# Generated by default/object.tt
package Paws::ElastiCache::UserGroupPendingChanges;
  use Moose;
  has UserIdsToAdd => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has UserIdsToRemove => (is => 'ro', isa => 'ArrayRef[Str|Undef]');

1;

### main pod documentation begin ###

=head1 NAME

Paws::ElastiCache::UserGroupPendingChanges

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ElastiCache::UserGroupPendingChanges object:

  $service_obj->Method(Att1 => { UserIdsToAdd => $value, ..., UserIdsToRemove => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ElastiCache::UserGroupPendingChanges object:

  $result = $service_obj->Method(...);
  $result->Att1->UserIdsToAdd

=head1 DESCRIPTION

Returns the updates being applied to the user group.

=head1 ATTRIBUTES


=head2 UserIdsToAdd => ArrayRef[Str|Undef]

The list of user IDs to add.


=head2 UserIdsToRemove => ArrayRef[Str|Undef]

The list of user IDs to remove.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ElastiCache>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

