/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.handler;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.server.JsonParametersAware;
import org.openqa.selenium.remote.server.Session;
import org.openqa.selenium.remote.server.handler.WebDriverHandler;

public class SetScriptTimeout
extends WebDriverHandler<Void>
implements JsonParametersAware {
    private volatile long millis;

    public SetScriptTimeout(Session session) {
        super(session);
    }

    @Override
    public void setJsonParameters(Map<String, Object> allParameters) throws Exception {
        try {
            this.millis = ((Number)allParameters.get("ms")).longValue();
        }
        catch (ClassCastException ex) {
            throw new WebDriverException("Illegal (non-numeric) timeout value passed: " + allParameters.get("ms"), ex);
        }
    }

    @Override
    public Void call() throws Exception {
        this.getDriver().manage().timeouts().setScriptTimeout(this.millis, TimeUnit.MILLISECONDS);
        return null;
    }

    public String toString() {
        return String.format("[set script timeout: %s]", this.millis);
    }
}

