/*
 * Unicode-Precis-Preparation
 *
 * Copyright (C) 2015 by Hatuka*nezumi - IKEDA Soji
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the same terms as Perl. For more details, see the full text of
 * the licenses at <http://dev.perl.org/licenses/>.
 *
 * This program is distributed in the hope that it will be
 * useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 */

#include <assert.h>
#include "precis_preparation.h"

/* Lines below are automatically generated.  Don't edit them manually. */
#define PROP_BLKWIDTH (6)
#define AGE_BLKWIDTH (5)
#define XPROP_BLKWIDTH (7)

#define JT_T (0x80)
#define JT_R (0x40)
#define JT_L (0x20)
#define JT_D (JT_R | JT_L)
#define JT_MASK (JT_T | JT_R | JT_L)

typedef enum {
    CCC_VIRAMA = 1,
    CH_Arabic_Indic_digits,
    CH_extended_Arabic_Indic_digits,
    CH_GERESH,
    CH_GERSHAYIM,
    CH_KERAIA,
    CH_NAKAGURO,
    CH_MIDDLEDOT,
    CH_SMALLL,
    CH_ZWJ,
    CH_ZWNJ,
    SC_Greek,
    SC_Han,
    SC_Hebrew,
    SC_Hiragana,
    SC_Katakana
} xprop_t;


/* Lines below are automatically generated. Don't edit them manually. */
static U16 precis_prop_index[] = {
    0, 33, 96, 160, 216, 279, 343, 403, 343, 343, 359, 465, 343, 527, 591,
    639, 343, 343, 701, 343, 717, 766, 823, 885, 949, 1013, 343, 1070,
    1134, 1187, 1201, 1265, 1329, 1393, 1425, 1487, 343, 1527, 1587, 1647,
    1710, 1772, 1835, 1895, 1958, 2018, 2080, 2142, 2206, 2267, 2331, 2391,
    2454, 2515, 2579, 2643, 2706, 2770, 2833, 2897, 2961, 3023, 3086, 3148,
    343, 3212, 3246, 3304, 3368, 3368, 3368, 3368, 343, 3432, 3487, 3549,
    3596, 3633, 3697, 3729, 32, 343, 343, 343, 343, 343, 343, 343, 343,
    3231, 3793, 3825, 3889, 3953, 4017, 4071, 4135, 4167, 4231, 4279, 4343,
    4407, 4471, 4525, 4589, 4622, 4685, 4748, 343, 4812, 343, 4876, 4940,
    5004, 5068, 5132, 5196, 5256, 5313, 5377, 343, 343, 5436, 343, 5478,
    5536, 5600, 5662, 5726, 5773, 5825, 5888, 5952, 5988, 6049, 6065, 6065,
    6065, 6065, 6065, 6065, 6065, 6065, 6066, 6090, 6154, 6065, 6065, 6065,
    6065, 6065, 6065, 6065, 6065, 6065, 6065, 6065, 6065, 6065, 6065, 6065,
    6065, 6065, 6065, 6065, 6065, 6065, 6065, 6065, 6065, 6065, 6065, 6065,
    6186, 6216, 6277, 718, 6341, 343, 6403, 6467, 6515, 6578, 6610, 5955,
    6674, 6738, 6077, 6065, 6065, 6065, 6780, 6844, 6908, 6949, 6982, 7046,
    7095, 7144, 7208, 7272, 6065, 6065, 6066, 6065, 6065, 6065, 6065, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 4279, 6065, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 7336, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 7400, 7457, 343, 343, 343, 343, 7506, 7570, 6373, 7633, 7697, 294,
    7720, 7776, 7834, 7898, 343, 7962, 3230, 8026, 343, 8090, 8154, 8218,
    343, 8279, 8342, 8390, 343, 8438, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 8502,
    8559, 3368, 3368, 3368, 3368, 3368, 3368, 3368, 3368, 3368, 3368, 3368,
    3368, 3368, 3368, 3368, 3368, 3368, 3368, 3368, 3368, 3368, 3368, 3368,
    3368, 3368, 3368, 3368, 3368, 3368, 3368, 3368, 3368, 3368, 3368, 3368,
    3368, 3368, 3368, 3368, 3368, 3368, 3368, 3368, 3368, 3368, 3368, 3368,
    3368, 3368, 3368, 3368, 3368, 3368, 3368, 3368, 3368, 3368, 3368, 3368,
    3368, 3368, 3368, 3368, 3368, 3368, 3368, 3368, 3368, 3368, 3368, 3368,
    3368, 3368, 3368, 3368, 3368, 3368, 3368, 3368, 3368, 3368, 3368, 3368,
    3368, 3368, 3368, 3368, 3368, 3368, 3368, 3368, 3368, 3368, 3368, 3368,
    3368, 3368, 3368, 3368, 3368, 3368, 3368, 3368, 3368, 3368, 3368, 3368,
    3368, 3368, 3368, 3368, 3368, 3368, 3368, 3368, 3368, 3368, 3368, 3368,
    3368, 3368, 3368, 3368, 3368, 3368, 3368, 3368, 3368, 3368, 3368, 3368,
    3368, 6065, 6065, 6065, 6065, 8623, 6192, 6065, 8665, 8729, 8793, 6065,
    8855, 6065, 6065, 6065, 6065, 6065, 6170, 8903, 8959, 9023, 9071, 6065,
    9125, 6064, 6065, 9189, 9252, 9316, 9379, 343, 9443, 9507, 6065, 9562,
    9610, 4748, 4748, 9674, 9721, 9785, 9848, 9912, 9972, 343, 343, 10036,
    10084, 4183, 10108, 4748, 4748, 343, 343, 343, 343, 8154, 10172, 4748,
    4748, 10236, 10299, 10363, 10411, 10475, 4748, 10539, 8903, 10601,
    10665, 10697, 10761, 10825, 10889, 10953, 4748, 343, 5068, 1200, 11017,
    4748, 4748, 4748, 4748, 4748, 11081, 4748, 4748, 4748, 4748, 4748,
    4748, 343, 11145, 11208, 11270, 712, 11334, 343, 11398, 11462, 4748,
    11526, 11574, 11638, 11698, 4748, 4748, 343, 11762, 343, 11826, 4748,
    4748, 11890, 11953, 343, 12017, 4167, 12081, 12145, 4748, 4748, 4748,
    4748, 4748, 9411, 12209, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    12272, 4748, 4748, 4748, 4748, 12336, 12399, 12449, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 12513,
    4748, 6065, 12577, 343, 343, 343, 12641, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 12705, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 12745, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 343, 343, 343, 343, 343, 343, 343,
    343, 12272, 12809, 4748, 12857, 352, 12921, 12736, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 343, 12982,
    13045, 13077, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    12707, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 1200,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 13141, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 343, 13205, 13257, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 6065, 6065, 6065, 6075, 6199, 13321, 13382, 6088, 6065,
    13444, 4748, 4748, 6065, 13508, 4748, 4748, 6065, 13572, 13607, 13668,
    13726, 13790, 6065, 6065, 6065, 6065, 6200, 6065, 6065, 6065, 6065,
    13842, 6065, 6065, 6065, 6065, 6065, 6065, 6065, 6065, 13906, 13965,
    14025, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    14089, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 343, 343, 343,
    14153, 343, 14217, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 14281,
    14343, 14407, 14467, 4748, 4748, 4748, 4748, 14531, 6065, 14579, 14627,
    14691, 14531, 6084, 6700, 14752, 14803, 4748, 4748, 6065, 6065, 6065,
    6065, 6065, 6065, 6065, 6065, 6065, 6065, 6065, 6065, 6065, 6065, 6065,
    14867, 6065, 6077, 6065, 14931, 14995, 15051, 15107, 4748, 15155,
    15206, 15270, 4747, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 15288, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    12729, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 15352, 343, 343, 343,
    1168, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 12718, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 6065, 6065, 6065, 6065, 6065, 6065, 6065, 6065,
    15416, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    15288, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748, 4748,
    4748, 4748, 4748, 4748, 4748, 15288
};

/* Lines below are automatically generated. Don't edit them manually. */
static U8 precis_prop_array[] = {
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_DISALLOWED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_CONTEXTO, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_DISALLOWED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_CONTEXTO,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_CONTEXTO, PRECIS_CONTEXTO, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_DISALLOWED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_DISALLOWED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_CONTEXTO,
    PRECIS_CONTEXTO, PRECIS_CONTEXTO, PRECIS_CONTEXTO, PRECIS_CONTEXTO,
    PRECIS_CONTEXTO, PRECIS_CONTEXTO, PRECIS_CONTEXTO, PRECIS_CONTEXTO,
    PRECIS_CONTEXTO, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_DISALLOWED, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_CONTEXTO, PRECIS_CONTEXTO, PRECIS_CONTEXTO, PRECIS_CONTEXTO,
    PRECIS_CONTEXTO, PRECIS_CONTEXTO, PRECIS_CONTEXTO, PRECIS_CONTEXTO,
    PRECIS_CONTEXTO, PRECIS_CONTEXTO, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_DISALLOWED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_DISALLOWED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_DISALLOWED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_DISALLOWED, PRECIS_CONTEXTJ, PRECIS_CONTEXTJ, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_UNASSIGNED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_ID_DIS,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_DISALLOWED,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_CONTEXTO, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_DISALLOWED,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_DISALLOWED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_DISALLOWED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_DISALLOWED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED
};

static U8 precis_prop_lookup(U32 cp)
{
    if ((cp & 0x00FFFE) == 0x00FFFE
	|| cp == 0x0E0001 || (0x0E0020 <= cp && cp <= 0x0E007F)
	|| (0x0E0100 <= cp && cp <= 0x0E01EF)
	|| (0x0F0000 <= cp && cp <= 0x0FFFFD)
	|| (0x100000 <= cp && cp <= 0x10FFFD))
	return PRECIS_DISALLOWED;
    else if (0x040000 <= cp)
	return PRECIS_UNASSIGNED;

    return precis_prop_array[precis_prop_index[cp >> PROP_BLKWIDTH] +
			     (cp & ((1 << PROP_BLKWIDTH) - 1))
	];
}

/* Lines below are automatically generated. Don't edit them manually. */
static U16 precis_age_index[] = {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 36, 68, 98, 0, 0, 121,
    1, 143, 0, 0, 175, 207, 0, 0, 239, 269, 301, 0, 317, 0, 347, 0, 374,
    394, 426, 454, 0, 0, 476, 506, 534, 0, 566, 598, 630, 662, 0, 678, 710,
    728, 760, 779, 800, 818, 850, 865, 897, 902, 934, 952, 984, 0, 0, 1016,
    1046, 1075, 1107, 1113, 1141, 1165, 1197, 1200, 1230, 1245, 1276, 0,
    1291, 1287, 1311, 0, 0, 1342, 0, 1208, 1370, 1400, 0, 1424, 1447, 1473,
    1197, 1500, 1530, 1560, 1592, 1596, 0, 1626, 1657, 1680, 1710, 1742,
    1774, 1800, 1832, 1864, 0, 0, 0, 0, 0, 0, 1885, 0, 1917, 1917, 1941,
    1963, 1983, 2008, 2038, 0, 850, 2070, 2102, 2128, 2134, 0, 2166, 2180,
    0, 0, 2212, 0, 0, 2235, 0, 2243, 2275, 850, 2300, 850, 2332, 2292,
    2363, 2387, 2404, 850, 2428, 2459, 2491, 850, 850, 2523, 2555, 850,
    850, 850, 850, 850, 850, 850, 850, 850, 850, 850, 850, 850, 850, 850,
    850, 850, 850, 2564, 2596, 850, 850, 2628, 2660, 2692, 2695, 2727, 850,
    850, 2759, 2791, 2823, 850, 850, 2855, 850, 2887, 934, 2903, 2935,
    2967, 2999, 3017, 3049, 3071, 3093, 3125, 3157, 934, 935, 937, 3189,
    3221, 0, 0, 897, 897, 3253, 900, 2128, 3285, 3317, 3329, 2128, 3361,
    3375, 2128, 3407, 0, 3439, 3455, 3125, 3125, 3125, 3145, 3049, 3049,
    3487, 3512, 0, 0, 0, 0, 3544, 0, 0, 3576, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    710, 3608, 3639, 3657, 3686, 0, 3717, 0, 3734, 3763, 0, 3792, 0, 0,
    3813, 0, 0, 0, 0, 0, 0, 0, 3845, 3877, 0, 0, 3882, 3911, 3938, 3955,
    3983, 0, 4014, 0, 0, 0, 0, 0, 4035, 0, 0, 0, 0, 4024, 0, 0, 4067, 4099,
    0, 0, 4125, 4157, 4189, 4214, 4244, 4276, 4300, 4320, 4351, 4373, 4397,
    4429, 4449, 850, 850, 850, 850, 850, 850, 850, 850, 3938, 3938, 3938,
    3938, 3938, 3938, 3938, 3938, 3938, 3938, 3938, 3938, 3938, 3938, 3938,
    3938, 4481, 4504, 4523, 4549, 4571, 4595, 4624, 4644, 3049, 4676, 4692,
    4724, 3049, 3049, 3049, 4756, 3049, 4782, 3049, 4808, 4840, 4872, 4872,
    2128, 4904, 4934, 4963, 0, 4995, 850, 850, 5022, 850, 850, 850, 850,
    850, 850, 5054, 5076, 0, 5104, 0, 0, 5135, 5166, 0, 5167, 0, 5199, 0,
    0, 0, 5231, 816, 5263, 1595, 0, 5295, 5327, 0, 4029, 5358, 0, 0, 0, 0,
    5374, 0, 0, 1594, 1198, 850, 850, 850, 850, 850, 850, 850, 850, 850,
    850, 850, 850, 850, 850, 850, 850, 850, 850, 850, 850, 850, 850, 850,
    850, 850, 850, 850, 850, 850, 850, 850, 850, 850, 850, 850, 850, 850,
    850, 850, 850, 850, 850, 850, 850, 850, 850, 850, 850, 850, 850, 850,
    850, 850, 850, 850, 850, 850, 850, 850, 850, 850, 850, 850, 850, 850,
    850, 850, 850, 850, 850, 850, 850, 850, 850, 850, 850, 850, 850, 850,
    850, 850, 850, 850, 850, 850, 850, 850, 850, 850, 850, 850, 850, 850,
    850, 850, 850, 850, 850, 850, 850, 850, 850, 850, 850, 850, 850, 850,
    850, 850, 850, 850, 850, 850, 850, 850, 850, 850, 850, 850, 850, 850,
    850, 850, 850, 850, 850, 850, 850, 850, 850, 850, 850, 850, 850, 850,
    850, 850, 850, 850, 850, 850, 850, 850, 850, 850, 850, 850, 850, 850,
    850, 850, 850, 850, 850, 850, 850, 850, 850, 850, 850, 850, 850, 850,
    850, 850, 850, 850, 850, 850, 850, 850, 850, 850, 850, 850, 850, 850,
    850, 850, 850, 850, 850, 850, 850, 850, 850, 850, 850, 850, 850, 850,
    850, 850, 850, 850, 850, 850, 850, 850, 850, 850, 850, 850, 850, 850,
    5054, 3125, 3125, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5401, 5429, 0, 850, 850, 850, 850,
    850, 850, 850, 850, 850, 850, 850, 850, 850, 850, 850, 850, 850, 850,
    850, 850, 850, 850, 850, 850, 850, 850, 850, 850, 850, 850, 850, 850,
    850, 850, 850, 850, 1784, 5461, 5492, 934, 2128, 2128, 2128, 2128,
    2128, 2128, 2128, 2128, 2128, 5524, 2128, 5556, 5584, 934, 934, 5616,
    5648, 5673, 2128, 2128, 5692, 5724, 0, 5748, 3049, 5780, 897, 5812,
    2128, 2128, 5844, 5876, 2128, 2128, 5908, 5940, 934, 934, 5972, 6004,
    2128, 6036, 6068, 6100, 934, 934, 6132, 6164, 6195, 6227, 6243, 6275,
    6291, 6291, 934, 6323, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917,
    1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917,
    1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917,
    1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917,
    1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917,
    1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917,
    1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917,
    1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917,
    1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917,
    1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917,
    1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917,
    1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917,
    1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917,
    1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917,
    1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917,
    1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917,
    1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917,
    1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917,
    1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917,
    1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917,
    1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917,
    1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917,
    1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917,
    1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917,
    1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917,
    1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917,
    1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917,
    1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917,
    1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917,
    1917, 1917, 1917, 1917, 1917, 6355, 6380, 6391, 1917, 1917, 1917, 1917,
    1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917,
    1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917,
    1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917,
    1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917,
    1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917, 1917,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6419, 3938, 6440,
    3049, 3049, 2491, 0, 6472, 0, 0, 0, 0, 6502, 6532, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 6548, 6564, 6596, 6624, 6651, 5179, 0, 0, 0, 0,
    0, 0, 5167, 5166, 0, 0, 0, 6660, 6692, 6697, 6728, 0, 3125, 3125, 3125,
    6760, 6792, 6804, 3049, 3049, 6836, 1197, 6864, 6880, 0, 0, 0, 0, 6881,
    2128, 6893, 6925, 6957, 6989, 7010, 7026, 7058, 3049, 7090, 0, 7122,
    7148, 7166, 3125, 7180, 7200, 7216, 7240, 6243, 7272, 6243, 7300, 0, 0,
    0, 0, 6243, 6243, 6243, 6243, 6243, 6243, 6243, 6243, 6243, 7332, 7333,
    7347, 0, 0, 0, 0, 7379, 7389, 7421, 6243, 6004, 7453, 0, 7485, 7517,
    7549, 0, 0, 7581, 7589, 7621, 6291, 7653, 7678, 7709, 934, 6243, 0,
    6243, 7741, 934, 5947, 944, 7773, 7805, 7834, 0, 0, 934, 934, 7866, 0,
    6291, 7898, 6291, 7930, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 935, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 3317, 3317, 7962, 7980, 934, 934, 8012,
    8035, 7581, 8067, 8095, 7332, 7581, 7581, 8127, 8159, 8191, 8210, 0, 0,
    8242, 8273, 6243, 8294, 8326, 8349, 8377, 8406, 0, 0, 0, 0, 8438, 8438,
    8444, 0, 6243, 6243, 8476, 0, 0, 0, 0, 0, 6243, 4571, 8508, 0, 6243,
    6243, 8540, 8572, 7581, 8604, 8618, 0, 8650, 8679, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 6243, 6243, 8711, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    6243, 8742, 0, 0, 0, 0, 0, 0, 0, 0, 8774, 8784, 8810, 8829, 8845, 8869,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 897, 897, 897, 897, 897, 897, 897, 897, 897, 897, 897, 897, 897,
    897, 897, 897, 897, 897, 897, 897, 897, 897, 897, 897, 897, 897, 897,
    8901, 8916, 0, 0, 0, 897, 897, 897, 8948, 6291, 6291, 6291, 6291, 6291,
    6291, 8980, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 934, 934, 934, 934,
    934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934,
    934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934,
    934, 9012, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6291, 6291, 6291, 6291, 6291, 6291, 6291,
    6291, 6291, 6291, 6291, 6291, 6291, 6291, 6291, 6291, 6291, 6291, 9044,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 3317, 3317, 3317, 3317, 3317, 3317, 3317, 3317, 3317,
    3317, 3317, 3317, 3317, 3317, 3317, 3317, 3317, 3324, 6004, 9076, 0, 0,
    7316, 9108, 6243, 6243, 9124, 9148, 7339, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7581, 7581, 9180,
    7582, 8589, 0, 0, 9212, 8438, 8438, 8438, 8438, 8438, 8438, 8438, 8438,
    8438, 8438, 8438, 8438, 8438, 8438, 8438, 8438, 8438, 8438, 8438, 8438,
    8438, 8438, 8438, 8438, 8438, 8438, 8438, 8438, 8438, 8438, 8438, 8438,
    8438, 8438, 8438, 8438, 8438, 8438, 8438, 8438, 8438, 8438, 8438, 8438,
    8438, 8438, 8438, 8438, 8438, 8438, 8438, 8438, 8438, 8438, 8438, 8438,
    8438, 8438, 8438, 8438, 8438, 8438, 8438, 8438, 8438, 8438, 8438, 8438,
    8438, 8438, 8438, 8438, 8438, 8438, 8438, 8438, 8438, 8438, 8438, 8438,
    8438, 8438, 8438, 8438, 8438, 8438, 8438, 8438, 8438, 8438, 8438, 8438,
    8438, 8438, 8438, 8438, 8438, 8438, 8438, 8438, 8438, 8438, 8438, 8438,
    8438, 8438, 8438, 8438, 8438, 8438, 8438, 8438, 8438, 8438, 8438, 8438,
    8438, 8438, 8438, 8438, 8438, 8438, 8438, 8438, 8438, 8438, 8438, 8438,
    8438, 8438, 8438, 8438, 8438, 8438, 8438, 8438, 8438, 8438, 8438, 8438,
    8438, 8438, 8438, 8438, 8438, 8438, 8438, 8438, 8438, 8438, 8438, 8438,
    8438, 8438, 8438, 8438, 8438, 8438, 8438, 8438, 8438, 8438, 8438, 8438,
    8438, 8438, 8438, 8438, 8438, 8438, 8438, 8438, 8438, 8438, 8438, 8438,
    8438, 8438, 8438, 8438, 8438, 8438, 8438, 8438, 8438, 8438, 8438, 8438,
    8438, 8438, 8438, 8572, 8438, 8438, 8438, 8438, 8438, 8438, 8438, 8438,
    8438, 8438, 8438, 8438, 8438, 8438, 8438, 8438, 8438, 8438, 8438, 8438,
    8438, 8438, 8438, 9244, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6532, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6243, 6243, 6243,
    9276, 9296, 9324, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 9356, 7122, 9388, 7122, 7122, 7122, 7122, 9398, 9428,
    3049, 3049, 6466, 0, 0, 0, 0, 0, 3125, 3125, 9460, 9492, 0, 0, 0, 0,
    7122, 7122, 9524, 7122, 9546, 9578, 9609, 7122, 9635, 9615, 9665, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 9693, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 9715, 7122, 6291, 6291, 6291, 6291,
    6291, 6291, 6291, 6291, 6291, 6291, 6291, 6291, 6291, 6291, 6291, 6291,
    6291, 6291, 6291, 6291, 9747, 9773, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 9805, 9835, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    6243, 6243, 6243, 6243, 6243, 6243, 9867, 0, 8438, 8438, 9899, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9931, 9963, 9993, 10023, 10055, 10086, 0,
    10114, 0, 0, 0, 0, 0, 0, 0, 0, 2128, 10146, 2128, 2128, 6890, 10178,
    10210, 7333, 10242, 10259, 10291, 10323, 10355, 8572, 0, 10387, 10419,
    10435, 10467, 0, 0, 0, 0, 0, 3317, 10499, 3317, 10522, 10554, 3317,
    10586, 10618, 3317, 10650, 10680, 3317, 3317, 3317, 3317, 10688, 3317,
    10720, 10752, 10776, 6243, 10798, 6243, 10803, 10835, 10867, 10898,
    6243, 3317, 3317, 10930, 10962, 3317, 3317, 3317, 10994, 6243, 6243,
    7334, 0, 11026, 6243, 8476, 6243, 7272, 7341, 0, 0, 11058, 11090,
    11109, 0, 11141, 0, 11173, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 11175, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 11207, 0, 934, 934,
    934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934,
    934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934,
    934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934,
    934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934,
    934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934,
    934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934,
    934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934,
    934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934,
    934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934,
    934, 6398, 3317, 3317, 3317, 3317, 3317, 3317, 3319, 6291, 6291, 6291,
    6291, 6291, 6291, 6291, 6291, 6291, 6291, 6291, 6291, 6291, 6291, 6291,
    6291, 6291, 6291, 6291, 6291, 6291, 6291, 6291, 6291, 6291, 6291, 6291,
    6291, 6291, 6291, 6291, 6291, 6291, 6291, 6291, 6291, 6291, 6291, 6291,
    6291, 6291, 6291, 6291, 6291, 6291, 6291, 6291, 6291, 6291, 6291, 6291,
    6291, 6291, 6291, 6291, 6291, 6291, 6291, 6291, 6291, 6291, 6291, 6291,
    6291, 6291, 6291, 6291, 6291, 6291, 6291, 6291, 6291, 6291, 6291, 6291,
    6291, 6291, 6291, 6291, 6291, 6291, 6291, 6291, 6291, 6291, 6291, 6291,
    6291, 6291, 6291, 6291, 6291, 6291, 6291, 6291, 6291, 6291, 6291, 6291,
    6291, 6291, 6291, 6291, 6291, 6291, 6291, 6291, 6291, 6291, 6291, 6291,
    6291, 6291, 6291, 6291, 6291, 6291, 6291, 6291, 6291, 6291, 6291, 6291,
    6291, 6291, 6291, 6291, 6291, 6291, 6291, 6291, 6291, 6291, 6291, 6291,
    6291, 6291, 6291, 6291, 6291, 6291, 6291, 6291, 6291, 6291, 6291, 6291,
    6291, 6291, 6291, 6291, 6291, 6291, 6291, 6291, 6291, 6291, 6291, 6291,
    6291, 6291, 6291, 6291, 6291, 6291, 6291, 6291, 6291, 6291, 6291, 6291,
    6291, 6291, 6291, 6291, 6291, 6291, 6291, 6291, 6291, 11239, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7122, 7122, 7122, 7122,
    7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122, 7122,
    11271, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 11175, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11175
};

/* Lines below are automatically generated. Don't edit them manually. */
static U8 precis_age_array[] = {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0x30, 0x30, 0x30, 0x30, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x32, 0x40, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x40, 0x40, 0x40, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,
    0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50,
    0x50, 0x50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x40, 0x40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0x30, 0x30, 0x30, 0x30, 0x30, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0, 0,
    0, 0, 0, 0, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x32,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x41, 0x41, 0x41, 0x41,
    0x41, 0x40, 0x40, 0x40, 0, 0, 0x30, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32,
    0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x51, 0x51, 0x51, 0x51, 0, 0,
    0x51, 0x51, 0, 0, 0, 0x50, 0x50, 0x50, 0, 0x70, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0x51, 0, 0, 0, 0, 0, 0, 0, 0x30, 0x32, 0x32, 0,
    0x30, 0, 0x30, 0, 0x30, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0x31, 0x31, 0x32, 0x40, 0x40, 0x40, 0x40, 0x40, 0x41, 0x41, 0x41,
    0x41, 0x30, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x30, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x30, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0x30, 0, 0, 0, 0, 0, 0, 0, 0x51, 0x30, 0x30, 0x32, 0x32, 0x30,
    0x30, 0x30, 0x30, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x32,
    0x32, 0, 0, 0x32, 0x32, 0, 0, 0x32, 0x32, 0x50, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0x30, 0x30, 0, 0, 0, 0, 0, 0, 0, 0, 0x41, 0x41,
    0, 0, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x32, 0x32, 0x32, 0x32, 0x32,
    0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x50,
    0x50, 0x50, 0x50, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51,
    0x51, 0x51, 0x51, 0x52, 0x52, 0x60, 0x60, 0x70, 0x70, 0x70, 0x70, 0x70,
    0x70, 0x70, 0x70, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x30,
    0, 0, 0x70, 0x70, 0x61, 0, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x41, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0x50, 0, 0, 0, 0, 0, 0x20, 0x41, 0x41, 0x41, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x40,
    0x40, 0x40, 0x40, 0x61, 0x70, 0x51, 0x51, 0x51, 0x51, 0x51, 0x41, 0,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x51, 0x51, 0x51,
    0x51, 0x51, 0, 0x63, 0, 0x41, 0, 0x60, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x51, 0x51, 0x51, 0x51,
    0x51, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x30,
    0x30, 0x30, 0x40, 0x40, 0x40, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x60,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x32, 0x32, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x30, 0x30, 0, 0,
    0, 0, 0, 0x30, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x30, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x40, 0x40, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0x30, 0x30, 0x30, 0x30, 0x30, 0x40, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x40, 0x40, 0x40, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0, 0,
    0x40, 0x40, 0x40, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,
    0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x51, 0x51, 0x51, 0x51, 0x51,
    0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51,
    0x51, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x32, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50,
    0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50,
    0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50,
    0x50, 0, 0, 0, 0, 0, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52,
    0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52,
    0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52,
    0, 0, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52,
    0x52, 0x52, 0x52, 0x52, 0, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
    0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
    0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0, 0, 0x60, 0,
    0x61, 0x70, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61,
    0x61, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x80, 0x80, 0, 0x90, 0x90,
    0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90,
    0x90, 0x90, 0x90, 0x90, 0x80, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61,
    0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61,
    0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x70, 0x52, 0, 0, 0,
    0x40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0x60, 0x60, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0x52, 0x60, 0, 0, 0, 0, 0, 0x52, 0x60, 0x60, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0x51, 0x51, 0x60, 0x60, 0x60, 0x60, 0x60, 0x70,
    0x52, 0x52, 0x50, 0x50, 0x41, 0x50, 0x50, 0x70, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0x40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x41, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x52, 0,
    0, 0, 0, 0x40, 0, 0x40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x51, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0x40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0x40, 0x40, 0x40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x61, 0x40, 0,
    0, 0, 0, 0, 0, 0, 0x80, 0, 0, 0, 0, 0, 0, 0x51, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x51, 0x51, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x40, 0x60, 0x60, 0x60, 0x60, 0x60,
    0x60, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0x41, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x51, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x41, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x70, 0, 0, 0, 0, 0, 0, 0, 0,
    0x51, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0x51, 0x51, 0x80, 0, 0, 0, 0, 0, 0x51, 0x51, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x51, 0x51, 0x51, 0x51, 0x51,
    0x51, 0x51, 0x51, 0x90, 0x70, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x40, 0x40, 0, 0, 0x50,
    0x50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x50, 0x50, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0x70, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x60, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x60, 0, 0, 0x51, 0, 0, 0, 0, 0x51, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0x60, 0x90, 0, 0, 0, 0, 0x90, 0x90, 0x90, 0, 0x90,
    0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x80, 0, 0, 0x51, 0x51, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x90, 0x90,
    0x90, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0, 0, 0x30, 0x30, 0,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0, 0, 0, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0,
    0x30, 0, 0, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0, 0, 0, 0x30, 0,
    0, 0, 0, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0, 0x30, 0, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0, 0, 0, 0, 0, 0, 0x70, 0x70, 0x70,
    0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0, 0, 0x30, 0x30, 0x30, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0x61, 0x61, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x30, 0x51, 0x51, 0, 0, 0, 0, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x60, 0x60, 0x60, 0x60,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x30, 0x20, 0, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x30,
    0x30, 0x30, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x30, 0x20, 0x30,
    0x30, 0x30, 0, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0, 0x51, 0x30, 0x41, 0x41, 0x51, 0x51, 0x51,
    0x52, 0x52, 0x52, 0x52, 0x60, 0x60, 0, 0, 0, 0, 0, 0x30, 0x30, 0x51,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x51, 0x30, 0x30, 0x51, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x51, 0x51, 0x51, 0x30, 0x30, 0x30, 0x30, 0x51,
    0x51, 0x51, 0x51, 0x51, 0x51, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x51, 0x51, 0x51, 0x51, 0x51,
    0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51,
    0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51,
    0x51, 0x51, 0x51, 0x52, 0x52, 0x52, 0x52, 0x51, 0x51, 0, 0, 0, 0, 0, 0,
    0, 0x61, 0, 0, 0, 0, 0, 0x61, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0x32, 0x32, 0x41, 0x41, 0, 0x41, 0x61, 0x61,
    0x61, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0x52, 0x52, 0x52, 0x52, 0x52, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x52, 0x52, 0x52, 0x52,
    0x52, 0x52, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x41, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x41, 0x30,
    0, 0x30, 0x30, 0x30, 0x30, 0, 0, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x30, 0, 0x30, 0, 0x30, 0x30, 0x30, 0x30, 0, 0, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x41, 0x30, 0, 0x30, 0x30, 0x30, 0x30, 0, 0, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0, 0x30, 0x30, 0x30, 0x30, 0, 0, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x41, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x41, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x41, 0x30, 0,
    0x30, 0x30, 0x30, 0x30, 0, 0, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x41, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0, 0, 0x60, 0x60, 0x41,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0, 0, 0, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,
    0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,
    0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0, 0, 0, 0, 0, 0, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x80, 0, 0, 0x80, 0x80,
    0x80, 0x80, 0x80, 0x80, 0, 0, 0x52, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0, 0, 0, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x70, 0x70,
    0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0, 0, 0, 0, 0, 0, 0, 0x32, 0x32,
    0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0,
    0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32,
    0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32,
    0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0, 0x32, 0x32, 0x32, 0, 0x32,
    0x32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x40, 0, 0, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0, 0, 0, 0, 0, 0, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0, 0, 0, 0, 0, 0, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0, 0, 0, 0, 0, 0, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0, 0, 0, 0, 0, 0,
    0, 0, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x51,
    0, 0, 0, 0, 0, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52,
    0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52,
    0x52, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x70,
    0x70, 0, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0, 0, 0, 0, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0, 0, 0, 0, 0x40, 0, 0, 0, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0, 0, 0x40, 0x40, 0x40, 0x40, 0x40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,
    0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,
    0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x52, 0x52, 0, 0,
    0, 0, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,
    0x41, 0x41, 0x41, 0x41, 0x41, 0, 0, 0, 0, 0, 0, 0x41, 0x41, 0x41, 0x41,
    0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x52, 0, 0, 0, 0x41, 0x41, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x41, 0x41, 0x41, 0x41, 0x41,
    0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,
    0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0, 0,
    0x41, 0x41, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52,
    0, 0, 0, 0, 0, 0, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52,
    0x52, 0, 0, 0, 0, 0, 0, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52,
    0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0, 0, 0x70, 0x70, 0x70, 0x70, 0x70,
    0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0, 0x50,
    0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0, 0,
    0, 0, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50,
    0x50, 0x50, 0x50, 0x50, 0x50, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51,
    0x51, 0x51, 0x51, 0x51, 0x61, 0x61, 0x61, 0x51, 0x51, 0x51, 0x51, 0x51,
    0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x61, 0x61, 0x61, 0x61, 0x61,
    0x61, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
    0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
    0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0, 0, 0, 0, 0, 0,
    0, 0, 0x60, 0x60, 0x60, 0x60, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51,
    0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51,
    0x51, 0x51, 0x51, 0x51, 0x51, 0, 0, 0, 0x51, 0x51, 0x51, 0x51, 0x51,
    0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51,
    0x51, 0x51, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x61,
    0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0, 0, 0, 0, 0, 0, 0, 0, 0x52,
    0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52,
    0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x61, 0x61, 0x61, 0x61, 0, 0x70,
    0x70, 0, 0, 0, 0, 0, 0, 0x41, 0x41, 0x41, 0x41, 0x50, 0x50, 0x50, 0x50,
    0x50, 0x50, 0x50, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51,
    0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51,
    0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70,
    0x70, 0x70, 0x70, 0, 0, 0, 0, 0, 0x90, 0x60, 0x52, 0x50, 0x50, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0x20, 0x51, 0x51, 0x51, 0x51, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51,
    0, 0, 0, 0, 0, 0, 0, 0x32, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x32,
    0x32, 0x32, 0x32, 0x32, 0x40, 0x40, 0x41, 0x41, 0x32, 0x41, 0x41, 0x41,
    0x41, 0x41, 0x41, 0x41, 0x32, 0x32, 0x32, 0x32, 0x51, 0, 0x63, 0x63,
    0x63, 0x63, 0, 0, 0, 0, 0, 0, 0, 0x32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0x41, 0x41, 0x41, 0x41, 0x41, 0x60, 0x60, 0x60, 0x60,
    0x60, 0x60, 0x60, 0x60, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x20, 0x21,
    0x30, 0x30, 0x30, 0x32, 0x32, 0x41, 0x41, 0x41, 0x41, 0x52, 0x52, 0x52,
    0x60, 0x62, 0x70, 0x70, 0x70, 0x80, 0, 0, 0x30, 0x30, 0x32, 0x32, 0x32,
    0x32, 0x32, 0x32, 0x32, 0x41, 0x50, 0x50, 0x50, 0x50, 0x51, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x30,
    0x30, 0x40, 0x41, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32,
    0x32, 0x32, 0x32, 0x41, 0x50, 0x50, 0x51, 0x52, 0x52, 0x52, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0x30, 0x50, 0x51, 0x51, 0x51, 0x51, 0x52,
    0x80, 0x80, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x32, 0x32, 0x32,
    0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32,
    0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0, 0x30, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0x30, 0x32, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32,
    0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32,
    0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32,
    0x32, 0x32, 0x40, 0x40, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,
    0x41, 0x41, 0x41, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x52,
    0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x70,
    0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x90, 0x90, 0x90, 0x90, 0, 0, 0, 0,
    0, 0x30, 0x30, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32,
    0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x40,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x40, 0x40,
    0x32, 0x32, 0x41, 0x30, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0x30, 0x30, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32,
    0x32, 0x32, 0x41, 0x41, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32,
    0x32, 0x32, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x41, 0x41,
    0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x51, 0x52, 0x52,
    0x40, 0x40, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,
    0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x50, 0x51, 0x51, 0x51, 0x51, 0x51,
    0x51, 0x51, 0x51, 0x51, 0x51, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52,
    0x52, 0x52, 0x52, 0x60, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52,
    0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x60, 0x52, 0x60,
    0x60, 0x60, 0x60, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52,
    0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52,
    0x52, 0x52, 0x52, 0x70, 0, 0, 0, 0, 0x60, 0, 0, 0, 0, 0x60, 0x60, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x60, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x60, 0, 0x60,
    0, 0, 0, 0, 0x60, 0x60, 0x60, 0, 0x52, 0, 0, 0, 0, 0, 0, 0, 0x60, 0, 0,
    0, 0, 0, 0, 0, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32,
    0x32, 0x32, 0x32, 0x32, 0x32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0x60, 0x60, 0x60, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0x60, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x60,
    0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x50, 0x50, 0x50, 0x50, 0x61,
    0x51, 0x61, 0x60, 0x60, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32,
    0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x51, 0x51, 0x51, 0x51,
    0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32,
    0x32, 0x32, 0x32, 0x32, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,
    0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x51, 0x51, 0x51, 0x51, 0x51,
    0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51,
    0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x70,
    0x70, 0x70, 0x51, 0x51, 0x51, 0x51, 0x51, 0x52, 0x52, 0x52, 0x52, 0x52,
    0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70,
    0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0, 0, 0x70, 0x70, 0x70,
    0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70,
    0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0, 0, 0x70, 0x70, 0x70, 0x70,
    0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70,
    0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0, 0, 0,
    0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0, 0x70, 0x70,
    0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0x80, 0x80, 0x80, 0x80, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,
    0x41, 0x41, 0x41, 0x41, 0, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,
    0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,
    0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,
    0, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50,
    0x50, 0x50, 0x51, 0x51, 0x51, 0x52, 0x51, 0x51, 0x51, 0x50, 0x50, 0x50,
    0x50, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x52, 0x52, 0x41, 0x41, 0x41,
    0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x52, 0x52, 0x52, 0x52,
    0x52, 0x52, 0x52, 0x61, 0x61, 0, 0, 0, 0, 0, 0x41, 0x41, 0x41, 0x41,
    0x41, 0x41, 0x41, 0, 0x61, 0, 0, 0, 0, 0, 0x61, 0, 0, 0x41, 0x41, 0x41,
    0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,
    0x41, 0x61, 0x61, 0, 0, 0, 0, 0, 0, 0, 0x41, 0x60, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0x60, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,
    0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,
    0x41, 0x41, 0x41, 0x41, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x41, 0x41, 0x41,
    0x41, 0x41, 0x41, 0x41, 0, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0,
    0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0, 0x41, 0x41, 0x41, 0x41,
    0x41, 0x41, 0x41, 0, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,
    0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,
    0x41, 0x41, 0x41, 0x41, 0x51, 0x51, 0x51, 0x51, 0x41, 0x41, 0x51, 0x51,
    0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51,
    0x51, 0x51, 0x51, 0x52, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61,
    0x61, 0x61, 0x70, 0x70, 0x70, 0x70, 0x90, 0x90, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x30, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x30, 0x30, 0x30,
    0x32, 0x32, 0x32, 0x30, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0x32, 0x32, 0, 0, 0, 0, 0, 0, 0, 0, 0x32, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0x32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x51, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x60, 0x60, 0x60, 0, 0, 0, 0,
    0, 0x51, 0x51, 0x51, 0x51, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x32,
    0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32,
    0x32, 0x32, 0x32, 0, 0, 0, 0, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52,
    0x52, 0x52, 0x52, 0x52, 0x52, 0x40, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32,
    0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x40,
    0x40, 0x41, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x40, 0x40, 0x40, 0x40,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0x40, 0x40, 0x40, 0x40, 0, 0, 0, 0, 0, 0, 0x41, 0x41, 0x41, 0x41, 0x41,
    0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,
    0x41, 0x41, 0x41, 0x41, 0x41, 0x51, 0x51, 0x51, 0x51, 0x52, 0x52, 0x52,
    0x52, 0x52, 0x52, 0x52, 0x52, 0x61, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
    0x80, 0x80, 0x80, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x30, 0x30, 0x32, 0x32,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x32, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x32, 0x30, 0x30, 0x30, 0x32, 0x30, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52,
    0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x51, 0x51, 0x51, 0x51, 0x51,
    0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x60, 0x60, 0x51, 0x51, 0x51, 0x51, 0x51,
    0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51,
    0x51, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x51, 0x51, 0x51,
    0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51,
    0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x70, 0x70, 0x70,
    0x70, 0x70, 0x70, 0x80, 0x61, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52,
    0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52,
    0x52, 0x52, 0x52, 0x52, 0x52, 0, 0, 0, 0, 0, 0, 0, 0, 0x41, 0x41, 0x41,
    0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,
    0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x50, 0x50, 0x50, 0x50,
    0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51,
    0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51,
    0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x60, 0x60, 0x80, 0x60, 0x60, 0x61,
    0x61, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70,
    0x70, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x61,
    0x70, 0x70, 0x70, 0x90, 0, 0x70, 0x70, 0x80, 0x80, 0x80, 0x80, 0x80,
    0x80, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0x70, 0x61, 0x61, 0x60, 0x51, 0x51, 0x51, 0x51, 0x51, 0x41, 0x41,
    0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0, 0, 0, 0,
    0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0, 0, 0, 0,
    0, 0, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50,
    0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50,
    0x50, 0, 0, 0, 0, 0, 0, 0, 0, 0x51, 0x51, 0x51, 0x51, 0x51, 0x90, 0, 0,
    0, 0, 0, 0, 0, 0, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51,
    0x51, 0x51, 0x51, 0, 0, 0, 0, 0, 0, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52,
    0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52,
    0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x80, 0x80,
    0, 0, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51,
    0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0x51, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52,
    0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52,
    0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0, 0, 0, 0x52,
    0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52,
    0x52, 0, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52,
    0x52, 0, 0, 0, 0, 0x52, 0x52, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70,
    0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70,
    0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70,
    0, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51,
    0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51,
    0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0, 0, 0x51, 0x51, 0x51, 0x51,
    0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0, 0, 0x51, 0x51, 0x51, 0x51, 0x52,
    0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52,
    0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52,
    0x52, 0x52, 0x52, 0x70, 0x70, 0x70, 0x70, 0x52, 0x52, 0x52, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x52, 0x52,
    0x52, 0x52, 0x52, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61,
    0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61,
    0x61, 0x61, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x60, 0x60, 0x60, 0x60, 0x60,
    0x60, 0, 0, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0, 0, 0x60, 0x60, 0x60,
    0x60, 0x60, 0x60, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x60, 0x60, 0x60, 0x60,
    0x60, 0x60, 0x60, 0, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0, 0x70,
    0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70,
    0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70,
    0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x80, 0x80, 0x80, 0x80, 0x70,
    0x70, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
    0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
    0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
    0x80, 0x80, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52,
    0x52, 0x52, 0x52, 0x52, 0, 0, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52,
    0x52, 0x52, 0x52, 0, 0, 0, 0, 0, 0, 0x20, 0x20, 0x20, 0x20, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52,
    0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0, 0, 0, 0, 0x52, 0x52,
    0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52,
    0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52,
    0x52, 0x52, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x61, 0x61, 0x32,
    0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32,
    0x32, 0x32, 0x32, 0x52, 0x52, 0x52, 0, 0, 0x41, 0x41, 0x41, 0x41, 0x41,
    0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0x30, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
    0x60, 0x60, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31,
    0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0x32, 0x40, 0, 0, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32,
    0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x41, 0x41,
    0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0, 0, 0, 0, 0, 0, 0x51,
    0x51, 0x51, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x80, 0x80, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x32, 0x32, 0x40, 0x40, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0x30, 0x30, 0x30, 0x21, 0, 0, 0, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0, 0x40, 0x40, 0, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0, 0, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0, 0, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0, 0, 0, 0, 0, 0x40, 0x40, 0x40, 0, 0, 0, 0, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0, 0,
    0, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x41, 0x41,
    0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x70, 0x70, 0x90,
    0x90, 0, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51,
    0x51, 0x51, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x51, 0x51,
    0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51,
    0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51,
    0x51, 0x51, 0x51, 0x51, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70,
    0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70,
    0x70, 0x70, 0x70, 0x70, 0, 0, 0, 0, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31,
    0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31,
    0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31,
    0x31, 0x70, 0x31, 0x31, 0x31, 0x31, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31,
    0x31, 0x31, 0x31, 0x31, 0, 0, 0, 0, 0, 0x70, 0x70, 0x70, 0x70, 0x70,
    0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70,
    0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0, 0, 0, 0,
    0, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0, 0x40, 0x41, 0x41, 0x41,
    0x41, 0, 0, 0, 0, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,
    0x41, 0x41, 0x41, 0x41, 0x41, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x31, 0x31,
    0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31,
    0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31,
    0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x40, 0x40, 0x31, 0x31, 0x31, 0x31,
    0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31,
    0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0, 0, 0, 0, 0, 0, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90,
    0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90,
    0x90, 0, 0, 0, 0, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90,
    0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90,
    0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0, 0, 0, 0, 0x70, 0x70, 0x70,
    0x70, 0x70, 0x70, 0x70, 0x70, 0, 0, 0, 0, 0, 0, 0, 0, 0x70, 0x70, 0x70,
    0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70,
    0x70, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x70, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70,
    0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70,
    0x70, 0x70, 0x70, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0, 0, 0x40, 0,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0, 0x40,
    0x40, 0, 0, 0, 0x40, 0, 0, 0x40, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52,
    0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52,
    0x52, 0x52, 0x52, 0x52, 0, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52,
    0x52, 0x52, 0, 0, 0, 0, 0, 0, 0, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70,
    0x70, 0x70, 0x70, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x80,
    0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
    0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0, 0x80, 0x80, 0, 0, 0, 0, 0, 0x80,
    0x80, 0x80, 0x80, 0x80, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50,
    0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50,
    0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x52, 0x52, 0, 0, 0, 0x50, 0x51,
    0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51,
    0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51,
    0x51, 0, 0, 0, 0, 0, 0x51, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61,
    0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61,
    0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61,
    0x61, 0, 0, 0, 0, 0x80, 0x80, 0x61, 0x61, 0x80, 0x80, 0x80, 0x80, 0x80,
    0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0, 0,
    0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
    0x80, 0x80, 0x41, 0x41, 0x41, 0x41, 0, 0x41, 0x41, 0, 0, 0, 0, 0, 0x41,
    0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0, 0x41, 0x41, 0x41, 0, 0x41,
    0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,
    0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0, 0, 0, 0, 0x41, 0x41, 0x41,
    0, 0, 0, 0, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0, 0, 0, 0,
    0, 0, 0, 0, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0, 0,
    0, 0, 0, 0, 0, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0, 0, 0, 0,
    0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52,
    0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52,
    0, 0, 0, 0, 0, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x70,
    0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70,
    0x70, 0x70, 0x70, 0x70, 0x70, 0, 0, 0, 0, 0, 0, 0, 0x70, 0x70, 0x70,
    0x70, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70,
    0x70, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x52, 0x52, 0x52,
    0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
    0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
    0x80, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x80, 0x80, 0x80, 0x80,
    0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
    0x80, 0x80, 0x80, 0, 0, 0, 0, 0, 0, 0, 0x80, 0x80, 0x80, 0x80, 0x80,
    0x80, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
    0x60, 0x60, 0x60, 0, 0, 0, 0, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
    0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0x70, 0x52, 0x52, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61,
    0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0, 0, 0, 0, 0, 0, 0, 0x61,
    0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0, 0, 0, 0, 0, 0,
    0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61,
    0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0, 0x61, 0x61,
    0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70,
    0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61,
    0x61, 0x61, 0x61, 0x80, 0x80, 0x80, 0x80, 0x70, 0, 0, 0x61, 0x61, 0x61,
    0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x70, 0x80, 0x80, 0x80, 0x80,
    0x80, 0, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70,
    0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70,
    0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0, 0x70,
    0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70,
    0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70,
    0x70, 0x70, 0x70, 0x70, 0x70, 0x90, 0, 0x80, 0x80, 0x80, 0x80, 0x80,
    0x80, 0x80, 0, 0x80, 0, 0x80, 0x80, 0x80, 0x80, 0, 0x80, 0x80, 0x80,
    0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
    0, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0, 0, 0,
    0, 0, 0, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70,
    0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0, 0, 0, 0, 0, 0x70, 0x70, 0x70,
    0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0, 0, 0, 0, 0, 0, 0x80, 0x70,
    0x70, 0x70, 0, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0, 0,
    0x70, 0x70, 0, 0, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70,
    0x70, 0x70, 0x70, 0x70, 0, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0,
    0x70, 0x70, 0, 0x70, 0x70, 0x70, 0x70, 0x70, 0, 0, 0x70, 0x70, 0x70,
    0x70, 0x70, 0, 0, 0x70, 0x70, 0, 0, 0x70, 0x70, 0x70, 0, 0, 0x80, 0, 0,
    0, 0, 0, 0, 0x70, 0, 0, 0, 0, 0, 0x70, 0x70, 0x70, 0x70, 0, 0, 0x70,
    0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0, 0, 0, 0x70, 0x70, 0x70, 0x70,
    0x70, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x90, 0x90, 0x90, 0x90, 0x90,
    0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90,
    0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90,
    0x90, 0x90, 0x90, 0, 0x90, 0, 0x90, 0, 0, 0x70, 0x70, 0x70, 0x70, 0x70,
    0x70, 0x70, 0x70, 0, 0, 0, 0, 0, 0, 0, 0, 0x70, 0x70, 0x70, 0x70, 0x70,
    0x70, 0x70, 0x70, 0x70, 0x70, 0, 0, 0, 0, 0, 0, 0x70, 0x70, 0x70, 0x70,
    0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
    0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
    0x80, 0x80, 0, 0, 0x70, 0x70, 0x70, 0x70, 0x70, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0,
    0, 0, 0, 0, 0, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90,
    0x90, 0x90, 0x90, 0x90, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61,
    0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61,
    0x61, 0x61, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
    0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
    0x80, 0x80, 0x80, 0, 0, 0, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
    0x80, 0x80, 0x80, 0x80, 0x80, 0, 0, 0, 0, 0x80, 0x80, 0x80, 0x80, 0x80,
    0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x70,
    0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70,
    0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70,
    0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70,
    0x70, 0, 0, 0, 0, 0, 0, 0, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90,
    0x90, 0x90, 0, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90,
    0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90,
    0x90, 0x90, 0, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90,
    0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0, 0, 0, 0x90, 0x90,
    0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90,
    0x90, 0x90, 0, 0, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90,
    0x90, 0x90, 0x90, 0x90, 0x90, 0, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90,
    0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50,
    0x50, 0x50, 0x50, 0x50, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70,
    0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70,
    0x70, 0x70, 0x70, 0x70, 0x70, 0x80, 0, 0, 0, 0, 0, 0, 0x50, 0x50, 0x50,
    0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70,
    0, 0x50, 0x50, 0x50, 0x50, 0x70, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x80,
    0x80, 0x80, 0x80, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52,
    0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0, 0, 0, 0,
    0x70, 0x70, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x70, 0x70,
    0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70,
    0, 0, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0, 0x70,
    0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70,
    0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0, 0, 0, 0, 0, 0x70,
    0x70, 0x70, 0x61, 0x61, 0x61, 0x61, 0x61, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61,
    0x61, 0x61, 0x61, 0x61, 0x61, 0x90, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x90, 0x90,
    0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90,
    0x90, 0x90, 0x90, 0x90, 0x90, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0, 0,
    0, 0, 0, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70,
    0x70, 0x70, 0x70, 0, 0, 0, 0, 0, 0, 0, 0x70, 0x70, 0x70, 0x70, 0x70,
    0x70, 0x70, 0x70, 0x70, 0x70, 0, 0, 0x70, 0x70, 0x70, 0x70, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31,
    0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0, 0, 0x51,
    0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31,
    0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31,
    0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
    0x80, 0x80, 0x80, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x50, 0x50, 0x50, 0x50, 0x50,
    0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50,
    0x50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x31, 0x31, 0x31, 0x31,
    0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31,
    0x31, 0x31, 0x31, 0x31, 0x31, 0, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31,
    0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31,
    0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0,
    0x31, 0x31, 0, 0, 0x31, 0, 0, 0x31, 0x31, 0, 0, 0x31, 0x31, 0x31, 0x31,
    0, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31,
    0x31, 0, 0x31, 0, 0x31, 0x31, 0x31, 0x40, 0x31, 0x31, 0, 0x31, 0x31,
    0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31,
    0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31,
    0x31, 0, 0x31, 0x31, 0x31, 0x31, 0, 0, 0x31, 0x31, 0x31, 0x31, 0x31,
    0x31, 0x31, 0x31, 0, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0, 0x31,
    0x31, 0x31, 0x31, 0x31, 0, 0x31, 0, 0, 0, 0x31, 0x31, 0x31, 0x31, 0x31,
    0x31, 0x31, 0, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31,
    0x31, 0x31, 0x31, 0x31, 0x31, 0x41, 0x41, 0, 0, 0x31, 0x31, 0x31, 0x31,
    0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31,
    0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x50, 0x50, 0, 0, 0x31,
    0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31,
    0x31, 0x31, 0x31, 0x31, 0x31, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
    0x80, 0x80, 0x80, 0x80, 0x80, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
    0x80, 0x80, 0x80, 0x80, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0, 0x90, 0x90, 0x90, 0x90,
    0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90,
    0x90, 0, 0, 0x90, 0x90, 0x90, 0x90, 0x90, 0, 0x90, 0x90, 0, 0x90, 0x90,
    0x90, 0x90, 0x90, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0x70, 0x70, 0x70, 0x70, 0x70, 0, 0, 0x70, 0x70, 0x70, 0x70,
    0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90,
    0x90, 0x90, 0x90, 0x90, 0, 0, 0, 0, 0, 0x90, 0x90, 0x90, 0x90, 0x90,
    0x90, 0x90, 0x90, 0x90, 0x90, 0, 0, 0, 0, 0x90, 0x90, 0x61, 0x61, 0x61,
    0x61, 0, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61,
    0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61,
    0x61, 0x61, 0x61, 0x61, 0x61, 0, 0x61, 0x61, 0, 0x61, 0, 0, 0x61, 0,
    0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0, 0x61,
    0x61, 0x61, 0x61, 0, 0x61, 0, 0x61, 0, 0, 0, 0, 0x61, 0, 0, 0, 0, 0x61,
    0, 0x61, 0, 0x61, 0, 0x61, 0x61, 0x61, 0, 0x61, 0x61, 0, 0x61, 0, 0,
    0x61, 0, 0x61, 0, 0x61, 0, 0x61, 0, 0x61, 0x61, 0, 0x61, 0, 0, 0x61,
    0x61, 0x61, 0x61, 0, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0, 0x61,
    0x61, 0x61, 0x61, 0, 0x61, 0x61, 0x61, 0x61, 0, 0x61, 0, 0x61, 0x61,
    0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0, 0x61, 0x61, 0x61,
    0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61,
    0x61, 0x61, 0, 0, 0, 0, 0x61, 0x61, 0x61, 0, 0x61, 0x61, 0x61, 0x61,
    0x61, 0, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61,
    0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0x61, 0x61, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51,
    0, 0, 0, 0, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51,
    0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
    0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0, 0, 0x60, 0x60,
    0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
    0x70, 0, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
    0x60, 0x60, 0x60, 0x60, 0x60, 0, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
    0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x52, 0x52, 0x52,
    0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x70, 0x70, 0, 0, 0,
    0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52,
    0x52, 0x52, 0x52, 0x52, 0, 0x60, 0x52, 0x60, 0x60, 0x60, 0x60, 0x60,
    0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x52, 0x60, 0x52, 0x60, 0x60, 0x52,
    0x60, 0x60, 0x60, 0x52, 0x60, 0x60, 0x60, 0x52, 0x52, 0x52, 0x52, 0x52,
    0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x52, 0x60, 0x60, 0x60,
    0x60, 0x60, 0x60, 0x60, 0x52, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
    0x60, 0x60, 0x60, 0x61, 0x61, 0, 0, 0, 0, 0x60, 0x60, 0x60, 0x60, 0x60,
    0x60, 0x60, 0x60, 0x60, 0x52, 0x60, 0x52, 0x52, 0x60, 0x60, 0x52, 0x60,
    0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x52, 0x52, 0x52,
    0x52, 0x60, 0x60, 0x52, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
    0x60, 0x60, 0x90, 0x90, 0x90, 0x90, 0x90, 0, 0, 0, 0, 0, 0, 0x60, 0x60,
    0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
    0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
    0x52, 0x60, 0x60, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x52, 0x52,
    0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52,
    0x52, 0x52, 0x52, 0x52, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
    0x60, 0x90, 0, 0, 0, 0, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52,
    0x52, 0, 0, 0, 0, 0, 0, 0, 0x60, 0x60, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0x60, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70,
    0x70, 0x70, 0x70, 0x80, 0x80, 0x80, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
    0x70, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
    0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
    0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x70, 0x80, 0x80, 0x60, 0x60, 0x60,
    0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
    0x60, 0x60, 0x60, 0x60, 0x60, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70,
    0x70, 0x70, 0x70, 0x70, 0x70, 0x60, 0x60, 0x60, 0x60, 0x60, 0x70, 0x60,
    0x60, 0x60, 0x60, 0x60, 0x70, 0x70, 0x70, 0x70, 0x80, 0x80, 0x80, 0x80,
    0x80, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70,
    0x70, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
    0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70,
    0x70, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x60, 0x60, 0x60,
    0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
    0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
    0x60, 0x60, 0x60, 0x60, 0x70, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
    0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
    0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x70,
    0x60, 0x60, 0x60, 0x60, 0x70, 0x70, 0x80, 0x60, 0x60, 0x60, 0x60, 0x60,
    0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
    0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
    0x60, 0x70, 0x70, 0x61, 0x61, 0x61, 0x61, 0x70, 0x70, 0x70, 0x70, 0x70,
    0x70, 0x70, 0x80, 0x80, 0x80, 0x80, 0x80, 0x60, 0x60, 0x60, 0x60, 0x60,
    0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x70,
    0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70,
    0x70, 0x70, 0x70, 0x70, 0x70, 0x90, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70,
    0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70,
    0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x60, 0x60, 0x60,
    0x60, 0x60, 0x61, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
    0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x61, 0x60, 0x60, 0x60, 0x61,
    0x60, 0x61, 0x60, 0x61, 0x60, 0x61, 0x60, 0x60, 0x60, 0x61, 0x60, 0x60,
    0x60, 0x60, 0x60, 0x60, 0x61, 0x61, 0x60, 0x60, 0x60, 0x60, 0x61, 0x60,
    0x61, 0x61, 0x60, 0x60, 0x60, 0x60, 0x61, 0x60, 0x60, 0x60, 0x60, 0x60,
    0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x70, 0x70, 0x80, 0x80, 0x60, 0x60,
    0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x70, 0x70, 0x70,
    0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70,
    0x70, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x70, 0x70, 0x70, 0x70, 0x70,
    0x70, 0x70, 0x70, 0x70, 0x70, 0x80, 0x90, 0x90, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70,
    0x70, 0x70, 0x70, 0x70, 0, 0, 0, 0x70, 0x70, 0x70, 0x70, 0x90, 0x90,
    0x90, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
    0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
    0x60, 0x60, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x70, 0x70, 0x70, 0x70,
    0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0, 0, 0, 0, 0x70, 0x70,
    0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70,
    0x70, 0x70, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x80, 0x80,
    0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x90, 0x90, 0x90, 0x90, 0x90,
    0x90, 0, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0, 0, 0, 0, 0,
    0, 0, 0, 0x90, 0, 0, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90,
    0x90, 0x90, 0x90, 0x90, 0, 0, 0, 0, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90,
    0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0, 0x80, 0x80,
    0x80, 0x80, 0x80, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90,
    0x90, 0x90, 0x90, 0x90, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x80,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0x20, 0x20, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31,
    0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31,
    0x31, 0x31, 0x31, 0x31, 0x31, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x80, 0x80, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31,
    0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31,
    0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0, 0
};

static U8 precis_age_lookup(U32 cp)
{
    if ((0x01FFFE <= cp && (cp & 0x00FFFE) == 0x00FFFE)
	|| (0x0F0000 <= cp && cp <= 0x0FFFFD)
	|| (0x100000 <= cp && cp <= 0x10FFFD))
	return 0x20;
    else if (cp == 0x0E0001 || (0x0E0020 <= cp && cp <= 0x0E007F))
	return 0x31;
    else if (0x0E0100 <= cp && cp <= 0x0E01EF)
	return 0x40;
    else if (0x040000 <= cp)
	return 0;

    return precis_age_array[precis_age_index[cp >> AGE_BLKWIDTH] +
			    (cp & ((1 << AGE_BLKWIDTH) - 1))
	];
}

/* Lines below are automatically generated. Don't edit them manually. */
static U16 precis_xprop_index[] = {
    0, 109, 165, 165, 165, 165, 293, 421, 165, 549, 165, 660, 777, 897,
    1025, 1153, 1269, 1365, 1490, 1617, 1714, 1841, 1968, 2094, 2222, 2349,
    2476, 2576, 2663, 2742, 2846, 2974, 3057, 3183, 165, 165, 165, 165,
    3218, 165, 165, 165, 165, 165, 165, 165, 3328, 3444, 3565, 3688, 3784,
    165, 3889, 4017, 4145, 4259, 4375, 4431, 4553, 4660, 165, 165, 4788,
    4916, 5043, 5155, 5268, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 5307,
    5421, 197, 165, 5549, 5677, 5719, 5842, 5947, 165, 6075, 165, 6107,
    6235, 165, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677,
    5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677,
    5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677,
    5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677,
    5677, 5677, 5677, 5677, 5677, 6363, 5677, 5677, 5677, 5677, 5677, 5677,
    5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677,
    5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677,
    5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677,
    5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677,
    5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677,
    5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677,
    5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677,
    5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677,
    5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677,
    5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677,
    5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677,
    5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677,
    5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677,
    5677, 5719, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    6417, 6543, 165, 165, 6669, 6784, 6898, 7026, 7128, 7253, 7372, 7474,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    5677, 5677, 7602, 5715, 7730, 165, 165, 165, 165, 165, 7858, 166, 7906,
    8019, 165, 165, 8143, 8256, 165, 8382, 8479, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 8606, 8670, 165, 8798, 165,
    165, 165, 165, 165, 165, 165, 165, 8925, 9053, 9181, 9309, 9390, 9453,
    9581, 165, 9698, 9775, 165, 9853, 9947, 10032, 10131, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 10211, 10321, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 10376, 10493, 165,
    165, 165, 165, 165, 165, 165, 165, 10606, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 10734, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 10833, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 10869, 10994, 11122, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 11250, 11363,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 11491, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 11539,
    11667, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 11795, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677,
    5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677,
    5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677,
    5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677,
    5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677,
    5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677,
    5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677,
    5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677,
    5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677,
    5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677,
    5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677,
    5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677,
    5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677,
    5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677,
    5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677,
    5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677,
    5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677,
    5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677,
    5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677,
    5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677,
    5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677,
    5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677,
    5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677,
    5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677,
    5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677,
    5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677,
    5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677,
    5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677,
    5677, 5718, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677,
    5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677,
    5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 11923,
    5677, 12021, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677,
    5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677,
    5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677,
    5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 5677, 6383,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 5677, 5677,
    5677, 5677, 6387, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165
};

/* Lines below are automatically generated. Don't edit them manually. */
static U8 precis_xprop_array[] = {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, CH_SMALLL, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    CH_MIDDLEDOT, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, 0, CH_KERAIA, SC_Greek,
    SC_Greek, 0, 0, SC_Greek, SC_Greek, SC_Greek, SC_Greek, 0, SC_Greek, 0,
    0, 0, 0, SC_Greek, 0, SC_Greek, 0, SC_Greek, SC_Greek, SC_Greek, 0,
    SC_Greek, 0, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, 0, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    JT_T | SC_Hebrew, JT_T | SC_Hebrew, JT_T | SC_Hebrew, JT_T | SC_Hebrew,
    JT_T | SC_Hebrew, JT_T | SC_Hebrew, JT_T | SC_Hebrew, JT_T | SC_Hebrew,
    JT_T | SC_Hebrew, JT_T | SC_Hebrew, JT_T | SC_Hebrew, JT_T | SC_Hebrew,
    JT_T | SC_Hebrew, JT_T | SC_Hebrew, JT_T | SC_Hebrew, JT_T | SC_Hebrew,
    JT_T | SC_Hebrew, JT_T | SC_Hebrew, JT_T | SC_Hebrew, JT_T | SC_Hebrew,
    JT_T | SC_Hebrew, JT_T | SC_Hebrew, JT_T | SC_Hebrew, JT_T | SC_Hebrew,
    JT_T | SC_Hebrew, JT_T | SC_Hebrew, JT_T | SC_Hebrew, JT_T | SC_Hebrew,
    JT_T | SC_Hebrew, JT_T | SC_Hebrew, JT_T | SC_Hebrew, JT_T | SC_Hebrew,
    JT_T | SC_Hebrew, JT_T | SC_Hebrew, JT_T | SC_Hebrew, JT_T | SC_Hebrew,
    JT_T | SC_Hebrew, JT_T | SC_Hebrew, JT_T | SC_Hebrew, JT_T | SC_Hebrew,
    JT_T | SC_Hebrew, JT_T | SC_Hebrew, JT_T | SC_Hebrew, JT_T | SC_Hebrew,
    JT_T | SC_Hebrew, SC_Hebrew, JT_T | SC_Hebrew, SC_Hebrew,
    JT_T | SC_Hebrew, JT_T | SC_Hebrew, SC_Hebrew, JT_T | SC_Hebrew,
    JT_T | SC_Hebrew, SC_Hebrew, JT_T | SC_Hebrew, 0, 0, 0, 0, 0, 0, 0, 0,
    SC_Hebrew, SC_Hebrew, SC_Hebrew, SC_Hebrew, SC_Hebrew, SC_Hebrew,
    SC_Hebrew, SC_Hebrew, SC_Hebrew, SC_Hebrew, SC_Hebrew, SC_Hebrew,
    SC_Hebrew, SC_Hebrew, SC_Hebrew, SC_Hebrew, SC_Hebrew, SC_Hebrew,
    SC_Hebrew, SC_Hebrew, SC_Hebrew, SC_Hebrew, SC_Hebrew, SC_Hebrew,
    SC_Hebrew, SC_Hebrew, SC_Hebrew, 0, 0, 0, 0, 0, SC_Hebrew, SC_Hebrew,
    SC_Hebrew, CH_GERESH, CH_GERSHAYIM, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, 0, JT_T, 0, 0, 0, JT_D, 0, JT_R, JT_R, JT_R, JT_R, JT_D, JT_R,
    JT_D, JT_R, JT_D, JT_D, JT_D, JT_D, JT_D, JT_R, JT_R, JT_R, JT_R, JT_D,
    JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D,
    0, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_R, JT_D, JT_D, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, CH_Arabic_Indic_digits,
    CH_Arabic_Indic_digits, CH_Arabic_Indic_digits, CH_Arabic_Indic_digits,
    CH_Arabic_Indic_digits, CH_Arabic_Indic_digits, CH_Arabic_Indic_digits,
    CH_Arabic_Indic_digits, CH_Arabic_Indic_digits, CH_Arabic_Indic_digits,
    0, 0, 0, 0, JT_D, JT_D, JT_T, JT_R, JT_R, JT_R, 0, JT_R, JT_R, JT_R,
    JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_R, JT_R, JT_R, JT_R,
    JT_R, JT_R, JT_R, JT_R, JT_R, JT_R, JT_R, JT_R, JT_R, JT_R, JT_R, JT_R,
    JT_R, JT_R, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_D, JT_D, JT_D, JT_D, JT_R, JT_D, JT_D, JT_R, JT_R, JT_R, JT_R, JT_R,
    JT_R, JT_R, JT_R, JT_R, JT_D, JT_R, JT_D, JT_R, JT_D, JT_D, JT_R, JT_R,
    0, JT_R, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, 0, 0, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, 0, 0, JT_T, JT_T, 0, JT_T, JT_T, JT_T, JT_T,
    JT_R, JT_R, CH_extended_Arabic_Indic_digits,
    CH_extended_Arabic_Indic_digits, CH_extended_Arabic_Indic_digits,
    CH_extended_Arabic_Indic_digits, CH_extended_Arabic_Indic_digits,
    CH_extended_Arabic_Indic_digits, CH_extended_Arabic_Indic_digits,
    CH_extended_Arabic_Indic_digits, CH_extended_Arabic_Indic_digits,
    CH_extended_Arabic_Indic_digits, JT_D, JT_D, JT_D, 0, 0, JT_D, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_R, JT_T, JT_D, JT_D, JT_D,
    JT_R, JT_R, JT_R, JT_R, JT_R, JT_D, JT_D, JT_D, JT_D, JT_R, JT_D, JT_D,
    JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_R, JT_D, JT_R, JT_D, JT_R,
    JT_D, JT_D, JT_R, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, 0, 0, JT_R, JT_D, JT_D, JT_D, JT_D,
    JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_R, JT_R, JT_R, JT_D, JT_D,
    JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_D, JT_R, JT_R, JT_D, JT_D, JT_D, JT_D, JT_R, JT_D, JT_R, JT_R, JT_D,
    JT_D, JT_D, JT_R, JT_R, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_D, JT_D, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T,
    JT_T, JT_T, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, 0,
    JT_T, JT_T, JT_T, 0, JT_T, JT_T, JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_R, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_R, JT_R, JT_D, JT_R, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_D, JT_D, JT_R, JT_D, 0, 0, 0, JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_D, JT_R, JT_R, JT_R, 0, JT_R, JT_D, JT_D, JT_R, JT_R, JT_D, JT_D, 0,
    JT_D, JT_D, JT_D, JT_R, JT_D, JT_D, JT_D, JT_D, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, 0, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, 0, JT_T, 0, 0, 0, 0, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, 0, 0, 0, 0,
    JT_T | CCC_VIRAMA, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, JT_T, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, 0, 0, 0, 0,
    0, 0, 0, 0, JT_T | CCC_VIRAMA, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, 0, 0,
    0, 0, JT_T, JT_T, 0, 0, 0, 0, JT_T, JT_T, 0, 0, JT_T, JT_T,
    JT_T | CCC_VIRAMA, 0, 0, 0, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, 0, 0,
    0, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, JT_T, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T, 0, JT_T, JT_T, 0,
    0, 0, 0, JT_T | CCC_VIRAMA, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, JT_T, 0, 0, JT_T, 0, JT_T, JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0,
    0, JT_T | CCC_VIRAMA, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    JT_T | CCC_VIRAMA, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, 0, JT_T, JT_T, JT_T,
    JT_T | CCC_VIRAMA, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, JT_T, 0, 0, JT_T, 0, 0, 0, 0, 0, 0, JT_T, 0, 0, 0, 0, 0, JT_T,
    JT_T | CCC_VIRAMA, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0,
    JT_T | CCC_VIRAMA, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T | CCC_VIRAMA, 0, 0, 0, 0, 0, 0, 0,
    JT_T, JT_T, JT_T, 0, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T | CCC_VIRAMA, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, 0, 0, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, 0, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, 0,
    JT_T, 0, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, 0, JT_T, JT_T, JT_T,
    JT_T, JT_T | CCC_VIRAMA, 0, JT_T, JT_T, 0, 0, 0, 0, 0, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, 0, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, 0, 0, 0, 0,
    0, 0, 0, 0, 0, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T,
    0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, 0, JT_T | CCC_VIRAMA,
    JT_T | CCC_VIRAMA, 0, 0, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, 0, 0, 0, 0, JT_T,
    JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T,
    JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, 0, 0, JT_T, JT_T, 0,
    0, 0, 0, 0, 0, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T,
    JT_T | CCC_VIRAMA, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T | CCC_VIRAMA, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T,
    JT_T, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0,
    0, JT_T, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T | CCC_VIRAMA, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, JT_D, 0, 0, 0, JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, 0, 0, 0, 0,
    0, 0, 0, 0, JT_T, JT_T, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_D, JT_D, JT_T, JT_D, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T,
    JT_T, JT_T, 0, 0, 0, 0, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, 0,
    0, 0, 0, 0, 0, JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, 0, 0, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, JT_T, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, 0,
    JT_T | CCC_VIRAMA, 0, JT_T, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, 0, 0, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, 0, JT_T, JT_T,
    JT_T, JT_T, JT_T, 0, JT_T, 0, 0, 0, 0, 0, JT_T, 0, CCC_VIRAMA, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, 0, 0,
    JT_T, JT_T, CCC_VIRAMA, JT_T | CCC_VIRAMA, JT_T, JT_T, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, JT_T, 0, JT_T, JT_T, 0, 0, 0, JT_T, 0, JT_T, JT_T, JT_T,
    CCC_VIRAMA, CCC_VIRAMA, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, 0, 0, JT_T,
    JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, 0, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, 0, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, 0, 0, 0, 0, JT_T, 0, 0, 0, 0, 0, 0,
    JT_T, 0, 0, 0, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, 0, 0, 0, 0, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, SC_Greek, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, 0, 0, 0, 0, 0,
    JT_T, JT_T, JT_T, JT_T, JT_T, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, 0, 0, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, 0, 0, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, 0, 0, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, 0, 0, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, 0, SC_Greek, 0, SC_Greek, 0, SC_Greek, 0,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, 0, 0, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, 0, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, 0, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, 0, 0, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, 0, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, 0, 0, SC_Greek, SC_Greek, SC_Greek, 0,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, CH_ZWNJ,
    CH_ZWJ, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T,
    JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, SC_Greek, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    JT_T | CCC_VIRAMA, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, 0, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, SC_Han, 0,
    SC_Han, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, JT_T, JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    SC_Han, SC_Han, SC_Han, SC_Han, 0, 0, 0, 0, 0, SC_Hiragana,
    SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana,
    SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana,
    SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana,
    SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana,
    SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana,
    SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana,
    SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana,
    SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana,
    SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana,
    SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana,
    SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana,
    SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana,
    SC_Hiragana, SC_Hiragana, 0, 0, JT_T, JT_T, 0, 0, SC_Hiragana,
    SC_Hiragana, SC_Hiragana, 0, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, CH_NAKAGURO, 0, SC_Katakana, SC_Katakana,
    SC_Katakana, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, 0, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, 0, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    JT_T, 0, 0, 0, JT_T | CCC_VIRAMA, 0, 0, 0, 0, JT_T, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_D, JT_D, JT_L, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, JT_T | CCC_VIRAMA, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, 0, CCC_VIRAMA, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, 0, 0, JT_T, JT_T,
    JT_T, JT_T, 0, 0, JT_T, 0, 0, 0, CCC_VIRAMA, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, 0, 0, JT_T, JT_T, 0, 0, JT_T, JT_T, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    JT_T, 0, JT_T, JT_T, JT_T, 0, 0, JT_T, JT_T, 0, 0, 0, 0, 0, JT_T, JT_T,
    0, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T,
    JT_T, 0, 0, 0, 0, 0, 0, 0, 0, JT_T | CCC_VIRAMA, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    SC_Greek, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, 0, 0, JT_T, 0, 0, 0, 0,
    JT_T | CCC_VIRAMA, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, 0, 0, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, SC_Hebrew, JT_T | SC_Hebrew,
    SC_Hebrew, SC_Hebrew, SC_Hebrew, SC_Hebrew, SC_Hebrew, SC_Hebrew,
    SC_Hebrew, SC_Hebrew, SC_Hebrew, SC_Hebrew, SC_Hebrew, SC_Hebrew,
    SC_Hebrew, SC_Hebrew, SC_Hebrew, SC_Hebrew, SC_Hebrew, SC_Hebrew,
    SC_Hebrew, SC_Hebrew, SC_Hebrew, SC_Hebrew, SC_Hebrew, SC_Hebrew, 0,
    SC_Hebrew, SC_Hebrew, SC_Hebrew, SC_Hebrew, SC_Hebrew, 0, SC_Hebrew, 0,
    SC_Hebrew, SC_Hebrew, 0, SC_Hebrew, SC_Hebrew, 0, SC_Hebrew, SC_Hebrew,
    SC_Hebrew, SC_Hebrew, SC_Hebrew, SC_Hebrew, SC_Hebrew, SC_Hebrew,
    SC_Hebrew, SC_Hebrew, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, 0,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, SC_Greek, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T,
    JT_T, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, 0, JT_T, JT_T, 0, 0, 0, 0, 0,
    JT_T, JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    JT_T, JT_T, JT_T, 0, 0, 0, 0, JT_T | CCC_VIRAMA, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, JT_D, JT_D, JT_D, JT_D, JT_D, JT_R, 0, JT_R,
    0, JT_R, JT_R, 0, 0, JT_L, JT_R, JT_R, JT_R, JT_R, JT_R, JT_D, JT_D,
    JT_D, JT_D, JT_L, JT_D, JT_D, JT_D, JT_D, JT_D, JT_R, JT_D, JT_D, JT_D,
    JT_R, 0, 0, JT_R, JT_T, JT_T, 0, 0, 0, 0, JT_D, JT_D, JT_D, JT_D, JT_R,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_D, JT_R, JT_D, JT_R,
    JT_R, JT_R, JT_D, JT_D, JT_D, JT_R, JT_D, JT_D, JT_R, JT_D, JT_R, JT_R,
    JT_D, JT_R, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, JT_R, JT_R, JT_R, JT_R, JT_D, JT_D, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T | CCC_VIRAMA, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, JT_T | CCC_VIRAMA, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, 0,
    0, JT_T | CCC_VIRAMA, JT_T, 0, 0, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, JT_T, JT_T, JT_T, JT_T, JT_T, 0, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T | CCC_VIRAMA, JT_T | CCC_VIRAMA, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, 0,
    CCC_VIRAMA, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T,
    JT_T, JT_T, 0, 0, JT_T, CCC_VIRAMA, JT_T, JT_T, 0, 0, 0, 0, 0, 0, JT_T,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    JT_T, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T | CCC_VIRAMA, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, 0, 0, 0,
    JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, CCC_VIRAMA, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, 0, 0,
    JT_T | CCC_VIRAMA, JT_T, JT_T, 0, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, 0, JT_T, 0, 0, 0, 0, JT_T, JT_T, 0,
    JT_T | CCC_VIRAMA, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T,
    JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0, JT_T, JT_T, 0, JT_T | CCC_VIRAMA,
    JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, 0, 0, JT_T, 0, JT_T | CCC_VIRAMA, JT_T, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, 0, JT_T, 0, 0, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, CCC_VIRAMA, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, 0, 0, JT_T, JT_T, JT_T,
    JT_T, 0, JT_T, JT_T, JT_T, JT_T, JT_T | CCC_VIRAMA, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, 0, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, 0, JT_T | CCC_VIRAMA, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, 0,
    JT_T, JT_T, 0, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, JT_T, JT_T, JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, JT_T, JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    SC_Katakana, SC_Hiragana, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, 0, JT_T, JT_T,
    JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0,
    0, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, JT_T, JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, JT_T | SC_Greek, JT_T | SC_Greek, JT_T | SC_Greek,
    SC_Greek, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T,
    JT_T, JT_T, JT_T, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, 0, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    0, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, 0, JT_T, JT_T, 0, JT_T,
    JT_T, JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, SC_Hiragana, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, 0, 0, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han
};

static U32 precis_xprop_lookup(U32 cp)
{
    if (cp == 0x0E0001 || (0x0E0020 <= cp && cp <= 0x0E007F)
	|| (0x0E0100 <= cp && cp <= 0x0E01EF))
	return JT_T;
    else if (0x040000 <= cp)
	return 0;

    return precis_xprop_array[precis_xprop_index[cp >> XPROP_BLKWIDTH] +
			      (cp & ((1 << XPROP_BLKWIDTH) - 1))
	];
}

static const U8 utf8_sequence_len[0x100] = {
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,	/* 0x00-0x0F */
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,	/* 0x10-0x1F */
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,	/* 0x20-0x2F */
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,	/* 0x30-0x3F */
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,	/* 0x40-0x4F */
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,	/* 0x50-0x5F */
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,	/* 0x60-0x6F */
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,	/* 0x70-0x7F */
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,	/* 0x80-0x8F */
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,	/* 0x90-0x9F */
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,	/* 0xA0-0xAF */
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,	/* 0xB0-0xBF */
    0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,	/* 0xC0-0xCF */
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,	/* 0xD0-0xDF */
    3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,	/* 0xE0-0xEF */
    4, 4, 4, 4, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,	/* 0xF0-0xFF */
};

int precis_prepare(U8 * buf, const STRLEN buflen, int stringclass,
		   U8 unicode_version, U8 ** pptr, STRLEN * lenptr,
		   STRLEN * idxptr, U32 * cpptr)
{
    U8 *p = buf;
    const U8 *end = buf + buflen;
    const U8 *end4 = end - 4;

    STRLEN len = 0, idx = 0;
    U32 cp = 0;
    U8 prop = PRECIS_PVALID;
    U8 has_hankana = 0, has_aid = 0, has_eaid = 0;
    typedef struct {
	U8 *p;
	STRLEN len;
	STRLEN idx;
	U32 cp;
    } ctx_t;
    ctx_t ctx = { NULL, 0, 0, 0 };
    ctx_t nakaguro = { NULL, 0, 0, 0 };

    U32 vec;
    U32 xprop, jtype, xprop_before = 0, jtype_before = 0;

    while (p < end4) {
      check:
	/* Check if string consists of valid UTF-8 sequences. */

	len = utf8_sequence_len[*p];

	switch (len) {
	case 0:
	    goto illseq;

	case 1:
	    /* 0xxxxxxx */
	    cp = (U32) p[0];
	    break;

	case 2:
	    /* 110xxxxx 10xxxxxx */
	    if ((p[1] & 0xC0) != 0x80)
		goto illseq;
	    cp = ((U32) (p[0] & 0x1F) << 6) | ((U32) (p[1] & 0x3F));
	    break;

	case 3:
	    vec = ((U32) p[0] << 16) | ((U32) p[1] << 8) | ((U32) p[2]);
	    /* 1110xxxx 10xxxxxx 10xxxxxx *//* Shortest form */
	    if ((vec & 0x00F0C0C0) != 0x00E08080 || vec < 0x00E0A080)
		goto illseq;
	    cp = ((U32) (p[0] & 0x0F) << 12)
		| ((U32) (p[1] & 0x3F) << 6) | ((U32) (p[2] & 0x3F));
	    /* Surrogates U+D800..U+DFFF */
	    if ((cp & 0x00F800) == 0x00D800)
		goto disallowed;
	    /* Non-characters U+FDD0..U+FDEF, U+FFFE..U+FFFF */
	    if (0x00FDD0 <= cp && cp <= 0x00FDEF)
		goto disallowed;
	    if ((cp & 0x00FFFE) == 0x00FFFE)
		goto disallowed;
	    break;

	case 4:
	    vec = ((U32) p[0] << 24)
		| ((U32) p[1] << 16) | ((U32) p[2] << 8) | ((U32) p[3]);
	    /* 11110xxx 10xxxxxx 10xxxxxx 10xxxxxx *//* Shortest form */
	    if ((vec & 0xF8C0C0C0) != 0xF0808080 || vec < 0xF0908080)
		goto illseq;
	    cp = ((U32) (p[0] & 0x07) << 18)
		| ((U32) (p[1] & 0x3F) << 12)
		| ((U32) (p[2] & 0x3F) << 6) | ((U32) (p[3] & 0x3F));
	    /* Greater than U+10FFFF */
	    if (0x10FFFF < cp)
		goto disallowed;
	    /* Non-characters U+nFFFE..U+nFFFF */
	    if ((cp & 0x00FFFE) == 0x00FFFE)
		goto disallowed;
	    break;

	  illseq:
	    len = 0;
	    cp = 0;
	    /* goto disallowed; */
	  disallowed:
	    prop = PRECIS_DISALLOWED;
	    goto done;
	}			/* switch (len) */

	/* Check if character is assigned by specified version of Unicode. */

	if (unicode_version != 0
	    && unicode_version < precis_age_lookup(cp)) {
	    prop = PRECIS_UNASSIGNED;
	    goto done;
	}

	switch (stringclass) {
	case PRECIS_FREE_FORM_CLASS:
	case PRECIS_IDENTIFIER_CLASS:

	    /* Resolve property. */

	    prop = precis_prop_lookup(cp);

	    switch (prop) {
	    case PRECIS_PVALID:
	    case PRECIS_CONTEXTJ:
	    case PRECIS_CONTEXTO:
		break;

	    case PRECIS_ID_DIS:
		if (stringclass == PRECIS_IDENTIFIER_CLASS) {
		    prop = PRECIS_DISALLOWED;
		    goto done;
		} else
		    prop = PRECIS_PVALID;
		break;

	    default:
		goto done;
	    }

	    /* Resolve contextual rules. */

	    xprop = precis_xprop_lookup(cp);
	    jtype = xprop & JT_MASK;
	    xprop &= ~JT_MASK;

	    if (xprop == CH_NAKAGURO) {
		/* Rule 7: Record use of NAKAGURO. */
		if (nakaguro.p == NULL) {
		    nakaguro.p = p;
		    nakaguro.len = len;
		    nakaguro.idx = idx;
		    nakaguro.cp = cp;
		}
		prop = PRECIS_PVALID;
		xprop = 0;
	    }
	    if ((jtype_before & JT_L) && (jtype & JT_T))
		/* Rule 1.2: Allowing Re((JT:{L,D})(JT:T)*) */
		jtype = jtype_before;

	    switch (xprop_before) {
	    case CH_ZWNJ:
		goto after_ZWNJ;
	    case CH_MIDDLEDOT:
		goto after_MIDDLEDOT;
	    case CH_KERAIA:
		goto after_KERAIA;
	    }
	    switch (prop) {
	    case PRECIS_CONTEXTJ:
	    case PRECIS_CONTEXTO:
		ctx.p = p;
		ctx.len = len;
		ctx.idx = idx;
		ctx.cp = cp;
	    }

	    switch (xprop) {
		/* Rule 1: ZERO WIDTH NON-JOINER */
	    case CH_ZWNJ:	/* ZWNJ, CONTEXTJ */
		if (xprop_before == CCC_VIRAMA) {
		    /* Rule 1.1: CCC(Before(cp)) .eq. Virama */
		    prop = PRECIS_PVALID;
		    xprop = 0;
		} else if (jtype_before & JT_L)
		    /* Rule 1.2 top half: Re((JT:{L,D})(JT:T)*\u200C) */
		    ;
		else
		    goto done;
		break;

	      after_ZWNJ:
		/* Rule 1.2 bottom half: Re(\u200C(JT:T)*(JT:{R,D})) */
		if (jtype & JT_T) {
		    prop = PRECIS_CONTEXTJ;
		    xprop = xprop_before;	/* CP_ZWNJ */
		    jtype = jtype_before;	/* 0 */
		} else if (jtype & JT_R);
		else {
		    prop = PRECIS_CONTEXTJ;
		    goto done;
		}
		break;

		/* Rule 2: ZERO WIDTH JOINER */
	    case CH_ZWJ:	/* ZWJ, CONTEXTJ */
		if (xprop_before == CCC_VIRAMA)
		    prop = PRECIS_PVALID;
		else
		    goto done;
		break;

	    case CCC_VIRAMA:
		break;

		/* Rule 3: MIDDLE DOT */
	    case CH_MIDDLEDOT:	/* MIDDLE DOT, CONTEXTO */
		if (xprop_before == CH_SMALLL);
		else
		    goto done;
		break;

	      after_MIDDLEDOT:
		if (xprop == CH_SMALLL);
		else {
		    prop = PRECIS_CONTEXTO;
		    goto done;
		}
		break;

	    case CH_SMALLL:
		break;

		/* Rule 4: GREEK LOWER NUMERAL SIGN */
	    case CH_KERAIA:	/* KERAIA, CONTEXTO */
		break;

	      after_KERAIA:
		switch (xprop) {
		case CH_KERAIA:	/* CONTEXTO */
		    break;
		case SC_Greek:
		    break;
		default:
		    prop = PRECIS_CONTEXTO;
		    goto done;
		}
		break;

	    case SC_Greek:
		break;

		/* Rule 5: HEBREW PUNCTUATION GERESH */
	    case CH_GERESH:	/* GERESH, CONTEXTO */
		switch (xprop_before) {
		case CH_GERESH:
		case CH_GERSHAYIM:
		case SC_Hebrew:
		    prop = PRECIS_PVALID;
		    break;
		default:
		    goto done;
		}
		break;

		/* Rule 6: HEBREW PUNCTUATION GERSHAYIM */
	    case CH_GERSHAYIM:	/* GERSHAYIM, CONTEXTO */
		switch (xprop_before) {
		case CH_GERESH:
		case CH_GERSHAYIM:
		case SC_Hebrew:
		    prop = PRECIS_PVALID;
		    break;
		default:
		    goto done;
		}
		break;

	    case SC_Hebrew:
		break;

		/* Rule 7: KATAKANA MIDDLE DOT */
	    case CH_NAKAGURO:	/* NAKAGURO, CONTEXTO */
		 /*NOTREACHED*/	/* See above. */
		    break;

	    case SC_Han:
	    case SC_Hiragana:
	    case SC_Katakana:
		has_hankana = 1;
		break;

		/* Rule 8: ARABIC-INDIC DIGITS */
	    case CH_Arabic_Indic_digits:
		/* Arabic-Indic digits, CONTEXTO */
		if (has_eaid)
		    goto done;
		else {
		    prop = PRECIS_PVALID;
		    has_aid = 1;
		}
		break;

		/* Rule 9: EXTENDED ARABIC-INDIC DIGITS */
	    case CH_extended_Arabic_Indic_digits:
		/* Extended Arabic-Indic digits, CONTEXTO */
		if (has_aid)
		    goto done;
		else {
		    prop = PRECIS_PVALID;
		    has_eaid = 1;
		}
		break;

	    default:
		assert(prop == PRECIS_PVALID);
		assert(xprop == 0);
	    }			/* switch (xprop) */

	    xprop_before = xprop;
	    jtype_before = jtype;
	    break;

	default:
	    break;
	}			/* switch (stringclass) */

	p += len;
	idx++;
    }				/* while (p < end4) */
    if (p < end) {
	if (p + utf8_sequence_len[*p] <= end)
	    goto check;
	else
	    goto illseq;
    }

  done:
    if (nakaguro.p != NULL && !has_hankana) {
	if (pptr != NULL)
	    *pptr = nakaguro.p;
	if (lenptr != NULL)
	    *lenptr = nakaguro.len;
	if (idxptr != NULL)
	    *idxptr = nakaguro.idx;
	if (cpptr != NULL)
	    *cpptr = nakaguro.cp;
	prop = PRECIS_CONTEXTO;
    } else
	switch (prop) {
	case PRECIS_CONTEXTJ:
	case PRECIS_CONTEXTO:
	    assert(ctx.p != NULL);

	    if (pptr != NULL)
		*pptr = ctx.p;
	    if (lenptr != NULL)
		*lenptr = ctx.len;
	    if (idxptr != NULL)
		*idxptr = ctx.idx;
	    if (cpptr != NULL)
		*cpptr = ctx.cp;
	    break;

	case PRECIS_DISALLOWED:
	case PRECIS_UNASSIGNED:
	    if (pptr != NULL)
		*pptr = p;
	    if (lenptr != NULL)
		*lenptr = len;
	    if (idxptr != NULL)
		*idxptr = idx;
	    if (cpptr != NULL)
		*cpptr = cp;
	    break;

	default:
	    if (pptr != NULL)
		*pptr = p;
	    if (lenptr != NULL)
		*lenptr = 0;
	    if (idxptr != NULL)
		*idxptr = idx;
	    break;
	}

    return prop;
}
