# Generated by default/object.tt
package Paws::SecurityHub::PortProbeDetail;
  use Moose;
  has LocalIpDetails => (is => 'ro', isa => 'Paws::SecurityHub::ActionLocalIpDetails');
  has LocalPortDetails => (is => 'ro', isa => 'Paws::SecurityHub::ActionLocalPortDetails');
  has RemoteIpDetails => (is => 'ro', isa => 'Paws::SecurityHub::ActionRemoteIpDetails');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SecurityHub::PortProbeDetail

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SecurityHub::PortProbeDetail object:

  $service_obj->Method(Att1 => { LocalIpDetails => $value, ..., RemoteIpDetails => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SecurityHub::PortProbeDetail object:

  $result = $service_obj->Method(...);
  $result->Att1->LocalIpDetails

=head1 DESCRIPTION

A port scan that was part of the port probe. For each scan,
PortProbeDetails provides information about the local IP address and
port that were scanned, and the remote IP address that the scan
originated from.

=head1 ATTRIBUTES


=head2 LocalIpDetails => L<Paws::SecurityHub::ActionLocalIpDetails>

Provides information about the IP address where the scanned port is
located.


=head2 LocalPortDetails => L<Paws::SecurityHub::ActionLocalPortDetails>

Provides information about the port that was scanned.


=head2 RemoteIpDetails => L<Paws::SecurityHub::ActionRemoteIpDetails>

Provides information about the remote IP address that performed the
scan.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SecurityHub>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

