/* DO NOT EDIT THIS FILE - update __DATA__ section of helper_script/regen_openssl_constants.pl */

static double
constant (const char *name, size_t len) {
  /* Initially switch on the length of the name.  */
  switch (len) {
  case 5:
    /* Names all of length 5.  */
    /* RSA_3 ST_OK */
    /* Offset 0 gives the best switch position.  */
    switch (*name++) {
    case 'R':
      if (!memcmp(name, "SA_3", 4)) {
      /*                R          */
        
#ifdef RSA_3
        return RSA_3;
#else
        goto not_there;
#endif

      }
      break;
    case 'S':
      if (!memcmp(name, "T_OK", 4)) {
      /*                S          */
        
#ifdef SSL_ST_OK
        return SSL_ST_OK;
#else
        goto not_there;
#endif

      }
      break;
    }
    break;
  case 6:
    /* Names all of length 6.  */
    /* OP_ALL RSA_F4 */
    /* Offset 0 gives the best switch position.  */
    switch (*name++) {
    case 'O':
      if (!memcmp(name, "P_ALL", 5)) {
      /*                O           */
        
#ifdef SSL_OP_ALL
        return SSL_OP_ALL;
#else
        goto not_there;
#endif

      }
      break;
    case 'R':
      if (!memcmp(name, "SA_F4", 5)) {
      /*                R           */
        
#ifdef RSA_F4
        return RSA_F4;
#else
        goto not_there;
#endif

      }
      break;
    }
    break;
  case 7:
    /* Names all of length 7.  */
    /* CB_EXIT CB_LOOP CB_READ GEN_DNS GEN_RID GEN_URI NID_dsa NID_md2 NID_md5
       NID_rc4 NID_rsa NID_sha NOTHING READING ST_INIT WRITING */
    /* Offset 4 gives the best switch position.  */
    switch (name[4]) {
    case 'D':
      if (!memcmp(name, "GEN_DNS", 7)) {
      /*                     ^        */
        
#ifdef GEN_DNS
        return GEN_DNS;
#else
        goto not_there;
#endif

      }
      break;
    case 'E':
      if (!memcmp(name, "CB_READ", 7)) {
      /*                     ^        */
        
#ifdef SSL_CB_READ
        return SSL_CB_READ;
#else
        goto not_there;
#endif

      }
      break;
    case 'I':
      if (!memcmp(name, "NOTHING", 7)) {
      /*                     ^        */
        
#ifdef SSL_NOTHING
        return SSL_NOTHING;
#else
        goto not_there;
#endif

      }
      if (!memcmp(name, "READING", 7)) {
      /*                     ^        */
        
#ifdef SSL_READING
        return SSL_READING;
#else
        goto not_there;
#endif

      }
      if (!memcmp(name, "WRITING", 7)) {
      /*                     ^        */
        
#ifdef SSL_WRITING
        return SSL_WRITING;
#else
        goto not_there;
#endif

      }
      break;
    case 'N':
      if (!memcmp(name, "ST_INIT", 7)) {
      /*                     ^        */
        
#ifdef SSL_ST_INIT
        return SSL_ST_INIT;
#else
        goto not_there;
#endif

      }
      break;
    case 'O':
      if (!memcmp(name, "CB_LOOP", 7)) {
      /*                     ^        */
        
#ifdef SSL_CB_LOOP
        return SSL_CB_LOOP;
#else
        goto not_there;
#endif

      }
      break;
    case 'R':
      if (!memcmp(name, "GEN_RID", 7)) {
      /*                     ^        */
        
#ifdef GEN_RID
        return GEN_RID;
#else
        goto not_there;
#endif

      }
      break;
    case 'U':
      if (!memcmp(name, "GEN_URI", 7)) {
      /*                     ^        */
        
#ifdef GEN_URI
        return GEN_URI;
#else
        goto not_there;
#endif

      }
      break;
    case 'X':
      if (!memcmp(name, "CB_EXIT", 7)) {
      /*                     ^        */
        
#ifdef SSL_CB_EXIT
        return SSL_CB_EXIT;
#else
        goto not_there;
#endif

      }
      break;
    case 'd':
      if (!memcmp(name, "NID_dsa", 7)) {
      /*                     ^        */
        
#ifdef NID_dsa
        return NID_dsa;
#else
        goto not_there;
#endif

      }
      break;
    case 'm':
      if (!memcmp(name, "NID_md2", 7)) {
      /*                     ^        */
        
#ifdef NID_md2
        return NID_md2;
#else
        goto not_there;
#endif

      }
      if (!memcmp(name, "NID_md5", 7)) {
      /*                     ^        */
        
#ifdef NID_md5
        return NID_md5;
#else
        goto not_there;
#endif

      }
      break;
    case 'r':
      if (!memcmp(name, "NID_rc4", 7)) {
      /*                     ^        */
        
#ifdef NID_rc4
        return NID_rc4;
#else
        goto not_there;
#endif

      }
      if (!memcmp(name, "NID_rsa", 7)) {
      /*                     ^        */
        
#ifdef NID_rsa
        return NID_rsa;
#else
        goto not_there;
#endif

      }
      break;
    case 's':
      if (!memcmp(name, "NID_sha", 7)) {
      /*                     ^        */
        
#ifdef NID_sha
        return NID_sha;
#else
        goto not_there;
#endif

      }
      break;
    }
    break;
  case 8:
    /* Names all of length 8.  */
    /* CB_ALERT CB_WRITE F_READ_N GEN_X400 NID_X500 NID_X509 NID_mdc2 NID_name
       NID_pkcs NID_sha1 */
    /* Offset 5 gives the best switch position.  */
    switch (name[5]) {
    case '4':
      if (!memcmp(name, "GEN_X400", 8)) {
      /*                      ^        */
        
#ifdef GEN_X400
        return GEN_X400;
#else
        goto not_there;
#endif

      }
      break;
    case '5':
      if (!memcmp(name, "NID_X500", 8)) {
      /*                      ^        */
        
#ifdef NID_X500
        return NID_X500;
#else
        goto not_there;
#endif

      }
      if (!memcmp(name, "NID_X509", 8)) {
      /*                      ^        */
        
#ifdef NID_X509
        return NID_X509;
#else
        goto not_there;
#endif

      }
      break;
    case 'D':
      if (!memcmp(name, "F_READ_N", 8)) {
      /*                      ^        */
        
#ifdef SSL_F_READ_N
        return SSL_F_READ_N;
#else
        goto not_there;
#endif

      }
      break;
    case 'E':
      if (!memcmp(name, "CB_ALERT", 8)) {
      /*                      ^        */
        
#ifdef SSL_CB_ALERT
        return SSL_CB_ALERT;
#else
        goto not_there;
#endif

      }
      break;
    case 'I':
      if (!memcmp(name, "CB_WRITE", 8)) {
      /*                      ^        */
        
#ifdef SSL_CB_WRITE
        return SSL_CB_WRITE;
#else
        goto not_there;
#endif

      }
      break;
    case 'a':
      if (!memcmp(name, "NID_name", 8)) {
      /*                      ^        */
        
#ifdef NID_name
        return NID_name;
#else
        goto not_there;
#endif

      }
      break;
    case 'd':
      if (!memcmp(name, "NID_mdc2", 8)) {
      /*                      ^        */
        
#ifdef NID_mdc2
        return NID_mdc2;
#else
        goto not_there;
#endif

      }
      break;
    case 'h':
      if (!memcmp(name, "NID_sha1", 8)) {
      /*                      ^        */
        
#ifdef NID_sha1
        return NID_sha1;
#else
        goto not_there;
#endif

      }
      break;
    case 'k':
      if (!memcmp(name, "NID_pkcs", 8)) {
      /*                      ^        */
        
#ifdef NID_pkcs
        return NID_pkcs;
#else
        goto not_there;
#endif

      }
      break;
    }
    break;
  case 9:
    /* Names all of length 9.  */
    /* ERROR_SSL EVP_PK_DH EVP_PK_EC F_SSL_NEW GEN_EMAIL GEN_IPADD NID_dsa_2
       NID_id_ad NID_id_ce NID_id_kp NID_id_pe NID_pbes2 NID_pkcs3 NID_pkcs7
       NID_pkcs9 NID_sxnet NID_title NID_undef ST_ACCEPT ST_BEFORE X509_V_OK */
    /* Offset 8 gives the best switch position.  */
    switch (name[8]) {
    case '2':
      if (!memcmp(name, "NID_dsa_", 8)) {
      /*                         2     */
        
#ifdef NID_dsa_2
        return NID_dsa_2;
#else
        goto not_there;
#endif

      }
      if (!memcmp(name, "NID_pbes", 8)) {
      /*                         2     */
        
#ifdef NID_pbes2
        return NID_pbes2;
#else
        goto not_there;
#endif

      }
      break;
    case '3':
      if (!memcmp(name, "NID_pkcs", 8)) {
      /*                         3     */
        
#ifdef NID_pkcs3
        return NID_pkcs3;
#else
        goto not_there;
#endif

      }
      break;
    case '7':
      if (!memcmp(name, "NID_pkcs", 8)) {
      /*                         7     */
        
#ifdef NID_pkcs7
        return NID_pkcs7;
#else
        goto not_there;
#endif

      }
      break;
    case '9':
      if (!memcmp(name, "NID_pkcs", 8)) {
      /*                         9     */
        
#ifdef NID_pkcs9
        return NID_pkcs9;
#else
        goto not_there;
#endif

      }
      break;
    case 'C':
      if (!memcmp(name, "EVP_PK_E", 8)) {
      /*                         C     */
        
#ifdef EVP_PK_EC
        return EVP_PK_EC;
#else
        goto not_there;
#endif

      }
      break;
    case 'D':
      if (!memcmp(name, "GEN_IPAD", 8)) {
      /*                         D     */
        
#ifdef GEN_IPADD
        return GEN_IPADD;
#else
        goto not_there;
#endif

      }
      break;
    case 'E':
      if (!memcmp(name, "ST_BEFOR", 8)) {
      /*                         E     */
        
#ifdef SSL_ST_BEFORE
        return SSL_ST_BEFORE;
#else
        goto not_there;
#endif

      }
      break;
    case 'H':
      if (!memcmp(name, "EVP_PK_D", 8)) {
      /*                         H     */
        
#ifdef EVP_PK_DH
        return EVP_PK_DH;
#else
        goto not_there;
#endif

      }
      break;
    case 'K':
      if (!memcmp(name, "X509_V_O", 8)) {
      /*                         K     */
        
#ifdef X509_V_OK
        return X509_V_OK;
#else
        goto not_there;
#endif

      }
      break;
    case 'L':
      if (!memcmp(name, "ERROR_SS", 8)) {
      /*                         L     */
        
#ifdef SSL_ERROR_SSL
        return SSL_ERROR_SSL;
#else
        goto not_there;
#endif

      }
      if (!memcmp(name, "GEN_EMAI", 8)) {
      /*                         L     */
        
#ifdef GEN_EMAIL
        return GEN_EMAIL;
#else
        goto not_there;
#endif

      }
      break;
    case 'T':
      if (!memcmp(name, "ST_ACCEP", 8)) {
      /*                         T     */
        
#ifdef SSL_ST_ACCEPT
        return SSL_ST_ACCEPT;
#else
        goto not_there;
#endif

      }
      break;
    case 'W':
      if (!memcmp(name, "F_SSL_NE", 8)) {
      /*                         W     */
        
#ifdef SSL_F_SSL_NEW
        return SSL_F_SSL_NEW;
#else
        goto not_there;
#endif

      }
      break;
    case 'd':
      if (!memcmp(name, "NID_id_a", 8)) {
      /*                         d     */
        
#ifdef NID_id_ad
        return NID_id_ad;
#else
        goto not_there;
#endif

      }
      break;
    case 'e':
      if (!memcmp(name, "NID_id_c", 8)) {
      /*                         e     */
        
#ifdef NID_id_ce
        return NID_id_ce;
#else
        goto not_there;
#endif

      }
      if (!memcmp(name, "NID_id_p", 8)) {
      /*                         e     */
        
#ifdef NID_id_pe
        return NID_id_pe;
#else
        goto not_there;
#endif

      }
      if (!memcmp(name, "NID_titl", 8)) {
      /*                         e     */
        
#ifdef NID_title
        return NID_title;
#else
        goto not_there;
#endif

      }
      break;
    case 'f':
      if (!memcmp(name, "NID_unde", 8)) {
      /*                         f     */
        
#ifdef NID_undef
        return NID_undef;
#else
        goto not_there;
#endif

      }
      break;
    case 'p':
      if (!memcmp(name, "NID_id_k", 8)) {
      /*                         p     */
        
#ifdef NID_id_kp
        return NID_id_kp;
#else
        goto not_there;
#endif

      }
      break;
    case 't':
      if (!memcmp(name, "NID_sxne", 8)) {
      /*                         t     */
        
#ifdef NID_sxnet
        return NID_sxnet;
#else
        goto not_there;
#endif

      }
      break;
    }
    break;
  case 10:
    /* Names all of length 10.  */
    /* ERROR_NONE EVP_PKS_EC EVP_PK_DSA EVP_PK_RSA F_SSL_READ NID_bf_cbc
       NID_bf_ecb NID_crlBag NID_keyBag NID_ms_efs NID_ms_sgc NID_ns_sgc
       NID_pbmac1 NID_rc4_40 NID_rsadsi R_X509_LIB ST_CONNECT */
    /* Offset 8 gives the best switch position.  */
    switch (name[8]) {
    case '4':
      if (!memcmp(name, "NID_rc4_40", 10)) {
      /*                         ^        */
        
#ifdef NID_rc4_40
        return NID_rc4_40;
#else
        goto not_there;
#endif

      }
      break;
    case 'A':
      if (!memcmp(name, "F_SSL_READ", 10)) {
      /*                         ^        */
        
#ifdef SSL_F_SSL_READ
        return SSL_F_SSL_READ;
#else
        goto not_there;
#endif

      }
      break;
    case 'C':
      if (!memcmp(name, "ST_CONNECT", 10)) {
      /*                         ^        */
        
#ifdef SSL_ST_CONNECT
        return SSL_ST_CONNECT;
#else
        goto not_there;
#endif

      }
      break;
    case 'E':
      if (!memcmp(name, "EVP_PKS_EC", 10)) {
      /*                         ^        */
        
#ifdef EVP_PKS_EC
        return EVP_PKS_EC;
#else
        goto not_there;
#endif

      }
      break;
    case 'I':
      if (!memcmp(name, "R_X509_LIB", 10)) {
      /*                         ^        */
        
#ifdef SSL_R_X509_LIB
        return SSL_R_X509_LIB;
#else
        goto not_there;
#endif

      }
      break;
    case 'N':
      if (!memcmp(name, "ERROR_NONE", 10)) {
      /*                         ^        */
        
#ifdef SSL_ERROR_NONE
        return SSL_ERROR_NONE;
#else
        goto not_there;
#endif

      }
      break;
    case 'S':
      if (!memcmp(name, "EVP_PK_DSA", 10)) {
      /*                         ^        */
        
#ifdef EVP_PK_DSA
        return EVP_PK_DSA;
#else
        goto not_there;
#endif

      }
      if (!memcmp(name, "EVP_PK_RSA", 10)) {
      /*                         ^        */
        
#ifdef EVP_PK_RSA
        return EVP_PK_RSA;
#else
        goto not_there;
#endif

      }
      break;
    case 'a':
      if (!memcmp(name, "NID_crlBag", 10)) {
      /*                         ^        */
        
#ifdef NID_crlBag
        return NID_crlBag;
#else
        goto not_there;
#endif

      }
      if (!memcmp(name, "NID_keyBag", 10)) {
      /*                         ^        */
        
#ifdef NID_keyBag
        return NID_keyBag;
#else
        goto not_there;
#endif

      }
      break;
    case 'b':
      if (!memcmp(name, "NID_bf_cbc", 10)) {
      /*                         ^        */
        
#ifdef NID_bf_cbc
        return NID_bf_cbc;
#else
        goto not_there;
#endif

      }
      break;
    case 'c':
      if (!memcmp(name, "NID_bf_ecb", 10)) {
      /*                         ^        */
        
#ifdef NID_bf_ecb
        return NID_bf_ecb;
#else
        goto not_there;
#endif

      }
      if (!memcmp(name, "NID_pbmac1", 10)) {
      /*                         ^        */
        
#ifdef NID_pbmac1
        return NID_pbmac1;
#else
        goto not_there;
#endif

      }
      break;
    case 'f':
      if (!memcmp(name, "NID_ms_efs", 10)) {
      /*                         ^        */
        
#ifdef NID_ms_efs
        return NID_ms_efs;
#else
        goto not_there;
#endif

      }
      break;
    case 'g':
      if (!memcmp(name, "NID_ms_sgc", 10)) {
      /*                         ^        */
        
#ifdef NID_ms_sgc
        return NID_ms_sgc;
#else
        goto not_there;
#endif

      }
      if (!memcmp(name, "NID_ns_sgc", 10)) {
      /*                         ^        */
        
#ifdef NID_ns_sgc
        return NID_ns_sgc;
#else
        goto not_there;
#endif

      }
      break;
    case 's':
      if (!memcmp(name, "NID_rsadsi", 10)) {
      /*                         ^        */
        
#ifdef NID_rsadsi
        return NID_rsadsi;
#else
        goto not_there;
#endif

      }
      break;
    }
    break;
  case 11:
    /* Names all of length 11.  */
    /* EVP_PKS_DSA EVP_PKS_RSA EVP_PKT_ENC EVP_PKT_EXP GEN_DIRNAME NID_ad_OCSP
       NID_certBag NID_des_cbc NID_des_ecb NID_des_ede NID_ext_req NID_id_pkix
       NID_rc2_cbc NID_rc2_ecb NID_rc5_cbc NID_rc5_ecb NID_surname NID_x509Crl
       OP_NO_SSLv2 OP_NO_SSLv3 OP_NO_TLSv1 R_BAD_STATE VERIFY_NONE VERIFY_PEER
       X509_LOOKUP */
    /* Offset 9 gives the best switch position.  */
    switch (name[9]) {
    case 'E':
      if (!memcmp(name, "VERIFY_PEER", 11)) {
      /*                          ^        */
        
#ifdef SSL_VERIFY_PEER
        return SSL_VERIFY_PEER;
#else
        goto not_there;
#endif

      }
      break;
    case 'M':
      if (!memcmp(name, "GEN_DIRNAME", 11)) {
      /*                          ^        */
        
#ifdef GEN_DIRNAME
        return GEN_DIRNAME;
#else
        goto not_there;
#endif

      }
      break;
    case 'N':
      if (!memcmp(name, "EVP_PKT_ENC", 11)) {
      /*                          ^        */
        
#ifdef EVP_PKT_ENC
        return EVP_PKT_ENC;
#else
        goto not_there;
#endif

      }
      if (!memcmp(name, "VERIFY_NONE", 11)) {
      /*                          ^        */
        
#ifdef SSL_VERIFY_NONE
        return SSL_VERIFY_NONE;
#else
        goto not_there;
#endif

      }
      break;
    case 'S':
      if (!memcmp(name, "EVP_PKS_DSA", 11)) {
      /*                          ^        */
        
#ifdef EVP_PKS_DSA
        return EVP_PKS_DSA;
#else
        goto not_there;
#endif

      }
      if (!memcmp(name, "EVP_PKS_RSA", 11)) {
      /*                          ^        */
        
#ifdef EVP_PKS_RSA
        return EVP_PKS_RSA;
#else
        goto not_there;
#endif

      }
      if (!memcmp(name, "NID_ad_OCSP", 11)) {
      /*                          ^        */
        
#ifdef NID_ad_OCSP
        return NID_ad_OCSP;
#else
        goto not_there;
#endif

      }
      break;
    case 'T':
      if (!memcmp(name, "R_BAD_STATE", 11)) {
      /*                          ^        */
        
#ifdef SSL_R_BAD_STATE
        return SSL_R_BAD_STATE;
#else
        goto not_there;
#endif

      }
      break;
    case 'U':
      if (!memcmp(name, "X509_LOOKUP", 11)) {
      /*                          ^        */
        
#ifdef SSL_X509_LOOKUP
        return SSL_X509_LOOKUP;
#else
        goto not_there;
#endif

      }
      break;
    case 'X':
      if (!memcmp(name, "EVP_PKT_EXP", 11)) {
      /*                          ^        */
        
#ifdef EVP_PKT_EXP
        return EVP_PKT_EXP;
#else
        goto not_there;
#endif

      }
      break;
    case 'a':
      if (!memcmp(name, "NID_certBag", 11)) {
      /*                          ^        */
        
#ifdef NID_certBag
        return NID_certBag;
#else
        goto not_there;
#endif

      }
      break;
    case 'b':
      if (!memcmp(name, "NID_des_cbc", 11)) {
      /*                          ^        */
        
#ifdef NID_des_cbc
        return NID_des_cbc;
#else
        goto not_there;
#endif

      }
      if (!memcmp(name, "NID_rc2_cbc", 11)) {
      /*                          ^        */
        
#ifdef NID_rc2_cbc
        return NID_rc2_cbc;
#else
        goto not_there;
#endif

      }
      if (!memcmp(name, "NID_rc5_cbc", 11)) {
      /*                          ^        */
        
#ifdef NID_rc5_cbc
        return NID_rc5_cbc;
#else
        goto not_there;
#endif

      }
      break;
    case 'c':
      if (!memcmp(name, "NID_des_ecb", 11)) {
      /*                          ^        */
        
#ifdef NID_des_ecb
        return NID_des_ecb;
#else
        goto not_there;
#endif

      }
      if (!memcmp(name, "NID_rc2_ecb", 11)) {
      /*                          ^        */
        
#ifdef NID_rc2_ecb
        return NID_rc2_ecb;
#else
        goto not_there;
#endif

      }
      if (!memcmp(name, "NID_rc5_ecb", 11)) {
      /*                          ^        */
        
#ifdef NID_rc5_ecb
        return NID_rc5_ecb;
#else
        goto not_there;
#endif

      }
      break;
    case 'd':
      if (!memcmp(name, "NID_des_ede", 11)) {
      /*                          ^        */
        
#ifdef NID_des_ede
        return NID_des_ede;
#else
        goto not_there;
#endif

      }
      break;
    case 'e':
      if (!memcmp(name, "NID_ext_req", 11)) {
      /*                          ^        */
        
#ifdef NID_ext_req
        return NID_ext_req;
#else
        goto not_there;
#endif

      }
      break;
    case 'i':
      if (!memcmp(name, "NID_id_pkix", 11)) {
      /*                          ^        */
        
#ifdef NID_id_pkix
        return NID_id_pkix;
#else
        goto not_there;
#endif

      }
      break;
    case 'm':
      if (!memcmp(name, "NID_surname", 11)) {
      /*                          ^        */
        
#ifdef NID_surname
        return NID_surname;
#else
        goto not_there;
#endif

      }
      break;
    case 'r':
      if (!memcmp(name, "NID_x509Crl", 11)) {
      /*                          ^        */
        
#ifdef NID_x509Crl
        return NID_x509Crl;
#else
        goto not_there;
#endif

      }
      break;
    case 'v':
      if (!memcmp(name, "OP_NO_SSLv2", 11)) {
      /*                          ^        */
        
#ifdef SSL_OP_NO_SSLv2
        return SSL_OP_NO_SSLv2;
#else
        goto not_there;
#endif

      }
      if (!memcmp(name, "OP_NO_SSLv3", 11)) {
      /*                          ^        */
        
#ifdef SSL_OP_NO_SSLv3
        return SSL_OP_NO_SSLv3;
#else
        goto not_there;
#endif

      }
      if (!memcmp(name, "OP_NO_TLSv1", 11)) {
      /*                          ^        */
        
#ifdef SSL_OP_NO_TLSv1
        return SSL_OP_NO_TLSv1;
#else
        goto not_there;
#endif

      }
      break;
    }
    break;
  case 12:
    /* Names all of length 12.  */
    /* EVP_PKT_EXCH EVP_PKT_SIGN FILETYPE_PEM F_SSL_SET_FD GEN_EDIPARTY
       MBSTRING_ASC MBSTRING_BMP NID_bf_cfb64 NID_bf_ofb64 NID_des_ede3
       NID_desx_cbc NID_idea_cbc NID_idea_ecb NID_initials NID_md5_sha1
       NID_netscape OP_NO_TICKET R_PEER_ERROR R_SHORT_READ ST_READ_BODY */
    /* Offset 10 gives the best switch position.  */
    switch (name[10]) {
    case '6':
      if (!memcmp(name, "NID_bf_cfb64", 12)) {
      /*                           ^        */
        
#ifdef NID_bf_cfb64
        return NID_bf_cfb64;
#else
        goto not_there;
#endif

      }
      if (!memcmp(name, "NID_bf_ofb64", 12)) {
      /*                           ^        */
        
#ifdef NID_bf_ofb64
        return NID_bf_ofb64;
#else
        goto not_there;
#endif

      }
      break;
    case 'A':
      if (!memcmp(name, "R_SHORT_READ", 12)) {
      /*                           ^        */
        
#ifdef SSL_R_SHORT_READ
        return SSL_R_SHORT_READ;
#else
        goto not_there;
#endif

      }
      break;
    case 'C':
      if (!memcmp(name, "EVP_PKT_EXCH", 12)) {
      /*                           ^        */
        
#ifdef EVP_PKT_EXCH
        return EVP_PKT_EXCH;
#else
        goto not_there;
#endif

      }
      break;
    case 'D':
      if (!memcmp(name, "ST_READ_BODY", 12)) {
      /*                           ^        */
        
#ifdef SSL_ST_READ_BODY
        return SSL_ST_READ_BODY;
#else
        goto not_there;
#endif

      }
      break;
    case 'E':
      if (!memcmp(name, "FILETYPE_PEM", 12)) {
      /*                           ^        */
        
#ifdef SSL_FILETYPE_PEM
        return SSL_FILETYPE_PEM;
#else
        goto not_there;
#endif

      }
      if (!memcmp(name, "OP_NO_TICKET", 12)) {
      /*                           ^        */
        
#ifdef SSL_OP_NO_TICKET
        return SSL_OP_NO_TICKET;
#else
        goto not_there;
#endif

      }
      break;
    case 'F':
      if (!memcmp(name, "F_SSL_SET_FD", 12)) {
      /*                           ^        */
        
#ifdef SSL_F_SSL_SET_FD
        return SSL_F_SSL_SET_FD;
#else
        goto not_there;
#endif

      }
      break;
    case 'G':
      if (!memcmp(name, "EVP_PKT_SIGN", 12)) {
      /*                           ^        */
        
#ifdef EVP_PKT_SIGN
        return EVP_PKT_SIGN;
#else
        goto not_there;
#endif

      }
      break;
    case 'M':
      if (!memcmp(name, "MBSTRING_BMP", 12)) {
      /*                           ^        */
        
#ifdef MBSTRING_BMP
        return MBSTRING_BMP;
#else
        goto not_there;
#endif

      }
      break;
    case 'O':
      if (!memcmp(name, "R_PEER_ERROR", 12)) {
      /*                           ^        */
        
#ifdef SSL_R_PEER_ERROR
        return SSL_R_PEER_ERROR;
#else
        goto not_there;
#endif

      }
      break;
    case 'S':
      if (!memcmp(name, "MBSTRING_ASC", 12)) {
      /*                           ^        */
        
#ifdef MBSTRING_ASC
        return MBSTRING_ASC;
#else
        goto not_there;
#endif

      }
      break;
    case 'T':
      if (!memcmp(name, "GEN_EDIPARTY", 12)) {
      /*                           ^        */
        
#ifdef GEN_EDIPARTY
        return GEN_EDIPARTY;
#else
        goto not_there;
#endif

      }
      break;
    case 'a':
      if (!memcmp(name, "NID_md5_sha1", 12)) {
      /*                           ^        */
        
#ifdef NID_md5_sha1
        return NID_md5_sha1;
#else
        goto not_there;
#endif

      }
      break;
    case 'b':
      if (!memcmp(name, "NID_desx_cbc", 12)) {
      /*                           ^        */
        
#ifdef NID_desx_cbc
        return NID_desx_cbc;
#else
        goto not_there;
#endif

      }
      if (!memcmp(name, "NID_idea_cbc", 12)) {
      /*                           ^        */
        
#ifdef NID_idea_cbc
        return NID_idea_cbc;
#else
        goto not_there;
#endif

      }
      break;
    case 'c':
      if (!memcmp(name, "NID_idea_ecb", 12)) {
      /*                           ^        */
        
#ifdef NID_idea_ecb
        return NID_idea_ecb;
#else
        goto not_there;
#endif

      }
      break;
    case 'e':
      if (!memcmp(name, "NID_des_ede3", 12)) {
      /*                           ^        */
        
#ifdef NID_des_ede3
        return NID_des_ede3;
#else
        goto not_there;
#endif

      }
      break;
    case 'l':
      if (!memcmp(name, "NID_initials", 12)) {
      /*                           ^        */
        
#ifdef NID_initials
        return NID_initials;
#else
        goto not_there;
#endif

      }
      break;
    case 'p':
      if (!memcmp(name, "NID_netscape", 12)) {
      /*                           ^        */
        
#ifdef NID_netscape
        return NID_netscape;
#else
        goto not_there;
#endif

      }
      break;
    }
    break;
  case 13:
    /* Names all of length 13.  */
    /* CB_READ_ALERT ERROR_SYSCALL FILETYPE_ASN1 F_SSL_SET_RFD F_SSL_SET_WFD
       GEN_OTHERNAME MBSTRING_FLAG MBSTRING_UNIV MBSTRING_UTF8 NID_OCSP_sign
       NID_algorithm NID_cast5_cbc NID_cast5_ecb NID_code_sign NID_delta_crl
       NID_des_cfb64 NID_des_ofb64 NID_givenName NID_id_pbkdf2 NID_id_qt_cps
       NID_key_usage NID_rc2_cfb64 NID_rc2_ofb64 NID_rc5_cfb64 NID_rc5_ofb64
       NID_ripemd160 NID_secretBag OP_NO_TLSv1_1 OP_NO_TLSv1_2 OP_TLS_D5_BUG
       SENT_SHUTDOWN XN_FLAG_FN_LN XN_FLAG_FN_SN */
    /* Offset 12 gives the best switch position.  */
    switch (name[12]) {
    case '0':
      if (!memcmp(name, "NID_ripemd16", 12)) {
      /*                             0      */
        
#ifdef NID_ripemd160
        return NID_ripemd160;
#else
        goto not_there;
#endif

      }
      break;
    case '1':
      if (!memcmp(name, "FILETYPE_ASN", 12)) {
      /*                             1      */
        
#ifdef SSL_FILETYPE_ASN1
        return SSL_FILETYPE_ASN1;
#else
        goto not_there;
#endif

      }
      if (!memcmp(name, "OP_NO_TLSv1_", 12)) {
      /*                             1      */
        
#ifdef SSL_OP_NO_TLSv1_1
        return SSL_OP_NO_TLSv1_1;
#else
        goto not_there;
#endif

      }
      break;
    case '2':
      if (!memcmp(name, "NID_id_pbkdf", 12)) {
      /*                             2      */
        
#ifdef NID_id_pbkdf2
        return NID_id_pbkdf2;
#else
        goto not_there;
#endif

      }
      if (!memcmp(name, "OP_NO_TLSv1_", 12)) {
      /*                             2      */
        
#ifdef SSL_OP_NO_TLSv1_2
        return SSL_OP_NO_TLSv1_2;
#else
        goto not_there;
#endif

      }
      break;
    case '4':
      if (!memcmp(name, "NID_des_cfb6", 12)) {
      /*                             4      */
        
#ifdef NID_des_cfb64
        return NID_des_cfb64;
#else
        goto not_there;
#endif

      }
      if (!memcmp(name, "NID_des_ofb6", 12)) {
      /*                             4      */
        
#ifdef NID_des_ofb64
        return NID_des_ofb64;
#else
        goto not_there;
#endif

      }
      if (!memcmp(name, "NID_rc2_cfb6", 12)) {
      /*                             4      */
        
#ifdef NID_rc2_cfb64
        return NID_rc2_cfb64;
#else
        goto not_there;
#endif

      }
      if (!memcmp(name, "NID_rc2_ofb6", 12)) {
      /*                             4      */
        
#ifdef NID_rc2_ofb64
        return NID_rc2_ofb64;
#else
        goto not_there;
#endif

      }
      if (!memcmp(name, "NID_rc5_cfb6", 12)) {
      /*                             4      */
        
#ifdef NID_rc5_cfb64
        return NID_rc5_cfb64;
#else
        goto not_there;
#endif

      }
      if (!memcmp(name, "NID_rc5_ofb6", 12)) {
      /*                             4      */
        
#ifdef NID_rc5_ofb64
        return NID_rc5_ofb64;
#else
        goto not_there;
#endif

      }
      break;
    case '8':
      if (!memcmp(name, "MBSTRING_UTF", 12)) {
      /*                             8      */
        
#ifdef MBSTRING_UTF8
        return MBSTRING_UTF8;
#else
        goto not_there;
#endif

      }
      break;
    case 'D':
      if (!memcmp(name, "F_SSL_SET_RF", 12)) {
      /*                             D      */
        
#ifdef SSL_F_SSL_SET_RFD
        return SSL_F_SSL_SET_RFD;
#else
        goto not_there;
#endif

      }
      if (!memcmp(name, "F_SSL_SET_WF", 12)) {
      /*                             D      */
        
#ifdef SSL_F_SSL_SET_WFD
        return SSL_F_SSL_SET_WFD;
#else
        goto not_there;
#endif

      }
      break;
    case 'E':
      if (!memcmp(name, "GEN_OTHERNAM", 12)) {
      /*                             E      */
        
#ifdef GEN_OTHERNAME
        return GEN_OTHERNAME;
#else
        goto not_there;
#endif

      }
      break;
    case 'G':
      if (!memcmp(name, "MBSTRING_FLA", 12)) {
      /*                             G      */
        
#ifdef MBSTRING_FLAG
        return MBSTRING_FLAG;
#else
        goto not_there;
#endif

      }
      if (!memcmp(name, "OP_TLS_D5_BU", 12)) {
      /*                             G      */
        
#ifdef SSL_OP_TLS_D5_BUG
        return SSL_OP_TLS_D5_BUG;
#else
        goto not_there;
#endif

      }
      break;
    case 'L':
      if (!memcmp(name, "ERROR_SYSCAL", 12)) {
      /*                             L      */
        
#ifdef SSL_ERROR_SYSCALL
        return SSL_ERROR_SYSCALL;
#else
        goto not_there;
#endif

      }
      break;
    case 'N':
      if (!memcmp(name, "SENT_SHUTDOW", 12)) {
      /*                             N      */
        
#ifdef SSL_SENT_SHUTDOWN
        return SSL_SENT_SHUTDOWN;
#else
        goto not_there;
#endif

      }
      if (!memcmp(name, "XN_FLAG_FN_L", 12)) {
      /*                             N      */
        
#ifdef XN_FLAG_FN_LN
        return XN_FLAG_FN_LN;
#else
        goto not_there;
#endif

      }
      if (!memcmp(name, "XN_FLAG_FN_S", 12)) {
      /*                             N      */
        
#ifdef XN_FLAG_FN_SN
        return XN_FLAG_FN_SN;
#else
        goto not_there;
#endif

      }
      break;
    case 'T':
      if (!memcmp(name, "CB_READ_ALER", 12)) {
      /*                             T      */
        
#ifdef SSL_CB_READ_ALERT
        return SSL_CB_READ_ALERT;
#else
        goto not_there;
#endif

      }
      break;
    case 'V':
      if (!memcmp(name, "MBSTRING_UNI", 12)) {
      /*                             V      */
        
#ifdef MBSTRING_UNIV
        return MBSTRING_UNIV;
#else
        goto not_there;
#endif

      }
      break;
    case 'b':
      if (!memcmp(name, "NID_cast5_ec", 12)) {
      /*                             b      */
        
#ifdef NID_cast5_ecb
        return NID_cast5_ecb;
#else
        goto not_there;
#endif

      }
      break;
    case 'c':
      if (!memcmp(name, "NID_cast5_cb", 12)) {
      /*                             c      */
        
#ifdef NID_cast5_cbc
        return NID_cast5_cbc;
#else
        goto not_there;
#endif

      }
      break;
    case 'e':
      if (!memcmp(name, "NID_givenNam", 12)) {
      /*                             e      */
        
#ifdef NID_givenName
        return NID_givenName;
#else
        goto not_there;
#endif

      }
      if (!memcmp(name, "NID_key_usag", 12)) {
      /*                             e      */
        
#ifdef NID_key_usage
        return NID_key_usage;
#else
        goto not_there;
#endif

      }
      break;
    case 'g':
      if (!memcmp(name, "NID_secretBa", 12)) {
      /*                             g      */
        
#ifdef NID_secretBag
        return NID_secretBag;
#else
        goto not_there;
#endif

      }
      break;
    case 'l':
      if (!memcmp(name, "NID_delta_cr", 12)) {
      /*                             l      */
        
#ifdef NID_delta_crl
        return NID_delta_crl;
#else
        goto not_there;
#endif

      }
      break;
    case 'm':
      if (!memcmp(name, "NID_algorith", 12)) {
      /*                             m      */
        
#ifdef NID_algorithm
        return NID_algorithm;
#else
        goto not_there;
#endif

      }
      break;
    case 'n':
      if (!memcmp(name, "NID_OCSP_sig", 12)) {
      /*                             n      */
        
#ifdef NID_OCSP_sign
        return NID_OCSP_sign;
#else
        goto not_there;
#endif

      }
      if (!memcmp(name, "NID_code_sig", 12)) {
      /*                             n      */
        
#ifdef NID_code_sign
        return NID_code_sign;
#else
        goto not_there;
#endif

      }
      break;
    case 's':
      if (!memcmp(name, "NID_id_qt_cp", 12)) {
      /*                             s      */
        
#ifdef NID_id_qt_cps
        return NID_id_qt_cps;
#else
        goto not_there;
#endif

      }
      break;
    }
    break;
  case 14:
    /* Names all of length 14.  */
    /* CB_ACCEPT_EXIT CB_ACCEPT_LOOP CB_WRITE_ALERT F_CLIENT_HELLO
       F_SERVER_HELLO F_SSL_CERT_NEW NID_commonName NID_crl_number
       NID_crl_reason NID_dsaWithSHA NID_idea_cfb64 NID_idea_ofb64
       NID_localKeyID NID_md5WithRSA NID_ms_ext_req NID_pkcs7_data
       NID_rc2_40_cbc NID_rc2_64_cbc NID_time_stamp R_BAD_CHECKSUM
       R_NO_PUBLICKEY R_NULL_SSL_CTX ST_READ_HEADER X509_TRUST_TSA
       XN_FLAG_COMPAT XN_FLAG_DN_REV XN_FLAG_FN_OID XN_FLAG_SPC_EQ */
    /* Offset 9 gives the best switch position.  */
    switch (name[9]) {
    case '0':
      if (!memcmp(name, "NID_rc2_40_cbc", 14)) {
      /*                          ^           */
        
#ifdef NID_rc2_40_cbc
        return NID_rc2_40_cbc;
#else
        goto not_there;
#endif

      }
      break;
    case '4':
      if (!memcmp(name, "NID_rc2_64_cbc", 14)) {
      /*                          ^           */
        
#ifdef NID_rc2_64_cbc
        return NID_rc2_64_cbc;
#else
        goto not_there;
#endif

      }
      break;
    case 'A':
      if (!memcmp(name, "CB_WRITE_ALERT", 14)) {
      /*                          ^           */
        
#ifdef SSL_CB_WRITE_ALERT
        return SSL_CB_WRITE_ALERT;
#else
        goto not_there;
#endif

      }
      break;
    case 'C':
      if (!memcmp(name, "R_BAD_CHECKSUM", 14)) {
      /*                          ^           */
        
#ifdef SSL_R_BAD_CHECKSUM
        return SSL_R_BAD_CHECKSUM;
#else
        goto not_there;
#endif

      }
      break;
    case 'E':
      if (!memcmp(name, "ST_READ_HEADER", 14)) {
      /*                          ^           */
        
#ifdef SSL_ST_READ_HEADER
        return SSL_ST_READ_HEADER;
#else
        goto not_there;
#endif

      }
      break;
    case 'H':
      if (!memcmp(name, "F_CLIENT_HELLO", 14)) {
      /*                          ^           */
        
#ifdef SSL_F_CLIENT_HELLO
        return SSL_F_CLIENT_HELLO;
#else
        goto not_there;
#endif

      }
      if (!memcmp(name, "F_SERVER_HELLO", 14)) {
      /*                          ^           */
        
#ifdef SSL_F_SERVER_HELLO
        return SSL_F_SERVER_HELLO;
#else
        goto not_there;
#endif

      }
      break;
    case 'I':
      if (!memcmp(name, "R_NO_PUBLICKEY", 14)) {
      /*                          ^           */
        
#ifdef SSL_R_NO_PUBLICKEY
        return SSL_R_NO_PUBLICKEY;
#else
        goto not_there;
#endif

      }
      break;
    case 'K':
      if (!memcmp(name, "NID_localKeyID", 14)) {
      /*                          ^           */
        
#ifdef NID_localKeyID
        return NID_localKeyID;
#else
        goto not_there;
#endif

      }
      break;
    case 'L':
      if (!memcmp(name, "R_NULL_SSL_CTX", 14)) {
      /*                          ^           */
        
#ifdef SSL_R_NULL_SSL_CTX
        return SSL_R_NULL_SSL_CTX;
#else
        goto not_there;
#endif

      }
      break;
    case 'N':
      if (!memcmp(name, "XN_FLAG_DN_REV", 14)) {
      /*                          ^           */
        
#ifdef XN_FLAG_DN_REV
        return XN_FLAG_DN_REV;
#else
        goto not_there;
#endif

      }
      if (!memcmp(name, "XN_FLAG_FN_OID", 14)) {
      /*                          ^           */
        
#ifdef XN_FLAG_FN_OID
        return XN_FLAG_FN_OID;
#else
        goto not_there;
#endif

      }
      break;
    case 'O':
      if (!memcmp(name, "XN_FLAG_COMPAT", 14)) {
      /*                          ^           */
        
#ifdef XN_FLAG_COMPAT
        return XN_FLAG_COMPAT;
#else
        goto not_there;
#endif

      }
      break;
    case 'P':
      if (!memcmp(name, "XN_FLAG_SPC_EQ", 14)) {
      /*                          ^           */
        
#ifdef XN_FLAG_SPC_EQ
        return XN_FLAG_SPC_EQ;
#else
        goto not_there;
#endif

      }
      break;
    case 'T':
      if (!memcmp(name, "F_SSL_CERT_NEW", 14)) {
      /*                          ^           */
        
#ifdef SSL_F_SSL_CERT_NEW
        return SSL_F_SSL_CERT_NEW;
#else
        goto not_there;
#endif

      }
      if (!memcmp(name, "X509_TRUST_TSA", 14)) {
      /*                          ^           */
        
#ifdef X509_TRUST_TSA
        return X509_TRUST_TSA;
#else
        goto not_there;
#endif

      }
      break;
    case '_':
      if (!memcmp(name, "CB_ACCEPT_EXIT", 14)) {
      /*                          ^           */
        
#ifdef SSL_CB_ACCEPT_EXIT
        return SSL_CB_ACCEPT_EXIT;
#else
        goto not_there;
#endif

      }
      if (!memcmp(name, "CB_ACCEPT_LOOP", 14)) {
      /*                          ^           */
        
#ifdef SSL_CB_ACCEPT_LOOP
        return SSL_CB_ACCEPT_LOOP;
#else
        goto not_there;
#endif

      }
      if (!memcmp(name, "NID_pkcs7_data", 14)) {
      /*                          ^           */
        
#ifdef NID_pkcs7_data
        return NID_pkcs7_data;
#else
        goto not_there;
#endif

      }
      break;
    case 'c':
      if (!memcmp(name, "NID_idea_cfb64", 14)) {
      /*                          ^           */
        
#ifdef NID_idea_cfb64
        return NID_idea_cfb64;
#else
        goto not_there;
#endif

      }
      break;
    case 'e':
      if (!memcmp(name, "NID_crl_reason", 14)) {
      /*                          ^           */
        
#ifdef NID_crl_reason
        return NID_crl_reason;
#else
        goto not_there;
#endif

      }
      break;
    case 'n':
      if (!memcmp(name, "NID_commonName", 14)) {
      /*                          ^           */
        
#ifdef NID_commonName
        return NID_commonName;
#else
        goto not_there;
#endif

      }
      break;
    case 'o':
      if (!memcmp(name, "NID_idea_ofb64", 14)) {
      /*                          ^           */
        
#ifdef NID_idea_ofb64
        return NID_idea_ofb64;
#else
        goto not_there;
#endif

      }
      break;
    case 's':
      if (!memcmp(name, "NID_time_stamp", 14)) {
      /*                          ^           */
        
#ifdef NID_time_stamp
        return NID_time_stamp;
#else
        goto not_there;
#endif

      }
      break;
    case 't':
      if (!memcmp(name, "NID_dsaWithSHA", 14)) {
      /*                          ^           */
        
#ifdef NID_dsaWithSHA
        return NID_dsaWithSHA;
#else
        goto not_there;
#endif

      }
      if (!memcmp(name, "NID_md5WithRSA", 14)) {
      /*                          ^           */
        
#ifdef NID_md5WithRSA
        return NID_md5WithRSA;
#else
        goto not_there;
#endif

      }
      if (!memcmp(name, "NID_ms_ext_req", 14)) {
      /*                          ^           */
        
#ifdef NID_ms_ext_req
        return NID_ms_ext_req;
#else
        goto not_there;
#endif

      }
      break;
    case 'u':
      if (!memcmp(name, "NID_crl_number", 14)) {
      /*                          ^           */
        
#ifdef NID_crl_number
        return NID_crl_number;
#else
        goto not_there;
#endif

      }
      break;
    }
    break;
  case 15:
    /* Names all of length 15.  */
    /* CB_CONNECT_EXIT CB_CONNECT_LOOP ERROR_WANT_READ F_WRITE_PENDING
       MODE_AUTO_RETRY NID_cast5_cfb64 NID_cast5_ofb64 NID_client_auth
       NID_countryName NID_des_ede_cbc NID_description NID_dnQualifier
       NID_dsaWithSHA1 NID_info_access NID_mdc2WithRSA NID_ms_code_com
       NID_ms_code_ind NID_ms_ctl_sign NID_server_auth NID_sha1WithRSA
       OP_NO_QUERY_MTU R_NO_PRIVATEKEY R_UNKNOWN_STATE XN_FLAG_FN_MASK
       XN_FLAG_FN_NONE XN_FLAG_ONELINE XN_FLAG_RFC2253 */
    /* Offset 14 gives the best switch position.  */
    switch (name[14]) {
    case '1':
      if (!memcmp(name, "NID_dsaWithSHA", 14)) {
      /*                               1      */
        
#ifdef NID_dsaWithSHA1
        return NID_dsaWithSHA1;
#else
        goto not_there;
#endif

      }
      break;
    case '3':
      if (!memcmp(name, "XN_FLAG_RFC225", 14)) {
      /*                               3      */
        
#ifdef XN_FLAG_RFC2253
        return XN_FLAG_RFC2253;
#else
        goto not_there;
#endif

      }
      break;
    case '4':
      if (!memcmp(name, "NID_cast5_cfb6", 14)) {
      /*                               4      */
        
#ifdef NID_cast5_cfb64
        return NID_cast5_cfb64;
#else
        goto not_there;
#endif

      }
      if (!memcmp(name, "NID_cast5_ofb6", 14)) {
      /*                               4      */
        
#ifdef NID_cast5_ofb64
        return NID_cast5_ofb64;
#else
        goto not_there;
#endif

      }
      break;
    case 'A':
      if (!memcmp(name, "NID_mdc2WithRS", 14)) {
      /*                               A      */
        
#ifdef NID_mdc2WithRSA
        return NID_mdc2WithRSA;
#else
        goto not_there;
#endif

      }
      if (!memcmp(name, "NID_sha1WithRS", 14)) {
      /*                               A      */
        
#ifdef NID_sha1WithRSA
        return NID_sha1WithRSA;
#else
        goto not_there;
#endif

      }
      break;
    case 'D':
      if (!memcmp(name, "ERROR_WANT_REA", 14)) {
      /*                               D      */
        
#ifdef SSL_ERROR_WANT_READ
        return SSL_ERROR_WANT_READ;
#else
        goto not_there;
#endif

      }
      break;
    case 'E':
      if (!memcmp(name, "R_UNKNOWN_STAT", 14)) {
      /*                               E      */
        
#ifdef SSL_R_UNKNOWN_STATE
        return SSL_R_UNKNOWN_STATE;
#else
        goto not_there;
#endif

      }
      if (!memcmp(name, "XN_FLAG_FN_NON", 14)) {
      /*                               E      */
        
#ifdef XN_FLAG_FN_NONE
        return XN_FLAG_FN_NONE;
#else
        goto not_there;
#endif

      }
      if (!memcmp(name, "XN_FLAG_ONELIN", 14)) {
      /*                               E      */
        
#ifdef XN_FLAG_ONELINE
        return XN_FLAG_ONELINE;
#else
        goto not_there;
#endif

      }
      break;
    case 'G':
      if (!memcmp(name, "F_WRITE_PENDIN", 14)) {
      /*                               G      */
        
#ifdef SSL_F_WRITE_PENDING
        return SSL_F_WRITE_PENDING;
#else
        goto not_there;
#endif

      }
      break;
    case 'K':
      if (!memcmp(name, "XN_FLAG_FN_MAS", 14)) {
      /*                               K      */
        
#ifdef XN_FLAG_FN_MASK
        return XN_FLAG_FN_MASK;
#else
        goto not_there;
#endif

      }
      break;
    case 'P':
      if (!memcmp(name, "CB_CONNECT_LOO", 14)) {
      /*                               P      */
        
#ifdef SSL_CB_CONNECT_LOOP
        return SSL_CB_CONNECT_LOOP;
#else
        goto not_there;
#endif

      }
      break;
    case 'T':
      if (!memcmp(name, "CB_CONNECT_EXI", 14)) {
      /*                               T      */
        
#ifdef SSL_CB_CONNECT_EXIT
        return SSL_CB_CONNECT_EXIT;
#else
        goto not_there;
#endif

      }
      break;
    case 'U':
      if (!memcmp(name, "OP_NO_QUERY_MT", 14)) {
      /*                               U      */
        
#ifdef SSL_OP_NO_QUERY_MTU
        return SSL_OP_NO_QUERY_MTU;
#else
        goto not_there;
#endif

      }
      break;
    case 'Y':
      if (!memcmp(name, "MODE_AUTO_RETR", 14)) {
      /*                               Y      */
        
#ifdef SSL_MODE_AUTO_RETRY
        return SSL_MODE_AUTO_RETRY;
#else
        goto not_there;
#endif

      }
      if (!memcmp(name, "R_NO_PRIVATEKE", 14)) {
      /*                               Y      */
        
#ifdef SSL_R_NO_PRIVATEKEY
        return SSL_R_NO_PRIVATEKEY;
#else
        goto not_there;
#endif

      }
      break;
    case 'c':
      if (!memcmp(name, "NID_des_ede_cb", 14)) {
      /*                               c      */
        
#ifdef NID_des_ede_cbc
        return NID_des_ede_cbc;
#else
        goto not_there;
#endif

      }
      break;
    case 'd':
      if (!memcmp(name, "NID_ms_code_in", 14)) {
      /*                               d      */
        
#ifdef NID_ms_code_ind
        return NID_ms_code_ind;
#else
        goto not_there;
#endif

      }
      break;
    case 'e':
      if (!memcmp(name, "NID_countryNam", 14)) {
      /*                               e      */
        
#ifdef NID_countryName
        return NID_countryName;
#else
        goto not_there;
#endif

      }
      break;
    case 'h':
      if (!memcmp(name, "NID_client_aut", 14)) {
      /*                               h      */
        
#ifdef NID_client_auth
        return NID_client_auth;
#else
        goto not_there;
#endif

      }
      if (!memcmp(name, "NID_server_aut", 14)) {
      /*                               h      */
        
#ifdef NID_server_auth
        return NID_server_auth;
#else
        goto not_there;
#endif

      }
      break;
    case 'm':
      if (!memcmp(name, "NID_ms_code_co", 14)) {
      /*                               m      */
        
#ifdef NID_ms_code_com
        return NID_ms_code_com;
#else
        goto not_there;
#endif

      }
      break;
    case 'n':
      if (!memcmp(name, "NID_descriptio", 14)) {
      /*                               n      */
        
#ifdef NID_description
        return NID_description;
#else
        goto not_there;
#endif

      }
      if (!memcmp(name, "NID_ms_ctl_sig", 14)) {
      /*                               n      */
        
#ifdef NID_ms_ctl_sign
        return NID_ms_ctl_sign;
#else
        goto not_there;
#endif

      }
      break;
    case 'r':
      if (!memcmp(name, "NID_dnQualifie", 14)) {
      /*                               r      */
        
#ifdef NID_dnQualifier
        return NID_dnQualifier;
#else
        goto not_there;
#endif

      }
      break;
    case 's':
      if (!memcmp(name, "NID_info_acces", 14)) {
      /*                               s      */
        
#ifdef NID_info_access
        return NID_info_access;
#else
        goto not_there;
#endif

      }
      break;
    }
    break;
  case 16:
    /* Names all of length 16.  */
    /* ERROR_WANT_WRITE NID_des_ede3_cbc NID_friendlyName NID_hmacWithSHA1
       NID_localityName NID_pkcs7_digest NID_pkcs7_signed NID_serialNumber
       OP_EPHEMERAL_RSA OP_PKCS1_CHECK_1 OP_PKCS1_CHECK_2 OP_SINGLE_DH_USE
       R_BAD_MAC_DECODE R_NO_CIPHER_LIST X509_PURPOSE_ANY X509_TRUST_EMAIL
       XN_FLAG_FN_ALIGN XN_FLAG_SEP_MASK */
    /* Offset 8 gives the best switch position.  */
    switch (name[8]) {
    case '7':
      if (!memcmp(name, "NID_pkcs7_digest", 16)) {
      /*                         ^              */
        
#ifdef NID_pkcs7_digest
        return NID_pkcs7_digest;
#else
        goto not_there;
#endif

      }
      if (!memcmp(name, "NID_pkcs7_signed", 16)) {
      /*                         ^              */
        
#ifdef NID_pkcs7_signed
        return NID_pkcs7_signed;
#else
        goto not_there;
#endif

      }
      break;
    case 'C':
      if (!memcmp(name, "R_BAD_MAC_DECODE", 16)) {
      /*                         ^              */
        
#ifdef SSL_R_BAD_MAC_DECODE
        return SSL_R_BAD_MAC_DECODE;
#else
        goto not_there;
#endif

      }
      break;
    case 'E':
      if (!memcmp(name, "OP_EPHEMERAL_RSA", 16)) {
      /*                         ^              */
        
#ifdef SSL_OP_EPHEMERAL_RSA
        return SSL_OP_EPHEMERAL_RSA;
#else
        goto not_there;
#endif

      }
      if (!memcmp(name, "OP_SINGLE_DH_USE", 16)) {
      /*                         ^              */
        
#ifdef SSL_OP_SINGLE_DH_USE
        return SSL_OP_SINGLE_DH_USE;
#else
        goto not_there;
#endif

      }
      break;
    case 'F':
      if (!memcmp(name, "XN_FLAG_FN_ALIGN", 16)) {
      /*                         ^              */
        
#ifdef XN_FLAG_FN_ALIGN
        return XN_FLAG_FN_ALIGN;
#else
        goto not_there;
#endif

      }
      break;
    case 'H':
      if (!memcmp(name, "R_NO_CIPHER_LIST", 16)) {
      /*                         ^              */
        
#ifdef SSL_R_NO_CIPHER_LIST
        return SSL_R_NO_CIPHER_LIST;
#else
        goto not_there;
#endif

      }
      break;
    case 'N':
      if (!memcmp(name, "ERROR_WANT_WRITE", 16)) {
      /*                         ^              */
        
#ifdef SSL_ERROR_WANT_WRITE
        return SSL_ERROR_WANT_WRITE;
#else
        goto not_there;
#endif

      }
      break;
    case 'P':
      if (!memcmp(name, "X509_PURPOSE_ANY", 16)) {
      /*                         ^              */
        
#ifdef X509_PURPOSE_ANY
        return X509_PURPOSE_ANY;
#else
        goto not_there;
#endif

      }
      break;
    case 'S':
      if (!memcmp(name, "X509_TRUST_EMAIL", 16)) {
      /*                         ^              */
        
#ifdef X509_TRUST_EMAIL
        return X509_TRUST_EMAIL;
#else
        goto not_there;
#endif

      }
      if (!memcmp(name, "XN_FLAG_SEP_MASK", 16)) {
      /*                         ^              */
        
#ifdef XN_FLAG_SEP_MASK
        return XN_FLAG_SEP_MASK;
#else
        goto not_there;
#endif

      }
      break;
    case 'W':
      if (!memcmp(name, "NID_hmacWithSHA1", 16)) {
      /*                         ^              */
        
#ifdef NID_hmacWithSHA1
        return NID_hmacWithSHA1;
#else
        goto not_there;
#endif

      }
      break;
    case '_':
      if (!memcmp(name, "OP_PKCS1_CHECK_1", 16)) {
      /*                         ^              */
        
#ifdef SSL_OP_PKCS1_CHECK_1
        return SSL_OP_PKCS1_CHECK_1;
#else
        goto not_there;
#endif

      }
      if (!memcmp(name, "OP_PKCS1_CHECK_2", 16)) {
      /*                         ^              */
        
#ifdef SSL_OP_PKCS1_CHECK_2
        return SSL_OP_PKCS1_CHECK_2;
#else
        goto not_there;
#endif

      }
      break;
    case 'a':
      if (!memcmp(name, "NID_serialNumber", 16)) {
      /*                         ^              */
        
#ifdef NID_serialNumber
        return NID_serialNumber;
#else
        goto not_there;
#endif

      }
      break;
    case 'e':
      if (!memcmp(name, "NID_des_ede3_cbc", 16)) {
      /*                         ^              */
        
#ifdef NID_des_ede3_cbc
        return NID_des_ede3_cbc;
#else
        goto not_there;
#endif

      }
      break;
    case 'l':
      if (!memcmp(name, "NID_localityName", 16)) {
      /*                         ^              */
        
#ifdef NID_localityName
        return NID_localityName;
#else
        goto not_there;
#endif

      }
      break;
    case 'n':
      if (!memcmp(name, "NID_friendlyName", 16)) {
      /*                         ^              */
        
#ifdef NID_friendlyName
        return NID_friendlyName;
#else
        goto not_there;
#endif

      }
      break;
    }
    break;
  case 17:
    /* Names all of length 17.  */
    /* CB_HANDSHAKE_DONE ERROR_WANT_ACCEPT ERROR_ZERO_RETURN F_D2I_SSL_SESSION
       F_I2D_SSL_SESSION F_SSL_SESSION_NEW NID_ad_ca_issuers NID_des_ede_cfb64
       NID_des_ede_ofb64 NID_dsaWithSHA1_2 NID_email_protect NID_ext_key_usage
       NID_id_qt_unotice NID_rsaEncryption OP_NO_COMPRESSION RECEIVED_SHUTDOWN
       R_BAD_WRITE_RETRY R_NO_CIPHER_MATCH X509_TRUST_COMPAT XN_FLAG_MULTILINE
       */
    /* Offset 8 gives the best switch position.  */
    switch (name[8]) {
    case 'H':
      if (!memcmp(name, "CB_HANDSHAKE_DONE", 17)) {
      /*                         ^               */
        
#ifdef SSL_CB_HANDSHAKE_DONE
        return SSL_CB_HANDSHAKE_DONE;
#else
        goto not_there;
#endif

      }
      if (!memcmp(name, "R_NO_CIPHER_MATCH", 17)) {
      /*                         ^               */
        
#ifdef SSL_R_NO_CIPHER_MATCH
        return SSL_R_NO_CIPHER_MATCH;
#else
        goto not_there;
#endif

      }
      break;
    case 'I':
      if (!memcmp(name, "R_BAD_WRITE_RETRY", 17)) {
      /*                         ^               */
        
#ifdef SSL_R_BAD_WRITE_RETRY
        return SSL_R_BAD_WRITE_RETRY;
#else
        goto not_there;
#endif

      }
      break;
    case 'L':
      if (!memcmp(name, "F_D2I_SSL_SESSION", 17)) {
      /*                         ^               */
        
#ifdef SSL_F_D2I_SSL_SESSION
        return SSL_F_D2I_SSL_SESSION;
#else
        goto not_there;
#endif

      }
      if (!memcmp(name, "F_I2D_SSL_SESSION", 17)) {
      /*                         ^               */
        
#ifdef SSL_F_I2D_SSL_SESSION
        return SSL_F_I2D_SSL_SESSION;
#else
        goto not_there;
#endif

      }
      break;
    case 'M':
      if (!memcmp(name, "OP_NO_COMPRESSION", 17)) {
      /*                         ^               */
        
#ifdef SSL_OP_NO_COMPRESSION
        return SSL_OP_NO_COMPRESSION;
#else
        goto not_there;
#endif

      }
      if (!memcmp(name, "XN_FLAG_MULTILINE", 17)) {
      /*                         ^               */
        
#ifdef XN_FLAG_MULTILINE
        return XN_FLAG_MULTILINE;
#else
        goto not_there;
#endif

      }
      break;
    case 'N':
      if (!memcmp(name, "ERROR_WANT_ACCEPT", 17)) {
      /*                         ^               */
        
#ifdef SSL_ERROR_WANT_ACCEPT
        return SSL_ERROR_WANT_ACCEPT;
#else
        goto not_there;
#endif

      }
      break;
    case 'R':
      if (!memcmp(name, "ERROR_ZERO_RETURN", 17)) {
      /*                         ^               */
        
#ifdef SSL_ERROR_ZERO_RETURN
        return SSL_ERROR_ZERO_RETURN;
#else
        goto not_there;
#endif

      }
      break;
    case 'S':
      if (!memcmp(name, "F_SSL_SESSION_NEW", 17)) {
      /*                         ^               */
        
#ifdef SSL_F_SSL_SESSION_NEW
        return SSL_F_SSL_SESSION_NEW;
#else
        goto not_there;
#endif

      }
      if (!memcmp(name, "X509_TRUST_COMPAT", 17)) {
      /*                         ^               */
        
#ifdef X509_TRUST_COMPAT
        return X509_TRUST_COMPAT;
#else
        goto not_there;
#endif

      }
      break;
    case '_':
      if (!memcmp(name, "RECEIVED_SHUTDOWN", 17)) {
      /*                         ^               */
        
#ifdef SSL_RECEIVED_SHUTDOWN
        return SSL_RECEIVED_SHUTDOWN;
#else
        goto not_there;
#endif

      }
      break;
    case 'a':
      if (!memcmp(name, "NID_ad_ca_issuers", 17)) {
      /*                         ^               */
        
#ifdef NID_ad_ca_issuers
        return NID_ad_ca_issuers;
#else
        goto not_there;
#endif

      }
      break;
    case 'e':
      if (!memcmp(name, "NID_des_ede_cfb64", 17)) {
      /*                         ^               */
        
#ifdef NID_des_ede_cfb64
        return NID_des_ede_cfb64;
#else
        goto not_there;
#endif

      }
      if (!memcmp(name, "NID_des_ede_ofb64", 17)) {
      /*                         ^               */
        
#ifdef NID_des_ede_ofb64
        return NID_des_ede_ofb64;
#else
        goto not_there;
#endif

      }
      break;
    case 'i':
      if (!memcmp(name, "NID_dsaWithSHA1_2", 17)) {
      /*                         ^               */
        
#ifdef NID_dsaWithSHA1_2
        return NID_dsaWithSHA1_2;
#else
        goto not_there;
#endif

      }
      break;
    case 'k':
      if (!memcmp(name, "NID_ext_key_usage", 17)) {
      /*                         ^               */
        
#ifdef NID_ext_key_usage
        return NID_ext_key_usage;
#else
        goto not_there;
#endif

      }
      break;
    case 'l':
      if (!memcmp(name, "NID_email_protect", 17)) {
      /*                         ^               */
        
#ifdef NID_email_protect
        return NID_email_protect;
#else
        goto not_there;
#endif

      }
      break;
    case 'n':
      if (!memcmp(name, "NID_rsaEncryption", 17)) {
      /*                         ^               */
        
#ifdef NID_rsaEncryption
        return NID_rsaEncryption;
#else
        goto not_there;
#endif

      }
      break;
    case 't':
      if (!memcmp(name, "NID_id_qt_unotice", 17)) {
      /*                         ^               */
        
#ifdef NID_id_qt_unotice
        return NID_id_qt_unotice;
#else
        goto not_there;
#endif

      }
      break;
    }
    break;
  case 18:
    /* Names all of length 18.  */
    /* CB_HANDSHAKE_START ERROR_WANT_CONNECT F_GET_CLIENT_HELLO
       F_GET_SERVER_HELLO NID_des_ede3_cfb64 NID_des_ede3_ofb64
       NID_dhKeyAgreement OP_COOKIE_EXCHANGE OP_SINGLE_ECDH_USE
       R_BAD_SSL_FILETYPE VERIFY_CLIENT_ONCE */
    /* Offset 11 gives the best switch position.  */
    switch (name[11]) {
    case '3':
      if (!memcmp(name, "NID_des_ede3_cfb64", 18)) {
      /*                            ^             */
        
#ifdef NID_des_ede3_cfb64
        return NID_des_ede3_cfb64;
#else
        goto not_there;
#endif

      }
      if (!memcmp(name, "NID_des_ede3_ofb64", 18)) {
      /*                            ^             */
        
#ifdef NID_des_ede3_ofb64
        return NID_des_ede3_ofb64;
#else
        goto not_there;
#endif

      }
      break;
    case 'C':
      if (!memcmp(name, "ERROR_WANT_CONNECT", 18)) {
      /*                            ^             */
        
#ifdef SSL_ERROR_WANT_CONNECT
        return SSL_ERROR_WANT_CONNECT;
#else
        goto not_there;
#endif

      }
      if (!memcmp(name, "OP_SINGLE_ECDH_USE", 18)) {
      /*                            ^             */
        
#ifdef SSL_OP_SINGLE_ECDH_USE
        return SSL_OP_SINGLE_ECDH_USE;
#else
        goto not_there;
#endif

      }
      break;
    case 'E':
      if (!memcmp(name, "CB_HANDSHAKE_START", 18)) {
      /*                            ^             */
        
#ifdef SSL_CB_HANDSHAKE_START
        return SSL_CB_HANDSHAKE_START;
#else
        goto not_there;
#endif

      }
      break;
    case 'I':
      if (!memcmp(name, "R_BAD_SSL_FILETYPE", 18)) {
      /*                            ^             */
        
#ifdef SSL_R_BAD_SSL_FILETYPE
        return SSL_R_BAD_SSL_FILETYPE;
#else
        goto not_there;
#endif

      }
      break;
    case 'N':
      if (!memcmp(name, "VERIFY_CLIENT_ONCE", 18)) {
      /*                            ^             */
        
#ifdef SSL_VERIFY_CLIENT_ONCE
        return SSL_VERIFY_CLIENT_ONCE;
#else
        goto not_there;
#endif

      }
      break;
    case 'R':
      if (!memcmp(name, "F_GET_SERVER_HELLO", 18)) {
      /*                            ^             */
        
#ifdef SSL_F_GET_SERVER_HELLO
        return SSL_F_GET_SERVER_HELLO;
#else
        goto not_there;
#endif

      }
      break;
    case 'T':
      if (!memcmp(name, "F_GET_CLIENT_HELLO", 18)) {
      /*                            ^             */
        
#ifdef SSL_F_GET_CLIENT_HELLO
        return SSL_F_GET_CLIENT_HELLO;
#else
        goto not_there;
#endif

      }
      break;
    case 'X':
      if (!memcmp(name, "OP_COOKIE_EXCHANGE", 18)) {
      /*                            ^             */
        
#ifdef SSL_OP_COOKIE_EXCHANGE
        return SSL_OP_COOKIE_EXCHANGE;
#else
        goto not_there;
#endif

      }
      break;
    case 'r':
      if (!memcmp(name, "NID_dhKeyAgreement", 18)) {
      /*                            ^             */
        
#ifdef NID_dhKeyAgreement
        return NID_dhKeyAgreement;
#else
        goto not_there;
#endif

      }
      break;
    }
    break;
  case 19:
    /* Names all of length 19.  */
    /* F_CLIENT_MASTER_KEY F_GET_SERVER_VERIFY NID_invalidity_date
       NID_issuer_alt_name NID_pkcs7_encrypted NID_pkcs7_enveloped
       NID_rle_compression NID_safeContentsBag NID_sdsiCertificate
       NID_x509Certificate OP_CISCO_ANYCONNECT OP_NON_EXPORT_FIRST
       OP_TLS_ROLLBACK_BUG */
    /* Offset 10 gives the best switch position.  */
    switch (name[10]) {
    case 'A':
      if (!memcmp(name, "F_CLIENT_MASTER_KEY", 19)) {
      /*                           ^               */
        
#ifdef SSL_F_CLIENT_MASTER_KEY
        return SSL_F_CLIENT_MASTER_KEY;
#else
        goto not_there;
#endif

      }
      break;
    case 'E':
      if (!memcmp(name, "F_GET_SERVER_VERIFY", 19)) {
      /*                           ^               */
        
#ifdef SSL_F_GET_SERVER_VERIFY
        return SSL_F_GET_SERVER_VERIFY;
#else
        goto not_there;
#endif

      }
      break;
    case 'L':
      if (!memcmp(name, "OP_TLS_ROLLBACK_BUG", 19)) {
      /*                           ^               */
        
#ifdef SSL_OP_TLS_ROLLBACK_BUG
        return SSL_OP_TLS_ROLLBACK_BUG;
#else
        goto not_there;
#endif

      }
      break;
    case 'N':
      if (!memcmp(name, "OP_CISCO_ANYCONNECT", 19)) {
      /*                           ^               */
        
#ifdef SSL_OP_CISCO_ANYCONNECT
        return SSL_OP_CISCO_ANYCONNECT;
#else
        goto not_there;
#endif

      }
      break;
    case 'O':
      if (!memcmp(name, "OP_NON_EXPORT_FIRST", 19)) {
      /*                           ^               */
        
#ifdef SSL_OP_NON_EXPORT_FIRST
        return SSL_OP_NON_EXPORT_FIRST;
#else
        goto not_there;
#endif

      }
      break;
    case '_':
      if (!memcmp(name, "NID_issuer_alt_name", 19)) {
      /*                           ^               */
        
#ifdef NID_issuer_alt_name
        return NID_issuer_alt_name;
#else
        goto not_there;
#endif

      }
      break;
    case 'd':
      if (!memcmp(name, "NID_invalidity_date", 19)) {
      /*                           ^               */
        
#ifdef NID_invalidity_date
        return NID_invalidity_date;
#else
        goto not_there;
#endif

      }
      break;
    case 'e':
      if (!memcmp(name, "NID_pkcs7_encrypted", 19)) {
      /*                           ^               */
        
#ifdef NID_pkcs7_encrypted
        return NID_pkcs7_encrypted;
#else
        goto not_there;
#endif

      }
      if (!memcmp(name, "NID_pkcs7_enveloped", 19)) {
      /*                           ^               */
        
#ifdef NID_pkcs7_enveloped
        return NID_pkcs7_enveloped;
#else
        goto not_there;
#endif

      }
      break;
    case 'm':
      if (!memcmp(name, "NID_rle_compression", 19)) {
      /*                           ^               */
        
#ifdef NID_rle_compression
        return NID_rle_compression;
#else
        goto not_there;
#endif

      }
      break;
    case 'n':
      if (!memcmp(name, "NID_safeContentsBag", 19)) {
      /*                           ^               */
        
#ifdef NID_safeContentsBag
        return NID_safeContentsBag;
#else
        goto not_there;
#endif

      }
      break;
    case 'r':
      if (!memcmp(name, "NID_sdsiCertificate", 19)) {
      /*                           ^               */
        
#ifdef NID_sdsiCertificate
        return NID_sdsiCertificate;
#else
        goto not_there;
#endif

      }
      if (!memcmp(name, "NID_x509Certificate", 19)) {
      /*                           ^               */
        
#ifdef NID_x509Certificate
        return NID_x509Certificate;
#else
        goto not_there;
#endif

      }
      break;
    }
    break;
  case 20:
    /* Names all of length 20.  */
    /* ASN1_STRFLGS_ESC_MSB ASN1_STRFLGS_RFC2253 F_CLIENT_CERTIFICATE
       F_SSL_USE_PRIVATEKEY MODE_RELEASE_BUFFERS NID_netscape_comment
       NID_organizationName NID_ripemd160WithRSA NID_subject_alt_name
       NID_uniqueIdentifier NID_zlib_compression R_NO_CERTIFICATE_SET
       SESSION_ASN1_VERSION X509_TRUST_OCSP_SIGN */
    /* Offset 13 gives the best switch position.  */
    switch (name[13]) {
    case 'A':
      if (!memcmp(name, "R_NO_CERTIFICATE_SET", 20)) {
      /*                              ^             */
        
#ifdef SSL_R_NO_CERTIFICATE_SET
        return SSL_R_NO_CERTIFICATE_SET;
#else
        goto not_there;
#endif

      }
      break;
    case 'B':
      if (!memcmp(name, "MODE_RELEASE_BUFFERS", 20)) {
      /*                              ^             */
        
#ifdef SSL_MODE_RELEASE_BUFFERS
        return SSL_MODE_RELEASE_BUFFERS;
#else
        goto not_there;
#endif

      }
      break;
    case 'E':
      if (!memcmp(name, "ASN1_STRFLGS_ESC_MSB", 20)) {
      /*                              ^             */
        
#ifdef ASN1_STRFLGS_ESC_MSB
        return ASN1_STRFLGS_ESC_MSB;
#else
        goto not_there;
#endif

      }
      break;
    case 'I':
      if (!memcmp(name, "F_CLIENT_CERTIFICATE", 20)) {
      /*                              ^             */
        
#ifdef SSL_F_CLIENT_CERTIFICATE
        return SSL_F_CLIENT_CERTIFICATE;
#else
        goto not_there;
#endif

      }
      break;
    case 'R':
      if (!memcmp(name, "ASN1_STRFLGS_RFC2253", 20)) {
      /*                              ^             */
        
#ifdef ASN1_STRFLGS_RFC2253
        return ASN1_STRFLGS_RFC2253;
#else
        goto not_there;
#endif

      }
      break;
    case 'S':
      if (!memcmp(name, "X509_TRUST_OCSP_SIGN", 20)) {
      /*                              ^             */
        
#ifdef X509_TRUST_OCSP_SIGN
        return X509_TRUST_OCSP_SIGN;
#else
        goto not_there;
#endif

      }
      break;
    case 'V':
      if (!memcmp(name, "F_SSL_USE_PRIVATEKEY", 20)) {
      /*                              ^             */
        
#ifdef SSL_F_SSL_USE_PRIVATEKEY
        return SSL_F_SSL_USE_PRIVATEKEY;
#else
        goto not_there;
#endif

      }
      if (!memcmp(name, "SESSION_ASN1_VERSION", 20)) {
      /*                              ^             */
        
#ifdef SSL_SESSION_ASN1_VERSION
        return SSL_SESSION_ASN1_VERSION;
#else
        goto not_there;
#endif

      }
      break;
    case 'W':
      if (!memcmp(name, "NID_ripemd160WithRSA", 20)) {
      /*                              ^             */
        
#ifdef NID_ripemd160WithRSA
        return NID_ripemd160WithRSA;
#else
        goto not_there;
#endif

      }
      break;
    case 'c':
      if (!memcmp(name, "NID_netscape_comment", 20)) {
      /*                              ^             */
        
#ifdef NID_netscape_comment
        return NID_netscape_comment;
#else
        goto not_there;
#endif

      }
      break;
    case 'i':
      if (!memcmp(name, "NID_organizationName", 20)) {
      /*                              ^             */
        
#ifdef NID_organizationName
        return NID_organizationName;
#else
        goto not_there;
#endif

      }
      break;
    case 'l':
      if (!memcmp(name, "NID_subject_alt_name", 20)) {
      /*                              ^             */
        
#ifdef NID_subject_alt_name
        return NID_subject_alt_name;
#else
        goto not_there;
#endif

      }
      break;
    case 'n':
      if (!memcmp(name, "NID_uniqueIdentifier", 20)) {
      /*                              ^             */
        
#ifdef NID_uniqueIdentifier
        return NID_uniqueIdentifier;
#else
        goto not_there;
#endif

      }
      break;
    case 'r':
      if (!memcmp(name, "NID_zlib_compression", 20)) {
      /*                              ^             */
        
#ifdef NID_zlib_compression
        return NID_zlib_compression;
#else
        goto not_there;
#endif

      }
      break;
    }
    break;
  case 21:
    /* Names all of length 21.  */
    /* ASN1_STRFLGS_ESC_CTRL F_GET_CLIENT_FINISHED F_GET_SERVER_FINISHED
       F_REQUEST_CERTIFICATE F_SSL_GET_NEW_SESSION F_SSL_USE_CERTIFICATE
       NID_SMIMECapabilities NID_basic_constraints NID_netscape_base_url
       NID_pkcs9_contentType NID_pkcs9_signingTime OP_NETSCAPE_CA_DN_BUG
       X509_PURPOSE_CRL_SIGN X509_TRUST_SSL_CLIENT X509_TRUST_SSL_SERVER
       X509_V_FLAG_CRL_CHECK XN_FLAG_SEP_CPLUS_SPC XN_FLAG_SEP_MULTILINE
       XN_FLAG_SEP_SPLUS_SPC */
    /* Offset 15 gives the best switch position.  */
    switch (name[15]) {
    case 'C':
      if (!memcmp(name, "ASN1_STRFLGS_ESC_CTRL", 21)) {
      /*                                ^            */
        
#ifdef ASN1_STRFLGS_ESC_CTRL
        return ASN1_STRFLGS_ESC_CTRL;
#else
        goto not_there;
#endif

      }
      if (!memcmp(name, "X509_TRUST_SSL_CLIENT", 21)) {
      /*                                ^            */
        
#ifdef X509_TRUST_SSL_CLIENT
        return X509_TRUST_SSL_CLIENT;
#else
        goto not_there;
#endif

      }
      break;
    case 'D':
      if (!memcmp(name, "OP_NETSCAPE_CA_DN_BUG", 21)) {
      /*                                ^            */
        
#ifdef SSL_OP_NETSCAPE_CA_DN_BUG
        return SSL_OP_NETSCAPE_CA_DN_BUG;
#else
        goto not_there;
#endif

      }
      break;
    case 'E':
      if (!memcmp(name, "F_SSL_GET_NEW_SESSION", 21)) {
      /*                                ^            */
        
#ifdef SSL_F_SSL_GET_NEW_SESSION
        return SSL_F_SSL_GET_NEW_SESSION;
#else
        goto not_there;
#endif

      }
      break;
    case 'F':
      if (!memcmp(name, "F_REQUEST_CERTIFICATE", 21)) {
      /*                                ^            */
        
#ifdef SSL_F_REQUEST_CERTIFICATE
        return SSL_F_REQUEST_CERTIFICATE;
#else
        goto not_there;
#endif

      }
      if (!memcmp(name, "F_SSL_USE_CERTIFICATE", 21)) {
      /*                                ^            */
        
#ifdef SSL_F_SSL_USE_CERTIFICATE
        return SSL_F_SSL_USE_CERTIFICATE;
#else
        goto not_there;
#endif

      }
      break;
    case 'L':
      if (!memcmp(name, "X509_PURPOSE_CRL_SIGN", 21)) {
      /*                                ^            */
        
#ifdef X509_PURPOSE_CRL_SIGN
        return X509_PURPOSE_CRL_SIGN;
#else
        goto not_there;
#endif

      }
      break;
    case 'N':
      if (!memcmp(name, "F_GET_CLIENT_FINISHED", 21)) {
      /*                                ^            */
        
#ifdef SSL_F_GET_CLIENT_FINISHED
        return SSL_F_GET_CLIENT_FINISHED;
#else
        goto not_there;
#endif

      }
      if (!memcmp(name, "F_GET_SERVER_FINISHED", 21)) {
      /*                                ^            */
        
#ifdef SSL_F_GET_SERVER_FINISHED
        return SSL_F_GET_SERVER_FINISHED;
#else
        goto not_there;
#endif

      }
      break;
    case 'S':
      if (!memcmp(name, "X509_TRUST_SSL_SERVER", 21)) {
      /*                                ^            */
        
#ifdef X509_TRUST_SSL_SERVER
        return X509_TRUST_SSL_SERVER;
#else
        goto not_there;
#endif

      }
      break;
    case 'T':
      if (!memcmp(name, "XN_FLAG_SEP_MULTILINE", 21)) {
      /*                                ^            */
        
#ifdef XN_FLAG_SEP_MULTILINE
        return XN_FLAG_SEP_MULTILINE;
#else
        goto not_there;
#endif

      }
      break;
    case 'U':
      if (!memcmp(name, "XN_FLAG_SEP_CPLUS_SPC", 21)) {
      /*                                ^            */
        
#ifdef XN_FLAG_SEP_CPLUS_SPC
        return XN_FLAG_SEP_CPLUS_SPC;
#else
        goto not_there;
#endif

      }
      if (!memcmp(name, "XN_FLAG_SEP_SPLUS_SPC", 21)) {
      /*                                ^            */
        
#ifdef XN_FLAG_SEP_SPLUS_SPC
        return XN_FLAG_SEP_SPLUS_SPC;
#else
        goto not_there;
#endif

      }
      break;
    case '_':
      if (!memcmp(name, "X509_V_FLAG_CRL_CHECK", 21)) {
      /*                                ^            */
        
#ifdef X509_V_FLAG_CRL_CHECK
        return X509_V_FLAG_CRL_CHECK;
#else
        goto not_there;
#endif

      }
      break;
    case 'l':
      if (!memcmp(name, "NID_SMIMECapabilities", 21)) {
      /*                                ^            */
        
#ifdef NID_SMIMECapabilities
        return NID_SMIMECapabilities;
#else
        goto not_there;
#endif

      }
      break;
    case 'n':
      if (!memcmp(name, "NID_pkcs9_contentType", 21)) {
      /*                                ^            */
        
#ifdef NID_pkcs9_contentType
        return NID_pkcs9_contentType;
#else
        goto not_there;
#endif

      }
      if (!memcmp(name, "NID_pkcs9_signingTime", 21)) {
      /*                                ^            */
        
#ifdef NID_pkcs9_signingTime
        return NID_pkcs9_signingTime;
#else
        goto not_there;
#endif

      }
      break;
    case 'r':
      if (!memcmp(name, "NID_basic_constraints", 21)) {
      /*                                ^            */
        
#ifdef NID_basic_constraints
        return NID_basic_constraints;
#else
        goto not_there;
#endif

      }
      break;
    case 's':
      if (!memcmp(name, "NID_netscape_base_url", 21)) {
      /*                                ^            */
        
#ifdef NID_netscape_base_url
        return NID_netscape_base_url;
#else
        goto not_there;
#endif

      }
      break;
    }
    break;
  case 22:
    /* Names all of length 22.  */
    /* ASN1_STRFLGS_ESC_QUOTE ERROR_WANT_X509_LOOKUP F_SSL_SESSION_PRINT_FP
       NID_netscape_cert_type NID_netscape_data_type NID_pkcs9_emailAddress
       OPENSSL_VERSION_NUMBER R_PEER_ERROR_NO_CIPHER TLSEXT_STATUSTYPE_ocsp
       V_OCSP_CERTSTATUS_GOOD X509_TRUST_OBJECT_SIGN X509_V_FLAG_USE_DELTAS
       XN_FLAG_SEP_COMMA_PLUS _TEST_INVALID_CONSTANT */
    /* Offset 14 gives the best switch position.  */
    switch (name[14]) {
    case '9':
      if (!memcmp(name, "ERROR_WANT_X509_LOOKUP", 22)) {
      /*                               ^              */
        
#ifdef SSL_ERROR_WANT_X509_LOOKUP
        return SSL_ERROR_WANT_X509_LOOKUP;
#else
        goto not_there;
#endif

      }
      break;
    case 'C':
      if (!memcmp(name, "_TEST_INVALID_CONSTANT", 22)) {
      /*                               ^              */
        goto not_there;
      }
      break;
    case 'E':
      if (!memcmp(name, "X509_TRUST_OBJECT_SIGN", 22)) {
      /*                               ^              */
        
#ifdef X509_TRUST_OBJECT_SIGN
        return X509_TRUST_OBJECT_SIGN;
#else
        goto not_there;
#endif

      }
      if (!memcmp(name, "X509_V_FLAG_USE_DELTAS", 22)) {
      /*                               ^              */
        
#ifdef X509_V_FLAG_USE_DELTAS
        return X509_V_FLAG_USE_DELTAS;
#else
        goto not_there;
#endif

      }
      break;
    case 'M':
      if (!memcmp(name, "XN_FLAG_SEP_COMMA_PLUS", 22)) {
      /*                               ^              */
        
#ifdef XN_FLAG_SEP_COMMA_PLUS
        return XN_FLAG_SEP_COMMA_PLUS;
#else
        goto not_there;
#endif

      }
      break;
    case 'N':
      if (!memcmp(name, "OPENSSL_VERSION_NUMBER", 22)) {
      /*                               ^              */
        
#ifdef OPENSSL_VERSION_NUMBER
        return OPENSSL_VERSION_NUMBER;
#else
        goto not_there;
#endif

      }
      break;
    case 'O':
      if (!memcmp(name, "R_PEER_ERROR_NO_CIPHER", 22)) {
      /*                               ^              */
        
#ifdef SSL_R_PEER_ERROR_NO_CIPHER
        return SSL_R_PEER_ERROR_NO_CIPHER;
#else
        goto not_there;
#endif

      }
      break;
    case 'P':
      if (!memcmp(name, "F_SSL_SESSION_PRINT_FP", 22)) {
      /*                               ^              */
        
#ifdef SSL_F_SSL_SESSION_PRINT_FP
        return SSL_F_SSL_SESSION_PRINT_FP;
#else
        goto not_there;
#endif

      }
      break;
    case 'S':
      if (!memcmp(name, "ASN1_STRFLGS_ESC_QUOTE", 22)) {
      /*                               ^              */
        
#ifdef ASN1_STRFLGS_ESC_QUOTE
        return ASN1_STRFLGS_ESC_QUOTE;
#else
        goto not_there;
#endif

      }
      break;
    case 'T':
      if (!memcmp(name, "V_OCSP_CERTSTATUS_GOOD", 22)) {
      /*                               ^              */
        
#ifdef V_OCSP_CERTSTATUS_GOOD
        return V_OCSP_CERTSTATUS_GOOD;
#else
        goto not_there;
#endif

      }
      break;
    case 'Y':
      if (!memcmp(name, "TLSEXT_STATUSTYPE_ocsp", 22)) {
      /*                               ^              */
        
#ifdef TLSEXT_STATUSTYPE_ocsp
        return TLSEXT_STATUSTYPE_ocsp;
#else
        goto not_there;
#endif

      }
      break;
    case 'a':
      if (!memcmp(name, "NID_netscape_data_type", 22)) {
      /*                               ^              */
        
#ifdef NID_netscape_data_type
        return NID_netscape_data_type;
#else
        goto not_there;
#endif

      }
      break;
    case 'e':
      if (!memcmp(name, "NID_netscape_cert_type", 22)) {
      /*                               ^              */
        
#ifdef NID_netscape_cert_type
        return NID_netscape_cert_type;
#else
        goto not_there;
#endif

      }
      break;
    case 'l':
      if (!memcmp(name, "NID_pkcs9_emailAddress", 22)) {
      /*                               ^              */
        
#ifdef NID_pkcs9_emailAddress
        return NID_pkcs9_emailAddress;
#else
        goto not_there;
#endif

      }
      break;
    }
    break;
  case 23:
    /* Names all of length 23.  */
    /* F_GET_CLIENT_MASTER_KEY F_SSL_USE_RSAPRIVATEKEY LIBRESSL_VERSION_NUMBER
       NID_pkcs8ShroudedKeyBag NID_pkcs9_messageDigest NID_stateOrProvinceName
       OP_CRYPTOPRO_TLSEXT_BUG R_BAD_RESPONSE_ARGUMENT R_PUBLIC_KEY_IS_NOT_RSA
       X509_PURPOSE_SMIME_SIGN X509_PURPOSE_SSL_CLIENT X509_PURPOSE_SSL_SERVER
       X509_TRUST_OCSP_REQUEST X509_V_FLAG_INHIBIT_ANY X509_V_FLAG_INHIBIT_MAP
       X509_V_FLAG_POLICY_MASK X509_V_FLAG_X509_STRICT */
    /* Offset 17 gives the best switch position.  */
    switch (name[17]) {
    case 'A':
      if (!memcmp(name, "F_SSL_USE_RSAPRIVATEKEY", 23)) {
      /*                                  ^            */
        
#ifdef SSL_F_SSL_USE_RSAPRIVATEKEY
        return SSL_F_SSL_USE_RSAPRIVATEKEY;
#else
        goto not_there;
#endif

      }
      break;
    case 'C':
      if (!memcmp(name, "X509_PURPOSE_SSL_CLIENT", 23)) {
      /*                                  ^            */
        
#ifdef X509_PURPOSE_SSL_CLIENT
        return X509_PURPOSE_SSL_CLIENT;
#else
        goto not_there;
#endif

      }
      break;
    case 'D':
      if (!memcmp(name, "NID_pkcs9_messageDigest", 23)) {
      /*                                  ^            */
        
#ifdef NID_pkcs9_messageDigest
        return NID_pkcs9_messageDigest;
#else
        goto not_there;
#endif

      }
      break;
    case 'E':
      if (!memcmp(name, "F_GET_CLIENT_MASTER_KEY", 23)) {
      /*                                  ^            */
        
#ifdef SSL_F_GET_CLIENT_MASTER_KEY
        return SSL_F_GET_CLIENT_MASTER_KEY;
#else
        goto not_there;
#endif

      }
      if (!memcmp(name, "X509_PURPOSE_SMIME_SIGN", 23)) {
      /*                                  ^            */
        
#ifdef X509_PURPOSE_SMIME_SIGN
        return X509_PURPOSE_SMIME_SIGN;
#else
        goto not_there;
#endif

      }
      if (!memcmp(name, "X509_TRUST_OCSP_REQUEST", 23)) {
      /*                                  ^            */
        
#ifdef X509_TRUST_OCSP_REQUEST
        return X509_TRUST_OCSP_REQUEST;
#else
        goto not_there;
#endif

      }
      break;
    case 'G':
      if (!memcmp(name, "R_BAD_RESPONSE_ARGUMENT", 23)) {
      /*                                  ^            */
        
#ifdef SSL_R_BAD_RESPONSE_ARGUMENT
        return SSL_R_BAD_RESPONSE_ARGUMENT;
#else
        goto not_there;
#endif

      }
      break;
    case 'I':
      if (!memcmp(name, "X509_V_FLAG_INHIBIT_ANY", 23)) {
      /*                                  ^            */
        
#ifdef X509_V_FLAG_INHIBIT_ANY
        return X509_V_FLAG_INHIBIT_ANY;
#else
        goto not_there;
#endif

      }
      if (!memcmp(name, "X509_V_FLAG_INHIBIT_MAP", 23)) {
      /*                                  ^            */
        
#ifdef X509_V_FLAG_INHIBIT_MAP
        return X509_V_FLAG_INHIBIT_MAP;
#else
        goto not_there;
#endif

      }
      break;
    case 'K':
      if (!memcmp(name, "NID_pkcs8ShroudedKeyBag", 23)) {
      /*                                  ^            */
        
#ifdef NID_pkcs8ShroudedKeyBag
        return NID_pkcs8ShroudedKeyBag;
#else
        goto not_there;
#endif

      }
      break;
    case 'N':
      if (!memcmp(name, "LIBRESSL_VERSION_NUMBER", 23)) {
      /*                                  ^            */
        
#ifdef LIBRESSL_VERSION_NUMBER
        return LIBRESSL_VERSION_NUMBER;
#else
        goto not_there;
#endif

      }
      break;
    case 'O':
      if (!memcmp(name, "R_PUBLIC_KEY_IS_NOT_RSA", 23)) {
      /*                                  ^            */
        
#ifdef SSL_R_PUBLIC_KEY_IS_NOT_RSA
        return SSL_R_PUBLIC_KEY_IS_NOT_RSA;
#else
        goto not_there;
#endif

      }
      break;
    case 'S':
      if (!memcmp(name, "X509_PURPOSE_SSL_SERVER", 23)) {
      /*                                  ^            */
        
#ifdef X509_PURPOSE_SSL_SERVER
        return X509_PURPOSE_SSL_SERVER;
#else
        goto not_there;
#endif

      }
      if (!memcmp(name, "X509_V_FLAG_X509_STRICT", 23)) {
      /*                                  ^            */
        
#ifdef X509_V_FLAG_X509_STRICT
        return X509_V_FLAG_X509_STRICT;
#else
        goto not_there;
#endif

      }
      break;
    case 'X':
      if (!memcmp(name, "OP_CRYPTOPRO_TLSEXT_BUG", 23)) {
      /*                                  ^            */
        
#ifdef SSL_OP_CRYPTOPRO_TLSEXT_BUG
        return SSL_OP_CRYPTOPRO_TLSEXT_BUG;
#else
        goto not_there;
#endif

      }
      break;
    case 'Y':
      if (!memcmp(name, "X509_V_FLAG_POLICY_MASK", 23)) {
      /*                                  ^            */
        
#ifdef X509_V_FLAG_POLICY_MASK
        return X509_V_FLAG_POLICY_MASK;
#else
        goto not_there;
#endif

      }
      break;
    case 'c':
      if (!memcmp(name, "NID_stateOrProvinceName", 23)) {
      /*                                  ^            */
        
#ifdef NID_stateOrProvinceName
        return NID_stateOrProvinceName;
#else
        goto not_there;
#endif

      }
      break;
    }
    break;
  case 24:
    /* Names all of length 24.  */
    /* F_SSL_RSA_PUBLIC_ENCRYPT NID_certificate_policies
       NID_md2WithRSAEncryption NID_md5WithRSAEncryption
       NID_netscape_renewal_url NID_pbeWithMD2AndDES_CBC
       NID_pbeWithMD2AndRC2_CBC NID_pbeWithMD5AndDES_CBC
       NID_pbeWithMD5AndRC2_CBC NID_shaWithRSAEncryption
       OP_LEGACY_SERVER_CONNECT OP_MICROSOFT_SESS_ID_BUG
       OP_TLS_BLOCK_PADDING_BUG R_CHALLENGE_IS_DIFFERENT
       R_CIPHER_TABLE_SRC_ERROR R_PEER_ERROR_CERTIFICATE
       R_READ_WRONG_PACKET_TYPE X509_PURPOSE_OCSP_HELPER
       X509_V_FLAG_POLICY_CHECK */
    /* Offset 5 gives the best switch position.  */
    switch (name[5]) {
    case 'C':
      if (!memcmp(name, "OP_MICROSOFT_SESS_ID_BUG", 24)) {
      /*                      ^                         */
        
#ifdef SSL_OP_MICROSOFT_SESS_ID_BUG
        return SSL_OP_MICROSOFT_SESS_ID_BUG;
#else
        goto not_there;
#endif

      }
      break;
    case 'D':
      if (!memcmp(name, "R_READ_WRONG_PACKET_TYPE", 24)) {
      /*                      ^                         */
        
#ifdef SSL_R_READ_WRONG_PACKET_TYPE
        return SSL_R_READ_WRONG_PACKET_TYPE;
#else
        goto not_there;
#endif

      }
      break;
    case 'G':
      if (!memcmp(name, "OP_LEGACY_SERVER_CONNECT", 24)) {
      /*                      ^                         */
        
#ifdef SSL_OP_LEGACY_SERVER_CONNECT
        return SSL_OP_LEGACY_SERVER_CONNECT;
#else
        goto not_there;
#endif

      }
      break;
    case 'H':
      if (!memcmp(name, "R_CIPHER_TABLE_SRC_ERROR", 24)) {
      /*                      ^                         */
        
#ifdef SSL_R_CIPHER_TABLE_SRC_ERROR
        return SSL_R_CIPHER_TABLE_SRC_ERROR;
#else
        goto not_there;
#endif

      }
      break;
    case 'L':
      if (!memcmp(name, "R_CHALLENGE_IS_DIFFERENT", 24)) {
      /*                      ^                         */
        
#ifdef SSL_R_CHALLENGE_IS_DIFFERENT
        return SSL_R_CHALLENGE_IS_DIFFERENT;
#else
        goto not_there;
#endif

      }
      break;
    case 'P':
      if (!memcmp(name, "X509_PURPOSE_OCSP_HELPER", 24)) {
      /*                      ^                         */
        
#ifdef X509_PURPOSE_OCSP_HELPER
        return X509_PURPOSE_OCSP_HELPER;
#else
        goto not_there;
#endif

      }
      break;
    case 'R':
      if (!memcmp(name, "R_PEER_ERROR_CERTIFICATE", 24)) {
      /*                      ^                         */
        
#ifdef SSL_R_PEER_ERROR_CERTIFICATE
        return SSL_R_PEER_ERROR_CERTIFICATE;
#else
        goto not_there;
#endif

      }
      break;
    case 'S':
      if (!memcmp(name, "OP_TLS_BLOCK_PADDING_BUG", 24)) {
      /*                      ^                         */
        
#ifdef SSL_OP_TLS_BLOCK_PADDING_BUG
        return SSL_OP_TLS_BLOCK_PADDING_BUG;
#else
        goto not_there;
#endif

      }
      break;
    case 'V':
      if (!memcmp(name, "X509_V_FLAG_POLICY_CHECK", 24)) {
      /*                      ^                         */
        
#ifdef X509_V_FLAG_POLICY_CHECK
        return X509_V_FLAG_POLICY_CHECK;
#else
        goto not_there;
#endif

      }
      break;
    case '_':
      if (!memcmp(name, "F_SSL_RSA_PUBLIC_ENCRYPT", 24)) {
      /*                      ^                         */
        
#ifdef SSL_F_SSL_RSA_PUBLIC_ENCRYPT
        return SSL_F_SSL_RSA_PUBLIC_ENCRYPT;
#else
        goto not_there;
#endif

      }
      break;
    case 'b':
      if (!memcmp(name, "NID_pbeWithMD2AndDES_CBC", 24)) {
      /*                      ^                         */
        
#ifdef NID_pbeWithMD2AndDES_CBC
        return NID_pbeWithMD2AndDES_CBC;
#else
        goto not_there;
#endif

      }
      if (!memcmp(name, "NID_pbeWithMD2AndRC2_CBC", 24)) {
      /*                      ^                         */
        
#ifdef NID_pbeWithMD2AndRC2_CBC
        return NID_pbeWithMD2AndRC2_CBC;
#else
        goto not_there;
#endif

      }
      if (!memcmp(name, "NID_pbeWithMD5AndDES_CBC", 24)) {
      /*                      ^                         */
        
#ifdef NID_pbeWithMD5AndDES_CBC
        return NID_pbeWithMD5AndDES_CBC;
#else
        goto not_there;
#endif

      }
      if (!memcmp(name, "NID_pbeWithMD5AndRC2_CBC", 24)) {
      /*                      ^                         */
        
#ifdef NID_pbeWithMD5AndRC2_CBC
        return NID_pbeWithMD5AndRC2_CBC;
#else
        goto not_there;
#endif

      }
      break;
    case 'd':
      if (!memcmp(name, "NID_md2WithRSAEncryption", 24)) {
      /*                      ^                         */
        
#ifdef NID_md2WithRSAEncryption
        return NID_md2WithRSAEncryption;
#else
        goto not_there;
#endif

      }
      if (!memcmp(name, "NID_md5WithRSAEncryption", 24)) {
      /*                      ^                         */
        
#ifdef NID_md5WithRSAEncryption
        return NID_md5WithRSAEncryption;
#else
        goto not_there;
#endif

      }
      break;
    case 'e':
      if (!memcmp(name, "NID_certificate_policies", 24)) {
      /*                      ^                         */
        
#ifdef NID_certificate_policies
        return NID_certificate_policies;
#else
        goto not_there;
#endif

      }
      if (!memcmp(name, "NID_netscape_renewal_url", 24)) {
      /*                      ^                         */
        
#ifdef NID_netscape_renewal_url
        return NID_netscape_renewal_url;
#else
        goto not_there;
#endif

      }
      break;
    case 'h':
      if (!memcmp(name, "NID_shaWithRSAEncryption", 24)) {
      /*                      ^                         */
        
#ifdef NID_shaWithRSAEncryption
        return NID_shaWithRSAEncryption;
#else
        goto not_there;
#endif

      }
      break;
    }
    break;
  case 25:
    /* Names all of length 25.  */
    /* F_SSL_RSA_PRIVATE_DECRYPT F_SSL_USE_PRIVATEKEY_ASN1
       F_SSL_USE_PRIVATEKEY_FILE MODE_ENABLE_PARTIAL_WRITE
       NID_pbeWithSHA1AndDES_CBC NID_pbeWithSHA1AndRC2_CBC
       NID_sha1WithRSAEncryption OP_MSIE_SSLV2_RSA_PADDING
       OP_NETSCAPE_CHALLENGE_BUG R_BAD_AUTHENTICATION_TYPE
       V_OCSP_CERTSTATUS_REVOKED V_OCSP_CERTSTATUS_UNKNOWN
       X509_V_FLAG_CRL_CHECK_ALL X509_V_FLAG_NOTIFY_POLICY */
    /* Offset 20 gives the best switch position.  */
    switch (name[20]) {
    case '2':
      if (!memcmp(name, "NID_pbeWithSHA1AndRC2_CBC", 25)) {
      /*                                     ^           */
        
#ifdef NID_pbeWithSHA1AndRC2_CBC
        return NID_pbeWithSHA1AndRC2_CBC;
#else
        goto not_there;
#endif

      }
      break;
    case 'C':
      if (!memcmp(name, "F_SSL_RSA_PRIVATE_DECRYPT", 25)) {
      /*                                     ^           */
        
#ifdef SSL_F_SSL_RSA_PRIVATE_DECRYPT
        return SSL_F_SSL_RSA_PRIVATE_DECRYPT;
#else
        goto not_there;
#endif

      }
      break;
    case 'D':
      if (!memcmp(name, "OP_MSIE_SSLV2_RSA_PADDING", 25)) {
      /*                                     ^           */
        
#ifdef SSL_OP_MSIE_SSLV2_RSA_PADDING
        return SSL_OP_MSIE_SSLV2_RSA_PADDING;
#else
        goto not_there;
#endif

      }
      break;
    case 'E':
      if (!memcmp(name, "OP_NETSCAPE_CHALLENGE_BUG", 25)) {
      /*                                     ^           */
        
#ifdef SSL_OP_NETSCAPE_CHALLENGE_BUG
        return SSL_OP_NETSCAPE_CHALLENGE_BUG;
#else
        goto not_there;
#endif

      }
      break;
    case 'K':
      if (!memcmp(name, "V_OCSP_CERTSTATUS_UNKNOWN", 25)) {
      /*                                     ^           */
        
#ifdef V_OCSP_CERTSTATUS_UNKNOWN
        return V_OCSP_CERTSTATUS_UNKNOWN;
#else
        goto not_there;
#endif

      }
      if (!memcmp(name, "X509_V_FLAG_CRL_CHECK_ALL", 25)) {
      /*                                     ^           */
        
#ifdef X509_V_FLAG_CRL_CHECK_ALL
        return X509_V_FLAG_CRL_CHECK_ALL;
#else
        goto not_there;
#endif

      }
      break;
    case 'O':
      if (!memcmp(name, "X509_V_FLAG_NOTIFY_POLICY", 25)) {
      /*                                     ^           */
        
#ifdef X509_V_FLAG_NOTIFY_POLICY
        return X509_V_FLAG_NOTIFY_POLICY;
#else
        goto not_there;
#endif

      }
      break;
    case 'S':
      if (!memcmp(name, "NID_pbeWithSHA1AndDES_CBC", 25)) {
      /*                                     ^           */
        
#ifdef NID_pbeWithSHA1AndDES_CBC
        return NID_pbeWithSHA1AndDES_CBC;
#else
        goto not_there;
#endif

      }
      break;
    case 'V':
      if (!memcmp(name, "V_OCSP_CERTSTATUS_REVOKED", 25)) {
      /*                                     ^           */
        
#ifdef V_OCSP_CERTSTATUS_REVOKED
        return V_OCSP_CERTSTATUS_REVOKED;
#else
        goto not_there;
#endif

      }
      break;
    case 'W':
      if (!memcmp(name, "MODE_ENABLE_PARTIAL_WRITE", 25)) {
      /*                                     ^           */
        
#ifdef SSL_MODE_ENABLE_PARTIAL_WRITE
        return SSL_MODE_ENABLE_PARTIAL_WRITE;
#else
        goto not_there;
#endif

      }
      break;
    case '_':
      if (!memcmp(name, "F_SSL_USE_PRIVATEKEY_ASN1", 25)) {
      /*                                     ^           */
        
#ifdef SSL_F_SSL_USE_PRIVATEKEY_ASN1
        return SSL_F_SSL_USE_PRIVATEKEY_ASN1;
#else
        goto not_there;
#endif

      }
      if (!memcmp(name, "F_SSL_USE_PRIVATEKEY_FILE", 25)) {
      /*                                     ^           */
        
#ifdef SSL_F_SSL_USE_PRIVATEKEY_FILE
        return SSL_F_SSL_USE_PRIVATEKEY_FILE;
#else
        goto not_there;
#endif

      }
      if (!memcmp(name, "R_BAD_AUTHENTICATION_TYPE", 25)) {
      /*                                     ^           */
        
#ifdef SSL_R_BAD_AUTHENTICATION_TYPE
        return SSL_R_BAD_AUTHENTICATION_TYPE;
#else
        goto not_there;
#endif

      }
      break;
    case 'p':
      if (!memcmp(name, "NID_sha1WithRSAEncryption", 25)) {
      /*                                     ^           */
        
#ifdef NID_sha1WithRSAEncryption
        return NID_sha1WithRSAEncryption;
#else
        goto not_there;
#endif

      }
      break;
    }
    break;
  case 26:
    /* Names all of length 26.  */
    /* F_SSL_USE_CERTIFICATE_ASN1 F_SSL_USE_CERTIFICATE_FILE
       NID_netscape_ca_policy_url NID_netscape_cert_sequence
       NID_organizationalUnitName NID_pbeWithMD5AndCast5_CBC
       NID_pkcs9_countersignature NID_pkcs9_unstructuredName
       NID_subject_key_identifier R_INVALID_CHALLENGE_LENGTH
       R_NO_CERTIFICATE_SPECIFIED R_PUBLIC_KEY_ENCRYPT_ERROR
       X509_PURPOSE_NS_SSL_SERVER X509_PURPOSE_SMIME_ENCRYPT
       X509_V_FLAG_USE_CHECK_TIME */
    /* Offset 16 gives the best switch position.  */
    switch (name[16]) {
    case 'C':
      if (!memcmp(name, "X509_V_FLAG_USE_CHECK_TIME", 26)) {
      /*                                 ^                */
        
#ifdef X509_V_FLAG_USE_CHECK_TIME
        return X509_V_FLAG_USE_CHECK_TIME;
#else
        goto not_there;
#endif

      }
      break;
    case 'I':
      if (!memcmp(name, "F_SSL_USE_CERTIFICATE_ASN1", 26)) {
      /*                                 ^                */
        
#ifdef SSL_F_SSL_USE_CERTIFICATE_ASN1
        return SSL_F_SSL_USE_CERTIFICATE_ASN1;
#else
        goto not_there;
#endif

      }
      if (!memcmp(name, "F_SSL_USE_CERTIFICATE_FILE", 26)) {
      /*                                 ^                */
        
#ifdef SSL_F_SSL_USE_CERTIFICATE_FILE
        return SSL_F_SSL_USE_CERTIFICATE_FILE;
#else
        goto not_there;
#endif

      }
      break;
    case 'M':
      if (!memcmp(name, "X509_PURPOSE_SMIME_ENCRYPT", 26)) {
      /*                                 ^                */
        
#ifdef X509_PURPOSE_SMIME_ENCRYPT
        return X509_PURPOSE_SMIME_ENCRYPT;
#else
        goto not_there;
#endif

      }
      break;
    case 'N':
      if (!memcmp(name, "R_INVALID_CHALLENGE_LENGTH", 26)) {
      /*                                 ^                */
        
#ifdef SSL_R_INVALID_CHALLENGE_LENGTH
        return SSL_R_INVALID_CHALLENGE_LENGTH;
#else
        goto not_there;
#endif

      }
      break;
    case 'R':
      if (!memcmp(name, "R_PUBLIC_KEY_ENCRYPT_ERROR", 26)) {
      /*                                 ^                */
        
#ifdef SSL_R_PUBLIC_KEY_ENCRYPT_ERROR
        return SSL_R_PUBLIC_KEY_ENCRYPT_ERROR;
#else
        goto not_there;
#endif

      }
      break;
    case 'S':
      if (!memcmp(name, "X509_PURPOSE_NS_SSL_SERVER", 26)) {
      /*                                 ^                */
        
#ifdef X509_PURPOSE_NS_SSL_SERVER
        return X509_PURPOSE_NS_SSL_SERVER;
#else
        goto not_there;
#endif

      }
      break;
    case '_':
      if (!memcmp(name, "R_NO_CERTIFICATE_SPECIFIED", 26)) {
      /*                                 ^                */
        
#ifdef SSL_R_NO_CERTIFICATE_SPECIFIED
        return SSL_R_NO_CERTIFICATE_SPECIFIED;
#else
        goto not_there;
#endif

      }
      break;
    case 'a':
      if (!memcmp(name, "NID_organizationalUnitName", 26)) {
      /*                                 ^                */
        
#ifdef NID_organizationalUnitName
        return NID_organizationalUnitName;
#else
        goto not_there;
#endif

      }
      break;
    case 'c':
      if (!memcmp(name, "NID_pkcs9_unstructuredName", 26)) {
      /*                                 ^                */
        
#ifdef NID_pkcs9_unstructuredName
        return NID_pkcs9_unstructuredName;
#else
        goto not_there;
#endif

      }
      break;
    case 'd':
      if (!memcmp(name, "NID_pbeWithMD5AndCast5_CBC", 26)) {
      /*                                 ^                */
        
#ifdef NID_pbeWithMD5AndCast5_CBC
        return NID_pbeWithMD5AndCast5_CBC;
#else
        goto not_there;
#endif

      }
      break;
    case 'i':
      if (!memcmp(name, "NID_subject_key_identifier", 26)) {
      /*                                 ^                */
        
#ifdef NID_subject_key_identifier
        return NID_subject_key_identifier;
#else
        goto not_there;
#endif

      }
      break;
    case 'p':
      if (!memcmp(name, "NID_netscape_ca_policy_url", 26)) {
      /*                                 ^                */
        
#ifdef NID_netscape_ca_policy_url
        return NID_netscape_ca_policy_url;
#else
        goto not_there;
#endif

      }
      break;
    case 'r':
      if (!memcmp(name, "NID_pkcs9_countersignature", 26)) {
      /*                                 ^                */
        
#ifdef NID_pkcs9_countersignature
        return NID_pkcs9_countersignature;
#else
        goto not_there;
#endif

      }
      break;
    case 't':
      if (!memcmp(name, "NID_netscape_cert_sequence", 26)) {
      /*                                 ^                */
        
#ifdef NID_netscape_cert_sequence
        return NID_netscape_cert_sequence;
#else
        goto not_there;
#endif

      }
      break;
    }
    break;
  case 27:
    /* Names all of length 27.  */
    /* NID_crl_distribution_points NID_netscape_cert_extension
       NID_netscape_revocation_url NID_pbe_WithSHA1And40BitRC4
       NID_pkcs9_challengePassword NID_pkcs9_extCertAttributes
       OP_CIPHER_SERVER_PREFERENCE OP_SSLEAY_080_CLIENT_DH_BUG
       R_BAD_SSL_SESSION_ID_LENGTH R_UNKNOWN_REMOTE_ERROR_TYPE
       VERIFY_FAIL_IF_NO_PEER_CERT X509_PURPOSE_TIMESTAMP_SIGN
       X509_V_FLAG_CB_ISSUER_CHECK X509_V_FLAG_EXPLICIT_POLICY
       X509_V_FLAG_IGNORE_CRITICAL XN_FLAG_DUMP_UNKNOWN_FIELDS */
    /* Offset 13 gives the best switch position.  */
    switch (name[13]) {
    case 'B':
      if (!memcmp(name, "X509_V_FLAG_CB_ISSUER_CHECK", 27)) {
      /*                              ^                    */
        
#ifdef X509_V_FLAG_CB_ISSUER_CHECK
        return X509_V_FLAG_CB_ISSUER_CHECK;
#else
        goto not_there;
#endif

      }
      break;
    case 'C':
      if (!memcmp(name, "NID_pkcs9_extCertAttributes", 27)) {
      /*                              ^                    */
        
#ifdef NID_pkcs9_extCertAttributes
        return NID_pkcs9_extCertAttributes;
#else
        goto not_there;
#endif

      }
      break;
    case 'F':
      if (!memcmp(name, "VERIFY_FAIL_IF_NO_PEER_CERT", 27)) {
      /*                              ^                    */
        
#ifdef SSL_VERIFY_FAIL_IF_NO_PEER_CERT
        return SSL_VERIFY_FAIL_IF_NO_PEER_CERT;
#else
        goto not_there;
#endif

      }
      break;
    case 'G':
      if (!memcmp(name, "X509_V_FLAG_IGNORE_CRITICAL", 27)) {
      /*                              ^                    */
        
#ifdef X509_V_FLAG_IGNORE_CRITICAL
        return X509_V_FLAG_IGNORE_CRITICAL;
#else
        goto not_there;
#endif

      }
      break;
    case 'H':
      if (!memcmp(name, "NID_pbe_WithSHA1And40BitRC4", 27)) {
      /*                              ^                    */
        
#ifdef NID_pbe_WithSHA1And40BitRC4
        return NID_pbe_WithSHA1And40BitRC4;
#else
        goto not_there;
#endif

      }
      break;
    case 'O':
      if (!memcmp(name, "R_UNKNOWN_REMOTE_ERROR_TYPE", 27)) {
      /*                              ^                    */
        
#ifdef SSL_R_UNKNOWN_REMOTE_ERROR_TYPE
        return SSL_R_UNKNOWN_REMOTE_ERROR_TYPE;
#else
        goto not_there;
#endif

      }
      break;
    case 'S':
      if (!memcmp(name, "R_BAD_SSL_SESSION_ID_LENGTH", 27)) {
      /*                              ^                    */
        
#ifdef SSL_R_BAD_SSL_SESSION_ID_LENGTH
        return SSL_R_BAD_SSL_SESSION_ID_LENGTH;
#else
        goto not_there;
#endif

      }
      break;
    case 'T':
      if (!memcmp(name, "X509_PURPOSE_TIMESTAMP_SIGN", 27)) {
      /*                              ^                    */
        
#ifdef X509_PURPOSE_TIMESTAMP_SIGN
        return X509_PURPOSE_TIMESTAMP_SIGN;
#else
        goto not_there;
#endif

      }
      break;
    case 'U':
      if (!memcmp(name, "XN_FLAG_DUMP_UNKNOWN_FIELDS", 27)) {
      /*                              ^                    */
        
#ifdef XN_FLAG_DUMP_UNKNOWN_FIELDS
        return XN_FLAG_DUMP_UNKNOWN_FIELDS;
#else
        goto not_there;
#endif

      }
      break;
    case 'V':
      if (!memcmp(name, "OP_CIPHER_SERVER_PREFERENCE", 27)) {
      /*                              ^                    */
        
#ifdef SSL_OP_CIPHER_SERVER_PREFERENCE
        return SSL_OP_CIPHER_SERVER_PREFERENCE;
#else
        goto not_there;
#endif

      }
      break;
    case 'X':
      if (!memcmp(name, "X509_V_FLAG_EXPLICIT_POLICY", 27)) {
      /*                              ^                    */
        
#ifdef X509_V_FLAG_EXPLICIT_POLICY
        return X509_V_FLAG_EXPLICIT_POLICY;
#else
        goto not_there;
#endif

      }
      break;
    case '_':
      if (!memcmp(name, "OP_SSLEAY_080_CLIENT_DH_BUG", 27)) {
      /*                              ^                    */
        
#ifdef SSL_OP_SSLEAY_080_CLIENT_DH_BUG
        return SSL_OP_SSLEAY_080_CLIENT_DH_BUG;
#else
        goto not_there;
#endif

      }
      break;
    case 'c':
      if (!memcmp(name, "NID_netscape_cert_extension", 27)) {
      /*                              ^                    */
        
#ifdef NID_netscape_cert_extension
        return NID_netscape_cert_extension;
#else
        goto not_there;
#endif

      }
      break;
    case 'i':
      if (!memcmp(name, "NID_crl_distribution_points", 27)) {
      /*                              ^                    */
        
#ifdef NID_crl_distribution_points
        return NID_crl_distribution_points;
#else
        goto not_there;
#endif

      }
      break;
    case 'l':
      if (!memcmp(name, "NID_pkcs9_challengePassword", 27)) {
      /*                              ^                    */
        
#ifdef NID_pkcs9_challengePassword
        return NID_pkcs9_challengePassword;
#else
        goto not_there;
#endif

      }
      break;
    case 'r':
      if (!memcmp(name, "NID_netscape_revocation_url", 27)) {
      /*                              ^                    */
        
#ifdef NID_netscape_revocation_url
        return NID_netscape_revocation_url;
#else
        goto not_there;
#endif

      }
      break;
    }
    break;
  case 28:
    /* Names all of length 28.  */
    /* F_SSL_USE_RSAPRIVATEKEY_ASN1 F_SSL_USE_RSAPRIVATEKEY_FILE
       NID_authority_key_identifier NID_netscape_ssl_server_name
       NID_pbe_WithSHA1And128BitRC4 NID_pkcs7_signedAndEnveloped
       NID_private_key_usage_period */
    /* Offset 24 gives the best switch position.  */
    switch (name[24]) {
    case 'A':
      if (!memcmp(name, "F_SSL_USE_RSAPRIVATEKEY_ASN1", 28)) {
      /*                                         ^          */
        
#ifdef SSL_F_SSL_USE_RSAPRIVATEKEY_ASN1
        return SSL_F_SSL_USE_RSAPRIVATEKEY_ASN1;
#else
        goto not_there;
#endif

      }
      break;
    case 'F':
      if (!memcmp(name, "F_SSL_USE_RSAPRIVATEKEY_FILE", 28)) {
      /*                                         ^          */
        
#ifdef SSL_F_SSL_USE_RSAPRIVATEKEY_FILE
        return SSL_F_SSL_USE_RSAPRIVATEKEY_FILE;
#else
        goto not_there;
#endif

      }
      break;
    case 'f':
      if (!memcmp(name, "NID_authority_key_identifier", 28)) {
      /*                                         ^          */
        
#ifdef NID_authority_key_identifier
        return NID_authority_key_identifier;
#else
        goto not_there;
#endif

      }
      break;
    case 'n':
      if (!memcmp(name, "NID_netscape_ssl_server_name", 28)) {
      /*                                         ^          */
        
#ifdef NID_netscape_ssl_server_name
        return NID_netscape_ssl_server_name;
#else
        goto not_there;
#endif

      }
      break;
    case 'o':
      if (!memcmp(name, "NID_pkcs7_signedAndEnveloped", 28)) {
      /*                                         ^          */
        
#ifdef NID_pkcs7_signedAndEnveloped
        return NID_pkcs7_signedAndEnveloped;
#else
        goto not_there;
#endif

      }
      break;
    case 'r':
      if (!memcmp(name, "NID_private_key_usage_period", 28)) {
      /*                                         ^          */
        
#ifdef NID_private_key_usage_period
        return NID_private_key_usage_period;
#else
        goto not_there;
#endif

      }
      break;
    case 't':
      if (!memcmp(name, "NID_pbe_WithSHA1And128BitRC4", 28)) {
      /*                                         ^          */
        
#ifdef NID_pbe_WithSHA1And128BitRC4
        return NID_pbe_WithSHA1And128BitRC4;
#else
        goto not_there;
#endif

      }
      break;
    }
    break;
  case 29:
    /* Names all of length 29.  */
    /* NID_pkcs9_unstructuredAddress OCSP_RESPONSE_STATUS_TRYLATER
       OP_MICROSOFT_BIG_SSLV3_BUFFER R_SSL_SESSION_ID_IS_DIFFERENT
       X509_V_FLAG_ALLOW_PROXY_CERTS */
    /* Offset 6 gives the best switch position.  */
    switch (name[6]) {
    case 'E':
      if (!memcmp(name, "OCSP_RESPONSE_STATUS_TRYLATER", 29)) {
      /*                       ^                             */
        
#ifdef OCSP_RESPONSE_STATUS_TRYLATER
        return OCSP_RESPONSE_STATUS_TRYLATER;
#else
        goto not_there;
#endif

      }
      break;
    case 'R':
      if (!memcmp(name, "OP_MICROSOFT_BIG_SSLV3_BUFFER", 29)) {
      /*                       ^                             */
        
#ifdef SSL_OP_MICROSOFT_BIG_SSLV3_BUFFER
        return SSL_OP_MICROSOFT_BIG_SSLV3_BUFFER;
#else
        goto not_there;
#endif

      }
      break;
    case 'S':
      if (!memcmp(name, "R_SSL_SESSION_ID_IS_DIFFERENT", 29)) {
      /*                       ^                             */
        
#ifdef SSL_R_SSL_SESSION_ID_IS_DIFFERENT
        return SSL_R_SSL_SESSION_ID_IS_DIFFERENT;
#else
        goto not_there;
#endif

      }
      break;
    case '_':
      if (!memcmp(name, "X509_V_FLAG_ALLOW_PROXY_CERTS", 29)) {
      /*                       ^                             */
        
#ifdef X509_V_FLAG_ALLOW_PROXY_CERTS
        return X509_V_FLAG_ALLOW_PROXY_CERTS;
#else
        goto not_there;
#endif

      }
      break;
    case 'c':
      if (!memcmp(name, "NID_pkcs9_unstructuredAddress", 29)) {
      /*                       ^                             */
        
#ifdef NID_pkcs9_unstructuredAddress
        return NID_pkcs9_unstructuredAddress;
#else
        goto not_there;
#endif

      }
      break;
    }
    break;
  case 30:
    /* Names all of length 30.  */
    /* NID_netscape_ca_revocation_url OP_DONT_INSERT_EMPTY_FRAGMENTS
       OP_SSLREF2_REUSE_CERT_TYPE_BUG R_UNABLE_TO_EXTRACT_PUBLIC_KEY
       X509_V_FLAG_CHECK_SS_SIGNATURE */
    /* Offset 13 gives the best switch position.  */
    switch (name[13]) {
    case 'H':
      if (!memcmp(name, "X509_V_FLAG_CHECK_SS_SIGNATURE", 30)) {
      /*                              ^                       */
        
#ifdef X509_V_FLAG_CHECK_SS_SIGNATURE
        return X509_V_FLAG_CHECK_SS_SIGNATURE;
#else
        goto not_there;
#endif

      }
      break;
    case 'T':
      if (!memcmp(name, "OP_DONT_INSERT_EMPTY_FRAGMENTS", 30)) {
      /*                              ^                       */
        
#ifdef SSL_OP_DONT_INSERT_EMPTY_FRAGMENTS
        return SSL_OP_DONT_INSERT_EMPTY_FRAGMENTS;
#else
        goto not_there;
#endif

      }
      break;
    case 'U':
      if (!memcmp(name, "OP_SSLREF2_REUSE_CERT_TYPE_BUG", 30)) {
      /*                              ^                       */
        
#ifdef SSL_OP_SSLREF2_REUSE_CERT_TYPE_BUG
        return SSL_OP_SSLREF2_REUSE_CERT_TYPE_BUG;
#else
        goto not_there;
#endif

      }
      break;
    case 'X':
      if (!memcmp(name, "R_UNABLE_TO_EXTRACT_PUBLIC_KEY", 30)) {
      /*                              ^                       */
        
#ifdef SSL_R_UNABLE_TO_EXTRACT_PUBLIC_KEY
        return SSL_R_UNABLE_TO_EXTRACT_PUBLIC_KEY;
#else
        goto not_there;
#endif

      }
      break;
    case 'c':
      if (!memcmp(name, "NID_netscape_ca_revocation_url", 30)) {
      /*                              ^                       */
        
#ifdef NID_netscape_ca_revocation_url
        return NID_netscape_ca_revocation_url;
#else
        goto not_there;
#endif

      }
      break;
    }
    break;
  case 31:
    /* Names all of length 31.  */
    /* MIN_RSA_MODULUS_LENGTH_IN_BYTES MODE_ACCEPT_MOVING_WRITE_BUFFER
       NID_pbe_WithSHA1And40BitRC2_CBC OCSP_RESPONSE_STATUS_SUCCESSFUL */
    /* Offset 12 gives the best switch position.  */
    switch (name[12]) {
    case 'E':
      if (!memcmp(name, "OCSP_RESPONSE_STATUS_SUCCESSFUL", 31)) {
      /*                             ^                         */
        
#ifdef OCSP_RESPONSE_STATUS_SUCCESSFUL
        return OCSP_RESPONSE_STATUS_SUCCESSFUL;
#else
        goto not_there;
#endif

      }
      break;
    case 'L':
      if (!memcmp(name, "MIN_RSA_MODULUS_LENGTH_IN_BYTES", 31)) {
      /*                             ^                         */
        
#ifdef SSL_MIN_RSA_MODULUS_LENGTH_IN_BYTES
        return SSL_MIN_RSA_MODULUS_LENGTH_IN_BYTES;
#else
        goto not_there;
#endif

      }
      break;
    case 'M':
      if (!memcmp(name, "MODE_ACCEPT_MOVING_WRITE_BUFFER", 31)) {
      /*                             ^                         */
        
#ifdef SSL_MODE_ACCEPT_MOVING_WRITE_BUFFER
        return SSL_MODE_ACCEPT_MOVING_WRITE_BUFFER;
#else
        goto not_there;
#endif

      }
      break;
    case 'S':
      if (!memcmp(name, "NID_pbe_WithSHA1And40BitRC2_CBC", 31)) {
      /*                             ^                         */
        
#ifdef NID_pbe_WithSHA1And40BitRC2_CBC
        return NID_pbe_WithSHA1And40BitRC2_CBC;
#else
        goto not_there;
#endif

      }
      break;
    }
    break;
  case 32:
    /* Names all of length 32.  */
    /* NID_pbe_WithSHA1And128BitRC2_CBC OCSP_RESPONSE_STATUS_SIGREQUIRED
       X509_V_FLAG_EXTENDED_CRL_SUPPORT */
    /* Offset 0 gives the best switch position.  */
    switch (*name++) {
    case 'N':
      if (!memcmp(name, "ID_pbe_WithSHA1And128BitRC2_CBC", 31)) {
      /*                N                                      */
        
#ifdef NID_pbe_WithSHA1And128BitRC2_CBC
        return NID_pbe_WithSHA1And128BitRC2_CBC;
#else
        goto not_there;
#endif

      }
      break;
    case 'O':
      if (!memcmp(name, "CSP_RESPONSE_STATUS_SIGREQUIRED", 31)) {
      /*                O                                      */
        
#ifdef OCSP_RESPONSE_STATUS_SIGREQUIRED
        return OCSP_RESPONSE_STATUS_SIGREQUIRED;
#else
        goto not_there;
#endif

      }
      break;
    case 'X':
      if (!memcmp(name, "509_V_FLAG_EXTENDED_CRL_SUPPORT", 31)) {
      /*                X                                      */
        
#ifdef X509_V_FLAG_EXTENDED_CRL_SUPPORT
        return X509_V_FLAG_EXTENDED_CRL_SUPPORT;
#else
        goto not_there;
#endif

      }
      break;
    }
    break;
  case 33:
    if (!memcmp(name, "OCSP_RESPONSE_STATUS_UNAUTHORIZED", 33)) {
      
#ifdef OCSP_RESPONSE_STATUS_UNAUTHORIZED
        return OCSP_RESPONSE_STATUS_UNAUTHORIZED;
#else
        goto not_there;
#endif

    }
    break;
  case 34:
    /* Names all of length 34.  */
    /* OCSP_RESPONSE_STATUS_INTERNALERROR OP_NETSCAPE_DEMO_CIPHER_CHANGE_BUG */
    /* Offset 9 gives the best switch position.  */
    switch (name[9]) {
    case 'O':
      if (!memcmp(name, "OCSP_RESPONSE_STATUS_INTERNALERROR", 34)) {
      /*                          ^                               */
        
#ifdef OCSP_RESPONSE_STATUS_INTERNALERROR
        return OCSP_RESPONSE_STATUS_INTERNALERROR;
#else
        goto not_there;
#endif

      }
      break;
    case 'P':
      if (!memcmp(name, "OP_NETSCAPE_DEMO_CIPHER_CHANGE_BUG", 34)) {
      /*                          ^                               */
        
#ifdef SSL_OP_NETSCAPE_DEMO_CIPHER_CHANGE_BUG
        return SSL_OP_NETSCAPE_DEMO_CIPHER_CHANGE_BUG;
#else
        goto not_there;
#endif

      }
      break;
    }
    break;
  case 35:
    /* Names all of length 35.  */
    /* OP_NETSCAPE_REUSE_CIPHER_CHANGE_BUG R_PEER_DID_NOT_RETURN_A_CERTIFICATE
       */
    /* Offset 7 gives the best switch position.  */
    switch (name[7]) {
    case 'C':
      if (!memcmp(name, "OP_NETSCAPE_REUSE_CIPHER_CHANGE_BUG", 35)) {
      /*                        ^                                  */
        
#ifdef SSL_OP_NETSCAPE_REUSE_CIPHER_CHANGE_BUG
        return SSL_OP_NETSCAPE_REUSE_CIPHER_CHANGE_BUG;
#else
        goto not_there;
#endif

      }
      break;
    case 'D':
      if (!memcmp(name, "R_PEER_DID_NOT_RETURN_A_CERTIFICATE", 35)) {
      /*                        ^                                  */
        
#ifdef SSL_R_PEER_DID_NOT_RETURN_A_CERTIFICATE
        return SSL_R_PEER_DID_NOT_RETURN_A_CERTIFICATE;
#else
        goto not_there;
#endif

      }
      break;
    }
    break;
  case 36:
    if (!memcmp(name, "OP_ALLOW_UNSAFE_LEGACY_RENEGOTIATION", 36)) {
      
#ifdef SSL_OP_ALLOW_UNSAFE_LEGACY_RENEGOTIATION
        return SSL_OP_ALLOW_UNSAFE_LEGACY_RENEGOTIATION;
#else
        goto not_there;
#endif

    }
    break;
  case 37:
    if (!memcmp(name, "OCSP_RESPONSE_STATUS_MALFORMEDREQUEST", 37)) {
      
#ifdef OCSP_RESPONSE_STATUS_MALFORMEDREQUEST
        return OCSP_RESPONSE_STATUS_MALFORMEDREQUEST;
#else
        goto not_there;
#endif

    }
    break;
  case 38:
    /* Names all of length 38.  */
    /* NID_pbe_WithSHA1And2_Key_TripleDES_CBC
       NID_pbe_WithSHA1And3_Key_TripleDES_CBC */
    /* Offset 19 gives the best switch position.  */
    switch (name[19]) {
    case '2':
      if (!memcmp(name, "NID_pbe_WithSHA1And2_Key_TripleDES_CBC", 38)) {
      /*                                    ^                         */
        
#ifdef NID_pbe_WithSHA1And2_Key_TripleDES_CBC
        return NID_pbe_WithSHA1And2_Key_TripleDES_CBC;
#else
        goto not_there;
#endif

      }
      break;
    case '3':
      if (!memcmp(name, "NID_pbe_WithSHA1And3_Key_TripleDES_CBC", 38)) {
      /*                                    ^                         */
        
#ifdef NID_pbe_WithSHA1And3_Key_TripleDES_CBC
        return NID_pbe_WithSHA1And3_Key_TripleDES_CBC;
#else
        goto not_there;
#endif

      }
      break;
    }
    break;
  case 41:
    /* Names all of length 41.  */
    /* OP_NO_SESSION_RESUMPTION_ON_RENEGOTIATION
       R_PEER_ERROR_UNSUPPORTED_CERTIFICATE_TYPE */
    /* Offset 8 gives the best switch position.  */
    switch (name[8]) {
    case 'R':
      if (!memcmp(name, "R_PEER_ERROR_UNSUPPORTED_CERTIFICATE_TYPE", 41)) {
      /*                         ^                                       */
        
#ifdef SSL_R_PEER_ERROR_UNSUPPORTED_CERTIFICATE_TYPE
        return SSL_R_PEER_ERROR_UNSUPPORTED_CERTIFICATE_TYPE;
#else
        goto not_there;
#endif

      }
      break;
    case 'S':
      if (!memcmp(name, "OP_NO_SESSION_RESUMPTION_ON_RENEGOTIATION", 41)) {
      /*                         ^                                       */
        
#ifdef SSL_OP_NO_SESSION_RESUMPTION_ON_RENEGOTIATION
        return SSL_OP_NO_SESSION_RESUMPTION_ON_RENEGOTIATION;
#else
        goto not_there;
#endif

      }
      break;
    }
    break;
  }
  
  errno = EINVAL;
  return 0;

not_there:
  errno = ENOENT;
  return 0;

}
