package Net::Async::Spotify::Object::Generated::Playlist;

use strict;
use warnings;

our $VERSION = '0.002'; # VERSION
our $AUTHORITY = 'cpan:VNEALV'; # AUTHORITY

use mro;
use parent qw(Net::Async::Spotify::Object::Base);

=encoding utf8

=head1 NAME

Net::Async::Spotify::Object::Generated::Playlist - Package representing Spotify Playlist Object

=head1 DESCRIPTION

Autogenerated module.
Based on https://developer.spotify.com/documentation/web-api/reference/#objects-index
Check C<crawl-api-doc.pl> for more information.

=head1 PARAMETERS

Those are Spotify Playlist Object attributes:

=over 4

=item collaborative

Type:Boolean
Description:true if the owner allows other users to modify the playlist.

=item description

Type:String
Description:The playlist description. Only returned for modified, verified playlists, otherwise null.

=item external_urls

Type:ExternalUrlObject
Description:Known external URLs for this playlist.

=item followers

Type:FollowersObject
Description:Information about the followers of the playlist.

=item href

Type:String
Description:A link to the Web API endpoint providing full details of the playlist.

=item id

Type:String
Description:The Spotify ID for the playlist.

=item images

Type:Array[ImageObject]
Description:Images for the playlist. The array may be empty or contain up to three images. The images are returned by size in descending order. See Working with Playlists. Note: If returned, the source URL for the image (url) is temporary and will expire in less than a day.

=item name

Type:String
Description:The name of the playlist.

=item owner

Type:PublicUserObject
Description:The user who owns the playlist

=item public

Type:Boolean
Description:The playlist’s public/private status: true the playlist is public, false the playlist is private, null the playlist status is not relevant. For more about public/private status, see Working with Playlists

=item snapshot_id

Type:String
Description:The version identifier for the current playlist. Can be supplied in other requests to target a specific playlist version

=item tracks

Type:Array[PlaylistTrackObject]
Description:Information about the tracks of the playlist. Note, a track object may be null. This can happen if a track is no longer available.

=item type

Type:String
Description:The object type: “playlist”

=item uri

Type:String
Description:The Spotify URI for the playlist.

=back

=cut

sub new {
    my ($class, %args) = @_;

    my $fields = {
        collaborative => 'Boolean',
        description => 'String',
        external_urls => 'ExternalUrlObject',
        followers => 'FollowersObject',
        href => 'String',
        id => 'String',
        images => 'Array[ImageObject]',
        name => 'String',
        owner => 'PublicUserObject',
        public => 'Boolean',
        snapshot_id => 'String',
        tracks => 'Array[PlaylistTrackObject]',
        type => 'String',
        uri => 'String',
    };

    my $obj = next::method($class, $fields, %args);

    return $obj;
}

1;
