#!/usr/bin/perl

package eBay::API::XML::DataType::Enum::ExpressDetailLevelCodeType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. ExpressDetailLevelCodeType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 07/07/2008 17:42
# API Release Number: ... 571
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::Enum::ExpressDetailLevelCodeType

=head1 DESCRIPTION

For GetSearchResultsExpress, controls the details to retrieve per
item, product, or histogram.



=head1 SYNOPSIS

=cut



=head1 Enums:

=cut


=head2 Coarse

(in) The effect of Coarse varies for HistogramDetails, ProductDetails,
and ItemDetails.<br>
<br>
For HistogramDetails, this is primarily useful for reducing the
histogram depth when you search across all departments or within a
specific department. (When you search by AisleName or ProductTypeName,
there is no difference between Coarse and Fine).<br>
<br>
If the request includes no DepartmentName, AisleName, or ProductName,
retrieve a histogram for all departments that match the
criteria in the request, but don't retrieve aisle or
product type details.
Stand-alone domains (aisles and product types) aren't grouped into
departments, so Express ignores them in this departments-only histogram.
That is, the data in the histogram is only based on matching departments
and their grouped subdomains.
(Please note the following consequences of retrieving a departments-only
histogram:
If Express only finds items or products in stand-alone domains,
then ItemCount or ProductCount could be 0. For example, if Express finds
catalog products in two departments, but only finds items in a
stand-alone product type (like DVDs & Movies),
ItemCount would be 0 in the two departments.
Furthermore, if all matching items and catalog products are in
stand-alone domains, no histogram is returned at all (because there are
no matching departments). This might occur when you also add filters
(e.g., LowestPrice) or more query keywords to your request.)<br>
<br>
If the request only specifies DepartmentName, retrieve a histogram
for that department and all of its aisles (but no histogram details
for any product types it contains).
If the request only specifies AisleName, retrieve the full histogram
for that aisle, including all of its product types and the
parent department.
If the request only specifies ProductTypeName, retrieve the histogram
for its parent department (and any aisles), or only retrieve the
histogram for the product type if isn't grouped into
a department.<br>
<br>
For ProductDetails, retrieve the Title, MinPrice, and MaxPrice fields
for each product found.<br>
<br>
For ItemDetails, retrieve the ItemID, Title, BuyItNowPrice,
and ShippingDetails node for each item found.



=cut


use constant Coarse => scalar('Coarse');


=head2 Fine

(in) For HistogramDetails, retrieve a full histogram (all levels of the
domain hierarchy) that matches the request.
If you specify Fine, you must also specify DepartmentName, AisleName,
and/or ProductTypeName in the request.
If the request only specifies DepartmentName, retrieve a full histogram
for that department, all of its aisles, and all of its product types.
If the request only specifies AisleName or ProductTypeName, the results
are the same as specifying Coarse.<br>
<br>
For ProductDetails, retrieve all applicable fields for each
catalog product found.<br>
<br>
For ItemDetails, retrieve all applicable fields for each item found.



=cut


use constant Fine => scalar('Fine');


=head2 None

(in) For HistogramDetails, omits the histogram from the response.
For ProductDetails, omits the ProductArray from the response.
For ItemDetails, omits the ItemArray from the response.



=cut


use constant None => scalar('None');


=head2 CustomCode

(out) Reserved for internal or future use.



=cut


use constant CustomCode => scalar('CustomCode');







1;   
