# Generated by default/object.tt
package Paws::Config::StoredQuery;
  use Moose;
  has Description => (is => 'ro', isa => 'Str');
  has Expression => (is => 'ro', isa => 'Str');
  has QueryArn => (is => 'ro', isa => 'Str');
  has QueryId => (is => 'ro', isa => 'Str');
  has QueryName => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Config::StoredQuery

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Config::StoredQuery object:

  $service_obj->Method(Att1 => { Description => $value, ..., QueryName => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Config::StoredQuery object:

  $result = $service_obj->Method(...);
  $result->Att1->Description

=head1 DESCRIPTION

Provides the details of a stored query.

=head1 ATTRIBUTES


=head2 Description => Str

A unique description for the query.


=head2 Expression => Str

The expression of the query. For example, C<SELECT resourceId,
resourceType,
supplementaryConfiguration.BucketVersioningConfiguration.status WHERE
resourceType = 'AWS::S3::Bucket' AND
supplementaryConfiguration.BucketVersioningConfiguration.status =
'Off'.>


=head2 QueryArn => Str

Amazon Resource Name (ARN) of the query. For example,
arn:partition:service:region:account-id:resource-type/resource-name/resource-id.


=head2 QueryId => Str

The ID of the query.


=head2 B<REQUIRED> QueryName => Str

The name of the query.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Config>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

