package IO::K8s::Api::Admissionregistration::V1::ServiceReference;
# ABSTRACT: ServiceReference holds a reference to Service.legacy.k8s.io
our $VERSION = '1.003';
use IO::K8s::Resource;

k8s name => Str, 'required';


k8s namespace => Str, 'required';


k8s path => Str;


k8s port => Int;


1;

__END__

=pod

=encoding UTF-8

=head1 NAME

IO::K8s::Api::Admissionregistration::V1::ServiceReference - ServiceReference holds a reference to Service.legacy.k8s.io

=head1 VERSION

version 1.003

=head2 name

`name` is the name of the service. Required

=head2 namespace

`namespace` is the namespace of the service. Required

=head2 path

`path` is an optional URL path which will be sent in any request to this service.

=head2 port

If specified, the port on the service that hosting webhook. Default to 443 for backward compatibility. `port` should be a valid port number (1-65535, inclusive).

=head1 SUPPORT

=head2 Issues

Please report bugs and feature requests on GitHub at
L<https://github.com/pplu/io-k8s-p5/issues>.

=head2 IRC

Join C<#kubernetes> on C<irc.perl.org> or message Getty directly.

=head1 CONTRIBUTING

Contributions are welcome! Please fork the repository and submit a pull request.

=head1 AUTHORS

=over 4

=item *

Torsten Raudssus <torsten@raudssus.de>

=item *

Jose Luis Martinez <jlmartin@cpan.org> (original author, inactive)

=back

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2018 by Jose Luis Martinez.

This is free software, licensed under:

  The Apache License, Version 2.0, January 2004

=cut
