<?php
/**
 *
 * @license    GPL 2 (http://www.gnu.org/licenses/gpl.html)
 * @author     Myron Turner <turnermm02@shaw.ca>
 */
 
if(!defined('DOKU_INC')) die();
if(!defined('DOKU_PLUGIN')) define('DOKU_PLUGIN',DOKU_INC.'lib/plugins/');
require_once(DOKU_PLUGIN.'action.php');

 
class action_plugin_dwfckg_table extends DokuWiki_Action_Plugin { 

  
  /**
   * return some info
   */
  function getInfo(){
    return array(
		 'author' => 'Myron Turner',
		 'email'  => 'turnermm03@shaw.ca',
		 'date'   => '2007-09-18',
		 'name'   => 'table fromatter',
		 'desc'   => 'handles table formatting for dwfckg',
		 'url'    => 'http://www.mturner.org',
		 );
  }
 

  /*
   * Register its handlers with the dokuwiki's event controller
   */
  function register(&$controller) {
    $controller->register_hook('TPL_CONTENT_DISPLAY', 'BEFORE', $this, 'write_event_before');
  }



   function write_event_before (&$event, $param) {

//$this->debug( $event->data);
     $rev_text="";

      $event->data =  str_replace ( '$', '\$', $event->data); 
 
     
      preg_match('/(<table.*\/table>)/ms', $event->data, $tables); 
      if(isset($tables[1])) {
              $tables[1] = $this->get_theader($tables[1]);
              $rev_text = preg_replace_callback(            
                        "|(<td.*?>.*?</td>)|ms",
                          "td_color_spec",
                          $tables[1]);

         
         $rev_text =  str_replace ( 'dwfckgTableOpenBRACKET', '&lt;', $rev_text);  
         $event->data = preg_replace('/<table.*\/table>/ms',$rev_text, $event->data); 
    
      }
   
       $event->data =  str_replace ( '\$', '$', $event->data);
       //$event->data =  str_replace ( 'dwfckgTableOpenBRACKET', '&lt;', $event->data); 
// $this->debug("\n\nEVENT DATA===>" . $event->data);
   }


 function debug($data) {
    $handle = fopen('table_debug.txt', 'w');
  
    fwrite($handle,$data . "\n\n");
    fclose($handle);
 }

 function get_theader($table) {
    preg_match_all('/(<table.*?>)[\n\s]+(<tr\s+class="row0">[\n\s]+<td.*?>(.*?)<\/td>[\n\s]+<\/tr>)/', $table, $matches);
    
    for($i=0; $i<count($matches[2]); $i++) {                    
              if(preg_match('/\+\+THEAD\+\+/', $matches[3][$i])) { 
                  list($thead,$align) = preg_split('/\s+/', $matches[3][$i]);
                  list($name,$value) = explode("=",$align);
                  $align = "$name='$value'";
                  
                  if($value == 'center') {
                      $align .=" style='margin:auto;'";
                  }
                  elseif($value == 'right') {                  
                      $align .=" style='margin-left:12px;margin-right:6px;margin-bottom:6px;margin-top:6px;'";
                  }                  
                  elseif($value == 'left') {
                    $align .=" style='margin-left:6px;margin-right:12px;margin-bottom:6px;margin-top:6px;'";               
                  }

                  $tr = preg_quote($matches[2][$i],'/');      
                  $table = preg_replace("/$tr/", "", $table, 1);          
                  $tbl =  preg_quote($matches[1][$i],'/');                  
                  $tbl_rev = str_replace('>', " $align>", $matches[1][$i]);       
                  $table = preg_replace("/$tbl/", $tbl_rev, $table, 1);
              }
          
    }
    return $table;  
  }

}

 // the callback function
function td_color_spec($matches)
{

// Uses rgb value or else selects the first non-white indent color as cell background

   $aligns = array('L'=> "left", 'R'=> "right", 'C'=> "center");
   $col_span = preg_match('/colspan\s*=\s*[\'"]\d+[\'"]/', $matches[1], $colspan) ? $colspan[0] : "";
   $width = "";
   if(preg_match('/#([RLC])(rgb\(\d+,\s*\d+,\s*\d+\))(\d*px)*#/', $matches[1], $color)) {         
        $align = $aligns[$color[1]];
        if(isset($color[3])) {
          $width = '; width: ' . $color[3]; 
        }
        return preg_replace('/<td.*?>\s*#[RLC]rgb\(\d+,\s*\d+,\s*\d+\)(\d*px)*#/', 
              "<td  $col_span align = '$align'  style='background-color:$color[2] $width'>", $matches[1]);          
   }
   elseif(preg_match('/#([RLC])(\d*px)*#/', $matches[1], $alignment)) {         
        $align = $aligns[$alignment[1]];
        if(isset($alignment[2])) {
          $width = " style='width: " . $alignment[2] . "';";
        }
        return preg_replace('/<td.*?>\s*#[RLC](\d*px)*#/', 
              "<td $col_span align = '$align'  $width >", $matches[1]);          
   }
   if(preg_match('/#(rgb\(\d+,\s*\d+,\s*\d+\))(\d*px)*#/', $matches[1], $color)) {         
        if(isset($color[2])) {
          $width = '; width: ' . $color[2]; 
        }
        return preg_replace('/<td.*?>\s*#rgb\(\d+,\s*\d+,\s*\d+\)(\d*px)*#/',
          "<td $col_span style='background-color:$color[1] $width'>", $matches[1]);          
   }   
   elseif(preg_match_all('/<indent\s+style=\s*"color:(.*?)>/', $matches[1], $color)) {
           if(count($color[1] > 1)) {
                $i_colors = $color[1];
                $i_color = "white"; 
                for($i=0; $i< count($i_colors); $i++) {
                   $i_colors[$i] = trim($i_colors[$i]);
                   $i_colors[$i] = preg_replace('/[\s\'\"]/',"",$i_colors[$i]);                   

                   if($i_colors[$i] != 'white') {
                      $i_color = $i_colors[$i];
                      $matches[1] = preg_replace('/color:\s*white/', "color:$i_color", $matches[1]); 
                      break;  
                   }
                }

           }
           else { 

               $i_color = trim($color[1][0]);
               $i_color = preg_replace('/[\s\'\"]/',"",$i_color);            
           }

            
           return preg_replace('/<td.*?>/', "<td style='background-color:$i_color'>", $matches[1]);          
   }


// Select the first background-color as cell background
   preg_match_all('/background-color:(.*?);/',$matches[1], $bg_color);
   if(count($bg_color[1] > 1)) {
     $color_1 = trim($bg_color[1][0]);
     $color_2 = trim($bg_color[1][1]);
     $color_1 = preg_replace('/\s/',"",$color_1); 
     $color_2 = preg_replace('/\s/',"",$color_2); 
     if($color_1 == $color_2){
        return preg_replace('/<td>/', "<td style='background-color:$color_1'>", $matches[1]);      
     }
   }

   return $matches[1];
}
 


