Name:           perl-LCFG-Utils
Summary:        Perl API for LCFG utilities
Version:        1.13.4
Release:        1
Packager:       Stephen Quinney <squinney@inf.ed.ac.uk>
License:        GPLv2
Group:          LCFG/Utilities
Source:         LCFG-Utils-Perl-1.13.4.tar.gz
BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
Requires:       perl(:MODULE_COMPAT_%(eval "`%{__perl} -V:version`"; echo $version))
Requires:	perl(XML::Parser), perl(HTML::Parser)
Requires:       perl(Template)
BuildArch:      noarch
BuildRequires:  perl(Readonly), perl(Digest::SHA), perl(HTML::Entities)
BuildRequires:  perl(Template), perl(DB_File)
BuildRequires:  perl >= 5.16.0
BuildRequires:  perl(Module::Build)
BuildRequires:  perl(Test::More), perl(Test::File::Contents)
BuildRequires:  /usr/bin/pod2man
Provides:	perl(LCFG::DB_File)

%description
This package provides Perl modules for handling LCFG template
files and querying/modifying the LCFG resource database.

%prep
%setup -q -n LCFG-Utils-Perl-%{version}

%build
%{__perl} Build.PL installdirs=vendor
./Build
pod2man --section=8 sbin/lcfgdiff lcfgdiff.8

%install
rm -rf $RPM_BUILD_ROOT

./Build install destdir=$RPM_BUILD_ROOT create_packlist=0

mkdir -p $RPM_BUILD_ROOT/%{_mandir}/man8/
cp lcfgdiff.8 $RPM_BUILD_ROOT/%{_mandir}/man8/
                                  
%{_fixperms} $RPM_BUILD_ROOT/*

%check
prove --verbose --lib t

%files
%defattr(-,root,root)
%doc ChangeLog EXAMPLE README
%attr(0555,root,root)%{_sbindir}/lcfgdiff
%{perl_vendorlib}/LCFG/*.pm
%{perl_vendorlib}/LCFG/Utils/Diff/*.pm
%{_mandir}/man3/*
%{_mandir}/man8/*

%clean
rm -rf $RPM_BUILD_ROOT

%changelog
* Thu Jan 31 2019 SVN: new release
- Release: 1.13.4

* Thu Jan 31 2019 16:08  squinney@INF.ED.AC.UK
- Makefile.PL: Need to get version from a module which is still in this
  package

* Thu Jan 31 2019 16:06  squinney@INF.ED.AC.UK
- t/00_load.t: Do not test LCFG::Utils, it is no longer part of this
  package

* Thu Jan 31 2019 16:00  squinney@INF.ED.AC.UK
- ChangeLog, debian/changelog, lcfg.yml: LCFG-Utils-Perl release: 1.13.3

* Thu Jan 31 2019 15:37  squinney@INF.ED.AC.UK
- LCFG-Utils-Perl.spec: Added missing build-deps

* Thu Jan 31 2019 15:29  squinney@INF.ED.AC.UK
- ChangeLog, debian/changelog, lcfg.yml: LCFG-Utils-Perl release: 1.13.2

* Thu Jan 31 2019 15:29  squinney@INF.ED.AC.UK
- debian/copyright, lcfg.yml: Updated copyright

* Thu Jan 31 2019 15:25  squinney@INF.ED.AC.UK
- ChangeLog, debian/changelog, lcfg.yml: LCFG-Utils-Perl release: 1.13.1

* Thu Jan 31 2019 15:25  squinney@INF.ED.AC.UK
- debian/control, debian/manpages, debian/rules, lcfg.yml: Generate manpage
  for lcfgdiff utility

* Thu Jan 31 2019 15:22  squinney@INF.ED.AC.UK
- debian/control, lcfg.yml: Fixed build-depends

* Thu Jan 31 2019 15:18  squinney@INF.ED.AC.UK
- META.json.cin, META.yml.cin, lcfg.yml: More metadata updates

* Thu Jan 31 2019 15:14  squinney@INF.ED.AC.UK
- Makefile.PL: Updated build script

* Thu Jan 31 2019 15:11  squinney@INF.ED.AC.UK
- Build.PL.cin: updated deps lists

* Thu Jan 31 2019 15:09  squinney@INF.ED.AC.UK
- debian, debian/compat, debian/control, debian/copyright, debian/docs,
  debian/rules, debian/source, debian/source/format: First attempt at
  debian package info

* Thu Jan 31 2019 15:09  squinney@INF.ED.AC.UK
- MANIFEST: Updated MANIFEST for files which have been moved to other
  packages

* Thu Jan 31 2019 15:06  squinney@INF.ED.AC.UK
- LCFG-Utils-Perl.spec: Generate man page for lcfgdiff. Run tests after
  build

* Thu Jan 31 2019 12:16  squinney@INF.ED.AC.UK
- LCFG-Utils-Perl.spec, lcfg.yml: Updated build-requirements. Switched to
  noarch since there are no longer any XS modules

* Thu Jan 31 2019 12:15  squinney@INF.ED.AC.UK
- ppport.h: No need for this file, no XS modules in the package

* Thu Jan 31 2019 12:15  squinney@INF.ED.AC.UK
- sbin/lcfgdiff.cin: Updated docs

* Thu Jan 31 2019 12:08  squinney@INF.ED.AC.UK
- sbin/lcfgdiff.cin: require XML::Parser in an eval block rather than
  string

* Mon Mar 12 2018 13:00  squinney@INF.ED.AC.UK
- ChangeLog, lcfg.yml: LCFG-Utils-Perl release: 1.13.0

* Mon Mar 12 2018 12:59  squinney@INF.ED.AC.UK
- lib/LCFG/Template.pm.cin: Fixed Delimiters method for change to perl
  options handling

* Mon Mar 12 2018 12:57  squinney@INF.ED.AC.UK
- lib/LCFG/Template.pm.cin: Pass on any include path to Template Toolkit so
  that includes from within templates will work

* Mon Mar 12 2018 11:49  squinney@INF.ED.AC.UK
- lib/LCFG/Template.pm.cin: Set min perl version to 5.10 so we can use
  state variables

* Mon Mar 12 2018 11:29  squinney@INF.ED.AC.UK
- lib/LCFG/Template.pm.cin: Added support for setting an 'include path'
  which will be searched if the template file name is not an absolute path

* Thu Jun 22 2017 12:14  squinney@INF.ED.AC.UK
- ChangeLog, lcfg.yml: LCFG-Utils-Perl release: 1.12.5

* Thu Jun 22 2017 11:21  squinney@INF.ED.AC.UK
- LCFG-Utils-Perl.spec, bin/qxprof.cin, bin/sxprof.cin, lcfg.yml: Moved
  qxprof and sxprof to the LCFG-Client package. This means the specfile
  dependency filtering can be dropped since the bootstrapping problems are
  now resolved

* Wed May 17 2017 11:30  squinney@INF.ED.AC.UK
- ChangeLog, lcfg.yml: LCFG-Utils-Perl release: 1.12.4

* Wed May 17 2017 11:30  squinney@INF.ED.AC.UK
- Build.PL.cin, LCFG-Utils-Perl.spec, MANIFEST, lcfg.yml,
  lib/LCFG/Utils.pm.cin, lib/LCFG/Utils.xs.cin, sbin/lcfgmkdir.cin: Moved
  the LCFG::Utils module and lcfgmkdir to LCFG-Core-Perl

* Wed May 17 2017 09:59  squinney@INF.ED.AC.UK
- ChangeLog, lcfg.yml: LCFG-Utils-Perl release: 1.12.3

* Wed May 17 2017 09:59  squinney@INF.ED.AC.UK
- LCFG-Utils-Perl.spec, lcfg.yml: updated deps on lcfg-core

* Wed Aug 10 2016 09:24  squinney@INF.ED.AC.UK
- lcfg.yml, lib/LCFG/Resources.pm.cin: Added note about Load needing the
  full nodename

* Thu Jul 14 2016 08:23  squinney@INF.ED.AC.UK
- ChangeLog, lcfg.yml: LCFG-Utils-Perl release: 1.12.2

* Thu Jul 14 2016 08:23  squinney@INF.ED.AC.UK
- LCFG-Utils-Perl.spec, README: Updated dependencies to refer to lcfg-core

* Wed Jul 13 2016 18:50  squinney@INF.ED.AC.UK
- ChangeLog, lcfg.yml: LCFG-Utils-Perl release: 1.12.1

* Wed Jul 13 2016 18:50  squinney@INF.ED.AC.UK
- MANIFEST: removed generated files from manifest

* Wed Jul 13 2016 18:49  squinney@INF.ED.AC.UK
- ChangeLog, lcfg.yml: LCFG-Utils-Perl release: 1.12.0

* Wed Jul 13 2016 18:48  squinney@INF.ED.AC.UK
- Build.PL.cin, LCFG-Utils-Perl.spec, MANIFEST, MANIFEST.SKIP,
  META.json.cin, META.yml.cin, Makefile.PL, README, lcfg.yml,
  lib/LCFG/Utils.xs.cin: Updated to link against the new version of
  lcfg_utils from lcfg-profilelib

* Mon Mar 21 2016 12:08  squinney@INF.ED.AC.UK
- ChangeLog, lcfg.yml: LCFG-Utils-Perl release: 1.11.0

* Mon Mar 21 2016 12:08  squinney@INF.ED.AC.UK
- LCFG-Utils-Perl.spec: build depend on perl(HTML::Entities)

* Mon Mar 21 2016 12:06  squinney@INF.ED.AC.UK
- lcfg.yml, lib/LCFG/Resources.pm.cin: WriteFile now does a numeric html
  encoding of resource values when they are stored into status files. This
  avoids problems with newlines and other troublesome characters breaking
  the file parser. The ReadFile method will now decode any of these html
  encoded values

* Thu Nov 12 2015 15:16  squinney@INF.ED.AC.UK
- ChangeLog, lcfg.yml: LCFG-Utils-Perl release: 1.10.1

* Thu Nov 12 2015 15:13  squinney@INF.ED.AC.UK
- Build.PL.cin: Fixed header include path and library path for MacOSX (and
  any other platform where stuff is put into /usr/local

* Thu Nov 12 2015 15:12  squinney@INF.ED.AC.UK
- bin/qxprof.cin, bin/sxprof.cin: Removed hardwired path to profile dbm
  directory

* Thu Nov 12 2015 15:11  squinney@INF.ED.AC.UK
- lib/LCFG/Resources.pm.cin: Removed hardwired path to profile dbm
  directory

* Fri Nov 06 2015 17:38  squinney@INF.ED.AC.UK
- Build.PL.cin, META.yml.cin, bin/qxprof.cin, bin/sxprof.cin,
  lib/LCFG/DB_File.pm.cin, lib/LCFG/Resources.pm.cin,
  lib/LCFG/Template.pm.cin, lib/LCFG/Utils.pm.cin,
  lib/LCFG/Utils/Diff/Log.pm.cin, lib/LCFG/Utils/Diff/Module.pm.cin,
  sbin/lcfgdiff.cin, sbin/lcfgmkdir.cin: Fixed version strings in Perl code
  so they are always safe

* Thu Jun 05 2014 11:22  squinney@INF.ED.AC.UK
- ChangeLog, lcfg.yml: LCFG-Utils-Perl release: 1.10.0

* Thu Jun 05 2014 11:21  squinney@INF.ED.AC.UK
- bin/qxprof.cin, lcfg.yml: If the component status option is enabled and
  the user just wants all resources listing it's now possible to avoid
  specifying the component name twice

* Thu Jun 05 2014 11:13  squinney@INF.ED.AC.UK
- bin/qxprof.cin: Added support for reading component status files

* Fri May 16 2014 12:59  squinney@INF.ED.AC.UK
- ChangeLog, lcfg.yml: LCFG-Utils-Perl release: 1.9.2

* Fri May 16 2014 12:58  squinney@INF.ED.AC.UK
- LCFG-Utils-Perl.spec: Added explicit dependency on perl(Template)

* Thu May 08 2014 14:14  cc@INF.ED.AC.UK
- ChangeLog, lcfg.yml: LCFG-Utils-Perl release: 1.9.1

* Thu May 08 2014 13:52  cc@INF.ED.AC.UK
- ChangeLog: Mass LCFG rebuild for Red Hat Enterprise Linux 7.0 RC 1

* Thu Apr 03 2014 11:23  squinney@INF.ED.AC.UK
- ChangeLog, lcfg.yml: LCFG-Utils-Perl release: 1.9.0

* Thu Apr 03 2014 11:22  squinney@INF.ED.AC.UK
- lcfg.yml, lib/LCFG/Resources.pm.cin: Added a new DBMDir subroutine which
  can be used to query and alter the directory in which we look for DBM
  files for nodes

* Mon Mar 31 2014 14:50  squinney@INF.ED.AC.UK
- ChangeLog, lcfg.yml: LCFG-Utils-Perl release: 1.8.0

* Mon Mar 31 2014 14:44  squinney@INF.ED.AC.UK
- Build.PL.cin, LCFG-Utils-Perl.spec, Makefile.PL, README: Added dependency
  on Digest::SHA

* Mon Mar 31 2014 14:28  squinney@INF.ED.AC.UK
- lib/LCFG/Template.pm.cin: When storing generated files, this switches
  from directly comparing files to comparing file contents using the hex
  digest of the SHA1 checksum. This avoids needlessly creating temporary
  files all the time

* Mon Mar 03 2014 11:26  squinney@INF.ED.AC.UK
- ChangeLog, lcfg.yml: LCFG-Utils-Perl release: 1.7.0

* Mon Mar 03 2014 11:26  squinney@INF.ED.AC.UK
- lib/LCFG/Template.pm.cin: moved default file creation mode into a
  readonly global variable for clarity

* Mon Feb 24 2014 19:23  squinney@INF.ED.AC.UK
- lib/LCFG/Template.pm.cin: fixed the way SaveFile does comparisons so that
  it handles 'skip files' correctly. This has been broken for quite a long
  time so clearly isn't being heavily used...

* Mon Feb 24 2014 16:24  squinney@INF.ED.AC.UK
- lib/LCFG/Template.pm.cin: Reworked the mode and umask handling so that it
  is simpler and actually achieves the desired result in all cases

* Mon Feb 24 2014 15:50  squinney@INF.ED.AC.UK
- lib/LCFG/Template.pm.cin: Some small tidying and removal of modules we no
  longer need

* Mon Feb 24 2014 15:42  squinney@INF.ED.AC.UK
- lib/LCFG/Template.pm.cin: Improved the security of the SaveFile method.
  It now uses File::Temp to get a temporary file with a random file name.
  The way the backup file is created (if desired) is now improved so that
  permissions are not accidentally dropped. Also the use of the 'cmp'
  program has been replaced with File::Compare to avoid starting a shell

* Fri Jan 24 2014 09:57  squinney@INF.ED.AC.UK
- ChangeLog, lcfg.yml: LCFG-Utils-Perl release: 1.6.0

* Fri Jan 24 2014 09:57  squinney@INF.ED.AC.UK
- LCFG-Utils-Perl.spec, lcfg.yml: Avoid scanning bin files for
  auto-requires, this means we don't end up depending on LCFG::Client which
  causes bootstrapping problems

* Fri Jan 24 2014 09:56  squinney@INF.ED.AC.UK
- bin/qxprof.cin, bin/sxprof.cin: Slightly reworked the host to node name
  discovery to use the improved functions supplied by the latest version of
  the V3 client

* Thu Oct 10 2013 10:48  squinney@INF.ED.AC.UK
- ChangeLog, lcfg.yml: LCFG-Utils-Perl release: 1.5.1

* Thu Oct 10 2013 10:48  squinney@INF.ED.AC.UK
- bin/qxprof.cin, bin/sxprof.cin: Use LCFG::Client::NodeName to translate
  the specified host name into the lcfg node name

* Thu Oct 10 2013 10:46  squinney@INF.ED.AC.UK
- lib/LCFG/Resources.pm.cin: tweaked docs

* Thu May 30 2013 12:18  squinney@INF.ED.AC.UK
- ChangeLog, lcfg.yml: LCFG-Utils-Perl release: 1.5.0

* Thu May 30 2013 12:18  squinney@INF.ED.AC.UK
- lib/LCFG/Resources.pm.cin: Reworked the DBMFile method so that it matches
  the new behaviour of the lcfg client where all dbm files are named after
  the fqdn. This simplifies a lot of things.

* Thu May 23 2013 10:46  squinney@INF.ED.AC.UK
- ChangeLog, lcfg.yml: LCFG-Utils-Perl release: 1.4.0

* Thu May 23 2013 10:46  squinney@INF.ED.AC.UK
- LCFG-Utils-Perl.spec, bin/qxprof.cin, bin/sxprof.cin, lcfg.yml,
  lib/LCFG/Resources.pm.cin: Altered qxprof and sxprof scripts so that they
  use the NodeName function from LCFG::Client to get the current node name
  rather than using the host name, this requires at least version 3.1.0 of
  the LCFG::Client module. Also fixed LCFG::Resources::Load so that it
  handles fully-qualified domain names in the same way as the client. This
  makes it work with profiles which are in a different domain to the
  current host

* Thu May 12 2011 14:26  squinney@INF.ED.AC.UK
- ChangeLog, lcfg.yml: LCFG-Utils-Perl release: 1.3.11

* Thu May 12 2011 14:17  squinney@INF.ED.AC.UK
- lib/LCFG/Utils.pm.cin: Reworked the MkDir function to handle the
  situation in which the directory already exists and no mode has been
  specified. This should fix https://bugs.lcfg.org/show_bug.cgi?id=380

* Thu Mar 17 2011 14:59  squinney@INF.ED.AC.UK
- ChangeLog, lcfg.yml: LCFG-Utils-Perl release: 1.3.10

* Thu Mar 17 2011 14:58  squinney@INF.ED.AC.UK
- ChangeLog, lcfg.yml: Added SL6 as a supported platform

* Fri Sep 24 2010 14:09  squinney@INF.ED.AC.UK
- LCFG-Utils-Perl.spec: Added requirement on diffutils which is needed for
  the template processing

* Wed May 12 2010 13:37  squinney@INF.ED.AC.UK
- ChangeLog, lcfg.yml: LCFG-Utils-Perl release: 1.3.9

* Wed May 12 2010 13:13  squinney@INF.ED.AC.UK
- lib/LCFG/Template.pm.cin: Added new 'literal' processing mode which does
  no substitution on file contents but does everything else (e.g. mode
  setting)

* Wed Apr 07 2010 13:44  squinney@INF.ED.AC.UK
- ChangeLog, lcfg.yml: LCFG-Utils-Perl release: 1.3.8

* Wed Apr 07 2010 13:44  squinney@INF.ED.AC.UK
- lib/LCFG/Template.pm.cin: Replaced the globals hash in the LCFG::Template
  class with a hash scoped within the Transform() subroutine. This was used
  in the old LCFG-style templates to store variables created using <%set%>.
  Inadvertently this meant that variables set in a template in one call to
  the LCFG::Template::Substitute were available in any following calls.
  This led to unexpected behaviour which was dependent on the order in
  which templates were processed.

* Thu Apr 01 2010 12:17  squinney@INF.ED.AC.UK
- ChangeLog, lcfg.yml: LCFG-Utils-Perl release: 1.3.7

* Thu Apr 01 2010 07:23  squinney@INF.ED.AC.UK
- t/01_template.t, t/templates/for.tmpl: fixed test template

* Thu Apr 01 2010 07:09  squinney@INF.ED.AC.UK
- LCFG-Utils-Perl.spec, t, t/00_load.t, t/01_template.t, t/expected,
  t/expected/for.txt, t/templates, t/templates/for.tmpl: Started adding
  some tests

* Thu Apr 01 2010 06:07  squinney@INF.ED.AC.UK
- lib/LCFG/Template.pm.cin: The main regexp in Scan() was missing a ^ to
  tie it down which meant it took an astronomical amount of time to parse
  large files

* Mon Mar 29 2010 14:31  squinney@INF.ED.AC.UK
- ChangeLog, lcfg.yml: LCFG-Utils-Perl release: 1.3.6

* Mon Mar 29 2010 14:31  squinney@INF.ED.AC.UK
- lcfg.yml, lib/LCFG/Template.pm.cin: Fixed a problem in SaveFile where it
  did not honour the current umask. This could result in files being
  unintentionally publicably readable

* Mon Mar 15 2010 18:47  squinney@INF.ED.AC.UK
- ChangeLog, lcfg.yml: LCFG-Utils-Perl release: 1.3.5

* Mon Mar 15 2010 18:47  squinney@INF.ED.AC.UK
- lcfg.yml: Fixed the LCFG::Template::Scan method so it escapes any regexp
  metacharacters in the left and right delimiters

* Mon Mar 15 2010 18:36  squinney@INF.ED.AC.UK
- lib/LCFG/Template.pm.cin: Quote any regexp chars in the delimiters

* Mon Mar 15 2010 18:24  squinney@INF.ED.AC.UK
- lib/LCFG/Template.pm.cin: Improved LCFG::Template::Scan regex to avoid
  bug triggered by using F12

* Thu Feb 25 2010 16:56  cc@INF.ED.AC.UK
- ChangeLog, lcfg.yml: LCFG-Utils-Perl release: 1.3.4

* Thu Feb 25 2010 16:56  cc@INF.ED.AC.UK
- ChangeLog, lcfg.yml: seems to work fine on F12

* Mon Nov 30 2009 12:35  squinney@INF.ED.AC.UK
- ChangeLog, lcfg.yml: LCFG-Utils-Perl release: 1.3.3

* Mon Nov 30 2009 12:35  squinney@INF.ED.AC.UK
- lcfg.yml, lib/LCFG/DB_File.pm.cin, lib/LCFG/Resources.pm.cin,
  lib/LCFG/Template.pm.cin, lib/LCFG/Utils/Diff/Log.pm.cin,
  lib/LCFG/Utils/Diff/Module.pm.cin: Use our() instead of my() for $VERSION
  so that the rpm auto-provides script gets the versions correct

* Mon Nov 30 2009 12:25  squinney@INF.ED.AC.UK
- ChangeLog, lcfg.yml: LCFG-Utils-Perl release: 1.3.2

* Mon Nov 30 2009 12:25  squinney@INF.ED.AC.UK
- LCFG-Utils-Perl.spec: Set the minimum build-requirement on
  lcfg-utils-devel to 1.3.1 to clear out a compilation warning

* Mon Nov 30 2009 12:24  squinney@INF.ED.AC.UK
- lib/LCFG/Template.pm.cin: Made the LCFG::Template variables ($DUMMY,
  $NOBACK and $PERLTMPL) readonly and made them available for export

* Tue Jun 16 2009 11:29  squinney@INF.ED.AC.UK
- ChangeLog, lcfg.yml: LCFG-Utils-Perl release: 1.3.1

* Tue Jun 16 2009 11:29  squinney@INF.ED.AC.UK
- lcfg.yml: bumped version number so it is greater than the old version of
  lcfg-utils which provided these Perl modules. This should avoid
  dependency resolution issues with yum/mock

* Wed Apr 08 2009 16:04  squinney@INF.ED.AC.UK
- ChangeLog, lcfg.yml: LCFG-Utils-Perl release: 1.0.5

* Wed Apr 08 2009 16:04  squinney@INF.ED.AC.UK
- LCFG-Utils-Perl.spec, bin/qxprof.cin, bin/sxprof.cin, lcfg.yml,
  sbin/lcfgdiff.cin, sbin/lcfgmkdir.cin: fixed the mode for some scripts

* Wed Apr 08 2009 16:04  squinney@INF.ED.AC.UK
- lib/LCFG/Utils/Diff/Log.pm.cin: Fixed error with specifying emacs mode
  which resulted in the module not compiling

* Wed Mar 25 2009 16:35  squinney@INF.ED.AC.UK
- ChangeLog, lcfg.yml: LCFG-Utils-Perl release: 1.0.4

* Wed Mar 25 2009 16:34  squinney@INF.ED.AC.UK
- lib/LCFG/Template.pm.cin: decided on a more conservative approach which
  also checks the length of the string

* Wed Mar 25 2009 16:01  squinney@INF.ED.AC.UK
- ChangeLog, lcfg.yml: LCFG-Utils-Perl release: 1.0.3

* Wed Mar 25 2009 16:01  squinney@INF.ED.AC.UK
- lib/LCFG/Template.pm.cin: Fixed LCFG::Template::Scan to handle text which
  is '0'. See https://bugs.lcfg.org/show_bug.cgi?id=128 for full details

* Thu Mar 12 2009 15:05  squinney@INF.ED.AC.UK
- Build.PL.cin, META.yml.cin, lib/LCFG/DB_File.pm.cin,
  lib/LCFG/Resources.pm.cin, lib/LCFG/Template.pm.cin,
  lib/LCFG/Utils.pm.cin, lib/LCFG/Utils/Diff/Log.pm.cin,
  lib/LCFG/Utils/Diff/Module.pm.cin: Massive setting of svn:keywords
  property on component scripts, schemas, pod files and Perl modules

* Wed Mar 04 2009 13:04  squinney
- ChangeLog, lcfg.yml: Release: 1.0.2

* Wed Mar 04 2009 13:04  squinney
- LCFG-Utils-Perl.spec: The build now requires lcfg-utils-devel >= 1.3.0

* Wed Mar 04 2009 11:59  squinney
- LCFG-Utils-Perl.spec: specfile updated to show the dependencies on
  XML::Parser and HTML::Parser. Also mentioned that the package provides
  LCFG::DB_File

* Wed Mar 04 2009 11:08  squinney
- ChangeLog, lcfg.yml: Release: 1.0.1

* Wed Mar 04 2009 11:08  squinney
- LCFG-Utils-Perl.spec: Need Module::Build in the specfile build-requires
  list

* Wed Mar 04 2009 11:02  squinney
- ChangeLog, lcfg.yml: Release: 1.0.0

* Wed Mar 04 2009 10:59  squinney
- ChangeLog, lcfg.yml: Release: 0.0.3

* Wed Mar 04 2009 10:59  squinney
- bin/qxprof.cin, bin/sxprof.cin, lib/LCFG/DB_File.pm.cin,
  lib/LCFG/Resources.pm.cin, lib/LCFG/Template.pm.cin,
  lib/LCFG/Utils.pm.cin, lib/LCFG/Utils/Diff/Log.pm.cin,
  lib/LCFG/Utils/Diff/Module.pm.cin, sbin/lcfgdiff.cin, sbin/lcfgmkdir.cin:
  Various improvements, mainly to the code comments

* Wed Mar 04 2009 10:47  squinney
- MANIFEST, META.yml.cin, Makefile.PL: Updated Perl metadata files

* Wed Mar 04 2009 10:38  squinney
- ChangeLog, lcfg.yml: Release: 0.0.2

* Wed Mar 04 2009 10:38  squinney
- README: Updated README some more

* Wed Mar 04 2009 10:38  squinney
- Build.PL.cin, LCFG-Utils-Perl.spec, MANIFEST, bin/lcfgdiff.cin,
  bin/lcfgmkdir.cin, lcfg.yml, sbin, sbin/lcfgdiff.cin, sbin/lcfgmkdir.cin:
  Moved lcfgdiff and lcfgmkdir to /usr/sbin where they should be

* Wed Mar 04 2009 10:37  squinney
- README: Added useful README

* Wed Mar 04 2009 10:20  squinney
- Build.PL.cin, EXAMPLE, LCFG-Utils-Perl.spec, MANIFEST, MANIFEST.SKIP,
  META.yml.cin, Makefile.PL, README.BUILD, bin, bin/lcfgdiff.cin,
  bin/lcfgmkdir.cin, bin/qxprof.cin, bin/sxprof.cin, lcfg.yml,
  lib/LCFG/DB_File.pm.cin, lib/LCFG/Resources.pm.cin,
  lib/LCFG/Template.pm.cin, lib/LCFG/Utils, lib/LCFG/Utils.pm.cin,
  lib/LCFG/Utils.xs.cin, lib/LCFG/Utils/Diff,
  lib/LCFG/Utils/Diff/Log.pm.cin, lib/LCFG/Utils/Diff/Module.pm.cin,
  ppport.h, specfile: Copied all perl stuff from lcfg-utils

* Tue Mar 03 2009 15:29  squinney
- lib, lib/LCFG, lib/LCFG/Template.pm.cin: copied LCFG::Template from
  lcfg-utils

* Tue Mar 03 2009 12:14  squinney
- ChangeLog, README, README.BUILD, lcfg.yml, specfile: Created with
  lcfg-skeleton

* Tue Mar 03 2009 12:14  
- .: Standard project directories initialized by cvs2svn.


