# Generated by default/object.tt
package Paws::Lightsail::ContainerServicePower;
  use Moose;
  has CpuCount => (is => 'ro', isa => 'Num', request_name => 'cpuCount', traits => ['NameInRequest']);
  has IsActive => (is => 'ro', isa => 'Bool', request_name => 'isActive', traits => ['NameInRequest']);
  has Name => (is => 'ro', isa => 'Str', request_name => 'name', traits => ['NameInRequest']);
  has PowerId => (is => 'ro', isa => 'Str', request_name => 'powerId', traits => ['NameInRequest']);
  has Price => (is => 'ro', isa => 'Num', request_name => 'price', traits => ['NameInRequest']);
  has RamSizeInGb => (is => 'ro', isa => 'Num', request_name => 'ramSizeInGb', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Lightsail::ContainerServicePower

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Lightsail::ContainerServicePower object:

  $service_obj->Method(Att1 => { CpuCount => $value, ..., RamSizeInGb => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Lightsail::ContainerServicePower object:

  $result = $service_obj->Method(...);
  $result->Att1->CpuCount

=head1 DESCRIPTION

Describes the powers that can be specified for an Amazon Lightsail
container service.

The power specifies the amount of RAM, the number of vCPUs, and the
base price of the container service.

=head1 ATTRIBUTES


=head2 CpuCount => Num

The number of vCPUs included in the power.


=head2 IsActive => Bool

A Boolean value indicating whether the power is active and can be
specified for container services.


=head2 Name => Str

The friendly name of the power (e.g., C<nano>).


=head2 PowerId => Str

The ID of the power (e.g., C<nano-1>).


=head2 Price => Num

The monthly price of the power in USD.


=head2 RamSizeInGb => Num

The amount of RAM (in GB) of the power.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Lightsail>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

