# Generated by default/object.tt
package Paws::AuditManager::AssessmentReportMetadata;
  use Moose;
  has AssessmentId => (is => 'ro', isa => 'Str', request_name => 'assessmentId', traits => ['NameInRequest']);
  has AssessmentName => (is => 'ro', isa => 'Str', request_name => 'assessmentName', traits => ['NameInRequest']);
  has Author => (is => 'ro', isa => 'Str', request_name => 'author', traits => ['NameInRequest']);
  has CreationTime => (is => 'ro', isa => 'Str', request_name => 'creationTime', traits => ['NameInRequest']);
  has Description => (is => 'ro', isa => 'Str', request_name => 'description', traits => ['NameInRequest']);
  has Id => (is => 'ro', isa => 'Str', request_name => 'id', traits => ['NameInRequest']);
  has Name => (is => 'ro', isa => 'Str', request_name => 'name', traits => ['NameInRequest']);
  has Status => (is => 'ro', isa => 'Str', request_name => 'status', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::AuditManager::AssessmentReportMetadata

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AuditManager::AssessmentReportMetadata object:

  $service_obj->Method(Att1 => { AssessmentId => $value, ..., Status => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AuditManager::AssessmentReportMetadata object:

  $result = $service_obj->Method(...);
  $result->Att1->AssessmentId

=head1 DESCRIPTION

The metadata objects associated with the specified assessment report.

=head1 ATTRIBUTES


=head2 AssessmentId => Str

The unique identifier for the associated assessment.


=head2 AssessmentName => Str

The name of the associated assessment.


=head2 Author => Str

The name of the user who created the assessment report.


=head2 CreationTime => Str

Specifies when the assessment report was created.


=head2 Description => Str

The description of the specified assessment report.


=head2 Id => Str

The unique identifier for the assessment report.


=head2 Name => Str

The name of the assessment report.


=head2 Status => Str

The current status of the assessment report.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AuditManager>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

