# Generated by default/object.tt
package Paws::Budgets::IamActionDefinition;
  use Moose;
  has Groups => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has PolicyArn => (is => 'ro', isa => 'Str', required => 1);
  has Roles => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has Users => (is => 'ro', isa => 'ArrayRef[Str|Undef]');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Budgets::IamActionDefinition

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Budgets::IamActionDefinition object:

  $service_obj->Method(Att1 => { Groups => $value, ..., Users => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Budgets::IamActionDefinition object:

  $result = $service_obj->Method(...);
  $result->Att1->Groups

=head1 DESCRIPTION

The AWS Identity and Access Management (IAM) action definition details.

=head1 ATTRIBUTES


=head2 Groups => ArrayRef[Str|Undef]

A list of groups to be attached. There must be at least one group.


=head2 B<REQUIRED> PolicyArn => Str

The Amazon Resource Name (ARN) of the policy to be attached.


=head2 Roles => ArrayRef[Str|Undef]

A list of roles to be attached. There must be at least one role.


=head2 Users => ArrayRef[Str|Undef]

A list of users to be attached. There must be at least one user.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Budgets>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

