# Generated by default/object.tt
package Paws::IoTEventsData::Alarm;
  use Moose;
  has AlarmModelName => (is => 'ro', isa => 'Str', request_name => 'alarmModelName', traits => ['NameInRequest']);
  has AlarmModelVersion => (is => 'ro', isa => 'Str', request_name => 'alarmModelVersion', traits => ['NameInRequest']);
  has AlarmState => (is => 'ro', isa => 'Paws::IoTEventsData::AlarmState', request_name => 'alarmState', traits => ['NameInRequest']);
  has CreationTime => (is => 'ro', isa => 'Str', request_name => 'creationTime', traits => ['NameInRequest']);
  has KeyValue => (is => 'ro', isa => 'Str', request_name => 'keyValue', traits => ['NameInRequest']);
  has LastUpdateTime => (is => 'ro', isa => 'Str', request_name => 'lastUpdateTime', traits => ['NameInRequest']);
  has Severity => (is => 'ro', isa => 'Int', request_name => 'severity', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::IoTEventsData::Alarm

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::IoTEventsData::Alarm object:

  $service_obj->Method(Att1 => { AlarmModelName => $value, ..., Severity => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::IoTEventsData::Alarm object:

  $result = $service_obj->Method(...);
  $result->Att1->AlarmModelName

=head1 DESCRIPTION

Contains information about an alarm.

=head1 ATTRIBUTES


=head2 AlarmModelName => Str

The name of the alarm model.


=head2 AlarmModelVersion => Str

The version of the alarm model.


=head2 AlarmState => L<Paws::IoTEventsData::AlarmState>

Contains information about the current state of the alarm.


=head2 CreationTime => Str

The time the alarm was created, in the Unix epoch format.


=head2 KeyValue => Str

The value of the key used as a filter to select only the alarms
associated with the key
(https://docs.aws.amazon.com/iotevents/latest/apireference/API_CreateAlarmModel.html#iotevents-CreateAlarmModel-request-key).


=head2 LastUpdateTime => Str

The time the alarm was last updated, in the Unix epoch format.


=head2 Severity => Int

A non-negative integer that reflects the severity level of the alarm.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::IoTEventsData>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

