/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.ling.CategoryWordTag;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.ling.StringLabel;
import edu.stanford.nlp.math.SloppyMath;
import edu.stanford.nlp.parser.KBestViterbiParser;
import edu.stanford.nlp.parser.lexparser.BinaryGrammar;
import edu.stanford.nlp.parser.lexparser.BinaryRule;
import edu.stanford.nlp.parser.lexparser.DependencyGrammar;
import edu.stanford.nlp.parser.lexparser.Edge;
import edu.stanford.nlp.parser.lexparser.ExhaustiveDependencyParser;
import edu.stanford.nlp.parser.lexparser.ExhaustivePCFGParser;
import edu.stanford.nlp.parser.lexparser.GrammarProjection;
import edu.stanford.nlp.parser.lexparser.Hook;
import edu.stanford.nlp.parser.lexparser.HookChart;
import edu.stanford.nlp.parser.lexparser.IntTaggedWord;
import edu.stanford.nlp.parser.lexparser.Interner;
import edu.stanford.nlp.parser.lexparser.Item;
import edu.stanford.nlp.parser.lexparser.Lexicon;
import edu.stanford.nlp.parser.lexparser.NullGrammarProjection;
import edu.stanford.nlp.parser.lexparser.Options;
import edu.stanford.nlp.parser.lexparser.Scorer;
import edu.stanford.nlp.parser.lexparser.Test;
import edu.stanford.nlp.parser.lexparser.UnaryGrammar;
import edu.stanford.nlp.parser.lexparser.UnaryRule;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeFactory;
import edu.stanford.nlp.util.ArrayHeap;
import edu.stanford.nlp.util.Heap;
import edu.stanford.nlp.util.Numberer;
import edu.stanford.nlp.util.Scored;
import edu.stanford.nlp.util.ScoredComparator;
import edu.stanford.nlp.util.ScoredObject;
import edu.stanford.nlp.util.Timing;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BiLexPCFGParser
implements KBestViterbiParser {
    protected static final boolean VERBOSE = false;
    protected static final boolean VERY_VERBOSE = false;
    protected HookChart chart;
    protected Heap<Item> agenda;
    protected int length;
    protected int[] words;
    protected Edge goal;
    protected Interner interner;
    protected Scorer scorer;
    protected ExhaustivePCFGParser fscorer;
    protected ExhaustiveDependencyParser dparser;
    protected GrammarProjection projection;
    protected BinaryGrammar bg;
    protected UnaryGrammar ug;
    protected DependencyGrammar dg;
    protected Lexicon lex;
    protected Options op;
    protected List<IntTaggedWord>[] taggedWordList;
    protected Numberer wordNumberer = Numberer.getGlobalNumberer("words");
    protected Numberer tagNumberer = Numberer.getGlobalNumberer("tags");
    protected Numberer stateNumberer = Numberer.getGlobalNumberer("states");
    protected TreeFactory tf = new LabeledScoredTreeFactory();
    protected long relaxHook1 = 0L;
    protected long relaxHook2 = 0L;
    protected long relaxHook3 = 0L;
    protected long relaxHook4 = 0L;
    protected long builtHooks = 0L;
    protected long builtEdges = 0L;
    protected long extractedHooks = 0L;
    protected long extractedEdges = 0L;
    private static final double TOL = 1.0E-10;
    protected List<Edge> nGoodTrees = new LinkedList<Edge>();
    protected Edge tempEdge = new Edge();
    protected Edge iTemp = new Edge();
    protected Edge oTemp = new Edge();
    protected Hook tempHook = new Hook();

    protected static boolean better(double x, double y) {
        return (x - y) / (Math.abs(x) + Math.abs(y) + 1.0E-100) > 1.0E-10;
    }

    @Override
    public double getBestScore() {
        if (this.goal == null) {
            return Double.NEGATIVE_INFINITY;
        }
        return this.goal.score();
    }

    protected Tree extractParse(Edge edge) {
        String head = (String)this.wordNumberer.object(this.words[edge.head]);
        String tag = (String)this.tagNumberer.object(edge.tag);
        String state = (String)this.stateNumberer.object(edge.state);
        CategoryWordTag label = new CategoryWordTag(state, head, tag);
        if (edge.backEdge == null && edge.backHook == null) {
            List<Tree> childList = Collections.singletonList(this.tf.newLeaf(new StringLabel(head)));
            return this.tf.newTreeNode(label, childList);
        }
        if (edge.backHook == null) {
            List<Tree> childList = Collections.singletonList(this.extractParse(edge.backEdge));
            return this.tf.newTreeNode(label, childList);
        }
        ArrayList<Tree> children = new ArrayList<Tree>();
        if (edge.backHook.isPreHook()) {
            children.add(this.extractParse(edge.backEdge));
            children.add(this.extractParse(edge.backHook.backEdge));
        } else {
            children.add(this.extractParse(edge.backHook.backEdge));
            children.add(this.extractParse(edge.backEdge));
        }
        return this.tf.newTreeNode(label, children);
    }

    @Override
    public Tree getBestParse() {
        return this.extractParse(this.goal);
    }

    @Override
    public boolean hasParse() {
        return this.goal != null && this.goal.iScore != Double.NEGATIVE_INFINITY;
    }

    @Override
    public List<ScoredObject<Tree>> getKGoodParses(int k) {
        ArrayList<ScoredObject<Tree>> nGoodTreesList = new ArrayList<ScoredObject<Tree>>(Test.printFactoredKGood);
        for (Edge e : this.nGoodTrees) {
            nGoodTreesList.add(new ScoredObject<Tree>(this.extractParse(e), e.iScore));
        }
        return nGoodTreesList;
    }

    @Override
    public List<ScoredObject<Tree>> getKBestParses(int k) {
        throw new UnsupportedOperationException("BiLexPCFGParser doesn't support k best parses");
    }

    @Override
    public List<ScoredObject<Tree>> getBestParses() {
        throw new UnsupportedOperationException("BiLexPCFGParser doesn't support best parses");
    }

    @Override
    public List<ScoredObject<Tree>> getKSampledParses(int k) {
        throw new UnsupportedOperationException("BiLexPCFGParser doesn't support k sampled parses");
    }

    protected void combine(Edge edge, Hook hook) {
        if (hook.isPreHook()) {
            this.tempEdge.start = edge.start;
            this.tempEdge.end = hook.end;
        } else {
            this.tempEdge.start = hook.start;
            this.tempEdge.end = edge.end;
        }
        this.tempEdge.state = hook.state;
        this.tempEdge.head = hook.head;
        this.tempEdge.tag = hook.tag;
        this.tempEdge.iScore = hook.iScore + edge.iScore;
        this.tempEdge.backEdge = edge;
        this.tempEdge.backHook = hook;
        this.relaxTempEdge();
    }

    protected void relaxTempEdge() {
        Edge resultEdge = this.interner.intern(this.tempEdge);
        if (resultEdge == this.tempEdge) {
            this.tempEdge = new Edge();
            this.discoverEdge(resultEdge);
        } else if (BiLexPCFGParser.better(this.tempEdge.iScore, resultEdge.iScore) && resultEdge.oScore > Double.NEGATIVE_INFINITY) {
            double back = resultEdge.iScore;
            Edge backE = resultEdge.backEdge;
            Hook backH = resultEdge.backHook;
            resultEdge.iScore = this.tempEdge.iScore;
            resultEdge.backEdge = this.tempEdge.backEdge;
            resultEdge.backHook = this.tempEdge.backHook;
            try {
                this.agenda.decreaseKey(resultEdge);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
        }
    }

    protected void discoverEdge(Edge edge) {
        edge.oScore = this.scorer.oScore(edge);
        this.agenda.add(edge);
        ++this.builtEdges;
    }

    protected void discoverHook(Hook hook) {
        hook.oScore = this.buildOScore(hook);
        if (hook.oScore == Double.NEGATIVE_INFINITY) {
            ++this.relaxHook4;
        }
        ++this.builtHooks;
        this.agenda.add(hook);
    }

    protected double buildOScore(Hook hook) {
        double bestOScore = Double.NEGATIVE_INFINITY;
        this.iTemp.head = hook.head;
        this.iTemp.tag = hook.tag;
        this.iTemp.state = hook.subState;
        this.oTemp.head = hook.head;
        this.oTemp.tag = hook.tag;
        this.oTemp.state = hook.state;
        if (hook.isPreHook()) {
            this.iTemp.end = hook.start;
            this.oTemp.end = hook.end;
            int start = 0;
            while (start <= hook.head) {
                this.iTemp.start = start;
                this.oTemp.start = start++;
                double oScore = this.scorer.oScore(this.oTemp) + this.scorer.iScore(this.iTemp);
                bestOScore = SloppyMath.max(bestOScore, oScore);
            }
        } else {
            this.iTemp.start = hook.end;
            this.oTemp.start = hook.start;
            int end = hook.head + 1;
            while (end <= this.length) {
                this.iTemp.end = end;
                this.oTemp.end = end++;
                double oScore = this.scorer.oScore(this.oTemp) + this.scorer.iScore(this.iTemp);
                bestOScore = SloppyMath.max(bestOScore, oScore);
            }
        }
        return bestOScore;
    }

    protected void projectHooks(Edge edge) {
        short tag;
        IntTaggedWord iTW;
        int hdi;
        int sz;
        int head;
        BinaryRule br;
        int r;
        List<BinaryRule> ruleList = this.bg.ruleListByLeftChild(edge.state);
        int rsz = ruleList.size();
        for (r = 0; r < rsz; ++r) {
            br = ruleList.get(r);
            if (!this.fscorer.oPossibleL(this.project(br.parent), edge.start) || !this.fscorer.iPossibleL(this.project(br.rightChild), edge.end)) continue;
            for (head = edge.end; head < this.length; ++head) {
                sz = this.taggedWordList[head].size();
                for (hdi = 0; hdi < sz; ++hdi) {
                    iTW = this.taggedWordList[head].get(hdi);
                    tag = iTW.tag;
                    this.tempHook.start = edge.start;
                    this.tempHook.end = edge.end;
                    this.tempHook.head = head;
                    this.tempHook.tag = tag;
                    this.tempHook.state = br.parent;
                    this.tempHook.subState = br.rightChild;
                    if (!this.chart.isBuiltL(this.tempHook.subState, this.tempHook.end, this.tempHook.head, this.tempHook.tag)) continue;
                    this.tempHook.iScore = edge.iScore + (double)br.score + (double)this.dparser.headScore[this.dparser.binDistance[head][edge.end]][head][this.dg.tagBin(tag)][edge.head][this.dg.tagBin(edge.tag)] + (double)this.dparser.headStop[edge.head][this.dg.tagBin(edge.tag)][edge.start] + (double)this.dparser.headStop[edge.head][this.dg.tagBin(edge.tag)][edge.end];
                    this.tempHook.backEdge = edge;
                    this.relaxTempHook();
                }
            }
        }
        ruleList = this.bg.ruleListByRightChild(edge.state);
        int rlSize = ruleList.size();
        for (r = 0; r < rlSize; ++r) {
            br = ruleList.get(r);
            if (!this.fscorer.oPossibleR(this.project(br.parent), edge.end) || !this.fscorer.iPossibleR(this.project(br.leftChild), edge.start)) continue;
            for (head = 0; head < edge.start; ++head) {
                sz = this.taggedWordList[head].size();
                for (hdi = 0; hdi < sz; ++hdi) {
                    iTW = this.taggedWordList[head].get(hdi);
                    tag = iTW.tag;
                    this.tempHook.start = edge.start;
                    this.tempHook.end = edge.end;
                    this.tempHook.head = head;
                    this.tempHook.tag = tag;
                    this.tempHook.state = br.parent;
                    this.tempHook.subState = br.leftChild;
                    if (!this.chart.isBuiltR(this.tempHook.subState, this.tempHook.start, this.tempHook.head, this.tempHook.tag)) continue;
                    this.tempHook.iScore = edge.iScore + (double)br.score + (double)this.dparser.headScore[this.dparser.binDistance[head][edge.start]][head][this.dg.tagBin(tag)][edge.head][this.dg.tagBin(edge.tag)] + (double)this.dparser.headStop[edge.head][this.dg.tagBin(edge.tag)][edge.start] + (double)this.dparser.headStop[edge.head][this.dg.tagBin(edge.tag)][edge.end];
                    this.tempHook.backEdge = edge;
                    this.relaxTempHook();
                }
            }
        }
    }

    protected void registerReal(Edge real) {
        this.chart.registerRealEdge(real);
    }

    protected void triggerHooks(Edge edge) {
        Collection<Edge> realEdges;
        BinaryRule[] rules;
        boolean newL = !this.chart.isBuiltL(edge.state, edge.start, edge.head, edge.tag);
        boolean newR = !this.chart.isBuiltR(edge.state, edge.end, edge.head, edge.tag);
        this.chart.registerEdgeIndexes(edge);
        if (newR) {
            for (BinaryRule br : rules = this.bg.splitRulesWithLC(edge.state)) {
                realEdges = this.chart.getRealEdgesWithL(br.rightChild, edge.end);
                for (Edge real : realEdges) {
                    this.tempHook.start = real.start;
                    this.tempHook.end = real.end;
                    this.tempHook.state = br.parent;
                    this.tempHook.subState = br.leftChild;
                    this.tempHook.head = edge.head;
                    this.tempHook.tag = edge.tag;
                    this.tempHook.backEdge = real;
                    this.tempHook.iScore = real.iScore + (double)br.score + (double)this.dparser.headScore[this.dparser.binDistance[edge.head][edge.end]][edge.head][this.dg.tagBin(edge.tag)][real.head][this.dg.tagBin(real.tag)] + (double)this.dparser.headStop[real.head][this.dg.tagBin(real.tag)][real.start] + (double)this.dparser.headStop[real.head][this.dg.tagBin(real.tag)][real.end];
                    this.relaxTempHook();
                }
            }
        }
        if (newL) {
            for (BinaryRule br : rules = this.bg.splitRulesWithRC(edge.state)) {
                realEdges = this.chart.getRealEdgesWithR(br.leftChild, edge.start);
                for (Edge real : realEdges) {
                    this.tempHook.start = real.start;
                    this.tempHook.end = real.end;
                    this.tempHook.state = br.parent;
                    this.tempHook.subState = br.rightChild;
                    this.tempHook.head = edge.head;
                    this.tempHook.tag = edge.tag;
                    this.tempHook.backEdge = real;
                    this.tempHook.iScore = real.iScore + (double)br.score + (double)this.dparser.headScore[this.dparser.binDistance[edge.head][edge.start]][edge.head][this.dg.tagBin(edge.tag)][real.head][this.dg.tagBin(real.tag)] + (double)this.dparser.headStop[real.head][this.dg.tagBin(real.tag)][real.start] + (double)this.dparser.headStop[real.head][this.dg.tagBin(real.tag)][real.end];
                    this.relaxTempHook();
                }
            }
        }
    }

    protected void triggerAllHooks(Edge edge) {
        Collection<Edge> edges;
        BinaryRule br;
        Iterator<BinaryRule> rI;
        boolean newL = !this.chart.isBuiltL(edge.state, edge.start, edge.head, edge.tag);
        boolean newR = !this.chart.isBuiltR(edge.state, edge.end, edge.head, edge.tag);
        this.chart.registerEdgeIndexes(edge);
        if (newR) {
            rI = this.bg.ruleIteratorByLeftChild(edge.state);
            while (rI.hasNext()) {
                br = rI.next();
                edges = this.chart.getRealEdgesWithL(br.rightChild, edge.end);
                for (Edge real : edges) {
                    this.tempHook.start = real.start;
                    this.tempHook.end = real.end;
                    this.tempHook.state = br.parent;
                    this.tempHook.subState = br.leftChild;
                    this.tempHook.head = edge.head;
                    this.tempHook.tag = edge.tag;
                    this.tempHook.backEdge = real;
                    this.tempHook.iScore = real.iScore + (double)br.score + (double)this.dparser.headScore[this.dparser.binDistance[edge.head][edge.end]][edge.head][this.dg.tagBin(edge.tag)][real.head][this.dg.tagBin(real.tag)] + (double)this.dparser.headStop[real.head][this.dg.tagBin(real.tag)][real.start] + (double)this.dparser.headStop[real.head][this.dg.tagBin(real.tag)][real.end];
                    this.relaxTempHook();
                }
            }
        }
        if (newL) {
            rI = this.bg.ruleIteratorByRightChild(edge.state);
            while (rI.hasNext()) {
                br = rI.next();
                edges = this.chart.getRealEdgesWithR(br.leftChild, edge.start);
                for (Edge real : edges) {
                    this.tempHook.start = real.start;
                    this.tempHook.end = real.end;
                    this.tempHook.state = br.parent;
                    this.tempHook.subState = br.rightChild;
                    this.tempHook.head = edge.head;
                    this.tempHook.tag = edge.tag;
                    this.tempHook.backEdge = real;
                    this.tempHook.iScore = real.iScore + (double)br.score + (double)this.dparser.headScore[this.dparser.binDistance[edge.head][edge.start]][edge.head][this.dg.tagBin(edge.tag)][real.head][this.dg.tagBin(real.tag)] + (double)this.dparser.headStop[real.head][this.dg.tagBin(real.tag)][real.start] + (double)this.dparser.headStop[real.head][this.dg.tagBin(real.tag)][real.end];
                    this.relaxTempHook();
                }
            }
        }
    }

    protected void relaxTempHook() {
        ++this.relaxHook1;
        if (!this.scorer.oPossible(this.tempHook) || !this.scorer.iPossible(this.tempHook)) {
            return;
        }
        ++this.relaxHook2;
        Hook resultHook = this.interner.intern(this.tempHook);
        if (resultHook == this.tempHook) {
            ++this.relaxHook3;
            this.tempHook = new Hook();
            this.discoverHook(resultHook);
        }
        if (BiLexPCFGParser.better(this.tempHook.iScore, resultHook.iScore)) {
            resultHook.iScore = this.tempHook.iScore;
            resultHook.backEdge = this.tempHook.backEdge;
            try {
                this.agenda.decreaseKey(resultHook);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    protected void projectUnaries(Edge edge) {
        Iterator<UnaryRule> rI = this.ug.ruleIteratorByChild(edge.state);
        while (rI.hasNext()) {
            UnaryRule ur = rI.next();
            if (ur.child == ur.parent) continue;
            this.tempEdge.start = edge.start;
            this.tempEdge.end = edge.end;
            this.tempEdge.head = edge.head;
            this.tempEdge.tag = edge.tag;
            this.tempEdge.state = ur.parent;
            this.tempEdge.backEdge = edge;
            this.tempEdge.backHook = null;
            this.tempEdge.iScore = edge.iScore + (double)ur.score;
            this.relaxTempEdge();
        }
    }

    protected void processEdge(Edge edge) {
        this.chart.addEdge(edge);
        for (Hook hook : this.chart.getPreHooks(edge)) {
            this.combine(edge, hook);
        }
        for (Hook hook : this.chart.getPostHooks(edge)) {
            this.combine(edge, hook);
        }
        this.projectUnaries(edge);
        if (!this.bg.isSynthetic(edge.state) && !this.op.freeDependencies) {
            this.projectHooks(edge);
            this.registerReal(edge);
        }
        if (this.op.freeDependencies) {
            this.projectHooks(edge);
            this.registerReal(edge);
            this.triggerAllHooks(edge);
        } else {
            this.triggerHooks(edge);
        }
    }

    protected void processHook(Hook hook) {
        this.chart.addHook(hook);
        Collection<Edge> edges = this.chart.getEdges(hook);
        for (Edge edge : edges) {
            this.combine(edge, hook);
        }
    }

    protected void processItem(Item item) {
        if (item.isEdge()) {
            this.processEdge((Edge)item);
        } else {
            this.processHook((Hook)item);
        }
    }

    protected void discoverItem(Item item) {
        if (item.isEdge()) {
            this.discoverEdge((Edge)item);
        } else {
            this.discoverHook((Hook)item);
        }
    }

    protected static Item makeInitialItem(int pos, int tag, int state, double iScore) {
        Edge edge = new Edge();
        edge.start = pos;
        edge.end = pos + 1;
        edge.state = state;
        edge.head = pos;
        edge.tag = tag;
        edge.iScore = iScore;
        return edge;
    }

    protected List<Item> makeInitialItems(List wordList) {
        ArrayList<Item> itemList = new ArrayList<Item>();
        int length = wordList.size();
        int numTags = this.tagNumberer.total();
        this.words = new int[length];
        this.taggedWordList = new List[length];
        int terminalCount = 0;
        for (int i = 0; i < length; ++i) {
            int word;
            this.taggedWordList[i] = new ArrayList<IntTaggedWord>(numTags);
            String wordStr = "";
            Object wordObject = wordList.get(i);
            wordStr = wordObject instanceof HasWord ? ((HasWord)wordObject).word() : wordObject.toString();
            if (!this.wordNumberer.hasSeen(wordStr)) {
                wordStr = "UNK";
            }
            this.words[i] = word = this.wordNumberer.number(wordStr);
            Iterator<IntTaggedWord> tagI = this.lex.ruleIteratorByWord(word, i);
            while (tagI.hasNext()) {
                int state;
                IntTaggedWord tagging = tagI.next();
                short tag = tagging.tag;
                this.tempEdge.state = state = Numberer.translate("tags", "states", tag);
                this.tempEdge.head = i;
                this.tempEdge.start = i;
                this.tempEdge.end = i + 1;
                this.tempEdge.tag = tag;
                itemList.add(BiLexPCFGParser.makeInitialItem(i, tag, state, this.scorer.iScore(this.tempEdge)));
                ++terminalCount;
                this.taggedWordList[i].add(new IntTaggedWord(word, tag));
            }
        }
        if (Test.verbose) {
            System.err.println("Terminals (# of tag edges in chart): " + terminalCount);
        }
        return itemList;
    }

    protected void scoreDependencies() {
    }

    protected void setGoal(int length) {
        this.goal = new Edge();
        this.goal.start = 0;
        this.goal.end = length;
        this.goal.state = this.stateNumberer.number(this.op.langpack().startSymbol());
        this.goal.tag = this.tagNumberer.number(".$$.");
        this.goal.head = length - 1;
    }

    protected void initialize(List words) {
        this.length = words.size();
        this.interner = new Interner();
        this.agenda = new ArrayHeap<Scored>(ScoredComparator.DESCENDING_COMPARATOR);
        this.chart = new HookChart();
        this.setGoal(this.length);
        List<Item> initialItems = this.makeInitialItems(words);
        this.scoreDependencies();
        int iiSize = initialItems.size();
        for (int i = 0; i < iiSize; ++i) {
            Item item = initialItems.get(i);
            item = this.interner.intern(item);
            this.discoverItem(item);
        }
    }

    @Override
    public boolean parse(List<? extends HasWord> sentence, String goal) {
        return this.parse(sentence);
    }

    @Override
    public boolean parse(List<? extends HasWord> words) {
        int nGoodRemaining = 0;
        if (Test.printFactoredKGood > 0) {
            nGoodRemaining = Test.printFactoredKGood;
            this.nGoodTrees.clear();
        }
        int spanFound = 0;
        long last = 0L;
        int exHook = 0;
        this.relaxHook1 = 0L;
        this.relaxHook2 = 0L;
        this.relaxHook3 = 0L;
        this.relaxHook4 = 0L;
        this.builtHooks = 0L;
        this.builtEdges = 0L;
        this.extractedHooks = 0L;
        this.extractedEdges = 0L;
        if (Test.verbose) {
            Timing.tick("Starting combined parse.");
        }
        this.dparser.binDistance = this.dparser.binDistance;
        this.initialize(words);
        while (!this.agenda.isEmpty()) {
            Item item = this.agenda.extractMin();
            if (!item.isEdge()) {
                ++exHook;
                ++this.extractedHooks;
            } else {
                ++this.extractedEdges;
            }
            if (this.relaxHook1 > last + 1000000L) {
                last = this.relaxHook1;
                if (Test.verbose) {
                    System.err.println("Proposed hooks:   " + this.relaxHook1);
                    System.err.println("Unfiltered hooks: " + this.relaxHook2);
                    System.err.println("Built hooks:      " + this.relaxHook3);
                    System.err.println("Waste hooks:      " + this.relaxHook4);
                    System.err.println("Extracted hooks:  " + exHook);
                }
            }
            if (item.end - item.start > spanFound) {
                spanFound = item.end - item.start;
                if (Test.verbose) {
                    System.err.print(spanFound + " ");
                }
            }
            if (item.equals(this.goal)) {
                if (Test.verbose) {
                    System.err.println("Found goal!");
                    System.err.println("Comb iScore " + item.iScore);
                    Timing.tick("Done, parse found.");
                    System.err.println("Built items:      " + (this.builtEdges + this.builtHooks));
                    System.err.println("Built hooks:      " + this.builtHooks);
                    System.err.println("Built edges:      " + this.builtEdges);
                    System.err.println("Extracted items:  " + (this.extractedEdges + this.extractedHooks));
                    System.err.println("Extracted hooks:  " + this.extractedHooks);
                    System.err.println("Extracted edges:  " + this.extractedEdges);
                }
                if (Test.printFactoredKGood <= 0) {
                    this.goal = (Edge)item;
                    this.interner = null;
                    this.agenda = null;
                    return true;
                }
                this.goal = (Edge)item;
                this.nGoodTrees.add(this.goal);
                if (--nGoodRemaining <= 0) {
                    this.interner = null;
                    this.agenda = null;
                    return true;
                }
            }
            if (item.score() == Double.NEGATIVE_INFINITY) {
                if (this.nGoodTrees.size() > 0) {
                    this.goal = this.nGoodTrees.get(0);
                    this.interner = null;
                    this.agenda = null;
                    return true;
                }
                System.err.println("FactoredParser: no consistent parse [hit A*-blocked edges, aborting].");
                if (Test.verbose) {
                    Timing.tick("FactoredParser: no consistent parse [hit A*-blocked edges, aborting].");
                }
                return false;
            }
            if (Test.MAX_ITEMS > 0 && this.builtEdges + this.builtHooks >= (long)Test.MAX_ITEMS) {
                if (this.nGoodTrees.size() > 0) {
                    System.err.println("DEBUG: aborting search because of reaching the MAX_ITEMS work limit [" + Test.MAX_ITEMS + " items]");
                    this.goal = this.nGoodTrees.get(0);
                    this.interner = null;
                    this.agenda = null;
                    return true;
                }
                System.err.println("FactoredParser: exceeded MAX_ITEMS work limit [" + Test.MAX_ITEMS + " items]; aborting.");
                if (Test.verbose) {
                    Timing.tick("FactoredParser: exceeded MAX_ITEMS work limit [" + Test.MAX_ITEMS + " items]; aborting.");
                }
                return false;
            }
            this.processItem(item);
        }
        if (this.nGoodTrees.size() > 0) {
            System.err.println("DEBUG: aborting search because of empty agenda");
            this.goal = this.nGoodTrees.get(0);
            this.interner = null;
            this.agenda = null;
            return true;
        }
        System.err.println("FactoredParser: emptied agenda, no parse found!");
        if (Test.verbose) {
            Timing.tick("FactoredParser: emptied agenda, no parse found!");
        }
        return false;
    }

    protected void postMortem() {
        int numHooks = 0;
        int numEdges = 0;
        int numUnmatchedHooks = 0;
        int total = this.agenda.size();
        int done = 0;
        while (!this.agenda.isEmpty()) {
            Item item = this.agenda.extractMin();
            ++done;
            if (item.isEdge()) {
                ++numEdges;
                continue;
            }
            ++numHooks;
            Collection<Edge> edges = this.chart.getEdges((Hook)item);
            if (edges.size() != 0) continue;
            ++numUnmatchedHooks;
        }
        System.err.println("--- Agenda Post-Mortem ---");
        System.err.println("Edges:           " + numEdges);
        System.err.println("Hooks:           " + numHooks);
        System.err.println("Unmatched Hooks: " + numUnmatchedHooks);
    }

    protected int project(int state) {
        return this.projection.project(state);
    }

    BiLexPCFGParser(Scorer scorer, ExhaustivePCFGParser fscorer, ExhaustiveDependencyParser dparser, BinaryGrammar bg, UnaryGrammar ug, DependencyGrammar dg, Lexicon lex, Options op) {
        this(scorer, fscorer, dparser, bg, ug, dg, lex, op, new NullGrammarProjection(bg, ug));
    }

    BiLexPCFGParser(Scorer scorer, ExhaustivePCFGParser fscorer, ExhaustiveDependencyParser dparser, BinaryGrammar bg, UnaryGrammar ug, DependencyGrammar dg, Lexicon lex, Options op, GrammarProjection projection) {
        this.fscorer = fscorer;
        this.projection = projection;
        this.dparser = dparser;
        this.scorer = scorer;
        this.bg = bg;
        this.ug = ug;
        this.dg = dg;
        this.lex = lex;
        this.op = op;
    }

    public static class N5BiLexPCFGParser
    extends BiLexPCFGParser {
        protected void relaxTempHook() {
            ++this.relaxHook1;
            if (!this.scorer.oPossible(this.tempHook) || !this.scorer.iPossible(this.tempHook)) {
                return;
            }
            ++this.relaxHook2;
            Hook resultHook = this.tempHook;
            if (resultHook == this.tempHook) {
                ++this.relaxHook3;
                this.tempHook = new Hook();
                this.processHook(resultHook);
                ++this.builtHooks;
            }
        }

        N5BiLexPCFGParser(Scorer scorer, ExhaustivePCFGParser fscorer, ExhaustiveDependencyParser leach, BinaryGrammar bg, UnaryGrammar ug, DependencyGrammar dg, Lexicon lex, Options op) {
            super(scorer, fscorer, leach, bg, ug, dg, lex, op, new NullGrammarProjection(bg, ug));
        }

        N5BiLexPCFGParser(Scorer scorer, ExhaustivePCFGParser fscorer, ExhaustiveDependencyParser leach, BinaryGrammar bg, UnaryGrammar ug, DependencyGrammar dg, Lexicon lex, Options op, GrammarProjection proj) {
            super(scorer, fscorer, leach, bg, ug, dg, lex, op, proj);
        }
    }
}

