#
# PHP::Decode::Test - test cases for usage from php_decode
#
package PHP::Decode::Test;

use strict;
use warnings;

our $VERSION = '0.301';

our @tests = (
	'str',        q(foo),                             q('foo' ;),
	'str2',       q(?>foo),                           q(echo 'foo' ; $STDOUT = 'foo' ;),
	'str3',       q(?>a'\"\''b<?),                    q(echo 'a\'\\\\"\\\\\'\'b' ; $STDOUT = 'a\'\\\\"\\\\\'\'b' ;), # '\\' is really '\' in q()
	'str4',       q(?>a"\"\'"b<?),                    q(echo 'a"\\\\"\\\\\'"b' ; $STDOUT = 'a"\\\\"\\\\\'"b' ;),
	'str5',       q('a"\\"\\'"b'),                    q('a"\\\\"\\'"b' ;),
	'str6',       q(a(); "$test"),                    q(a ( ) ; '' . $test ;),
	'n:str7',     q("$test[0]"),                      q('' ;),
	'N:str7',     q("$test[0]"),                      q('' . $test [ 0 ] ;),
	'str8',       q(a(); "{$test}"),                  q(a ( ) ; $test ;),
	'str9',       q(a(); "x{$test}y"),                q(a ( ) ; 'x' . $test . 'y' ;),
	'str10',      q('a'),                             q('a' ;),
	'str11',      q('\\\\'),                          q('\\\\' ;),  # '\\\\' is really '\\' in php
	'str12',      q("\\\\\\\\"),                      q('\\\\\\\\' ;),  # '\\\\\\\\' is really '\\\\' in php
	'str13',      q(":\\\\"),                         q(':\\\\' ;), # '\\\\' is really '\\' in php
	'str14',      q(ord('\\\\')),                     q(92 ;),
	'str15',      q(chr(92)),                         q('\\\\' ;),
	'str16',      q($x = <<<FOO)."\ntesttest\nFOO",   q($x = 'testtest)."\n' ;",
	'n:str17',    q($x = <<<FOO)."\n\$test[x]\nFOO",  q($x = ')."\n' ;",
	'N:str17',    q($x = <<<FOO)."\n\$test[x]\nFOO",  q($x = '' . $test [ 'x' ] . ')."\n' ;",
	'n:str18',    q($x = "h={$a[0]} p={$a[1]} b"),    q($x = 'h= p= b' ;),
	'N:str18',    q($x = "h={$a[0]} p={$a[1]} b"),    q($x = 'h=' . $a [ 0 ] . ' p=' . $a [ 1 ] . ' b' ;),
	'str19',      q("\x65$156\x32"),                  q('e$1562' ;),
	'str20',      q($x='\15'; $y=$x.'6'),             q($x = '\\\\15' ; $y = '\\\\156' ;), 
	'str21',      q(chr(-159)),                       q('a' ;),
	'str22',      q(chr(833)),                        q('A' ;),
	'str23',      q("$_GET[0]"),                      q('' . $_GET [ 0 ] ;),
	'n:str24',    q("$GLOBALS[a]"),                   q('' ;),
	'N:str24',    q("$GLOBALS[a]"),                   q('' . $a ;),
	'n:str25',    q("$test"),                         q('' ;),
	'N:str25',    q("$test"),                         q('' . $test ;),
	'n:str26',    q("x{$test}y"),                     q('xy' ;),
	'N:str26',    q("x{$test}y"),                     q('x' . $test . 'y' ;),
	'echo',       q(echo foo),                        q(echo foo ; $STDOUT = 'foo' ;),
	'echo2',      q(echo 'foo'),                      q(echo 'foo' ; $STDOUT = 'foo' ;),
	'echo3',      q(echo 'foo';),                     q(echo 'foo' ; $STDOUT = 'foo' ;),
	'echo4',      q(echo 'foo', 'bar'),               q(echo 'foobar' ; $STDOUT = 'foobar' ;),
	'echo6',      q(?><? chr(65) ?>),                 q('A' ;),
	'echo7',      q(?><? chr(65) ?> ),                q('A' ; echo ' ' ; $STDOUT = ' ' ;),
	'echo8',      q(?><? chr(65); ?> ),               q('A' ; echo ' ' ; $STDOUT = ' ' ;),
	'n:echo9',    q(echo "".$a;),                     q(echo '' ; $STDOUT = '' ;),
	'N:echo9',    q(echo "".$a;),                     q(echo '' . $a ; $STDOUT = '' . $a ;),
	'n:echo10',   q(echo "$a";),                      q(echo '' ; $STDOUT = '' ;),
	'N:echo10',   q(echo "$a";),                      q(echo '' . $a ; $STDOUT = '' . $a ;),
	'echo11',     q(echo 'a'.'b'.$_GET[0].'d'.'e';),  q(echo 'ab' . $_GET [ 0 ] . 'de' ; $STDOUT = 'ab' . $_GET [ 0 ] . 'de' ;),
	'stmt',       q(echo '2'; echo '1';),             q(echo '2' ; echo '1' ; $STDOUT = '21' ;),
	'stmt2',      q('2'; echo '1';),                  q('2' ; echo '1' ; $STDOUT = '1' ;),
	'base64',     q(base64_decode('Zm9vYg==');),      q('foob' ;),
	'base64-2',   q((base64_decode('Zm9vYg=='));),    q('foob' ;),
	'base64-3',   q((base64_encode('foob'));),        q('Zm9vYg==' ;),
	'base64-4',   q((Base64_enCode('foob'));),        q('Zm9vYg==' ;),
	'base64-5',   q(base64_decode(": Zm9vYg= = ");),  q('foob' ;),
	'compress1',  q(gzinflate(base64_decode("S8vPBwA="));), q('foo' ;),
	'compress2',  q(gzdecode(base64_decode("H4sIAAAAAAACA0vLzwcAIWVzjAMAAAA="));), q('foo' ;),
	'compress3',  q(gzuncompress(base64_decode("eNpLy88HAAKCAUU="));), q('foo' ;),
	#'compress4',  q(base64_encode(gzdeflate("foo", 9));),  q('S8vPBwA=' ;),
	#'compress5',  q(base64_encode(gzencode("foo", 9));),   q('H4sIAAAAAAACA0vLzwcAIWVzjAMAAAA=' ;),
	#'compress6',  q(base64_encode(gzcompress("foo", 9));), q('eNpLy88HAAKCAUU=' ;),
	'strlen1',    q(strlen("foo");),                  q(3 ;),
	'strlen2',    q(strlen(null);),                   q(0 ;),
	'strpos1',    q(strpos("abab", "b");),            q(1 ;),
	'strpos2',    q(strpos("abab", "b", 2);),         q(3 ;),
	'substr1',    q(substr("abab", 1);),              q('bab' ;),
	'substr2',    q(substr("abab", 1, 2);),           q('ba' ;),
	'substr3',    q(substr_count("ababab", "ab", 1);),q(2 ;),
	'strtr1',     q(strtr("ab", "ab", "cd");),        q('cd' ;),
	'strtr2',     q(strtr("ab", "ab", "c");),         q('cb' ;),
	'strtr3',     q(strtr("ab", "ab", "cdd");),       q('cd' ;),
	'url1',       q(urlencode("a b&+c");),            q('a+b%26%2Bc' ;),
	'url2',       q(rawurlencode("a b&+c");),         q('a%20b%26%2Bc' ;),
	'eval',       q(eval('foo')),                     q('foo' ;),
	'eval2',      q(eval('echo foo;');),              q(echo foo ; $STDOUT = 'foo' ;),
	'eval3',      q(eval(eval('echo foo;'))),         q(echo foo ; $STDOUT = 'foo' ;),
	'eval4',      q(eval(eval('foo'))),               q('foo' ;),
	'eval5',      q(eval($x=file_get_contents('y'))), q(eval ( $x = file_get_contents ( 'y' ) ) ;),
	'eval6',      q(eval('echo "foo"; echo "bar"');), q(echo 'foo' ; echo 'bar' ; $STDOUT = 'foobar' ;),
	'eval7',      q(eval('eval(base64_decode("JHggPSAnYSc="));'); echo $x;), q($x = 'a' ; echo 'a' ; $STDOUT = 'a' ;),
	'eval-ord',   q(eval(ord('a'))),                  q(97 ;),
	'eval-ord2',  q(eval('echo '.ord('a').';')),      q(echo 97 ; $STDOUT = '97' ;),
	'eval-ord3',  q(eval((ord('a')))),                q(97 ;),
	'eval-ret1',  q(eval('return "foo";')),           q('foo' ;),
	'eval-ret2',  q(eval('echo "b"; return "a";')),   q(echo 'b' ; 'a' ; $STDOUT = 'b' ;),
	'eval-ret3',  q(eval('return "a"; echo "b";')),   q('a' ;),
	'eval-ret4',  q(eval(eval(error_reporting(0)))),  q(error_reporting ( 0 ) ;),
	'$var',       q($x = "foo"; $x),                  q($x = 'foo' ; 'foo' ;),
	'$var2',      q($x = "foo"; eval($x)),            q($x = 'foo' ; 'foo' ;),
	'${var}',     q($x = "foo"; eval(${x})),          q($x = 'foo' ; 'foo' ;),
	'$var3',      q($x = "0555"; $x),                 q($x = '0555' ; '0555' ;),
	'$var4',      q($x = array("x" => "0777")),       q($x = array ( 'x' => '0777' ) ;),
	'$var5',      q($x = array("0777" => "0777")),    q($x = array ( '0777' => '0777' ) ;),
	'$var6',      q($x = $y = 'foo';),                q($y = 'foo' ; $x = 'foo' ;),
	'$var7',      q($x[0] = $x[1] = 'foo'; $x),       q($x [ 1 ] = 'foo' ; $x [ 0 ] = 'foo' ; array ( 1 => 'foo' , 0 => 'foo' ) ;),
	'elem',       q($x['a'] = "foo"; $x['a']),        q($x [ 'a' ] = 'foo' ; 'foo' ;),
	'elem2',      q($x['a'] = 'foo'; $x['a'][0]),     q($x [ 'a' ] = 'foo' ; 'f' ;),
	'elem3',      q($x['a'] = 'foo'; $x['a'][0]='k'), q($x [ 'a' ] = 'foo' ; $x [ 'a' ] = 'koo' ;),
	'elem4',      q('foo'[0]),                        q('f' ;),
	'elem5',      q($y["b"] = "foo"; $x["a"] = $y; echo $x["a"]["b"];), q($y [ 'b' ] = 'foo' ; $x [ 'a' ] = array ( 'b' => 'foo' ) ; echo 'foo' ; $STDOUT = 'foo' ;),
	'elem6',      q($x=array("a"=>array()); $x["a"]["b"] = "foo"; $x["a"]["b"];), q($x = array ( 'a' => array ( ) ) ; $x [ 'a' ] [ 'b' ] = 'foo' ; 'foo' ;),
	'elem7',      q($x["a"]["b"] = "foo"; $x["a"]["b"];), q($x [ 'a' ] [ 'b' ] = 'foo' ; 'foo' ;),
	'elem8',      q($x["a"]["b"] = "foo"; $x["a"]["c"] = "bar";), q($x [ 'a' ] [ 'b' ] = 'foo' ; $x [ 'a' ] [ 'c' ] = 'bar' ;),
	'elem9',      q($x["a"]["b"]["c"] = "foo"; $x["a"]["b"]["c"];), q($x [ 'a' ] [ 'b' ] [ 'c' ] = 'foo' ; 'foo' ;),
	'n:elem10',   q($x[$a]['b']['c'] = 'foo'; $x[$a]['b']['c'];), q($x [ '' ] [ 'b' ] [ 'c' ] = 'foo' ; 'foo' ;),
	'N:elem10',   q($x[$a]['b']['c'] = 'foo'; $x[$a]['b']['c'];), q($x [ $a ] [ 'b' ] [ 'c' ] = 'foo' ; $x [ $a ] [ 'b' ] [ 'c' ] ;),
	'n:elem11',   q($x[$a] = 'foo'; $x;),             q($x [ null ] = 'foo' ; array ( '' => 'foo' ) ;),
	'N:elem11',   q($x[$a] = 'foo'; $x;),             q($x [ $a ] = 'foo' ; array ( ) ;),
	'n:elem12',   q($x[$a] = 'foo'; $x[null];),       q($x [ null ] = 'foo' ; 'foo' ;),
	'N:elem12',   q($x[$a] = 'foo'; $x[null];),       q($x [ $a ] = 'foo' ; $x [ '' ] ;),
	'n:elem13',   q($x[$a] = 'foo'; $x[""];),         q($x [ null ] = 'foo' ; 'foo' ;),
	'N:elem13',   q($x[$a] = 'foo'; $x[""];),         q($x [ $a ] = 'foo' ; $x [ '' ] ;),
	'n:elem14',   q($x[$a] = 'foo'; $x[0];),          q($x [ null ] = 'foo' ; $x [ 0 ] ;),
	'N:elem14',   q($x[$a] = 'foo'; $x[0];),          q($x [ $a ] = 'foo' ; $x [ 0 ] ;),
	'n:elem15',   q($x[$a] = 'foo'; $x[$a];),         q($x [ null ] = 'foo' ; 'foo' ;),
	'N:elem15',   q($x[$a] = 'foo'; $x[$a];),         q($x [ $a ] = 'foo' ; $x [ $a ] ;),
	'GLOBALS',    q($x = "foo"; eval($GLOBALS['x'])), q($x = 'foo' ; 'foo' ;),
	'GLOBALS2',   q(${'GLOBALS'}['x'] = 'foo'; $x),   q($x = 'foo' ; 'foo' ;),
	'GLOBALS3',   q($g='GLOBALS';${$g}['x']='foo';$x),q($g = 'GLOBALS' ; $x = 'foo' ; 'foo' ;),
	'n:GLOBALS4', q($x = "foo"; $y=${$GLOBALS['x']}), q($x = 'foo' ; $y = null ;),
	'N:GLOBALS4', q($x = "foo"; $y=${$GLOBALS['x']}), q($x = 'foo' ; $y = $foo ;),
	'GLOBALS5',   q($GLOBALS ['foo']['bar'] = 1),     q($foo [ 'bar' ] = 1 ;),
	'GLOBALS6',   q($GLOBALS ['foo']['bar']['x'] = 1),q($foo [ 'bar' ] [ 'x' ] = 1 ;),
	'GLOBALS7',   q($x = "foo"; $y=$GLOBALS[x]['1']), q($x = 'foo' ; $y = 'o' ;),
	'GLOBALS8',   q($x = "foo"; $y=$GLOBALS[x]['0'] . $GLOBALS[x]['1']), q($x = 'foo' ; $y = 'fo' ;),
	'GLOBALS9',   q($x = "foo"; $y=array($GLOBALS[x]['0'] => f())), q($x = 'foo' ; $y = array ( 'f' => f ( ) ) ;),
	'GLOBALS10',  q($x = "foo"; if ($_POST["b"]) $y=array($GLOBALS[x]['0'] => f())), q($x = 'foo' ; if ( $_POST [ 'b' ] ) { $y = array ( 'f' => f ( ) ) ; }),
	'GLOBALS11',  q($x = "foo"; echo $GLOBALS[x]['0'],f()), q($x = 'foo' ; echo 'f' , f ( ) ; $STDOUT = 'f' . f ( ) ;),
	'GLOBALS12',  q($x='a';$y='x';$z=$GLOBALS[$GLOBALS[y]]), q($x = 'a' ; $y = 'x' ; $z = 'a' ;),
	'GLOBALS13',  q(if(a()){$b='c';d(1,e(${$b}))}),   q(if ( a ( ) ) { $b = 'c' ; d ( 1 , e ( $c ) ) ; }),
	'GLOBALS14',  q($x=&$GLOBALS; $x['a']='b'; $a),   q($x = & $GLOBALS ; $a = 'b' ; 'b' ;),
	'GLOBALS15',  q($x=$GLOBALS; $x['a']='b'; $a),    q($x = $GLOBALS ; $a = 'b' ; 'b' ;),
	'n:GLOBALS16',q($x='a'; ${${"GLOBALS"}[x]}[d]),   q($x = 'a' ;),
	'N:GLOBALS16',q($x='a'; ${${"GLOBALS"}[x]}[d]),   q($x = 'a' ; $a [ 'd' ] ;),
	'n:GLOBALS17',q($x='a'; b(${${"GLOBALS"}[x]}[d])),q($x = 'a' ; b ( null ) ;),
	'N:GLOBALS17',q($x='a'; b(${${"GLOBALS"}[x]}[d])),q($x = 'a' ; b ( $a [ 'd' ] ) ;),
	'n:GLOBALS18',q(${"GLOBALS"}[x]='a'; b(${${"GLOBALS"}[x]}['d'])),q($x = 'a' ; b ( null ) ;),
	'N:GLOBALS18',q(${"GLOBALS"}[x]='a'; b(${${"GLOBALS"}[x]}['d'])),q($x = 'a' ; b ( $a [ 'd' ] ) ;),
	'GLOBALS19',  q(if(c()){$x='a'; b(${${"GLOBALS"}[x]}['d'])}), q(if ( c ( ) ) { $x = 'a' ; b ( $a [ 'd' ] ) ; }),
	'GLOBALS20',  q(if(c()){${"GLOBALS"}[x]='a'; b(${${"GLOBALS"}[x]}['d'])}), q(if ( c ( ) ) { $x = 'a' ; b ( $a [ 'd' ] ) ; }),
	'GLOBALS21',  q(if(d()){f()}elseif(c()){${"GLOBALS"}[x]='a'; b(${${"GLOBALS"}[x]}['d'])}), q(if ( d ( ) ) { f ( ) ; } else if ( c ( ) ) { $x = 'a' ; b ( $a [ 'd' ] ) ; }),
	'GLOBALS22',  q($x='a'; ${${'GLOBALS'}['x']} = 'foo'; $a), q($x = 'a' ; $a = 'foo' ; 'foo' ;),
	'GLOBALS23',  q($b='foo'; $x='a'; $y='b'; ${${'GLOBALS'}['x']} = ${${'GLOBALS'}['y']}; $a), q($b = 'foo' ; $x = 'a' ; $y = 'b' ; $a = 'foo' ; 'foo' ;),
	'GLOBALS24',  q($foo["bar"]["x"] = 1; echo $GLOBALS["foo"]["bar"]["x"];), q($foo [ 'bar' ] [ 'x' ] = 1 ; echo 1 ; $STDOUT = '1' ;),
	'n:GLOBALS25',q($a='x'; $b='y'; ${$a} = f(${$GLOBALS['b']});), q($a = 'x' ; $b = 'y' ; $x = f ( null ) ;),
	'N:GLOBALS25',q($a='x'; $b='y'; ${$a} = f(${$GLOBALS['b']});), q($a = 'x' ; $b = 'y' ; $x = f ( $y ) ;),
	'GLOBALS26',  q($a='x'; $b='y'; function d() { ${$a} = f(${$GLOBALS['b']});}), q(function d ( ) { $ { $a } = f ( $ { $GLOBALS [ 'b' ] } ) ; } $a = 'x' ; $b = 'y' ;),
	'GLOBALS27',  q($a='x'; $b='y'; function d() { $GLOBALS['c']='z'; ${$a} = f(${$GLOBALS['c']});}), q(function d ( ) { $GLOBALS [ 'c' ] = 'z' ; $ { $a } = f ( $z ) ; } $a = 'x' ; $b = 'y' ;),
	'GLOBALS28',  q($a='x'; $b='y'; function d() { $c='z'; ${$c} = f(${$GLOBALS['b']});}), q(function d ( ) { $c = 'z' ; $z = f ( $ { $GLOBALS [ 'b' ] } ) ; } $a = 'x' ; $b = 'y' ;),
	'n:GLOBALS29',q($a='x'; $b='y'; $d = ${$b}[1][$GLOBALS[a]];), q($a = 'x' ; $b = 'y' ; $d = null ;),
	'N:GLOBALS29',q($a='x'; $b='y'; $d = ${$b}[1][$GLOBALS[a]];), q($a = 'x' ; $b = 'y' ; $d = $y [ 1 ] [ 'x' ] ;),
	'GLOBALS30',  q($a='x'; function f() { $b='y'; $d = ${$b}[1][$GLOBALS[a]];}), q(function f ( ) { $b = 'y' ; $d = $y [ 1 ] [ $GLOBALS [ 'a' ] ] ; } $a = 'x' ;),
	'GLOBALS31',  q($a='x'; function f() { for ($i=0;$i<10;$i++) {$b='y'; $d = ${$b}[1][$GLOBALS[a]];}}), q(function f ( ) { for ( $i = 0 ; $i < 10 ; $i ++ ) { $b = 'y' ; $d = $y [ 1 ] [ $GLOBALS [ 'a' ] ] ; } } $a = 'x' ;),
	'i:GLOBALS32',  q($x = "foo"; if (a()) {$y=$x;}),   q($x = 'foo' ; if ( a ( ) ) { $y = 'foo' ; }),
	'I:GLOBALS32',  q($x = "foo"; if (a()) {$y=$x;}),   q($x = 'foo' ; if ( a ( ) ) { $y = $x ; }),
	'GLOBALS33',  q($foo=array(bar=>array()); $GLOBALS ['foo']['bar']['x'] = 1;), q($foo = array ( 'bar' => array ( ) ) ; $foo [ 'bar' ] [ 'x' ] = 1 ;),
	'GLOBALS34',  q($GLOBALS['a']='1';$x=$GLOBALS['a'][0];), q($a = '1' ; $x = '1' ;),
	'GLOBALS35',  q($y=$GLOBALS; $y['a']='1';$x=$y['a'][0];), q($y = $GLOBALS ; $a = '1' ; $x = '1' ;),
	'i:GLOBALS36',  q($x=1; b(); if ($GLOBALS['x']) { echo 'a'};), q($x = 1 ; b ( ) ; echo 'a' ; $STDOUT = 'a' ;),
	'I:GLOBALS36',  q($x=1; b(); if ($GLOBALS['x']) { echo 'a'};), q($x = 1 ; b ( ) ; if ( $x ) { echo 'a' ; }),
	'GLOBALS37',  q(if (c()) { echo 'a'; } else if ($GLOBALS['x']) { echo 'b'};), q(if ( c ( ) ) { echo 'a' ; } else if ( $x ) { echo 'b' ; }),
	'i:GLOBALS38',  q(function f() {$GLOBALS['x']=1; c(); if ($GLOBALS['x']) { echo 'a';}}), q(function f ( ) { $GLOBALS [ 'x' ] = 1 ; c ( ) ; echo 'a' ; }),
	'I:GLOBALS38',  q(function f() {$GLOBALS['x']=1; c(); if ($GLOBALS['x']) { echo 'a';}}), q(function f ( ) { $GLOBALS [ 'x' ] = 1 ; c ( ) ; if ( $GLOBALS [ 'x' ] ) { echo 'a' ; } }),
	'GLOBALS39',  q($x=1; if (c()) { $x=0; } if ($GLOBALS['x']) { echo 'b'};), q($x = 1 ; if ( c ( ) ) { $x = 0 ; } if ( $x ) { echo 'b' ; }),
	'GLOBALS40',  q(function f() {$GLOBALS['$d'] = a('d');}), q(function f ( ) { $GLOBALS [ '' ] = a ( 'd' ) ; }),
	'GLOBALS41',  q($GLOBALS['$d'] = 'a'; $GLOBALS['$e'];), q($ { null } = 'a' ; 'a' ;),
	'GLOBALS42',  q($GLOBALS['a']=f(); if(!$GLOBALS['a']) {echo 'c';}), q($a = f ( ) ; if ( ! $a ) { echo 'c' ; }),
	'i:GLOBALS43',  q($x = "foo"; if (a()) $y=array($GLOBALS[x]['0'] => f())), q($x = 'foo' ; if ( a ( ) ) { $y = array ( 'f' => f ( ) ) ; }),
	'I:GLOBALS43',  q($x = "foo"; if (a()) $y=array($GLOBALS[x]['0'] => f())), q($x = 'foo' ; if ( a ( ) ) { $y = array ( $x [ '0' ] => f ( ) ) ; }),
	'GLOBALS44',  q(function f($x) { if ($GLOBALS['a']) { echo $x; } else { $GLOBALS['b'] .= $x; }} $y=$_GET[0]; $b=$_GET[1]; f($_GET[2].$y);), q(function f ( $x ) { if ( $GLOBALS [ 'a' ] ) { echo $x ; } else { $GLOBALS [ 'b' ] = $GLOBALS [ 'b' ] . $x ; } } $y = $_GET [ 0 ] ; $b = $_GET [ 1 ] ; $b = $_GET [ 1 ] . $_GET [ 2 ] . $_GET [ 0 ] ;),
	'SUPER1',     q($_POST['a']),                     q($_POST [ 'a' ] ;),
	'SUPER2',     q($_POST['a'] = 'foo'; $_POST['a']),q($_POST [ 'a' ] = 'foo' ; 'foo' ;),
	'SUPER3',     q(if($_POST['a']){$x=1} else {$x=2}), q(if ( $_POST [ 'a' ] ) { $x = 1 ; } else { $x = 2 ; }),
	'SUPER4',     q($x = 'a' . $_POST['a'] . 'b'),    q($x = 'a' . $_POST [ 'a' ] . 'b' ;),
	'SUPER5',     q($_POST['a']='b'; $x = 'a' . $_POST['b']), q($_POST [ 'a' ] = 'b' ; $x = 'a' . $_POST [ 'b' ] ;),
	'SUPER6',     q(function f() {$_POST['a']='b'}; $x = $_POST['a']), q(function f ( ) { $_POST [ 'a' ] = 'b' ; } $x = $_POST [ 'a' ] ;),
	'SUPER7',     q($_POST['a']='b';if (!empty($_POST['c'])) {$x=1} ), q($_POST [ 'a' ] = 'b' ; if ( ! empty ( $_POST [ 'c' ] ) ) { $x = 1 ; }),
	'SUPER8',     q($_POST['a'] = 'foo'; $_POST['a'][0]),q($_POST [ 'a' ] = 'foo' ; 'f' ;),
	'SUPER9',     q($_POST['a'] = 'foo'; $_POST),     q($_POST [ 'a' ] = 'foo' ; array ( 'a' => 'foo' ) ;),
	'SUPER10',    q($_POST['b'] ? 1 : 2),             q($_POST [ 'b' ] ? 1 : 2 ;),
	'SUPER11',    q($_POST['a'] = 'a'; $_POST['b'] ? 1 : 2), q($_POST [ 'a' ] = 'a' ; $_POST [ 'b' ] ? 1 : 2 ;),
	'SUPER12',    q($_POST['a'] = 'a'; $_POST['a'] ? 1 : 2), q($_POST [ 'a' ] = 'a' ; 1 ;),
	'SUPER14',    q($x=&$_POST; $x['a']='b'; $_POST['a']), q($x = & $_POST ; $_POST [ 'a' ] = 'b' ; 'b' ;),
	'SUPER15',    q($x=$_POST; $x['a']='b'; $_POST['a']),  q($x = $_POST ; $x [ 'a' ] = 'b' ; $_POST [ 'a' ] ;),
	'SUPER16',    q(if(f($_POST['a'])) { eval($_POST['a']); }), q(if ( f ( $_POST [ 'a' ] ) ) { eval ( $_POST [ 'a' ] ) ; }),
	'SUPER17',    q($_POST["a"]=1; $x=$_POST; $x['b']=2; $_POST; $x;), q($_POST [ 'a' ] = 1 ; $x = array ( 'a' => 1 ) ; $x [ 'b' ] = 2 ; array ( 'a' => 1 ) ; array ( 'a' => 1 , 'b' => 2 ) ;),
	'SUPER18',    q(isset($_POST); $_POST;),          q(1 ; $_POST ;),
	'SUPER19',    q($a='b'; $x=$_POST; $x[$a];),      q($a = 'b' ; $x = $_POST ; $x [ 'b' ] ;),
	'SUPER20',    q($x=$_POST; if (!empty($x['a'])) { echo 'b'; }), q($x = $_POST ; if ( ! empty ( $x [ 'a' ] ) ) { echo 'b' ; }),
	'SUPER21',    q($x=$_POST['a']; if (empty($x)) { $x='1'; } $x;), q($x = $_POST [ 'a' ] ; if ( empty ( $_POST [ 'a' ] ) ) { $x = '1' ; } $x ;),
	'SUPER22',    q($_GET[0]=1; if (isset($_GET[1])) { $x=1; } $x;), q($_GET [ 0 ] = 1 ; if ( isset ( $_GET [ 1 ] ) ) { $x = 1 ; } $x ;),
	'$var[i]',    q($x = "foo"; eval($x[1])),         q($x = 'foo' ; 'o' ;),
	'$var[$n]',   q($x = "foo"; $n=1; eval($x[$n])),  q($x = 'foo' ; $n = 1 ; 'o' ;),
	'$$var',      q($x = 'y'; $y = 'foo'; $$x),       q($x = 'y' ; $y = 'foo' ; 'foo' ;),
	'$$$var',     q($x='y';$y='z';$z='foo'; $$$x),    q($x = 'y' ; $y = 'z' ; $z = 'foo' ; 'foo' ;),
	'${$var}',    q($x = 'y'; $y = 'foo'; ${$x}),     q($x = 'y' ; $y = 'foo' ; 'foo' ;),
	'n:${$var}[n]', q($x = 'foo'; ${$x}['bar']),      q($x = 'foo' ;),
	'N:${$var}[n]', q($x = 'foo'; ${$x}['bar']),      q($x = 'foo' ; $foo [ 'bar' ] ;),
	'$var[$n]=',  q($x='foo'; $x[1]='f'; $x),         q($x = 'foo' ; $x = 'ffo' ; 'ffo' ;),
	'${$var[$n]}',q($x='fox'; $n=2; ${$x[$n]}),       q($x = 'fox' ; $n = 2 ; 'fox' ;),
	'n:f($$a[x])',q($a='foo'; if (f(${$a}['x'])) {}), q($a = 'foo' ; if ( f ( null ) ) { }),
	'N:f($$a[x])',q($a='foo'; if (f(${$a}['x'])) {}), q($a = 'foo' ; if ( f ( $foo [ 'x' ] ) ) { }),
	'${$var}[]',  q($x = 'fox'; $y = 'x'; ${$y}[0]),  q($x = 'fox' ; $y = 'x' ; 'f' ;),
	'$$var[]',    q($x = 'fox'; $y = 'x'; $$y[0]),    q($x = 'fox' ; $y = 'x' ; 'fox' ;),
	'${$var()}',  q($x = 'f'; $y = 'a'; function f() {return 'y';} ${$x()};), q(function f ( ) { return 'y' ; } $x = 'f' ; $y = 'a' ; 'a' ;),
	'$$var()',    q($x = 'y'; $y = 'f'; function f() {return 'a';} $$x();), q(function f ( ) { return 'a' ; } $x = 'y' ; $y = 'f' ; 'a' ;),
	'${$var}()',  q($x = 'y'; $y = 'f'; function f() {return 'a';} ${$x}();), q(function f ( ) { return 'a' ; } $x = 'y' ; $y = 'f' ; 'a' ;),
	'$x[$y++]=',  q($x='foo'; $y=1; $x[$y++]='f'),    q($x = 'foo' ; $y = 1 ; $y = 2 ; $x = 'ffo' ;),
	'$$var=',     q($x=a(); $$x=$_GET{'a'};),         q($x = a ( ) ; $ { $x } = $_GET [ 'a' ] ;),
	'concat',     q('a' . 'b'),                       q('ab' ;),
	'concat2',    q('a' . chr(112) . 'b'),            q('apb' ;),
	'concat3',    q(4 . array('x');),                 q('4Array' ;),
	'concat4',    q(4 . $x='x'; $x),                  q($x = 'x' ; '4x' ; 'x' ;),
	'add',        q('1' + '2' + 3),                   q(6 ;),
	'add2',       q($y = a(); $x = 'a' + $y),         q($y = a ( ) ; $x = 'a' + $y ;),
	'add3',       q($x = -1 - +2),                    q($x = -3 ;),
	'add4',       q($x = 0; $x += 1),                 q($x = 0 ; $x = 1 ;),
	'n:add5',     q($x += 1),                         q($x = 1 ;),
	'N:add5',     q($x += 1),                         q($x = $x + 1 ;),
	'add6',       q($x = a(); $x += 1),               q($x = a ( ) ; $x = $x + 1 ;),
	'add7',       q(a(); $x += 1),                    q(a ( ) ; $x = $x + 1 ;),
	'add8',       q($x = 'a' + 1),                    q($x = 1 ;),
	'add9',       q($x = 'a' + '1'),                  q($x = 1 ;),
	'add10',      q($x = 1 + '2'),                    q($x = 3 ;),
	'n:add11',    q($x = 'a' + $y),                   q($x = 0 ;),
	'N:add11',    q($x = 'a' + $y),                   q($x = 'a' + $y ;),
	'hex',        q($x = 0xff),                       q($x = 255 ;),
	'inc',        q($x = 1; $x++; $x),                q($x = 1 ; $x = 2 ; 2 ;),
	'inc2',       q($x = 1; $x+=7; $x),               q($x = 1 ; $x = 8 ; 8 ;),
	'inc3',       q($x = 1; ++$x),                    q($x = 1 ; $x = 2 ;),
	'inc4',       q($x = 1; $y = 5 + ++$x; $x),       q($x = 1 ; $x = 2 ; $y = 7 ; 2 ;),
	'inc5',       q($x = 'Z'; ++$x),                  q($x = 'Z' ; $x = 'AA' ;),
	'inc6',       q($x = 'AX'; $x--),                 q($x = 'AX' ; $x = 'AX' ;),
	'inc7',       q($x=2; $d=($x<<4)+(++$x)),         q($x = 2 ; $x = 3 ; $d = 35 ;),
	'inc8',       q($x=2; $d=chr(($x<<4)+(++$x))),    q($x = 2 ; $x = 3 ; $d = '#' ;),
	'paren',      q($x = (2*(2 + 4))),                q($x = 12 ;),
	'paren2',     q($x = (1 + 2) * 3 + 4),            q($x = 13 ;),
	'paren3',     q($x = (foo(7))),                   q($x = foo ( 7 ) ;),
	'paren4',     q((1)),                             q(1 ;),
	'paren5',     q(($x = 1)),                        q($x = 1 ;),
	'prec1',      q($x = 1 + 2 * 3 + 4),              q($x = 11 ;),
	'prec2',      q($x = 'a'.'b' ^ ' '.' '),          q($x = 'AB' ;),
	'prec3',      q($x = ('a'.'b' ^ ' '.' ') | ' '),  q($x = 'aB' ;),
	'prec4',      q($x = 'a' . b ^ ' '.' ' | '  '),   q($x = 'ab' ;),
	'prec5',      q($x = ~1 & 0xff),                  q($x = 254 ;),
	'prec6',      q($x = 1 != 2),                     q($x = 1 ;),
	'prec7',      q($x = 1 === 1),                    q($x = 1 ;),
	'prec8',      q($x = a(); $x >>= 2),              q($x = a ( ) ; $x = $x >> 2 ;),
	'prec9',      q($x = round(8800000000 / 0x100000000, 12);), q($x = 2.048909664154 ;),
	'prec10',     q($x = (a() || !(b()));),           q($x = a ( ) || ! b ( ) ;),
	'prec11',     q(if (f()) {$x = $a % $b == $c;}),  q(if ( f ( ) ) { $x = ( $a % $b ) == $c ; }),
	'n:prec12',   q($x >>= 2),                        q($x = 0 ;),
	'N:prec12',   q($x >>= 2),                        q($x = $x >> 2 ;),
	'ter1',       q($x = 1 ? 2 : 3),                  q($x = 2 ;),
	'ter2',       q($x = 'a' ?: 'b'),                 q($x = 'a' ;),
	'ter3',       q($x = true?'true':false?'t':'f'),  q($x = 't' ;),
	'ter4',       q($y = a(); $x = $y ? 2 : 3),       q($y = a ( ) ; $x = $y ? 2 : 3 ;),
	'n:ter5',     q($x = $y ? 2 : 3),                 q($x = 3 ;),
	'N:ter5',     q($x = $y ? 2 : 3),                 q($x = $y ? 2 : 3 ;),
	'n:ter6',     q($a ? ( - 1 ) : 1;),               q(1 ;),
	'N:ter6',     q($a ? ( - 1 ) : 1;),               q($a ? -1 : 1 ;),
	'ter6',       q($x = $_POST['y'] ? 1 : 2;),       q($x = $_POST [ 'y' ] ? 1 : 2 ;),
	'ter7',       q($x = ($_POST['y']) ? 1 : 2;),     q($x = $_POST [ 'y' ] ? 1 : 2 ;),
	'ter8',       q($x = $_POST['y'] ?: 1;),          q($x = $_POST [ 'y' ] ?: 1 ;),
	'n:ter9',     q($x = $x[0] ?: 1;),                q($x = 1 ;),
	'N:ter9',     q($x = $x[0] ?: 1;),                q($x = $x [ 0 ] ?: 1 ;),
	'ter10',      q($x = ($x='a') ? 'b' : c();),      q($x = 'a' ; $x = 'b' ;),
	'ter11',      q($x = a() ? $x='b' : c();),        q($x = a ( ) ? ( $x = 'b' ) : c ( ) ;),
	'ter12',      q($x = a() ? b() : $x='c';),        q($x = a ( ) ? b ( ) : ( $x = 'c' ) ;),
	'nullcoal1',  q($x = 1 ?? 2;),                    q($x = 1 ;),
	'n:nullcoal2',q($x = $a ?? 1;),                   q($x = 1 ;),
	'N:nullcoal2',q($x = $a ?? 1;),                   q($x = $a ?? 1 ;),
	'n:nullcoal3',q($x = $x[0] ?? 1;),                q($x = 1 ;),
	'N:nullcoal3',q($x = $x[0] ?? 1;),                q($x = $x [ 0 ] ?? 1 ;),
	'spaceship1', q($x = 1 <=> 2;),                   q($x = -1 ;),
	'spaceship2', q($x = "b" <=> "a";),               q($x = 1 ;),
	'spaceship3', q($x = 1.5 <=> 1.5;),               q($x = 0 ;),
	'unset1',     q($x = 1; unset($x); $x),           q($x = 1 ; unset ( $x ) ;),
	'unset2',     q($x = array('a'); unset($x[0]); $x), q($x = array ( 0 => 'a' ) ; unset ( $x [ 0 ] ) ; array ( ) ;),
	'unset3',     q(unset($GLOBALS['x']);),           q(unset ( $x ) ;),
	'unset4',     q($x=array('a'); unset($x[0]); $x), q($x = array ( 0 => 'a' ) ; unset ( $x [ 0 ] ) ; array ( ) ;),
	'unset5',     q(unset($_POST[f(0)]); function f() {return 'a';}), q(function f ( ) { return 'a' ; } unset ( $_POST [ 'a' ] ) ;),
	'unref',      q($x = $_POST['y']; $x),            q($x = $_POST [ 'y' ] ; $_POST [ 'y' ] ;),
	'unref2',     q($x = open('y'); $y=$x),           q($x = open ( 'y' ) ; $y = $x ;),
	'n:unref3',   q($x = $y[2] & foo('y'); $x),       q($x = null & foo ( 'y' ) ; $x ;),
	'N:unref3',   q($x = $y[2] & foo('y'); $x),       q($x = $y [ 2 ] & foo ( 'y' ) ; $x ;),
	'unref4',     q($x = '_POST'; foo(${$x}['y'])),   q($x = '_POST' ; foo ( $_POST [ 'y' ] ) ;),
	'unref5',     q($x = 'foo'; if(!$x('y')){}),      q($x = 'foo' ; if ( ! foo ( 'y' ) ) { }),
	'unref6',     q($x = 'foo'; if(fopen($x)+$x()){}),q($x = 'foo' ; if ( fopen ( 'foo' ) + foo ( ) ) { }),
	'unref7',     q($y=a(); $x = $y+1; $z=$x+($x+$x)),q($y = a ( ) ; $x = $y + 1 ; $z = $x + $x + $x ;),
	'unref8',     q($x = $_POST['y']; $y=empty($x)),  q($x = $_POST [ 'y' ] ; $y = empty ( $_POST [ 'y' ] ) ;),
	'unref9',     q($x = $_POST[y]; if(empty($x)){}), q($x = $_POST [ 'y' ] ; if ( empty ( $_POST [ 'y' ] ) ) { }),
	'i:unref10',  q($x = 'foo'; if($x()+$x()){}),     q($x = 'foo' ; if ( foo ( ) + foo ( ) ) { }),
	'I:unref10',  q($x = 'foo'; if($x()+$x()){}),     q($x = 'foo' ; if ( foo ( ) + $x ( ) ) { }),
	'n:unref11',  q($x = $y+1; $z=$x+($x+$x)),        q($x = 1 ; $z = 3 ;),
	'N:unref11',  q($x = $y+1; $z=$x+($x+$x)),        q($x = $y + 1 ; $z = $x + $x + $x ;),
	'null1',      q($x = ($y == null)),               q($x = 1 ;),
	'null2',      q($x = ($y === null)),              q($x = 1 ;),
	'null3',      q($x = is_null($y)),                q($x = 1 ;),
	'null4',      q($x = isset($y)),                  q($x = 0 ;),
	'null5',      q($x = empty($y)),                  q($x = 1 ;),
	'null6',      q($y = '';$x = ($y == null)),       q($y = '' ; $x = 1 ;),
	'null7',      q($y = '';$x = ($y === null)),      q($y = '' ; $x = 0 ;),
	'null8',      q($y = '';$x = is_null($y)),        q($y = '' ; $x = 0 ;),
	'null9',      q($y = '';$x = isset($y)),          q($y = '' ; $x = 1 ;),
	'null10',     q($y = '';$x = empty($y)),          q($y = '' ; $x = 1 ;),
	'null11',     q(if (null) { echo "a"; } else { echo "b"; }), q(echo 'b' ; $STDOUT = 'b' ;),
	'null12',     q(if (eval("echo \"c\";")) { echo "a"; } else { echo "b"; }), q(echo 'c' ; echo 'b' ; $STDOUT = 'cb' ;),
	'null13',     q($y = is_null($GLOBALS['x']);),    q($y = 1 ;),
	'n:null14',   q($y = empty($GLOBALS['x'][1]);),   q($y = 1 ;),
	'N:null14',   q($y = empty($GLOBALS['x'][1]);),   q($y = empty ( $x [ 1 ] ) ;),
	'null15',     q(${null} = 1; echo ${""};),        q($ { null } = 1 ; echo 1 ; $STDOUT = '1' ;),
	'n:null16',   q(${"$xx"} = 1; echo ${""};),       q($ { null } = 1 ; echo 1 ; $STDOUT = '1' ;),
	'N:null16',   q(${"$xx"} = 1; echo ${""};),       q($ { ( '' . $xx ) } = 1 ; echo $ { null } $STDOUT = $ { null }),
	'n:null17',   q(${"$xx"} = 1; echo ${"$yy"};),    q($ { null } = 1 ; echo 1 ; $STDOUT = '1' ;),
	'N:null17',   q(${"$xx"} = 1; echo ${"$yy"};),    q($ { ( '' . $xx ) } = 1 ; echo $ { ( '' . $yy ) } $STDOUT = $ { ( '' . $yy ) }),
	'n:null18',   q($GLOBALS{"$"} = 1; echo ${""}; echo ${"$"};), q($ { '$' } = 1 ; echo null ; echo 1 ; $STDOUT = '1' ;),
	'N:null18',   q($GLOBALS{"$"} = 1; echo ${""}; echo ${"$"};), q($ { '$' } = 1 ; echo $ { null } echo 1 ; $STDOUT = $ { null } . '1' ;),
	'arr-null1',  q($a = array();$x = ($a == null)),  q($a = array ( ) ; $x = 1 ;),
	'arr-null2',  q($a = array();$x = ($a === null)), q($a = array ( ) ; $x = 0 ;),
	'arr-null3',  q($a = array();$x = is_null($a)),   q($a = array ( ) ; $x = 0 ;),
	'arr-null4',  q($a = array();$x = isset($a)),     q($a = array ( ) ; $x = 1 ;),
	'arr-null5',  q($a = array();$x = empty($a)),     q($a = array ( ) ; $x = 1 ;),
	'arr-null6',  q($a = array('a');$x = empty($a)),  q($a = array ( 0 => 'a' ) ; $x = 0 ;),
	'arr-null7',  q($a = array('a');$x = empty($a[0])),  q($a = array ( 0 => 'a' ) ; $x = 0 ;),
	'arr-null8',  q($a = array('a');$x = empty($a[1])),  q($a = array ( 0 => 'a' ) ; $x = 1 ;),
	'arr-null9',  q($a = array('a');$x = empty($a[0][0])),  q($a = array ( 0 => 'a' ) ; $x = 0 ;),
	'str-null1',  q($s = 'foo';$x = ($s[1] == null)), q($s = 'foo' ; $x = 0 ;),
	'str-null2',  q($s = 'foo';$x = ($s[3] == null)), q($s = 'foo' ; $x = 1 ;),
	'intval',     q($x = intval(-2);),                q($x = -2 ;),
	'isset1',     q($x = isset($_POST[x])),           q($x = isset ( $_POST [ 'x' ] ) ;),
	'isset2',     q($x = f();$y = isset($x)),         q($x = f ( ) ; $y = isset ( $x ) ;),
	'isset3',     q($a = array();$y=isset($a['1'])),  q($a = array ( ) ; $y = 0 ;),
	'isset4',     q(if (isset($_POST)) { $x = "a"; } else { $x = "b"; }), q($x = 'a' ;),
	'assign1',    q($x=1;$y=a();$x=$y+1),             q($x = 1 ; $y = a ( ) ; $x = $y + 1 ;),
	'assign2',    q($x=1;$y=($x=8+$x)+2;echo $x,$y),  q($x = 1 ; $x = 9 ; $y = 11 ; echo '911' ; $STDOUT = '911' ;),
	'i:assign3',  q(($x=1) && foo('a'); $x),          q($x = 1 ; 1 && foo ( 'a' ) ; 1 ;),
	'I:assign3',  q(($x=1) && foo('a'); $x),          q($x = 1 ; 1 && foo ( 'a' ) ; $x ;),
	'assign4',    q($x=1; $y=$x; $x=2; $y),           q($x = 1 ; $y = 1 ; $x = 2 ; 1 ;),
	'assign5',    q($x=a(); $y=$x; $x=2; $y),         q($x = a ( ) ; $y = $x ; $x = 2 ; $y ;),
	'assign6',    q(a(); $x.=foo($a) ? 'a' : 'b'),    q(a ( ) ; $x = $x . ( foo ( $a ) ? 'a' : 'b' ) ;),
	'assign7',    q(a(); ($x=1) && foo($y)),          q(a ( ) ; $x = 1 ; 1 && foo ( $y ) ;),
	'i:assign8',  q(($x=1) and foo('a'); $x),         q($x = 1 ; 1 and foo ( 'a' ) ; 1 ;),
	'I:assign8',  q(($x=1) and foo('a'); $x),         q($x = 1 ; 1 and foo ( 'a' ) ; $x ;),
	'assign9',    q($x[$y = 'a'] = 'd'),              q($y = 'a' ; $x [ 'a' ] = 'd' ;),
	'n:assign10', q($x=1;$x=$y+1),                    q($x = 1 ; $x = 1 ;),
	'N:assign10', q($x=1;$x=$y+1),                    q($x = 1 ; $x = $y + 1 ;),
	'block',      q({ echo '1'; }),                   q(echo '1' ; $STDOUT = '1' ;),
	'block2',     q({ $x = '1'; $x }),                q($x = '1' ; '1' ;),
	'block3',     q({ '2'; echo '1'; }),              q('2' ; echo '1' ; $STDOUT = '1' ;),
	'comment',    q(/* test */ ?> y),                 q(echo ' y' ; $STDOUT = ' y' ;),
	'comment2',   q(// test <? y),                    q(),
	'comment3',   q(?>// test <? y),                  q(echo '// test ' ; 'y' ; $STDOUT = '// test ' ;),
	'comment4',   q(# test <? y),                     q(),
	'comment5',   q(// test ?> y),                    q(echo ' y' ; $STDOUT = ' y' ;),
	#'#str',       q(#str7),                           q(#str7 ;),
	'#str',       q(#str7),                           q(),
	'if',         q($x=1; if($x<3) { $x; }),          q($x = 1 ; 1 ;),
	'if2',        q(a(); if($x<3) {$y=2} else {$y=3}),q(a ( ) ; if ( $x < 3 ) { $y = 2 ; } else { $y = 3 ; }),
	'if3',        q($x=1; if($x<3) : $x; endif),      q($x = 1 ; 1 ;),
	'if4',        q($x=a(); if($x<3) {$y} elseif($a) {$z}),   q($x = a ( ) ; if ( $x < 3 ) { $y ; } else if ( $a ) { $z ; }),
	'if5',        q(function f(){if($x=g()) return $x}),  q(function f ( ) { $x = g ( ) ; if ( $x ) { return $x ; } }),
	'if6',        q($x=$_POST['y']; if($x=='a') echo 'a' elseif ($x=='b') echo 'b' elseif ($x=='c') echo 'c'),  q($x = $_POST [ 'y' ] ; if ( $_POST [ 'y' ] == 'a' ) { echo 'a' ; } else if ( $_POST [ 'y' ] == 'b' ) { echo 'b' ; } else if ( $_POST [ 'y' ] == 'c' ) { echo 'c' ; }),
	'if7',        q($x=a(); if($x<3) $a=$b($c)),      q($x = a ( ) ; if ( $x < 3 ) { $a = $b ( $c ) ; }),
	'if8',        q(if($x = 'b') eval($x)),           q($x = 'b' ; 'b' ;),
	'if9',        q(if($x = foo('a')) eval($x)),      q($x = foo ( 'a' ) ; if ( $x ) { eval ( $x ) ; }),
	'if10',       q(if(empty($a)) {$x=1} else {$x=2}),q($x = 1 ;),
	'if11',       q(if(a()){ if(empty($a)) {$x=1}}),  q(if ( a ( ) ) { if ( empty ( $a ) ) { $x = 1 ; } }),
	'if12',       q(if(!($x=a())) {$x=''}),           q($x = a ( ) ; if ( ! $x ) { $x = '' ; }),
	'if13',       q(if(!$x=a()) {$y=3}),              q($x = a ( ) ; if ( ! $x ) { $y = 3 ; }),
	'if14',       q(if(1+($x=a())) {$y=3}),           q($x = a ( ) ; if ( 1 + $x ) { $y = 3 ; }),
	'if15',       q(if(1+($x=2)) {a()}),              q($x = 2 ; a ( ) ;),
	'n:if16',     q(if ($GLOBALS['c']) { echo 'a'; } else { echo 'b'; }), q(echo 'b' ; $STDOUT = 'b' ;),  
	'N:if16',     q(if ($GLOBALS['c']) { echo 'a'; } else { echo 'b'; }), q(if ( $c ) { echo 'a' ; } else { echo 'b' ; }),  
	'if17',       q(if(a()) { echo 'a'; } elseif ($x==($y='1')) { echo 'b';}), q(if ( a ( ) ) { echo 'a' ; } else { $y = '1' ; if ( $x == '1' ) { echo 'b' ; } }),
	'if18',       q(if(b()) { $x=$y; getcwd($x); }),  q(if ( b ( ) ) { $x = $y ; getcwd ( $x ) ; }),
	'if19',       q(if(b()) { $x=c(); getcwd($x); }), q(if ( b ( ) ) { $x = c ( ) ; getcwd ( $x ) ; }),
	'if20',       q($y=a(); if(file_exists('a')) { $x=$y; getcwd($x); }), q($y = a ( ) ; if ( file_exists ( 'a' ) ) { $x = $y ; getcwd ( $x ) ; }),
	'if21',       q(function f($y) { if(file_exists('a')) { $x=$y; getcwd($x); }}), q(function f ( $y ) { if ( file_exists ( 'a' ) ) { $x = $y ; getcwd ( $x ) ; } }),
	'if22',       q(if(a()+($x=1)) {$y=3}),           q($x = 1 ; if ( a ( ) + 1 ) { $y = 3 ; }),
	'if23',       q(if(a()) {$y=b() or c();),         q(if ( a ( ) ) { $y = b ( ) ; $y or c ( ) ; }),
	'if24',       q(if($x[0]=b()) { c();),            q($x [ 0 ] = b ( ) ; if ( $x [ 0 ] ) { c ( ) ; }),
	'n:if25',     q(if($x<3) {$y=2} else {$y=3}),     q($y = 2 ;),
	'N:if25',     q(if($x<3) {$y=2} else {$y=3}),     q(if ( $x < 3 ) { $y = 2 ; } else { $y = 3 ; }),
	'list1',      q($a=['a','b','c']; $a[1];),        q($a = array ( 0 => 'a' , 1 => 'b' , 2 => 'c' ) ; 'b' ;),
	'list2',      q([$a,$b]=['a','b','c']; $a; $b;),  q(list ( $a , $b ) = array ( 0 => 'a' , 1 => 'b' , 2 => 'c' ) ; 'a' ; 'b' ;),
	'list3',      q(list($a,$b)=['a','b']; $a; $b;),  q(list ( $a , $b ) = array ( 0 => 'a' , 1 => 'b' ) ; 'a' ; 'b' ;),
	'list4',      q([$a,,$b]=['a','b','c']; $a; $b;), q(list ( $a , , $b ) = array ( 0 => 'a' , 1 => 'b' , 2 => 'c' ) ; 'a' ; 'c' ;),
	'list5',      q([$a[1],$a[0]]=['a','b']; $a;),    q(list ( $a [ 1 ] , $a [ 0 ] ) = array ( 0 => 'a' , 1 => 'b' ) ; array ( 1 => 'a' , 0 => 'b' ) ;),
	'list6',      q($a=['a', 'x' => 'b']; $a[0]),     q($a = array ( 0 => 'a' , 'x' => 'b' ) ; 'a' ;),
	'list7',      q(function f($x) { return [$a,$b]=$x; } f(['a','b']);),  q(function f ( $x ) { return list ( $a , $b ) = $x ; } array ( 0 => 'a' , 1 => 'b' ) ;),
	'array',      q($a=array('a','b','c'); $a[1]),    q($a = array ( 0 => 'a' , 1 => 'b' , 2 => 'c' ) ; 'b' ;),
	'array2',     q(a(); $x='b'; $a=array('a',${$x})),q(a ( ) ; $x = 'b' ; $a = array ( 0 => 'a' , 1 => $b ) ;),
	'array3',     q($a=array(2 => 'a'); $a[2]),       q($a = array ( 2 => 'a' ) ; 'a' ;),
	'array4',     q($a=array(foo('x') => 'a')),       q($a = array ( foo ( 'x' ) => 'a' ) ;),
	'array5',     q(a(); $a=$b[0][1]),                q(a ( ) ; $a = $b [ 0 ] [ 1 ] ;),
	'array6',     q($x=array(); $x[0]=1),             q($x = array ( ) ; $x [ 0 ] = 1 ;),
	'array7',     q($x=array(); $x[0]=a(); $y=$x; $x=array(); $x[0]=$y),     q($x = array ( ) ; $x [ 0 ] = a ( ) ; $y = $x ; $x = array ( ) ; $x [ 0 ] = $y ;),
	'array8',     q($b['foo'][] = a()),               q($b [ 'foo' ] [ ] = a ( ) ;),
	'array9',     q($b['foo']['bar'] = a()),          q($b [ 'foo' ] [ 'bar' ] = a ( ) ;),
	'array10',    q($a=array(); $a['x']['y']=b(); $a),q($a = array ( ) ; $a [ 'x' ] [ 'y' ] = b ( ) ; $a ;),
	'array11',    q($a=array('x' => 'a'); $a[x]),     q($a = array ( 'x' => 'a' ) ; 'a' ;),
	'array12',    q($a=array();$a[]='x';$a[]='y';$a), q($a = array ( ) ; $a [ ] = 'x' ; $a [ ] = 'y' ; array ( 0 => 'x' , 1 => 'y' ) ;),
	'array13',    q($a=array('a','b','c'); $a[1.02]), q($a = array ( 0 => 'a' , 1 => 'b' , 2 => 'c' ) ; 'b' ;),
	'array14',    q($a=['a','b','c']; $a[1]),         q($a = array ( 0 => 'a' , 1 => 'b' , 2 => 'c' ) ; 'b' ;),
	'array15',    q($a=array('a','b','c')[2]; $a),    q($a = 'c' ; 'c' ;),
	'array16',    q($a=array('a','b')[1].array('c','d')[1]; $a),    q($a = 'bd' ; 'bd' ;),
	'n:array17',  q($a=$b[0][1]),                     q($a = null ;),
	'N:array17',  q($a=$b[0][1]),                     q($a = $b [ 0 ] [ 1 ] ;),
	'array18',    q($a=array(); if(b()) {$a[]='c';}), q($a = array ( ) ; if ( b ( ) ) { $a [ ] = 'c' ; }),
	'array19',    q($a=array(); $a['x']['y']='foo'; $a), q($a = array ( ) ; $a [ 'x' ] [ 'y' ] = 'foo' ; array ( 'x' => array ( 'y' => 'foo' ) ) ;),
	'array20',    q($x=1; $a=array('b'); $a[0]=$a[0].$x; $a), q($x = 1 ; $a = array ( 0 => 'b' ) ; $a [ 0 ] = 'b1' ; array ( 0 => 'b1' ) ;),
	'array21',    q($a=array(); $a[]='b'; $a[]='c'; $a), q($a = array ( ) ; $a [ ] = 'b' ; $a [ ] = 'c' ; array ( 0 => 'b' , 1 => 'c' ) ;),
	'array22',    q($a=array(); $a[]='b'; $a[]='c'; $x=0; $a[$x] = $a[$x] . '1' ; $a), q($a = array ( ) ; $a [ ] = 'b' ; $a [ ] = 'c' ; $x = 0 ; $a [ 0 ] = 'b1' ; array ( 0 => 'b1' , 1 => 'c' ) ;),
	'array23',    q(function f($d) {$a=array(); $a[]='b'; $x=0; $y='d'.$d; $a[$x] = $a[$x] . $y ; $z=count($a);}), q(function f ( $d ) { $a = array ( ) ; $a [ ] = 'b' ; $x = 0 ; $y = 'd' . $d ; $a [ 0 ] = 'b' . $y ; $z = count ( $a ) ; }),
	'array24',    q($a='b'; ${$a}[0] = 1),            q($a = 'b' ; $b [ 0 ] = 1 ;),
	'array25',    q($a['w']['x']['y']['z']='b'; $a),  q($a [ 'w' ] [ 'x' ] [ 'y' ] [ 'z' ] = 'b' ; array ( 'w' => array ( 'x' => array ( 'y' => array ( 'z' => 'b' ) ) ) ) ;),
	'array26',    q(if (array()) {$x=1;} else {$x=2;}),     q($x = 2 ;),
	'array27',    q(if (!array()) {$x=1;} else {$x=2;}),    q($x = 1 ;),
	'array28',    q(if (!array('a')) {$x=1;} else {$x=2;}), q($x = 2 ;),
	'array29',    q($x = array('a') == array('a');),  q($x = 1 ;),
	'array30',    q($x = array('a') == array('b');),  q($x = 0 ;),
	'array31',    q($x = 'x' < array('a');),          q($x = 1 ;),
	'array32',    q($a=array('a','b'); $a[0.123];),   q($a = array ( 0 => 'a' , 1 => 'b' ) ; 'a' ;),
	'array33',    q($a=array(1=>"a","1"=>"b",1.5=>"c",true=>"d",);), q($a = array ( 1 => 'd' ) ;),
	'array34',    q($a=array(-2=>"x", "y");),         q($a = array ( -2 => 'x' , -1 => 'y' ) ;),
	'array35',    q($a=array(1=>"a", "1"=>"b", 1.5=>"c", -1=>"d", "01"=>"e", "1.5"=>"f", true=>"g", false=>"h", ""=>"i", null=>"j", "k", 2=>"l");), q($a = array ( 1 => 'g' , -1 => 'd' , '01' => 'e' , '1.5' => 'f' , 0 => 'h' , '' => 'j' , 2 => 'l' ) ;),
	'array36',    q($a=array("a", 0=>"b", "c");),     q($a = array ( 0 => 'b' , 1 => 'c' ) ;),
	'array37',    q($a[0]=array('x'); $a;),           q($a [ 0 ] = array ( 0 => 'x' ) ; array ( 0 => array ( 0 => 'x' ) ) ;),
	'array38',    q($a=''; $a[0]=array('x'); $a;),    q($a = '' ; $a [ 0 ] = array ( 0 => 'x' ) ; array ( 0 => array ( 0 => 'x' ) ) ;), # up to php70
	'n:array39',  q($x='b'; $a=array('a',${$x})),     q($x = 'b' ; $a = array ( 0 => 'a' , 1 => null ) ;),
	'N:array39',  q($x='b'; $a=array('a',${$x})),     q($x = 'b' ; $a = array ( 0 => 'a' , 1 => $b ) ;),
	'n:is_array1',q(is_array($a);),                   q(0 ;),
	'N:is_array1',q(is_array($a);),                   q(is_array ( $a ) ;),
	'is_array2',  q($a=array(); is_array($a);),       q($a = array ( ) ; 1 ;),
	'is_array3',  q(is_array($_POST);),               q(1 ;),
	'array_map',  q(function f($x) { return $x+$x; } array_map('f', array(1,2));), q(function f ( $x ) { return $x + $x ; } array ( 0 => 2 , 1 => 4 ) ;),
	'array_walk', q($a=array('a','b'); function f(&$x) { $x=strtoupper($x); } array_walk($a, 'f'); $a), q(function f ( & $x ) { $x = strtoupper ( $x ) ; } $a = array ( 0 => 'a' , 1 => 'b' ) ; 1 ; array ( 0 => 'A' , 1 => 'B' ) ;),
	'array_walk2',q($a=array('a','b'); array_walk($a, function f($v,$k) { echo "[$k:$v]" })), q($a = array ( 0 => 'a' , 1 => 'b' ) ; 1 ; $STDOUT = '[0:a][1:b]' ;),
	'array_rand', q($a=array('a','b'); array_rand($a,2);), q($a = array ( 0 => 'a' , 1 => 'b' ) ; array ( 0 => 0 , 1 => 1 ) ;),
	'array_rand2',q($a=array('a'=>'b'); array_rand($a);), q($a = array ( 'a' => 'b' ) ; 'a' ;),
	'array_push', q($a=array('a'); array_push($a,'b'); $a;),  q($a = array ( 0 => 'a' ) ; 2 ; array ( 0 => 'a' , 1 => 'b' ) ;),
	'array_push2',q(array_push($a,'b'); $a;),          q(1 ; array ( 0 => 'b' ) ;),
	'array_pop',  q($a=array('a','b'); array_pop($a); $a;), q($a = array ( 0 => 'a' , 1 => 'b' ) ; 'b' ; array ( 0 => 'a' ) ;),
	'array_pop2', q($a=array(); $x=array_pop($a);),    q($a = array ( ) ; $x = null ;),
	'unshift',    q($a=array('a'); array_unshift($a,'b'); $a;),  q($a = array ( 0 => 'a' ) ; 2 ; array ( 0 => 'b' , 1 => 'a' ) ;),
	'unshift2',   q(array_unshift($a,'b'); $a;),       q(1 ; array ( 0 => 'b' ) ;),
	'shift',      q($a=array('a','b'); array_shift($a); $a;), q($a = array ( 0 => 'a' , 1 => 'b' ) ; 'a' ; array ( 0 => 'b' ) ;),
	'shift2',     q($a=array(); $x=array_shift($a);),  q($a = array ( ) ; $x = null ;),
	'each',       q($a=array('a','b'); $b=each($a); $c=each($a)),  q($a = array ( 0 => 'a' , 1 => 'b' ) ; $b = array ( 0 => 0 , 1 => 'a' ) ; $c = array ( 0 => 1 , 1 => 'b' ) ;),
	'each2',      q($a[0]=array('a','b'); $b=each($a[0]);),  q($a [ 0 ] = array ( 0 => 'a' , 1 => 'b' ) ; $b = array ( 0 => 0 , 1 => 'a' ) ;),
	'n:each3',    q($a=array('a'); while (list($k,$v)=each($a)) { $b.=$v; }),  q($a = array ( 0 => 'a' ) ; $k = 0 ; $v = 'a' ; $b = 'a' ;),
	'N:each3',    q($a=array('a'); while (list($k,$v)=each($a)) { $b.=$v; }),  q($a = array ( 0 => 'a' ) ; while ( list ( $k , $v ) = 0 ) { $b = $b . $v ; }),
	'next',       q($a=array('a','b'); $b=next($a); $c=next($a);),  q($a = array ( 0 => 'a' , 1 => 'b' ) ; $b = 'b' ; $c = 0 ;),
	'prev',       q($a=array('a','b'); $b=next($a); $c=prev($a);),  q($a = array ( 0 => 'a' , 1 => 'b' ) ; $b = 'b' ; $c = 'a' ;),
	'reset',      q($a=array('a','b'); $b=next($a); $c=reset($a);),  q($a = array ( 0 => 'a' , 1 => 'b' ) ; $b = 'b' ; $c = 'a' ;),
	'end',        q($a=array('a','b'); $b=end($a); $c=current($a);),  q($a = array ( 0 => 'a' , 1 => 'b' ) ; $b = 'b' ; $c = 'b' ;),
	'func',       q(function f($x){return $x;} f(2);), q(function f ( $x ) { return $x ; } 2 ;),
	'func2',      q($a='ab';function f($x){return $x;} f($a[1]);), q(function f ( $x ) { return $x ; } $a = 'ab' ; 'b' ;),
	'func3',      q(function f($x){return $x;};$x='f';$x(2)), q(function f ( $x ) { return $x ; } $x = 'f' ; 2 ;),
	'func4',      q(function f($x){$x++; return $x;};f(2)), q(function f ( $x ) { $x ++ ; return $x ; } 3 ;),
	'func5',      q(function f($x){return $x; ++$x};f(2)), q(function f ( $x ) { return $x ; } 2 ;),
	'func6',      q(function f($x){$a=array('a');return $a[$x];}f(0)), q(function f ( $x ) { $a = array ( 0 => 'a' ) ; return $a [ $x ] ; } 'a' ;),
	'func8',      q(f(3);function f($x){return $x;}), q(function f ( $x ) { return $x ; } 3 ;),
	'func9',      q(f(3);if ($y) function f($x){return $x;}), q(f ( 3 ) ; if ( $y ) { function f ( $x ) { return $x ; } }),
	'func10',     q(eval('function f(){if(${x}) return h()};')),  q(function f ( ) { if ( $x ) { return h ( ) ; } }),
	'func11',     q(eval('$x=f();function f(){return 1};')),  q(function f ( ) { return 1 ; } $x = 1 ;),
	'func12',     q(function f(){if($x){return 1}return 2};$y=f()),  q(function f ( ) { if ( $x ) { return 1 ; } return 2 ; } $y = 2 ;),
	'func13',     q(function f($x){return $x;};$x[0]='f';$x[0](2)), q(function f ( $x ) { return $x ; } $x [ 0 ] = 'f' ; 2 ;),
	'func14',     q(function f($x){return $x;};$x[0]='f';$GLOBALS[x][0](2)), q(function f ( $x ) { return $x ; } $x [ 0 ] = 'f' ; 2 ;),
	'func15',     q(function f($x){return $x;};$x=Array('f');$GLOBALS[x][0](2)), q(function f ( $x ) { return $x ; } $x = array ( 0 => 'f' ) ; 2 ;),
	'func16',     q(function f(){ eval(strrev(";)(emanu_php ohce"));}), q(function f ( ) { echo php_uname ( ) ; }),
	'func17',     q(a(); call_user_func('foo','x',$y)),    q(a ( ) ; foo ( 'x' , $y ) ;),
	'func18',     q(a(); if($x) call_user_func('foo',$y)), q(a ( ) ; if ( $x ) { foo ( $y ) ; }),
	'func19',     q(a(); if($x) call_user_func_array('foo',array('x'.'y'))),    q(a ( ) ; if ( $x ) { foo ( 'xy' ) ; }),
	'func20',     q(function f(){$GLOBALS[$GLOBALS[a]]()}), q(function f ( ) { $GLOBALS [ $GLOBALS [ 'a' ] ] ( ) ; }),
	'func21',     q(function f(){$GLOBALS[a]='x';c($GLOBALS[a])}), q(function f ( ) { $GLOBALS [ 'a' ] = 'x' ; c ( 'x' ) ; }),
	'func22',     q(function f(){$GLOBALS[a]='x';c(${$GLOBALS[a]})}), q(function f ( ) { $GLOBALS [ 'a' ] = 'x' ; c ( $x ) ; }),
	'func23',     q(function f(){$GLOBALS[a]='x';c(${$GLOBALS[a]} - 1)}), q(function f ( ) { $GLOBALS [ 'a' ] = 'x' ; c ( $x - 1 ) ; }),
	'func24',     q(function f($x){return a($x);};f(3)), q(function f ( $x ) { return a ( $x ) ; } a ( 3 ) ;),
	'func25',     q(function f($x){$y=1;return a($y);};f(3)), q(function f ( $x ) { $y = 1 ; return a ( 1 ) ; } a ( 1 ) ;),
	'func26',     q(function f($x){$y=z();return a($y);};f(3)), q(function f ( $x ) { $y = z ( ) ; return a ( $y ) ; } ( function ( ) { $y = z ( ) ; return a ( $y ) ; } ) ( ) ;),
	'func27',     q($x=function(){return 'a'}; $x();), q($x = function ( ) { return 'a' ; } 'a' ;),
	'func28',     q($x=function(){return a() }; $x();), q($x = function ( ) { return a ( ) ; } a ( ) ;),
	'func29',     q($x=function(){ a() }; $x();),     q($x = function ( ) { a ( ) ; } a ( ) ;),
	'func30',     q(function a($x) {eval(base64_decode($x))} a('Zm9v')), q(function a ( $x ) { eval ( base64_decode ( $x ) ) ; } 'foo' ;),
	'func31',     q($a=function($x) {eval(base64_decode($x))}; $a('Zm9v')), q($a = function ( $x ) { eval ( base64_decode ( $x ) ) ; } 'foo' ;),
	'func32',     q(function f(){ echo 'a' }; f()),   q(function f ( ) { echo 'a' ; } echo 'a' ; $STDOUT = 'a' ;),
	'func33',     q(function f($x){return a($x).b($x);};f(3);), q(function f ( $x ) { return a ( $x ) . b ( $x ) ; } a ( 3 ) . b ( 3 ) ;),
	'func34',     q(function f($x){return $_GET[$x];};f(3);), q(function f ( $x ) { return $_GET [ $x ] ; } $_GET [ 3 ] ;),
	'func35',     q(function f($x){return eval('if (a($x)) { $y=2; }');};f(3);), q(function f ( $x ) { if ( a ( $x ) ) { $y = 2 ; } return null ; } a ( 3 ) ;),
	'func36',     q(function f($x){return eval($x);} f('if (a($a)) { $y=2; }');), q(function f ( $x ) { return eval ( $x ) ; } a ( null ) ;),
	'func37',     q(function f($x = 1) {return $x;}), q(function f ( $x = 1 ) { return $x ; }),
	'func38',     q(function f() { $x=1; if($_GET[0]) {echo 'b';} elseif ($x) { echo $c;}}), q(function f ( ) { $x = 1 ; if ( $_GET [ 0 ] ) { echo 'b' ; } else { echo $c ; } }),
	'func39',     q($a=function($x) {eval("echo \"".base64_decode($x)."\";");}; $a("Zm9v");), q($a = function ( $x ) { eval ( 'echo "' . base64_decode ( $x ) . '";' ) ; } echo 'foo' ; $STDOUT = 'foo' ;),
	'func40',     q(echo function($x) { return $x;}(4);), q(echo 4 ; $STDOUT = '4' ;),
	'func41',     q(echo (function($x) { return $x;})(4);), q(echo 4 ; $STDOUT = '4' ;),
	'func42',     q(function f() { $x=1; b(); $x++; }), q(function f ( ) { $x = 1 ; b ( ) ; $x = 2 ; }),
	'func43',     q(function f() { if (c()) { $x=1; b(); $x++; }), q(function f ( ) { if ( c ( ) ) { $x = 1 ; b ( ) ; $x = 2 ; } }),
	'i:func44',   q(function f() { b(); } $x=1; f(); $x++;), q(function f ( ) { b ( ) ; } $x = 1 ; b ( ) ; $x = 2 ;),
	'I:func44',   q(function f() { b(); } $x=1; f(); $x++;), q(function f ( ) { b ( ) ; } $x = 1 ; b ( ) ; $x ++ ;),
	'func45',     q(function f() { getcwd(); } $x=1; f(); $x++;), q(function f ( ) { getcwd ( ) ; } $x = 1 ; getcwd ( ) ; $x = 2 ;),
	'func46',     q(function f() { getcwd(); } b(); $x=1; f(); $x++;), q(function f ( ) { getcwd ( ) ; } b ( ) ; $x = 1 ; getcwd ( ) ; $x = 2 ;),
	'func47',     q(function e($x) { return $x; } function f($x) { foreach ($x as $y) { $GLOBALS['a']=1; e($GLOBALS['b']); b($GLOBALS['a']);}}), q(function e ( $x ) { return $x ; } function f ( $x ) { foreach ( $x as $y ) { $GLOBALS [ 'a' ] = 1 ; $GLOBALS [ 'b' ] ; b ( 1 ) ; } }),
	'func48',     q(function f($x) { return $x; } f('a','b');),  q(function f ( $x ) { return $x ; } 'a' ;),
	'func49',     q(function f($x,$y) { return $x; } f('a');),   q(function f ( $x , $y ) { return $x ; } f ( 'a' ) ;),
	'func50',     q(function f($x,$y=0) { return $x; } f('a');), q(function f ( $x , $y = 0 ) { return $x ; } 'a' ;),
	'func51',     q(function f($x) { return $x; } F('a');), q(function f ( $x ) { return $x ; } 'a' ;),
	'func52',     q(function f($x){return $x;}; F(2);), q(function f ( $x ) { return $x ; } 2 ;),
	'func53',     q(function F($x){return $x;}; f(2);), q(function F ( $x ) { return $x ; } 2 ;),
	'n:func54',   q(call_user_func('foo','x',$y)),    q(foo ( 'x' , null ) ;),
	'N:func54',   q(call_user_func('foo','x',$y)),    q(foo ( 'x' , $y ) ;),
	'n:func55',   q(if($x) call_user_func('foo',$y)), q(),
	'N:func55',   q(if($x) call_user_func('foo',$y)), q(if ( $x ) { foo ( $y ) ; }),
	'i:global1',  q(function f() { global $x; if (c()) { $x=1; b(); $x++; } ), q(function f ( ) { global $x ; if ( c ( ) ) { $x = 1 ; b ( ) ; $x = 2 ; } }),
	'I:global1',  q(function f() { global $x; if (c()) { $x=1; b(); $x++; } ), q(function f ( ) { global $x ; if ( c ( ) ) { $x = 1 ; b ( ) ; $x ++ ; } }),
	'global2',    q(function f() { global $x; $x.='2'; } $x='1'; f(); $x.='3';), q(function f ( ) { global $x ; $x = $x . '2' ; } $x = '1' ; $x = '12' ; $x = '123' ;),
	'global3',    q(function f() { global $x; $x.='2'; } if (c()) { $x='1'; f(); $x.='3'; }), q(function f ( ) { global $x ; $x = $x . '2' ; } if ( c ( ) ) { $x = '1' ; $x = '12' ; $x = '123' ; }),
	'static1',    q(function f() { static $x; return $x++; } f(); f();), q(function f ( ) { static $x ; return $x ++ ; } f ( ) ; f ( ) ; '1' ;),
	'static2',    q(function f() { static $x=null; if($x==null) { $x='a'; } else { echo $x; }} f(); f();), q(function f ( ) { static $x = null ; if ( $x == null ) { $x = 'a' ; } else { echo $x ; } } f ( ) ; echo 'a' ; $STDOUT = 'a' ;),
	'static3',    q(class c { static $x; static function f() { return c::$x++; }} c::f(); c::f();), q(class c { static $x ; static function f ( ) { return c :: $x ++ ; } } c :: f ( ) ; c :: f ( ) ; '1' ;),
	'static4',    q(class c { static $x; static function f() { return ++c::$x; }} c::f(); c::f();), q(class c { static $x ; static function f ( ) { return ++ c :: $x ; } } c :: f ( ) ; '1' ; c :: f ( ) ; '2' ;),
	'static5',    q(class c { static $x; static function f($i) { if (!c::$x) { c::a(); } return c::$x[$i]; } static function a() { c::$x=array('a'); }} c::f(0); c::f(0);),  q(class c { static $x ; static function f ( $i ) { if ( ! c :: $x ) { c :: a ( ) ; } return c :: $x [ $i ] ; } static function a ( ) { c :: $x = array ( 0 => 'a' ) ; } } c :: a ( ) ; 'a' ; 'a' ;),
	'static6',    q(class C { static $x; static function f($i) { if (!C::$x) { C::a(); } return C::$x[$i]; } static function a() { C::$x=array('a'); }} C::f(0); C::f(0);),  q(class C { static $x ; static function f ( $i ) { if ( ! C :: $x ) { C :: a ( ) ; } return C :: $x [ $i ] ; } static function a ( ) { C :: $x = array ( 0 => 'a' ) ; } } C :: a ( ) ; 'a' ; 'a' ;),
	'static7',    q(class c { static $x; static function f($i) { if (!c::$x) { c::a(); } return c::$x[$i]; } static function a() { c::$x=array('a'); }} function b() { echo c::f(0); echo c::f(0);} b(); b();),  q(class c { static $x ; static function f ( $i ) { if ( ! c :: $x ) { c :: a ( ) ; } return c :: $x [ $i ] ; } static function a ( ) { c :: $x = array ( 0 => 'a' ) ; } } function b ( ) { echo c :: f ( 0 ) ; echo c :: f ( 0 ) ; } c :: a ( ) ; echo 'a' ; echo 'a' ; echo 'a' ; echo 'a' ; $STDOUT = 'aaaa' ;),
	'ref1',       q($a='a'; $b=&$a; $b='b'; $a),      q($a = 'a' ; $b = & $a ; $b = 'b' ; 'b' ;),
	'ref2',       q($a='a'; function f(&$x){$x='b'};f($a);$a), q(function f ( & $x ) { $x = 'b' ; } $a = 'a' ; f ( $a ) ; 'b' ;),
	'ref3',       q($a[0]='a'; $b=&$a; $b[1]='b'; $a[0]; $a[1]), q($a [ 0 ] = 'a' ; $b = & $a ; $b [ 1 ] = 'b' ; 'a' ; 'b' ;),
	'ref4',       q($a[0]='a'; $b=&$a; $b[1]='b'; $a[0]='c'; $b[0]), q($a [ 0 ] = 'a' ; $b = & $a ; $b [ 1 ] = 'b' ; $a [ 0 ] = 'c' ; 'c' ;),
	'ref5',       q(global $a; $b=&$a; $b[1]='b'; $a[1]), q(global $a ; $b = & $a ; $a [ 1 ] = 'b' ; 'b' ;),
	'ref6',       q(function f($x) { $r=''; exec($x, $r); $r = join(' ', $r); return $r; } $y=f('cwd');), q(function f ( $x ) { $r = '' ; exec ( $x , $r ) ; $r = join ( ' ' , $r ) ; return $r ; } $y = ( function ( ) { $r = '' ; exec ( 'cwd' , $r ) ; return join ( ' ' , $r ) ; } ) ( ) ;),
	'n:nofunc',   q($x='foo';f(${$x}['bar'])),        q($x = 'foo' ; f ( null ) ;),
	'N:nofunc',   q($x='foo';f(${$x}['bar'])),        q($x = 'foo' ; f ( $foo [ 'bar' ] ) ;),
	'varscope',   q($x=1;function f(){$x=0};f();$x),  q(function f ( ) { $x = 0 ; } $x = 1 ; 1 ;),
	'varscope2',  q($x=1;function f(){$GLOBALS['x']=0};f();$x;),  q(function f ( ) { $GLOBALS [ 'x' ] = 0 ; } $x = 1 ; $x = 0 ; 0 ;),
	'varscope3',  q($x=1;function f(){global $x;$x=0};f();$x;),  q(function f ( ) { global $x ; $x = 0 ; } $x = 1 ; $x = 0 ; 0 ;),
	'varscope4',  q($x=1;f();function f(){$GLOBALS['x']=0};$x;),  q(function f ( ) { $GLOBALS [ 'x' ] = 0 ; } $x = 1 ; $x = 0 ; 0 ;),
	'varscope5',  q($y='x';$x=f(0);function f($x){${$GLOBALS['y']}=1;return $x;}),  q(function f ( $x ) { $ { $GLOBALS [ 'y' ] } = 1 ; return $x ; } $y = 'x' ; $x = 1 ;),
	'obj1',       q(a(); $x=$y->foo()),               q(a ( ) ; $x = $y -> foo ( ) ;),
	'obj2',       q($x=$y->foo()),                    q($x = $y -> foo ( ) ;),
	'n:obj3',     q($y=new a(); $x=$y->b($z);),       q($y = new a ( ) ; $x = $y -> b ( null ) ;),
	'N:obj3',     q($y=new a(); $x=$y->b($z);),       q($y = new a ( ) ; $x = $y -> b ( $z ) ;),
	'n:obj4',     q($y=new a(); $x=$y->b(${$GLOBALS['e']});), q($y = new a ( ) ; $x = $y -> b ( null ) ;),
	'N:obj4',     q($y=new a(); $x=$y->b(${$GLOBALS['e']});), q($y = new a ( ) ; $x = $y -> b ( $ { $e } ) ;),
	'obj5',       q(function f() { $y=new a(); $x=$y->b(${$GLOBALS['e']}); }), q(function f ( ) { $y = new a ( ) ; $x = $y -> b ( $ { $GLOBALS [ 'e' ] } ) ; }),
	'obj6',       q(class a { function b($x) { return $this->a;}}; function f() { $y=new a(); $x=$y->b($ { $GLOBALS ['e'] });}), q(class a { function b ( $x ) { return $this -> a ; } } function f ( ) { $y = new a ( ) ; $x = $y -> b ( $ { $GLOBALS [ 'e' ] } ) ; }),
	'obj7',       q(class a { function b() { $this->a['c']=1; }}), q(class a { function b ( ) { $this -> a [ 'c' ] = 1 ; } }),
	'obj8',       q(class a { function b() { $this->a['c']['d']=1; }}), q(class a { function b ( ) { $this -> a [ 'c' ] [ 'd' ] = 1 ; } }),
	'i:obj9',     q($x=1; $_SESSION['a']->b(); $x++;), q($x = 1 ; $_SESSION [ 'a' ] -> b ( ) ; $x = 2 ;),
	'I:obj9',     q($x=1; $_SESSION['a']->b(); $x++;), q($x = 1 ; $_SESSION [ 'a' ] -> b ( ) ; $x ++ ;),
	'obj10',      q($_SESSION['a']->b(); $x++;),      q($_SESSION [ 'a' ] -> b ( ) ; $x ++ ;),
	'obj11',      q(class a { function b($a) { $this->a=2; return $a; }} $x=(new a())->b(1);),  q(class a { function b ( $a ) { $this -> a = 2 ; return $a ; } } new a ( ) -> b ( 1 ) ; $x = 1 ;),
	'class1',     q($x=A::foo()),                     q($x = A :: foo ( ) ;),
	'class2',     q(class a { $x = 1; }),             q(class a { $x = 1 ; }),
	'class3',     q(class a { public function b() {return 'd'}} $x=new a(); $y=$x->b()), q(class a { public function b ( ) { return 'd' ; } } $x = new a ( ) ; $y = 'd' ;),
	'class4',     q($x=new a(); $y=$x->b(); class a { public function b() {return 'd'}}), q(class a { public function b ( ) { return 'd' ; } } $x = new a ( ) ; $y = 'd' ;),
	'class5',     q(class a { public function b() {return 'd'}} do { $x=new a(); $y=$x->b() } while(0)), q(class a { public function b ( ) { return 'd' ; } } $x = new a ( ) ; $y = 'd' ;),
	'class6',     q(class a { function b() { return 'd'; }} (new a)->b()), q(class a { function b ( ) { return 'd' ; } } 'd' ;),
	'class7',     q(class a { } $x = new a),          q(class a { } $x = new a ( ) ;),
	'class8',     q(class a { function b() { return 'd'; }} (new a())->b()), q(class a { function b ( ) { return 'd' ; } } 'd' ;),
	'class9',     q(class a { function b() { return 'd'; }} (new a())->{'b'}()), q(class a { function b ( ) { return 'd' ; } } 'd' ;),
	'class10',    q(class a { function __construct() { echo 'd'; }} $c=new a()), q(class a { function __construct ( ) { echo 'd' ; } } $__a___construct = function ( ) { echo 'd' ; } $c = new a ( ) ; $STDOUT = 'd' ;),
	'class11',    q(class a { function b($x) { return $x; } function c($x) { return $this->b($x) }} (new a())->c('d')), q(class a { function b ( $x ) { return $x ; } function c ( $x ) { return $this -> b ( $x ) ; } } 'd' ;),
	'class12',    q(class a { public $x = 'd' } (new a())->x; ), q(class a { public $x = 'd' ; } 'd' ;),
	'class13',    q(class a { public $v; } $x=new a; $x->v='d'; echo $x->v;), q(class a { public $v ; } $x = new a ( ) ; $x -> v = 'd' ; echo 'd' ; $STDOUT = 'd' ;),
	'class14',    q(class a { function __construct() { echo 'd'; }} new a()), q(class a { function __construct ( ) { echo 'd' ; } } $__a___construct = function ( ) { echo 'd' ; } new a ( ) ; $STDOUT = 'd' ;),
	'class15',    q(class a { public $x = 'd'; function b() { return $this->x; }} (new a())->b()), q(class a { public $x = 'd' ; function b ( ) { return $this -> x ; } } 'd' ;),
	'class16',    q(class a { public $x; function __construct() { $this->x = 'd'; }} (new a())->x;),  q(class a { public $x ; function __construct ( ) { $this -> x = 'd' ; } } $__a___construct = function ( ) { $this -> x = 'd' ; } 'd' ;),
	'class17',    q(class a { public $x; var $a = array('d'); function __construct() { $this->x = $this->a[0]; }} (new a())->x;),  q(class a { public $x ; var $a = array ( 0 => 'd' ) ; function __construct ( ) { $this -> x = $this -> a [ 0 ] ; } } $__a___construct = function ( ) { $this -> x = 'd' ; } 'd' ;),
	'class18',    q(function f($i) { $a=array('a','b'); return $a[$i]; } $db->obj(f(1));), q(function f ( $i ) { $a = array ( 0 => 'a' , 1 => 'b' ) ; return $a [ $i ] ; } $db -> obj ( 'b' ) ;),
	'class19',    q(function f($i) { $a=array('a','b'); return $a[$i]; } class c { function b() { if (x()) { switch ($x) {case f(1): $_POST [f(1)];}}}}), q(function f ( $i ) { $a = array ( 0 => 'a' , 1 => 'b' ) ; return $a [ $i ] ; } class c { function b ( ) { if ( x ( ) ) { switch ( $x ) { case 'b' : $_POST [ 'b' ] ; } } } }),
	'class20',    q(function f($i) { $a=array('a','b'); return $a[$i]; } function b() { class c { function d() { echo a(f(1)); }}}), q(function f ( $i ) { $a = array ( 0 => 'a' , 1 => 'b' ) ; return $a [ $i ] ; } function b ( ) { class c { function d ( ) { echo a ( 'b' ) ; } } }),
	'class21',    q(class a { function b($x) { return $x; }} $x='1'; new a(); $x.='3';), q(class a { function b ( $x ) { return $x ; } } $x = '1' ; new a ( ) ; $x = '13' ;),
	'class22',    q(class a { function a($x) { echo $x; }} $c=new a('d');), q(class a { function a ( $x ) { echo $x ; } } $__a___construct = function ( ) { echo 'd' ; } $c = new a ( 'd' ) ; $STDOUT = 'd' ;),
	'class23',    q(class a { $v=array('b'); function f() { echo $this->v[0]; }} (new a())->f();),  q(class a { $v = array ( 0 => 'b' ) ; function f ( ) { echo $this -> v [ 0 ] ; } } echo 'b' ; $STDOUT = 'b' ;),
	'class24',    q(class a { var $v; function f() { echo $this->v[0]; }} $c=new a(); $c->v[0]='b'; $c->f();),  q(class a { var $v ; function f ( ) { echo $this -> v [ 0 ] ; } } $c = new a ( ) ; $c -> v [ 0 ] = 'b' ; echo 'b' ; $STDOUT = 'b' ;),
	'class25',    q(class a { function f() { return 'b'; }} $x='a'; $c=new a(); $x=$x.$c->f();),  q(class a { function f ( ) { return 'b' ; } } $x = 'a' ; $c = new a ( ) ; $x = 'ab' ;),
	'class26',    q(class aB { function Cd() { return 'b'; }} (new aB())->Cd();),  q(class aB { function Cd ( ) { return 'b' ; } } 'b' ;),
	'class27',    q(class a { var $x=1; function x() { return 2; }} (new A())->x();),  q(class a { var $x = 1 ; function x ( ) { return 2 ; } } 2 ;),
	'n:class28',  q(class a { var $x=1; function x() { return 2; }} (new A())->X;),  q(class a { var $x = 1 ; function x ( ) { return 2 ; } }),
	'N:class28',  q(class a { var $x=1; function x() { return 2; }} (new A())->X;),  q(class a { var $x = 1 ; function x ( ) { return 2 ; } } new A ( ) -> X ;),
	'class29',    q(class a { var $x; } $c=new a(); if (isset($c) && b($c) && $c->x) { echo 1; }),  q(class a { var $x ; } $c = new a ( ) ; if ( isset ( $c ) && b ( $c ) && $c -> x ) { echo 1 ; }),
	'n:class30',  q(class a { public $x; } $c=new a(); if ($c->y) { echo 1; }),  q(class a { public $x ; } $c = new a ( ) ;),
	'N:class30',  q(class a { public $x; } $c=new a(); if ($c->y) { echo 1; }),  q(class a { public $x ; } $c = new a ( ) ; if ( $c -> y ) { echo 1 ; }),
	'class31',    q(class a { public $x=b($_GET[0]); } $c=new a(); if ($c->x) { echo 1; }),  q(class a { public $x = b ( $_GET [ 0 ] ) ; } $c = new a ( ) ; if ( $c -> x ) { echo 1 ; }),
	'class32',    q(class c { static $b; const b=1; static function b() {return 2;}}; c::b();),  q(class c { static $b ; const b = 1 ; static function b ( ) { return 2 ; } } 2 ;),
	'class33',    q(class c { var $b; } if (b()) { $x=new c; $x->b = $y; }),  q(class c { var $b ; } if ( b ( ) ) { $x = new c ( ) ; $x -> b = $y ; }),
	'class34',    q(class c { var $b; } if (b()) { $x=new c; $x->b[0][1] = $y; }),  q(class c { var $b ; } if ( b ( ) ) { $x = new c ( ) ; $x -> b [ 0 ] [ 1 ] = $y ; }),
	'class35',    q(class c { private $x='foo'; function f() { echo $x; }} $c=new c; $c->f();),  q(class c { private $x = 'foo' ; function f ( ) { echo $x ; } } $c = new c ( ) ; echo null ; $STDOUT = '' ;),
	'class36',    q(class A {} $a = new A(); $v="-"; $a->$v = '1'; echo $a->{"-"};),  q(class A { } $a = new A ( ) ; $v = '-' ; $a -> $v = '1' ; echo '1' ; $STDOUT = '1' ;),
	'class37',    q(class c { const a = 1; } echo c::a;),  q(class c { const a = 1 ; } echo 1 ; $STDOUT = '1' ;),
	'class38',    q(class c { public const a = 1; } echo c::a;),  q(class c { public const a = 1 ; } echo 1 ; $STDOUT = '1' ;),
	'class39',    q(class c { function t () { } }; $x=new c($_GET[0]); $x->t($_GET[1]);),  q(class c { function t ( ) { } } $x = new c ( $_GET [ 0 ] ) ; $x -> t ( $_GET [ 1 ] ) ;),
	'trait1',     q(trait t { public function f() {return 'a'}}), q(trait t { public function f ( ) { return 'a' ; } }),
	'scope1',     q(class a { public static function f($x) { echo $x; }} a::f('d');),  q(class a { public static function f ( $x ) { echo $x ; } } echo 'd' ; $STDOUT = 'd' ;),
	'scope2',     q(class a { static $v='2'; public static function f($x) { echo self::$v; }} a::f('d');),  q(class a { static $v = '2' ; public static function f ( $x ) { echo a :: $v ; } } echo '2' ; $STDOUT = '2' ;),
	'scope3',     q(class a { static $v=array('b'); public static function f() { echo self::$v[0]; }} a::f();),  q(class a { static $v = array ( 0 => 'b' ) ; public static function f ( ) { echo a :: $v [ 0 ] ; } } echo 'b' ; $STDOUT = 'b' ;),
	'scope4',     q(class a { static $v; public static function f() { echo self::$v; }} a::$v='b'; a::f();),  q(class a { static $v ; public static function f ( ) { echo a :: $v ; } } a :: $v = 'b' ; echo 'b' ; $STDOUT = 'b' ;),
	'scope5',     q(class a { public static function f($x) { echo __METHOD__; }} a::f('d');),  q(class a { public static function f ( $x ) { echo 'a::f' ; } } echo 'a::f' ; $STDOUT = 'a::f' ;),
	'scope6',     q(class a { public static function f() { echo __METHOD__; }} $c=new a; $c->f();),  q(class a { public static function f ( ) { echo 'a::f' ; } } $c = new a ( ) ; echo 'a::f' ; $STDOUT = 'a::f' ;),
	'namespace1', q(namespace a\b; echo __NAMESPACE__;),  q(namespace a\b ; echo 'a\\\\b' ; $STDOUT = 'a\\\\b' ;),
	'namespace2', q(const A=1; echo \A;),             q(const A = 1 ; echo 1 ; $STDOUT = '1' ;),
	'namespace3', q(namespace N; const A=1; echo \N\A;),  q(namespace N ; const A = 1 ; echo 1 ; $STDOUT = '1' ;),
	'namespace4', q(function a() { echo __FUNCTION__; } \a();),  q(function a ( ) { echo 'a' ; } echo 'a' ; $STDOUT = 'a' ;),
	'namespace5', q(namespace N; function a() { echo __FUNCTION__; } a();),  q(namespace N ; function a ( ) { echo __FUNCTION__ ; } echo 'N\\\\a' ; $STDOUT = 'N\\\\a' ;),
	'namespace6', q(namespace N; const A=1; namespace M; const A=2; echo \N\A, A, \M\A;),  q(namespace N ; const A = 1 ; namespace M ; const A = 2 ; echo '1' , A , '2' ; $STDOUT = '122' ;),
	'namespace7', q(namespace N { class c { const A=1; }} namespace { echo \N\c::A; }),  q(namespace N { class c { const A = 1 ; } } namespace { echo 1 ; } $STDOUT = '1' ;),
	'namespace8', q(namespace N; $x=range(1,1);),     q(namespace N ; $x = array ( 0 => '1' ) ;),
	'namespace9', q(namespace N; function range () { return 'a'; }; $x=range(1,1);),  q(namespace N ; function range ( ) { return 'a' ; } $x = 'a' ;),
	'namespace10',q(namespace N; function range () { return 'a'; }; $x=\range(1,1);),  q(namespace N ; function range ( ) { return 'a' ; } $x = array ( 0 => '1' ) ;),
	'switch',     q(switch(2){case 2: $x=1;} $x),     q($x = 1 ; 1 ;),
	'switch2',    q(switch(a()){case 2: $x=1;}),      q(switch ( a ( ) ) { case 2 : $x = 1 ; }),
	'switch3',    q($x=0; switch (a()) {case 2: $x=1; case 3: $y=$x+1;}),  q($x = 0 ; switch ( a ( ) ) { case 2 : $x = 1 ; case 3 : $y = $x + 1 ; }),
	'switch4',    q(function f($y) {$x=0; switch ($y) {case 2: $x=1; case 3: $y=$x+1;}}),  q(function f ( $y ) { $x = 0 ; switch ( $y ) { case 2 : $x = 1 ; case 3 : $y = $x + 1 ; } }),
	'switch5',    q(switch(2){case 1: case 2: $x=1; case 3: $x++;} $x), q($x = 2 ; 2 ;),
	'switch6',    q(switch(2){case 1: case 2: $x=1; break; case 3: $x++;} $x), q($x = 1 ; 1 ;),
	'switch7',    q(switch(a()){case a: $x=1;}),      q(switch ( a ( ) ) { case a : $x = 1 ; }),
	'escape1',    q($y='a'; $x=a(); if($x){$y=$x}; $z=$y),q($y = 'a' ; $x = a ( ) ; if ( $x ) { $y = $x ; } $z = $y ;),
	'n:escape2',  q($y='a'; $x=base64_decode($p); if($x){$y=$x}; $z=$y),q($y = 'a' ; $x = '' ; $z = 'a' ;),
	'N:escape2',  q($y='a'; $x=base64_decode($p); if($x){$y=$x}; $z=$y),q($y = 'a' ; $x = base64_decode ( $p ) ; if ( $x ) { $y = $x ; } $z = $y ;),
	'try',        q(try { echo 'a'; } catch (Exception $e) { echo 'b'; } finally { echo 'c'; }), q(try { echo 'a' ; } catch ( Exception $e ) { echo 'b' ; } finally { echo 'c' ; }),
	'goto',       q(goto a; a: echo 'x';),            q(goto a ; a : echo 'x' ; $STDOUT = 'x' ;),
	'strcmp',     q($x=strcmp('aa','aa')),            q($x = 0 ;),
	'strncasecmp',q($x=strncasecmp('aAb','aAc',2)),   q($x = 0 ;),
	'preg1',      q($x=preg_replace("/([a-z])/", ":\\\\1:", 'abc')),  q($x = ':a::b::c:' ;),
	'preg2',      q($x=preg_replace("/([0-9A-Fa-f]{2})/e", "''.chr(hexdec('\\\\1')).''", '4142')),  q($x = 'AB' ;),
	'n:preg3',    q(a(); $x=preg_replace("/b/e", 'eval($x)', 'abc')),  q(a ( ) ; $x = 'ac' ;),
	'N:preg3',    q(a(); $x=preg_replace("/b/e", 'eval($x)', 'abc')),  q(a ( ) ; $x = 'a' . eval ( $x ) . 'c' ;),
	'preg4',      q(preg_replace('/a/', 'b', array('abc', 'aaa'))), q(array ( 0 => 'bbc' , 1 => 'bbb' ) ;),
	'preg5',      q(str_replace('a', 'b', array('abc', 'aaa'))), q(array ( 0 => 'bbc' , 1 => 'bbb' ) ;),
	'n:preg6',    q(a(); $x=preg_replace("{[b]}e", 'eval($x)', 'abc')),  q(a ( ) ; $x = 'ac' ;),
	'N:preg6',    q(a(); $x=preg_replace("{[b]}e", 'eval($x)', 'abc')),  q(a ( ) ; $x = 'a' . eval ( $x ) . 'c' ;),
	'preg7',      q($x=preg_replace("/(.*)/", 'abc', null)),  q($x = 'abc' ;),
	'preg8',      q($x=str_replace(array('a'),array('b'),'ab')),  q($x = 'bb' ;),
	'preg9',      q($x=str_repeat('x', 4)),           q($x = 'xxxx' ;),
	'preg10',     q($x=str_replace('O','\15','O6')),  q($x = '\\\\156' ;),
	'preg11',     q($x=eval(str_replace('O','\15','echo "O6";'))),  q(echo 'n' ; $x = null ; $STDOUT = 'n' ;),
	'preg12',     q($x=preg_split("/[\s,]+/", "aa bb, cc");),  q($x = array ( 0 => 'aa' , 1 => 'bb' , 2 => 'cc' ) ;),
	'preg13',     q(preg_replace('@(.+)@ie', 'eval("\\1");', '@eval(base64_decode("JHggPSAnYSc="));'); echo $x;), q($x = 'a' ; echo 'a' ; $STDOUT = 'a' ;),
	'pack1',      q($x=pack("nc*", 0x5678, 65, 66)),  q($x = 'VxAB' ;),
	'pack2',      q($x=pack("H*", '787a')),           q($x = 'xz' ;),
	'pack3',      q($x=unpack("c2", "\x32\x42")),     q($x = array ( 0 => '50' , 1 => '66' ) ;),
	'sprintf',    q($x=sprintf("x%d%c", 100, 65)),   q($x = 'x100A' ;),
	'def1',       q(define('DS','/'); x('a'.DS.b)),   q(define ( 'DS' , '/' ) ; x ( 'a/b' ) ;),
	'def2',       q(define('A','x'); define('A','y')),q(define ( 'A' , 'x' ) ; define ( 'A' , 'y' ) ;),
	'count',      q($a=array('1','2','3');count($a)), q($a = array ( 0 => '1' , 1 => '2' , 2 => '3' ) ; 3 ;),
	'cf1',        q($x=create_function('$y', 'return $y'); $x('a')), q($x = function ( $y ) { return $y ; } 'a' ;),
	'cf2',        q($x=create_function('$y', '$z = create_function(\'$a\', \'return $a\')')), q($x = function ( $y ) { $z = function ( $a ) { return $a ; } }),
	'cf3',        q($a='$z = create_function(\'$y\', $a)'; $x = create_function('$z', $a)), q($a = '$z = create_function(\'$y\', $a)' ; $x = function ( $z ) { $z = create_function ( '$y' , $a ) ; }),
	'cf4',        q($x=create_function('', 'return 1; } echo 2; //'); $x()), q($x = function ( ) { return 1 ; } echo 2 ; 1 ; $STDOUT = '2' ;),
	'cf5',        q(create_function('', '}; echo 2; //')), q(function ( ) { } echo 2 ; $STDOUT = '2' ;),
	'cf6',        q(create_function('', '}; function b() { return 1 } //')), q(function ( ) { } function b ( ) { return 1 ; }),
	'cf7',        q(function a() { create_function('', '}; function b() { return 1 } //')} a()), q(function a ( ) { function ( ) { } function b ( ) { return 1 ; } } function ( ) { } function b ( ) { return 1 ; }),
	'cf8',        q(function a($x) { create_function('', '}; function '.$x.'() { return 1 } //')} a('b')), q(function a ( $x ) { create_function ( '' , '}; function ' . $x . '() { return 1 } //' ) ; } function ( ) { } function b ( ) { return 1 ; }),
	'pfx1',       q($x=new a(); $y=$x),               q($x = new a ( ) ; $y = $x ;),
	'amap1',      q(function f($x){return chr(ord($x)+1)} $y=array_map('f',array('a'))), q(function f ( $x ) { return chr ( ord ( $x ) + 1 ) ; } $y = array ( 0 => 'b' ) ;),
	'for',        q(for($x=1; $x<3; $x+=1) { $y=$x }),   q($y = 2 ; $x = 3 ;),
	'for2',       q(for($a=1, $x=1; $x<3; $x+=1) { $y=$x }),   q($a = 1 ; $y = 2 ; $x = 3 ;),
	'for3',       q(for($a='ab', $x=0; ord($a[$x]); $x++) { $y=$x }),   q($a = 'ab' ; $y = 1 ; $x = 2 ;),
	'for4-unres', q(a(); $y='';for($x=1; $x<4; $x+=1) {$y.=$tag}), q(a ( ) ; $y = '' ; for ( $x = 1 ; $x < 4 ; $x = $x + 1 ) { $y = $y . $tag ; }),
	'for5',       q(for($i=0;$i<2;++$i) { $d['i']=$i; $g[] = array('i'=>$i) }), q($d = array ( 'i' => 1 ) ; $g = array ( 0 => array ( 'i' => 0 ) , 1 => array ( 'i' => 1 ) ) ; $i = 2 ;), 
	'for6',       q(for($i=0;$i<2;++$i) { $a[]="$i"; } $a), q($a = array ( 0 => '0' , 1 => '1' ) ; $i = 2 ; array ( 0 => '0' , 1 => '1' ) ;), 
	'for7',       q($x='';for($i=1,$v=64; $i < 3; $i++) { $x=$x.chr($v+$i);}; $x), q($x = '' ; $v = 64 ; $x = 'AB' ; $i = 3 ; 'AB' ;),
	'for8',       q(for($a='ab', $x=0; ord($a[$x++]); ) { $y=$x }), q($a = 'ab' ; $y = 2 ; $x = 3 ;),
	'for9',       q(for($i=0; $i<2; $i++) { if ($i == 1) { echo 'a'; }}), q(echo 'a' ; $i = 2 ; $STDOUT = 'a' ;),
	'for10',      q(for(;$x=foo();) {$y += 1}),       q(for ( ; $x = foo ( ) ; ) { $y = $y + 1 ; }),
	'for11',      q(for(;$x=f();) {$y += 1;} function f() { echo 'a'; }), q(function f ( ) { echo 'a' ; } echo 'a' ; $x = null ; $STDOUT = 'a' ;),
	'for12',      q(for(;$x=f();) {} function f() { echo 'a'; b(); }), q(function f ( ) { echo 'a' ; b ( ) ; } echo 'a' ; b ( ) ; $x = null ; $STDOUT = 'a' ;),
	'n:for13',    q(for(;$x==f();) {$x += 1;} function f() { echo 'a'; }), q(function f ( ) { echo 'a' ; } $x = 1 ; echo 'aa' ; $STDOUT = 'aa' ;),
	'N:for13',    q(for(;$x==f();) {$x += 1;} function f() { echo 'a'; }), q(function f ( ) { echo 'a' ; } for ( ; $x == f ( ) ; ) { $x = $x + 1 ; } $STDOUT = 'a' ;),
	'for-while',  q($x=1; while($x<=3) $x++; $x),     q($x = 1 ; $x = 4 ; 4 ;),
	'for-while2', q($x=1; while(1) { f(); $x++ } $x), q($x = 1 ; while ( 1 ) { f ( ) ; $x ++ ; } $x ;),
	'for-while3', q($x=1; while(1) { if ($x > 2) break; $x++ } $x), q($x = 1 ; $x = 3 ; 3 ;),
	'for-while4', q(while($x=foo()) {$y += 1}),       q(while ( $x = foo ( ) ) { $y = $y + 1 ; }),
	'for-while5', q($x=1; $y=0; if ($x) while($x=DB::foo()) {$y += $x}),  q($x = 1 ; $y = 0 ; while ( $x = DB :: foo ( ) ) { $y = $y + $x ; }),
	'for-while6', q($x=2; while(--$x) { f() } $x),    q($x = 2 ; while ( -- $x ) { f ( ) ; } $x ;),
	'for-while7', q($x=3; while(--$x) { $a[]=$x }),   q($x = 3 ; $a = array ( 0 => 2 , 1 => 1 ) ; $x = 0 ;),
	'for-while8', q($x=3; do { $a[]=$x } while(--$x)),q($x = 3 ; $a = array ( 0 => 3 , 1 => 2 , 2 => 1 ) ; $x = 0 ;),
	'for-while9', q(while($x=foo()) {$y += 1}),       q(while ( $x = foo ( ) ) { $y = $y + 1 ; }),
	'for-while10',q(while(false !== ($x=foo())) {$y += 1}), q(while ( 0 !== ( $x = foo ( ) ) ) { $y = $y + 1 ; }),
	'do-while',   q($x=1; do { $x++ } while($x<=3); $x;),  q($x = 1 ; $x = 4 ; 4 ;),
	'do-while2',  q($x=1; do { $x++ } while(0); $x;),  q($x = 1 ; $x = 2 ; 2 ;),
	'do-while3',  q(do { a() } while(0);),            q(a ( ) ;),
	'do-while4',  q(do { echo 'a'; } while(f());),    q(do { echo 'a' ; } while ( f ( ) ) ; $STDOUT = 'a' ;),
	'foreach',    q(foreach(array('a','b') as $x) $x;), q('a' ; 'b' ;),
	'foreach2',   q($v='x'; foreach(array('a','b') as $k => ${$v}) { $x }), q($v = 'x' ; 'a' ; 'b' ;),
	'foreach3',   q($x=$_POST; foreach($GLOBALS['x'] as $k => $v) { f() }), q($x = $_POST ; foreach ( $x as $k => $v ) { f ( ) ; }),
	'foreach4',   q($a=array('a','b'); foreach($a as $x) { y($x) }), q($a = array ( 0 => 'a' , 1 => 'b' ) ; foreach ( array ( 0 => 'a' , 1 => 'b' ) as $x ) { y ( $x ) ; }),
	'foreach5',   q($v='x'; foreach ($_POST as $key => $value) { ${$GLOBALS['v']} = $a }), q($v = 'x' ; foreach ( $_POST as $key => $value ) { $ { $v } = $a ; }),
	'foreach6',   q($x=$GLOBALS; foreach($x as $k => $v) { f(); }), q($x = $GLOBALS ; foreach ( $GLOBALS as $k => $v ) { f ( ) ; }),
	'foreach7',   q(foreach ($_POST as $v) { if(!isset($x)) { $x = $v; }}), q(foreach ( $_POST as $v ) { if ( ! isset ( $x ) ) { $x = $v ; } }), 
	'foreach8',   q(foreach ($_POST as $k => $v) { ${$x = $v}; }), q(foreach ( $_POST as $k => $v ) { $x = $v ; $ { $x } }),
	'foreach9',   q($a=array('a','b'); foreach($a as $k => $v) { $a[$k]='x'; } $a;), q($a = array ( 0 => 'a' , 1 => 'b' ) ; $a = array ( 0 => 'x' , 1 => 'x' ) ; array ( 0 => 'x' , 1 => 'x' ) ;),
	'foreach10',  q($a=array('a','b'); foreach($a as $k => $v) { $a[$k]='x'; echo $v; } $a;), q($a = array ( 0 => 'a' , 1 => 'b' ) ; $a = array ( 0 => 'x' , 1 => 'x' ) ; echo 'ab' ; array ( 0 => 'x' , 1 => 'x' ) ; $STDOUT = 'ab' ;),
	'foreach11',  q($a=array('a','b'); foreach($a as $k => $v) { $a[$k]='x'; echo $v; } $a;), q($a = array ( 0 => 'a' , 1 => 'b' ) ; $a = array ( 0 => 'x' , 1 => 'x' ) ; echo 'ab' ; array ( 0 => 'x' , 1 => 'x' ) ; $STDOUT = 'ab' ;),
	'foreach12',  q(foreach (array("a", "b") as $x) { echo $x; } echo $x;), q(echo 'ab' ; echo 'b' ; $STDOUT = 'abb' ;),
	'foreach13',  q($a=array("a","k","v"); foreach (${$a[0]} as ${$a[1]} => ${$a[2]}) { echo "($k:$v)"; }), q($a = array ( 0 => 'a' , 1 => 'k' , 2 => 'v' ) ; echo '(0:a)(1:k)(2:v)' ; $STDOUT = '(0:a)(1:k)(2:v)' ;),
	'foreach14',  q($a=array("a","k","v"); foreach (${$a[0]} as ${$a[1]} => ${$a[2]}) { $a[0]="x"; echo "($k:$v)"; }), q($a = array ( 0 => 'a' , 1 => 'k' , 2 => 'v' ) ; $a = array ( 0 => 'x' , 1 => 'k' , 2 => 'v' ) ; echo '(0:a)(1:k)(2:v)' ; $STDOUT = '(0:a)(1:k)(2:v)' ;),
	'foreach15',  q($a=array("a","k","v"); foreach (${$a[0]} as ${$a[1]} => ${$a[2]}) { $a[0]=$a[1]=$a[2]="x"; echo "($k:$v)"; }), q($a = array ( 0 => 'a' , 1 => 'k' , 2 => 'v' ) ; $a = array ( 0 => 'x' , 1 => 'x' , 2 => 'x' ) ; echo '(0:a)(0:a)(0:a)' ; $STDOUT = '(0:a)(0:a)(0:a)' ;),
	'n:foreach16',q(function f() { foreach ($_POST as $k => $v) { $GLOBALS['a'][0] = '3' }} f(); $a; $b), q(function f ( ) { foreach ( $_POST as $k => $v ) { $GLOBALS [ 'a' ] [ 0 ] = '3' ; } } ( function ( ) { foreach ( $_POST as $k => $v ) { $GLOBALS [ 'a' ] [ 0 ] = '3' ; } } ) ( ) ; $a ;),
	'N:foreach16',q(function f() { foreach ($_POST as $k => $v) { $GLOBALS['a'][0] = '3' }} f(); $a; $b), q(function f ( ) { foreach ( $_POST as $k => $v ) { $GLOBALS [ 'a' ] [ 0 ] = '3' ; } } ( function ( ) { foreach ( $_POST as $k => $v ) { $GLOBALS [ 'a' ] [ 0 ] = '3' ; } } ) ( ) ; $a ; $b ;),
	'fcall1',     q(function_exists('md5')),          q(1 ;),
	'fcall2',     q(if(!function_exists('a')){$x=1}), q($x = 1 ;),
	'fcall3',     q(if(function_exists('md5') and f()){$x=1}), q(if ( 1 and f ( ) ) { $x = 1 ; }),
	'fcall4',     q(function a() { } function_exists('a')), q(function a ( ) { } 1 ;),
	'fcall5',     q(if (!function_exists('a')) { function a() { echo 'x' }}), q(function a ( ) { echo 'x' ; }),
	'fcall6',     q(eval("if (!function_exists('a')) { function a() { echo 'x' }}")), q(function a ( ) { echo 'x' ; }),
	'fcall7',     q(if (b()) { eval("if (!function_exists('a')) { function a() { echo 'x' }}") }), q(if ( b ( ) ) { function a ( ) { echo 'x' ; } }),
	'fcall8',     q(if (!function_exists('a')) { eval("function a() { echo 'x' }") }), q(function a ( ) { echo 'x' ; }),
	'fcall9',     q(function f($s) { $k=10; if($s < $k) { return $s.'b'; }), q(function f ( $s ) { $k = 10 ; if ( $s < 10 ) { return $s . 'b' ; } }),
	'fcall10',    q(eval("function f(){ return 1;}"); f();),  q(function f ( ) { return 1 ; } 1 ;),
	'fcall11',    q($x=1; do { f(); } while(1 > 2); function f(){ global $x; $x++;}; $x;),  q(function f ( ) { global $x ; $x ++ ; } $x = 1 ; $x = 2 ; 2 ;),
	'fcall12',    q(function f($i) { $a=array('a','b'); return $a[$i]; } $x=a().f(1)), q(function f ( $i ) { $a = array ( 0 => 'a' , 1 => 'b' ) ; return $a [ $i ] ; } $x = a ( ) . 'b' ;),
	'fcall13',    q(function f($i) { $a=array('a','b'); return $a[$i]; } function b() { return a().f(1); }), q(function f ( $i ) { $a = array ( 0 => 'a' , 1 => 'b' ) ; return $a [ $i ] ; } function b ( ) { return a ( ) . 'b' ; }),
	'fcall14',    q(function f($i) { $a=array('a','b'); return $a[$i]; } function b() { echo a(f(1)); }), q(function f ( $i ) { $a = array ( 0 => 'a' , 1 => 'b' ) ; return $a [ $i ] ; } function b ( ) { echo a ( 'b' ) ; }),
	'fcall15',    q(function f($i) { $a=array('a','b'); return $a[$i]; } $GLOBALS[f(1)] = 'd';), q(function f ( $i ) { $a = array ( 0 => 'a' , 1 => 'b' ) ; return $a [ $i ] ; } $b = 'd' ;),
	'fcall16',    q(function f($i) { $a=array('a','b'); return $a[$i]; } $_POST[f(1)] = 'd';), q(function f ( $i ) { $a = array ( 0 => 'a' , 1 => 'b' ) ; return $a [ $i ] ; } $_POST [ 'b' ] = 'd' ;),
	'fcall17',    q(function f($i) { $a=array('a','b'); return $a[$i]; } function b() { $m[f(1)] = 'd'; }), q(function f ( $i ) { $a = array ( 0 => 'a' , 1 => 'b' ) ; return $a [ $i ] ; } function b ( ) { $m [ 'b' ] = 'd' ; }),
	'fcall18',    q(function f($i) { $a=array('a','b'); return $a[$i]; } switch (a()) {case f(1): $_POST [f(1)];}), q(function f ( $i ) { $a = array ( 0 => 'a' , 1 => 'b' ) ; return $a [ $i ] ; } switch ( a ( ) ) { case 'b' : $_POST [ 'b' ] ; }),
	'fcall19',    q(function f($i) { $a=array('a','b'); return $a[$i]; } function b() { $m[f(1)] = 'd'; }), q(function f ( $i ) { $a = array ( 0 => 'a' , 1 => 'b' ) ; return $a [ $i ] ; } function b ( ) { $m [ 'b' ] = 'd' ; }),
	'fcall20',    q(function f($i) { $a=array('a','b'); return $a[$i]; } a(); $m[f(1)] = $m[f(0)];), q(function f ( $i ) { $a = array ( 0 => 'a' , 1 => 'b' ) ; return $a [ $i ] ; } a ( ) ; $m [ 'b' ] = $m [ 'a' ] ;),
	'fcall21',    q(function f($i) { $a=array('a','b'); return $a[$i]; } $m = array(0 => f(1));), q(function f ( $i ) { $a = array ( 0 => 'a' , 1 => 'b' ) ; return $a [ $i ] ; } $m = array ( 0 => 'b' ) ;),
	'fcall22',    q(function f($i) { $a=array('a','b'); return $a[$i]; } function b() { $m = array(0 => f(1)); }), q(function f ( $i ) { $a = array ( 0 => 'a' , 1 => 'b' ) ; return $a [ $i ] ; } function b ( ) { $m = array ( 0 => 'b' ) ; }),
	'fcall23',    q(function f($i) { $a=array('a','b'); return $a[$i]; } if (a(b(),f(1))) { $d = $d . f(0); }), q(function f ( $i ) { $a = array ( 0 => 'a' , 1 => 'b' ) ; return $a [ $i ] ; } if ( a ( b ( ) , 'b' ) ) { $d = $d . 'a' ; }),
	'fcall24',    q(function f($i) { $a=array('a','b'); return $a[$i]; } foreach(range(f(0),f(1)) as $d) { if (a($d,f(1))) { $d = $d . f(0); }}), q(function f ( $i ) { $a = array ( 0 => 'a' , 1 => 'b' ) ; return $a [ $i ] ; } foreach ( array ( 0 => 'a' , 1 => 'b' ) as $d ) { if ( a ( $d , 'b' ) ) { $d = $d . 'a' ; } }),
	'fcall25',    q(function f($i) { $a=array('a','b'); return $a[$i]; } if (a(b(),f(1))) { echo $_POST[f(0)]; }), q(function f ( $i ) { $a = array ( 0 => 'a' , 1 => 'b' ) ; return $a [ $i ] ; } if ( a ( b ( ) , 'b' ) ) { echo $_POST [ 'a' ] ; }),
	'fcall26',    q(function f($i) { $a=array('a','b'); return $a[$i]; } if (a(b(),f(1))) { if (b(f(1))) { echo $_POST[f(0)]; }}), q(function f ( $i ) { $a = array ( 0 => 'a' , 1 => 'b' ) ; return $a [ $i ] ; } if ( a ( b ( ) , 'b' ) ) { if ( b ( 'b' ) ) { echo $_POST [ 'a' ] ; } }),
	'fcall27',    q(function f($i) { $a=array('a','b'); return $a[$i]; } if (a(b(),f(1))) { if (b(f(1))) { d(); echo $_POST[f(0)]; }}), q(function f ( $i ) { $a = array ( 0 => 'a' , 1 => 'b' ) ; return $a [ $i ] ; } if ( a ( b ( ) , 'b' ) ) { if ( b ( 'b' ) ) { d ( ) ; echo $_POST [ 'a' ] ; } }),
	'fcall28',    q(function f($i) { $a=array('a','b'); return $a[$i]; } function d() { if (a($d,f(1))) { if (b(f(1))) { echo $_POST[f(0)]; }}}), q(function f ( $i ) { $a = array ( 0 => 'a' , 1 => 'b' ) ; return $a [ $i ] ; } function d ( ) { if ( a ( $d , 'b' ) ) { if ( b ( 'b' ) ) { echo $_POST [ 'a' ] ; } } }),
	'fcall29',    q(function f($i) { $a=array('a','b'); return $a[$i]; } echo $_POST[f(0)]($_POST[f(1)])), q(function f ( $i ) { $a = array ( 0 => 'a' , 1 => 'b' ) ; return $a [ $i ] ; } echo $_POST [ 'a' ] ( $_POST [ 'b' ] ) ; $STDOUT = $_POST [ 'a' ] ( $_POST [ 'b' ] ) ;),
	'fcall30',    q(function f($i) { $a=array('a','b'); return $a[$i]; } echo $_POST[f(0)][f(1)]), q(function f ( $i ) { $a = array ( 0 => 'a' , 1 => 'b' ) ; return $a [ $i ] ; } echo $_POST [ 'a' ] [ 'b' ] ; $STDOUT = $_POST [ 'a' ] [ 'b' ] ;),
	'fcall31',    q(if(a()) {function f() {return 1;} $x=f();}),      q(if ( a ( ) ) { function f ( ) { return 1 ; } $x = 1 ; }),
	'fcall32',    q(function c() { function f() {return "x";} if (a()) { $x=f(); if ($_POST[$x."y"]) { echo "d"; }}}), q(function c ( ) { function f ( ) { return 'x' ; } if ( a ( ) ) { $x = 'x' ; if ( $_POST [ 'xy' ] ) { echo 'd' ; } } }),
	'fcall33',    q(function a($x) { return 'w'; } function c($f,$t) { ($w = fopen($f, a(1))) or 1; if ($w) { fwrite($w, base64_decode($t)); fclose($w);}} c('f','Zm9v')), q(function a ( $x ) { return 'w' ; } function c ( $f , $t ) { $w = fopen ( $f , 'w' ) ; $w or 1 ; if ( $w ) { fwrite ( $w , base64_decode ( $t ) ) ; fclose ( $w ) ; } } ( function ( ) { $w = fopen ( 'f' , 'w' ) ; $w or 1 ; if ( $w ) { fwrite ( $w , 'foo' ) ; fclose ( $w ) ; } } ) ( ) ;),
	'fcall34',    q(function f() { if (b()) { $a=array('c'); echo d($a); }), q(function f ( ) { if ( b ( ) ) { $a = array ( 0 => 'c' ) ; echo d ( array ( 0 => 'c' ) ) ; } }),
	'fcall35',    q(function f() { if (b()) { $a=array(0=>c()); echo d($a); }), q(function f ( ) { if ( b ( ) ) { $a = array ( 0 => c ( ) ) ; echo d ( $a ) ; } }),
	'fcall36',  q(function f() { if ($GLOBALS['c']) { echo 'a'; } else { echo 'b'; }} f();), q(function f ( ) { if ( $GLOBALS [ 'c' ] ) { echo 'a' ; } else { echo 'b' ; } } echo 'b' ; $STDOUT = 'b' ;),
	'fcall37',  q(function f($x) { if ($GLOBALS['c']) { echo $x.'+'; } else { $GLOBALS['a']=$GLOBALS['a'].$x.'_';}} $a=''; f('d'); f('e'); $a;), q(function f ( $x ) { if ( $GLOBALS [ 'c' ] ) { echo $x . '+' ; } else { $GLOBALS [ 'a' ] = $GLOBALS [ 'a' ] . $x . '_' ; } } $a = '' ; $a = 'd_' ; $a = 'd_e_' ; 'd_e_' ;),
	'fcall38',  q(function f($x) { if ($GLOBALS['c']) { echo $x.'+'; } else { $GLOBALS['a']=$GLOBALS['a'].$x.'_';}} $a=''; f('d'); $c=1; f('e'); f('f'); $a;), q(function f ( $x ) { if ( $GLOBALS [ 'c' ] ) { echo $x . '+' ; } else { $GLOBALS [ 'a' ] = $GLOBALS [ 'a' ] . $x . '_' ; } } $a = '' ; $a = 'd_' ; $c = 1 ; echo 'e+' ; echo 'f+' ; 'd_' ; $STDOUT = 'e+f+' ;),
	'fcall39',    q(function f($i) { $a=array('a'); return $a[$i]; } function g() { class c { var $a; function c($a) { $this->a=$a; }} $x = new c($_POST[f(0)]);}), q(function f ( $i ) { $a = array ( 0 => 'a' ) ; return $a [ $i ] ; } function g ( ) { class c { var $a ; function c ( $a ) { $this -> a = $a ; } } $__c___construct = function ( ) { $this -> a = $_POST [ 'a' ] ; } $x = new c ( $_POST [ 'a' ] ) ; }),
	'fcall40',    q(function f($x) { return a($x); } f($_POST['a']);), q(function f ( $x ) { return a ( $x ) ; } a ( $_POST [ 'a' ] ) ;),
	'fcall41',    q(function f($x) { return a($x); } f(b());), q(function f ( $x ) { return a ( $x ) ; } a ( b ( ) ) ;),
	'fcall42',    q($v='1'; function f($x) { $c=$GLOBALS['v']; return a($c,$x); } function g() { if(b(f(3))) { $r=f(7); }), q(function f ( $x ) { $c = $GLOBALS [ 'v' ] ; return a ( $GLOBALS [ 'v' ] , $x ) ; } function g ( ) { if ( b ( a ( $GLOBALS [ 'v' ] , 3 ) ) ) { $r = a ( $GLOBALS [ 'v' ] , 7 ) ; } } $v = '1' ;),
	'fcall43',    q(function f() { $x=1; echo 'a'; } f();), q(function f ( ) { $x = 1 ; echo 'a' ; } echo 'a' ; $STDOUT = 'a' ;),
	'fcall44',    q(function f() { $x=z(); echo 'a'; } f();), q(function f ( ) { $x = z ( ) ; echo 'a' ; } z ( ) ; echo 'a' ; $STDOUT = 'a' ;),
	'fcall45',    q(function f($x) { $a[0][0]='a'; echo $a[$x][$x]; } f(0);), q(function f ( $x ) { $a [ 0 ] [ 0 ] = 'a' ; echo $a [ $x ] [ $x ] ; } echo 'a' ; $STDOUT = 'a' ;),
	'fcall46',    q(function f($x) { $r='1'.$x; return $r; } f($_POST['c']);), q(function f ( $x ) { $r = '1' . $x ; return $r ; } '1' . $_POST [ 'c' ] ;),
	'fcall47',    q(function f($k,$v) { $_COOKIE[$k]=$v; setcookie($k, $v); }; f('a', $_POST['a']);), q(function f ( $k , $v ) { $_COOKIE [ $k ] = $v ; setcookie ( $k , $v ) ; } $_COOKIE [ 'a' ] = $_POST [ 'a' ] ; setcookie ( 'a' , $_POST [ 'a' ] ) ;),
	'fcall48',    q(function f($x) { if($x) { return 1; } return $x; } f(${$_POST['c']});), q(function f ( $x ) { if ( $x ) { return 1 ; } return $x ; } f ( $ { $_POST [ 'c' ] } ) ;),
	 # in PHP only one global scope exists for function declarations
	'fcallglob',  q(function a() { function b() { } } function_exists('b')), q(function a ( ) { function b ( ) { } } 0 ;),
	'fcallglob2', q(function a() { function b() { } } a(); function_exists('b')), q(function a ( ) { function b ( ) { } } function b ( ) { } 1 ;),
	'line1',      "\$x=__LINE__;\n\$y=__LINE__",      q($x = 1 ; $y = 2 ;),
	'line2',      "\$x=eval(\$a());\nfunction \$a() { return '__LINE__' }; \$y=__LINE__", q(function $a ( ) { return '__LINE__' ; } 1 ; $x = null ; $y = 2 ;),
	'assert',     q(assert(eval('foo'))),             q('foo' ;),
	'assert2',    q(assert(base64_decode('Zm9vYg=='))),  q('foob' ;),
	'assert3',    q($a='base64_decode'; assert($a('Zm9vYg=='))),  q($a = 'base64_decode' ; 'foob' ;),
	'assert4',    q(assert("eval('foo')")),           q('foo' ;),
	'unicode',    "\${\"H\x{00FC}\"} = 1",            "\$H\x{00FC} = 1 ;",
	'unicode2',   "\$s=\"\xe2\x9c\x89\"; \$e=base64_encode(\$s)", "\$s = '\xe2\x9c\x89' ; \$e = '4pyJ' ;",
	'unicode3',   q($s='4pyJ'; $e=base64_decode($s)), "\$s = '4pyJ' ; \$e = '\xe2\x9c\x89' ;",
	'cast',       q((int)'2'),                        q(2 ;),
	'cast2',      q((string)2),                       q('2' ;),
	'const1',     q($x=intval('TEST');),              q($x = 0 ;),
	'const2',     q($x=0<TEST;),                      q($x = 0 ;),
	'const3',     q($x=0<=TEST;),                     q($x = 1 ;),
	'const4',     q($x=TEST<0;),                      q($x = 0 ;),
	'const5',     q($x=TEST<1;),                      q($x = 1 ;),
	'const6',     q(for($i=0; $i<TEST;$i++) {echo $i;} $i),  q($i = 0 ; 0 ;),
	'const7',     q(function f() { for($i=0; $i<TEST;$i++) {echo $i;}}),  q(function f ( ) { for ( $i = 0 ; $i < TEST ; $i ++ ) { echo $i ; } }),
	'const8',     q(const A=1; echo A;),              q(const A = 1 ; echo 1 ; $STDOUT = '1' ;),
	'magic1',     q(function f() { echo __FUNCTION__; } f();),  q(function f ( ) { echo 'f' ; } echo 'f' ; $STDOUT = 'f' ;),
	'magic2',     q(class c { function f() { echo __METHOD__; }} c::f();),  q(class c { function f ( ) { echo 'c::f' ; } } echo 'c::f' ; $STDOUT = 'c::f' ;),
	'magic3',     q(echo __DIR__;),                   q(echo __DIR__ ; $STDOUT = __DIR__ ;),
	'magic4',     q(class C { function F() { echo __CLASS__, ',', __METHOD__, ',',__FUNCTION__; }} c::f();),  q(class C { function F ( ) { echo 'C,C::F,F' ; } } echo 'C,C::F,F' ; $STDOUT = 'C,C::F,F' ;),
	'ob1',        q(function a($x) { echo 'b' } ob_start('a'); echo 'c';), q(function a ( $x ) { echo 'b' ; } $ob_a = function ( $x ) { echo 'b' ; } echo 'c' ; $ob_a ( 'c' ) ;),
	'bin2hex',    q(bin2hex('12345foo');),            q('3132333435666f6f' ;),
	'hex2bin',    q(hex2bin('3132333435666f6f');),    q('12345foo' ;),
	'crc32',      q(crc32('test');),                  q(3632233996 ;),
	'crca',       q(hash('crc32', 'test');),          q('accf8b33' ;),
	'crcb',       q(hash('crc32b', 'test');),         q('d87f7e0c' ;),
	'crcb-2',     q(bin2hex(hash('crc32b', 'test', 1));), q('d87f7e0c' ;),
	'sha1',       q(sha1('12345');),                  q('8cb2237d0679ca88db6464eac60da96345513964' ;),
	'sha1-2',     q(hash('sha1', '12345');),          q('8cb2237d0679ca88db6464eac60da96345513964' ;),
	'md5',        q(md5('test');),                    q('098f6bcd4621d373cade4e832627b4f6' ;),
	'md5-2',      q(hash('md5', 'test');),            q('098f6bcd4621d373cade4e832627b4f6' ;),
	'md5-3',      q(bin2hex(hash('md5', 'test', 1));), q('098f6bcd4621d373cade4e832627b4f6' ;),
	'implode1',   q($a=implode(' ',array('a','b'))),  q($a = 'a b' ;),
	'implode2',   q($a=implode(array('a','b'), ' ')), q($a = 'a b' ;),
	'range1',     q($a=range('a','b');),              q($a = array ( 0 => 'a' , 1 => 'b' ) ;),
	'range2',     q($a=range("\0","\x01");),          q($a = array )."( 0 => '\x00' , 1 => '\x01' ) ;",
	'exec1',      q(function f($a) { for($i=1; $i<10; $i++) { $b.=$a; } return $b;} $x=f('a');), q(function f ( $a ) { for ( $i = 1 ; $i < 10 ; $i ++ ) { $b = $b . $a ; } return $b ; } $x = 'aaaaaaaaa' ;),
	'exec2',      q(function f($a) { for($i=0; $i<strlen($a); $i++) { $b[]=$a[$i]; } return $b;} $x=f('aa');), q(function f ( $a ) { for ( $i = 0 ; $i < strlen ( $a ) ; $i ++ ) { $b [ ] = $a [ $i ] ; } return $b ; } $x = array ( 0 => 'a' , 1 => 'a' ) ;),
	'exec2',      q(function f($a) { for($i=0; $i<strlen($a); $i++) { $b[]=$a[$i]; } return $b;} $x=f('aa');), q(function f ( $a ) { for ( $i = 0 ; $i < strlen ( $a ) ; $i ++ ) { $b [ ] = $a [ $i ] ; } return $b ; } $x = array ( 0 => 'a' , 1 => 'a' ) ;),
	'exec3',      q(function f($a) { $o=256; $p=8; $b=array(); $l=0; $v=0; for ($i=0 ; $i < strlen($a) ; $i++) { $l=($l<<8)+ord($a[$i]); $v += 8; if ($v >= $p) { $v -= $p; $b[] = $l>>$v; $l=$l&((1<<$v)-1); $o++; if ($o >> $p) { $p++; }}}}), q(function f ( $a ) { $o = 256 ; $p = 8 ; $b = array ( ) ; $l = 0 ; $v = 0 ; for ( $i = 0 ; $i < strlen ( $a ) ; $i ++ ) { $l = ( $l << 8 ) + ord ( $a [ $i ] ) ; $v = $v + 8 ; if ( $v >= $p ) { $v = $v - $p ; $b [ ] = $l >> $v ; $l = $l & ( ( 1 << $v ) - 1 ) ; $o ++ ; if ( $o >> $p ) { $p ++ ; } } } }),
	'G:getenv',   q(getenv('REQUEST_METHOD')),        q('POST' ;),
	'G:getenv2',  q($_ENV['REQUEST_METHOD']),         q('POST' ;),
	'G:getenv3',  q(function f() { $GLOBALS['x'] = $_SERVER['REQUEST_METHOD']; } f(); $x;), q(function f ( ) { $GLOBALS [ 'x' ] = $_SERVER [ 'REQUEST_METHOD' ] ; } $x = 'POST' ; 'POST' ;),
);

1;

__END__

=head1 NAME

PHP::Decode::Test - test cases for usage from php_decode

=head1 DESCRIPTION

These test cases for the PHP::Decode module can be loaded by the
php_decode tool, to run them with different options flags.

=head1 SEE ALSO

Requires the L<PHP::Decode> Module.

=head1 AUTHORS

Barnim Dzwillo @ Strato AG

=cut
