/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.h264.read;

import com.googlecode.mp4parser.h264.CharCache;
import java.io.IOException;
import java.io.InputStream;

public class BitstreamReader {
    private InputStream is;
    private int curByte;
    private int nextByte;
    int nBit;
    protected static int bitsRead;
    protected CharCache debugBits = new CharCache(50);

    public BitstreamReader(InputStream is) throws IOException {
        this.is = is;
        this.curByte = is.read();
        this.nextByte = is.read();
    }

    public boolean readBool() throws IOException {
        return this.read1Bit() == 1;
    }

    public int read1Bit() throws IOException {
        if (this.nBit == 8) {
            this.advance();
            if (this.curByte == -1) {
                return -1;
            }
        }
        int res = this.curByte >> 7 - this.nBit & 1;
        ++this.nBit;
        this.debugBits.append(res == 0 ? (char)'0' : '1');
        ++bitsRead;
        return res;
    }

    public long readNBit(int n) throws IOException {
        if (n > 64) {
            throw new IllegalArgumentException("Can not readByte more then 64 bit");
        }
        long val = 0L;
        int i = 0;
        while (i < n) {
            val <<= 1;
            val |= (long)this.read1Bit();
            ++i;
        }
        return val;
    }

    private void advance() throws IOException {
        this.curByte = this.nextByte;
        this.nextByte = this.is.read();
        this.nBit = 0;
    }

    public int readByte() throws IOException {
        if (this.nBit > 0) {
            this.advance();
        }
        int res = this.curByte;
        this.advance();
        return res;
    }

    public boolean moreRBSPData() throws IOException {
        int tail;
        int mask;
        if (this.nBit == 8) {
            this.advance();
        }
        boolean hasTail = (this.curByte & (mask = ((tail = 1 << 8 - this.nBit - 1) << 1) - 1)) == tail;
        return this.curByte != -1 && (this.nextByte != -1 || !hasTail);
    }

    public long getBitPosition() {
        return bitsRead * 8 + this.nBit % 8;
    }

    public long readRemainingByte() throws IOException {
        return this.readNBit(8 - this.nBit);
    }

    public int peakNextBits(int n) throws IOException {
        if (n > 8) {
            throw new IllegalArgumentException("N should be less then 8");
        }
        if (this.nBit == 8) {
            this.advance();
            if (this.curByte == -1) {
                return -1;
            }
        }
        int[] bits = new int[16 - this.nBit];
        int cnt = 0;
        int i = this.nBit;
        while (i < 8) {
            bits[cnt++] = this.curByte >> 7 - i & 1;
            ++i;
        }
        i = 0;
        while (i < 8) {
            bits[cnt++] = this.nextByte >> 7 - i & 1;
            ++i;
        }
        int result = 0;
        int i2 = 0;
        while (i2 < n) {
            result <<= 1;
            result |= bits[i2];
            ++i2;
        }
        return result;
    }

    public boolean isByteAligned() {
        return this.nBit % 8 == 0;
    }

    public void close() throws IOException {
    }

    public int getCurBit() {
        return this.nBit;
    }
}

