/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.ontonotes;

import java.io.File;
import java.nio.charset.StandardCharsets;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.formats.AbstractSampleStreamFactory;
import opennlp.tools.formats.DirectorySampleStream;
import opennlp.tools.formats.convert.FileToStringSampleStream;
import opennlp.tools.formats.ontonotes.OntoNotesFormatParameters;
import opennlp.tools.formats.ontonotes.OntoNotesNameSampleStream;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.util.ObjectStream;

public class OntoNotesNameSampleStreamFactory
extends AbstractSampleStreamFactory<NameSample> {
    public OntoNotesNameSampleStreamFactory() {
        super(OntoNotesFormatParameters.class);
    }

    @Override
    public ObjectStream<NameSample> create(String[] args) {
        OntoNotesFormatParameters params = ArgumentParser.parse(args, OntoNotesFormatParameters.class);
        DirectorySampleStream documentStream = new DirectorySampleStream(new File(params.getOntoNotesDir()), file -> {
            if (file.isFile()) {
                return file.getName().endsWith(".name");
            }
            return file.isDirectory();
        }, true);
        return new OntoNotesNameSampleStream(new FileToStringSampleStream(documentStream, StandardCharsets.UTF_8));
    }

    public static void registerFactory() {
        StreamFactoryRegistry.registerFactory(NameSample.class, "ontonotes", new OntoNotesNameSampleStreamFactory());
    }
}

