/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Deprecable;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.resources.Errors;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;
import org.opengis.util.NameFactory;

public class AbstractIdentifiedType
implements Deprecable,
Serializable {
    private static final long serialVersionUID = 277130188958446740L;
    public static final String NAME_KEY = "name";
    public static final String DEFINITION_KEY = "definition";
    public static final String DESIGNATION_KEY = "designation";
    public static final String DESCRIPTION_KEY = "description";
    public static final String DEPRECATED_KEY = "deprecated";
    private final GenericName name;
    private final InternationalString definition;
    private final InternationalString designation;
    private final InternationalString description;
    final boolean deprecated;

    protected AbstractIdentifiedType(Map<String, ?> map) throws IllegalArgumentException {
        ArgumentChecks.ensureNonNull("identification", map);
        Object obj = map.get(NAME_KEY);
        if (obj == null) {
            throw new IllegalArgumentException(Errors.getResources(map).getString((short)89, NAME_KEY));
        }
        if (obj instanceof String) {
            this.name = this.createName(DefaultFactories.forBuildin(NameFactory.class), (String)obj);
        } else if (obj instanceof GenericName) {
            this.name = (GenericName)obj;
        } else {
            throw AbstractIdentifiedType.illegalPropertyType(map, NAME_KEY, obj);
        }
        this.definition = Types.toInternationalString(map, DEFINITION_KEY);
        this.designation = Types.toInternationalString(map, DESIGNATION_KEY);
        this.description = Types.toInternationalString(map, DESCRIPTION_KEY);
        obj = map.get(DEPRECATED_KEY);
        if (obj == null) {
            this.deprecated = false;
        } else if (obj instanceof Boolean) {
            this.deprecated = (Boolean)obj;
        } else {
            throw AbstractIdentifiedType.illegalPropertyType(map, DEPRECATED_KEY, obj);
        }
    }

    private static IllegalArgumentException illegalPropertyType(Map<String, ?> map, String string, Object object) {
        return new IllegalArgumentException(Errors.getResources(map).getString((short)58, string, object.getClass()));
    }

    GenericName createName(NameFactory nameFactory, String string) {
        return nameFactory.createLocalName(null, string);
    }

    public final GenericName getName() {
        return this.name;
    }

    public InternationalString getDefinition() {
        return this.definition;
    }

    public InternationalString getDesignation() {
        return this.designation;
    }

    public InternationalString getDescription() {
        return this.description;
    }

    @Override
    public InternationalString getRemarks() {
        return this.deprecated ? this.description : null;
    }

    @Override
    public boolean isDeprecated() {
        return this.deprecated;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.definition, this.designation, this.description, this.deprecated);
    }

    public boolean equals(Object object) {
        if (object != null && this.getClass() == object.getClass()) {
            AbstractIdentifiedType abstractIdentifiedType = (AbstractIdentifiedType)object;
            return Objects.equals(this.name, abstractIdentifiedType.name) && Objects.equals(this.definition, abstractIdentifiedType.definition) && Objects.equals(this.designation, abstractIdentifiedType.designation) && Objects.equals(this.description, abstractIdentifiedType.description) && this.deprecated == abstractIdentifiedType.deprecated;
        }
        return false;
    }

    static String toString(GenericName genericName, AbstractIdentifiedType abstractIdentifiedType, String string, int n) {
        CharSequence charSequence;
        short s = 89;
        if (genericName != null) {
            charSequence = genericName.toString();
            if (!((String)charSequence).isEmpty()) {
                return charSequence;
            }
            s = 32;
        }
        charSequence = new StringBuilder(40).append("Type[\u201c").append(abstractIdentifiedType.getName()).append("\u201d].").append(string).append('[').append(n).append("].name");
        throw new IllegalArgumentException(Errors.format(s, ((StringBuilder)charSequence).toString()));
    }
}

