/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.fit.factory;

import java.io.IOException;
import java.net.URL;
import java.util.Map;
import org.apache.uima.UIMAException;
import org.apache.uima.UIMAFramework;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.collection.CollectionReaderDescription;
import org.apache.uima.fit.factory.CapabilityFactory;
import org.apache.uima.fit.factory.ConfigurationParameterFactory;
import org.apache.uima.fit.factory.ExternalResourceFactory;
import org.apache.uima.fit.factory.FsIndexFactory;
import org.apache.uima.fit.factory.ResourceCreationSpecifierFactory;
import org.apache.uima.fit.factory.ResourceMetaDataFactory;
import org.apache.uima.fit.factory.TypePrioritiesFactory;
import org.apache.uima.fit.factory.TypeSystemDescriptionFactory;
import org.apache.uima.fit.internal.ResourceManagerFactory;
import org.apache.uima.resource.ExternalResourceDescription;
import org.apache.uima.resource.ResourceCreationSpecifier;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.metadata.Capability;
import org.apache.uima.resource.metadata.ConfigurationParameter;
import org.apache.uima.resource.metadata.FsIndexCollection;
import org.apache.uima.resource.metadata.Import;
import org.apache.uima.resource.metadata.ResourceMetaData;
import org.apache.uima.resource.metadata.TypePriorities;
import org.apache.uima.resource.metadata.TypeSystemDescription;

public final class CollectionReaderFactory {
    private CollectionReaderFactory() {
    }

    public static CollectionReader createReaderFromPath(String descriptorPath, Object ... configurationData) throws UIMAException, IOException {
        CollectionReaderDescription desc = CollectionReaderFactory.createReaderDescriptionFromPath(descriptorPath, configurationData);
        return UIMAFramework.produceCollectionReader(desc, ResourceManagerFactory.newResourceManager(), null);
    }

    @Deprecated
    public static CollectionReader createCollectionReaderFromPath(String descriptorPath, Object ... configurationData) throws UIMAException, IOException {
        return CollectionReaderFactory.createReaderFromPath(descriptorPath, configurationData);
    }

    public static CollectionReaderDescription createReaderDescriptionFromPath(String descriptorPath, Object ... configurationData) throws UIMAException, IOException {
        ResourceCreationSpecifier specifier = ResourceCreationSpecifierFactory.createResourceCreationSpecifier(descriptorPath, configurationData);
        return (CollectionReaderDescription)specifier;
    }

    @Deprecated
    public static CollectionReaderDescription createCollectionReaderDescriptionFromPath(String descriptorPath, Object ... configurationData) throws UIMAException, IOException {
        return CollectionReaderFactory.createReaderDescriptionFromPath(descriptorPath, configurationData);
    }

    public static CollectionReader createReader(String descriptorName, Object ... configurationData) throws UIMAException, IOException {
        Import imp = UIMAFramework.getResourceSpecifierFactory().createImport();
        imp.setName(descriptorName);
        URL url = imp.findAbsoluteUrl(ResourceManagerFactory.newResourceManager());
        ResourceCreationSpecifier specifier = ResourceCreationSpecifierFactory.createResourceCreationSpecifier(url, configurationData);
        return UIMAFramework.produceCollectionReader(specifier, ResourceManagerFactory.newResourceManager(), null);
    }

    @Deprecated
    public static CollectionReader createCollectionReader(String descriptorName, Object ... configurationData) throws UIMAException, IOException {
        return CollectionReaderFactory.createReader(descriptorName, configurationData);
    }

    public static CollectionReader createReader(Class<? extends CollectionReader> readerClass, Object ... configurationData) throws ResourceInitializationException {
        TypeSystemDescription tsd = TypeSystemDescriptionFactory.createTypeSystemDescription();
        return CollectionReaderFactory.createReader(readerClass, tsd, (TypePriorities)null, configurationData);
    }

    @Deprecated
    public static CollectionReader createCollectionReader(Class<? extends CollectionReader> readerClass, Object ... configurationData) throws ResourceInitializationException {
        return CollectionReaderFactory.createReader(readerClass, configurationData);
    }

    public static CollectionReader createReader(Class<? extends CollectionReader> readerClass, TypeSystemDescription typeSystem, Object ... configurationData) throws ResourceInitializationException {
        return CollectionReaderFactory.createReader(readerClass, typeSystem, (TypePriorities)null, configurationData);
    }

    @Deprecated
    public static CollectionReader createCollectionReader(Class<? extends CollectionReader> readerClass, TypeSystemDescription typeSystem, Object ... configurationData) throws ResourceInitializationException {
        return CollectionReaderFactory.createReader(readerClass, typeSystem, configurationData);
    }

    @Deprecated
    public static CollectionReader createReader(Class<? extends CollectionReader> readerClass, TypeSystemDescription typeSystem, String[] prioritizedTypeNames, Object ... configurationData) throws ResourceInitializationException {
        TypePriorities typePriorities = TypePrioritiesFactory.createTypePriorities(prioritizedTypeNames);
        return CollectionReaderFactory.createReader(readerClass, typeSystem, typePriorities, configurationData);
    }

    @Deprecated
    public static CollectionReader createCollectionReader(Class<? extends CollectionReader> readerClass, TypeSystemDescription typeSystem, String[] prioritizedTypeNames, Object ... configurationData) throws ResourceInitializationException {
        return CollectionReaderFactory.createReader(readerClass, typeSystem, prioritizedTypeNames, configurationData);
    }

    public static CollectionReader createReader(Class<? extends CollectionReader> readerClass, TypeSystemDescription typeSystem, TypePriorities typePriorities, Object ... configurationData) throws ResourceInitializationException {
        CollectionReaderDescription desc = CollectionReaderFactory.createReaderDescription(readerClass, typeSystem, typePriorities, configurationData);
        return CollectionReaderFactory.createReader(desc, new Object[0]);
    }

    @Deprecated
    public static CollectionReader createCollectionReader(Class<? extends CollectionReader> readerClass, TypeSystemDescription typeSystem, TypePriorities typePriorities, Object ... configurationData) throws ResourceInitializationException {
        return CollectionReaderFactory.createReader(readerClass, typeSystem, typePriorities, configurationData);
    }

    public static CollectionReader createReader(CollectionReaderDescription desc, Object ... configurationData) throws ResourceInitializationException {
        CollectionReaderDescription descClone = (CollectionReaderDescription)desc.clone();
        ResourceCreationSpecifierFactory.setConfigurationParameters((ResourceCreationSpecifier)descClone, configurationData);
        return UIMAFramework.produceCollectionReader(descClone, ResourceManagerFactory.newResourceManager(), null);
    }

    @Deprecated
    public static CollectionReader createCollectionReader(CollectionReaderDescription desc, Object ... configurationData) throws ResourceInitializationException {
        return CollectionReaderFactory.createReader(desc, configurationData);
    }

    public static CollectionReaderDescription createReaderDescription(Class<? extends CollectionReader> readerClass, Object ... configurationData) throws ResourceInitializationException {
        TypeSystemDescription tsd = TypeSystemDescriptionFactory.createTypeSystemDescription();
        return CollectionReaderFactory.createReaderDescription(readerClass, tsd, (TypePriorities)null, configurationData);
    }

    @Deprecated
    public static CollectionReaderDescription createDescription(Class<? extends CollectionReader> readerClass, Object ... configurationData) throws ResourceInitializationException {
        TypeSystemDescription tsd = TypeSystemDescriptionFactory.createTypeSystemDescription();
        return CollectionReaderFactory.createReaderDescription(readerClass, tsd, (TypePriorities)null, configurationData);
    }

    public static CollectionReaderDescription createReaderDescription(Class<? extends CollectionReader> readerClass, TypeSystemDescription typeSystem, Object ... configurationData) throws ResourceInitializationException {
        return CollectionReaderFactory.createReaderDescription(readerClass, typeSystem, (TypePriorities)null, configurationData);
    }

    @Deprecated
    public static CollectionReaderDescription createDescription(Class<? extends CollectionReader> readerClass, TypeSystemDescription typeSystem, Object ... configurationData) throws ResourceInitializationException {
        return CollectionReaderFactory.createReaderDescription(readerClass, typeSystem, configurationData);
    }

    public static CollectionReaderDescription createReaderDescription(Class<? extends CollectionReader> readerClass, TypeSystemDescription typeSystem, String[] prioritizedTypeNames, Object ... configurationData) throws ResourceInitializationException {
        TypePriorities typePriorities = TypePrioritiesFactory.createTypePriorities(prioritizedTypeNames);
        return CollectionReaderFactory.createReaderDescription(readerClass, typeSystem, typePriorities, configurationData);
    }

    @Deprecated
    public static CollectionReaderDescription createDescription(Class<? extends CollectionReader> readerClass, TypeSystemDescription typeSystem, String[] prioritizedTypeNames, Object ... configurationData) throws ResourceInitializationException {
        return CollectionReaderFactory.createReaderDescription(readerClass, typeSystem, prioritizedTypeNames, configurationData);
    }

    public static CollectionReaderDescription createReaderDescription(Class<? extends CollectionReader> readerClass, TypeSystemDescription typeSystem, TypePriorities typePriorities, Object ... configurationData) throws ResourceInitializationException {
        return CollectionReaderFactory.createReaderDescription(readerClass, typeSystem, typePriorities, (FsIndexCollection)null, (Capability[])null, configurationData);
    }

    @Deprecated
    public static CollectionReaderDescription createDescription(Class<? extends CollectionReader> readerClass, TypeSystemDescription typeSystem, TypePriorities typePriorities, Object ... configurationData) throws ResourceInitializationException {
        return CollectionReaderFactory.createReaderDescription(readerClass, typeSystem, typePriorities, configurationData);
    }

    public static CollectionReaderDescription createReaderDescription(Class<? extends CollectionReader> readerClass, TypeSystemDescription typeSystem, TypePriorities typePriorities, FsIndexCollection indexes, Capability[] capabilities, Object ... configurationData) throws ResourceInitializationException {
        ConfigurationParameterFactory.ensureParametersComeInPairs(configurationData);
        Map<String, ExternalResourceDescription> externalResources = ExternalResourceFactory.extractExternalResourceParameters(configurationData);
        ConfigurationParameterFactory.ConfigurationData cdata = ConfigurationParameterFactory.createConfigurationData(configurationData);
        return CollectionReaderFactory.createReaderDescription(readerClass, typeSystem, typePriorities, indexes, capabilities, cdata.configurationParameters, cdata.configurationValues, externalResources);
    }

    @Deprecated
    public static CollectionReaderDescription createDescription(Class<? extends CollectionReader> readerClass, TypeSystemDescription typeSystem, TypePriorities typePriorities, FsIndexCollection indexes, Capability[] capabilities, Object ... configurationData) throws ResourceInitializationException {
        return CollectionReaderFactory.createReaderDescription(readerClass, typeSystem, typePriorities, indexes, capabilities, configurationData);
    }

    public static CollectionReaderDescription createReaderDescription(Class<? extends CollectionReader> readerClass, TypeSystemDescription typeSystem, TypePriorities typePriorities, FsIndexCollection indexes, Capability[] capabilities, ConfigurationParameter[] configurationParameters, Object[] configurationValues) throws ResourceInitializationException {
        return CollectionReaderFactory.createReaderDescription(readerClass, typeSystem, typePriorities, indexes, capabilities, configurationParameters, configurationValues, null);
    }

    @Deprecated
    public static CollectionReaderDescription createDescription(Class<? extends CollectionReader> readerClass, TypeSystemDescription typeSystem, TypePriorities typePriorities, FsIndexCollection indexes, Capability[] capabilities, ConfigurationParameter[] configurationParameters, Object[] configurationValues) throws ResourceInitializationException {
        return CollectionReaderFactory.createReaderDescription(readerClass, typeSystem, typePriorities, indexes, capabilities, configurationParameters, configurationValues);
    }

    public static CollectionReaderDescription createReaderDescription(Class<? extends CollectionReader> readerClass, TypeSystemDescription typeSystem, TypePriorities typePriorities, FsIndexCollection indexes, Capability[] capabilities, ConfigurationParameter[] configurationParameters, Object[] configurationValues, Map<String, ExternalResourceDescription> externalResources) throws ResourceInitializationException {
        CollectionReaderDescription desc = UIMAFramework.getResourceSpecifierFactory().createCollectionReaderDescription();
        desc.setFrameworkImplementation("org.apache.uima.java");
        desc.setImplementationName(readerClass.getName());
        ConfigurationParameterFactory.setParameters(desc, readerClass, configurationParameters, configurationValues);
        ResourceMetaData meta = desc.getMetaData();
        ResourceMetaDataFactory.configureResourceMetaData(meta, readerClass);
        if (typeSystem != null) {
            desc.getCollectionReaderMetaData().setTypeSystem(typeSystem);
        }
        if (typePriorities != null) {
            desc.getCollectionReaderMetaData().setTypePriorities(typePriorities);
        }
        if (indexes != null) {
            desc.getCollectionReaderMetaData().setFsIndexCollection(indexes);
        } else {
            desc.getCollectionReaderMetaData().setFsIndexCollection(FsIndexFactory.createFsIndexCollection(readerClass));
        }
        if (capabilities != null) {
            desc.getCollectionReaderMetaData().setCapabilities(capabilities);
        } else {
            Capability capability = CapabilityFactory.createCapability(readerClass);
            if (capability != null) {
                desc.getCollectionReaderMetaData().setCapabilities(new Capability[]{capability});
            }
        }
        desc.setExternalResourceDependencies(ExternalResourceFactory.createExternalResourceDependencies(readerClass));
        if (externalResources != null) {
            for (Map.Entry<String, ExternalResourceDescription> e : externalResources.entrySet()) {
                ExternalResourceFactory.bindExternalResource((ResourceCreationSpecifier)desc, e.getKey(), e.getValue());
            }
        }
        return desc;
    }

    @Deprecated
    public static CollectionReaderDescription createDescription(Class<? extends CollectionReader> readerClass, TypeSystemDescription typeSystem, TypePriorities typePriorities, FsIndexCollection indexes, Capability[] capabilities, ConfigurationParameter[] configurationParameters, Object[] configurationValues, Map<String, ExternalResourceDescription> externalResources) throws ResourceInitializationException {
        return CollectionReaderFactory.createReaderDescription(readerClass, typeSystem, typePriorities, indexes, capabilities, configurationParameters, configurationValues, externalResources);
    }
}

