/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc.vertical;

import java.io.IOException;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.ArrayDouble;
import ucar.ma2.Index;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.units.SimpleUnit;
import ucar.unidata.geoloc.vertical.VerticalTransformImpl;
import ucar.unidata.util.Parameter;

public class HybridSigmaPressure
extends VerticalTransformImpl {
    public static final String P0 = "P0_variableName";
    public static final String PS = "SurfacePressure_variableName";
    public static final String A = "A_variableName";
    public static final String AP = "AP_variableName";
    public static final String B = "B_variableName";
    private double p0;
    private Variable psVar;
    private Variable aVar;
    private Variable bVar;
    private Variable p0Var;
    private String apUnits = "";
    private Array aArray = null;
    private Array bArray = null;

    public HybridSigmaPressure(NetcdfFile ds, Dimension timeDim, List<Parameter> params) {
        super(timeDim);
        String psName = this.getParameterStringValue(params, PS);
        String aName = this.getParameterStringValue(params, A);
        String bName = this.getParameterStringValue(params, B);
        String p0Name = this.getParameterStringValue(params, P0);
        String apName = this.getParameterStringValue(params, AP);
        this.aVar = apName != null ? ds.findVariable(apName) : ds.findVariable(aName);
        if (this.aVar.findAttributeIgnoreCase("units") != null) {
            this.apUnits = this.aVar.findAttributeIgnoreCase("units").getStringValue();
        }
        this.psVar = ds.findVariable(psName);
        this.bVar = ds.findVariable(bName);
        this.units = ds.findAttValueIgnoreCase(this.psVar, "units", "none");
        if (p0Name != null) {
            this.p0Var = ds.findVariable(p0Name);
            this.apUnits = this.units;
        }
    }

    @Override
    public ArrayDouble.D3 getCoordinateArray(int timeIndex) throws IOException, InvalidRangeException {
        Array psArray = this.readArray(this.psVar, timeIndex);
        if (null == this.aArray) {
            this.aArray = this.aVar.read();
            this.bArray = this.bVar.read();
            this.p0 = this.computeP0();
        }
        int nz = (int)this.aArray.getSize();
        Index aIndex = this.aArray.getIndex();
        Index bIndex = this.bArray.getIndex();
        if (psArray.getRank() == 3) {
            psArray = psArray.reduce(0);
        }
        int[] shape2D = psArray.getShape();
        int ny = shape2D[0];
        int nx = shape2D[1];
        Index psIndex = psArray.getIndex();
        ArrayDouble.D3 press = new ArrayDouble.D3(nz, ny, nx);
        for (int z = 0; z < nz; ++z) {
            double term1 = this.aArray.getDouble(aIndex.set(z)) * this.p0;
            if (!this.apUnits.equals(this.units)) {
                term1 = this.convertPressureToPSUnits(this.apUnits, term1);
            }
            double bz = this.bArray.getDouble(bIndex.set(z));
            for (int y = 0; y < ny; ++y) {
                for (int x = 0; x < nx; ++x) {
                    double ps = psArray.getDouble(psIndex.set(y, x));
                    press.set(z, y, x, term1 + bz * ps);
                }
            }
        }
        return press;
    }

    @Override
    public ArrayDouble.D1 getCoordinateArray1D(int timeIndex, int xIndex, int yIndex) throws IOException, InvalidRangeException {
        Array psArray = this.readArray(this.psVar, timeIndex);
        if (null == this.aArray) {
            this.aArray = this.aVar.read();
            this.bArray = this.bVar.read();
            this.p0 = this.computeP0();
        }
        int nz = (int)this.aArray.getSize();
        Index aIndex = this.aArray.getIndex();
        Index bIndex = this.bArray.getIndex();
        if (psArray.getRank() == 3) {
            psArray = psArray.reduce(0);
        }
        Index psIndex = psArray.getIndex();
        ArrayDouble.D1 press = new ArrayDouble.D1(nz);
        for (int z = 0; z < nz; ++z) {
            double term1 = this.aArray.getDouble(aIndex.set(z)) * this.p0;
            if (!this.apUnits.equals(this.units)) {
                term1 = this.convertPressureToPSUnits(this.apUnits, term1);
            }
            double bz = this.bArray.getDouble(bIndex.set(z));
            double ps = psArray.getDouble(psIndex.set(yIndex, xIndex));
            press.set(z, term1 + bz * ps);
        }
        return press;
    }

    private double computeP0() throws IOException {
        if (this.p0Var == null) {
            return 1.0;
        }
        double p0 = this.p0Var.readScalarDouble();
        String p0UnitStr = this.p0Var.findAttributeIgnoreCase("units").getStringValue();
        if (p0UnitStr == null) {
            throw new IllegalStateException();
        }
        if (!this.units.equalsIgnoreCase(p0UnitStr)) {
            p0 = this.convertPressureToPSUnits(p0UnitStr, p0);
        }
        return p0;
    }

    private double convertPressureToPSUnits(String unit, double val) {
        SimpleUnit psUnit = SimpleUnit.factory(this.units);
        SimpleUnit ptopUnit = SimpleUnit.factory(unit);
        double factor = ptopUnit.convertTo(1.0, psUnit);
        return val * factor;
    }
}

