package Sys::Ebpf::Link::Netlink::Constants::Socket;

use strict;
use warnings;
use utf8;

use Exporter 'import';

# cf. https://github.com/torvalds/linux/blob/master/include/linux/socket.h
my %constants = (

    # /* Supported address families. */
    'AF_UNSPEC'     => 0,
    'AF_UNIX'       => 1,
    'AF_INET'       => 2,
    'AF_AX25'       => 3,
    'AF_IPX'        => 4,
    'AF_APPLETALK'  => 5,
    'AF_NETROM'     => 6,
    'AF_BRIDGE'     => 7,
    'AF_ATMPVC'     => 8,
    'AF_X25'        => 9,
    'AF_INET6'      => 10,
    'AF_ROSE'       => 11,
    'AF_DECnet'     => 12,
    'AF_NETBEUI'    => 13,
    'AF_SECURITY'   => 14,
    'AF_KEY'        => 15,
    'AF_NETLINK'    => 16,
    'AF_ROUTE'      => 16,
    'AF_PACKET'     => 17,
    'AF_ASH'        => 18,
    'AF_ECONET'     => 19,
    'AF_ATMSVC'     => 20,
    'AF_RDS'        => 21,
    'AF_SNA'        => 22,
    'AF_IRDA'       => 23,
    'AF_PPPOX'      => 24,
    'AF_WANPIPE'    => 25,
    'AF_LLC'        => 26,
    'AF_IB'         => 27,
    'AF_MPLS'       => 28,
    'AF_CAN'        => 29,
    'AF_TIPC'       => 30,
    'AF_BLUETOOTH'  => 31,
    'AF_IUCV'       => 32,
    'AF_RXRPC'      => 33,
    'AF_ISDN'       => 34,
    'AF_PHONET'     => 35,
    'AF_IEEE802154' => 36,
    'AF_CAIF'       => 37,
    'AF_ALG'        => 38,
    'AF_NFC'        => 39,
    'AF_VSOCK'      => 40,
    'AF_KCM'        => 41,
    'AF_QIPCRTR'    => 42,
    'AF_SMC'        => 43,
    'AF_XDP'        => 44,
    'AF_MCTP'       => 45,

    # /* Protocol families, same as address families. */
    'PF_UNSPEC'     => 0,
    'PF_UNIX'       => 1,
    'PF_LOCAL'      => 1,
    'PF_INET'       => 2,
    'PF_AX25'       => 3,
    'PF_IPX'        => 4,
    'PF_APPLETALK'  => 5,
    'PF_NETROM'     => 6,
    'PF_BRIDGE'     => 7,
    'PF_ATMPVC'     => 8,
    'PF_X25'        => 9,
    'PF_INET6'      => 10,
    'PF_ROSE'       => 11,
    'PF_DECnet'     => 12,
    'PF_NETBEUI'    => 13,
    'PF_SECURITY'   => 14,
    'PF_KEY'        => 15,
    'PF_NETLINK'    => 16,
    'PF_ROUTE'      => 16,
    'PF_PACKET'     => 17,
    'PF_ASH'        => 18,
    'PF_ECONET'     => 19,
    'PF_ATMSVC'     => 20,
    'PF_RDS'        => 21,
    'PF_SNA'        => 22,
    'PF_IRDA'       => 23,
    'PF_PPPOX'      => 24,
    'PF_WANPIPE'    => 25,
    'PF_LLC'        => 26,
    'PF_IB'         => 27,
    'PF_MPLS'       => 28,
    'PF_CAN'        => 29,
    'PF_TIPC'       => 30,
    'PF_BLUETOOTH'  => 31,
    'PF_IUCV'       => 32,
    'PF_RXRPC'      => 33,
    'PF_ISDN'       => 34,
    'PF_PHONET'     => 35,
    'PF_IEEE802154' => 36,
    'PF_CAIF'       => 37,
    'PF_ALG'        => 38,
    'PF_NFC'        => 39,
    'PF_VSOCK'      => 40,
    'PF_KCM'        => 41,
    'PF_QIPCRTR'    => 42,
    'PF_SMC'        => 43,
    'PF_XDP'        => 44,
    'PF_MCTP'       => 45,

   # /* Setsockoptions(2) level. Thanks to BSD these must match IPPROTO_xxx */
    'SOL_IP'        => 0,
    'SOL_SOCKET'    => 1,
    'SOL_TCP'       => 6,
    'SOL_UDP'       => 17,
    'SOL_IPV6'      => 41,
    'SOL_ICMPV6'    => 58,
    'SOL_SCTP'      => 132,
    'SOL_UDPLITE'   => 136,
    'SOL_RAW'       => 255,
    'SOL_IPX'       => 256,
    'SOL_AX25'      => 257,
    'SOL_ATALK'     => 258,
    'SOL_NETROM'    => 259,
    'SOL_ROSE'      => 260,
    'SOL_DECNET'    => 261,
    'SOL_X25'       => 262,
    'SOL_PACKET'    => 263,
    'SOL_ATM'       => 264,
    'SOL_AAL'       => 265,
    'SOL_IRDA'      => 266,
    'SOL_NETBEUI'   => 267,
    'SOL_LLC'       => 268,
    'SOL_DCCP'      => 269,
    'SOL_NETLINK'   => 270,
    'SOL_TIPC'      => 271,
    'SOL_RXRPC'     => 272,
    'SOL_PPPOL2TP'  => 273,
    'SOL_BLUETOOTH' => 274,
    'SOL_PNPIPE'    => 275,
    'SOL_RDS'       => 276,
    'SOL_IUCV'      => 277,
    'SOL_CAIF'      => 278,
    'SOL_ALG'       => 279,
    'SOL_NFC'       => 280,
    'SOL_KCM'       => 281,
    'SOL_TLS'       => 282,
    'SOL_XDP'       => 283,
    'SOL_MPTCP'     => 284,
    'SOL_MCTP'      => 285,
    'SOL_SMC'       => 286,
    'SOL_VSOCK'     => 287,
);

# Export all constants
our @EXPORT_OK   = keys %constants;
our %EXPORT_TAGS = ( all => \@EXPORT_OK );

# Define constants as subroutines
for my $name (@EXPORT_OK) {
    no strict 'refs';
    *{$name} = sub () { $constants{$name} };
}

1;
