/*
 * Decompiled with CFR 0.152.
 */
package org.couchbase.mock.http;

import com.sun.net.httpserver.Authenticator;
import com.sun.net.httpserver.BasicAuthenticator;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpPrincipal;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.couchbase.mock.Bucket;

public class Authenticator
extends BasicAuthenticator {
    private String adminName;
    private String adminPass;
    private String bucketName;
    private Map<String, Bucket> buckets;

    public Authenticator(String username, String password, Map<String, Bucket> buckets) {
        super("Couchbase Mock");
        this.adminName = username;
        this.adminPass = password;
        this.buckets = buckets;
    }

    @Override
    public boolean checkCredentials(String username, String password) {
        if (this.adminName.equals(username) && this.adminPass.equals(password)) {
            return true;
        }
        Bucket bucket = this.buckets.get(username);
        if (bucket == null || !this.bucketName.equals(username)) {
            return false;
        }
        return bucket.getPassword().equals(password);
    }

    @Override
    public Authenticator.Result authenticate(HttpExchange exchange) {
        Bucket bucket;
        String requestPath = exchange.getRequestURI().getPath();
        Matcher m = Pattern.compile("/pools/\\w+/buckets(Streaming)?/(\\w+)/?.*").matcher(requestPath);
        this.bucketName = null;
        if (m.find()) {
            this.bucketName = m.group(2);
        }
        if (!exchange.getRequestHeaders().containsKey("Authorization") && ((bucket = this.buckets.get(this.bucketName)) == null || bucket.getPassword().isEmpty())) {
            return new Authenticator.Success(new HttpPrincipal("", this.realm));
        }
        return super.authenticate(exchange);
    }

    public String getAdminName() {
        return this.adminName;
    }
}

