/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.BooleanExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.OrExpression;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Choose;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.NotFn;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.BooleanValue;

public class AndExpression
extends BooleanExpression {
    public AndExpression(Expression p1, Expression p2) {
        super(p1, 10, p2);
    }

    public Expression optimize(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        Expression e = super.optimize(visitor, contextItemType);
        if (e != this) {
            return e;
        }
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        if (Literal.isConstantBoolean(this.operand0, false) || Literal.isConstantBoolean(this.operand1, false)) {
            return new Literal(BooleanValue.FALSE);
        }
        if (Literal.isConstantBoolean(this.operand0, true)) {
            return this.forceToBoolean(this.operand1, th);
        }
        if (Literal.isConstantBoolean(this.operand1, true)) {
            return this.forceToBoolean(this.operand0, th);
        }
        if (e == this && this.operand1 instanceof UserFunctionCall && th.isSubType(this.operand1.getItemType(th), BuiltInAtomicType.BOOLEAN) && !visitor.isLoopingSubexpression(null)) {
            Expression cond = Choose.makeConditional(this.operand0, this.operand1, Literal.makeLiteral(BooleanValue.FALSE));
            ExpressionTool.copyLocationInfo(this, cond);
            return cond;
        }
        return this;
    }

    public Expression copy() {
        return new AndExpression(this.operand0.copy(), this.operand1.copy());
    }

    public Expression negate() {
        NotFn not0 = (NotFn)SystemFunction.makeSystemFunction("not", new Expression[]{this.operand0});
        NotFn not1 = (NotFn)SystemFunction.makeSystemFunction("not", new Expression[]{this.operand1});
        return new OrExpression(not0, not1);
    }

    public boolean effectiveBooleanValue(XPathContext c) throws XPathException {
        return this.operand0.effectiveBooleanValue(c) && this.operand1.effectiveBooleanValue(c);
    }
}

