/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ncml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import ucar.nc2.NetcdfFile;
import ucar.nc2.dataset.DatasetConstructor;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ncml.Aggregation;
import ucar.nc2.util.CancelTask;

public class AggregationUnion
extends Aggregation {
    private List<NetcdfFile> openDatasets = new ArrayList<NetcdfFile>();

    public AggregationUnion(NetcdfDataset ncd, String dimName, String recheckS) {
        super(ncd, dimName, Aggregation.Type.union, recheckS);
    }

    protected void buildNetcdfDataset(CancelTask cancelTask) throws IOException {
        List<Aggregation.Dataset> nestedDatasets = this.getDatasets();
        for (Aggregation.Dataset vnested : nestedDatasets) {
            NetcdfFile ncfile = vnested.acquireFile(cancelTask);
            DatasetConstructor.transferDataset(ncfile, this.ncDataset, null);
            this.openDatasets.add(ncfile);
        }
    }

    protected void rebuildDataset() throws IOException {
        this.ncDataset.empty();
        this.buildNetcdfDataset(null);
    }

    protected void closeDatasets() throws IOException {
        for (NetcdfFile ncfile : this.openDatasets) {
            try {
                ncfile.close();
            }
            catch (IOException iOException) {}
        }
        super.closeDatasets();
    }
}

