/*
 * Decompiled with CFR 0.152.
 */
package org.maltparser.core.io.dataformat;

import org.maltparser.core.exception.MaltChainedException;
import org.maltparser.core.io.dataformat.DataFormatException;
import org.maltparser.core.symbol.SymbolTable;
import org.maltparser.core.symbol.SymbolTableHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnDescription
implements Comparable<ColumnDescription> {
    public static final int INPUT = 1;
    public static final int HEAD = 2;
    public static final int DEPENDENCY_EDGE_LABEL = 3;
    public static final int PHRASE_STRUCTURE_EDGE_LABEL = 4;
    public static final int PHRASE_STRUCTURE_NODE_LABEL = 5;
    public static final int SECONDARY_EDGE_LABEL = 6;
    public static final int STRING = 1;
    public static final int INTEGER = 2;
    public static final int BOOLEAN = 3;
    public static final int ECHO = 4;
    public static final int IGNORE = 5;
    private int position;
    private String name;
    private int category;
    private int type;
    private String defaultOutput;
    private SymbolTable symbolTable;
    private int cachedHash;

    public ColumnDescription(int position, String name, String category, String type, String defaultOutput, SymbolTableHandler symbolTables, String specialSymbolsfileName, String rootLabel) throws MaltChainedException {
        this.setPosition(position);
        this.setName(name);
        this.setCategory(category);
        this.setType(type);
        this.setDefaultOutput(defaultOutput);
        this.createSymbolTable(symbolTables, specialSymbolsfileName, rootLabel);
    }

    private void createSymbolTable(SymbolTableHandler symbolTables, String nullValueStrategy, String rootLabel) throws MaltChainedException {
        this.symbolTable = this.type == 1 || this.type == 2 || this.type == 3 ? (this.category == 3 ? symbolTables.addSymbolTable(this.name, this.category, nullValueStrategy, rootLabel) : symbolTables.addSymbolTable(this.name, this.category, nullValueStrategy)) : null;
    }

    public int getPosition() {
        return this.position;
    }

    public String getName() {
        return this.name;
    }

    public int getCategory() {
        return this.category;
    }

    public int getType() {
        return this.type;
    }

    public String getDefaultOutput() {
        return this.defaultOutput;
    }

    public SymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    private void setPosition(int position) throws MaltChainedException {
        if (position < 0) {
            throw new DataFormatException("Position value for column must be a non-negative value. ");
        }
        this.position = position;
    }

    private void setName(String name) {
        this.name = name.toUpperCase();
    }

    private void setCategory(String category) throws MaltChainedException {
        if (category.toUpperCase().equals("INPUT")) {
            this.category = 1;
        } else if (category.toUpperCase().equals("HEAD")) {
            this.category = 2;
        } else if (category.toUpperCase().equals("OUTPUT")) {
            this.category = 3;
        } else if (category.toUpperCase().equals("DEPENDENCY_EDGE_LABEL")) {
            this.category = 3;
        } else if (category.toUpperCase().equals("PHRASE_STRUCTURE_EDGE_LABEL")) {
            this.category = 4;
        } else if (category.toUpperCase().equals("PHRASE_STRUCTURE_NODE_LABEL")) {
            this.category = 5;
        } else if (category.toUpperCase().equals("SECONDARY_EDGE_LABEL")) {
            this.category = 6;
        } else {
            throw new DataFormatException("The category '" + category + "' is not allowed. ");
        }
    }

    private void setType(String type) throws MaltChainedException {
        if (type.toUpperCase().equals("STRING")) {
            this.type = 1;
        } else if (type.toUpperCase().equals("INTEGER")) {
            this.type = 2;
        } else if (type.toUpperCase().equals("BOOLEAN")) {
            this.type = 3;
        } else if (type.toUpperCase().equals("ECHO")) {
            this.type = 4;
        } else if (type.toUpperCase().equals("IGNORE")) {
            this.type = 5;
        } else {
            throw new DataFormatException("The column type '" + type + "' is not allowed. ");
        }
    }

    public void setSymbolTable(SymbolTable symbolTable) {
        if (this.type == 1) {
            this.symbolTable = symbolTable;
        }
    }

    public void setDefaultOutput(String defaultOutput) {
        this.defaultOutput = defaultOutput;
    }

    @Override
    public int compareTo(ColumnDescription that) {
        int BEFORE = -1;
        boolean EQUAL = false;
        boolean AFTER = true;
        if (this == that) {
            return 0;
        }
        if (this.position < that.position) {
            return -1;
        }
        if (this.position > that.position) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ColumnDescription objC = (ColumnDescription)obj;
        return this.type == objC.type && this.category == objC.category && (this.name == null ? objC.name == null : this.name.equals(objC.name));
    }

    public int hashCode() {
        if (this.cachedHash == 0) {
            int hash = 217 + this.type;
            hash = 31 * hash + this.category;
            this.cachedHash = hash = 31 * hash + (null == this.name ? 0 : this.name.hashCode());
        }
        return this.cachedHash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name);
        sb.append('\t');
        sb.append(this.category);
        sb.append('\t');
        sb.append(this.type);
        if (this.defaultOutput != null) {
            sb.append('\t');
            sb.append(this.defaultOutput);
        }
        return sb.toString();
    }
}

