/*
 * Decompiled with CFR 0.152.
 */
package com.drew.imaging.jpeg;

import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpegSegmentData
implements Serializable {
    private static final long serialVersionUID = 7110175216435025451L;
    @NotNull
    private final HashMap<Byte, List<byte[]>> _segmentDataMap = new HashMap(10);

    public void addSegment(byte segmentMarker, @NotNull byte[] segmentBytes) {
        List<byte[]> segmentList = this.getOrCreateSegmentList(segmentMarker);
        segmentList.add(segmentBytes);
    }

    @Nullable
    public byte[] getSegment(byte segmentMarker) {
        return this.getSegment(segmentMarker, 0);
    }

    @Nullable
    public byte[] getSegment(byte segmentMarker, int occurrence) {
        List<byte[]> segmentList = this.getSegmentList(segmentMarker);
        if (segmentList == null || segmentList.size() <= occurrence) {
            return null;
        }
        return segmentList.get(occurrence);
    }

    @NotNull
    public Iterable<byte[]> getSegments(byte segmentMarker) {
        ArrayList segmentList = this.getSegmentList(segmentMarker);
        return segmentList == null ? new ArrayList() : segmentList;
    }

    @Nullable
    public List<byte[]> getSegmentList(byte segmentMarker) {
        return this._segmentDataMap.get(segmentMarker);
    }

    @NotNull
    private List<byte[]> getOrCreateSegmentList(byte segmentMarker) {
        ArrayList<byte[]> segmentList;
        if (this._segmentDataMap.containsKey(segmentMarker)) {
            segmentList = this._segmentDataMap.get(segmentMarker);
        } else {
            segmentList = new ArrayList();
            this._segmentDataMap.put(segmentMarker, segmentList);
        }
        return segmentList;
    }

    public int getSegmentCount(byte segmentMarker) {
        List<byte[]> segmentList = this.getSegmentList(segmentMarker);
        return segmentList == null ? 0 : segmentList.size();
    }

    public void removeSegmentOccurrence(byte segmentMarker, int occurrence) {
        List<byte[]> segmentList = this._segmentDataMap.get(segmentMarker);
        segmentList.remove(occurrence);
    }

    public void removeSegment(byte segmentMarker) {
        this._segmentDataMap.remove(segmentMarker);
    }

    public boolean containsSegment(byte segmentMarker) {
        return this._segmentDataMap.containsKey(segmentMarker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void toFile(@NotNull File file, @NotNull JpegSegmentData segmentData) throws IOException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            new ObjectOutputStream(fileOutputStream).writeObject(segmentData);
        }
        finally {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static JpegSegmentData fromFile(@NotNull File file) throws IOException, ClassNotFoundException {
        ObjectInputStream inputStream = null;
        try {
            inputStream = new ObjectInputStream(new FileInputStream(file));
            JpegSegmentData jpegSegmentData = (JpegSegmentData)inputStream.readObject();
            return jpegSegmentData;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }
}

