/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.measure;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.measure.Dimension;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.spi.SystemOfUnits;
import org.apache.sis.math.Fraction;
import org.apache.sis.measure.AbstractUnit;
import org.apache.sis.measure.ConventionalUnit;
import org.apache.sis.measure.SystemUnit;
import org.apache.sis.measure.UnitDimension;
import org.apache.sis.measure.Units;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.collection.WeakValueHashMap;

final class UnitRegistry
implements SystemOfUnits,
Serializable {
    private static final long serialVersionUID = -84557361079506390L;
    static final byte PREFIXABLE = 1;
    static final byte SI = 2;
    static final byte ACCEPTED = 4;
    static final byte IMPERIAL = 8;
    static final byte OTHER = 16;
    private static final Map<Object, Object> HARD_CODED = new HashMap<Object, Object>(256);
    private static final WeakValueHashMap<Object, Object> USER_DEFINED = new WeakValueHashMap(Object.class);
    final String name;
    private final int includes;
    private transient Set<Unit<?>> units;

    static void init(Map<UnitDimension, Fraction> map, UnitDimension unitDimension) {
        assert (!Units.initialized) : unitDimension.symbol;
        if (HARD_CODED.put(map, unitDimension) != null) {
            throw new AssertionError(unitDimension.symbol);
        }
    }

    static <Q extends Quantity<Q>> SystemUnit<Q> init(SystemUnit<Q> systemUnit) {
        assert (!Units.initialized) : systemUnit;
        int n = HARD_CODED.put(systemUnit.dimension, systemUnit) == null ? 0 : 1;
        n |= HARD_CODED.put(systemUnit.quantity, systemUnit) == null ? 0 : 2;
        n |= HARD_CODED.put(systemUnit.getSymbol(), systemUnit) == null ? 0 : 4;
        if (systemUnit.epsg != 0) {
            n |= HARD_CODED.put(systemUnit.epsg, systemUnit) == null ? 0 : 8;
        }
        assert (UnitRegistry.filter(n, systemUnit) == 0) : systemUnit;
        return systemUnit;
    }

    private static int filter(int n, SystemUnit<?> systemUnit) {
        String string = systemUnit.getSymbol();
        if (systemUnit.dimension.isDimensionless()) {
            n &= 0xFFFFFFFC;
        }
        if (string.equals("cd") || string.equals("Hz")) {
            n &= 0xFFFFFFFE;
        }
        return string.isEmpty() ? 0 : n;
    }

    static <Q extends Quantity<Q>> ConventionalUnit<Q> init(ConventionalUnit<Q> conventionalUnit) {
        assert (!Units.initialized) : conventionalUnit;
        if (HARD_CODED.put(conventionalUnit.getSymbol(), conventionalUnit) == null && (conventionalUnit.epsg == 0 || HARD_CODED.put(conventionalUnit.epsg, conventionalUnit) == null)) {
            return conventionalUnit;
        }
        throw new AssertionError(conventionalUnit);
    }

    static void alias(Unit<?> unit, Comparable<?> comparable) {
        assert (!Units.initialized) : unit;
        if (HARD_CODED.put(comparable, unit) != null) {
            throw new AssertionError(unit);
        }
    }

    static Object putIfAbsent(Object object, Object object2) {
        assert (Units.initialized) : object2;
        Object object3 = HARD_CODED.get(object);
        if (object3 == null) {
            object3 = USER_DEFINED.putIfAbsent(object, object2);
        }
        return object3;
    }

    static Object get(Object object) {
        Object object2 = HARD_CODED.get(object);
        if (object2 == null) {
            object2 = USER_DEFINED.get(object);
        }
        return object2;
    }

    UnitRegistry(String string, int n) {
        this.name = string;
        this.includes = n;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public <Q extends Quantity<Q>> Unit<Q> getUnit(Class<Q> clazz) {
        return Units.get(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Unit<?>> getUnits() {
        if (Units.initialized) {
            UnitRegistry unitRegistry = this;
            synchronized (unitRegistry) {
                if (this.units == null) {
                    this.units = new HashSet();
                    for (Object object : HARD_CODED.values()) {
                        if (!(object instanceof AbstractUnit)) continue;
                        AbstractUnit abstractUnit = (AbstractUnit)object;
                        if ((abstractUnit.scope & this.includes) == 0) continue;
                        this.units.add(abstractUnit);
                    }
                    this.units = Collections.unmodifiableSet(this.units);
                }
            }
        }
        return this.units;
    }

    public Set<Unit<?>> getUnits(Dimension dimension) {
        ArgumentChecks.ensureNonNull("dimension", dimension);
        HashSet hashSet = new HashSet();
        for (Unit<?> unit : this.getUnits()) {
            if (!dimension.equals(unit.getDimension())) continue;
            hashSet.add(unit);
        }
        return hashSet;
    }
}

