
package Paws::EC2::GetFlowLogsIntegrationTemplate;
  use Moose;
  has ConfigDeliveryS3DestinationArn => (is => 'ro', isa => 'Str', required => 1);
  has DryRun => (is => 'ro', isa => 'Bool');
  has FlowLogId => (is => 'ro', isa => 'Str', required => 1);
  has IntegrateServices => (is => 'ro', isa => 'Paws::EC2::IntegrateServices', traits => ['NameInRequest'], request_name => 'IntegrateService' , required => 1);

  use MooseX::ClassAttribute;

  class_has _api_call => (isa => 'Str', is => 'ro', default => 'GetFlowLogsIntegrationTemplate');
  class_has _returns => (isa => 'Str', is => 'ro', default => 'Paws::EC2::GetFlowLogsIntegrationTemplateResult');
  class_has _result_key => (isa => 'Str', is => 'ro');
1;

### main pod documentation begin ###

=head1 NAME

Paws::EC2::GetFlowLogsIntegrationTemplate - Arguments for method GetFlowLogsIntegrationTemplate on L<Paws::EC2>

=head1 DESCRIPTION

This class represents the parameters used for calling the method GetFlowLogsIntegrationTemplate on the
L<Amazon Elastic Compute Cloud|Paws::EC2> service. Use the attributes of this class
as arguments to method GetFlowLogsIntegrationTemplate.

You shouldn't make instances of this class. Each attribute should be used as a named argument in the call to GetFlowLogsIntegrationTemplate.

=head1 SYNOPSIS

    my $ec2 = Paws->service('EC2');
    my $GetFlowLogsIntegrationTemplateResult =
      $ec2->GetFlowLogsIntegrationTemplate(
      ConfigDeliveryS3DestinationArn => 'MyString',
      FlowLogId                      => 'MyVpcFlowLogId',
      IntegrateServices              => {
        AthenaIntegrations => [
          {
            IntegrationResultS3DestinationArn => 'MyString',
            PartitionLoadFrequency            =>
              'none',    # values: none, daily, weekly, monthly
            PartitionEndDate   => '1970-01-01T01:00:00',    # OPTIONAL
            PartitionStartDate => '1970-01-01T01:00:00',    # OPTIONAL
          },
          ...
        ],    # min: 1, max: 10; OPTIONAL
      },
      DryRun => 1,    # OPTIONAL
      );

    # Results:
    my $Result = $GetFlowLogsIntegrationTemplateResult->Result;

    # Returns a L<Paws::EC2::GetFlowLogsIntegrationTemplateResult> object.

Values for attributes that are native types (Int, String, Float, etc) can passed as-is (scalar values). Values for complex Types (objects) can be passed as a HashRef. The keys and values of the hashref will be used to instance the underlying object.
For the AWS API documentation, see L<https://docs.aws.amazon.com/goto/WebAPI/ec2/GetFlowLogsIntegrationTemplate>

=head1 ATTRIBUTES


=head2 B<REQUIRED> ConfigDeliveryS3DestinationArn => Str

To store the CloudFormation template in Amazon S3, specify the location
in Amazon S3.



=head2 DryRun => Bool

Checks whether you have the required permissions for the action,
without actually making the request, and provides an error response. If
you have the required permissions, the error response is
C<DryRunOperation>. Otherwise, it is C<UnauthorizedOperation>.



=head2 B<REQUIRED> FlowLogId => Str

The ID of the flow log.



=head2 B<REQUIRED> IntegrateServices => L<Paws::EC2::IntegrateServices>

Information about the service integration.




=head1 SEE ALSO

This class forms part of L<Paws>, documenting arguments for method GetFlowLogsIntegrationTemplate in L<Paws::EC2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

