package Locales::DB::Territory::ewo;

use strict;
use warnings;

# Auto generated from CLDR
use if $Locales::_UNICODE_STRINGS, 'utf8';

$Locales::DB::Territory::ewo::VERSION = '0.09';

$Locales::DB::Territory::ewo::cldr_version = '2.0';

%Locales::DB::Territory::ewo::code_to_name = (
    '001' => 'World',
    '002' => 'Africa',
    '003' => "North\ America",
    '005' => "South\ America",
    '009' => 'Oceania',
    '011' => "Western\ Africa",
    '013' => "Central\ America",
    '014' => "Eastern\ Africa",
    '015' => "Northern\ Africa",
    '017' => "Middle\ Africa",
    '018' => "Southern\ Africa",
    '019' => 'Americas',
    '021' => "Northern\ America",
    '029' => 'Caribbean',
    '030' => "Eastern\ Asia",
    '034' => "Southern\ Asia",
    '035' => "South\-Eastern\ Asia",
    '039' => "Southern\ Europe",
    '053' => "Australia\ and\ New\ Zealand",
    '054' => 'Melanesia',
    '057' => "Micronesian\ Region",
    '061' => 'Polynesia',
    '062' => "South\-Central\ Asia",
    142   => 'Asia',
    143   => "Central\ Asia",
    145   => "Western\ Asia",
    150   => 'Europe',
    151   => "Eastern\ Europe",
    154   => "Northern\ Europe",
    155   => "Western\ Europe",
    172   => "Commonwealth\ of\ Independent\ States",
    200   => 'Czechoslovakia',
    419   => "Latin\ America",
    830   => "Channel\ Islands",
    'ac'  => "Ascension\ Island",
    'ad'  => 'Andór',
    'ae'  => "Bemirá\ yá\ Arábǝ\ uní",
    'af'  => 'Afǝganisǝtán',
    'ag'  => "Antígwa\ ai\ Barǝbúda",
    'ai'  => 'Angíyǝ',
    'al'  => 'Alǝbánia',
    'am'  => 'Arǝménia',
    'an'  => "Anǝtíyǝ\ Nɛdǝlánia",
    'ao'  => 'Angolá',
    'aq'  => 'Antarctica',
    'ar'  => 'Arǝhenǝtína',
    'as'  => "Bǝsamóa\ yá\ Amǝ́rǝka",
    'at'  => 'Osǝtǝlía',
    'au'  => 'Osǝtǝlalí',
    'aw'  => 'Arúba',
    'ax'  => "\Ã\land\ Islands",
    'az'  => 'Azɛrǝbaidzáŋ',
    'ba'  => "Bosǝní\ ai\ ɛrǝzegovín",
    'bb'  => 'Barǝbád',
    'bd'  => 'Bangaladɛ́s',
    'be'  => 'Bɛlǝhíg',
    'bf'  => "Bulǝkiná\ Fasó",
    'bg'  => 'Bulǝgarí',
    'bh'  => 'Bahǝrɛ́n',
    'bi'  => 'Burundí',
    'bj'  => 'Bǝníŋ',
    'bl'  => "Saint\ Barth\Ã\©lemy",
    'bm'  => 'Bɛrǝmúd',
    'bn'  => 'Buluné',
    'bo'  => 'Bolívia',
    'bq'  => "British\ Antarctic\ Territory",
    'br'  => 'Bǝlazíl',
    'bs'  => 'Bahámas',
    'bt'  => 'Butáŋ',
    'bv'  => "Bouvet\ Island",
    'bw'  => 'Botswaná',
    'by'  => 'Bǝlarús',
    'bz'  => 'Bǝlís',
    'ca'  => 'kanadá',
    'cc'  => "Cocos\ \[Keeling\]\ Islands",
    'cd'  => "ǹnam\ Kongó\ Demokǝlatíg",
    'cf'  => "ǹnam\ Zǎŋ\ Afiriká",
    'cg'  => 'Kongó',
    'ch'  => 'Suís',
    'ci'  => "Kód\ Divɔ́r",
    'ck'  => "Minlán\ Mí\ kúg",
    'cl'  => 'Tsilí',
    'cm'  => 'Kamǝrún',
    'cn'  => 'Tsáina',
    'co'  => 'Kolɔmbí',
    'cp'  => "Clipperton\ Island",
    'cr'  => "Kosta\ Ríka",
    'cs'  => "Sɛrǝbí\-ai\-Mɔntenégǝlo",
    'ct'  => "Canton\ and\ Enderbury\ Islands",
    'cu'  => 'Kubá',
    'cv'  => "Minlán\ Mí\ Káb\ Vɛr",
    'cx'  => "Christmas\ Island",
    'cy'  => 'Sipǝlús',
    'cz'  => "Ǹnam\ Tsɛ́g",
    'dd'  => "East\ Germany",
    'de'  => 'Ndzáman',
    'dg'  => "Diego\ Garcia",
    'dj'  => 'Dzibutí',
    'dk'  => 'Danǝmárǝg',
    'dm'  => 'Dómǝnika',
    'do'  => "République\ dominicaine",
    'dz'  => 'Alǝyéria',
    'ea'  => "Ceuta\ and\ Melilla",
    'ec'  => 'Ekwatór',
    'ee'  => 'Esetoní',
    'eg'  => 'Ehíbǝtɛn',
    'eh'  => "Western\ Sahara",
    'er'  => 'Elitǝlé',
    'es'  => 'Kpǝnyá',
    'et'  => 'Etiopí',
    'eu'  => "European\ Union",
    'fi'  => 'Finǝlán',
    'fj'  => 'Fidzí',
    'fk'  => "Minlán\ Mi\ Fólǝkǝlan",
    'fm'  => 'Mikoronésia',
    'fo'  => "Faroe\ Islands",
    'fq'  => "French\ Southern\ and\ Antarctic\ Territories",
    'fr'  => 'Fulɛnsí',
    'fx'  => "Metropolitan\ France",
    'ga'  => 'Gabóŋ',
    'gb'  => "Ǹnam\ Engǝlis",
    'gd'  => 'Gǝlǝnádǝ',
    'ge'  => 'Horǝ́yia',
    'gf'  => "Guyán\ yá\ Fulɛnsí",
    'gg'  => 'Guernsey',
    'gh'  => 'Ganá',
    'gi'  => 'Yilǝbalatár',
    'gl'  => 'Goelán',
    'gm'  => 'Gambí',
    'gn'  => 'Giné',
    'gp'  => 'Guadǝlúb',
    'gq'  => "Giné\ Ekwató",
    'gr'  => 'Gǝlɛ́s',
    'gs'  => "South\ Georgia\ and\ the\ South\ Sandwich\ Islands",
    'gt'  => 'Guatemalá',
    'gu'  => 'Guám',
    'gw'  => "Giné\ Bisaó",
    'gy'  => 'Guyán',
    'hk'  => "Hong\ Kong",
    'hm'  => "Heard\ Island\ and\ McDonald\ Islands",
    'hn'  => 'Ondurás',
    'hr'  => 'Kǝlowásia',
    'ht'  => 'Aití',
    'hu'  => 'Ongirí',
    'ic'  => "Canary\ Islands",
    'id'  => 'ɛndonésia',
    'ie'  => 'Irǝlándǝ',
    'il'  => 'Isǝraɛ́l',
    'im'  => "Isle\ of\ Man",
    'in'  => 'ɛ́ndǝ',
    'io'  => "ǹnam\ ɛngǝlís\ yá\ Máŋ\ mǝ́\ ɛ́ndǝ",
    'iq'  => 'Irág',
    'ir'  => 'Irán',
    'is'  => 'Isǝlándǝ',
    'it'  => 'Itáliɛn',
    'je'  => 'Jersey',
    'jm'  => 'Hamaíka',
    'jo'  => 'Horǝdaní',
    'jp'  => 'Hapɔ́n',
    'jt'  => "Johnston\ Island",
    'ke'  => 'Keniá',
    'kg'  => 'Kirigisǝtán',
    'kh'  => 'kambodía',
    'ki'  => 'Kiribatí',
    'km'  => 'Komɔ́r',
    'kn'  => "Ǹfúfúb\-Kilisǝtóv\-ai\-Nevis",
    'kp'  => "Koré\ yá\ Nór",
    'kr'  => "Koré\ yá\ Súd",
    'kw'  => 'Kowɛ́d',
    'ky'  => "Minlán\ Mí\ Kalimáŋ",
    'kz'  => 'Kazakǝtáŋ',
    'la'  => 'Laós',
    'lb'  => 'Libáŋ',
    'lc'  => "Ǹfúfúb\-Lúsia",
    'li'  => 'Lísǝ́sǝ́táin',
    'lk'  => "Sǝri\ Laŋká",
    'lr'  => 'Libéria',
    'ls'  => 'Lǝsotó',
    'lt'  => 'Lituaní',
    'lu'  => 'Lukǝzambúd',
    'lv'  => 'Lǝtoní',
    'ly'  => 'Libí',
    'ma'  => 'Marɔ́g',
    'mc'  => 'Mɔnakó',
    'md'  => 'Molǝdaví',
    'me'  => 'Montenegro',
    'mf'  => "Saint\ Martin",
    'mg'  => 'Madagasǝkárǝ',
    'mh'  => "Minlán\ Mí\ Maresál",
    'mi'  => "Midway\ Islands",
    'mk'  => 'Masedónia',
    'ml'  => 'Malí',
    'mm'  => 'Mianǝmár',
    'mn'  => 'Mɔngɔ́lia',
    'mo'  => 'Macau',
    'mp'  => "Minlán\ Mi\ Marián\ yá\ Nór",
    'mq'  => 'Marǝtiníg',
    'mr'  => 'Moritaní',
    'ms'  => 'Mɔ́ntserád',
    'mt'  => 'Málǝtǝ',
    'mu'  => 'Morís',
    'mv'  => 'Malǝdívǝ',
    'mw'  => 'Malawí',
    'mx'  => 'Mɛkǝsíg',
    'my'  => 'Malɛ́zia',
    'mz'  => 'Mozambíg',
    'na'  => 'Namibí',
    'nc'  => "Ǹkpámɛn\ Kaledónia",
    'ne'  => 'Nihɛ́r',
    'nf'  => "Minlán\ Nɔrǝfɔ́lǝkǝ",
    'ng'  => 'Nihéria',
    'ni'  => 'Nikarágua',
    'nl'  => 'Pɛíbá',
    'no'  => 'Nɔrǝvɛ́s',
    'np'  => 'Nepál',
    'nq'  => "Dronning\ Maud\ Land",
    'nr'  => 'Naurú',
    'nt'  => "Neutral\ Zone",
    'nu'  => 'Niué',
    'nz'  => "Ǹkpámɛn\ Zeláŋ",
    'om'  => 'Omán',
    'pa'  => 'Panamá',
    'pc'  => "Pacific\ Islands\ Trust\ Territory",
    'pe'  => 'Perú',
    'pf'  => "Polinesí\ yá\ Fulɛnsí",
    'pg'  => "Papwazi\ yá\ Ǹkpámɛ́n\ Giné",
    'ph'  => 'Filipín',
    'pk'  => 'Pakisǝtán',
    'pl'  => 'fólis',
    'pm'  => "Ǹfúfúb\-Píɛr\-ai\-Mikǝlɔ́ŋ",
    'pn'  => 'Pítǝ́kɛ́rɛnǝ',
    'pr'  => "Pwɛrǝto\ Ríko",
    'ps'  => "Ǹnam\ Palɛsǝtín",
    'pt'  => 'fɔrǝtugɛ́s',
    'pu'  => "U\.S\.\ Miscellaneous\ Pacific\ Islands",
    'pw'  => 'Palau',
    'py'  => 'Paragué',
    'pz'  => "Panama\ Canal\ Zone",
    'qa'  => 'Katár',
    'qo'  => "Outlying\ Oceania",
    're'  => 'Reuniɔ́ŋ',
    'ro'  => 'Rumaní',
    'rs'  => 'Serbia',
    'ru'  => 'Rúsian',
    'rw'  => 'Ruwandá',
    'sa'  => "Arabí\ Saudí",
    'sb'  => "Minlán\ Mí\ Solomɔ́n",
    'sc'  => 'Sɛsɛ́l',
    'sd'  => 'Sudáŋ',
    'se'  => 'Suwɛ́d',
    'sg'  => 'Singapúr',
    'sh'  => "Ǹfúfúb\-Ɛlɛ́na",
    'si'  => 'Sǝlovénia',
    'sj'  => "Svalbard\ and\ Jan\ Mayen",
    'sk'  => 'Sǝlovakí',
    'sl'  => "Sierá\-leónǝ",
    'sm'  => "Ǹfúfúb\ Maríno",
    'sn'  => 'Senegál',
    'so'  => 'Somália',
    'sr'  => 'Surinám',
    'st'  => "Saó\ Tomé\ ai\ Pǝlinǝsípe",
    'su'  => "Union\ of\ Soviet\ Socialist\ Republics",
    'sv'  => 'Salǝvadór',
    'sy'  => 'Sirí',
    'sz'  => 'Swazilándǝ',
    'ta'  => "Tristan\ da\ Cunha",
    'tc'  => "Minlán\ Mí\ túrǝ́g\-ai\-Kaíg",
    'td'  => 'Tsád',
    'tf'  => "French\ Southern\ Territories",
    'tg'  => 'Togó',
    'th'  => 'Tailán',
    'tj'  => 'Tadzikisǝtáŋ',
    'tk'  => 'Tokeló',
    'tl'  => 'Timôr',
    'tm'  => 'Turǝkǝmǝnisǝtáŋ',
    'tn'  => 'Tunisí',
    'to'  => 'Tɔngá',
    'tr'  => 'Turǝkí',
    'tt'  => "Tǝlinité\-ai\-Tobágo",
    'tv'  => 'Tuvalú',
    'tw'  => 'Taiwán',
    'tz'  => 'Taŋǝzaní',
    'ua'  => 'Ukǝrɛ́n',
    'ug'  => 'Ugandá',
    'um'  => "U\.S\.\ Minor\ Outlying\ Islands",
    'us'  => "Ǹnam\ Amɛrǝkǝ",
    'uy'  => 'Urugué',
    'uz'  => 'Uzubekisǝtán',
    'va'  => "Ǹnam\ Vatikán",
    'vc'  => "Ǹfúfúb\-Vɛngǝsáŋ\-ai\-Bǝ\ Gǝlǝnadín",
    'vd'  => "North\ Vietnam",
    've'  => 'Venezuéla',
    'vg'  => "ńnam\ Minlán\ ɛ́ngǝlís",
    'vi'  => "Minlán\ Mi\ Amɛrǝkǝ",
    'vn'  => 'Viɛdǝnám',
    'vu'  => 'Vanuátu',
    'wf'  => "Walís\-ai\-Futúna",
    'wk'  => "Wake\ Island",
    'ws'  => 'Samoá',
    'yd'  => "People\â\\s\ Democratic\ Republic\ of\ Yemen",
    'ye'  => 'Yemɛ́n',
    'yt'  => 'Mayɔ́d',
    'za'  => "Afiríka\ yá\ Súd",
    'zm'  => 'Zambí',
    'zw'  => 'Zimbabwé',
    'zz'  => "Unknown\ Region",
);

%Locales::DB::Territory::ewo::name_to_code = (
    'afiríkayásúd'                           => 'za',
    'africa'                                    => '002',
    'afǝganisǝtán'                           => 'af',
    'aití'                                     => 'ht',
    'alǝbánia'                                => 'al',
    'alǝyéria'                                => 'dz',
    'americas'                                  => '019',
    'andór'                                    => 'ad',
    'angolá'                                   => 'ao',
    'angíyǝ'                                  => 'ai',
    'antarctica'                                => 'aq',
    'antígwaaibarǝbúda'                      => 'ag',
    'anǝtíyǝnɛdǝlánia'                    => 'an',
    'arabísaudí'                              => 'sa',
    'arúba'                                    => 'aw',
    'arǝhenǝtína'                            => 'ar',
    'arǝménia'                                => 'am',
    'ascensionisland'                           => 'ac',
    'asia'                                      => 142,
    'australiaandnewzealand'                    => '053',
    'azɛrǝbaidzáŋ'                          => 'az',
    'bahámas'                                  => 'bs',
    'bahǝrɛ́n'                               => 'bh',
    'bangaladɛ́s'                             => 'bd',
    'barǝbád'                                 => 'bb',
    'bemiráyáarábǝuní'                     => 'ae',
    'bolívia'                                  => 'bo',
    'bosǝníaiɛrǝzegovín'                   => 'ba',
    'botswaná'                                 => 'bw',
    'bouvetisland'                              => 'bv',
    'britishantarcticterritory'                 => 'bq',
    'buluné'                                   => 'bn',
    'bulǝgarí'                                => 'bg',
    'bulǝkináfasó'                           => 'bf',
    'burundí'                                  => 'bi',
    'butáŋ'                                   => 'bt',
    'bǝlarús'                                 => 'by',
    'bǝlazíl'                                 => 'br',
    'bǝlís'                                   => 'bz',
    'bǝníŋ'                                  => 'bj',
    'bǝsamóayáamǝ́rǝka'                   => 'as',
    'bɛlǝhíg'                                => 'be',
    'bɛrǝmúd'                                => 'bm',
    'canaryislands'                             => 'ic',
    'cantonandenderburyislands'                 => 'ct',
    'caribbean'                                 => '029',
    'centralamerica'                            => '013',
    'centralasia'                               => 143,
    'ceutaandmelilla'                           => 'ea',
    'channelislands'                            => 830,
    'christmasisland'                           => 'cx',
    'clippertonisland'                          => 'cp',
    'cocoskeelingislands'                       => 'cc',
    'commonwealthofindependentstates'           => 172,
    'czechoslovakia'                            => 200,
    'danǝmárǝg'                              => 'dk',
    'diegogarcia'                               => 'dg',
    'dronningmaudland'                          => 'nq',
    'dzibutí'                                  => 'dj',
    'dómǝnika'                                => 'dm',
    'easternafrica'                             => '014',
    'easternasia'                               => '030',
    'easterneurope'                             => 151,
    'eastgermany'                               => 'dd',
    'ehíbǝtɛn'                               => 'eg',
    'ekwatór'                                  => 'ec',
    'elitǝlé'                                 => 'er',
    'esetoní'                                  => 'ee',
    'etiopí'                                   => 'et',
    'europe'                                    => 150,
    'europeanunion'                             => 'eu',
    'faroeislands'                              => 'fo',
    'fidzí'                                    => 'fj',
    'filipín'                                  => 'ph',
    'finǝlán'                                 => 'fi',
    'frenchsouthernandantarcticterritories'     => 'fq',
    'frenchsouthernterritories'                 => 'tf',
    'fulɛnsí'                                 => 'fr',
    'fólis'                                    => 'pl',
    'fɔrǝtugɛ́s'                            => 'pt',
    'gabóŋ'                                   => 'ga',
    'gambí'                                    => 'gm',
    'ganá'                                     => 'gh',
    'giné'                                     => 'gn',
    'ginébisaó'                               => 'gw',
    'ginéekwató'                              => 'gq',
    'goelán'                                   => 'gl',
    'guadǝlúb'                                => 'gp',
    'guatemalá'                                => 'gt',
    'guernsey'                                  => 'gg',
    'guyán'                                    => 'gy',
    'guyányáfulɛnsí'                        => 'gf',
    'guám'                                     => 'gu',
    'gǝlǝnádǝ'                              => 'gd',
    'gǝlɛ́s'                                 => 'gr',
    'hamaíka'                                  => 'jm',
    'hapɔ́n'                                  => 'jp',
    'heardislandandmcdonaldislands'             => 'hm',
    'hongkong'                                  => 'hk',
    'horǝdaní'                                => 'jo',
    'horǝ́yia'                                => 'ge',
    'irág'                                     => 'iq',
    'irán'                                     => 'ir',
    'irǝlándǝ'                               => 'ie',
    'isleofman'                                 => 'im',
    'isǝlándǝ'                               => 'is',
    'isǝraɛ́l'                               => 'il',
    'itáliɛn'                                 => 'it',
    'jersey'                                    => 'je',
    'johnstonisland'                            => 'jt',
    'kambodía'                                 => 'kh',
    'kamǝrún'                                 => 'cm',
    'kanadá'                                   => 'ca',
    'katár'                                    => 'qa',
    'kazakǝtáŋ'                              => 'kz',
    'keniá'                                    => 'ke',
    'kiribatí'                                 => 'ki',
    'kirigisǝtán'                             => 'kg',
    'kolɔmbí'                                 => 'co',
    'komɔ́r'                                  => 'km',
    'kongó'                                    => 'cg',
    'koréyánór'                              => 'kp',
    'koréyásúd'                              => 'kr',
    'kostaríka'                                => 'cr',
    'kowɛ́d'                                  => 'kw',
    'kpǝnyá'                                  => 'es',
    'kubá'                                     => 'cu',
    'kóddivɔ́r'                              => 'ci',
    'kǝlowásia'                               => 'hr',
    'latinamerica'                              => 419,
    'laós'                                     => 'la',
    'libáŋ'                                   => 'lb',
    'libéria'                                  => 'lr',
    'libí'                                     => 'ly',
    'lituaní'                                  => 'lt',
    'lukǝzambúd'                              => 'lu',
    'lísǝ́sǝ́táin'                        => 'li',
    'lǝsotó'                                  => 'ls',
    'lǝtoní'                                  => 'lv',
    'macau'                                     => 'mo',
    'madagasǝkárǝ'                           => 'mg',
    'malawí'                                   => 'mw',
    'malí'                                     => 'ml',
    'malǝdívǝ'                               => 'mv',
    'malɛ́zia'                                => 'my',
    'marǝtiníg'                               => 'mq',
    'marɔ́g'                                  => 'ma',
    'masedónia'                                => 'mk',
    'mayɔ́d'                                  => 'yt',
    'melanesia'                                 => '054',
    'metropolitanfrance'                        => 'fx',
    'mianǝmár'                                => 'mm',
    'micronesianregion'                         => '057',
    'middleafrica'                              => '017',
    'midwayislands'                             => 'mi',
    'mikoronésia'                              => 'fm',
    'minlánmiamɛrǝkǝ'                       => 'vi',
    'minlánmifólǝkǝlan'                     => 'fk',
    'minlánmimariányánór'                   => 'mp',
    'minlánmíkalimáŋ'                       => 'ky',
    'minlánmíkábvɛr'                        => 'cv',
    'minlánmíkúg'                            => 'ck',
    'minlánmímaresál'                        => 'mh',
    'minlánmísolomɔ́n'                      => 'sb',
    'minlánmítúrǝ́gaikaíg'                => 'tc',
    'minlánnɔrǝfɔ́lǝkǝ'                  => 'nf',
    'molǝdaví'                                => 'md',
    'montenegro'                                => 'me',
    'moritaní'                                 => 'mr',
    'morís'                                    => 'mu',
    'mozambíg'                                 => 'mz',
    'málǝtǝ'                                 => 'mt',
    'mɔnakó'                                  => 'mc',
    'mɔngɔ́lia'                              => 'mn',
    'mɔ́ntserád'                             => 'ms',
    'mɛkǝsíg'                                => 'mx',
    'namibí'                                   => 'na',
    'naurú'                                    => 'nr',
    'ndzáman'                                  => 'de',
    'nepál'                                    => 'np',
    'neutralzone'                               => 'nt',
    'nihéria'                                  => 'ng',
    'nihɛ́r'                                  => 'ne',
    'nikarágua'                                => 'ni',
    'niué'                                     => 'nu',
    'northamerica'                              => '003',
    'northernafrica'                            => '015',
    'northernamerica'                           => '021',
    'northerneurope'                            => 154,
    'northvietnam'                              => 'vd',
    'nɔrǝvɛ́s'                              => 'no',
    'oceania'                                   => '009',
    'omán'                                     => 'om',
    'ondurás'                                  => 'hn',
    'ongirí'                                   => 'hu',
    'osǝtǝlalí'                              => 'au',
    'osǝtǝlía'                               => 'at',
    'outlyingoceania'                           => 'qo',
    'pacificislandstrustterritory'              => 'pc',
    'pakisǝtán'                               => 'pk',
    'palau'                                     => 'pw',
    'panamacanalzone'                           => 'pz',
    'panamá'                                   => 'pa',
    'papwaziyáǸkpámɛ́nginé'               => 'pg',
    'paragué'                                  => 'py',
    "people\â\\sdemocraticrepublicofyemen" => 'yd',
    'perú'                                     => 'pe',
    'polinesíyáfulɛnsí'                     => 'pf',
    'polynesia'                                 => '061',
    'pwɛrǝtoríko'                            => 'pr',
    'pítǝ́kɛ́rɛnǝ'                       => 'pn',
    'pɛíbá'                                  => 'nl',
    'reuniɔ́ŋ'                               => 're',
    'rumaní'                                   => 'ro',
    'ruwandá'                                  => 'rw',
    'républiquedominicaine'                    => 'do',
    'rúsian'                                   => 'ru',
    "saintbarth\Ã\©lemy"                      => 'bl',
    'saintmartin'                               => 'mf',
    'salǝvadór'                               => 'sv',
    'samoá'                                    => 'ws',
    'saótoméaipǝlinǝsípe'                  => 'st',
    'senegál'                                  => 'sn',
    'serbia'                                    => 'rs',
    'sieráleónǝ'                             => 'sl',
    'singapúr'                                 => 'sg',
    'sipǝlús'                                 => 'cy',
    'sirí'                                     => 'sy',
    'somália'                                  => 'so',
    'southamerica'                              => '005',
    'southcentralasia'                          => '062',
    'southeasternasia'                          => '035',
    'southernafrica'                            => '018',
    'southernasia'                              => '034',
    'southerneurope'                            => '039',
    'southgeorgiaandthesouthsandwichislands'    => 'gs',
    'sudáŋ'                                   => 'sd',
    'surinám'                                  => 'sr',
    'suwɛ́d'                                  => 'se',
    'suís'                                     => 'ch',
    'svalbardandjanmayen'                       => 'sj',
    'swazilándǝ'                              => 'sz',
    'sǝlovakí'                                => 'sk',
    'sǝlovénia'                               => 'si',
    'sǝrilaŋká'                              => 'lk',
    'sɛrǝbíaimɔntenégǝlo'                 => 'cs',
    'sɛsɛ́l'                                 => 'sc',
    'tadzikisǝtáŋ'                           => 'tj',
    'tailán'                                   => 'th',
    'taiwán'                                   => 'tw',
    'taŋǝzaní'                               => 'tz',
    'timôr'                                    => 'tl',
    'togó'                                     => 'tg',
    'tokeló'                                   => 'tk',
    'tristandacunha'                            => 'ta',
    'tsilí'                                    => 'cl',
    'tsád'                                     => 'td',
    'tsáina'                                   => 'cn',
    'tunisí'                                   => 'tn',
    'turǝkí'                                  => 'tr',
    'turǝkǝmǝnisǝtáŋ'                     => 'tm',
    'tuvalú'                                   => 'tv',
    'tǝlinitéaitobágo'                       => 'tt',
    'tɔngá'                                   => 'to',
    "u\.s\.minoroutlyingislands"                => 'um',
    "u\.s\.miscellaneouspacificislands"         => 'pu',
    'ugandá'                                   => 'ug',
    'ukǝrɛ́n'                                => 'ua',
    'unionofsovietsocialistrepublics'           => 'su',
    'unknownregion'                             => 'zz',
    'urugué'                                   => 'uy',
    'uzubekisǝtán'                            => 'uz',
    'vanuátu'                                  => 'vu',
    'venezuéla'                                => 've',
    'viɛdǝnám'                               => 'vn',
    'wakeisland'                                => 'wk',
    'walísaifutúna'                           => 'wf',
    'westernafrica'                             => '011',
    'westernasia'                               => 145,
    'westerneurope'                             => 155,
    'westernsahara'                             => 'eh',
    'world'                                     => '001',
    'yemɛ́n'                                  => 'ye',
    'yilǝbalatár'                             => 'gi',
    'zambí'                                    => 'zm',
    'zimbabwé'                                 => 'zw',
    "\Ã\landislands"                         => 'ax',
    'ńnamminlánɛ́ngǝlís'                  => 'vg',
    'Ǹfúfúbkilisǝtóvainevis'               => 'kn',
    'Ǹfúfúblúsia'                           => 'lc',
    'Ǹfúfúbmaríno'                          => 'sm',
    'Ǹfúfúbpíɛraimikǝlɔ́ŋ'             => 'pm',
    'Ǹfúfúbvɛngǝsáŋaibǝgǝlǝnadín'    => 'vc',
    'ǸfúfúbƐlɛ́na'                        => 'sh',
    'Ǹkpámɛnkaledónia'                      => 'nc',
    'Ǹkpámɛnzeláŋ'                         => 'nz',
    'Ǹnamamɛrǝkǝ'                           => 'us',
    'Ǹnamengǝlis'                             => 'gb',
    'Ǹnampalɛsǝtín'                         => 'ps',
    'Ǹnamtsɛ́g'                              => 'cz',
    'Ǹnamvatikán'                             => 'va',
    'ǹnamkongódemokǝlatíg'                  => 'cd',
    'ǹnamzǎŋafiriká'                        => 'cf',
    'ǹnamɛngǝlísyámáŋmǝ́ɛ́ndǝ'      => 'io',
    'ɛndonésia'                               => 'id',
    'ɛ́ndǝ'                                  => 'in',
);

1;

