;; NOTE: Assertions have been generated by update_lit_checks.py --all-items and should not be edited.

;; If asked to, we rename the conflicts. The second "func" export will become
;; "func_1".
;; RUN: wasm-merge %s first %s.second second --rename-export-conflicts -S -o - | filecheck %s --check-prefix RENAME

;; If asked to, we can skip conflicting exports from later modules. The second
;; "func" export will not exist.
;; RUN: wasm-merge %s first %s.second second --skip-export-conflicts -S -o - | filecheck %s --check-prefix SKIP_C

(module
  ;; RENAME:      (type $0 (func))

  ;; RENAME:      (export "func" (func $func0))

  ;; RENAME:      (export "func_1" (func $func1))

  ;; RENAME:      (export "other" (func $func2))

  ;; RENAME:      (func $func0
  ;; RENAME-NEXT:  (drop
  ;; RENAME-NEXT:   (i32.const 0)
  ;; RENAME-NEXT:  )
  ;; RENAME-NEXT: )
  ;; SKIP_C:      (type $0 (func))

  ;; SKIP_C:      (export "func" (func $func0))

  ;; SKIP_C:      (export "other" (func $func2))

  ;; SKIP_C:      (func $func0
  ;; SKIP_C-NEXT:  (drop
  ;; SKIP_C-NEXT:   (i32.const 0)
  ;; SKIP_C-NEXT:  )
  ;; SKIP_C-NEXT: )
  (func $func0 (export "func")
    ;; This export also appears in the second module.
    (drop
      (i32.const 0)
    )
  )
)
;; RENAME:      (func $func1
;; RENAME-NEXT:  (drop
;; RENAME-NEXT:   (i32.const 1)
;; RENAME-NEXT:  )
;; RENAME-NEXT: )

;; RENAME:      (func $func2
;; RENAME-NEXT:  (drop
;; RENAME-NEXT:   (i32.const 2)
;; RENAME-NEXT:  )
;; RENAME-NEXT: )

;; SKIP_C:      (func $func2
;; SKIP_C-NEXT:  (drop
;; SKIP_C-NEXT:   (i32.const 2)
;; SKIP_C-NEXT:  )
;; SKIP_C-NEXT: )
