/*
 * CLOUD API
 *
 * IONOS Enterprise-grade Infrastructure as a Service (IaaS) solutions can be managed through the Cloud API, in addition or as an alternative to the \"Data Center Designer\" (DCD) browser-based tool.    Both methods employ consistent concepts and features, deliver similar power and flexibility, and can be used to perform a multitude of management tasks, including adding servers, volumes, configuring networks, and so on.
 *
 * API version: 6.0
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package ionoscloud

import (
	"encoding/json"
	"fmt"
)

// NatGatewayRuleProtocol the model 'NatGatewayRuleProtocol'
type NatGatewayRuleProtocol string

// List of NatGatewayRuleProtocol
const (
	TCP  NatGatewayRuleProtocol = "TCP"
	UDP  NatGatewayRuleProtocol = "UDP"
	ICMP NatGatewayRuleProtocol = "ICMP"
	ALL  NatGatewayRuleProtocol = "ALL"
)

func (v *NatGatewayRuleProtocol) UnmarshalJSON(src []byte) error {
	var value string
	err := json.Unmarshal(src, &value)
	if err != nil {
		return err
	}
	enumTypeValue := NatGatewayRuleProtocol(value)
	for _, existing := range []NatGatewayRuleProtocol{"TCP", "UDP", "ICMP", "ALL"} {
		if existing == enumTypeValue {
			*v = enumTypeValue
			return nil
		}
	}

	return fmt.Errorf("%+v is not a valid NatGatewayRuleProtocol", value)
}

// Ptr returns reference to NatGatewayRuleProtocol value
func (v NatGatewayRuleProtocol) Ptr() *NatGatewayRuleProtocol {
	return &v
}

type NullableNatGatewayRuleProtocol struct {
	value *NatGatewayRuleProtocol
	isSet bool
}

func (v NullableNatGatewayRuleProtocol) Get() *NatGatewayRuleProtocol {
	return v.value
}

func (v *NullableNatGatewayRuleProtocol) Set(val *NatGatewayRuleProtocol) {
	v.value = val
	v.isSet = true
}

func (v NullableNatGatewayRuleProtocol) IsSet() bool {
	return v.isSet
}

func (v *NullableNatGatewayRuleProtocol) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableNatGatewayRuleProtocol(val *NatGatewayRuleProtocol) *NullableNatGatewayRuleProtocol {
	return &NullableNatGatewayRuleProtocol{value: val, isSet: true}
}

func (v NullableNatGatewayRuleProtocol) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableNatGatewayRuleProtocol) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
