package nl

import "github.com/olebedev/when/rules"

var All = []rules.Rule{
	Weekday(rules.Override),
	CasualDate(rules.Override),
	CasualTime(rules.Override),
	Hour(rules.Override),
	HourMinute(rules.Override),
	Deadline(rules.Override),
	PastTime(rules.Override),
	ExactMonthDate(rules.Override),
}

var WEEKDAY_OFFSET = map[string]int{
	"zondag":    0,
	"zon":       0,
	"zo":        0,
	"maandag":   1,
	"maa":       1,
	"ma":        1,
	"dinsdag":   2,
	"din":       2,
	"di":        2,
	"woensdag":  3,
	"woe":       3,
	"wo":        3,
	"donderdag": 4,
	"don":       4,
	"do":        4,
	"vrijdag":   5,
	"vrij":      5,
	"vr":        5,
	"zaterdag":  6,
	"zat":       6,
	"za":        6,
}

var WEEKDAY_OFFSET_PATTERN = "(?:zondag|zon|zo|maandag|maa|ma|dinsdag|din|di|woensdag|woe|wo|donderdag|don|do|vrijdag|vrij|vr|zaterdag|zat|za)"

var MONTH_OFFSET = map[string]int{
	"january":   1,
	"jan":       1,
	"jan.":      1,
	"februari":  2,
	"feb":       2,
	"feb.":      2,
	"maart":     3,
	"mrt":       3,
	"mrt.":      3,
	"april":     4,
	"apr":       4,
	"apr.":      4,
	"mei":       5,
	"juni":      6,
	"jun":       6,
	"jun.":      6,
	"juli":      7,
	"jul":       7,
	"jul.":      7,
	"augustus":  8,
	"aug":       8,
	"aug.":      8,
	"september": 9,
	"sep":       9,
	"sep.":      9,
	"sept":      9,
	"sept.":     9,
	"oktober":   10,
	"okt":       10,
	"okt.":      10,
	"november":  11,
	"nov":       11,
	"nov.":      11,
	"december":  12,
	"dec":       12,
	"dec.":      12,
}

var MONTH_OFFSET_PATTERN = `(?:january|jan\.?|februari|feb\.?|maart|mrt\.?|april|apr\.?|mei|juni|jun\.?|juli|jul\.?|augustus|aug\.?|september|sept?\.?|oktober|okt\.?|november|nov\.?|december|dec\.?)`

var INTEGER_WORDS = map[string]int{
	"een":    1,
	"één":    1,
	"twee":   2,
	"drie":   3,
	"vier":   4,
	"vijf":   5,
	"zes":    6,
	"zeven":  7,
	"acht":   8,
	"negen":  9,
	"tien":   10,
	"elf":    11,
	"twaalf": 12,
}

var INTEGER_WORDS_PATTERN = `(?:een|één|twee|drie|vier|vijf|zes|zeven|acht|negen|tien|elf|twaalf)`

var ORDINAL_WORDS = map[string]int{
	"eerste":            1,
	"1e":                1,
	"tweede":            2,
	"2e":                2,
	"derde":             3,
	"3e":                3,
	"vierde":            4,
	"4e":                4,
	"vijfde":            5,
	"5e":                5,
	"zesde":             6,
	"6e":                6,
	"zevende":           7,
	"7e":                7,
	"achtste":           8,
	"8e":                8,
	"negende":           9,
	"9e":                9,
	"tiende":            10,
	"10e":               10,
	"elfde":             11,
	"11e":               11,
	"twaalfde":          12,
	"12e":               12,
	"derdiende":         13,
	"13e":               13,
	"veertiende":        14,
	"14e":               14,
	"vijftiende":        15,
	"15e":               15,
	"zestiende":         16,
	"16e":               16,
	"zeventiende":       17,
	"17e":               17,
	"achttiende":        18,
	"18e":               18,
	"negentiende":       19,
	"19e":               19,
	"twintigste":        20,
	"20e":               20,
	"eenentwintigste":   21,
	"21e":               21,
	"tweeentwintigste":  22,
	"22e":               22,
	"drieentwintigste":  23,
	"23e":               23,
	"vierentwintigste":  24,
	"24e":               24,
	"vijfentwintigste":  25,
	"25e":               25,
	"zesentwintigste":   26,
	"26e":               26,
	"zevenentwintigste": 27,
	"27e":               27,
	"achtentwintigste":  28,
	"28e":               28,
	"negenentwintigste": 29,
	"29e":               29,
	"dertigste":         30,
	"30e":               30,
	"eenendertigste":    31,
	"31e":               31,
}

var ORDINAL_WORDS_PATTERN = `(?:1e|eerste|2e|tweede|3e|derde|4e|vierde|5e|vijfde|6e|zesde|7e|zevende|8e|achtste|9e|negende|10e|tiende|11e|elfde|12e|twaalfde|13e|derdiende|14e|veertiende|15e|vijftiende|16e|zestiende|17e|zeventiende|18e|achttiende|19e|negentiende|20e|twintigste|21e|eenentwintigste|22e|tweeentwintigste|23e|drieentwintigste|24e|vierentwintigste|25e|vijfentwintigste|26e|zesentwintigste|27e|zevenentwintigste|28e|achtentwintigste|29e|negenentwintigste|30e|dertigste|31e|eenendertigste)`
