// model-body.mustache

// licenseInfo.mustache

/**
 * Libre Graph API
 * Libre Graph is a free API for cloud collaboration inspired by the MS Graph API.
 *
 * The version of the OpenAPI document: v1.0.4
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

#include "OAIPermission.h"

#include <QDebug>
#include <QJsonArray>
#include <QJsonDocument>
#include <QObject>

#include "OAIHelpers.h"

namespace OpenAPI {

class OAIPermissionPrivate {
    friend class OAIPermission;

     QDateTime expiration_date_time;
     bool expiration_date_time_isSet;
     bool expiration_date_time_isValid;

     QList<OAIIdentitySet> granted_to_identities;
     bool granted_to_identities_isSet;
     bool granted_to_identities_isValid;

     QList<QString> roles;
     bool roles_isSet;
     bool roles_isValid;
};

OAIPermission::OAIPermission()
    : d_ptr()
{
}

OAIPermission::OAIPermission(const OAIPermission& other)
    : d_ptr(other.d_ptr)
{
}

OAIPermission::OAIPermission(QString json)
    : d_ptr(nullptr)
{
    this->fromJson(json);
}

OAIPermission::~OAIPermission() = default;

void OAIPermission::initializeModel() {
    if (d_ptr == nullptr) {
        d_ptr.reset(new OAIPermissionPrivate{});

        Q_D(OAIPermission);


        d->expiration_date_time_isSet = false;
        d->expiration_date_time_isValid = false;

        d->granted_to_identities_isSet = false;
        d->granted_to_identities_isValid = false;

        d->roles_isSet = false;
        d->roles_isValid = false;
    }
}

void OAIPermission::fromJson(QString jsonString) {
    QByteArray array(jsonString.toUtf8());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonObject jsonObject = doc.object();
    this->fromJsonObject(jsonObject);
}

void OAIPermission::fromJsonObject(QJsonObject json) {
    initializeModel();

    Q_D(OAIPermission);

    d->expiration_date_time_isValid = ::OpenAPI::fromJsonValue(d->expiration_date_time, json[QString("expirationDateTime")]);
    d->expiration_date_time_isSet = !json[QString("expirationDateTime")].isNull() && d->expiration_date_time_isValid;

    d->granted_to_identities_isValid = ::OpenAPI::fromJsonValue(d->granted_to_identities, json[QString("grantedToIdentities")]);
    d->granted_to_identities_isSet = !json[QString("grantedToIdentities")].isNull() && d->granted_to_identities_isValid;

    d->roles_isValid = ::OpenAPI::fromJsonValue(d->roles, json[QString("roles")]);
    d->roles_isSet = !json[QString("roles")].isNull() && d->roles_isValid;
}

QString OAIPermission::asJson() const {
    QJsonObject obj = this->asJsonObject();
    QJsonDocument doc(obj);
    QByteArray bytes = doc.toJson();
    return QString(bytes);
}

QJsonObject OAIPermission::asJsonObject() const {
    Q_D(const OAIPermission);
    if(!d){
        return {};
    }
    QJsonObject obj;
    if (d->expiration_date_time_isSet) {
        obj.insert(QString("expirationDateTime"), ::OpenAPI::toJsonValue(d->expiration_date_time));
    }
    if (d->granted_to_identities.size() > 0) {
        obj.insert(QString("grantedToIdentities"), ::OpenAPI::toJsonValue(d->granted_to_identities));
    }
    if (d->roles.size() > 0) {
        obj.insert(QString("roles"), ::OpenAPI::toJsonValue(d->roles));
    }
    return obj;
}

QDateTime OAIPermission::getExpirationDateTime() const {
    Q_D(const OAIPermission);
    if(!d){
        return {};
    }
    return d->expiration_date_time;
}
void OAIPermission::setExpirationDateTime(const QDateTime &expiration_date_time) {
    Q_D(OAIPermission);
    Q_ASSERT(d);

    d->expiration_date_time = expiration_date_time;
    d->expiration_date_time_isSet = true;
}

bool OAIPermission::is_expiration_date_time_Set() const{
    Q_D(const OAIPermission);
    if(!d){
        return false;
    }

    return d->expiration_date_time_isSet;
}

bool OAIPermission::is_expiration_date_time_Valid() const{
    Q_D(const OAIPermission);
    if(!d){
        return false;
    }
    return d->expiration_date_time_isValid;
}

QList<OAIIdentitySet> OAIPermission::getGrantedToIdentities() const {
    Q_D(const OAIPermission);
    if(!d){
        return {};
    }
    return d->granted_to_identities;
}
void OAIPermission::setGrantedToIdentities(const QList<OAIIdentitySet> &granted_to_identities) {
    Q_D(OAIPermission);
    Q_ASSERT(d);

    d->granted_to_identities = granted_to_identities;
    d->granted_to_identities_isSet = true;
}

bool OAIPermission::is_granted_to_identities_Set() const{
    Q_D(const OAIPermission);
    if(!d){
        return false;
    }

    return d->granted_to_identities_isSet;
}

bool OAIPermission::is_granted_to_identities_Valid() const{
    Q_D(const OAIPermission);
    if(!d){
        return false;
    }
    return d->granted_to_identities_isValid;
}

QList<QString> OAIPermission::getRoles() const {
    Q_D(const OAIPermission);
    if(!d){
        return {};
    }
    return d->roles;
}
void OAIPermission::setRoles(const QList<QString> &roles) {
    Q_D(OAIPermission);
    Q_ASSERT(d);

    d->roles = roles;
    d->roles_isSet = true;
}

bool OAIPermission::is_roles_Set() const{
    Q_D(const OAIPermission);
    if(!d){
        return false;
    }

    return d->roles_isSet;
}

bool OAIPermission::is_roles_Valid() const{
    Q_D(const OAIPermission);
    if(!d){
        return false;
    }
    return d->roles_isValid;
}

bool OAIPermission::isSet() const {
    Q_D(const OAIPermission);
    if(!d){
        return false;
    }
    bool isObjectUpdated = false;
    do {
        if (d->expiration_date_time_isSet) {
            isObjectUpdated = true;
            break;
        }

        if (d->granted_to_identities.size() > 0) {
            isObjectUpdated = true;
            break;
        }

        if (d->roles.size() > 0) {
            isObjectUpdated = true;
            break;
        }
    } while (false);
    return isObjectUpdated;
}

bool OAIPermission::isValid() const {
    Q_D(const OAIPermission);
    if(!d){
        return false;
    }
    // only required properties are required for the object to be considered valid
    return true;
}

} // namespace OpenAPI
