# collection-map [![NPM version](https://img.shields.io/npm/v/collection-map.svg?style=flat)](https://www.npmjs.com/package/collection-map) [![NPM monthly downloads](https://img.shields.io/npm/dm/collection-map.svg?style=flat)](https://npmjs.org/package/collection-map)  [![NPM total downloads](https://img.shields.io/npm/dt/collection-map.svg?style=flat)](https://npmjs.org/package/collection-map) [![Linux Build Status](https://img.shields.io/travis/jonschlinkert/collection-map.svg?style=flat&label=Travis)](https://travis-ci.org/jonschlinkert/collection-map)

> Returns an array of mapped values from an array or object.

## Install

Install with [npm](https://www.npmjs.com/):

```sh
$ npm install --save collection-map
```

Inspired by the [collections/map](http://moutjs.com/) util in mout.

## Usage

```js
var map = require('collection-map');
```

### objects

```js
var res = map({a: 'foo', b: 'bar', c: 'baz'}, function(item, key, obj) {
  return item;
});
console.log(res);
// => ['foo', 'bar', 'baz']

var res = map({a: 'foo', b: 'bar', c: 'baz'}, function(item, key, obj) {
  return key;
});
console.log(res);
// => ['a', 'b', 'c']
```

### arrays

```js
var res = map(['foo', 'bar', 'baz'], function(item, index, array) {
  return item;
});
console.log(res);
// => ['foo', 'bar', 'baz']

var res = map(['foo', 'bar', 'baz'], function(item, index, array) {
  return index;
});
console.log(res);
// => [0, 1, 2]
```

### strings

A string may be passed as the second argument, for getting properties:

```js
var obj = {
  a: {aaa: 'one', bbb: 'four', ccc: 'seven'},
  b: {aaa: 'two', bbb: 'five', ccc: 'eight'},
  c: {aaa: 'three', bbb: 'six', ccc: 'nine'}
};

console.log(map(obj, 'aaa'));
// => ['one', 'two', 'three']

var array = [obj.a, obj.b, obj.c];
console.log(map(array, 'bbb'));
// => ['four', 'five', 'six']
```

### thisArg

Invocation context may be passed as the last argument.

```js
var array = ['a', 'b', 'c'];
var ctx = {a: 'aaa', b: 'bbb', c: 'ccc'};

var res = map(array, function(item, index, array) {
  return this[item];
}, ctx);

console.log(res);
// => ['aaa', 'bbb', 'ccc']
```

## About

### Related projects

* [arr-flatten](https://www.npmjs.com/package/arr-flatten): Recursively flatten an array or arrays. This is the fastest implementation of array flatten. | [homepage](https://github.com/jonschlinkert/arr-flatten "Recursively flatten an array or arrays. This is the fastest implementation of array flatten.")
* [arr-map](https://www.npmjs.com/package/arr-map): Faster, node.js focused alternative to JavaScript's native array map. | [homepage](https://github.com/jonschlinkert/arr-map "Faster, node.js focused alternative to JavaScript's native array map.")
* [for-in](https://www.npmjs.com/package/for-in): Iterate over the own and inherited enumerable properties of an object, and return an object… [more](https://github.com/jonschlinkert/for-in) | [homepage](https://github.com/jonschlinkert/for-in "Iterate over the own and inherited enumerable properties of an object, and return an object with properties that evaluate to true from the callback. Exit early by returning `false`. JavaScript/Node.js")
* [for-own](https://www.npmjs.com/package/for-own): Iterate over the own enumerable properties of an object, and return an object with properties… [more](https://github.com/jonschlinkert/for-own) | [homepage](https://github.com/jonschlinkert/for-own "Iterate over the own enumerable properties of an object, and return an object with properties that evaluate to true from the callback. Exit early by returning `false`. JavaScript/Node.js.")

### Contributing

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](../../issues/new).

### Building docs

_(This project's readme.md is generated by [verb](https://github.com/verbose/verb-generate-readme), please don't edit the readme directly. Any changes to the readme must be made in the [.verb.md](.verb.md) readme template.)_

To generate the readme, run the following command:

```sh
$ npm install -g verbose/verb#dev verb-generate-readme && verb
```

### Running tests

Running and reviewing unit tests is a great way to get familiarized with a library and its API. You can install dependencies and run tests with the following command:

```sh
$ npm install && npm test
```

### Author

**Jon Schlinkert**

* [github/jonschlinkert](https://github.com/jonschlinkert)
* [twitter/jonschlinkert](https://twitter.com/jonschlinkert)

### License

Copyright © 2017, [Jon Schlinkert](https://github.com/jonschlinkert).
Released under the [MIT License](LICENSE).

***

_This file was generated by [verb-generate-readme](https://github.com/verbose/verb-generate-readme), v0.4.3, on March 02, 2017._