if (typeof T === 'undefined') require('../setup');

T('round', function () {

  function t(expected, n, rm) {
    Decimal.rounding = rm;
    T.assertEqual(expected, new Decimal(n).round().valueOf());
  }

  Decimal.config({
    precision: 20,
    rounding: 4,
    toExpNeg: -7,
    toExpPos: 21,
    minE: -9e15,
    maxE: 9e15
  });

  t('Infinity', 'Infinity', 4);
  t('-Infinity', '-Infinity', 4);
  t('NaN', 'NaN', 4);

  t('0', '0', 4);
  t('-0', '-0', 4);
  t('1', '1', 4);
  t('-1', '-1', 4);
  t('0', '0.1', 4);
  t('-0', '-0.1', 4);
  t('0', '1e-9000000000000000', 4);
  t('-0', '-1e-9000000000000000', 4);
  t('9.999e+9000000000000000', '9.999e+9000000000000000', 4);
  t('-9.999e+9000000000000000', '-9.999e+9000000000000000', 4);

  t('6.88054606464877886407425549768282761571350053022023236e+53', '6.880546064648778864074255497682827615713500530220232351811172615965890936e+53', 0);
  t('9.51833733815343753238388e+23', '9.51833733815343753238387581003146664685764843969081033323613e+23', 5);
  t('4.434086046379498022164479619323e+30', '4.4340860463794980221644796193222113345e+30', 0);
  t('913844451463', '913844451463.2968716291911429329', 4);
  t('4.124227112152123941928547272459545727985864897598835e+51', '4.1242271121521239419285472724595457279858648975988352729535839522490471492602734474826e+51', 3);
  t('4.63429955102358262449651440722058050134341793502231565647729228272e+65', '4.634299551023582624496514407220580501343417935022315656477292282722482758912005500689831e+65', 3);
  t('28923471241', '28923471241.98034587766743552', 1);
  t('4521981137129745', '4521981137129744.67989385131579785422314397', 0);
  t('1.757029854153590067583921300868154608080526623790036985862257948987889309489e+76', '1.7570298541535900675839213008681546080805266237900369858622579489878893094889309687763293350816e+76', 2);
  t('7.92779841419157112811950427049997777808175311282606971649180221573863785195e+74', '7.92779841419157112811950427049997777808175311282606971649180221573863785194619091321130332110043278383964781191e+74', 6);
  t('4.8046702619549660118837319476958242e+34', '4.80467026195496601188373194769582420063536104857816444372396235915e+34', 6);
  t('16604074202686788', '16604074202686787.6', 0);
  t('2.03054429543856309099719183163085279314546339909457784263114937593e+67', '2.0305442954385630909971918316308527931454633990945778426311493759300288903340472095271466713787146011e+67', 1);
  t('30559986845', '30559986844.828104310332245126047', 5);
  t('3.169159034649715925059423431889057069973085990306134577512910339e+63', '3.16915903464971592505942343188905706997308599030613457751291033998309334924157348709083e+63', 1);
  t('2.74536925513947196644678859506681278043361770523611795129e+56', '2.74536925513947196644678859506681278043361770523611795129033731273249555974944131605156319693351e+56', 1);
  t('3.836711661609490207325966566e+27', '3.83671166160949020732596656539593198724761580767321062612029068e+27', 2);
  t('9.5917250469401862241299735910188523300291350099849e+49', '9.591725046940186224129973591018852330029135009984930929359628823555090675843e+49', 3);
  t('21333682', '21333681.9', 0);
  t('8.62022856983460008434772295e+26', '8.62022856983460008434772295e+26', 3);
  t('68042277', '68042276.936331', 4);
  t('4.8750036651483452171308023e+25', '4.875003665148345217130802304e+25', 5);
  t('1.3591935058296677548790388717577585193715249e+43', '1.35919350582966775487903887175775851937152497849507394160868e+43', 1);
  t('4129', '4128.8573915082798234283182739502433923', 2);
  t('6.25825257883805843076111330243671881564726599e+44', '6.2582525788380584307611133024367188156472659814623144865497e+44', 0);
  t('2.073939185723766359554288e+24', '2.0739391857237663595542878001922882482361918639e+24', 6);
  t('5.145015399473362034445178801296467411193767021458e+48', '5.1450153994733620344451788012964674111937670214584134294502818008587093553744e+48', 4);
  t('3.7741249292961331651914274171432415480188820147e+46', '3.7741249292961331651914274171432415480188820147914167e+46', 3);
  t('2.5907197709663090692786288643e+28', '2.59071977096630906927862886428517500364162734e+28', 4);
  t('6.5019848918413133548151232394242295281947013425358575908400718513465e+67', '6.5019848918413133548151232394242295281947013425358575908400718513464661016174107270809281124152327737993e+67', 4);
  t('6.5654656243131424283006345840695185206252e+40', '6.56546562431314242830063458406951852062516491733e+40', 4);
  t('7.14296188550926336386536585191594379995651640918449914847192e+59', '7.1429618855092633638653658519159437999565164091844991484719191390713140556399248288684716160792764e+59', 0);
  t('1.65831307344278205652667503e+26', '1.6583130734427820565266750303412035297508422789795074468453e+26', 3);
  t('1.03868076642005814047021881e+26', '1.038680766420058140470218801950252025537802241e+26', 2);
  t('346', '346.452605374950482582868219', 4);
  t('181439315463425985534', '181439315463425985534.25865844894077275430318757', 3);
  t('8113502102248864193', '8113502102248864193.4', 6);
  t('2.0396642160540139112491673463348213536632845904136202928864236188830882179e+73', '2.0396642160540139112491673463348213536632845904136202928864236188830882178287498700128363702734e+73', 0);
  t('57217688166662318', '57217688166662318.14978073061366795927750180227408203205', 1);
  t('1.3263967367823644477766479033175434612e+37', '1.32639673678236444777664790331754346122524765959079128749150122574912710232e+37', 6);
  t('4.097858435839183181158056560760949599139954068194535406240460058272877614656e+75', '4.0978584358391831811580565607609495991399540681945354062404600582728776146564387e+75', 1);
  t('9.53862376611854437580813e+23', '9.5386237661185443758081265964082575366510636210576058e+23', 2);
  t('9.49667001930609829678887507025575441813606832788e+47', '9.49667001930609829678887507025575441813606832787403591376232279326592e+47', 0);
  t('6.10292467565130496104458878537476362133917639257694305498260179044673420925478e+77', '6.102924675651304961044588785374763621339176392576943054982601790446734209254780222e+77', 6);
  t('1.3569526432875110743338e+22', '1.3569526432875110743338802291960156552161e+22', 1);
  t('37621189552', '37621189552.4548804003545304449', 4);
  t('3.7760257582328104673720218606494623716708788e+43', '3.776025758232810467372021860649462371670878868908226307307668506118232e+43', 1);
  t('7.74525800334839542704379514512194550565400271258796650103830226e+62', '7.745258003348395427043795145121945505654002712587966501038302267977111236789268316426418098716e+62', 1);
  t('6.2644488671934926960298323609173878562204e+40', '6.264448867193492696029832360917387856220314258629579154805116236617047705e+40', 2);
  t('1.1212610202715126696808411919523222015979206841671840577694468e+61', '1.12126102027151266968084119195232220159792068416718405776944683512488141027069261455294944060583439e+61', 4);
  t('14768', '14768.1842134501472446153274412575133', 1);
  t('66', '65.84595269', 4);
  t('5.04358552116975225426776135857493312e+36', '5.0435855211697522542677613585749331194437753499183689199959863339211e+36', 2);
  t('72916866821', '72916866820.54423629685259893346337712794', 5);
  t('2.25398641434088868230960319957704440329914057033993092762174e+59', '2.253986414340888682309603199577044403299140570339930927621742643835298453365292983113173554605e+59', 6);
  t('9.50878709595470892500629632386714322909202072012758393749698817348e+65', '9.508787095954708925006296323867143229092020720127583937496988173481432728097661248708213e+65', 5);
  t('5.2607910472629613651015532597249206745434137969950236424916019135420122e+70', '5.260791047262961365101553259724920674543413796995023642491601913542012227611433312032956077032041978908e+70', 1);
  t('410', '410.762791093715303350001444121070121', 1);
  t('1.3320871624020377318642711553436113e+34', '1.33208716240203773186427115534361135519309237757872381699115467e+34', 1);
  t('6230378575909', '6230378575908.126534764593955', 2);
  t('8.79324953269900537785265055241483017965551931338157086204822343837345e+68', '8.793249532699005377852650552414830179655519313381570862048223438373446168669586851714244432e+68', 0);
  t('7.808570916258060849165e+21', '7.8085709162580608491646e+21', 5);
  t('88', '87.426', 2);
  t('5036', '5035.551403129954', 2);
  t('4.666777096688297335109779706846177431928559905049197884212958955e+63', '4.6667770966882973351097797068461774319285599050491978842129589550252836742465454224095908e+63', 6);
  t('1.3082493338072034134280214605195699691716814374132145e+52', '1.30824933380720341342802146051956996917168143741321444089754461241e+52', 0);
  t('82896368014641073413', '82896368014641073413.127', 3);
  t('3.6759908238598981366541946858543288181344210687261e+49', '3.6759908238598981366541946858543288181344210687260953004e+49', 2);
  t('2554853', '2554853.448817348736141', 5);
  t('7.432653329376812932864567362402827202784593426455497e+51', '7.43265332937681293286456736240282720278459342645549756393442032908961e+51', 1);
  t('4.1376083180004347798256857059806342e+34', '4.13760831800043477982568570598063412322243503351025693e+34', 0);
  t('2.81639743586035847441737607898e+29', '2.816397435860358474417376078971272140333871184e+29', 2);
  t('3.33308755377081894459518719001618476646619e+41', '3.33308755377081894459518719001618476646619345374865441860199004e+41', 4);
  t('861198584370', '861198584370.487', 1);
  t('58138545', '58138545.527841812778081669334', 3);
  t('9.1299443667780696881942861253757909197956397717814491253e+55', '9.12994436677806968819428612537579091979563977178144912531e+55', 1);
  t('4.39311758031073540977322723016501396453173282821704760525204945353983876096252e+77', '4.39311758031073540977322723016501396453173282821704760525204945353983876096251821769058876287518283551757703348408464e+77', 2);
  t('3.2974115909070248542274425313413005934211172865969028889e+55', '3.297411590907024854227442531341300593421117286596902888853804228063794921468e+55', 2);
  t('54', '53.34398845927930853307662313597656146', 0);
  t('15636384601748303', '15636384601748302.9811', 2);
  t('2.3043720261427013162485e+22', '2.3043720261427013162485531143187502464942974003324599e+22', 1);
  t('581057837085', '581057837085.65123531004522490062077436676334724089', 3);
  t('797366496337', '797366496337.6718190234426526346293683404803880987062', 1);
  t('4.285881357494659223685e+21', '4.285881357494659223685e+21', 6);
  t('9.132045135982774098345e+21', '9.13204513598277409834525940084399290647033372055570535606505e+21', 4);
  t('1.11669335324060757880756755605946384713132737403413e+50', '1.1166933532406075788075675560594638471313273740341292905922955935106577859270853666e+50', 5);
  t('3.23832893865411943993037855346860219715891545114e+47', '3.238328938654119439930378553468602197158915451147002264725e+47', 3);
  t('7.40310708864509274393878672061390994720684311147946750446044572e+62', '7.4031070886450927439387867206139099472068431114794675044604457234765307070001457084110726e+62', 1);
  t('3.68965336119015432161651754041004e+32', '3.68965336119015432161651754041003908937708794285e+32', 2);
  t('90783322754206050', '90783322754206049.35035', 2);
  t('4.783897483734883940914066109558172639368953766427218188058842e+60', '4.783897483734883940914066109558172639368953766427218188058842519826992028703726005242207628819478632e+60', 3);
  t('8.74642362004856279856821278562300234968553e+41', '8.7464236200485627985682127856230023496855266153880604628901734609882681e+41', 4);
  t('2.787528073145134085377480268092975211744788266156563860706325e+60', '2.787528073145134085377480268092975211744788266156563860706324907236200247422339482e+60', 0);
  t('9.044749264159923044896e+21', '9.0447492641599230448952113830135543025323624505592e+21', 0);
  t('3.38724858450634217020878619249322e+32', '3.3872485845063421702087861924932165998628685152854e+32', 5);
  t('7.33035174941232251216660134923e+32', '7.33035174941232251216660134923000387370975884e+32', 3);
  t('3.31861301560113994278653457913815811504895843883387949739855080482136508e+71', '3.318613015601139942786534579138158115048958438833879497398550804821365076078023599771341067964e+71', 2);
  t('4.892538135085055040561465460077728050505789433e+45', '4.892538135085055040561465460077728050505789433039013e+45', 3);
  t('3.480927423683982545690946611905582393906288848845e+48', '3.4809274236839825456909466119055823939062888488451700237682978275240792e+48', 6);
  t('8.5585370645750825066579e+22', '8.5585370645750825066579059239556661179388558223611585366682692e+22', 5);
  t('2.8106502332881758642573040950398356187983397721051055759182e+58', '2.810650233288175864257304095039835618798339772105105575918210150772785811e+58', 4);
  t('7.953951085584591494904819e+25', '7.9539510855845914949048190132594822824626976317642169018875166767e+25', 5);
  t('5012920663454824', '5012920663454823.94', 4);
  t('9.059308645970286362603799e+24', '9.059308645970286362603799e+24', 4);
  t('2.930381009176059877391197659254717127145084478e+45', '2.93038100917605987739119765925471712714508447815186763294045321221268221587573e+45', 1);
  t('3.93979729202599788234456028398138395381138418403803935560263301961568e+68', '3.939797292025997882344560283981383953811384184038039355602633019615681383938905911925353290603787e+68', 5);
  t('3.347294783804407389536880406224847102831717725051604392715997e+60', '3.3472947838044073895368804062248471028317177250516043927159970180531e+60', 1);
  t('4.152557275792933219421015403627280983623385245443758047431e+57', '4.1525572757929332194210154036272809836233852454437580474305470338495945e+57', 4);
  t('2.568943282775480373543498502026413633372529080072386778478497168e+63', '2.56894328277548037354349850202641363337252908007238677847849716763891609585410420915975309606355e+63', 2);
  t('8.684093992464956330645701447343516418e+36', '8.684093992464956330645701447343516417923741184554719792596139808816571956653e+36', 5);
  t('5.83803824336815109774392e+23', '5.838038243368151097743916928821585630595573416851e+23', 0);
  t('4.99449017842808893066894421324882543343399403548140337811028587e+62', '4.994490178428088930668944213248825433433994035481403378110285871375e+62', 1);
  t('4.3792711449156782662938969897476619220638522535235560693017440318235650762880312e+79', '4.379271144915678266293896989747661922063852253523556069301744031823565076288031203e+79', 6);
  t('1.64836570856055370302116821082684227150215611327936660631e+57', '1.6483657085605537030211682108268422715021561132793666063097975046239608762642599531985480246e+57', 4);
  t('3.6880029140410668344606480164489384e+34', '3.68800291404106683446064801644893833152881384958720719932324749064e+34', 2);
  t('5.37691884604259144480804415625800887790938772497524135e+53', '5.376918846042591444808044156258008877909387724975241352981212067476945435681674020225105e+53', 3);
  t('7.1995513358058164351942e+22', '7.199551335805816435194169107730917957459e+22', 5);
  t('55248039093404', '55248039093404.6273291498305797535238516736182191', 3);
  t('6.419830543451423871631416632166320919709e+39', '6.41983054345142387163141663216632091970977470919817409169e+39', 3);
  t('47', '46.679687957019966', 5);
  t('8.846171889181456596809377139e+27', '8.8461718891814565968093771394637497527855234030610736533458882022e+27', 5);
  t('9494812039339485', '9494812039339484.66504814190507971', 2);
  t('9.568743436371491059070139104936123822e+36', '9.568743436371491059070139104936123822153171585452165317540885e+36', 4);
  t('6.218950733005184405477309653091850341440038341422433362937950160976e+66', '6.218950733005184405477309653091850341440038341422433362937950160975956092596313331825e+66', 2);
  t('8.3184242277151497735548563861150757508026e+40', '8.318424227715149773554856386115075750802554724068866714143812e+40', 5);
  t('44238479', '44238479.45577788940469598821356176', 5);
  t('2037', '2037.823568704255455386618400409335477', 3);
  t('5.436649951976429287545774447705520810310093287073075e+51', '5.436649951976429287545774447705520810310093287073074686050425310198538528694387158388e+51', 6);
  t('37738994177', '37738994177', 5);
  t('9.117326071348610688176527980615463581736346164592577593e+54', '9.11732607134861068817652798061546358173634616459257759341133852768832521419919626360171e+54', 5);
  t('6.084920955300075178735187946364763863e+36', '6.08492095530007517873518794636476386223409771383197420966e+36', 2);
  t('8.522483763341817511064e+21', '8.5224837633418175110636e+21', 2);
  t('8089235072415301', '8089235072415301.5407182501479888352094914490764', 3);
  t('6588524', '6588524.3302879765427617637496749722', 4);
  t('6.48949404289677464226944079045203282327984360168518221116940520131007087e+71', '6.48949404289677464226944079045203282327984360168518221116940520131007086776011881e+71', 5);
  t('4.66758032658209403400328094282546162268665050304684900737759e+59', '4.6675803265820940340032809428254616226866505030468490073775840892679e+59', 0);
  t('3.8228501778813845182718352582392492990500025013409025197209162241766597698593466e+79', '3.82285017788138451827183525823924929905000250134090251972091622417665976985934664e+79', 3);
  t('1.48107423197776804105574657092158563e+36', '1.48107423197776804105574657092158563064846301871291470178376174e+36', 3);
  t('687436488212973', '687436488212972.3776181461101284022701451638', 0);
  t('1.3723738401752233053350007148932102e+34', '1.37237384017522330533500071489321018e+34', 4);
  t('7.62478294482680439921089600929940725974552200617448002491e+56', '7.6247829448268043992108960092994072597455220061744800249106939240528761312396549902e+56', 4);
  t('85960397435', '85960397434.6658395', 4);
  t('2.763384545224304050146832313739655508577774027132280259541365597279123017482e+75', '2.763384545224304050146832313739655508577774027132280259541365597279123017482371912033266310613516271663e+75', 5);
  t('3807642124967812864', '3807642124967812863.11134193333490873646020100055', 2);
  t('6.70427065774694862425851113103666872565875637413102437053e+57', '6.704270657746948624258511131036668725658756374131024370529849179417160857194136e+57', 2);
  t('5.847413670589089981708716357368937643792827522e+45', '5.8474136705890899817087163573689376437928275218768e+45', 0);
  t('8.05036521767882485190836e+23', '8.0503652176788248519083693278838868065648e+23', 1);
  t('2.388213850732309089626300468433832206510001e+42', '2.38821385073230908962630046843383220651000054e+42', 5);
  t('8.650286818819557970446473110946463648974025293138e+48', '8.65028681881955797044647311094646364897402529313791495118107976573745115e+48', 4);
  t('1.06125356153442428148614416928268031052670523838e+47', '1.06125356153442428148614416928268031052670523837841483302500724891691386968e+47', 5);
  t('6.051458835569184364025914e+24', '6.0514588355691843640259134539571989823409365353609022460399600829e+24', 2);
  t('5255333', '5255332.88023478522156979504635801765441542', 5);
  t('6.6440556280518454677778e+23', '6.64405562805184546777779589612592222e+23', 4);
  t('933398330878877265', '933398330878877264.71837776272423433960446407792842', 5);
  t('1.646563999089466617840308582e+27', '1.6465639990894666178403085828775007164048968602872689633441291356e+27', 3);
  t('2.04071424062649763402922072340235937591717327451273251540381e+59', '2.04071424062649763402922072340235937591717327451273251540381641481881855e+59', 1);
  t('6.207910504118590442964e+21', '6.20791050411859044296423935427955051266259547322838791883672e+21', 5);
  t('8.43012542075846388096939598702013e+32', '8.43012542075846388096939598702013178561e+32', 6);
  t('32973411322', '32973411322.0055', 1);
  t('7.41694510786524937341518027227253887932818592426915463600522309825048431e+71', '7.416945107865249373415180272272538879328185924269154636005223098250484307079446594739006612417e+71', 2);
  t('6', '5.9619856716250354871335057', 2);
  t('87527', '87526.63684823518483851567239869752', 4);
  t('9.763022525200483641130669988156219e+34', '9.763022525200483641130669988156219073728900962111054931e+34', 3);
  t('8.6185312763805220809689217680237306487385577826341538e+52', '8.61853127638052208096892176802373064873855778263415380693587684e+52', 6);
  t('8.45360239012103000688834251686727e+33', '8.45360239012103000688834251686726987255777523693637285554668319e+33', 0);
  t('2518723195860416961', '2518723195860416961.1285010663484912294197393809044612', 1);
  t('2.685500253120233156790885090189119970660485355223415640469844965503956949e+72', '2.6855002531202331567908850901891199706604853552234156404698449655039569485280575699687713e+72', 2);
  t('220453411', '220453411.8828467378639975405350886112158605', 1);
  t('4.85547756175076698605434224480862417426276770270709846574910398927491662348382e+77', '4.85547756175076698605434224480862417426276770270709846574910398927491662348381810254102042363e+77', 2);
  t('706', '705.772547316850746', 6);
  t('7.922244228553676441225996043345713795845944777e+45', '7.92224422855367644122599604334571379584594477725845245459550132153e+45', 1);
  t('5.2423675401973461629044e+22', '5.242367540197346162904370934159243342332619e+22', 5);
  t('18030585831906130', '18030585831906130.962417491553869302', 1);
  t('9.1579489825538072699342096635557184539890411086285024230055732e+61', '9.1579489825538072699342096635557184539890411086285024230055732145647118262972725923e+61', 1);
  t('85226070565187', '85226070565186.749650937595330322325285761974396', 0);
  t('5.8026252767502790532863416020671786591156722564880455114e+55', '5.80262527675027905328634160206717865911567225648804551136391722488e+55', 5);
  t('2.4218610164284422911400259009366691043836e+40', '2.4218610164284422911400259009366691043835892289395393055927142431986156068766091e+40', 2);
  t('9.06687520914843144090853802874797707391234306e+44', '9.066875209148431440908538028747977073912343061e+44', 4);
  t('9.277380564234452159463923699924423033503589164006560028593034039059e+66', '9.2773805642344521594639236999244230335035891640065600285930340390595049193598441e+66', 3);
  t('8.128082895667773893079564235647181e+33', '8.128082895667773893079564235647180709738816611273e+33', 0);
  t('36', '36.956949377301', 1);
  t('1.87389296164121983463708427608894171918413437553511848334553945494023535764718e+77', '1.873892961641219834637084276088941719184134375535118483345539454940235357647177900767e+77', 6);
  t('17310978329', '17310978328.5287351707255015885210716726522112', 6);
  t('9.2600219512947966032033927978963555790720436638836388e+52', '9.260021951294796603203392797896355579072043663883638828801926062258412645086313910012864e+52', 4);
  t('14575632844', '14575632843.9255237386639144', 4);
  t('6.6321582910691070759469809878367695902421451930245389e+52', '6.6321582910691070759469809878367695902421451930245388163039e+52', 0);
  t('7.25572991620854492306001e+23', '7.25572991620854492306000246e+23', 2);
  t('2.29944904912666115204337635383054709834656882596225337344e+56', '2.299449049126661152043376353830547098346568825962253373445377477443437271765291716e+56', 1);
  t('5.20558341173907182519017950869849925033417917e+44', '5.205583411739071825190179508698499250334179162775097e+44', 0);
  t('6111649076', '6111649076.222604966937070801102488363059341', 6);
  t('9.11024271273341770350822200927358669721049157581569029e+53', '9.11024271273341770350822200927358669721049157581569028990662687474e+53', 0);
  t('4.43687659677981757715075653509475056586153598815659143662113577e+62', '4.43687659677981757715075653509475056586153598815659143662113577090918204e+62', 3);
  t('248', '247.654291674654270796798279', 4);
  t('4.3600875972057143805604498896639034411838346245016392883967078243062789210025219e+79', '4.3600875972057143805604498896639034411838346245016392883967078243062789210025219430426344800669971036134643124803e+79', 3);
  t('1.03007021065884639208787111225352947659134e+41', '1.03007021065884639208787111225352947659134e+41', 5);
  t('6.6928769403416121328026875807e+28', '6.69287694034161213280268758078544463630255731257270872775864425e+28', 3);
  t('32434285307875262', '32434285307875262.2207922459899301806', 6);
  t('62748749332151342301', '62748749332151342301.19244', 5);
  t('4.0678262988827413231899e+22', '4.06782629888274132318985446914450533e+22', 2);
  t('9082662703546', '9082662703546.324370805591057', 6);
  t('8.94871836341303529473698033715697e+32', '8.9487183634130352947369803371569600373840782e+32', 0);
  t('2.1670379409405843366171258653978628564316145348035311924089e+58', '2.1670379409405843366171258653978628564316145348035311924089239541816857773897563368575797031936041e+58', 6);
  t('2935893', '2935892.87182124', 2);
  t('4.37578044122813627924254711867936993527178454e+44', '4.375780441228136279242547118679369935271784531302743e+44', 0);
  t('6.39286534756971472039e+21', '6.39286534756971472038980039416071834909341307858e+21', 6);
  t('4.18258479181585354438902084125374066e+35', '4.182584791815853544389020841253740662e+35', 3);
  t('2.9635549088358495388694647078277775625649e+40', '2.96355490883584953886946470782777756256487239375833003125e+40', 0);
  t('9.199438690858434123332123544047e+30', '9.19943869085843412333212354404671487370041239840183084655999684e+30', 4);
  t('3.29539383367054908280466428e+26', '3.2953938336705490828046642886489630335793970083516425663e+26', 1);
  t('5.4864050382187254727117788923745e+31', '5.48640503821872547271177889237442590120046642432614e+31', 2);
  t('6.72291657980520450527702159742964874909944380115207127826868e+59', '6.7229165798052045052770215974296487490994438011520712782686756677317729908042785747274547904999e+59', 5);
  t('6.4199675010715062595232405405532880703928738044906019996020105471838488933611956e+79', '6.41996750107150625952324054055328807039287380449060199960201054718384889336119552687e+79', 0);
  t('8.49573393504083151850167234209249202511578741027519908816390028552e+65', '8.495733935040831518501672342092492025115787410275199088163900285521533395797589e+65', 5);
  t('1.5955208479300521845981764334575800052437447146562787571491109848403080783e+73', '1.59552084793005218459817643345758000524374471465627875714911098484030807828997023018004378599828e+73', 0);
  t('6.036649336201741152293032410301018575e+36', '6.036649336201741152293032410301018575309192634222268026610553981547335341134e+36', 3);
  t('8.2206171209610808188838e+22', '8.220617120961080818883809546397772352053067497822e+22', 1);
  t('357067001617476243862', '357067001617476243862.137169321', 4);
  t('3648', '3648.935966276480770486703829', 3);
  t('3667256', '3667256.14321901053142272931937401084036', 3);
  t('3.06817804911202488565210058368288435840855617967301618918521966618918e+68', '3.06817804911202488565210058368288435840855617967301618918521966618918898694871236138832751471925640291008e+68', 1);
  t('6.397956949401398212866287356127033102182339663673964891147500216e+63', '6.3979569494013982128662873561270331021823396636739648911475002160201253259767111914786e+63', 6);
  t('4.035852629664930971748714986884026499248056376602e+49', '4.03585262966493097174871498688402649924805637660190057197207752443783928e+49', 0);
  t('690938', '690937.205492020637017366344964341683031', 2);
  t('4572785807971', '4572785807970.2685726', 0);
  t('9.12591556752170002546686195712080775076927539494357342e+53', '9.12591556752170002546686195712080775076927539494357342095192221318809927523394869766948859999e+53', 6);
  t('3.175166710121609964935909273257064925241534e+43', '3.175166710121609964935909273257064925241533921325823763693547e+43', 2);
  t('8.6981262273677133498099001368854630216532260172495845284342e+59', '8.6981262273677133498099001368854630216532260172495845284341969645697018865379917639005276e+59', 5);
  t('5.43909171309351447662743501782820255783778421662946112946990882360329e+68', '5.4390917130935144766274350178282025578377842166294611294699088236032838010825005751271e+68', 0);
  t('9.784135122662915564368384002663201291592977201175859415877628841e+63', '9.784135122662915564368384002663201291592977201175859415877628841445610051468229986e+63', 3);
  t('1.075926913120789044066114677747282911808323013538262852302400311648e+66', '1.0759269131207890440661146777472829118083230135382628523024003116470855e+66', 0);
  t('24', '24.009013648289204609707762701', 4);
  t('8.75619449783486902827580978677238339353807302997843705455206849896e+65', '8.7561944978348690282758097867723833935380730299784370545520684989674681468898373241422734005491e+65', 3);
  t('49185', '49185.42432350042440262481433144719', 3);
  t('475313129', '475313128.81802828668961', 0);
  t('5.966160504823907616078866600887399441996553619375546697015e+57', '5.96616050482390761607886660088739944199655361937554669701500365941215e+57', 3);
  t('8.67093818828233413993699849118457718482116385647241974416e+56', '8.6709381882823341399369984911845771848211638564724197441644559865e+56', 3);
  t('4.018307218209746175224522445986860839987164456492973969349e+58', '4.0183072182097461752245224459868608399871644564929739693489418729882986617019584512013283e+58', 0);

  t('4965078', '4965077.956955313373056935621', 2);
  t('6.32074464844040699391589694212584145237969644385445479e+53', '6.320744648440406993915896942125841452379696443854454787303226e+53', 4);
  t('2.630018093200468445909344327503187558812e+39', '2.63001809320046844590934432750318755881276774e+39', 1);
  t('5.9845994166628691963626788515044007024791069617050073781932631068e+64', '5.98459941666286919636267885150440070247910696170500737819326310684179e+64', 3);
  t('5.38788728618099476057660664795230746327516453731e+47', '5.38788728618099476057660664795230746327516453730723672718211491484463437612544615e+47', 5);
  t('5.816680772652537833886113306215842146722035445468511689872171309392e+66', '5.816680772652537833886113306215842146722035445468511689872171309391615108203036895388894202315e+66', 4);
  t('5.14951895405085032556822954571292087413665571538603148148092264951e+66', '5.1495189540508503255682295457129208741366557153860314814809226495101085411721086436447394e+66', 6);
  t('9.38071154248816610903159656235010365e+35', '9.38071154248816610903159656235010365457924684058e+35', 6);
  t('4.6192344120951390457511809260028977897911933273960342542075621554585705e+70', '4.619234412095139045751180926002897789791193327396034254207562155458570425292193318612e+70', 0);
  t('895', '895.42468256229', 4);
  t('4.49593629458007552251945193855124924788525290643178e+50', '4.4959362945800755225194519385512492478852529064317781769525204246314622e+50', 5);
  t('1.57561665415364001696709e+23', '1.575616654153640016967093563564651371666e+23', 4);
  t('9.5119206433900111282160111340222123761771472865509429834e+55', '9.51192064339001112821601113402221237617714728655094298342579e+55', 1);
  t('2.8705511287442274153174451865706904160604287523337828148634483123671245935117e+77', '2.87055112874422741531744518657069041606042875233378281486344831236712459351170440769052264237721532651856136663e+77', 4);
  t('7.34188971833045579480780836481104523190936e+41', '7.3418897183304557948078083648110452319093625282376588007189862745851161e+41', 6);
  t('7.8608372491686434746950705553718082749885371792704000800225593187312714063278e+76', '7.860837249168643474695070555371808274988537179270400080022559318731271406327753488333027e+76', 4);
  t('6.469775389199626982124099675993476e+34', '6.46977538919962698212409967599347606034988957766173192337753531700792e+34', 3);
  t('5.8545430675082317385046601147591350320748593523353867726685748e+61', '5.8545430675082317385046601147591350320748593523353867726685748416216417718e+61', 6);
  t('6253581', '6253581.49602122273536242131464028542', 4);
  t('8.7344751925490789359100991e+25', '8.7344751925490789359100990700674856026086725e+25', 0);
  t('3.9904601157326518550436849417943739334793e+40', '3.990460115732651855043684941794373933479342900084994082134338812305943386e+40', 3);
  t('7.117509805619442000811625308308028306e+36', '7.11750980561944200081162530830802830605763083615357319229708510119793e+36', 4);
  t('239', '239.6', 1);
  t('6.583584600606673632872593433278933533220316054467200967095949640912736824225e+75', '6.5835846006066736328725934332789335332203160544672009670959496409127368242248629713e+75', 5);
  t('3.695920981918849753532424768925832178720483413e+45', '3.69592098191884975353242476892583217872048341388978498358e+45', 3);
  t('2', '1.3037831777620558701769453039973469', 0);
  t('8.209369008504729502003611908929598068593e+40', '8.209369008504729502003611908929598068593e+40', 6);
  t('1.7943552590764773563109836e+26', '1.79435525907647735631098360862158965291e+26', 1);
  t('8.27389970382499192225882435e+26', '8.273899703824991922258824345580491438304434418276176349396745658e+26', 5);
  t('462561608456627', '462561608456627.001777', 3);
  t('8.1839600623408782869984730140049576888373907446562596320788904262169763785362e+77', '8.183960062340878286998473014004957688837390744656259632078890426216976378536205007147403782e+77', 3);
  t('6.703769389175962220793e+21', '6.703769389175962220792067880359735732888123800491e+21', 0);
  t('2.5585369539549659010966714135825828801369980436910644884291291e+61', '2.5585369539549659010966714135825828801369980436910644884291291234042228005022238e+61', 5);
  t('4.71355729812843325551825190733754692238411906900564645150190008e+62', '4.71355729812843325551825190733754692238411906900564645150190007430239409925817447e+62', 2);
  t('8.743778229459959593062156414403742568639029e+42', '8.74377822945995959306215641440374256863902836579411682005851e+42', 2);
  t('9.4610942886126267215813230206813878133108628300770338213090890302608873805945795e+79', '9.4610942886126267215813230206813878133108628300770338213090890302608873805945795171504245711910393542869912e+79', 6);
  t('9.637007602803820224674484773388404422058784394922216256468207851098e+66', '9.637007602803820224674484773388404422058784394922216256468207851097102844188166040233086965888060242247e+66', 0);
  t('9.8929084923535343669756305730610829040131245900415500369e+55', '9.89290849235353436697563057306108290401312459004155003684864835083512265034512297039071425988079e+55', 2);
  t('227029338743263', '227029338743263.93013322884665944911687839', 1);
  t('9556', '9555.702815788750539915212443558755764', 0);
  t('7.5777656953887385271106133131169037438362239623169e+49', '7.57776569538873852711061331311690374383622396231687000596e+49', 6);
  t('6.682104529462952632410838e+24', '6.682104529462952632410837641372635268045881966538e+24', 2);
  t('3.40490212059506016256377925738958571721640636153e+47', '3.404902120595060162563779257389585717216406361520888558246387332e+47', 2);
  t('6.02441364429381327260741367276985467068046371110897032865165337e+62', '6.0244136442938132726074136727698546706804637111089703286516533653471194692722610656609e+62', 4);
  t('2.5313651653786498793153255734290103587e+37', '2.53136516537864987931532557342901035878757668609321327884376561077398262963e+37', 1);
  t('7.85665005570333663657093714469705934e+35', '7.856650055703336636570937144697059336863289133308185e+35', 0);
  t('177640526141789', '177640526141788.343225172293525', 2);
  t('3.720337371189052622074943e+25', '3.720337371189052622074942921963398883266421248541e+25', 2);
  t('8.6313749672631505000804724190451538529154319985775036960071751534597975400579e+76', '8.631374967263150500080472419045153852915431998577503696007175153459797540057885204939257359487066282718539447e+76', 5);
  t('6.0093917332950477604948831161021364170792508830154947009e+55', '6.0093917332950477604948831161021364170792508830154947009e+55', 0);
  t('8.039856561515957202207593997063010720427567987067604601e+54', '8.03985656151595720220759399706301072042756798706760460081115e+54', 5);
  t('9.04126850298381168011568888913120103322736027748100982152669106905664e+68', '9.04126850298381168011568888913120103322736027748100982152669106905663196e+68', 0);
  t('32970', '32969.86013043774999017900493233800251808807', 4);
  t('4.062501613145928449827898996803197068849565543663154887810367223956097172358e+75', '4.06250161314592844982789899680319706884956554366315488781036722395609717235882712303074126e+75', 1);
  t('1.2585221051341615760113300656136097763123689416096518235274048137047508960225e+76', '1.2585221051341615760113300656136097763123689416096518235274048137047508960224444402424065809722365e+76', 0);
  t('76428498', '76428498.00834040050622904', 3);
  t('2969542081490470842', '2969542081490470842.2873874609960997776387424601', 1);
  t('1.83915362194670915529649750389183e+32', '1.83915362194670915529649750389183e+32', 3);
  t('9.051934488304764732260681809870433413368e+39', '9.05193448830476473226068180987043341336894274162300324775666234e+39', 1);
  t('5.5055581168379212453472842196419487578340912520119781134168481302943305e+70', '5.5055581168379212453472842196419487578340912520119781134168481302943304427006511738950093684489283497e+70', 2);
  t('7.8212509096600498185673448363795561801e+38', '7.82125090966004981856734483637955618009925616349415607657138464833290636076e+38', 4);
  t('3.0546982208479323109313411268e+28', '3.05469822084793231093134112688982335665368647631e+28', 1);
  t('48401191701190454916', '48401191701190454915.87020458175288248919360841887713552', 0);
  t('2.112204187292732553586397374536644222038661332931779202378403e+60', '2.1122041872927325535863973745366442220386613329317792023784031e+60', 4);
  t('2.32345597459570075584924011046569282105626864293765776e+53', '2.3234559745957007558492401104656928210562686429376577553656111494e+53', 6);
  t('6.83768634613093432910405748169502361694478922e+45', '6.8376863461309343291040574816950236169447892199728904351925720243118213615618093e+45', 5);
  t('9.750147130105570610532123362958045378e+36', '9.750147130105570610532123362958045378979179715926704377695369e+36', 3);
  t('2.100861289861071804337e+22', '2.10086128986107180433695930143316811637333008279165590263448e+22', 4);
  t('6.86043620730137169613692822530112725634606192506087063665162541409521357214042e+77', '6.8604362073013716961369282253011272563460619250608706366516254140952135721404168108626834814070528e+77', 4);
  t('1.5626034555461789267637613119509784678795467574624046084113e+59', '1.562603455546178926763761311950978467879546757462404608411306911462258050600025152315054266e+59', 1);
  t('8.1657953379518384767073891983969032e+34', '8.1657953379518384767073891983969032197860059203770678016940796429163e+34', 5);
  t('8.76242761957079783283256884156570096310765263e+44', '8.762427619570797832832568841565700963107652628626208374880873465683235356e+44', 4);
  t('5.738034559825558584827988487e+27', '5.738034559825558584827988486842333820461031439008871488489056012e+27', 0);
  t('50057554472467', '50057554472467.164635378107751829995761049170916', 1);
  t('2.217574620839810044488132284149156661898910087838684414107246055650497e+69', '2.217574620839810044488132284149156661898910087838684414107246055650497247127025575756749e+69', 4);
  t('2.5599585974649223224327226161115338826053171794370023977e+55', '2.559958597464922322432722616111533882605317179437002397792613551347e+55', 3);
  t('1.43014821461134396323079197376e+29', '1.43014821461134396323079197376075503936831895045225252422372849704547e+29', 3);
  t('9.70966118807833422956644722296756129766012276425821843096979556875e+65', '9.70966118807833422956644722296756129766012276425821843096979556875029e+65', 6);
  t('4.916533296743126969789915322e+27', '4.916533296743126969789915322e+27', 0);
  t('4.833542905767501913532472382036762424309928346865656598315910513985992546e+72', '4.83354290576750191353247238203676242430992834686565659831591051398599254568346115e+72', 0);
  t('1.3278316562805597179325e+22', '1.32783165628055971793246463003781572653917e+22', 5);
  t('5.02347253856796475647466e+23', '5.02347253856796475647466193e+23', 5);
  t('13871', '13871', 4);
  t('2.25474388246375890069616800777e+29', '2.254743882463758900696168007764489438567545789666275279171902946e+29', 0);
  t('1.02187732311006848174021155848981225371768135e+44', '1.0218773231100684817402115584898122537176813528139488791683036875150612463985e+44', 1);
  t('2909342', '2909342.4238780677375', 4);
  t('5.63252321267098810926174933800717e+32', '5.6325232126709881092617493380071648e+32', 2);
  t('5.23553453532019073853926210509049935358952607844215638892068535879e+65', '5.2355345353201907385392621050904993535895260784421563889206853587945892297422658429e+65', 4);
  t('5.0110191100309032508871028312215600979e+37', '5.0110191100309032508871028312215600979641138288229618389443889e+37', 3);
  t('4.7961858399681660804352167135837851113655618745113e+50', '4.796185839968166080435216713583785111365561874511295798100202049598678690552e+50', 0);
  t('3.6413072083209667611577984e+25', '3.64130720832096676115779843247079245446941280671681175325417221e+25', 3);
  t('2.83439430931506652088137802242984878152446095843660682602522650389e+65', '2.83439430931506652088137802242984878152446095843660682602522650388696313157109743775816855708e+65', 4);
  t('6', '5.41744405', 0);
  t('58970028613730800', '58970028613730800.2199658574092832368454', 1);
  t('8.20762797459327051824581448969093981355593722774039e+50', '8.20762797459327051824581448969093981355593722774038945867906329529223994172067097145347e+50', 0);
  t('8.54193986164574247811915221884901109509511490395756e+50', '8.54193986164574247811915221884901109509511490395756892065295262422447820275645e+50', 1);
  t('3.3671952204343650523723248544011797199532387566275400356721261e+61', '3.36719522043436505237232485440117971995323875662754003567212611293933424352567164847630936905281e+61', 6);
  t('7.895956448206507301924101293638155629123626e+42', '7.89595644820650730192410129363815562912362670531791013157843487e+42', 1);
  t('235550616880409704600', '235550616880409704599.127968573', 0);
  t('8.8364345580061269808644472129329280653955e+40', '8.836434558006126980864447212932928065395496132878436651857e+40', 2);
  t('3996478976343', '3996478976342.3856997029833631225762369936431', 0);
  t('296155900738434400', '296155900738434400.6386716', 1);
  t('1.1830481689411792598668e+22', '1.18304816894117925986685219229261257e+22', 1);
  t('8326900056386534199', '8326900056386534198.6860278942553748883', 4);
  t('3.83365199013301205515355243939508806561289907596528931968567685526298673e+71', '3.8336519901330120551535524393950880656128990759652893196856768552629867273321092962870965667105e+71', 5);
  t('9.3791314705961013288090054954372609296202314274173493146043e+58', '9.37913147059610132880900549543726092962023142741734931460434755787852055214175662842408203865372e+58', 3);
  t('7.53156457775671837805805213210009899583881e+41', '7.53156457775671837805805213210009899583881451963e+41', 1);
  t('6222125', '6222125.947399497889116625442366736', 3);
  t('27246516013451', '27246516013450.7612200898046', 5);
  t('2.1129209994249240465962150114302405500377695274770604922397881331e+65', '2.1129209994249240465962150114302405500377695274770604922397881331046343270898071712446295912642e+65', 6);
  t('1.646532833140068856832411079427771744265723063103019194344170396855795846e+72', '1.646532833140068856832411079427771744265723063103019194344170396855795846472772100605573093746166121081e+72', 6);
  t('8.425479546282021948869850897780983270136048547e+45', '8.425479546282021948869850897780983270136048546926147755138e+45', 6);
  t('2.233872046078596369134793158082187513760673304511868920359e+57', '2.23387204607859636913479315808218751376067330451186892035944859933718652677e+57', 1);
  t('3.116405743404107847814732269205375396135221718527468694425449065691242e+69', '3.116405743404107847814732269205375396135221718527468694425449065691241869806095568074204631019012404933659e+69', 5);
  t('2.062365631214868258839472996400163124440742356524760343620038100366519e+69', '2.062365631214868258839472996400163124440742356524760343620038100366518635685404679919e+69', 5);
  t('7.50745541728415428434029959e+26', '7.5074554172841542843402995893059819526420896996212780022697e+26', 4);
  t('7.24849752468097696916398838713364051520307862650612728265666514561056e+68', '7.2484975246809769691639883871336405152030786265061272826566651456105618100701083e+68', 4);
  t('1.35176383329614606610756531319295678018782464936214748745e+56', '1.3517638332961460661075653131929567801878246493621474874550800287300195566470029016e+56', 3);
  t('4.7152341392034704538023e+22', '4.71523413920347045380226220796263110674520711227447379291824e+22', 6);
  t('3.11927423685004836840577039188891100297737718473721047017231325136894944596e+74', '3.11927423685004836840577039188891100297737718473721047017231325136894944595400105170201920293344231e+74', 2);
  t('2.933400342567756418849544349581259968391617744e+45', '2.93340034256775641884954434958125996839161774380675440442887971748700867e+45', 6);
  t('978080378597', '978080378597.2017', 6);
  t('4.372210642064489328448661007253100863929888104582288453e+54', '4.372210642064489328448661007253100863929888104582288452571259872839821582026e+54', 4);
  t('1.857581283508729657743503973029242776985316586148834e+51', '1.8575812835087296577435039730292427769853165861488346530185e+51', 3);
  t('7.421813035238230409761595532233089939079148043727378221365519874e+63', '7.421813035238230409761595532233089939079148043727378221365519873463075894088208132266204031e+63', 2);
  t('51860977367633', '51860977367632.92841245248', 6);
  t('1.95284973709573510813936820783019996132821775350531973163592085e+62', '1.9528497370957351081393682078301999613282177535053197316359208517808968343594003206246753959887549e+62', 3);
  t('6.9464859606048993902832501774806312749761412476825724988127422436981545662e+73', '6.94648596060489939028325017748063127497614124768257249881274224369815456613e+73', 2);
  t('21129', '21128.947551940996938322', 5);
  t('868214861041', '868214861040.7427436259995316', 6);
  t('7.74918309357334474806682151708655686896e+38', '7.749183093573344748066821517086556868950832e+38', 2);
  t('2.230431257587000243746564167163186447940405426320077e+51', '2.230431257587000243746564167163186447940405426320076383541377505288703330654e+51', 2);
  t('6494555134286333798', '6494555134286333798.4', 1);
  t('462', '461.59410222325557994522667', 4);
  t('5.39024618638372653122483710077093421975991216013901874390338817595e+65', '5.390246186383726531224837100770934219759912160139018743903388175945025e+65', 0);
  t('1.12532182738546905376329237437102170669599779470511645090705e+59', '1.125321827385469053763292374371021706695997794705116450907054172134550142e+59', 5);
  t('3.601323497164902344681087151677942539149573539415387031319081234142241e+69', '3.60132349716490234468108715167794253914957353941538703131908123414224106980338319e+69', 3);
  t('8.3500141350805991379256449644186334968168974724806389539568927554e+64', '8.350014135080599137925644964418633496816897472480638953956892755422515632060455336286e+64', 3);
  t('5.401131445300570554896434535066508128e+36', '5.4011314453005705548964345350665081270950342624714457010875100354387132625661e+36', 2);
  t('9.6338971507843956503609197751788e+31', '9.633897150784395650360919775178841334361839784e+31', 3);
  t('3055045603560147538', '3055045603560147538.3515', 5);
  t('1.0337875723141065649275067510790681222557486415834002e+52', '1.03378757231410656492750675107906812225574864158340024144131893262996852354157450707845e+52', 3);
  t('6628586154', '6628586154.6', 3);
  t('33', '32.373155518538415', 0);
  t('360573130404', '360573130404.1772', 4);
  t('2.600098587066400190213419659095053181377974125e+45', '2.6000985870664001902134196590950531813779741255420320463e+45', 1);
  t('75065387', '75065386.98302833398157725347298017479752418', 0);
  t('6.8963281585506360266597808464229207581611594829703695196321237700812792e+70', '6.89632815855063602665978084642292075816115948297036951963212377008127918992506071226e+70', 2);
  t('9.28197726936724954894573282211104735760787482097421156e+55', '9.281977269367249548945732822111047357607874820974211559982916467270345710190773e+55', 5);
  t('3.907918344492889760185116925702963410054303636244477844047e+57', '3.907918344492889760185116925702963410054303636244477844046640552136476663480363798160760359609745e+57', 5);
  t('20390', '20389.50608970538326', 6);
  t('169686499443647', '169686499443646.100053454', 0);
  t('1.14751034435884033701335834374150193187852871899067496879575846043627e+68', '1.14751034435884033701335834374150193187852871899067496879575846043626932134782274903719229367322867524e+68', 5);
  t('3', '3.371802754012374149032621660036326692709', 1);
  t('6571532413631720476', '6571532413631720476.8387885238245530034497383', 1);
  t('711645553194682', '711645553194682', 6);
  t('4022796', '4022795.687', 6);
  t('7.4520872837909058911068647601019387382029518098e+46', '7.45208728379090589110686476010193873820295180975587424115061e+46', 2);
  t('8.03496111125697330071171956759554080088783440345e+47', '8.034961111256973300711719567595540800887834403452118760463608845e+47', 6);
  t('8.55511850491578616176163093563708160895365268972005384027430492224050471255e+74', '8.5551185049157861617616309356370816089536526897200538402743049222405047125441939022661980752136356946774e+74', 0);
  t('9.410089814611218259774585235e+27', '9.410089814611218259774585235484822e+27', 1);

  t('7.7606205390697079697957946444343391883700844095450185e+52', '7.7606205390697079697957946444343391883700844095450185e+52', 4);
  t('4.58994818214423764644807412616998882808679714838440424403030461797814893812e+74', '4.58994818214423764644807412616998882808679714838440424403030461797814893812342208878013e+74', 6);
  t('2.352923246599896770944553256e+27', '2.352923246599896770944553255908913239e+27', 0);
  t('6.57437044461257145907456386880266741220483546270538944188089263831541580968217e+77', '6.5743704446125714590745638688026674122048354627053894418808926383154158096821662727e+77', 2);
  t('5.144471216454355074735516002140628838593038720756482e+51', '5.144471216454355074735516002140628838593038720756481881662e+51', 6);
  t('7.55341561758734508030157277452437863273441605731555574e+54', '7.553415617587345080301572774524378632734416057315555740173241606524174749783e+54', 5);
  t('4.354982111603472427964762e+25', '4.3549821116034724279647619493655447118997607358552409709e+25', 2);
  t('6509325589913679', '6509325589913678.913617766383998659496023511512858', 2);
  t('666281', '666280.13924571686833198933637667668112364', 2);
  t('9.60199236890422200332350658058079087150429925358407963e+53', '9.6019923689042220033235065805807908715042992535840796342235866415544833610757e+53', 4);
  t('1.62306671385880562700401146583371770207236387224456185716632e+59', '1.62306671385880562700401146583371770207236387224456185716632051105062492e+59', 5);
  t('3.90349821730036455964772370048656246021974386995415e+51', '3.90349821730036455964772370048656246021974386995415033871223679e+51', 4);
  t('3.895161261341522686895752632514847521825863076204798881839954312741e+66', '3.8951612613415226868957526325148475218258630762047988818399543127409e+66', 4);
  t('6.25312627484320038802792129687993e+32', '6.25312627484320038802792129687992603074108932199032287019e+32', 2);
  t('7.5312441243891577030062206881031743279845658681657662674e+55', '7.5312441243891577030062206881031743279845658681657662674103562801e+55', 6);
  t('318581309743', '318581309742.186842979710587', 0);
  t('7.50855745791198760171353157088272348952587600306034994135951635926213e+68', '7.508557457911987601713531570882723489525876003060349941359516359262129e+68', 2);
  t('6.23597982856234075088091595070521511023354363e+44', '6.2359798285623407508809159507052151102335436295014681064614367149e+44', 0);
  t('84322488230978019136', '84322488230978019135.2227356965742193995386131512728', 2);
  t('16764', '16764.8665898588107088341937975401', 1);
  t('8.18935827058262157249579209e+26', '8.18935827058262157249579208026965e+26', 0);
  t('491791160034568602461', '491791160034568602460.83489923404591775163573', 2);
  t('6.229504129470767563312789386745388612037820576806e+48', '6.2295041294707675633127893867453886120378205768067974267924876508095964334825746814e+48', 1);
  t('1.208874896653745206039245186466009495535378043650030890890869246166106563569228e+78', '1.2088748966537452060392451864660094955353780436500308908908692461661065635692279595e+78', 5);
  t('9.80626682576630111702042213110361224617656870277610076975453108e+63', '9.80626682576630111702042213110361224617656870277610076975453108044184252370387593526284191295431542542e+63', 4);
  t('9.1613888774072527927195114711544852205567780437825695734193073459254248e+70', '9.1613888774072527927195114711544852205567780437825695734193073459254248529627314400484204661430178990453637e+70', 1);
  t('673517021208', '673517021208.9520590811346224620465', 1);
  t('488983444', '488983443.827', 0);
  t('4.6337190267670232287172031071723722378294103664e+46', '4.6337190267670232287172031071723722378294103663127179388e+46', 0);
  t('6.3139597581687527606169340957866e+31', '6.313959758168752760616934095786555041536228188648917605288037039409e+31', 2);
  t('1.54184940885928055170683378871489428906271821461859385037189717e+62', '1.54184940885928055170683378871489428906271821461859385037189717286319190992985766786581164023647478686e+62', 6);
  t('1.63191916991957661548524946828787075953112885078e+48', '1.6319191699195766154852494682878707595311288507800818816847603111640452525132673e+48', 6);
  t('2', '1.173623567', 0);
  t('52181901174680', '52181901174680.411663178526728847034927', 1);
  t('1.4428724102781618642158162144368851918104e+40', '1.442872410278161864215816214436885191810322778115208449994477462682497831e+40', 0);
  t('2.11079443220477721164615243276424047214227366133785871797501665832663e+68', '2.110794432204777211646152432764240472142273661337858717975016658326637343733212934e+68', 3);
  t('7.01873743153639142702763253786592257300036204279037943e+53', '7.0187374315363914270276325378659225730003620427903794263281588858684437869318245e+53', 4);
  t('297335892209058', '297335892209058.681131934803840285606124', 3);
  t('8.248773121583558644485e+21', '8.24877312158355864448508e+21', 1);
  t('4.28146436685796776936219858146868127921870561782487170316457881813318743106081e+77', '4.28146436685796776936219858146868127921870561782487170316457881813318743106081369565342945403698537616397552596e+77', 4);
  t('9.9820005984048321058530905694335215253469647160852278493082995163703534074e+73', '9.982000598404832105853090569433521525346964716085227849308299516370353407378913408895725481e+73', 2);
  t('9.148522784578220274278e+21', '9.14852278457822027427775281695859151371500029e+21', 2);
  t('9.939519663839419097084309722114337860929618038e+45', '9.93951966383941909708430972211433786092961803758074876538411188673348e+45', 0);
  t('632030633305048023685', '632030633305048023685', 5);
  t('4076', '4076.17183659158963369847898', 4);
  t('5.0915870680446042240788973434264033797234724711318458318825931704e+64', '5.09158706804460422407889734342640337972347247113184583188259317035179494921e+64', 5);
  t('2.764391420260965121209440896051695682676356191890177e+51', '2.7643914202609651212094408960516956826763561918901765856732207162244848e+51', 4);
  t('3.9447030166935777285149689808260893983776285e+43', '3.9447030166935777285149689808260893983776284915557532e+43', 2);
  t('8.010340555613665231927395659663971527793424333051426839523457029297415808148e+75', '8.01034055561366523192739565966397152779342433305142683952345702929741580814831598882542203e+75', 1);
  t('4.5925662338700879558086060238867215491730251801245149826509116719e+64', '4.59256623387008795580860602388672154917302518012451498265091167181660209345699020845019573551693665e+64', 0);
  t('36504551', '36504550.50166831479470939986155470151861004', 5);
  t('2.12540209018988712945893945069101074121688475e+44', '2.12540209018988712945893945069101074121688475323726090278554628156391087371545506904e+44', 5);
  t('181125152', '181125151.99491757248404575757536635094871583', 0);
  t('5.779523432816833924616772030412948003386911576895800096115162704042415963289556e+78', '5.7795234328168339246167720304129480033869115768958000961151627040424159632895565935151683005e+78', 1);
  t('9.17826096990960792013134687632848447684591816754268192955e+56', '9.17826096990960792013134687632848447684591816754268192954583e+56', 4);
  t('7.37421367532529067061667742667390536373826923290956e+50', '7.37421367532529067061667742667390536373826923290955104174785628111147170055463656e+50', 2);
  t('4', '4.3686309345715094939913360017624432429', 5);
  t('8.3594110965962381130596855916957925566323732058003739681143185743e+64', '8.35941109659623811305968559169579255663237320580037396811431857425404163e+64', 4);
  t('5.8017462781868947979669035963150371455e+37', '5.80174627818689479796690359631503714551627518481e+37', 1);
  t('1.90669137860811651611491585358014142495464234863436909519124432366465306869e+74', '1.9066913786081165161149158535801414249546423486343690951912443236646530686990503828136061620899505412969685328e+74', 1);
  t('65827281', '65827281.952680368668829078', 1);
  t('3.796975029309190153935073574227749285722909213685e+48', '3.79697502930919015393507357422774928572290921368440305490055258561431112182290578246e+48', 0);
  t('7891207466205997', '7891207466205997.584874499696221437', 1);
  t('2.94745525109421961698647322282990083780723298975940062387186332e+63', '2.94745525109421961698647322282990083780723298975940062387186331961089494759e+63', 6);
  t('4.34282947014265862495e+21', '4.34282947014265862495e+21', 4);
  t('9.1641692214618337763737436252361499553979881311255799266612e+58', '9.1641692214618337763737436252361499553979881311255799266611244928024975394877156e+58', 2);
  t('5.864333650394800685281265896322e+30', '5.864333650394800685281265896322331612364407086e+30', 5);
  t('7.48583556770321193530048004930689224512462576e+44', '7.485835567703211935300480049306892245124625769726886498025816e+44', 1);
  t('537697', '537697.02142073166750345433592', 5);
  t('6.746416112722632847560558595748474646323241803499729e+51', '6.7464161127226328475605585957484746463232418034997282515230110158271943e+51', 2);
  t('348870466676427057', '348870466676427056.540210736720958044510813849897553858', 0);
  t('12657090', '12657089.364186117157400260898', 0);
  t('1.031300029476346901189374675983105405944047815464946132481100505e+63', '1.03130002947634690118937467598310540594404781546494613248110050480689644637863861125e+63', 5);
  t('2.615472057019087907913471735667812386452505134772501355517041236227187e+69', '2.6154720570190879079134717356678123864525051347725013555170412362271865410294e+69', 0);
  t('7.04165504077691457763479440814442249894246758944393488056686043599000962e+71', '7.0416550407769145776347944081444224989424675894439348805668604359900096153767456881719096558635e+71', 5);
  t('7354818904551179123', '7354818904551179122.7014798901745046823977703675030620318379', 0);
  t('854817485148361', '854817485148360.5714740113462989051407045497052073830764', 6);
  t('47000805088498599710', '47000805088498599709.708437024062675608904338047', 0);
  t('2.1766018980782941709650115665537351498889478677e+47', '2.1766018980782941709650115665537351498889478677028004204702111607312292840436359777e+47', 5);
  t('7.8367301959920444880797359773949243636413420565977635106208263575374910713015704e+79', '7.83673019599204448807973597739492436364134205659776351062082635753749107130157048971635283591024e+79', 1);
  t('3.08903346956401542864799535261274279172597713664198203701807794e+62', '3.0890334695640154286479953526127427917259771366419820370180779377521270933350292462773167787142e+62', 5);
  t('576562571', '576562571.844608138306992462909059062174553', 3);
  t('4.88885922847235829453662441295981179020690065850389e+50', '4.8888592284723582945366244129598117902069006585038897785761278e+50', 0);
  t('805030', '805030.3196150823480264115976649255009294', 3);
  t('3.75867227262935844604124624219765052177179e+41', '3.758672272629358446041246242197650521771793e+41', 6);
  t('8.75150119113270892435492538833147019932204241197862490821051048044419e+68', '8.751501191132708924354925388331470199322042411978624908210510480444188669757061961455531943e+68', 0);
  t('42601873172232953', '42601873172232953.30659313764825104206642999', 3);
  t('1.8171003585956362231021760046143097114054128693433487680606690918875530579038e+76', '1.81710035859563622310217600461430971140541286934334876806066909188755305790370439773413227239119191673971090333e+76', 2);
  t('3.71331955392433687189949e+23', '3.7133195539243368718994912855e+23', 6);
});
