% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tags.R
\name{tagAppendChild}
\alias{tagAppendChild}
\alias{tagAppendChildren}
\alias{tagSetChildren}
\alias{tagInsertChildren}
\title{Modify tag contents}
\usage{
tagAppendChild(tag, child, .cssSelector = NULL)

tagAppendChildren(tag, ..., .cssSelector = NULL, list = NULL)

tagSetChildren(tag, ..., .cssSelector = NULL, list = NULL)

tagInsertChildren(tag, after, ..., .cssSelector = NULL, list = NULL)
}
\arguments{
\item{tag}{a \link{tag} object.}

\item{child}{A child element to append to a parent tag.}

\item{.cssSelector}{A character string containing a \href{https://developer.mozilla.org/en-US/docs/Learn/CSS/Building_blocks/Selectors}{CSS selector}
for targeting particular (inner) tags of interest. At the moment, only a
combination of
\href{https://www.w3.org/TR/CSS22/selector.html#type-selectors}{type} (e.g,
\code{div}), \href{https://www.w3.org/TR/CSS22/selector.html#class-html}{class}
(e.g., \code{.my-class}),
\href{https://www.w3.org/TR/CSS22/selector.html#id-selectors}{id} (e.g.,
\verb{#myID}), and
\href{https://www.w3.org/TR/CSS22/selector.html#universal-selector}{universal}
(\code{*}) selectors within a given \href{https://www.w3.org/TR/CSS22/selector.html#selector-syntax}{simple selector} is
supported. Note, if \code{.cssSelector} is used, the returned tags will have
their \verb{$children} fields flattened to a single \code{list()} via \code{\link[=tagQuery]{tagQuery()}}.}

\item{...}{a collection of \code{child} elements.}

\item{list}{Deprecated. Use \verb{!!!} instead to splice into \code{...}.}

\item{after}{an integer value (i.e., subscript) referring to the child position to append after.}
}
\description{
Modify the contents (aka children) of a \link{tag} object.
}
\examples{
html <- div(a(), h1())
tagAppendChild(html, span())
tagAppendChild(html, .cssSelector = "a", span())

tagAppendChildren(html, span(), p())
tagAppendChildren(html, .cssSelector = "a", span(), p())

tagSetChildren(html, span(), p())

tagInsertChildren(html, after = 1, span(), p())

}
\seealso{
\code{\link[=tagAppendAttributes]{tagAppendAttributes()}}, \code{\link[=tagQuery]{tagQuery()}}
}
