/*

  Broadcom B43 wireless driver
  IEEE 802.11n PHY data tables

  Copyright (c) 2008 Michael Buesch <m@bues.ch>
  Copyright (c) 2010 Rafał Miłecki <zajec5@gmail.com>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; see the file COPYING.  If not, write to
  the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
  Boston, MA 02110-1301, USA.

*/

#include "b43.h"
#include "tables_nphy.h"
#include "phy_common.h"
#include "phy_n.h"

static const u8 b43_ntab_adjustpower0[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

static const u8 b43_ntab_adjustpower1[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

static const u16 b43_ntab_bdi[] = {
	0x0070, 0x0126, 0x012C, 0x0246, 0x048D, 0x04D2,
};

static const u32 b43_ntab_channelest[] = {
	0x44444444, 0x44444444, 0x44444444, 0x44444444,
	0x44444444, 0x44444444, 0x44444444, 0x44444444,
	0x10101010, 0x10101010, 0x10101010, 0x10101010,
	0x10101010, 0x10101010, 0x10101010, 0x10101010,
	0x44444444, 0x44444444, 0x44444444, 0x44444444,
	0x44444444, 0x44444444, 0x44444444, 0x44444444,
	0x10101010, 0x10101010, 0x10101010, 0x10101010,
	0x10101010, 0x10101010, 0x10101010, 0x10101010,
	0x44444444, 0x44444444, 0x44444444, 0x44444444,
	0x44444444, 0x44444444, 0x44444444, 0x44444444,
	0x44444444, 0x44444444, 0x44444444, 0x44444444,
	0x44444444, 0x44444444, 0x44444444, 0x44444444,
	0x10101010, 0x10101010, 0x10101010, 0x10101010,
	0x10101010, 0x10101010, 0x10101010, 0x10101010,
	0x10101010, 0x10101010, 0x10101010, 0x10101010,
	0x10101010, 0x10101010, 0x10101010, 0x10101010,
	0x44444444, 0x44444444, 0x44444444, 0x44444444,
	0x44444444, 0x44444444, 0x44444444, 0x44444444,
	0x44444444, 0x44444444, 0x44444444, 0x44444444,
	0x44444444, 0x44444444, 0x44444444, 0x44444444,
	0x10101010, 0x10101010, 0x10101010, 0x10101010,
	0x10101010, 0x10101010, 0x10101010, 0x10101010,
	0x10101010, 0x10101010, 0x10101010, 0x10101010,
	0x10101010, 0x10101010, 0x10101010, 0x10101010,
};

static const u8 b43_ntab_estimatepowerlt0[] = {
	0x50, 0x4F, 0x4E, 0x4D, 0x4C, 0x4B, 0x4A, 0x49,
	0x48, 0x47, 0x46, 0x45, 0x44, 0x43, 0x42, 0x41,
	0x40, 0x3F, 0x3E, 0x3D, 0x3C, 0x3B, 0x3A, 0x39,
	0x38, 0x37, 0x36, 0x35, 0x34, 0x33, 0x32, 0x31,
	0x30, 0x2F, 0x2E, 0x2D, 0x2C, 0x2B, 0x2A, 0x29,
	0x28, 0x27, 0x26, 0x25, 0x24, 0x23, 0x22, 0x21,
	0x20, 0x1F, 0x1E, 0x1D, 0x1C, 0x1B, 0x1A, 0x19,
	0x18, 0x17, 0x16, 0x15, 0x14, 0x13, 0x12, 0x11,
};

static const u8 b43_ntab_estimatepowerlt1[] = {
	0x50, 0x4F, 0x4E, 0x4D, 0x4C, 0x4B, 0x4A, 0x49,
	0x48, 0x47, 0x46, 0x45, 0x44, 0x43, 0x42, 0x41,
	0x40, 0x3F, 0x3E, 0x3D, 0x3C, 0x3B, 0x3A, 0x39,
	0x38, 0x37, 0x36, 0x35, 0x34, 0x33, 0x32, 0x31,
	0x30, 0x2F, 0x2E, 0x2D, 0x2C, 0x2B, 0x2A, 0x29,
	0x28, 0x27, 0x26, 0x25, 0x24, 0x23, 0x22, 0x21,
	0x20, 0x1F, 0x1E, 0x1D, 0x1C, 0x1B, 0x1A, 0x19,
	0x18, 0x17, 0x16, 0x15, 0x14, 0x13, 0x12, 0x11,
};

static const u8 b43_ntab_framelookup[] = {
	0x02, 0x04, 0x14, 0x14, 0x03, 0x05, 0x16, 0x16,
	0x0A, 0x0C, 0x1C, 0x1C, 0x0B, 0x0D, 0x1E, 0x1E,
	0x06, 0x08, 0x18, 0x18, 0x07, 0x09, 0x1A, 0x1A,
	0x0E, 0x10, 0x20, 0x28, 0x0F, 0x11, 0x22, 0x2A,
};

static const u32 b43_ntab_framestruct[] = {
	0x08004A04, 0x00100000, 0x01000A05, 0x00100020,
	0x09804506, 0x00100030, 0x09804507, 0x00100030,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x08004A0C, 0x00100004, 0x01000A0D, 0x00100024,
	0x0980450E, 0x00100034, 0x0980450F, 0x00100034,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000A04, 0x00100000, 0x11008A05, 0x00100020,
	0x1980C506, 0x00100030, 0x21810506, 0x00100030,
	0x21810506, 0x00100030, 0x01800504, 0x00100030,
	0x11808505, 0x00100030, 0x29814507, 0x01100030,
	0x00000A04, 0x00100000, 0x11008A05, 0x00100020,
	0x21810506, 0x00100030, 0x21810506, 0x00100030,
	0x29814507, 0x01100030, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000A0C, 0x00100008, 0x11008A0D, 0x00100028,
	0x1980C50E, 0x00100038, 0x2181050E, 0x00100038,
	0x2181050E, 0x00100038, 0x0180050C, 0x00100038,
	0x1180850D, 0x00100038, 0x2981450F, 0x01100038,
	0x00000A0C, 0x00100008, 0x11008A0D, 0x00100028,
	0x2181050E, 0x00100038, 0x2181050E, 0x00100038,
	0x2981450F, 0x01100038, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x08004A04, 0x00100000, 0x01000A05, 0x00100020,
	0x1980C506, 0x00100030, 0x1980C506, 0x00100030,
	0x11808504, 0x00100030, 0x3981CA05, 0x00100030,
	0x29814507, 0x01100030, 0x00000000, 0x00000000,
	0x10008A04, 0x00100000, 0x3981CA05, 0x00100030,
	0x1980C506, 0x00100030, 0x29814507, 0x01100030,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x08004A0C, 0x00100008, 0x01000A0D, 0x00100028,
	0x1980C50E, 0x00100038, 0x1980C50E, 0x00100038,
	0x1180850C, 0x00100038, 0x3981CA0D, 0x00100038,
	0x2981450F, 0x01100038, 0x00000000, 0x00000000,
	0x10008A0C, 0x00100008, 0x3981CA0D, 0x00100038,
	0x1980C50E, 0x00100038, 0x2981450F, 0x01100038,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x40021404, 0x00100000, 0x02001405, 0x00100040,
	0x0B004A06, 0x01900060, 0x13008A06, 0x01900060,
	0x13008A06, 0x01900060, 0x43020A04, 0x00100060,
	0x1B00CA05, 0x00100060, 0x23010A07, 0x01500060,
	0x40021404, 0x00100000, 0x1A00D405, 0x00100040,
	0x13008A06, 0x01900060, 0x13008A06, 0x01900060,
	0x23010A07, 0x01500060, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x4002140C, 0x00100010, 0x0200140D, 0x00100050,
	0x0B004A0E, 0x01900070, 0x13008A0E, 0x01900070,
	0x13008A0E, 0x01900070, 0x43020A0C, 0x00100070,
	0x1B00CA0D, 0x00100070, 0x23010A0F, 0x01500070,
	0x4002140C, 0x00100010, 0x1A00D40D, 0x00100050,
	0x13008A0E, 0x01900070, 0x13008A0E, 0x01900070,
	0x23010A0F, 0x01500070, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x50029404, 0x00100000, 0x32019405, 0x00100040,
	0x0B004A06, 0x01900060, 0x0B004A06, 0x01900060,
	0x5B02CA04, 0x00100060, 0x3B01D405, 0x00100060,
	0x23010A07, 0x01500060, 0x00000000, 0x00000000,
	0x5802D404, 0x00100000, 0x3B01D405, 0x00100060,
	0x0B004A06, 0x01900060, 0x23010A07, 0x01500060,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x5002940C, 0x00100010, 0x3201940D, 0x00100050,
	0x0B004A0E, 0x01900070, 0x0B004A0E, 0x01900070,
	0x5B02CA0C, 0x00100070, 0x3B01D40D, 0x00100070,
	0x23010A0F, 0x01500070, 0x00000000, 0x00000000,
	0x5802D40C, 0x00100010, 0x3B01D40D, 0x00100070,
	0x0B004A0E, 0x01900070, 0x23010A0F, 0x01500070,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x40021404, 0x000F4800, 0x62031405, 0x00100040,
	0x53028A06, 0x01900060, 0x53028A07, 0x01900060,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x4002140C, 0x000F4808, 0x6203140D, 0x00100048,
	0x53028A0E, 0x01900068, 0x53028A0F, 0x01900068,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000A0C, 0x00100004, 0x11008A0D, 0x00100024,
	0x1980C50E, 0x00100034, 0x2181050E, 0x00100034,
	0x2181050E, 0x00100034, 0x0180050C, 0x00100038,
	0x1180850D, 0x00100038, 0x1181850D, 0x00100038,
	0x2981450F, 0x01100038, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000A0C, 0x00100008, 0x11008A0D, 0x00100028,
	0x2181050E, 0x00100038, 0x2181050E, 0x00100038,
	0x1181850D, 0x00100038, 0x2981450F, 0x01100038,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x08004A04, 0x00100000, 0x01000A05, 0x00100020,
	0x0180C506, 0x00100030, 0x0180C506, 0x00100030,
	0x2180C50C, 0x00100030, 0x49820A0D, 0x0016A130,
	0x41824A0D, 0x0016A130, 0x2981450F, 0x01100030,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x2000CA0C, 0x00100000, 0x49820A0D, 0x0016A130,
	0x1980C50E, 0x00100030, 0x41824A0D, 0x0016A130,
	0x2981450F, 0x01100030, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x4002140C, 0x00100008, 0x0200140D, 0x00100048,
	0x0B004A0E, 0x01900068, 0x13008A0E, 0x01900068,
	0x13008A0E, 0x01900068, 0x43020A0C, 0x00100070,
	0x1B00CA0D, 0x00100070, 0x1B014A0D, 0x00100070,
	0x23010A0F, 0x01500070, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x4002140C, 0x00100010, 0x1A00D40D, 0x00100050,
	0x13008A0E, 0x01900070, 0x13008A0E, 0x01900070,
	0x1B014A0D, 0x00100070, 0x23010A0F, 0x01500070,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x50029404, 0x00100000, 0x32019405, 0x00100040,
	0x03004A06, 0x01900060, 0x03004A06, 0x01900060,
	0x6B030A0C, 0x00100060, 0x4B02140D, 0x0016A160,
	0x4302540D, 0x0016A160, 0x23010A0F, 0x01500060,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x6B03140C, 0x00100060, 0x4B02140D, 0x0016A160,
	0x0B004A0E, 0x01900060, 0x4302540D, 0x0016A160,
	0x23010A0F, 0x01500060, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x40021404, 0x00100000, 0x1A00D405, 0x00100040,
	0x53028A06, 0x01900060, 0x5B02CA06, 0x01900060,
	0x5B02CA06, 0x01900060, 0x43020A04, 0x00100060,
	0x1B00CA05, 0x00100060, 0x53028A07, 0x0190C060,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x4002140C, 0x00100010, 0x1A00D40D, 0x00100050,
	0x53028A0E, 0x01900070, 0x5B02CA0E, 0x01900070,
	0x5B02CA0E, 0x01900070, 0x43020A0C, 0x00100070,
	0x1B00CA0D, 0x00100070, 0x53028A0F, 0x0190C070,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x40021404, 0x00100000, 0x1A00D405, 0x00100040,
	0x5B02CA06, 0x01900060, 0x5B02CA06, 0x01900060,
	0x53028A07, 0x0190C060, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x4002140C, 0x00100010, 0x1A00D40D, 0x00100050,
	0x5B02CA0E, 0x01900070, 0x5B02CA0E, 0x01900070,
	0x53028A0F, 0x0190C070, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
};

static const u32 b43_ntab_gainctl0[] = {
	0x03CC2B44, 0x03CC2B42, 0x03CC2B40, 0x03CC2B3E,
	0x03CC2B3D, 0x03CC2B3B, 0x03C82B44, 0x03C82B42,
	0x03C82B40, 0x03C82B3E, 0x03C82B3D, 0x03C82B3B,
	0x03C82B39, 0x03C82B38, 0x03C82B36, 0x03C82B34,
	0x03C42B44, 0x03C42B42, 0x03C42B40, 0x03C42B3E,
	0x03C42B3D, 0x03C42B3B, 0x03C42B39, 0x03C42B38,
	0x03C42B36, 0x03C42B34, 0x03C42B33, 0x03C42B32,
	0x03C42B30, 0x03C42B2F, 0x03C42B2D, 0x03C02B44,
	0x03C02B42, 0x03C02B40, 0x03C02B3E, 0x03C02B3D,
	0x03C02B3B, 0x03C02B39, 0x03C02B38, 0x03C02B36,
	0x03C02B34, 0x03B02B44, 0x03B02B42, 0x03B02B40,
	0x03B02B3E, 0x03B02B3D, 0x03B02B3B, 0x03B02B39,
	0x03B02B38, 0x03B02B36, 0x03B02B34, 0x03B02B33,
	0x03B02B32, 0x03B02B30, 0x03B02B2F, 0x03B02B2D,
	0x03A02B44, 0x03A02B42, 0x03A02B40, 0x03A02B3E,
	0x03A02B3D, 0x03A02B3B, 0x03A02B39, 0x03A02B38,
	0x03A02B36, 0x03A02B34, 0x03902B44, 0x03902B42,
	0x03902B40, 0x03902B3E, 0x03902B3D, 0x03902B3B,
	0x03902B39, 0x03902B38, 0x03902B36, 0x03902B34,
	0x03902B33, 0x03902B32, 0x03902B30, 0x03802B44,
	0x03802B42, 0x03802B40, 0x03802B3E, 0x03802B3D,
	0x03802B3B, 0x03802B39, 0x03802B38, 0x03802B36,
	0x03802B34, 0x03802B33, 0x03802B32, 0x03802B30,
	0x03802B2F, 0x03802B2D, 0x03802B2C, 0x03802B2B,
	0x03802B2A, 0x03802B29, 0x03802B27, 0x03802B26,
	0x03802B25, 0x03802B24, 0x03802B23, 0x03802B22,
	0x03802B21, 0x03802B20, 0x03802B1F, 0x03802B1E,
	0x03802B1E, 0x03802B1D, 0x03802B1C, 0x03802B1B,
	0x03802B1A, 0x03802B1A, 0x03802B19, 0x03802B18,
	0x03802B18, 0x03802B18, 0x03802B18, 0x03802B18,
	0x03802B18, 0x03802B18, 0x03802B18, 0x03802B18,
	0x03802B18, 0x03802B18, 0x03802B18, 0x00002B00,
};

static const u32 b43_ntab_gainctl1[] = {
	0x03CC2B44, 0x03CC2B42, 0x03CC2B40, 0x03CC2B3E,
	0x03CC2B3D, 0x03CC2B3B, 0x03C82B44, 0x03C82B42,
	0x03C82B40, 0x03C82B3E, 0x03C82B3D, 0x03C82B3B,
	0x03C82B39, 0x03C82B38, 0x03C82B36, 0x03C82B34,
	0x03C42B44, 0x03C42B42, 0x03C42B40, 0x03C42B3E,
	0x03C42B3D, 0x03C42B3B, 0x03C42B39, 0x03C42B38,
	0x03C42B36, 0x03C42B34, 0x03C42B33, 0x03C42B32,
	0x03C42B30, 0x03C42B2F, 0x03C42B2D, 0x03C02B44,
	0x03C02B42, 0x03C02B40, 0x03C02B3E, 0x03C02B3D,
	0x03C02B3B, 0x03C02B39, 0x03C02B38, 0x03C02B36,
	0x03C02B34, 0x03B02B44, 0x03B02B42, 0x03B02B40,
	0x03B02B3E, 0x03B02B3D, 0x03B02B3B, 0x03B02B39,
	0x03B02B38, 0x03B02B36, 0x03B02B34, 0x03B02B33,
	0x03B02B32, 0x03B02B30, 0x03B02B2F, 0x03B02B2D,
	0x03A02B44, 0x03A02B42, 0x03A02B40, 0x03A02B3E,
	0x03A02B3D, 0x03A02B3B, 0x03A02B39, 0x03A02B38,
	0x03A02B36, 0x03A02B34, 0x03902B44, 0x03902B42,
	0x03902B40, 0x03902B3E, 0x03902B3D, 0x03902B3B,
	0x03902B39, 0x03902B38, 0x03902B36, 0x03902B34,
	0x03902B33, 0x03902B32, 0x03902B30, 0x03802B44,
	0x03802B42, 0x03802B40, 0x03802B3E, 0x03802B3D,
	0x03802B3B, 0x03802B39, 0x03802B38, 0x03802B36,
	0x03802B34, 0x03802B33, 0x03802B32, 0x03802B30,
	0x03802B2F, 0x03802B2D, 0x03802B2C, 0x03802B2B,
	0x03802B2A, 0x03802B29, 0x03802B27, 0x03802B26,
	0x03802B25, 0x03802B24, 0x03802B23, 0x03802B22,
	0x03802B21, 0x03802B20, 0x03802B1F, 0x03802B1E,
	0x03802B1E, 0x03802B1D, 0x03802B1C, 0x03802B1B,
	0x03802B1A, 0x03802B1A, 0x03802B19, 0x03802B18,
	0x03802B18, 0x03802B18, 0x03802B18, 0x03802B18,
	0x03802B18, 0x03802B18, 0x03802B18, 0x03802B18,
	0x03802B18, 0x03802B18, 0x03802B18, 0x00002B00,
};

static const u32 b43_ntab_intlevel[] = {
	0x00802070, 0x0671188D, 0x0A60192C, 0x0A300E46,
	0x00C1188D, 0x080024D2, 0x00000070,
};

static const u32 b43_ntab_iqlt0[] = {
	0x0000007F, 0x0000007F, 0x0000007F, 0x0000007F,
	0x0000007F, 0x0000007F, 0x0000007F, 0x0000007F,
	0x0000007F, 0x0000007F, 0x0000007F, 0x0000007F,
	0x0000007F, 0x0000007F, 0x0000007F, 0x0000007F,
	0x0000007F, 0x0000007F, 0x0000007F, 0x0000007F,
	0x0000007F, 0x0000007F, 0x0000007F, 0x0000007F,
	0x0000007F, 0x0000007F, 0x0000007F, 0x0000007F,
	0x0000007F, 0x0000007F, 0x0000007F, 0x0000007F,
	0x0000007F, 0x0000007F, 0x0000007F, 0x0000007F,
	0x0000007F, 0x0000007F, 0x0000007F, 0x0000007F,
	0x0000007F, 0x0000007F, 0x0000007F, 0x0000007F,
	0x0000007F, 0x0000007F, 0x0000007F, 0x0000007F,
	0x0000007F, 0x0000007F, 0x0000007F, 0x0000007F,
	0x0000007F, 0x0000007F, 0x0000007F, 0x0000007F,
	0x0000007F, 0x0000007F, 0x0000007F, 0x0000007F,
	0x0000007F, 0x0000007F, 0x0000007F, 0x0000007F,
	0x0000007F, 0x0000007F, 0x0000007F, 0x0000007F,
	0x0000007F, 0x0000007F, 0x0000007F, 0x0000007F,
	0x0000007F, 0x0000007F, 0x0000007F, 0x0000007F,
	0x0000007F, 0x0000007F, 0x0000007F, 0x0000007F,
	0x0000007F, 0x0000007F, 0x0000007F, 0x0000007F,
	0x0000007F, 0x0000007F, 0x0000007F, 0x0000007F,
	0x0000007F, 0x0000007F, 0x0000007F, 0x0000007F,
	0x0000007F, 0x0000007F, 0x0000007F, 0x0000007F,
	0x0000007F, 0x0000007F, 0x0000007F, 0x0000007F,
	0x0000007F, 0x0000007F, 0x0000007F, 0x0000007F,
	0x0000007F, 0x0000007F, 0x0000007F, 0x0000007F,
	0x0000007F, 0x0000007F, 0x0000007F, 0x0000007F,
	0x0000007F, 0x0000007F, 0x0000007F, 0x0000007F,
	0x0000007F, 0x0000007F, 0x0000007F, 0x0000007F,
	0x0000007F, 0x0000007F, 0x0000007F, 0x0000007F,
	0x0000007F, 0x0000007F, 0x0000007F, 0x0000007F,
};

static const u32 b43_ntab_iqlt1[] = {
	0x0000007F, 0x0000007F, 0x0000007F, 0x0000007F,
	0x0000007F, 0x0000007F, 0x0000007F, 0x0000007F,
	0x0000007F, 0x0000007F, 0x0000007F, 0x0000007F,
	0x0000007F, 0x0000007F, 0x0000007F, 0x0000007F,
	0x0000007F, 0x0000007F, 0x0000007F, 0x0000007F,
	0x0000007F, 0x0000007F, 0x0000007F, 0x0000007F,
	0x0000007F, 0x0000007F, 0x0000007F, 0x0000007F,
	0x0000007F, 0x0000007F, 0x0000007F, 0x0000007F,
	0x0000007F, 0x0000007F, 0x0000007F, 0x0000007F,
	0x0000007F, 0x0000007F, 0x0000007F, 0x0000007F,
	0x0000007F, 0x0000007F, 0x0000007F, 0x0000007F,
	0x0000007F, 0x0000007F, 0x0000007F, 0x0000007F,
	0x0000007F, 0x0000007F, 0x0000007F, 0x0000007F,
	0x0000007F, 0x0000007F, 0x0000007F, 0x0000007F,
	0x0000007F, 0x0000007F, 0x0000007F, 0x0000007F,
	0x0000007F, 0x0000007F, 0x0000007F, 0x0000007F,
	0x0000007F, 0x0000007F, 0x0000007F, 0x0000007F,
	0x0000007F, 0x0000007F, 0x0000007F, 0x0000007F,
	0x0000007F, 0x0000007F, 0x0000007F, 0x0000007F,
	0x0000007F, 0x0000007F, 0x0000007F, 0x0000007F,
	0x0000007F, 0x0000007F, 0x0000007F, 0x0000007F,
	0x0000007F, 0x0000007F, 0x0000007F, 0x0000007F,
	0x0000007F, 0x0000007F, 0x0000007F, 0x0000007F,
	0x0000007F, 0x0000007F, 0x0000007F, 0x0000007F,
	0x0000007F, 0x0000007F, 0x0000007F, 0x0000007F,
	0x0000007F, 0x0000007F, 0x0000007F, 0x0000007F,
	0x0000007F, 0x0000007F, 0x0000007F, 0x0000007F,
	0x0000007F, 0x0000007F, 0x0000007F, 0x0000007F,
	0x0000007F, 0x0000007F, 0x0000007F, 0x0000007F,
	0x0000007F, 0x0000007F, 0x0000007F, 0x0000007F,
	0x0000007F, 0x0000007F, 0x0000007F, 0x0000007F,
	0x0000007F, 0x0000007F, 0x0000007F, 0x0000007F,
};

static const u16 b43_ntab_loftlt0[] = {
	0x0000, 0x0101, 0x0002, 0x0103, 0x0000, 0x0101,
	0x0002, 0x0103, 0x0000, 0x0101, 0x0002, 0x0103,
	0x0000, 0x0101, 0x0002, 0x0103, 0x0000, 0x0101,
	0x0002, 0x0103, 0x0000, 0x0101, 0x0002, 0x0103,
	0x0000, 0x0101, 0x0002, 0x0103, 0x0000, 0x0101,
	0x0002, 0x0103, 0x0000, 0x0101, 0x0002, 0x0103,
	0x0000, 0x0101, 0x0002, 0x0103, 0x0000, 0x0101,
	0x0002, 0x0103, 0x0000, 0x0101, 0x0002, 0x0103,
	0x0000, 0x0101, 0x0002, 0x0103, 0x0000, 0x0101,
	0x0002, 0x0103, 0x0000, 0x0101, 0x0002, 0x0103,
	0x0000, 0x0101, 0x0002, 0x0103, 0x0000, 0x0101,
	0x0002, 0x0103, 0x0000, 0x0101, 0x0002, 0x0103,
	0x0000, 0x0101, 0x0002, 0x0103, 0x0000, 0x0101,
	0x0002, 0x0103, 0x0000, 0x0101, 0x0002, 0x0103,
	0x0000, 0x0101, 0x0002, 0x0103, 0x0000, 0x0101,
	0x0002, 0x0103, 0x0000, 0x0101, 0x0002, 0x0103,
	0x0000, 0x0101, 0x0002, 0x0103, 0x0000, 0x0101,
	0x0002, 0x0103, 0x0000, 0x0101, 0x0002, 0x0103,
	0x0000, 0x0101, 0x0002, 0x0103, 0x0000, 0x0101,
	0x0002, 0x0103, 0x0000, 0x0101, 0x0002, 0x0103,
	0x0000, 0x0101, 0x0002, 0x0103, 0x0000, 0x0101,
	0x0002, 0x0103,
};

static const u16 b43_ntab_loftlt1[] = {
	0x0000, 0x0101, 0x0002, 0x0103, 0x0000, 0x0101,
	0x0002, 0x0103, 0x0000, 0x0101, 0x0002, 0x0103,
	0x0000, 0x0101, 0x0002, 0x0103, 0x0000, 0x0101,
	0x0002, 0x0103, 0x0000, 0x0101, 0x0002, 0x0103,
	0x0000, 0x0101, 0x0002, 0x0103, 0x0000, 0x0101,
	0x0002, 0x0103, 0x0000, 0x0101, 0x0002, 0x0103,
	0x0000, 0x0101, 0x0002, 0x0103, 0x0000, 0x0101,
	0x0002, 0x0103, 0x0000, 0x0101, 0x0002, 0x0103,
	0x0000, 0x0101, 0x0002, 0x0103, 0x0000, 0x0101,
	0x0002, 0x0103, 0x0000, 0x0101, 0x0002, 0x0103,
	0x0000, 0x0101, 0x0002, 0x0103, 0x0000, 0x0101,
	0x0002, 0x0103, 0x0000, 0x0101, 0x0002, 0x0103,
	0x0000, 0x0101, 0x0002, 0x0103, 0x0000, 0x0101,
	0x0002, 0x0103, 0x0000, 0x0101, 0x0002, 0x0103,
	0x0000, 0x0101, 0x0002, 0x0103, 0x0000, 0x0101,
	0x0002, 0x0103, 0x0000, 0x0101, 0x0002, 0x0103,
	0x0000, 0x0101, 0x0002, 0x0103, 0x0000, 0x0101,
	0x0002, 0x0103, 0x0000, 0x0101, 0x0002, 0x0103,
	0x0000, 0x0101, 0x0002, 0x0103, 0x0000, 0x0101,
	0x0002, 0x0103, 0x0000, 0x0101, 0x0002, 0x0103,
	0x0000, 0x0101, 0x0002, 0x0103, 0x0000, 0x0101,
	0x0002, 0x0103,
};

static const u8 b43_ntab_mcs[] = {
	0x00, 0x08, 0x0A, 0x10, 0x12, 0x19, 0x1A, 0x1C,
	0x40, 0x48, 0x4A, 0x50, 0x52, 0x59, 0x5A, 0x5C,
	0x80, 0x88, 0x8A, 0x90, 0x92, 0x99, 0x9A, 0x9C,
	0xC0, 0xC8, 0xCA, 0xD0, 0xD2, 0xD9, 0xDA, 0xDC,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x02, 0x04, 0x08, 0x09, 0x0A, 0x0C,
	0x10, 0x11, 0x12, 0x14, 0x18, 0x19, 0x1A, 0x1C,
	0x20, 0x21, 0x22, 0x24, 0x40, 0x41, 0x42, 0x44,
	0x48, 0x49, 0x4A, 0x4C, 0x50, 0x51, 0x52, 0x54,
	0x58, 0x59, 0x5A, 0x5C, 0x60, 0x61, 0x62, 0x64,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

static const u32 b43_ntab_noisevar10[] = {
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
};

static const u32 b43_ntab_noisevar11[] = {
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
	0x020C020C, 0x0000014D, 0x020C020C, 0x0000014D,
};

static const u16 b43_ntab_pilot[] = {
	0xFF08, 0xFF08, 0xFF08, 0xFF08, 0xFF08, 0xFF08,
	0xFF08, 0xFF08, 0x80D5, 0x80D5, 0x80D5, 0x80D5,
	0x80D5, 0x80D5, 0x80D5, 0x80D5, 0xFF0A, 0xFF82,
	0xFFA0, 0xFF28, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
	0xFF82, 0xFFA0, 0xFF28, 0xFF0A, 0xFFFF, 0xFFFF,
	0xFFFF, 0xFFFF, 0xF83F, 0xFA1F, 0xFA97, 0xFAB5,
	0xF2BD, 0xF0BF, 0xFFFF, 0xFFFF, 0xF017, 0xF815,
	0xF215, 0xF095, 0xF035, 0xF01D, 0xFFFF, 0xFFFF,
	0xFF08, 0xFF02, 0xFF80, 0xFF20, 0xFF08, 0xFF02,
	0xFF80, 0xFF20, 0xF01F, 0xF817, 0xFA15, 0xF295,
	0xF0B5, 0xF03D, 0xFFFF, 0xFFFF, 0xF82A, 0xFA0A,
	0xFA82, 0xFAA0, 0xF2A8, 0xF0AA, 0xFFFF, 0xFFFF,
	0xF002, 0xF800, 0xF200, 0xF080, 0xF020, 0xF008,
	0xFFFF, 0xFFFF, 0xF00A, 0xF802, 0xFA00, 0xF280,
	0xF0A0, 0xF028, 0xFFFF, 0xFFFF,
};

static const u32 b43_ntab_pilotlt[] = {
	0x76540123, 0x62407351, 0x76543201, 0x76540213,
	0x76540123, 0x76430521,
};

static const u32 b43_ntab_tdi20a0[] = {
	0x00091226, 0x000A1429, 0x000B56AD, 0x000C58B0,
	0x000D5AB3, 0x000E9CB6, 0x000F9EBA, 0x0000C13D,
	0x00020301, 0x00030504, 0x00040708, 0x0005090B,
	0x00064B8E, 0x00095291, 0x000A5494, 0x000B9718,
	0x000C9927, 0x000D9B2A, 0x000EDD2E, 0x000FDF31,
	0x000101B4, 0x000243B7, 0x000345BB, 0x000447BE,
	0x00058982, 0x00068C05, 0x00099309, 0x000A950C,
	0x000BD78F, 0x000CD992, 0x000DDB96, 0x000F1D99,
	0x00005FA8, 0x0001422C, 0x0002842F, 0x00038632,
	0x00048835, 0x0005CA38, 0x0006CCBC, 0x0009D3BF,
	0x000B1603, 0x000C1806, 0x000D1A0A, 0x000E1C0D,
	0x000F5E10, 0x00008093, 0x00018297, 0x0002C49A,
	0x0003C680, 0x0004C880, 0x00060B00, 0x00070D00,
	0x00000000, 0x00000000, 0x00000000,
};

static const u32 b43_ntab_tdi20a1[] = {
	0x00014B26, 0x00028D29, 0x000393AD, 0x00049630,
	0x0005D833, 0x0006DA36, 0x00099C3A, 0x000A9E3D,
	0x000BC081, 0x000CC284, 0x000DC488, 0x000F068B,
	0x0000488E, 0x00018B91, 0x0002D214, 0x0003D418,
	0x0004D6A7, 0x000618AA, 0x00071AAE, 0x0009DCB1,
	0x000B1EB4, 0x000C0137, 0x000D033B, 0x000E053E,
	0x000F4702, 0x00008905, 0x00020C09, 0x0003128C,
	0x0004148F, 0x00051712, 0x00065916, 0x00091B19,
	0x000A1D28, 0x000B5F2C, 0x000C41AF, 0x000D43B2,
	0x000E85B5, 0x000F87B8, 0x0000C9BC, 0x00024CBF,
	0x00035303, 0x00045506, 0x0005978A, 0x0006998D,
	0x00095B90, 0x000A5D93, 0x000B9F97, 0x000C821A,
	0x000D8400, 0x000EC600, 0x000FC800, 0x00010A00,
	0x00000000, 0x00000000, 0x00000000,
};

static const u32 b43_ntab_tdi40a0[] = {
	0x0011A346, 0x00136CCF, 0x0014F5D9, 0x001641E2,
	0x0017CB6B, 0x00195475, 0x001B2383, 0x001CAD0C,
	0x001E7616, 0x0000821F, 0x00020BA8, 0x0003D4B2,
	0x00056447, 0x00072DD0, 0x0008B6DA, 0x000A02E3,
	0x000B8C6C, 0x000D15F6, 0x0011E484, 0x0013AE0D,
	0x00153717, 0x00168320, 0x00180CA9, 0x00199633,
	0x001B6548, 0x001CEED1, 0x001EB7DB, 0x0000C3E4,
	0x00024D6D, 0x000416F7, 0x0005A585, 0x00076F0F,
	0x0008F818, 0x000A4421, 0x000BCDAB, 0x000D9734,
	0x00122649, 0x0013EFD2, 0x001578DC, 0x0016C4E5,
	0x00184E6E, 0x001A17F8, 0x001BA686, 0x001D3010,
	0x001EF999, 0x00010522, 0x00028EAC, 0x00045835,
	0x0005E74A, 0x0007B0D3, 0x00093A5D, 0x000A85E6,
	0x000C0F6F, 0x000DD8F9, 0x00126787, 0x00143111,
	0x0015BA9A, 0x00170623, 0x00188FAD, 0x001A5936,
	0x001BE84B, 0x001DB1D4, 0x001F3B5E, 0x000146E7,
	0x00031070, 0x000499FA, 0x00062888, 0x0007F212,
	0x00097B9B, 0x000AC7A4, 0x000C50AE, 0x000E1A37,
	0x0012A94C, 0x001472D5, 0x0015FC5F, 0x00174868,
	0x0018D171, 0x001A9AFB, 0x001C2989, 0x001DF313,
	0x001F7C9C, 0x000188A5, 0x000351AF, 0x0004DB38,
	0x0006AA4D, 0x000833D7, 0x0009BD60, 0x000B0969,
	0x000C9273, 0x000E5BFC, 0x00132A8A, 0x0014B414,
	0x00163D9D, 0x001789A6, 0x001912B0, 0x001ADC39,
	0x001C6BCE, 0x001E34D8, 0x001FBE61, 0x0001CA6A,
	0x00039374, 0x00051CFD, 0x0006EC0B, 0x00087515,
	0x0009FE9E, 0x000B4AA7, 0x000CD3B1, 0x000E9D3A,
	0x00000000, 0x00000000,
};

static const u32 b43_ntab_tdi40a1[] = {
	0x001EDB36, 0x000129CA, 0x0002B353, 0x00047CDD,
	0x0005C8E6, 0x000791EF, 0x00091BF9, 0x000AAA07,
	0x000C3391, 0x000DFD1A, 0x00120923, 0x0013D22D,
	0x00155C37, 0x0016EACB, 0x00187454, 0x001A3DDE,
	0x001B89E7, 0x001D12F0, 0x001F1CFA, 0x00016B88,
	0x00033492, 0x0004BE1B, 0x00060A24, 0x0007D32E,
	0x00095D38, 0x000AEC4C, 0x000C7555, 0x000E3EDF,
	0x00124AE8, 0x001413F1, 0x0015A37B, 0x00172C89,
	0x0018B593, 0x001A419C, 0x001BCB25, 0x001D942F,
	0x001F63B9, 0x0001AD4D, 0x00037657, 0x0004C260,
	0x00068BE9, 0x000814F3, 0x0009A47C, 0x000B2D8A,
	0x000CB694, 0x000E429D, 0x00128C26, 0x001455B0,
	0x0015E4BA, 0x00176E4E, 0x0018F758, 0x001A8361,
	0x001C0CEA, 0x001DD674, 0x001FA57D, 0x0001EE8B,
	0x0003B795, 0x0005039E, 0x0006CD27, 0x000856B1,
	0x0009E5C6, 0x000B6F4F, 0x000CF859, 0x000E8462,
	0x00130DEB, 0x00149775, 0x00162603, 0x0017AF8C,
	0x00193896, 0x001AC49F, 0x001C4E28, 0x001E17B2,
	0x0000A6C7, 0x00023050, 0x0003F9DA, 0x00054563,
	0x00070EEC, 0x00089876, 0x000A2704, 0x000BB08D,
	0x000D3A17, 0x001185A0, 0x00134F29, 0x0014D8B3,
	0x001667C8, 0x0017F151, 0x00197ADB, 0x001B0664,
	0x001C8FED, 0x001E5977, 0x0000E805, 0x0002718F,
	0x00043B18, 0x000586A1, 0x0007502B, 0x0008D9B4,
	0x000A68C9, 0x000BF252, 0x000DBBDC, 0x0011C7E5,
	0x001390EE, 0x00151A78, 0x0016A906, 0x00183290,
	0x0019BC19, 0x001B4822, 0x001CD12C, 0x001E9AB5,
	0x00000000, 0x00000000,
};

static const u32 b43_ntab_tdtrn[] = {
	0x061C061C, 0x0050EE68, 0xF592FE36, 0xFE5212F6,
	0x00000C38, 0xFE5212F6, 0xF592FE36, 0x0050EE68,
	0x061C061C, 0xEE680050, 0xFE36F592, 0x12F6FE52,
	0x0C380000, 0x12F6FE52, 0xFE36F592, 0xEE680050,
	0x061C061C, 0x0050EE68, 0xF592FE36, 0xFE5212F6,
	0x00000C38, 0xFE5212F6, 0xF592FE36, 0x0050EE68,
	0x061C061C, 0xEE680050, 0xFE36F592, 0x12F6FE52,
	0x0C380000, 0x12F6FE52, 0xFE36F592, 0xEE680050,
	0x05E305E3, 0x004DEF0C, 0xF5F3FE47, 0xFE611246,
	0x00000BC7, 0xFE611246, 0xF5F3FE47, 0x004DEF0C,
	0x05E305E3, 0xEF0C004D, 0xFE47F5F3, 0x1246FE61,
	0x0BC70000, 0x1246FE61, 0xFE47F5F3, 0xEF0C004D,
	0x05E305E3, 0x004DEF0C, 0xF5F3FE47, 0xFE611246,
	0x00000BC7, 0xFE611246, 0xF5F3FE47, 0x004DEF0C,
	0x05E305E3, 0xEF0C004D, 0xFE47F5F3, 0x1246FE61,
	0x0BC70000, 0x1246FE61, 0xFE47F5F3, 0xEF0C004D,
	0xFA58FA58, 0xF895043B, 0xFF4C09C0, 0xFBC6FFA8,
	0xFB84F384, 0x0798F6F9, 0x05760122, 0x058409F6,
	0x0B500000, 0x05B7F542, 0x08860432, 0x06DDFEE7,
	0xFB84F384, 0xF9D90664, 0xF7E8025C, 0x00FFF7BD,
	0x05A805A8, 0xF7BD00FF, 0x025CF7E8, 0x0664F9D9,
	0xF384FB84, 0xFEE706DD, 0x04320886, 0xF54205B7,
	0x00000B50, 0x09F60584, 0x01220576, 0xF6F90798,
	0xF384FB84, 0xFFA8FBC6, 0x09C0FF4C, 0x043BF895,
	0x02D402D4, 0x07DE0270, 0xFC96079C, 0xF90AFE94,
	0xFE00FF2C, 0x02D4065D, 0x092A0096, 0x0014FBB8,
	0xFD2CFD2C, 0x076AFB3C, 0x0096F752, 0xF991FD87,
	0xFB2C0200, 0xFEB8F960, 0x08E0FC96, 0x049802A8,
	0xFD2CFD2C, 0x02A80498, 0xFC9608E0, 0xF960FEB8,
	0x0200FB2C, 0xFD87F991, 0xF7520096, 0xFB3C076A,
	0xFD2CFD2C, 0xFBB80014, 0x0096092A, 0x065D02D4,
	0xFF2CFE00, 0xFE94F90A, 0x079CFC96, 0x027007DE,
	0x02D402D4, 0x027007DE, 0x079CFC96, 0xFE94F90A,
	0xFF2CFE00, 0x065D02D4, 0x0096092A, 0xFBB80014,
	0xFD2CFD2C, 0xFB3C076A, 0xF7520096, 0xFD87F991,
	0x0200FB2C, 0xF960FEB8, 0xFC9608E0, 0x02A80498,
	0xFD2CFD2C, 0x049802A8, 0x08E0FC96, 0xFEB8F960,
	0xFB2C0200, 0xF991FD87, 0x0096F752, 0x076AFB3C,
	0xFD2CFD2C, 0x0014FBB8, 0x092A0096, 0x02D4065D,
	0xFE00FF2C, 0xF90AFE94, 0xFC96079C, 0x07DE0270,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x062A0000, 0xFEFA0759, 0x08B80908, 0xF396FC2D,
	0xF9D6045C, 0xFC4EF608, 0xF748F596, 0x07B207BF,
	0x062A062A, 0xF84EF841, 0xF748F596, 0x03B209F8,
	0xF9D6045C, 0x0C6A03D3, 0x08B80908, 0x0106F8A7,
	0x062A0000, 0xFEFAF8A7, 0x08B8F6F8, 0xF39603D3,
	0xF9D6FBA4, 0xFC4E09F8, 0xF7480A6A, 0x07B2F841,
	0x062AF9D6, 0xF84E07BF, 0xF7480A6A, 0x03B2F608,
	0xF9D6FBA4, 0x0C6AFC2D, 0x08B8F6F8, 0x01060759,
	0x062A0000, 0xFEFA0759, 0x08B80908, 0xF396FC2D,
	0xF9D6045C, 0xFC4EF608, 0xF748F596, 0x07B207BF,
	0x062A062A, 0xF84EF841, 0xF748F596, 0x03B209F8,
	0xF9D6045C, 0x0C6A03D3, 0x08B80908, 0x0106F8A7,
	0x062A0000, 0xFEFAF8A7, 0x08B8F6F8, 0xF39603D3,
	0xF9D6FBA4, 0xFC4E09F8, 0xF7480A6A, 0x07B2F841,
	0x062AF9D6, 0xF84E07BF, 0xF7480A6A, 0x03B2F608,
	0xF9D6FBA4, 0x0C6AFC2D, 0x08B8F6F8, 0x01060759,
	0x061C061C, 0xFF30009D, 0xFFB21141, 0xFD87FB54,
	0xF65DFE59, 0x02EEF99E, 0x0166F03C, 0xFFF809B6,
	0x000008A4, 0x000AF42B, 0x00EFF577, 0xFA840BF2,
	0xFC02FF51, 0x08260F67, 0xFFF0036F, 0x0842F9C3,
	0x00000000, 0x063DF7BE, 0xFC910010, 0xF099F7DA,
	0x00AF03FE, 0xF40E057C, 0x0A89FF11, 0x0BD5FFF6,
	0xF75C0000, 0xF64A0008, 0x0FC4FE9A, 0x0662FD12,
	0x01A709A3, 0x04AC0279, 0xEEBF004E, 0xFF6300D0,
	0xF9E4F9E4, 0x00D0FF63, 0x004EEEBF, 0x027904AC,
	0x09A301A7, 0xFD120662, 0xFE9A0FC4, 0x0008F64A,
	0x0000F75C, 0xFFF60BD5, 0xFF110A89, 0x057CF40E,
	0x03FE00AF, 0xF7DAF099, 0x0010FC91, 0xF7BE063D,
	0x00000000, 0xF9C30842, 0x036FFFF0, 0x0F670826,
	0xFF51FC02, 0x0BF2FA84, 0xF57700EF, 0xF42B000A,
	0x08A40000, 0x09B6FFF8, 0xF03C0166, 0xF99E02EE,
	0xFE59F65D, 0xFB54FD87, 0x1141FFB2, 0x009DFF30,
	0x05E30000, 0xFF060705, 0x085408A0, 0xF425FC59,
	0xFA1D042A, 0xFC78F67A, 0xF7ACF60E, 0x075A0766,
	0x05E305E3, 0xF8A6F89A, 0xF7ACF60E, 0x03880986,
	0xFA1D042A, 0x0BDB03A7, 0x085408A0, 0x00FAF8FB,
	0x05E30000, 0xFF06F8FB, 0x0854F760, 0xF42503A7,
	0xFA1DFBD6, 0xFC780986, 0xF7AC09F2, 0x075AF89A,
	0x05E3FA1D, 0xF8A60766, 0xF7AC09F2, 0x0388F67A,
	0xFA1DFBD6, 0x0BDBFC59, 0x0854F760, 0x00FA0705,
	0x05E30000, 0xFF060705, 0x085408A0, 0xF425FC59,
	0xFA1D042A, 0xFC78F67A, 0xF7ACF60E, 0x075A0766,
	0x05E305E3, 0xF8A6F89A, 0xF7ACF60E, 0x03880986,
	0xFA1D042A, 0x0BDB03A7, 0x085408A0, 0x00FAF8FB,
	0x05E30000, 0xFF06F8FB, 0x0854F760, 0xF42503A7,
	0xFA1DFBD6, 0xFC780986, 0xF7AC09F2, 0x075AF89A,
	0x05E3FA1D, 0xF8A60766, 0xF7AC09F2, 0x0388F67A,
	0xFA1DFBD6, 0x0BDBFC59, 0x0854F760, 0x00FA0705,
	0xFA58FA58, 0xF8F0FE00, 0x0448073D, 0xFDC9FE46,
	0xF9910258, 0x089D0407, 0xFD5CF71A, 0x02AFFDE0,
	0x083E0496, 0xFF5A0740, 0xFF7AFD97, 0x00FE01F1,
	0x0009082E, 0xFA94FF75, 0xFECDF8EA, 0xFFB0F693,
	0xFD2CFA58, 0x0433FF16, 0xFBA405DD, 0xFA610341,
	0x06A606CB, 0x0039FD2D, 0x0677FA97, 0x01FA05E0,
	0xF896003E, 0x075A068B, 0x012CFC3E, 0xFA23F98D,
	0xFC7CFD43, 0xFF90FC0D, 0x01C10982, 0x00C601D6,
	0xFD2CFD2C, 0x01D600C6, 0x098201C1, 0xFC0DFF90,
	0xFD43FC7C, 0xF98DFA23, 0xFC3E012C, 0x068B075A,
	0x003EF896, 0x05E001FA, 0xFA970677, 0xFD2D0039,
	0x06CB06A6, 0x0341FA61, 0x05DDFBA4, 0xFF160433,
	0xFA58FD2C, 0xF693FFB0, 0xF8EAFECD, 0xFF75FA94,
	0x082E0009, 0x01F100FE, 0xFD97FF7A, 0x0740FF5A,
	0x0496083E, 0xFDE002AF, 0xF71AFD5C, 0x0407089D,
	0x0258F991, 0xFE46FDC9, 0x073D0448, 0xFE00F8F0,
	0xFD2CFD2C, 0xFCE00500, 0xFC09FDDC, 0xFE680157,
	0x04C70571, 0xFC3AFF21, 0xFCD70228, 0x056D0277,
	0x0200FE00, 0x0022F927, 0xFE3C032B, 0xFC44FF3C,
	0x03E9FBDB, 0x04570313, 0x04C9FF5C, 0x000D03B8,
	0xFA580000, 0xFBE900D2, 0xF9D0FE0B, 0x0125FDF9,
	0x042501BF, 0x0328FA2B, 0xFFA902F0, 0xFA250157,
	0x0200FE00, 0x03740438, 0xFF0405FD, 0x030CFE52,
	0x0037FB39, 0xFF6904C5, 0x04F8FD23, 0xFD31FC1B,
	0xFD2CFD2C, 0xFC1BFD31, 0xFD2304F8, 0x04C5FF69,
	0xFB390037, 0xFE52030C, 0x05FDFF04, 0x04380374,
	0xFE000200, 0x0157FA25, 0x02F0FFA9, 0xFA2B0328,
	0x01BF0425, 0xFDF90125, 0xFE0BF9D0, 0x00D2FBE9,
	0x0000FA58, 0x03B8000D, 0xFF5C04C9, 0x03130457,
	0xFBDB03E9, 0xFF3CFC44, 0x032BFE3C, 0xF9270022,
	0xFE000200, 0x0277056D, 0x0228FCD7, 0xFF21FC3A,
	0x057104C7, 0x0157FE68, 0xFDDCFC09, 0x0500FCE0,
	0xFD2CFD2C, 0x0500FCE0, 0xFDDCFC09, 0x0157FE68,
	0x057104C7, 0xFF21FC3A, 0x0228FCD7, 0x0277056D,
	0xFE000200, 0xF9270022, 0x032BFE3C, 0xFF3CFC44,
	0xFBDB03E9, 0x03130457, 0xFF5C04C9, 0x03B8000D,
	0x0000FA58, 0x00D2FBE9, 0xFE0BF9D0, 0xFDF90125,
	0x01BF0425, 0xFA2B0328, 0x02F0FFA9, 0x0157FA25,
	0xFE000200, 0x04380374, 0x05FDFF04, 0xFE52030C,
	0xFB390037, 0x04C5FF69, 0xFD2304F8, 0xFC1BFD31,
	0xFD2CFD2C, 0xFD31FC1B, 0x04F8FD23, 0xFF6904C5,
	0x0037FB39, 0x030CFE52, 0xFF0405FD, 0x03740438,
	0x0200FE00, 0xFA250157, 0xFFA902F0, 0x0328FA2B,
	0x042501BF, 0x0125FDF9, 0xF9D0FE0B, 0xFBE900D2,
	0xFA580000, 0x000D03B8, 0x04C9FF5C, 0x04570313,
	0x03E9FBDB, 0xFC44FF3C, 0xFE3C032B, 0x0022F927,
	0x0200FE00, 0x056D0277, 0xFCD70228, 0xFC3AFF21,
	0x04C70571, 0xFE680157, 0xFC09FDDC, 0xFCE00500,
	0x05A80000, 0xFF1006BE, 0x0800084A, 0xF49CFC7E,
	0xFA580400, 0xFC9CF6DA, 0xF800F672, 0x0710071C,
	0x05A805A8, 0xF8F0F8E4, 0xF800F672, 0x03640926,
	0xFA580400, 0x0B640382, 0x0800084A, 0x00F0F942,
	0x05A80000, 0xFF10F942, 0x0800F7B6, 0xF49C0382,
	0xFA58FC00, 0xFC9C0926, 0xF800098E, 0x0710F8E4,
	0x05A8FA58, 0xF8F0071C, 0xF800098E, 0x0364F6DA,
	0xFA58FC00, 0x0B64FC7E, 0x0800F7B6, 0x00F006BE,
	0x05A80000, 0xFF1006BE, 0x0800084A, 0xF49CFC7E,
	0xFA580400, 0xFC9CF6DA, 0xF800F672, 0x0710071C,
	0x05A805A8, 0xF8F0F8E4, 0xF800F672, 0x03640926,
	0xFA580400, 0x0B640382, 0x0800084A, 0x00F0F942,
	0x05A80000, 0xFF10F942, 0x0800F7B6, 0xF49C0382,
	0xFA58FC00, 0xFC9C0926, 0xF800098E, 0x0710F8E4,
	0x05A8FA58, 0xF8F0071C, 0xF800098E, 0x0364F6DA,
	0xFA58FC00, 0x0B64FC7E, 0x0800F7B6, 0x00F006BE,
};

static const u32 b43_ntab_tmap[] = {
	0x8A88AA80, 0x8AAAAA8A, 0x8A8A8AA8, 0x00000888,
	0x88000000, 0x8A8A88AA, 0x8AA88888, 0x8888A8A8,
	0xF1111110, 0x11111111, 0x11F11111, 0x00000111,
	0x11000000, 0x1111F111, 0x11111111, 0x111111F1,
	0x8A88AA80, 0x8AAAAA8A, 0x8A8A8AA8, 0x000AA888,
	0x88880000, 0x8A8A88AA, 0x8AA88888, 0x8888A8A8,
	0xA1111110, 0x11111111, 0x11C11111, 0x00000111,
	0x11000000, 0x1111A111, 0x11111111, 0x111111A1,
	0xA2222220, 0x22222222, 0x22C22222, 0x00000222,
	0x22000000, 0x2222A222, 0x22222222, 0x222222A2,
	0xF1111110, 0x11111111, 0x11F11111, 0x00011111,
	0x11110000, 0x1111F111, 0x11111111, 0x111111F1,
	0xA8AA88A0, 0xA88888A8, 0xA8A8A88A, 0x00088AAA,
	0xAAAA0000, 0xA8A8AA88, 0xA88AAAAA, 0xAAAA8A8A,
	0xAAA8AAA0, 0x8AAA8AAA, 0xAA8A8A8A, 0x000AAA88,
	0x8AAA0000, 0xAAA8A888, 0x8AA88A8A, 0x8A88A888,
	0x08080A00, 0x0A08080A, 0x080A0A08, 0x00080808,
	0x080A0000, 0x080A0808, 0x080A0808, 0x0A0A0A08,
	0xA0A0A0A0, 0x80A0A080, 0x8080A0A0, 0x00008080,
	0x80A00000, 0x80A080A0, 0xA080A0A0, 0x8080A0A0,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x99999000, 0x9B9B99BB, 0x9BB99999, 0x9999B9B9,
	0x9B99BB90, 0x9BBBBB9B, 0x9B9B9BB9, 0x00000999,
	0x88000000, 0x8A8A88AA, 0x8AA88888, 0x8888A8A8,
	0x8A88AA80, 0x8AAAAA8A, 0x8A8A8AA8, 0x00AAA888,
	0x22000000, 0x2222B222, 0x22222222, 0x222222B2,
	0xB2222220, 0x22222222, 0x22D22222, 0x00000222,
	0x11000000, 0x1111A111, 0x11111111, 0x111111A1,
	0xA1111110, 0x11111111, 0x11C11111, 0x00000111,
	0x33000000, 0x3333B333, 0x33333333, 0x333333B3,
	0xB3333330, 0x33333333, 0x33D33333, 0x00000333,
	0x22000000, 0x2222A222, 0x22222222, 0x222222A2,
	0xA2222220, 0x22222222, 0x22C22222, 0x00000222,
	0x99B99B00, 0x9B9B99BB, 0x9BB99999, 0x9999B9B9,
	0x9B99BB99, 0x9BBBBB9B, 0x9B9B9BB9, 0x00000999,
	0x88000000, 0x8A8A88AA, 0x8AA88888, 0x8888A8A8,
	0x8A88AA88, 0x8AAAAA8A, 0x8A8A8AA8, 0x08AAA888,
	0x22222200, 0x2222F222, 0x22222222, 0x222222F2,
	0x22222222, 0x22222222, 0x22F22222, 0x00000222,
	0x11000000, 0x1111F111, 0x11111111, 0x11111111,
	0xF1111111, 0x11111111, 0x11F11111, 0x01111111,
	0xBB9BB900, 0xB9B9BB99, 0xB99BBBBB, 0xBBBB9B9B,
	0xB9BB99BB, 0xB99999B9, 0xB9B9B99B, 0x00000BBB,
	0xAA000000, 0xA8A8AA88, 0xA88AAAAA, 0xAAAA8A8A,
	0xA8AA88AA, 0xA88888A8, 0xA8A8A88A, 0x0A888AAA,
	0xAA000000, 0xA8A8AA88, 0xA88AAAAA, 0xAAAA8A8A,
	0xA8AA88A0, 0xA88888A8, 0xA8A8A88A, 0x00000AAA,
	0x88000000, 0x8A8A88AA, 0x8AA88888, 0x8888A8A8,
	0x8A88AA80, 0x8AAAAA8A, 0x8A8A8AA8, 0x00000888,
	0xBBBBBB00, 0x999BBBBB, 0x9BB99B9B, 0xB9B9B9BB,
	0xB9B99BBB, 0xB9B9B9BB, 0xB9BB9B99, 0x00000999,
	0x8A000000, 0xAA88A888, 0xA88888AA, 0xA88A8A88,
	0xA88AA88A, 0x88A8AAAA, 0xA8AA8AAA, 0x0888A88A,
	0x0B0B0B00, 0x090B0B0B, 0x0B090B0B, 0x0909090B,
	0x09090B0B, 0x09090B0B, 0x09090B09, 0x00000909,
	0x0A000000, 0x0A080808, 0x080A080A, 0x080A0A08,
	0x080A080A, 0x0808080A, 0x0A0A0A08, 0x0808080A,
	0xB0B0B000, 0x9090B0B0, 0x90B09090, 0xB0B0B090,
	0xB0B090B0, 0x90B0B0B0, 0xB0B09090, 0x00000090,
	0x80000000, 0xA080A080, 0xA08080A0, 0xA0808080,
	0xA080A080, 0x80A0A0A0, 0xA0A080A0, 0x00A0A0A0,
	0x22000000, 0x2222F222, 0x22222222, 0x222222F2,
	0xF2222220, 0x22222222, 0x22F22222, 0x00000222,
	0x11000000, 0x1111F111, 0x11111111, 0x111111F1,
	0xF1111110, 0x11111111, 0x11F11111, 0x00000111,
	0x33000000, 0x3333F333, 0x33333333, 0x333333F3,
	0xF3333330, 0x33333333, 0x33F33333, 0x00000333,
	0x22000000, 0x2222F222, 0x22222222, 0x222222F2,
	0xF2222220, 0x22222222, 0x22F22222, 0x00000222,
	0x99000000, 0x9B9B99BB, 0x9BB99999, 0x9999B9B9,
	0x9B99BB90, 0x9BBBBB9B, 0x9B9B9BB9, 0x00000999,
	0x88000000, 0x8A8A88AA, 0x8AA88888, 0x8888A8A8,
	0x8A88AA80, 0x8AAAAA8A, 0x8A8A8AA8, 0x00000888,
	0x88888000, 0x8A8A88AA, 0x8AA88888, 0x8888A8A8,
	0x8A88AA80, 0x8AAAAA8A, 0x8A8A8AA8, 0x00000888,
	0x88000000, 0x8A8A88AA, 0x8AA88888, 0x8888A8A8,
	0x8A88AA80, 0x8AAAAA8A, 0x8A8A8AA8, 0x00AAA888,
	0x88A88A00, 0x8A8A88AA, 0x8AA88888, 0x8888A8A8,
	0x8A88AA88, 0x8AAAAA8A, 0x8A8A8AA8, 0x00000888,
	0x88000000, 0x8A8A88AA, 0x8AA88888, 0x8888A8A8,
	0x8A88AA88, 0x8AAAAA8A, 0x8A8A8AA8, 0x08AAA888,
	0x11000000, 0x1111A111, 0x11111111, 0x111111A1,
	0xA1111110, 0x11111111, 0x11C11111, 0x00000111,
	0x11000000, 0x1111A111, 0x11111111, 0x111111A1,
	0xA1111110, 0x11111111, 0x11C11111, 0x00000111,
	0x88000000, 0x8A8A88AA, 0x8AA88888, 0x8888A8A8,
	0x8A88AA80, 0x8AAAAA8A, 0x8A8A8AA8, 0x00000888,
	0x88000000, 0x8A8A88AA, 0x8AA88888, 0x8888A8A8,
	0x8A88AA80, 0x8AAAAA8A, 0x8A8A8AA8, 0x00000888,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
};

/* static tables, PHY revision >= 3 */
static const u32 b43_ntab_framestruct_r3[] = {
	0x08004a04, 0x00100000, 0x01000a05, 0x00100020,
	0x09804506, 0x00100030, 0x09804507, 0x00100030,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x08004a0c, 0x00100004, 0x01000a0d, 0x00100024,
	0x0980450e, 0x00100034, 0x0980450f, 0x00100034,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000a04, 0x00100000, 0x11008a05, 0x00100020,
	0x1980c506, 0x00100030, 0x21810506, 0x00100030,
	0x21810506, 0x00100030, 0x01800504, 0x00100030,
	0x11808505, 0x00100030, 0x29814507, 0x01100030,
	0x00000a04, 0x00100000, 0x11008a05, 0x00100020,
	0x21810506, 0x00100030, 0x21810506, 0x00100030,
	0x29814507, 0x01100030, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000a0c, 0x00100008, 0x11008a0d, 0x00100028,
	0x1980c50e, 0x00100038, 0x2181050e, 0x00100038,
	0x2181050e, 0x00100038, 0x0180050c, 0x00100038,
	0x1180850d, 0x00100038, 0x2981450f, 0x01100038,
	0x00000a0c, 0x00100008, 0x11008a0d, 0x00100028,
	0x2181050e, 0x00100038, 0x2181050e, 0x00100038,
	0x2981450f, 0x01100038, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x08004a04, 0x00100000, 0x01000a05, 0x00100020,
	0x1980c506, 0x00100030, 0x1980c506, 0x00100030,
	0x11808504, 0x00100030, 0x3981ca05, 0x00100030,
	0x29814507, 0x01100030, 0x00000000, 0x00000000,
	0x10008a04, 0x00100000, 0x3981ca05, 0x00100030,
	0x1980c506, 0x00100030, 0x29814507, 0x01100030,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x08004a0c, 0x00100008, 0x01000a0d, 0x00100028,
	0x1980c50e, 0x00100038, 0x1980c50e, 0x00100038,
	0x1180850c, 0x00100038, 0x3981ca0d, 0x00100038,
	0x2981450f, 0x01100038, 0x00000000, 0x00000000,
	0x10008a0c, 0x00100008, 0x3981ca0d, 0x00100038,
	0x1980c50e, 0x00100038, 0x2981450f, 0x01100038,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x40021404, 0x00100000, 0x02001405, 0x00100040,
	0x0b004a06, 0x01900060, 0x13008a06, 0x01900060,
	0x13008a06, 0x01900060, 0x43020a04, 0x00100060,
	0x1b00ca05, 0x00100060, 0x23010a07, 0x01500060,
	0x40021404, 0x00100000, 0x1a00d405, 0x00100040,
	0x13008a06, 0x01900060, 0x13008a06, 0x01900060,
	0x23010a07, 0x01500060, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x4002140c, 0x00100010, 0x0200140d, 0x00100050,
	0x0b004a0e, 0x01900070, 0x13008a0e, 0x01900070,
	0x13008a0e, 0x01900070, 0x43020a0c, 0x00100070,
	0x1b00ca0d, 0x00100070, 0x23010a0f, 0x01500070,
	0x4002140c, 0x00100010, 0x1a00d40d, 0x00100050,
	0x13008a0e, 0x01900070, 0x13008a0e, 0x01900070,
	0x23010a0f, 0x01500070, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x50029404, 0x00100000, 0x32019405, 0x00100040,
	0x0b004a06, 0x01900060, 0x0b004a06, 0x01900060,
	0x5b02ca04, 0x00100060, 0x3b01d405, 0x00100060,
	0x23010a07, 0x01500060, 0x00000000, 0x00000000,
	0x5802d404, 0x00100000, 0x3b01d405, 0x00100060,
	0x0b004a06, 0x01900060, 0x23010a07, 0x01500060,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x5002940c, 0x00100010, 0x3201940d, 0x00100050,
	0x0b004a0e, 0x01900070, 0x0b004a0e, 0x01900070,
	0x5b02ca0c, 0x00100070, 0x3b01d40d, 0x00100070,
	0x23010a0f, 0x01500070, 0x00000000, 0x00000000,
	0x5802d40c, 0x00100010, 0x3b01d40d, 0x00100070,
	0x0b004a0e, 0x01900070, 0x23010a0f, 0x01500070,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x40021404, 0x000f4800, 0x62031405, 0x00100040,
	0x53028a06, 0x01900060, 0x53028a07, 0x01900060,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x4002140c, 0x000f4808, 0x6203140d, 0x00100048,
	0x53028a0e, 0x01900068, 0x53028a0f, 0x01900068,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000a0c, 0x00100004, 0x11008a0d, 0x00100024,
	0x1980c50e, 0x00100034, 0x2181050e, 0x00100034,
	0x2181050e, 0x00100034, 0x0180050c, 0x00100038,
	0x1180850d, 0x00100038, 0x1181850d, 0x00100038,
	0x2981450f, 0x01100038, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000a0c, 0x00100008, 0x11008a0d, 0x00100028,
	0x2181050e, 0x00100038, 0x2181050e, 0x00100038,
	0x1181850d, 0x00100038, 0x2981450f, 0x01100038,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x08004a04, 0x00100000, 0x01000a05, 0x00100020,
	0x0180c506, 0x00100030, 0x0180c506, 0x00100030,
	0x2180c50c, 0x00100030, 0x49820a0d, 0x0016a130,
	0x41824a0d, 0x0016a130, 0x2981450f, 0x01100030,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x2000ca0c, 0x00100000, 0x49820a0d, 0x0016a130,
	0x1980c50e, 0x00100030, 0x41824a0d, 0x0016a130,
	0x2981450f, 0x01100030, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x4002140c, 0x00100008, 0x0200140d, 0x00100048,
	0x0b004a0e, 0x01900068, 0x13008a0e, 0x01900068,
	0x13008a0e, 0x01900068, 0x43020a0c, 0x00100070,
	0x1b00ca0d, 0x00100070, 0x1b014a0d, 0x00100070,
	0x23010a0f, 0x01500070, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x4002140c, 0x00100010, 0x1a00d40d, 0x00100050,
	0x13008a0e, 0x01900070, 0x13008a0e, 0x01900070,
	0x1b014a0d, 0x00100070, 0x23010a0f, 0x01500070,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x50029404, 0x00100000, 0x32019405, 0x00100040,
	0x03004a06, 0x01900060, 0x03004a06, 0x01900060,
	0x6b030a0c, 0x00100060, 0x4b02140d, 0x0016a160,
	0x4302540d, 0x0016a160, 0x23010a0f, 0x01500060,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x6b03140c, 0x00100060, 0x4b02140d, 0x0016a160,
	0x0b004a0e, 0x01900060, 0x4302540d, 0x0016a160,
	0x23010a0f, 0x01500060, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x40021404, 0x00100000, 0x1a00d405, 0x00100040,
	0x53028a06, 0x01900060, 0x5b02ca06, 0x01900060,
	0x5b02ca06, 0x01900060, 0x43020a04, 0x00100060,
	0x1b00ca05, 0x00100060, 0x53028a07, 0x0190c060,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x4002140c, 0x00100010, 0x1a00d40d, 0x00100050,
	0x53028a0e, 0x01900070, 0x5b02ca0e, 0x01900070,
	0x5b02ca0e, 0x01900070, 0x43020a0c, 0x00100070,
	0x1b00ca0d, 0x00100070, 0x53028a0f, 0x0190c070,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x40021404, 0x00100000, 0x1a00d405, 0x00100040,
	0x5b02ca06, 0x01900060, 0x5b02ca06, 0x01900060,
	0x53028a07, 0x0190c060, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x4002140c, 0x00100010, 0x1a00d40d, 0x00100050,
	0x5b02ca0e, 0x01900070, 0x5b02ca0e, 0x01900070,
	0x53028a0f, 0x0190c070, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
};

static const u16 b43_ntab_pilot_r3[] = {
	0xff08, 0xff08, 0xff08, 0xff08, 0xff08, 0xff08,
	0xff08, 0xff08, 0x80d5, 0x80d5, 0x80d5, 0x80d5,
	0x80d5, 0x80d5, 0x80d5, 0x80d5, 0xff0a, 0xff82,
	0xffa0, 0xff28, 0xffff, 0xffff, 0xffff, 0xffff,
	0xff82, 0xffa0, 0xff28, 0xff0a, 0xffff, 0xffff,
	0xffff, 0xffff, 0xf83f, 0xfa1f, 0xfa97, 0xfab5,
	0xf2bd, 0xf0bf, 0xffff, 0xffff, 0xf017, 0xf815,
	0xf215, 0xf095, 0xf035, 0xf01d, 0xffff, 0xffff,
	0xff08, 0xff02, 0xff80, 0xff20, 0xff08, 0xff02,
	0xff80, 0xff20, 0xf01f, 0xf817, 0xfa15, 0xf295,
	0xf0b5, 0xf03d, 0xffff, 0xffff, 0xf82a, 0xfa0a,
	0xfa82, 0xfaa0, 0xf2a8, 0xf0aa, 0xffff, 0xffff,
	0xf002, 0xf800, 0xf200, 0xf080, 0xf020, 0xf008,
	0xffff, 0xffff, 0xf00a, 0xf802, 0xfa00, 0xf280,
	0xf0a0, 0xf028, 0xffff, 0xffff,
};

static const u32 b43_ntab_tmap_r3[] = {
	0x8a88aa80, 0x8aaaaa8a, 0x8a8a8aa8, 0x00000888,
	0x88000000, 0x8a8a88aa, 0x8aa88888, 0x8888a8a8,
	0xf1111110, 0x11111111, 0x11f11111, 0x00000111,
	0x11000000, 0x1111f111, 0x11111111, 0x111111f1,
	0x8a88aa80, 0x8aaaaa8a, 0x8a8a8aa8, 0x000aa888,
	0x88880000, 0x8a8a88aa, 0x8aa88888, 0x8888a8a8,
	0xa1111110, 0x11111111, 0x11c11111, 0x00000111,
	0x11000000, 0x1111a111, 0x11111111, 0x111111a1,
	0xa2222220, 0x22222222, 0x22c22222, 0x00000222,
	0x22000000, 0x2222a222, 0x22222222, 0x222222a2,
	0xf1111110, 0x11111111, 0x11f11111, 0x00011111,
	0x11110000, 0x1111f111, 0x11111111, 0x111111f1,
	0xa8aa88a0, 0xa88888a8, 0xa8a8a88a, 0x00088aaa,
	0xaaaa0000, 0xa8a8aa88, 0xa88aaaaa, 0xaaaa8a8a,
	0xaaa8aaa0, 0x8aaa8aaa, 0xaa8a8a8a, 0x000aaa88,
	0x8aaa0000, 0xaaa8a888, 0x8aa88a8a, 0x8a88a888,
	0x08080a00, 0x0a08080a, 0x080a0a08, 0x00080808,
	0x080a0000, 0x080a0808, 0x080a0808, 0x0a0a0a08,
	0xa0a0a0a0, 0x80a0a080, 0x8080a0a0, 0x00008080,
	0x80a00000, 0x80a080a0, 0xa080a0a0, 0x8080a0a0,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x99999000, 0x9b9b99bb, 0x9bb99999, 0x9999b9b9,
	0x9b99bb90, 0x9bbbbb9b, 0x9b9b9bb9, 0x00000999,
	0x88000000, 0x8a8a88aa, 0x8aa88888, 0x8888a8a8,
	0x8a88aa80, 0x8aaaaa8a, 0x8a8a8aa8, 0x00aaa888,
	0x22000000, 0x2222b222, 0x22222222, 0x222222b2,
	0xb2222220, 0x22222222, 0x22d22222, 0x00000222,
	0x11000000, 0x1111a111, 0x11111111, 0x111111a1,
	0xa1111110, 0x11111111, 0x11c11111, 0x00000111,
	0x33000000, 0x3333b333, 0x33333333, 0x333333b3,
	0xb3333330, 0x33333333, 0x33d33333, 0x00000333,
	0x22000000, 0x2222a222, 0x22222222, 0x222222a2,
	0xa2222220, 0x22222222, 0x22c22222, 0x00000222,
	0x99b99b00, 0x9b9b99bb, 0x9bb99999, 0x9999b9b9,
	0x9b99bb99, 0x9bbbbb9b, 0x9b9b9bb9, 0x00000999,
	0x88000000, 0x8a8a88aa, 0x8aa88888, 0x8888a8a8,
	0x8a88aa88, 0x8aaaaa8a, 0x8a8a8aa8, 0x08aaa888,
	0x22222200, 0x2222f222, 0x22222222, 0x222222f2,
	0x22222222, 0x22222222, 0x22f22222, 0x00000222,
	0x11000000, 0x1111f111, 0x11111111, 0x11111111,
	0xf1111111, 0x11111111, 0x11f11111, 0x01111111,
	0xbb9bb900, 0xb9b9bb99, 0xb99bbbbb, 0xbbbb9b9b,
	0xb9bb99bb, 0xb99999b9, 0xb9b9b99b, 0x00000bbb,
	0xaa000000, 0xa8a8aa88, 0xa88aaaaa, 0xaaaa8a8a,
	0xa8aa88aa, 0xa88888a8, 0xa8a8a88a, 0x0a888aaa,
	0xaa000000, 0xa8a8aa88, 0xa88aaaaa, 0xaaaa8a8a,
	0xa8aa88a0, 0xa88888a8, 0xa8a8a88a, 0x00000aaa,
	0x88000000, 0x8a8a88aa, 0x8aa88888, 0x8888a8a8,
	0x8a88aa80, 0x8aaaaa8a, 0x8a8a8aa8, 0x00000888,
	0xbbbbbb00, 0x999bbbbb, 0x9bb99b9b, 0xb9b9b9bb,
	0xb9b99bbb, 0xb9b9b9bb, 0xb9bb9b99, 0x00000999,
	0x8a000000, 0xaa88a888, 0xa88888aa, 0xa88a8a88,
	0xa88aa88a, 0x88a8aaaa, 0xa8aa8aaa, 0x0888a88a,
	0x0b0b0b00, 0x090b0b0b, 0x0b090b0b, 0x0909090b,
	0x09090b0b, 0x09090b0b, 0x09090b09, 0x00000909,
	0x0a000000, 0x0a080808, 0x080a080a, 0x080a0a08,
	0x080a080a, 0x0808080a, 0x0a0a0a08, 0x0808080a,
	0xb0b0b000, 0x9090b0b0, 0x90b09090, 0xb0b0b090,
	0xb0b090b0, 0x90b0b0b0, 0xb0b09090, 0x00000090,
	0x80000000, 0xa080a080, 0xa08080a0, 0xa0808080,
	0xa080a080, 0x80a0a0a0, 0xa0a080a0, 0x00a0a0a0,
	0x22000000, 0x2222f222, 0x22222222, 0x222222f2,
	0xf2222220, 0x22222222, 0x22f22222, 0x00000222,
	0x11000000, 0x1111f111, 0x11111111, 0x111111f1,
	0xf1111110, 0x11111111, 0x11f11111, 0x00000111,
	0x33000000, 0x3333f333, 0x33333333, 0x333333f3,
	0xf3333330, 0x33333333, 0x33f33333, 0x00000333,
	0x22000000, 0x2222f222, 0x22222222, 0x222222f2,
	0xf2222220, 0x22222222, 0x22f22222, 0x00000222,
	0x99000000, 0x9b9b99bb, 0x9bb99999, 0x9999b9b9,
	0x9b99bb90, 0x9bbbbb9b, 0x9b9b9bb9, 0x00000999,
	0x88000000, 0x8a8a88aa, 0x8aa88888, 0x8888a8a8,
	0x8a88aa80, 0x8aaaaa8a, 0x8a8a8aa8, 0x00000888,
	0x88888000, 0x8a8a88aa, 0x8aa88888, 0x8888a8a8,
	0x8a88aa80, 0x8aaaaa8a, 0x8a8a8aa8, 0x00000888,
	0x88000000, 0x8a8a88aa, 0x8aa88888, 0x8888a8a8,
	0x8a88aa80, 0x8aaaaa8a, 0x8a8a8aa8, 0x00aaa888,
	0x88a88a00, 0x8a8a88aa, 0x8aa88888, 0x8888a8a8,
	0x8a88aa88, 0x8aaaaa8a, 0x8a8a8aa8, 0x00000888,
	0x88000000, 0x8a8a88aa, 0x8aa88888, 0x8888a8a8,
	0x8a88aa88, 0x8aaaaa8a, 0x8a8a8aa8, 0x08aaa888,
	0x11000000, 0x1111a111, 0x11111111, 0x111111a1,
	0xa1111110, 0x11111111, 0x11c11111, 0x00000111,
	0x11000000, 0x1111a111, 0x11111111, 0x111111a1,
	0xa1111110, 0x11111111, 0x11c11111, 0x00000111,
	0x88000000, 0x8a8a88aa, 0x8aa88888, 0x8888a8a8,
	0x8a88aa80, 0x8aaaaa8a, 0x8a8a8aa8, 0x00000888,
	0x88000000, 0x8a8a88aa, 0x8aa88888, 0x8888a8a8,
	0x8a88aa80, 0x8aaaaa8a, 0x8a8a8aa8, 0x00000888,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
};

static const u32 b43_ntab_intlevel_r3[] = {
	0x00802070, 0x0671188d, 0x0a60192c, 0x0a300e46,
	0x00c1188d, 0x080024d2, 0x00000070,
};

static const u32 b43_ntab_tdtrn_r3[] = {
	0x061c061c, 0x0050ee68, 0xf592fe36, 0xfe5212f6,
	0x00000c38, 0xfe5212f6, 0xf592fe36, 0x0050ee68,
	0x061c061c, 0xee680050, 0xfe36f592, 0x12f6fe52,
	0x0c380000, 0x12f6fe52, 0xfe36f592, 0xee680050,
	0x061c061c, 0x0050ee68, 0xf592fe36, 0xfe5212f6,
	0x00000c38, 0xfe5212f6, 0xf592fe36, 0x0050ee68,
	0x061c061c, 0xee680050, 0xfe36f592, 0x12f6fe52,
	0x0c380000, 0x12f6fe52, 0xfe36f592, 0xee680050,
	0x05e305e3, 0x004def0c, 0xf5f3fe47, 0xfe611246,
	0x00000bc7, 0xfe611246, 0xf5f3fe47, 0x004def0c,
	0x05e305e3, 0xef0c004d, 0xfe47f5f3, 0x1246fe61,
	0x0bc70000, 0x1246fe61, 0xfe47f5f3, 0xef0c004d,
	0x05e305e3, 0x004def0c, 0xf5f3fe47, 0xfe611246,
	0x00000bc7, 0xfe611246, 0xf5f3fe47, 0x004def0c,
	0x05e305e3, 0xef0c004d, 0xfe47f5f3, 0x1246fe61,
	0x0bc70000, 0x1246fe61, 0xfe47f5f3, 0xef0c004d,
	0xfa58fa58, 0xf895043b, 0xff4c09c0, 0xfbc6ffa8,
	0xfb84f384, 0x0798f6f9, 0x05760122, 0x058409f6,
	0x0b500000, 0x05b7f542, 0x08860432, 0x06ddfee7,
	0xfb84f384, 0xf9d90664, 0xf7e8025c, 0x00fff7bd,
	0x05a805a8, 0xf7bd00ff, 0x025cf7e8, 0x0664f9d9,
	0xf384fb84, 0xfee706dd, 0x04320886, 0xf54205b7,
	0x00000b50, 0x09f60584, 0x01220576, 0xf6f90798,
	0xf384fb84, 0xffa8fbc6, 0x09c0ff4c, 0x043bf895,
	0x02d402d4, 0x07de0270, 0xfc96079c, 0xf90afe94,
	0xfe00ff2c, 0x02d4065d, 0x092a0096, 0x0014fbb8,
	0xfd2cfd2c, 0x076afb3c, 0x0096f752, 0xf991fd87,
	0xfb2c0200, 0xfeb8f960, 0x08e0fc96, 0x049802a8,
	0xfd2cfd2c, 0x02a80498, 0xfc9608e0, 0xf960feb8,
	0x0200fb2c, 0xfd87f991, 0xf7520096, 0xfb3c076a,
	0xfd2cfd2c, 0xfbb80014, 0x0096092a, 0x065d02d4,
	0xff2cfe00, 0xfe94f90a, 0x079cfc96, 0x027007de,
	0x02d402d4, 0x027007de, 0x079cfc96, 0xfe94f90a,
	0xff2cfe00, 0x065d02d4, 0x0096092a, 0xfbb80014,
	0xfd2cfd2c, 0xfb3c076a, 0xf7520096, 0xfd87f991,
	0x0200fb2c, 0xf960feb8, 0xfc9608e0, 0x02a80498,
	0xfd2cfd2c, 0x049802a8, 0x08e0fc96, 0xfeb8f960,
	0xfb2c0200, 0xf991fd87, 0x0096f752, 0x076afb3c,
	0xfd2cfd2c, 0x0014fbb8, 0x092a0096, 0x02d4065d,
	0xfe00ff2c, 0xf90afe94, 0xfc96079c, 0x07de0270,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x062a0000, 0xfefa0759, 0x08b80908, 0xf396fc2d,
	0xf9d6045c, 0xfc4ef608, 0xf748f596, 0x07b207bf,
	0x062a062a, 0xf84ef841, 0xf748f596, 0x03b209f8,
	0xf9d6045c, 0x0c6a03d3, 0x08b80908, 0x0106f8a7,
	0x062a0000, 0xfefaf8a7, 0x08b8f6f8, 0xf39603d3,
	0xf9d6fba4, 0xfc4e09f8, 0xf7480a6a, 0x07b2f841,
	0x062af9d6, 0xf84e07bf, 0xf7480a6a, 0x03b2f608,
	0xf9d6fba4, 0x0c6afc2d, 0x08b8f6f8, 0x01060759,
	0x062a0000, 0xfefa0759, 0x08b80908, 0xf396fc2d,
	0xf9d6045c, 0xfc4ef608, 0xf748f596, 0x07b207bf,
	0x062a062a, 0xf84ef841, 0xf748f596, 0x03b209f8,
	0xf9d6045c, 0x0c6a03d3, 0x08b80908, 0x0106f8a7,
	0x062a0000, 0xfefaf8a7, 0x08b8f6f8, 0xf39603d3,
	0xf9d6fba4, 0xfc4e09f8, 0xf7480a6a, 0x07b2f841,
	0x062af9d6, 0xf84e07bf, 0xf7480a6a, 0x03b2f608,
	0xf9d6fba4, 0x0c6afc2d, 0x08b8f6f8, 0x01060759,
	0x061c061c, 0xff30009d, 0xffb21141, 0xfd87fb54,
	0xf65dfe59, 0x02eef99e, 0x0166f03c, 0xfff809b6,
	0x000008a4, 0x000af42b, 0x00eff577, 0xfa840bf2,
	0xfc02ff51, 0x08260f67, 0xfff0036f, 0x0842f9c3,
	0x00000000, 0x063df7be, 0xfc910010, 0xf099f7da,
	0x00af03fe, 0xf40e057c, 0x0a89ff11, 0x0bd5fff6,
	0xf75c0000, 0xf64a0008, 0x0fc4fe9a, 0x0662fd12,
	0x01a709a3, 0x04ac0279, 0xeebf004e, 0xff6300d0,
	0xf9e4f9e4, 0x00d0ff63, 0x004eeebf, 0x027904ac,
	0x09a301a7, 0xfd120662, 0xfe9a0fc4, 0x0008f64a,
	0x0000f75c, 0xfff60bd5, 0xff110a89, 0x057cf40e,
	0x03fe00af, 0xf7daf099, 0x0010fc91, 0xf7be063d,
	0x00000000, 0xf9c30842, 0x036ffff0, 0x0f670826,
	0xff51fc02, 0x0bf2fa84, 0xf57700ef, 0xf42b000a,
	0x08a40000, 0x09b6fff8, 0xf03c0166, 0xf99e02ee,
	0xfe59f65d, 0xfb54fd87, 0x1141ffb2, 0x009dff30,
	0x05e30000, 0xff060705, 0x085408a0, 0xf425fc59,
	0xfa1d042a, 0xfc78f67a, 0xf7acf60e, 0x075a0766,
	0x05e305e3, 0xf8a6f89a, 0xf7acf60e, 0x03880986,
	0xfa1d042a, 0x0bdb03a7, 0x085408a0, 0x00faf8fb,
	0x05e30000, 0xff06f8fb, 0x0854f760, 0xf42503a7,
	0xfa1dfbd6, 0xfc780986, 0xf7ac09f2, 0x075af89a,
	0x05e3fa1d, 0xf8a60766, 0xf7ac09f2, 0x0388f67a,
	0xfa1dfbd6, 0x0bdbfc59, 0x0854f760, 0x00fa0705,
	0x05e30000, 0xff060705, 0x085408a0, 0xf425fc59,
	0xfa1d042a, 0xfc78f67a, 0xf7acf60e, 0x075a0766,
	0x05e305e3, 0xf8a6f89a, 0xf7acf60e, 0x03880986,
	0xfa1d042a, 0x0bdb03a7, 0x085408a0, 0x00faf8fb,
	0x05e30000, 0xff06f8fb, 0x0854f760, 0xf42503a7,
	0xfa1dfbd6, 0xfc780986, 0xf7ac09f2, 0x075af89a,
	0x05e3fa1d, 0xf8a60766, 0xf7ac09f2, 0x0388f67a,
	0xfa1dfbd6, 0x0bdbfc59, 0x0854f760, 0x00fa0705,
	0xfa58fa58, 0xf8f0fe00, 0x0448073d, 0xfdc9fe46,
	0xf9910258, 0x089d0407, 0xfd5cf71a, 0x02affde0,
	0x083e0496, 0xff5a0740, 0xff7afd97, 0x00fe01f1,
	0x0009082e, 0xfa94ff75, 0xfecdf8ea, 0xffb0f693,
	0xfd2cfa58, 0x0433ff16, 0xfba405dd, 0xfa610341,
	0x06a606cb, 0x0039fd2d, 0x0677fa97, 0x01fa05e0,
	0xf896003e, 0x075a068b, 0x012cfc3e, 0xfa23f98d,
	0xfc7cfd43, 0xff90fc0d, 0x01c10982, 0x00c601d6,
	0xfd2cfd2c, 0x01d600c6, 0x098201c1, 0xfc0dff90,
	0xfd43fc7c, 0xf98dfa23, 0xfc3e012c, 0x068b075a,
	0x003ef896, 0x05e001fa, 0xfa970677, 0xfd2d0039,
	0x06cb06a6, 0x0341fa61, 0x05ddfba4, 0xff160433,
	0xfa58fd2c, 0xf693ffb0, 0xf8eafecd, 0xff75fa94,
	0x082e0009, 0x01f100fe, 0xfd97ff7a, 0x0740ff5a,
	0x0496083e, 0xfde002af, 0xf71afd5c, 0x0407089d,
	0x0258f991, 0xfe46fdc9, 0x073d0448, 0xfe00f8f0,
	0xfd2cfd2c, 0xfce00500, 0xfc09fddc, 0xfe680157,
	0x04c70571, 0xfc3aff21, 0xfcd70228, 0x056d0277,
	0x0200fe00, 0x0022f927, 0xfe3c032b, 0xfc44ff3c,
	0x03e9fbdb, 0x04570313, 0x04c9ff5c, 0x000d03b8,
	0xfa580000, 0xfbe900d2, 0xf9d0fe0b, 0x0125fdf9,
	0x042501bf, 0x0328fa2b, 0xffa902f0, 0xfa250157,
	0x0200fe00, 0x03740438, 0xff0405fd, 0x030cfe52,
	0x0037fb39, 0xff6904c5, 0x04f8fd23, 0xfd31fc1b,
	0xfd2cfd2c, 0xfc1bfd31, 0xfd2304f8, 0x04c5ff69,
	0xfb390037, 0xfe52030c, 0x05fdff04, 0x04380374,
	0xfe000200, 0x0157fa25, 0x02f0ffa9, 0xfa2b0328,
	0x01bf0425, 0xfdf90125, 0xfe0bf9d0, 0x00d2fbe9,
	0x0000fa58, 0x03b8000d, 0xff5c04c9, 0x03130457,
	0xfbdb03e9, 0xff3cfc44, 0x032bfe3c, 0xf9270022,
	0xfe000200, 0x0277056d, 0x0228fcd7, 0xff21fc3a,
	0x057104c7, 0x0157fe68, 0xfddcfc09, 0x0500fce0,
	0xfd2cfd2c, 0x0500fce0, 0xfddcfc09, 0x0157fe68,
	0x057104c7, 0xff21fc3a, 0x0228fcd7, 0x0277056d,
	0xfe000200, 0xf9270022, 0x032bfe3c, 0xff3cfc44,
	0xfbdb03e9, 0x03130457, 0xff5c04c9, 0x03b8000d,
	0x0000fa58, 0x00d2fbe9, 0xfe0bf9d0, 0xfdf90125,
	0x01bf0425, 0xfa2b0328, 0x02f0ffa9, 0x0157fa25,
	0xfe000200, 0x04380374, 0x05fdff04, 0xfe52030c,
	0xfb390037, 0x04c5ff69, 0xfd2304f8, 0xfc1bfd31,
	0xfd2cfd2c, 0xfd31fc1b, 0x04f8fd23, 0xff6904c5,
	0x0037fb39, 0x030cfe52, 0xff0405fd, 0x03740438,
	0x0200fe00, 0xfa250157, 0xffa902f0, 0x0328fa2b,
	0x042501bf, 0x0125fdf9, 0xf9d0fe0b, 0xfbe900d2,
	0xfa580000, 0x000d03b8, 0x04c9ff5c, 0x04570313,
	0x03e9fbdb, 0xfc44ff3c, 0xfe3c032b, 0x0022f927,
	0x0200fe00, 0x056d0277, 0xfcd70228, 0xfc3aff21,
	0x04c70571, 0xfe680157, 0xfc09fddc, 0xfce00500,
	0x05a80000, 0xff1006be, 0x0800084a, 0xf49cfc7e,
	0xfa580400, 0xfc9cf6da, 0xf800f672, 0x0710071c,
	0x05a805a8, 0xf8f0f8e4, 0xf800f672, 0x03640926,
	0xfa580400, 0x0b640382, 0x0800084a, 0x00f0f942,
	0x05a80000, 0xff10f942, 0x0800f7b6, 0xf49c0382,
	0xfa58fc00, 0xfc9c0926, 0xf800098e, 0x0710f8e4,
	0x05a8fa58, 0xf8f0071c, 0xf800098e, 0x0364f6da,
	0xfa58fc00, 0x0b64fc7e, 0x0800f7b6, 0x00f006be,
	0x05a80000, 0xff1006be, 0x0800084a, 0xf49cfc7e,
	0xfa580400, 0xfc9cf6da, 0xf800f672, 0x0710071c,
	0x05a805a8, 0xf8f0f8e4, 0xf800f672, 0x03640926,
	0xfa580400, 0x0b640382, 0x0800084a, 0x00f0f942,
	0x05a80000, 0xff10f942, 0x0800f7b6, 0xf49c0382,
	0xfa58fc00, 0xfc9c0926, 0xf800098e, 0x0710f8e4,
	0x05a8fa58, 0xf8f0071c, 0xf800098e, 0x0364f6da,
	0xfa58fc00, 0x0b64fc7e, 0x0800f7b6, 0x00f006be,
};

static const u32 b43_ntab_noisevar_r3[] = {
	0x02110211, 0x0000014d, 0x02110211, 0x0000014d,
	0x02110211, 0x0000014d, 0x02110211, 0x0000014d,
	0x02110211, 0x0000014d, 0x02110211, 0x0000014d,
	0x02110211, 0x0000014d, 0x02110211, 0x0000014d,
	0x02110211, 0x0000014d, 0x02110211, 0x0000014d,
	0x02110211, 0x0000014d, 0x02110211, 0x0000014d,
	0x02110211, 0x0000014d, 0x02110211, 0x0000014d,
	0x02110211, 0x0000014d, 0x02110211, 0x0000014d,
	0x02110211, 0x0000014d, 0x02110211, 0x0000014d,
	0x02110211, 0x0000014d, 0x02110211, 0x0000014d,
	0x02110211, 0x0000014d, 0x02110211, 0x0000014d,
	0x02110211, 0x0000014d, 0x02110211, 0x0000014d,
	0x02110211, 0x0000014d, 0x02110211, 0x0000014d,
	0x02110211, 0x0000014d, 0x02110211, 0x0000014d,
	0x02110211, 0x0000014d, 0x02110211, 0x0000014d,
	0x02110211, 0x0000014d, 0x02110211, 0x0000014d,
	0x02110211, 0x0000014d, 0x02110211, 0x0000014d,
	0x02110211, 0x0000014d, 0x02110211, 0x0000014d,
	0x02110211, 0x0000014d, 0x02110211, 0x0000014d,
	0x02110211, 0x0000014d, 0x02110211, 0x0000014d,
	0x02110211, 0x0000014d, 0x02110211, 0x0000014d,
	0x02110211, 0x0000014d, 0x02110211, 0x0000014d,
	0x02110211, 0x0000014d, 0x02110211, 0x0000014d,
	0x02110211, 0x0000014d, 0x02110211, 0x0000014d,
	0x02110211, 0x0000014d, 0x02110211, 0x0000014d,
	0x02110211, 0x0000014d, 0x02110211, 0x0000014d,
	0x02110211, 0x0000014d, 0x02110211, 0x0000014d,
	0x02110211, 0x0000014d, 0x02110211, 0x0000014d,
	0x02110211, 0x0000014d, 0x02110211, 0x0000014d,
	0x02110211, 0x0000014d, 0x02110211, 0x0000014d,
	0x02110211, 0x0000014d, 0x02110211, 0x0000014d,
	0x02110211, 0x0000014d, 0x02110211, 0x0000014d,
	0x02110211, 0x0000014d, 0x02110211, 0x0000014d,
	0x02110211, 0x0000014d, 0x02110211, 0x0000014d,
	0x02110211, 0x0000014d, 0x02110211, 0x0000014d,
	0x02110211, 0x0000014d, 0x02110211, 0x0000014d,
	0x02110211, 0x0000014d, 0x02110211, 0x0000014d,
	0x02110211, 0x0000014d, 0x02110211, 0x0000014d,
	0x02110211, 0x0000014d, 0x02110211, 0x0000014d,
	0x02110211, 0x0000014d, 0x02110211, 0x0000014d,
	0x02110211, 0x0000014d, 0x02110211, 0x0000014d,
	0x02110211, 0x0000014d, 0x02110211, 0x0000014d,
	0x02110211, 0x0000014d, 0x02110211, 0x0000014d,
	0x02110211, 0x0000014d, 0x02110211, 0x0000014d,
	0x02110211, 0x0000014d, 0x02110211, 0x0000014d,
	0x02110211, 0x0000014d, 0x02110211, 0x0000014d,
	0x02110211, 0x0000014d, 0x02110211, 0x0000014d,
	0x02110211, 0x0000014d, 0x02110211, 0x0000014d,
	0x02110211, 0x0000014d, 0x02110211, 0x0000014d,
	0x02110211, 0x0000014d, 0x02110211, 0x0000014d,
	0x02110211, 0x0000014d, 0x02110211, 0x0000014d,
	0x02110211, 0x0000014d, 0x02110211, 0x0000014d,
	0x02110211, 0x0000014d, 0x02110211, 0x0000014d,
	0x02110211, 0x0000014d, 0x02110211, 0x0000014d,
	0x02110211, 0x0000014d, 0x02110211, 0x0000014d,
	0x02110211, 0x0000014d, 0x02110211, 0x0000014d,
	0x02110211, 0x0000014d, 0x02110211, 0x0000014d,
	0x02110211, 0x0000014d, 0x02110211, 0x0000014d,
	0x02110211, 0x0000014d, 0x02110211, 0x0000014d,
	0x02110211, 0x0000014d, 0x02110211, 0x0000014d,
	0x02110211, 0x0000014d, 0x02110211, 0x0000014d,
	0x02110211, 0x0000014d, 0x02110211, 0x0000014d,
	0x02110211, 0x0000014d, 0x02110211, 0x0000014d,
	0x02110211, 0x0000014d, 0x02110211, 0x0000014d,
};

static const u16 b43_ntab_mcs_r3[] = {
	0x0000, 0x0008, 0x000a, 0x0010, 0x0012, 0x0019,
	0x001a, 0x001c, 0x0080, 0x0088, 0x008a, 0x0090,
	0x0092, 0x0099, 0x009a, 0x009c, 0x0100, 0x0108,
	0x010a, 0x0110, 0x0112, 0x0119, 0x011a, 0x011c,
	0x0180, 0x0188, 0x018a, 0x0190, 0x0192, 0x0199,
	0x019a, 0x019c, 0x0000, 0x0098, 0x00a0, 0x00a8,
	0x009a, 0x00a2, 0x00aa, 0x0120, 0x0128, 0x0128,
	0x0130, 0x0138, 0x0138, 0x0140, 0x0122, 0x012a,
	0x012a, 0x0132, 0x013a, 0x013a, 0x0142, 0x01a8,
	0x01b0, 0x01b8, 0x01b0, 0x01b8, 0x01c0, 0x01c8,
	0x01c0, 0x01c8, 0x01d0, 0x01d0, 0x01d8, 0x01aa,
	0x01b2, 0x01ba, 0x01b2, 0x01ba, 0x01c2, 0x01ca,
	0x01c2, 0x01ca, 0x01d2, 0x01d2, 0x01da, 0x0001,
	0x0002, 0x0004, 0x0009, 0x000c, 0x0011, 0x0014,
	0x0018, 0x0020, 0x0021, 0x0022, 0x0024, 0x0081,
	0x0082, 0x0084, 0x0089, 0x008c, 0x0091, 0x0094,
	0x0098, 0x00a0, 0x00a1, 0x00a2, 0x00a4, 0x0007,
	0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
	0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
	0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
	0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
	0x0007, 0x0007,
};

static const u32 b43_ntab_tdi20a0_r3[] = {
	0x00091226, 0x000a1429, 0x000b56ad, 0x000c58b0,
	0x000d5ab3, 0x000e9cb6, 0x000f9eba, 0x0000c13d,
	0x00020301, 0x00030504, 0x00040708, 0x0005090b,
	0x00064b8e, 0x00095291, 0x000a5494, 0x000b9718,
	0x000c9927, 0x000d9b2a, 0x000edd2e, 0x000fdf31,
	0x000101b4, 0x000243b7, 0x000345bb, 0x000447be,
	0x00058982, 0x00068c05, 0x00099309, 0x000a950c,
	0x000bd78f, 0x000cd992, 0x000ddb96, 0x000f1d99,
	0x00005fa8, 0x0001422c, 0x0002842f, 0x00038632,
	0x00048835, 0x0005ca38, 0x0006ccbc, 0x0009d3bf,
	0x000b1603, 0x000c1806, 0x000d1a0a, 0x000e1c0d,
	0x000f5e10, 0x00008093, 0x00018297, 0x0002c49a,
	0x0003c680, 0x0004c880, 0x00060b00, 0x00070d00,
	0x00000000, 0x00000000, 0x00000000,
};

static const u32 b43_ntab_tdi20a1_r3[] = {
	0x00014b26, 0x00028d29, 0x000393ad, 0x00049630,
	0x0005d833, 0x0006da36, 0x00099c3a, 0x000a9e3d,
	0x000bc081, 0x000cc284, 0x000dc488, 0x000f068b,
	0x0000488e, 0x00018b91, 0x0002d214, 0x0003d418,
	0x0004d6a7, 0x000618aa, 0x00071aae, 0x0009dcb1,
	0x000b1eb4, 0x000c0137, 0x000d033b, 0x000e053e,
	0x000f4702, 0x00008905, 0x00020c09, 0x0003128c,
	0x0004148f, 0x00051712, 0x00065916, 0x00091b19,
	0x000a1d28, 0x000b5f2c, 0x000c41af, 0x000d43b2,
	0x000e85b5, 0x000f87b8, 0x0000c9bc, 0x00024cbf,
	0x00035303, 0x00045506, 0x0005978a, 0x0006998d,
	0x00095b90, 0x000a5d93, 0x000b9f97, 0x000c821a,
	0x000d8400, 0x000ec600, 0x000fc800, 0x00010a00,
	0x00000000, 0x00000000, 0x00000000,
};

static const u32 b43_ntab_tdi40a0_r3[] = {
	0x0011a346, 0x00136ccf, 0x0014f5d9, 0x001641e2,
	0x0017cb6b, 0x00195475, 0x001b2383, 0x001cad0c,
	0x001e7616, 0x0000821f, 0x00020ba8, 0x0003d4b2,
	0x00056447, 0x00072dd0, 0x0008b6da, 0x000a02e3,
	0x000b8c6c, 0x000d15f6, 0x0011e484, 0x0013ae0d,
	0x00153717, 0x00168320, 0x00180ca9, 0x00199633,
	0x001b6548, 0x001ceed1, 0x001eb7db, 0x0000c3e4,
	0x00024d6d, 0x000416f7, 0x0005a585, 0x00076f0f,
	0x0008f818, 0x000a4421, 0x000bcdab, 0x000d9734,
	0x00122649, 0x0013efd2, 0x001578dc, 0x0016c4e5,
	0x00184e6e, 0x001a17f8, 0x001ba686, 0x001d3010,
	0x001ef999, 0x00010522, 0x00028eac, 0x00045835,
	0x0005e74a, 0x0007b0d3, 0x00093a5d, 0x000a85e6,
	0x000c0f6f, 0x000dd8f9, 0x00126787, 0x00143111,
	0x0015ba9a, 0x00170623, 0x00188fad, 0x001a5936,
	0x001be84b, 0x001db1d4, 0x001f3b5e, 0x000146e7,
	0x00031070, 0x000499fa, 0x00062888, 0x0007f212,
	0x00097b9b, 0x000ac7a4, 0x000c50ae, 0x000e1a37,
	0x0012a94c, 0x001472d5, 0x0015fc5f, 0x00174868,
	0x0018d171, 0x001a9afb, 0x001c2989, 0x001df313,
	0x001f7c9c, 0x000188a5, 0x000351af, 0x0004db38,
	0x0006aa4d, 0x000833d7, 0x0009bd60, 0x000b0969,
	0x000c9273, 0x000e5bfc, 0x00132a8a, 0x0014b414,
	0x00163d9d, 0x001789a6, 0x001912b0, 0x001adc39,
	0x001c6bce, 0x001e34d8, 0x001fbe61, 0x0001ca6a,
	0x00039374, 0x00051cfd, 0x0006ec0b, 0x00087515,
	0x0009fe9e, 0x000b4aa7, 0x000cd3b1, 0x000e9d3a,
	0x00000000, 0x00000000,
};

static const u32 b43_ntab_tdi40a1_r3[] = {
	0x001edb36, 0x000129ca, 0x0002b353, 0x00047cdd,
	0x0005c8e6, 0x000791ef, 0x00091bf9, 0x000aaa07,
	0x000c3391, 0x000dfd1a, 0x00120923, 0x0013d22d,
	0x00155c37, 0x0016eacb, 0x00187454, 0x001a3dde,
	0x001b89e7, 0x001d12f0, 0x001f1cfa, 0x00016b88,
	0x00033492, 0x0004be1b, 0x00060a24, 0x0007d32e,
	0x00095d38, 0x000aec4c, 0x000c7555, 0x000e3edf,
	0x00124ae8, 0x001413f1, 0x0015a37b, 0x00172c89,
	0x0018b593, 0x001a419c, 0x001bcb25, 0x001d942f,
	0x001f63b9, 0x0001ad4d, 0x00037657, 0x0004c260,
	0x00068be9, 0x000814f3, 0x0009a47c, 0x000b2d8a,
	0x000cb694, 0x000e429d, 0x00128c26, 0x001455b0,
	0x0015e4ba, 0x00176e4e, 0x0018f758, 0x001a8361,
	0x001c0cea, 0x001dd674, 0x001fa57d, 0x0001ee8b,
	0x0003b795, 0x0005039e, 0x0006cd27, 0x000856b1,
	0x0009e5c6, 0x000b6f4f, 0x000cf859, 0x000e8462,
	0x00130deb, 0x00149775, 0x00162603, 0x0017af8c,
	0x00193896, 0x001ac49f, 0x001c4e28, 0x001e17b2,
	0x0000a6c7, 0x00023050, 0x0003f9da, 0x00054563,
	0x00070eec, 0x00089876, 0x000a2704, 0x000bb08d,
	0x000d3a17, 0x001185a0, 0x00134f29, 0x0014d8b3,
	0x001667c8, 0x0017f151, 0x00197adb, 0x001b0664,
	0x001c8fed, 0x001e5977, 0x0000e805, 0x0002718f,
	0x00043b18, 0x000586a1, 0x0007502b, 0x0008d9b4,
	0x000a68c9, 0x000bf252, 0x000dbbdc, 0x0011c7e5,
	0x001390ee, 0x00151a78, 0x0016a906, 0x00183290,
	0x0019bc19, 0x001b4822, 0x001cd12c, 0x001e9ab5,
	0x00000000, 0x00000000,
};

static const u32 b43_ntab_pilotlt_r3[] = {
	0x76540213, 0x62407351, 0x76543210, 0x76540213,
	0x76540213, 0x76430521,
};

static const u32 b43_ntab_channelest_r3[] = {
	0x44444444, 0x44444444, 0x44444444, 0x44444444,
	0x44444444, 0x44444444, 0x44444444, 0x44444444,
	0x10101010, 0x10101010, 0x10101010, 0x10101010,
	0x10101010, 0x10101010, 0x10101010, 0x10101010,
	0x44444444, 0x44444444, 0x44444444, 0x44444444,
	0x44444444, 0x44444444, 0x44444444, 0x44444444,
	0x10101010, 0x10101010, 0x10101010, 0x10101010,
	0x10101010, 0x10101010, 0x10101010, 0x10101010,
	0x44444444, 0x44444444, 0x44444444, 0x44444444,
	0x44444444, 0x44444444, 0x44444444, 0x44444444,
	0x44444444, 0x44444444, 0x44444444, 0x44444444,
	0x44444444, 0x44444444, 0x44444444, 0x44444444,
	0x10101010, 0x10101010, 0x10101010, 0x10101010,
	0x10101010, 0x10101010, 0x10101010, 0x10101010,
	0x10101010, 0x10101010, 0x10101010, 0x10101010,
	0x10101010, 0x10101010, 0x10101010, 0x10101010,
	0x44444444, 0x44444444, 0x44444444, 0x44444444,
	0x44444444, 0x44444444, 0x44444444, 0x44444444,
	0x44444444, 0x44444444, 0x44444444, 0x44444444,
	0x44444444, 0x44444444, 0x44444444, 0x44444444,
	0x10101010, 0x10101010, 0x10101010, 0x10101010,
	0x10101010, 0x10101010, 0x10101010, 0x10101010,
	0x10101010, 0x10101010, 0x10101010, 0x10101010,
	0x10101010, 0x10101010, 0x10101010, 0x10101010,
};

static const u8 b43_ntab_framelookup_r3[] = {
	0x02, 0x04, 0x14, 0x14, 0x03, 0x05, 0x16, 0x16,
	0x0a, 0x0c, 0x1c, 0x1c, 0x0b, 0x0d, 0x1e, 0x1e,
	0x06, 0x08, 0x18, 0x18, 0x07, 0x09, 0x1a, 0x1a,
	0x0e, 0x10, 0x20, 0x28, 0x0f, 0x11, 0x22, 0x2a,
};

static const u8 b43_ntab_estimatepowerlt0_r3[] = {
	0x55, 0x54, 0x54, 0x53, 0x52, 0x52, 0x51, 0x51,
	0x50, 0x4f, 0x4f, 0x4e, 0x4e, 0x4d, 0x4c, 0x4c,
	0x4b, 0x4a, 0x49, 0x49, 0x48, 0x47, 0x46, 0x46,
	0x45, 0x44, 0x43, 0x42, 0x41, 0x40, 0x40, 0x3f,
	0x3e, 0x3d, 0x3c, 0x3a, 0x39, 0x38, 0x37, 0x36,
	0x35, 0x33, 0x32, 0x31, 0x2f, 0x2e, 0x2c, 0x2b,
	0x29, 0x27, 0x25, 0x23, 0x21, 0x1f, 0x1d, 0x1a,
	0x18, 0x15, 0x12, 0x0e, 0x0b, 0x07, 0x02, 0xfd,
};

static const u8 b43_ntab_estimatepowerlt1_r3[] = {
	0x55, 0x54, 0x54, 0x53, 0x52, 0x52, 0x51, 0x51,
	0x50, 0x4f, 0x4f, 0x4e, 0x4e, 0x4d, 0x4c, 0x4c,
	0x4b, 0x4a, 0x49, 0x49, 0x48, 0x47, 0x46, 0x46,
	0x45, 0x44, 0x43, 0x42, 0x41, 0x40, 0x40, 0x3f,
	0x3e, 0x3d, 0x3c, 0x3a, 0x39, 0x38, 0x37, 0x36,
	0x35, 0x33, 0x32, 0x31, 0x2f, 0x2e, 0x2c, 0x2b,
	0x29, 0x27, 0x25, 0x23, 0x21, 0x1f, 0x1d, 0x1a,
	0x18, 0x15, 0x12, 0x0e, 0x0b, 0x07, 0x02, 0xfd,
};

static const u8 b43_ntab_adjustpower0_r3[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

static const u8 b43_ntab_adjustpower1_r3[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

static const u32 b43_ntab_gainctl0_r3[] = {
	0x5bf70044, 0x5bf70042, 0x5bf70040, 0x5bf7003e,
	0x5bf7003c, 0x5bf7003b, 0x5bf70039, 0x5bf70037,
	0x5bf70036, 0x5bf70034, 0x5bf70033, 0x5bf70031,
	0x5bf70030, 0x5ba70044, 0x5ba70042, 0x5ba70040,
	0x5ba7003e, 0x5ba7003c, 0x5ba7003b, 0x5ba70039,
	0x5ba70037, 0x5ba70036, 0x5ba70034, 0x5ba70033,
	0x5b770044, 0x5b770042, 0x5b770040, 0x5b77003e,
	0x5b77003c, 0x5b77003b, 0x5b770039, 0x5b770037,
	0x5b770036, 0x5b770034, 0x5b770033, 0x5b770031,
	0x5b770030, 0x5b77002f, 0x5b77002d, 0x5b77002c,
	0x5b470044, 0x5b470042, 0x5b470040, 0x5b47003e,
	0x5b47003c, 0x5b47003b, 0x5b470039, 0x5b470037,
	0x5b470036, 0x5b470034, 0x5b470033, 0x5b470031,
	0x5b470030, 0x5b47002f, 0x5b47002d, 0x5b47002c,
	0x5b47002b, 0x5b47002a, 0x5b270044, 0x5b270042,
	0x5b270040, 0x5b27003e, 0x5b27003c, 0x5b27003b,
	0x5b270039, 0x5b270037, 0x5b270036, 0x5b270034,
	0x5b270033, 0x5b270031, 0x5b270030, 0x5b27002f,
	0x5b170044, 0x5b170042, 0x5b170040, 0x5b17003e,
	0x5b17003c, 0x5b17003b, 0x5b170039, 0x5b170037,
	0x5b170036, 0x5b170034, 0x5b170033, 0x5b170031,
	0x5b170030, 0x5b17002f, 0x5b17002d, 0x5b17002c,
	0x5b17002b, 0x5b17002a, 0x5b170028, 0x5b170027,
	0x5b170026, 0x5b170025, 0x5b170024, 0x5b170023,
	0x5b070044, 0x5b070042, 0x5b070040, 0x5b07003e,
	0x5b07003c, 0x5b07003b, 0x5b070039, 0x5b070037,
	0x5b070036, 0x5b070034, 0x5b070033, 0x5b070031,
	0x5b070030, 0x5b07002f, 0x5b07002d, 0x5b07002c,
	0x5b07002b, 0x5b07002a, 0x5b070028, 0x5b070027,
	0x5b070026, 0x5b070025, 0x5b070024, 0x5b070023,
	0x5b070022, 0x5b070021, 0x5b070020, 0x5b07001f,
	0x5b07001e, 0x5b07001d, 0x5b07001d, 0x5b07001c,
};

static const u32 b43_ntab_gainctl1_r3[] = {
	0x5bf70044, 0x5bf70042, 0x5bf70040, 0x5bf7003e,
	0x5bf7003c, 0x5bf7003b, 0x5bf70039, 0x5bf70037,
	0x5bf70036, 0x5bf70034, 0x5bf70033, 0x5bf70031,
	0x5bf70030, 0x5ba70044, 0x5ba70042, 0x5ba70040,
	0x5ba7003e, 0x5ba7003c, 0x5ba7003b, 0x5ba70039,
	0x5ba70037, 0x5ba70036, 0x5ba70034, 0x5ba70033,
	0x5b770044, 0x5b770042, 0x5b770040, 0x5b77003e,
	0x5b77003c, 0x5b77003b, 0x5b770039, 0x5b770037,
	0x5b770036, 0x5b770034, 0x5b770033, 0x5b770031,
	0x5b770030, 0x5b77002f, 0x5b77002d, 0x5b77002c,
	0x5b470044, 0x5b470042, 0x5b470040, 0x5b47003e,
	0x5b47003c, 0x5b47003b, 0x5b470039, 0x5b470037,
	0x5b470036, 0x5b470034, 0x5b470033, 0x5b470031,
	0x5b470030, 0x5b47002f, 0x5b47002d, 0x5b47002c,
	0x5b47002b, 0x5b47002a, 0x5b270044, 0x5b270042,
	0x5b270040, 0x5b27003e, 0x5b27003c, 0x5b27003b,
	0x5b270039, 0x5b270037, 0x5b270036, 0x5b270034,
	0x5b270033, 0x5b270031, 0x5b270030, 0x5b27002f,
	0x5b170044, 0x5b170042, 0x5b170040, 0x5b17003e,
	0x5b17003c, 0x5b17003b, 0x5b170039, 0x5b170037,
	0x5b170036, 0x5b170034, 0x5b170033, 0x5b170031,
	0x5b170030, 0x5b17002f, 0x5b17002d, 0x5b17002c,
	0x5b17002b, 0x5b17002a, 0x5b170028, 0x5b170027,
	0x5b170026, 0x5b170025, 0x5b170024, 0x5b170023,
	0x5b070044, 0x5b070042, 0x5b070040, 0x5b07003e,
	0x5b07003c, 0x5b07003b, 0x5b070039, 0x5b070037,
	0x5b070036, 0x5b070034, 0x5b070033, 0x5b070031,
	0x5b070030, 0x5b07002f, 0x5b07002d, 0x5b07002c,
	0x5b07002b, 0x5b07002a, 0x5b070028, 0x5b070027,
	0x5b070026, 0x5b070025, 0x5b070024, 0x5b070023,
	0x5b070022, 0x5b070021, 0x5b070020, 0x5b07001f,
	0x5b07001e, 0x5b07001d, 0x5b07001d, 0x5b07001c,
};

static const u32 b43_ntab_iqlt0_r3[] = {
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
};

static const u32 b43_ntab_iqlt1_r3[] = {
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
};

static const u16 b43_ntab_loftlt0_r3[] = {
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000,
};

static const u16 b43_ntab_loftlt1_r3[] = {
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000,
};

/* volatile  tables, PHY revision >= 3 */

/* indexed by antswctl2g */
static const u16 b43_ntab_antswctl_r3[4][32] = {
	{
		0x0082, 0x0082, 0x0211, 0x0222, 0x0328,
		0x0000, 0x0000, 0x0000, 0x0144, 0x0000,
		0x0000, 0x0000, 0x0188, 0x0000, 0x0000,
		0x0000, 0x0082, 0x0082, 0x0211, 0x0222,
		0x0328, 0x0000, 0x0000, 0x0000, 0x0144,
		0x0000, 0x0000, 0x0000, 0x0188, 0x0000,
		0x0000, 0x0000,
	},
	{
		0x0022, 0x0022, 0x0011, 0x0022, 0x0022,
		0x0000, 0x0000, 0x0000, 0x0011, 0x0000,
		0x0000, 0x0000, 0x0022, 0x0000, 0x0000,
		0x0000, 0x0022, 0x0022, 0x0011, 0x0022,
		0x0022, 0x0000, 0x0000, 0x0000, 0x0011,
		0x0000, 0x0000, 0x0000, 0x0022, 0x0000,
		0x0000, 0x0000,
	},
	{
		0x0088, 0x0088, 0x0044, 0x0088, 0x0088,
		0x0000, 0x0000, 0x0000, 0x0044, 0x0000,
		0x0000, 0x0000, 0x0088, 0x0000, 0x0000,
		0x0000, 0x0088, 0x0088, 0x0044, 0x0088,
		0x0088, 0x0000, 0x0000, 0x0000, 0x0044,
		0x0000, 0x0000, 0x0000, 0x0088, 0x0000,
		0x0000, 0x0000,
	},
	{
		0x0022, 0x0022, 0x0011, 0x0022, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0011, 0x0000,
		0x0000, 0x0000, 0x0022, 0x0000, 0x0000,
		0x03cc, 0x0022, 0x0022, 0x0011, 0x0022,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0011,
		0x0000, 0x0000, 0x0000, 0x0022, 0x0000,
		0x0000, 0x03cc,
	}
};

/* TX gain tables */
static const u32 b43_ntab_tx_gain_rev0_1_2[] = {
	0x03cc2b44, 0x03cc2b42, 0x03cc2a44, 0x03cc2a42,
	0x03cc2944, 0x03c82b44, 0x03c82b42, 0x03c82a44,
	0x03c82a42, 0x03c82944, 0x03c82942, 0x03c82844,
	0x03c82842, 0x03c42b44, 0x03c42b42, 0x03c42a44,
	0x03c42a42, 0x03c42944, 0x03c42942, 0x03c42844,
	0x03c42842, 0x03c42744, 0x03c42742, 0x03c42644,
	0x03c42642, 0x03c42544, 0x03c42542, 0x03c42444,
	0x03c42442, 0x03c02b44, 0x03c02b42, 0x03c02a44,
	0x03c02a42, 0x03c02944, 0x03c02942, 0x03c02844,
	0x03c02842, 0x03c02744, 0x03c02742, 0x03b02b44,
	0x03b02b42, 0x03b02a44, 0x03b02a42, 0x03b02944,
	0x03b02942, 0x03b02844, 0x03b02842, 0x03b02744,
	0x03b02742, 0x03b02644, 0x03b02642, 0x03b02544,
	0x03b02542, 0x03a02b44, 0x03a02b42, 0x03a02a44,
	0x03a02a42, 0x03a02944, 0x03a02942, 0x03a02844,
	0x03a02842, 0x03a02744, 0x03a02742, 0x03902b44,
	0x03902b42, 0x03902a44, 0x03902a42, 0x03902944,
	0x03902942, 0x03902844, 0x03902842, 0x03902744,
	0x03902742, 0x03902644, 0x03902642, 0x03902544,
	0x03902542, 0x03802b44, 0x03802b42, 0x03802a44,
	0x03802a42, 0x03802944, 0x03802942, 0x03802844,
	0x03802842, 0x03802744, 0x03802742, 0x03802644,
	0x03802642, 0x03802544, 0x03802542, 0x03802444,
	0x03802442, 0x03802344, 0x03802342, 0x03802244,
	0x03802242, 0x03802144, 0x03802142, 0x03802044,
	0x03802042, 0x03801f44, 0x03801f42, 0x03801e44,
	0x03801e42, 0x03801d44, 0x03801d42, 0x03801c44,
	0x03801c42, 0x03801b44, 0x03801b42, 0x03801a44,
	0x03801a42, 0x03801944, 0x03801942, 0x03801844,
	0x03801842, 0x03801744, 0x03801742, 0x03801644,
	0x03801642, 0x03801544, 0x03801542, 0x03801444,
	0x03801442, 0x03801344, 0x03801342, 0x00002b00,
};

static const u32 b43_ntab_tx_gain_rev3plus_2ghz[] = {
	0x1f410044, 0x1f410042, 0x1f410040, 0x1f41003e,
	0x1f41003c, 0x1f41003b, 0x1f410039, 0x1f410037,
	0x1e410044, 0x1e410042, 0x1e410040, 0x1e41003e,
	0x1e41003c, 0x1e41003b, 0x1e410039, 0x1e410037,
	0x1d410044, 0x1d410042, 0x1d410040, 0x1d41003e,
	0x1d41003c, 0x1d41003b, 0x1d410039, 0x1d410037,
	0x1c410044, 0x1c410042, 0x1c410040, 0x1c41003e,
	0x1c41003c, 0x1c41003b, 0x1c410039, 0x1c410037,
	0x1b410044, 0x1b410042, 0x1b410040, 0x1b41003e,
	0x1b41003c, 0x1b41003b, 0x1b410039, 0x1b410037,
	0x1a410044, 0x1a410042, 0x1a410040, 0x1a41003e,
	0x1a41003c, 0x1a41003b, 0x1a410039, 0x1a410037,
	0x19410044, 0x19410042, 0x19410040, 0x1941003e,
	0x1941003c, 0x1941003b, 0x19410039, 0x19410037,
	0x18410044, 0x18410042, 0x18410040, 0x1841003e,
	0x1841003c, 0x1841003b, 0x18410039, 0x18410037,
	0x17410044, 0x17410042, 0x17410040, 0x1741003e,
	0x1741003c, 0x1741003b, 0x17410039, 0x17410037,
	0x16410044, 0x16410042, 0x16410040, 0x1641003e,
	0x1641003c, 0x1641003b, 0x16410039, 0x16410037,
	0x15410044, 0x15410042, 0x15410040, 0x1541003e,
	0x1541003c, 0x1541003b, 0x15410039, 0x15410037,
	0x14410044, 0x14410042, 0x14410040, 0x1441003e,
	0x1441003c, 0x1441003b, 0x14410039, 0x14410037,
	0x13410044, 0x13410042, 0x13410040, 0x1341003e,
	0x1341003c, 0x1341003b, 0x13410039, 0x13410037,
	0x12410044, 0x12410042, 0x12410040, 0x1241003e,
	0x1241003c, 0x1241003b, 0x12410039, 0x12410037,
	0x11410044, 0x11410042, 0x11410040, 0x1141003e,
	0x1141003c, 0x1141003b, 0x11410039, 0x11410037,
	0x10410044, 0x10410042, 0x10410040, 0x1041003e,
	0x1041003c, 0x1041003b, 0x10410039, 0x10410037,
};

static const u32 b43_ntab_tx_gain_rev3_5ghz[] = {
	0xcff70044, 0xcff70042, 0xcff70040, 0xcff7003e,
	0xcff7003c, 0xcff7003b, 0xcff70039, 0xcff70037,
	0xcef70044, 0xcef70042, 0xcef70040, 0xcef7003e,
	0xcef7003c, 0xcef7003b, 0xcef70039, 0xcef70037,
	0xcdf70044, 0xcdf70042, 0xcdf70040, 0xcdf7003e,
	0xcdf7003c, 0xcdf7003b, 0xcdf70039, 0xcdf70037,
	0xccf70044, 0xccf70042, 0xccf70040, 0xccf7003e,
	0xccf7003c, 0xccf7003b, 0xccf70039, 0xccf70037,
	0xcbf70044, 0xcbf70042, 0xcbf70040, 0xcbf7003e,
	0xcbf7003c, 0xcbf7003b, 0xcbf70039, 0xcbf70037,
	0xcaf70044, 0xcaf70042, 0xcaf70040, 0xcaf7003e,
	0xcaf7003c, 0xcaf7003b, 0xcaf70039, 0xcaf70037,
	0xc9f70044, 0xc9f70042, 0xc9f70040, 0xc9f7003e,
	0xc9f7003c, 0xc9f7003b, 0xc9f70039, 0xc9f70037,
	0xc8f70044, 0xc8f70042, 0xc8f70040, 0xc8f7003e,
	0xc8f7003c, 0xc8f7003b, 0xc8f70039, 0xc8f70037,
	0xc7f70044, 0xc7f70042, 0xc7f70040, 0xc7f7003e,
	0xc7f7003c, 0xc7f7003b, 0xc7f70039, 0xc7f70037,
	0xc6f70044, 0xc6f70042, 0xc6f70040, 0xc6f7003e,
	0xc6f7003c, 0xc6f7003b, 0xc6f70039, 0xc6f70037,
	0xc5f70044, 0xc5f70042, 0xc5f70040, 0xc5f7003e,
	0xc5f7003c, 0xc5f7003b, 0xc5f70039, 0xc5f70037,
	0xc4f70044, 0xc4f70042, 0xc4f70040, 0xc4f7003e,
	0xc4f7003c, 0xc4f7003b, 0xc4f70039, 0xc4f70037,
	0xc3f70044, 0xc3f70042, 0xc3f70040, 0xc3f7003e,
	0xc3f7003c, 0xc3f7003b, 0xc3f70039, 0xc3f70037,
	0xc2f70044, 0xc2f70042, 0xc2f70040, 0xc2f7003e,
	0xc2f7003c, 0xc2f7003b, 0xc2f70039, 0xc2f70037,
	0xc1f70044, 0xc1f70042, 0xc1f70040, 0xc1f7003e,
	0xc1f7003c, 0xc1f7003b, 0xc1f70039, 0xc1f70037,
	0xc0f70044, 0xc0f70042, 0xc0f70040, 0xc0f7003e,
	0xc0f7003c, 0xc0f7003b, 0xc0f70039, 0xc0f70037,
};

static const u32 b43_ntab_tx_gain_rev4_5ghz[] = {
	0x2ff20044, 0x2ff20042, 0x2ff20040, 0x2ff2003e,
	0x2ff2003c, 0x2ff2003b, 0x2ff20039, 0x2ff20037,
	0x2ef20044, 0x2ef20042, 0x2ef20040, 0x2ef2003e,
	0x2ef2003c, 0x2ef2003b, 0x2ef20039, 0x2ef20037,
	0x2df20044, 0x2df20042, 0x2df20040, 0x2df2003e,
	0x2df2003c, 0x2df2003b, 0x2df20039, 0x2df20037,
	0x2cf20044, 0x2cf20042, 0x2cf20040, 0x2cf2003e,
	0x2cf2003c, 0x2cf2003b, 0x2cf20039, 0x2cf20037,
	0x2bf20044, 0x2bf20042, 0x2bf20040, 0x2bf2003e,
	0x2bf2003c, 0x2bf2003b, 0x2bf20039, 0x2bf20037,
	0x2af20044, 0x2af20042, 0x2af20040, 0x2af2003e,
	0x2af2003c, 0x2af2003b, 0x2af20039, 0x2af20037,
	0x29f20044, 0x29f20042, 0x29f20040, 0x29f2003e,
	0x29f2003c, 0x29f2003b, 0x29f20039, 0x29f20037,
	0x28f20044, 0x28f20042, 0x28f20040, 0x28f2003e,
	0x28f2003c, 0x28f2003b, 0x28f20039, 0x28f20037,
	0x27f20044, 0x27f20042, 0x27f20040, 0x27f2003e,
	0x27f2003c, 0x27f2003b, 0x27f20039, 0x27f20037,
	0x26f20044, 0x26f20042, 0x26f20040, 0x26f2003e,
	0x26f2003c, 0x26f2003b, 0x26f20039, 0x26f20037,
	0x25f20044, 0x25f20042, 0x25f20040, 0x25f2003e,
	0x25f2003c, 0x25f2003b, 0x25f20039, 0x25f20037,
	0x24f20044, 0x24f20042, 0x24f20040, 0x24f2003e,
	0x24f2003c, 0x24f2003b, 0x24f20039, 0x24f20038,
	0x23f20041, 0x23f20040, 0x23f2003f, 0x23f2003e,
	0x23f2003c, 0x23f2003b, 0x23f20039, 0x23f20037,
	0x22f20044, 0x22f20042, 0x22f20040, 0x22f2003e,
	0x22f2003c, 0x22f2003b, 0x22f20039, 0x22f20037,
	0x21f20044, 0x21f20042, 0x21f20040, 0x21f2003e,
	0x21f2003c, 0x21f2003b, 0x21f20039, 0x21f20037,
	0x20d20043, 0x20d20041, 0x20d2003e, 0x20d2003c,
	0x20d2003a, 0x20d20038, 0x20d20036, 0x20d20034,
};

static const u32 b43_ntab_tx_gain_rev5plus_5ghz[] = {
	0x0f62004a, 0x0f620048, 0x0f620046, 0x0f620044,
	0x0f620042, 0x0f620040, 0x0f62003e, 0x0f62003c,
	0x0e620044, 0x0e620042, 0x0e620040, 0x0e62003e,
	0x0e62003c, 0x0e62003d, 0x0e62003b, 0x0e62003a,
	0x0d620043, 0x0d620041, 0x0d620040, 0x0d62003e,
	0x0d62003d, 0x0d62003c, 0x0d62003b, 0x0d62003a,
	0x0c620041, 0x0c620040, 0x0c62003f, 0x0c62003e,
	0x0c62003c, 0x0c62003b, 0x0c620039, 0x0c620037,
	0x0b620046, 0x0b620044, 0x0b620042, 0x0b620040,
	0x0b62003e, 0x0b62003c, 0x0b62003b, 0x0b62003a,
	0x0a620041, 0x0a620040, 0x0a62003e, 0x0a62003c,
	0x0a62003b, 0x0a62003a, 0x0a620039, 0x0a620038,
	0x0962003e, 0x0962003d, 0x0962003c, 0x0962003b,
	0x09620039, 0x09620037, 0x09620035, 0x09620033,
	0x08620044, 0x08620042, 0x08620040, 0x0862003e,
	0x0862003c, 0x0862003b, 0x0862003a, 0x08620039,
	0x07620043, 0x07620042, 0x07620040, 0x0762003f,
	0x0762003d, 0x0762003b, 0x0762003a, 0x07620039,
	0x0662003e, 0x0662003d, 0x0662003c, 0x0662003b,
	0x06620039, 0x06620037, 0x06620035, 0x06620033,
	0x05620046, 0x05620044, 0x05620042, 0x05620040,
	0x0562003e, 0x0562003c, 0x0562003b, 0x05620039,
	0x04620044, 0x04620042, 0x04620040, 0x0462003e,
	0x0462003c, 0x0462003b, 0x04620039, 0x04620038,
	0x0362003c, 0x0362003b, 0x0362003a, 0x03620039,
	0x03620038, 0x03620037, 0x03620035, 0x03620033,
	0x0262004c, 0x0262004a, 0x02620048, 0x02620047,
	0x02620046, 0x02620044, 0x02620043, 0x02620042,
	0x0162004a, 0x01620048, 0x01620046, 0x01620044,
	0x01620043, 0x01620042, 0x01620041, 0x01620040,
	0x00620042, 0x00620040, 0x0062003e, 0x0062003c,
	0x0062003b, 0x00620039, 0x00620037, 0x00620035,
};

static const u32 txpwrctrl_tx_gain_ipa[] = {
	0x5ff7002d, 0x5ff7002b, 0x5ff7002a, 0x5ff70029,
	0x5ff70028, 0x5ff70027, 0x5ff70026, 0x5ff70025,
	0x5ef7002d, 0x5ef7002b, 0x5ef7002a, 0x5ef70029,
	0x5ef70028, 0x5ef70027, 0x5ef70026, 0x5ef70025,
	0x5df7002d, 0x5df7002b, 0x5df7002a, 0x5df70029,
	0x5df70028, 0x5df70027, 0x5df70026, 0x5df70025,
	0x5cf7002d, 0x5cf7002b, 0x5cf7002a, 0x5cf70029,
	0x5cf70028, 0x5cf70027, 0x5cf70026, 0x5cf70025,
	0x5bf7002d, 0x5bf7002b, 0x5bf7002a, 0x5bf70029,
	0x5bf70028, 0x5bf70027, 0x5bf70026, 0x5bf70025,
	0x5af7002d, 0x5af7002b, 0x5af7002a, 0x5af70029,
	0x5af70028, 0x5af70027, 0x5af70026, 0x5af70025,
	0x59f7002d, 0x59f7002b, 0x59f7002a, 0x59f70029,
	0x59f70028, 0x59f70027, 0x59f70026, 0x59f70025,
	0x58f7002d, 0x58f7002b, 0x58f7002a, 0x58f70029,
	0x58f70028, 0x58f70027, 0x58f70026, 0x58f70025,
	0x57f7002d, 0x57f7002b, 0x57f7002a, 0x57f70029,
	0x57f70028, 0x57f70027, 0x57f70026, 0x57f70025,
	0x56f7002d, 0x56f7002b, 0x56f7002a, 0x56f70029,
	0x56f70028, 0x56f70027, 0x56f70026, 0x56f70025,
	0x55f7002d, 0x55f7002b, 0x55f7002a, 0x55f70029,
	0x55f70028, 0x55f70027, 0x55f70026, 0x55f70025,
	0x54f7002d, 0x54f7002b, 0x54f7002a, 0x54f70029,
	0x54f70028, 0x54f70027, 0x54f70026, 0x54f70025,
	0x53f7002d, 0x53f7002b, 0x53f7002a, 0x53f70029,
	0x53f70028, 0x53f70027, 0x53f70026, 0x53f70025,
	0x52f7002d, 0x52f7002b, 0x52f7002a, 0x52f70029,
	0x52f70028, 0x52f70027, 0x52f70026, 0x52f70025,
	0x51f7002d, 0x51f7002b, 0x51f7002a, 0x51f70029,
	0x51f70028, 0x51f70027, 0x51f70026, 0x51f70025,
	0x50f7002d, 0x50f7002b, 0x50f7002a, 0x50f70029,
	0x50f70028, 0x50f70027, 0x50f70026, 0x50f70025,
};

static const u32 txpwrctrl_tx_gain_ipa_rev5[] = {
	0x1ff7002d, 0x1ff7002b, 0x1ff7002a, 0x1ff70029,
	0x1ff70028, 0x1ff70027, 0x1ff70026, 0x1ff70025,
	0x1ef7002d, 0x1ef7002b, 0x1ef7002a, 0x1ef70029,
	0x1ef70028, 0x1ef70027, 0x1ef70026, 0x1ef70025,
	0x1df7002d, 0x1df7002b, 0x1df7002a, 0x1df70029,
	0x1df70028, 0x1df70027, 0x1df70026, 0x1df70025,
	0x1cf7002d, 0x1cf7002b, 0x1cf7002a, 0x1cf70029,
	0x1cf70028, 0x1cf70027, 0x1cf70026, 0x1cf70025,
	0x1bf7002d, 0x1bf7002b, 0x1bf7002a, 0x1bf70029,
	0x1bf70028, 0x1bf70027, 0x1bf70026, 0x1bf70025,
	0x1af7002d, 0x1af7002b, 0x1af7002a, 0x1af70029,
	0x1af70028, 0x1af70027, 0x1af70026, 0x1af70025,
	0x19f7002d, 0x19f7002b, 0x19f7002a, 0x19f70029,
	0x19f70028, 0x19f70027, 0x19f70026, 0x19f70025,
	0x18f7002d, 0x18f7002b, 0x18f7002a, 0x18f70029,
	0x18f70028, 0x18f70027, 0x18f70026, 0x18f70025,
	0x17f7002d, 0x17f7002b, 0x17f7002a, 0x17f70029,
	0x17f70028, 0x17f70027, 0x17f70026, 0x17f70025,
	0x16f7002d, 0x16f7002b, 0x16f7002a, 0x16f70029,
	0x16f70028, 0x16f70027, 0x16f70026, 0x16f70025,
	0x15f7002d, 0x15f7002b, 0x15f7002a, 0x15f70029,
	0x15f70028, 0x15f70027, 0x15f70026, 0x15f70025,
	0x14f7002d, 0x14f7002b, 0x14f7002a, 0x14f70029,
	0x14f70028, 0x14f70027, 0x14f70026, 0x14f70025,
	0x13f7002d, 0x13f7002b, 0x13f7002a, 0x13f70029,
	0x13f70028, 0x13f70027, 0x13f70026, 0x13f70025,
	0x12f7002d, 0x12f7002b, 0x12f7002a, 0x12f70029,
	0x12f70028, 0x12f70027, 0x12f70026, 0x12f70025,
	0x11f7002d, 0x11f7002b, 0x11f7002a, 0x11f70029,
	0x11f70028, 0x11f70027, 0x11f70026, 0x11f70025,
	0x10f7002d, 0x10f7002b, 0x10f7002a, 0x10f70029,
	0x10f70028, 0x10f70027, 0x10f70026, 0x10f70025,
};

static const u32 txpwrctrl_tx_gain_ipa_rev6[] = {
	0x0ff7002d, 0x0ff7002b, 0x0ff7002a, 0x0ff70029,
	0x0ff70028, 0x0ff70027, 0x0ff70026, 0x0ff70025,
	0x0ef7002d, 0x0ef7002b, 0x0ef7002a, 0x0ef70029,
	0x0ef70028, 0x0ef70027, 0x0ef70026, 0x0ef70025,
	0x0df7002d, 0x0df7002b, 0x0df7002a, 0x0df70029,
	0x0df70028, 0x0df70027, 0x0df70026, 0x0df70025,
	0x0cf7002d, 0x0cf7002b, 0x0cf7002a, 0x0cf70029,
	0x0cf70028, 0x0cf70027, 0x0cf70026, 0x0cf70025,
	0x0bf7002d, 0x0bf7002b, 0x0bf7002a, 0x0bf70029,
	0x0bf70028, 0x0bf70027, 0x0bf70026, 0x0bf70025,
	0x0af7002d, 0x0af7002b, 0x0af7002a, 0x0af70029,
	0x0af70028, 0x0af70027, 0x0af70026, 0x0af70025,
	0x09f7002d, 0x09f7002b, 0x09f7002a, 0x09f70029,
	0x09f70028, 0x09f70027, 0x09f70026, 0x09f70025,
	0x08f7002d, 0x08f7002b, 0x08f7002a, 0x08f70029,
	0x08f70028, 0x08f70027, 0x08f70026, 0x08f70025,
	0x07f7002d, 0x07f7002b, 0x07f7002a, 0x07f70029,
	0x07f70028, 0x07f70027, 0x07f70026, 0x07f70025,
	0x06f7002d, 0x06f7002b, 0x06f7002a, 0x06f70029,
	0x06f70028, 0x06f70027, 0x06f70026, 0x06f70025,
	0x05f7002d, 0x05f7002b, 0x05f7002a, 0x05f70029,
	0x05f70028, 0x05f70027, 0x05f70026, 0x05f70025,
	0x04f7002d, 0x04f7002b, 0x04f7002a, 0x04f70029,
	0x04f70028, 0x04f70027, 0x04f70026, 0x04f70025,
	0x03f7002d, 0x03f7002b, 0x03f7002a, 0x03f70029,
	0x03f70028, 0x03f70027, 0x03f70026, 0x03f70025,
	0x02f7002d, 0x02f7002b, 0x02f7002a, 0x02f70029,
	0x02f70028, 0x02f70027, 0x02f70026, 0x02f70025,
	0x01f7002d, 0x01f7002b, 0x01f7002a, 0x01f70029,
	0x01f70028, 0x01f70027, 0x01f70026, 0x01f70025,
	0x00f7002d, 0x00f7002b, 0x00f7002a, 0x00f70029,
	0x00f70028, 0x00f70027, 0x00f70026, 0x00f70025,
};

static const u32 txpwrctrl_tx_gain_ipa_5g[] = {
	0x7ff70035, 0x7ff70033, 0x7ff70032, 0x7ff70031,
	0x7ff7002f, 0x7ff7002e, 0x7ff7002d, 0x7ff7002b,
	0x7ff7002a, 0x7ff70029, 0x7ff70028, 0x7ff70027,
	0x7ff70026, 0x7ff70024, 0x7ff70023, 0x7ff70022,
	0x7ef70028, 0x7ef70027, 0x7ef70026, 0x7ef70025,
	0x7ef70024, 0x7ef70023, 0x7df70028, 0x7df70027,
	0x7df70026, 0x7df70025, 0x7df70024, 0x7df70023,
	0x7df70022, 0x7cf70029, 0x7cf70028, 0x7cf70027,
	0x7cf70026, 0x7cf70025, 0x7cf70023, 0x7cf70022,
	0x7bf70029, 0x7bf70028, 0x7bf70026, 0x7bf70025,
	0x7bf70024, 0x7bf70023, 0x7bf70022, 0x7bf70021,
	0x7af70029, 0x7af70028, 0x7af70027, 0x7af70026,
	0x7af70025, 0x7af70024, 0x7af70023, 0x7af70022,
	0x79f70029, 0x79f70028, 0x79f70027, 0x79f70026,
	0x79f70025, 0x79f70024, 0x79f70023, 0x79f70022,
	0x78f70029, 0x78f70028, 0x78f70027, 0x78f70026,
	0x78f70025, 0x78f70024, 0x78f70023, 0x78f70022,
	0x77f70029, 0x77f70028, 0x77f70027, 0x77f70026,
	0x77f70025, 0x77f70024, 0x77f70023, 0x77f70022,
	0x76f70029, 0x76f70028, 0x76f70027, 0x76f70026,
	0x76f70024, 0x76f70023, 0x76f70022, 0x76f70021,
	0x75f70029, 0x75f70028, 0x75f70027, 0x75f70026,
	0x75f70025, 0x75f70024, 0x75f70023, 0x74f70029,
	0x74f70028, 0x74f70026, 0x74f70025, 0x74f70024,
	0x74f70023, 0x74f70022, 0x73f70029, 0x73f70027,
	0x73f70026, 0x73f70025, 0x73f70024, 0x73f70023,
	0x73f70022, 0x72f70028, 0x72f70027, 0x72f70026,
	0x72f70025, 0x72f70024, 0x72f70023, 0x72f70022,
	0x71f70028, 0x71f70027, 0x71f70026, 0x71f70025,
	0x71f70024, 0x71f70023, 0x70f70028, 0x70f70027,
	0x70f70026, 0x70f70024, 0x70f70023, 0x70f70022,
	0x70f70021, 0x70f70020, 0x70f70020, 0x70f7001f,
};

const s8 b43_ntab_papd_pga_gain_delta_ipa_2g[] = {
	-114, -108, -98, -91, -84, -78, -70, -62,
	-54, -46, -39, -31, -23, -15, -8, 0
};

const u16 tbl_iqcal_gainparams[2][9][8] = {
	{
		{ 0x000, 0, 0, 2, 0x69, 0x69, 0x69, 0x69 },
		{ 0x700, 7, 0, 0, 0x69, 0x69, 0x69, 0x69 },
		{ 0x710, 7, 1, 0, 0x68, 0x68, 0x68, 0x68 },
		{ 0x720, 7, 2, 0, 0x67, 0x67, 0x67, 0x67 },
		{ 0x730, 7, 3, 0, 0x66, 0x66, 0x66, 0x66 },
		{ 0x740, 7, 4, 0, 0x65, 0x65, 0x65, 0x65 },
		{ 0x741, 7, 4, 1, 0x65, 0x65, 0x65, 0x65 },
		{ 0x742, 7, 4, 2, 0x65, 0x65, 0x65, 0x65 },
		{ 0x743, 7, 4, 3, 0x65, 0x65, 0x65, 0x65 }
	},
	{
		{ 0x000, 7, 0, 0, 0x79, 0x79, 0x79, 0x79 },
		{ 0x700, 7, 0, 0, 0x79, 0x79, 0x79, 0x79 },
		{ 0x710, 7, 1, 0, 0x79, 0x79, 0x79, 0x79 },
		{ 0x720, 7, 2, 0, 0x78, 0x78, 0x78, 0x78 },
		{ 0x730, 7, 3, 0, 0x78, 0x78, 0x78, 0x78 },
		{ 0x740, 7, 4, 0, 0x78, 0x78, 0x78, 0x78 },
		{ 0x741, 7, 4, 1, 0x78, 0x78, 0x78, 0x78 },
		{ 0x742, 7, 4, 2, 0x78, 0x78, 0x78, 0x78 },
		{ 0x743, 7, 4, 3, 0x78, 0x78, 0x78, 0x78 }
	}
};

const struct nphy_txiqcal_ladder ladder_lo[] = {
	{ 3, 0 },
	{ 4, 0 },
	{ 6, 0 },
	{ 9, 0 },
	{ 13, 0 },
	{ 18, 0 },
	{ 25, 0 },
	{ 25, 1 },
	{ 25, 2 },
	{ 25, 3 },
	{ 25, 4 },
	{ 25, 5 },
	{ 25, 6 },
	{ 25, 7 },
	{ 35, 7 },
	{ 50, 7 },
	{ 71, 7 },
	{ 100, 7 }
};

const struct nphy_txiqcal_ladder ladder_iq[] = {
	{ 3, 0 },
	{ 4, 0 },
	{ 6, 0 },
	{ 9, 0 },
	{ 13, 0 },
	{ 18, 0 },
	{ 25, 0 },
	{ 35, 0 },
	{ 50, 0 },
	{ 71, 0 },
	{ 100, 0 },
	{ 100, 1 },
	{ 100, 2 },
	{ 100, 3 },
	{ 100, 4 },
	{ 100, 5 },
	{ 100, 6 },
	{ 100, 7 }
};

const u16 loscale[] = {
	256, 256, 271, 271,
	287, 256, 256, 271,
	271, 287, 287, 304,
	304, 256, 256, 271,
	271, 287, 287, 304,
	304, 322, 322, 341,
	341, 362, 362, 383,
	383, 256, 256, 271,
	271, 287, 287, 304,
	304, 322, 322, 256,
	256, 271, 271, 287,
	287, 304, 304, 322,
	322, 341, 341, 362,
	362, 256, 256, 271,
	271, 287, 287, 304,
	304, 322, 322, 256,
	256, 271, 271, 287,
	287, 304, 304, 322,
	322, 341, 341, 362,
	362, 256, 256, 271,
	271, 287, 287, 304,
	304, 322, 322, 341,
	341, 362, 362, 383,
	383, 406, 406, 430,
	430, 455, 455, 482,
	482, 511, 511, 541,
	541, 573, 573, 607,
	607, 643, 643, 681,
	681, 722, 722, 764,
	764, 810, 810, 858,
	858, 908, 908, 962,
	962, 1019, 1019, 256
};

const u16 tbl_tx_iqlo_cal_loft_ladder_40[] = {
	0x0200, 0x0300, 0x0400, 0x0700,
	0x0900, 0x0c00, 0x1200, 0x1201,
	0x1202, 0x1203, 0x1204, 0x1205,
	0x1206, 0x1207, 0x1907, 0x2307,
	0x3207, 0x4707
};

const u16 tbl_tx_iqlo_cal_loft_ladder_20[] = {
	0x0300, 0x0500, 0x0700, 0x0900,
	0x0d00, 0x1100, 0x1900, 0x1901,
	0x1902, 0x1903, 0x1904, 0x1905,
	0x1906, 0x1907, 0x2407, 0x3207,
	0x4607, 0x6407
};

const u16 tbl_tx_iqlo_cal_iqimb_ladder_40[] = {
	0x0100, 0x0200, 0x0400, 0x0700,
	0x0900, 0x0c00, 0x1200, 0x1900,
	0x2300, 0x3200, 0x4700, 0x4701,
	0x4702, 0x4703, 0x4704, 0x4705,
	0x4706, 0x4707
};

const u16 tbl_tx_iqlo_cal_iqimb_ladder_20[] = {
	0x0200, 0x0300, 0x0600, 0x0900,
	0x0d00, 0x1100, 0x1900, 0x2400,
	0x3200, 0x4600, 0x6400, 0x6401,
	0x6402, 0x6403, 0x6404, 0x6405,
	0x6406, 0x6407
};

const u16 tbl_tx_iqlo_cal_startcoefs_nphyrev3[B43_NTAB_TX_IQLO_CAL_STARTCOEFS_REV3] = { };

const u16 tbl_tx_iqlo_cal_startcoefs[B43_NTAB_TX_IQLO_CAL_STARTCOEFS] = { };

const u16 tbl_tx_iqlo_cal_cmds_recal_nphyrev3[] = {
	0x8423, 0x8323, 0x8073, 0x8256,
	0x8045, 0x8223, 0x9423, 0x9323,
	0x9073, 0x9256, 0x9045, 0x9223
};

const u16 tbl_tx_iqlo_cal_cmds_recal[] = {
	0x8101, 0x8253, 0x8053, 0x8234,
	0x8034, 0x9101, 0x9253, 0x9053,
	0x9234, 0x9034
};

const u16 tbl_tx_iqlo_cal_cmds_fullcal[] = {
	0x8123, 0x8264, 0x8086, 0x8245,
	0x8056, 0x9123, 0x9264, 0x9086,
	0x9245, 0x9056
};

const u16 tbl_tx_iqlo_cal_cmds_fullcal_nphyrev3[] = {
	0x8434, 0x8334, 0x8084, 0x8267,
	0x8056, 0x8234, 0x9434, 0x9334,
	0x9084, 0x9267, 0x9056, 0x9234
};

const s16 tbl_tx_filter_coef_rev4[7][15] = {
	{  -377,   137,  -407,   208, -1527,
	    956,    93,   186,    93,   230,
	    -44,   230,   201,  -191,   201 },
	{   -77,    20,   -98,    49,   -93,
	     60,    56,   111,    56,    26,
	     -5,    26,    34,   -32,    34 },
	{  -360,   164,  -376,   164, -1533,
	    576,   308,  -314,   308,   121,
	    -73,   121,    91,   124,    91 },
	{  -295,   200,  -363,   142, -1391,
	    826,   151,   301,   151,   151,
	    301,   151,   602,  -752,   602 },
	{   -92,    58,   -96,    49,  -104,
	     44,    17,    35,    17,    12,
	     25,    12,    13,    27,    13 },
	{  -375,   136,  -399,   209, -1479,
	    949,   130,   260,   130,   230,
	    -44,   230,   201,  -191,   201 },
	{ 0xed9,  0xc8, 0xe95,  0x8e, 0xa91,
	  0x33a,  0x97, 0x12d,  0x97,  0x97,
	  0x12d,  0x97, 0x25a, 0xd10, 0x25a }
};

/* addr0,  addr1,  bmask,  shift */
const struct nphy_rf_control_override_rev2 tbl_rf_control_override_rev2[] = {
	{ 0x78, 0x78, 0x0038,  3 }, /* for field == 0x0002 (fls == 2) */
	{ 0x7A, 0x7D, 0x0001,  0 }, /* for field == 0x0004 (fls == 3) */
	{ 0x7A, 0x7D, 0x0002,  1 }, /* for field == 0x0008 (fls == 4) */
	{ 0x7A, 0x7D, 0x0004,  2 }, /* for field == 0x0010 (fls == 5) */
	{ 0x7A, 0x7D, 0x0030,  4 }, /* for field == 0x0020 (fls == 6) */
	{ 0x7A, 0x7D, 0x00C0,  6 }, /* for field == 0x0040 (fls == 7) */
	{ 0x7A, 0x7D, 0x0100,  8 }, /* for field == 0x0080 (fls == 8) */
	{ 0x7A, 0x7D, 0x0200,  9 }, /* for field == 0x0100 (fls == 9) */
	{ 0x78, 0x78, 0x0004,  2 }, /* for field == 0x0200 (fls == 10) */
	{ 0x7B, 0x7E, 0x01FF,  0 }, /* for field == 0x0400 (fls == 11) */
	{ 0x7C, 0x7F, 0x01FF,  0 }, /* for field == 0x0800 (fls == 12) */
	{ 0x78, 0x78, 0x0100,  8 }, /* for field == 0x1000 (fls == 13) */
	{ 0x78, 0x78, 0x0200,  9 }, /* for field == 0x2000 (fls == 14) */
	{ 0x78, 0x78, 0xF000, 12 }  /* for field == 0x4000 (fls == 15) */
};

/* val_mask, val_shift, en_addr0, val_addr0, en_addr1, val_addr1 */
const struct nphy_rf_control_override_rev3 tbl_rf_control_override_rev3[] = {
	{ 0x8000, 15, 0xE5, 0xF9, 0xE6, 0xFB }, /* field == 0x0001 (fls 1) */
	{ 0x0001,  0, 0xE7, 0x7A, 0xEC, 0x7D }, /* field == 0x0002 (fls 2) */
	{ 0x0002,  1, 0xE7, 0x7A, 0xEC, 0x7D }, /* field == 0x0004 (fls 3) */
	{ 0x0004,  2, 0xE7, 0x7A, 0xEC, 0x7D }, /* field == 0x0008 (fls 4) */
	{ 0x0010,  4, 0xE7, 0x7A, 0xEC, 0x7D }, /* field == 0x0010 (fls 5) */
	{ 0x0020,  5, 0xE7, 0x7A, 0xEC, 0x7D }, /* field == 0x0020 (fls 6) */
	{ 0x0040,  6, 0xE7, 0x7A, 0xEC, 0x7D }, /* field == 0x0040 (fls 7) */
	{ 0x0080,  7, 0xE7, 0x7A, 0xEC, 0x7D }, /* field == 0x0080 (fls 8) */
	{ 0x0100,  8, 0xE7, 0x7A, 0xEC, 0x7D }, /* field == 0x0100 (fls 9) */
	{ 0x0007,  0, 0xE7, 0xF8, 0xEC, 0xFA }, /* field == 0x0200 (fls 10) */
	{ 0x0070,  4, 0xE7, 0xF8, 0xEC, 0xFA }, /* field == 0x0400 (fls 11) */
	{ 0xE000, 13, 0xE7, 0x7A, 0xEC, 0x7D }, /* field == 0x0800 (fls 12) */
	{ 0xFFFF,  0, 0xE7, 0x7B, 0xEC, 0x7E }, /* field == 0x1000 (fls 13) */
	{ 0xFFFF,  0, 0xE7, 0x7C, 0xEC, 0x7F }, /* field == 0x2000 (fls 14) */
	{ 0x00C0,  6, 0xE7, 0xF9, 0xEC, 0xFB }  /* field == 0x4000 (fls 15) */
};

/* field, val_addr_core0, val_addr_core1, val_mask, val_shift */
static const struct nphy_rf_control_override_rev7
			tbl_rf_control_override_rev7_over0[] = {
	{ 0x0004, 0x07A, 0x07D, 0x0002, 1 },
	{ 0x0008, 0x07A, 0x07D, 0x0004, 2 },
	{ 0x0010, 0x07A, 0x07D, 0x0010, 4 },
	{ 0x0020, 0x07A, 0x07D, 0x0020, 5 },
	{ 0x0040, 0x07A, 0x07D, 0x0040, 6 },
	{ 0x0080, 0x0F8, 0x0FA, 0x0080, 7 },
	{ 0x0400, 0x0F8, 0x0FA, 0x0070, 4 },
	{ 0x0800, 0x07B, 0x07E, 0xFFFF, 0 },
	{ 0x1000, 0x07C, 0x07F, 0xFFFF, 0 },
	{ 0x6000, 0x348, 0x349, 0xFFFF, 0 },
	{ 0x2000, 0x348, 0x349, 0x000F, 0 },
};

/* field, val_addr_core0, val_addr_core1, val_mask, val_shift */
static const struct nphy_rf_control_override_rev7
			tbl_rf_control_override_rev7_over1[] = {
	{ 0x0002, 0x340, 0x341, 0x0002, 1 },
	{ 0x0008, 0x340, 0x341, 0x0008, 3 },
	{ 0x0020, 0x340, 0x341, 0x0020, 5 },
	{ 0x0010, 0x340, 0x341, 0x0010, 4 },
	{ 0x0004, 0x340, 0x341, 0x0004, 2 },
	{ 0x0080, 0x340, 0x341, 0x0700, 8 },
	{ 0x0800, 0x340, 0x341, 0x4000, 14 },
	{ 0x0400, 0x340, 0x341, 0x2000, 13 },
	{ 0x0200, 0x340, 0x341, 0x0800, 12 },
	{ 0x0100, 0x340, 0x341, 0x0100, 11 },
	{ 0x0040, 0x340, 0x341, 0x0040, 6 },
	{ 0x0001, 0x340, 0x341, 0x0001, 0 },
};

/* field, val_addr_core0, val_addr_core1, val_mask, val_shift */
static const struct nphy_rf_control_override_rev7
			tbl_rf_control_override_rev7_over2[] = {
	{ 0x0008, 0x344, 0x345, 0x0008, 3 },
	{ 0x0002, 0x344, 0x345, 0x0002, 1 },
	{ 0x0001, 0x344, 0x345, 0x0001, 0 },
	{ 0x0004, 0x344, 0x345, 0x0004, 2 },
	{ 0x0010, 0x344, 0x345, 0x0010, 4 },
};

static struct nphy_gain_ctl_workaround_entry nphy_gain_ctl_wa_phy6_radio11_ghz2 = {
	{ 10, 14, 19, 27 },
	{ -5, 6, 10, 15 },
	{ 0xA, 0xA, 0xA, 0xA, 0xA, 0xA, 0xA, 0xA, 0xA, 0xA },
	{ 3, 3, 3, 3, 3, 3, 3, 3, 3, 3 },
	0x427E,
	{ 0x413F, 0x413F, 0x413F, 0x413F },
	0x007E, 0x0066, 0x1074,
	0x18, 0x18, 0x18,
	0x01D0, 0x5,
};
static struct nphy_gain_ctl_workaround_entry nphy_gain_ctl_workaround[2][4] = {
	{ /* 2GHz */
		{ /* PHY rev 3 */
			{ 7, 11, 16, 23 },
			{ -5, 6, 10, 14 },
			{ 0xA, 0xA, 0xA, 0xA, 0xA, 0xA, 0xA, 0xA, 0xA, 0xA },
			{ 3, 3, 3, 3, 3, 3, 3, 3, 3, 3 },
			0x627E,
			{ 0x613F, 0x613F, 0x613F, 0x613F },
			0x107E, 0x0066, 0x0074,
			0x18, 0x18, 0x18,
			0x020D, 0x5,
		},
		{ /* PHY rev 4 */
			{ 8, 12, 17, 25 },
			{ -5, 6, 10, 14 },
			{ 0xA, 0xA, 0xA, 0xA, 0xA, 0xA, 0xA, 0xA, 0xA, 0xA },
			{ 3, 3, 3, 3, 3, 3, 3, 3, 3, 3 },
			0x527E,
			{ 0x513F, 0x513F, 0x513F, 0x513F },
			0x007E, 0x0066, 0x0074,
			0x18, 0x18, 0x18,
			0x01A1, 0x5,
		},
		{ /* PHY rev 5 */
			{ 9, 13, 18, 26 },
			{ -3, 7, 11, 16 },
			{ 0xA, 0xA, 0xA, 0xA, 0xA, 0xA, 0xA, 0xA, 0xA, 0xA },
			{ 3, 3, 3, 3, 3, 3, 3, 3, 3, 3 },
			0x427E, /* invalid for external LNA! */
			{ 0x413F, 0x413F, 0x413F, 0x413F }, /* invalid for external LNA! */
			0x1076, 0x0066, 0x0000, /* low is invalid (the last one) */
			0x18, 0x18, 0x18,
			0x01D0, 0x9,
		},
		{ /* PHY rev 6+ */
			{ 8, 13, 18, 25 },
			{ -5, 6, 10, 14 },
			{ 0xA, 0xA, 0xA, 0xA, 0xA, 0xA, 0xA, 0xA, 0xA, 0xA },
			{ 3, 3, 3, 3, 3, 3, 3, 3, 3, 3 },
			0x527E, /* invalid for external LNA! */
			{ 0x513F, 0x513F, 0x513F, 0x513F }, /* invalid for external LNA! */
			0x1076, 0x0066, 0x0000, /* low is invalid (the last one) */
			0x18, 0x18, 0x18,
			0x01D0, 0x5,
		},
	},
	{ /* 5GHz */
		{ /* PHY rev 3 */
			{ 7, 11, 17, 23 },
			{ -6, 2, 6, 10 },
			{ 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13 },
			{ 6, 6, 6, 6, 6, 6, 6, 6, 6, 6 },
			0x52DE,
			{ 0x516F, 0x516F, 0x516F, 0x516F },
			0x00DE, 0x00CA, 0x00CC,
			0x1E, 0x1E, 0x1E,
			0x01A1, 25,
		},
		{ /* PHY rev 4 */
			{ 8, 12, 18, 23 },
			{ -5, 2, 6, 10 },
			{ 0xD, 0xD, 0xD, 0xD, 0xD, 0xD, 0xD, 0xD, 0xD, 0xD },
			{ 4, 4, 4, 4, 4, 4, 4, 4, 4, 4 },
			0x629E,
			{ 0x614F, 0x614F, 0x614F, 0x614F },
			0x029E, 0x1084, 0x0086,
			0x24, 0x24, 0x24,
			0x0107, 25,
		},
		{ /* PHY rev 5 */
			{ 6, 10, 16, 21 },
			{ -7, 0, 4, 8 },
			{ 0xD, 0xD, 0xD, 0xD, 0xD, 0xD, 0xD, 0xD, 0xD, 0xD },
			{ 4, 4, 4, 4, 4, 4, 4, 4, 4, 4 },
			0x729E,
			{ 0x714F, 0x714F, 0x714F, 0x714F },
			0x029E, 0x2084, 0x2086,
			0x24, 0x24, 0x24,
			0x00A9, 25,
		},
		{ /* PHY rev 6+ */
			{ 6, 10, 16, 21 },
			{ -7, 0, 4, 8 },
			{ 0xD, 0xD, 0xD, 0xD, 0xD, 0xD, 0xD, 0xD, 0xD, 0xD },
			{ 4, 4, 4, 4, 4, 4, 4, 4, 4, 4 },
			0x729E,
			{ 0x714F, 0x714F, 0x714F, 0x714F },
			0x029E, 0x2084, 0x2086,
			0x24, 0x24, 0x24, /* low is invalid for radio rev 11! */
			0x00F0, 25,
		},
	},
};

static inline void assert_ntab_array_sizes(void)
{
#undef check
#define check(table, size)	\
	BUILD_BUG_ON(ARRAY_SIZE(b43_ntab_##table) != B43_NTAB_##size##_SIZE)

	check(adjustpower0, C0_ADJPLT);
	check(adjustpower1, C1_ADJPLT);
	check(bdi, BDI);
	check(channelest, CHANEST);
	check(estimatepowerlt0, C0_ESTPLT);
	check(estimatepowerlt1, C1_ESTPLT);
	check(framelookup, FRAMELT);
	check(framestruct, FRAMESTRUCT);
	check(gainctl0, C0_GAINCTL);
	check(gainctl1, C1_GAINCTL);
	check(intlevel, INTLEVEL);
	check(iqlt0, C0_IQLT);
	check(iqlt1, C1_IQLT);
	check(loftlt0, C0_LOFEEDTH);
	check(loftlt1, C1_LOFEEDTH);
	check(mcs, MCS);
	check(noisevar10, NOISEVAR10);
	check(noisevar11, NOISEVAR11);
	check(pilot, PILOT);
	check(pilotlt, PILOTLT);
	check(tdi20a0, TDI20A0);
	check(tdi20a1, TDI20A1);
	check(tdi40a0, TDI40A0);
	check(tdi40a1, TDI40A1);
	check(tdtrn, TDTRN);
	check(tmap, TMAP);

#undef check
}

u32 b43_ntab_read(struct b43_wldev *dev, u32 offset)
{
	u32 type, value;

	type = offset & B43_NTAB_TYPEMASK;
	offset &= ~B43_NTAB_TYPEMASK;
	B43_WARN_ON(offset > 0xFFFF);

	switch (type) {
	case B43_NTAB_8BIT:
		b43_phy_write(dev, B43_NPHY_TABLE_ADDR, offset);
		value = b43_phy_read(dev, B43_NPHY_TABLE_DATALO) & 0xFF;
		break;
	case B43_NTAB_16BIT:
		b43_phy_write(dev, B43_NPHY_TABLE_ADDR, offset);
		value = b43_phy_read(dev, B43_NPHY_TABLE_DATALO);
		break;
	case B43_NTAB_32BIT:
		b43_phy_write(dev, B43_NPHY_TABLE_ADDR, offset);
		value = b43_phy_read(dev, B43_NPHY_TABLE_DATALO);
		value |= b43_phy_read(dev, B43_NPHY_TABLE_DATAHI) << 16;
		break;
	default:
		B43_WARN_ON(1);
		value = 0;
	}

	return value;
}

void b43_ntab_read_bulk(struct b43_wldev *dev, u32 offset,
			 unsigned int nr_elements, void *_data)
{
	u32 type;
	u8 *data = _data;
	unsigned int i;

	type = offset & B43_NTAB_TYPEMASK;
	offset &= ~B43_NTAB_TYPEMASK;
	B43_WARN_ON(offset > 0xFFFF);

	b43_phy_write(dev, B43_NPHY_TABLE_ADDR, offset);

	for (i = 0; i < nr_elements; i++) {
		/* Auto increment broken + caching issue on BCM43224? */
		if (dev->dev->chip_id == 43224 && dev->dev->chip_rev == 1) {
			b43_phy_read(dev, B43_NPHY_TABLE_DATALO);
			b43_phy_write(dev, B43_NPHY_TABLE_ADDR, offset + i);
		}

		switch (type) {
		case B43_NTAB_8BIT:
			*data = b43_phy_read(dev, B43_NPHY_TABLE_DATALO) & 0xFF;
			data++;
			break;
		case B43_NTAB_16BIT:
			*((u16 *)data) = b43_phy_read(dev, B43_NPHY_TABLE_DATALO);
			data += 2;
			break;
		case B43_NTAB_32BIT:
			*((u32 *)data) =
				b43_phy_read(dev, B43_NPHY_TABLE_DATALO);
			*((u32 *)data) |=
				b43_phy_read(dev, B43_NPHY_TABLE_DATAHI) << 16;
			data += 4;
			break;
		default:
			B43_WARN_ON(1);
		}
	}
}

void b43_ntab_write(struct b43_wldev *dev, u32 offset, u32 value)
{
	u32 type;

	type = offset & B43_NTAB_TYPEMASK;
	offset &= 0xFFFF;

	switch (type) {
	case B43_NTAB_8BIT:
		B43_WARN_ON(value & ~0xFF);
		b43_phy_write(dev, B43_NPHY_TABLE_ADDR, offset);
		b43_phy_write(dev, B43_NPHY_TABLE_DATALO, value);
		break;
	case B43_NTAB_16BIT:
		B43_WARN_ON(value & ~0xFFFF);
		b43_phy_write(dev, B43_NPHY_TABLE_ADDR, offset);
		b43_phy_write(dev, B43_NPHY_TABLE_DATALO, value);
		break;
	case B43_NTAB_32BIT:
		b43_phy_write(dev, B43_NPHY_TABLE_ADDR, offset);
		b43_phy_write(dev, B43_NPHY_TABLE_DATAHI, value >> 16);
		b43_phy_write(dev, B43_NPHY_TABLE_DATALO, value & 0xFFFF);
		break;
	default:
		B43_WARN_ON(1);
	}

	return;

	/* Some compiletime assertions... */
	assert_ntab_array_sizes();
}

void b43_ntab_write_bulk(struct b43_wldev *dev, u32 offset,
			  unsigned int nr_elements, const void *_data)
{
	u32 type, value;
	const u8 *data = _data;
	unsigned int i;

	type = offset & B43_NTAB_TYPEMASK;
	offset &= ~B43_NTAB_TYPEMASK;
	B43_WARN_ON(offset > 0xFFFF);

	b43_phy_write(dev, B43_NPHY_TABLE_ADDR, offset);

	for (i = 0; i < nr_elements; i++) {
		/* Auto increment broken + caching issue on BCM43224? */
		if ((offset >> 10) == 9 && dev->dev->chip_id == 43224 &&
		    dev->dev->chip_rev == 1) {
			b43_phy_read(dev, B43_NPHY_TABLE_DATALO);
			b43_phy_write(dev, B43_NPHY_TABLE_ADDR, offset + i);
		}

		switch (type) {
		case B43_NTAB_8BIT:
			value = *data;
			data++;
			B43_WARN_ON(value & ~0xFF);
			b43_phy_write(dev, B43_NPHY_TABLE_DATALO, value);
			break;
		case B43_NTAB_16BIT:
			value = *((u16 *)data);
			data += 2;
			B43_WARN_ON(value & ~0xFFFF);
			b43_phy_write(dev, B43_NPHY_TABLE_DATALO, value);
			break;
		case B43_NTAB_32BIT:
			value = *((u32 *)data);
			data += 4;
			b43_phy_write(dev, B43_NPHY_TABLE_DATAHI, value >> 16);
			b43_phy_write(dev, B43_NPHY_TABLE_DATALO,
					value & 0xFFFF);
			break;
		default:
			B43_WARN_ON(1);
		}
	}
}

#define ntab_upload(dev, offset, data) do { \
		b43_ntab_write_bulk(dev, offset, ARRAY_SIZE(data), data); \
	} while (0)

static void b43_nphy_tables_init_rev3(struct b43_wldev *dev)
{
	struct ssb_sprom *sprom = dev->dev->bus_sprom;
	u8 antswlut;

	if (b43_current_band(dev->wl) == IEEE80211_BAND_5GHZ)
		antswlut = sprom->fem.ghz5.antswlut;
	else
		antswlut = sprom->fem.ghz2.antswlut;

	/* Static tables */
	ntab_upload(dev, B43_NTAB_FRAMESTRUCT_R3, b43_ntab_framestruct_r3);
	ntab_upload(dev, B43_NTAB_PILOT_R3, b43_ntab_pilot_r3);
	ntab_upload(dev, B43_NTAB_TMAP_R3, b43_ntab_tmap_r3);
	ntab_upload(dev, B43_NTAB_INTLEVEL_R3, b43_ntab_intlevel_r3);
	ntab_upload(dev, B43_NTAB_TDTRN_R3, b43_ntab_tdtrn_r3);
	ntab_upload(dev, B43_NTAB_NOISEVAR_R3, b43_ntab_noisevar_r3);
	ntab_upload(dev, B43_NTAB_MCS_R3, b43_ntab_mcs_r3);
	ntab_upload(dev, B43_NTAB_TDI20A0_R3, b43_ntab_tdi20a0_r3);
	ntab_upload(dev, B43_NTAB_TDI20A1_R3, b43_ntab_tdi20a1_r3);
	ntab_upload(dev, B43_NTAB_TDI40A0_R3, b43_ntab_tdi40a0_r3);
	ntab_upload(dev, B43_NTAB_TDI40A1_R3, b43_ntab_tdi40a1_r3);
	ntab_upload(dev, B43_NTAB_PILOTLT_R3, b43_ntab_pilotlt_r3);
	ntab_upload(dev, B43_NTAB_CHANEST_R3, b43_ntab_channelest_r3);
	ntab_upload(dev, B43_NTAB_FRAMELT_R3, b43_ntab_framelookup_r3);
	ntab_upload(dev, B43_NTAB_C0_ESTPLT_R3, b43_ntab_estimatepowerlt0_r3);
	ntab_upload(dev, B43_NTAB_C1_ESTPLT_R3, b43_ntab_estimatepowerlt1_r3);
	ntab_upload(dev, B43_NTAB_C0_ADJPLT_R3, b43_ntab_adjustpower0_r3);
	ntab_upload(dev, B43_NTAB_C1_ADJPLT_R3, b43_ntab_adjustpower1_r3);
	ntab_upload(dev, B43_NTAB_C0_GAINCTL_R3, b43_ntab_gainctl0_r3);
	ntab_upload(dev, B43_NTAB_C1_GAINCTL_R3, b43_ntab_gainctl1_r3);
	ntab_upload(dev, B43_NTAB_C0_IQLT_R3, b43_ntab_iqlt0_r3);
	ntab_upload(dev, B43_NTAB_C1_IQLT_R3, b43_ntab_iqlt1_r3);
	ntab_upload(dev, B43_NTAB_C0_LOFEEDTH_R3, b43_ntab_loftlt0_r3);
	ntab_upload(dev, B43_NTAB_C1_LOFEEDTH_R3, b43_ntab_loftlt1_r3);

	/* Volatile tables */
	if (antswlut < ARRAY_SIZE(b43_ntab_antswctl_r3))
		ntab_upload(dev, B43_NTAB_ANT_SW_CTL_R3,
			    b43_ntab_antswctl_r3[antswlut]);
	else
		B43_WARN_ON(1);
}

static void b43_nphy_tables_init_rev0(struct b43_wldev *dev)
{
	/* Static tables */
	ntab_upload(dev, B43_NTAB_FRAMESTRUCT, b43_ntab_framestruct);
	ntab_upload(dev, B43_NTAB_FRAMELT, b43_ntab_framelookup);
	ntab_upload(dev, B43_NTAB_TMAP, b43_ntab_tmap);
	ntab_upload(dev, B43_NTAB_TDTRN, b43_ntab_tdtrn);
	ntab_upload(dev, B43_NTAB_INTLEVEL, b43_ntab_intlevel);
	ntab_upload(dev, B43_NTAB_PILOT, b43_ntab_pilot);
	ntab_upload(dev, B43_NTAB_TDI20A0, b43_ntab_tdi20a0);
	ntab_upload(dev, B43_NTAB_TDI20A1, b43_ntab_tdi20a1);
	ntab_upload(dev, B43_NTAB_TDI40A0, b43_ntab_tdi40a0);
	ntab_upload(dev, B43_NTAB_TDI40A1, b43_ntab_tdi40a1);
	ntab_upload(dev, B43_NTAB_CHANEST, b43_ntab_channelest);
	ntab_upload(dev, B43_NTAB_MCS, b43_ntab_mcs);
	ntab_upload(dev, B43_NTAB_NOISEVAR10, b43_ntab_noisevar10);
	ntab_upload(dev, B43_NTAB_NOISEVAR11, b43_ntab_noisevar11);

	/* Volatile tables */
	ntab_upload(dev, B43_NTAB_BDI, b43_ntab_bdi);
	ntab_upload(dev, B43_NTAB_PILOTLT, b43_ntab_pilotlt);
	ntab_upload(dev, B43_NTAB_C0_GAINCTL, b43_ntab_gainctl0);
	ntab_upload(dev, B43_NTAB_C1_GAINCTL, b43_ntab_gainctl1);
	ntab_upload(dev, B43_NTAB_C0_ESTPLT, b43_ntab_estimatepowerlt0);
	ntab_upload(dev, B43_NTAB_C1_ESTPLT, b43_ntab_estimatepowerlt1);
	ntab_upload(dev, B43_NTAB_C0_ADJPLT, b43_ntab_adjustpower0);
	ntab_upload(dev, B43_NTAB_C1_ADJPLT, b43_ntab_adjustpower1);
	ntab_upload(dev, B43_NTAB_C0_IQLT, b43_ntab_iqlt0);
	ntab_upload(dev, B43_NTAB_C1_IQLT, b43_ntab_iqlt1);
	ntab_upload(dev, B43_NTAB_C0_LOFEEDTH, b43_ntab_loftlt0);
	ntab_upload(dev, B43_NTAB_C1_LOFEEDTH, b43_ntab_loftlt1);
}

/* http://bcm-v4.sipsolutions.net/802.11/PHY/N/InitTables */
void b43_nphy_tables_init(struct b43_wldev *dev)
{
	if (dev->phy.rev >= 3)
		b43_nphy_tables_init_rev3(dev);
	else
		b43_nphy_tables_init_rev0(dev);
}

/* http://bcm-v4.sipsolutions.net/802.11/PHY/N/GetIpaGainTbl */
static const u32 *b43_nphy_get_ipa_gain_table(struct b43_wldev *dev)
{
	if (b43_current_band(dev->wl) == IEEE80211_BAND_2GHZ) {
		if (dev->phy.rev >= 6) {
			if (dev->dev->chip_id == 47162)
				return txpwrctrl_tx_gain_ipa_rev5;
			return txpwrctrl_tx_gain_ipa_rev6;
		} else if (dev->phy.rev >= 5) {
			return txpwrctrl_tx_gain_ipa_rev5;
		} else {
			return txpwrctrl_tx_gain_ipa;
		}
	} else {
		return txpwrctrl_tx_gain_ipa_5g;
	}
}

const u32 *b43_nphy_get_tx_gain_table(struct b43_wldev *dev)
{
	enum ieee80211_band band = b43_current_band(dev->wl);
	struct ssb_sprom *sprom = dev->dev->bus_sprom;

	if (dev->phy.rev < 3)
		return b43_ntab_tx_gain_rev0_1_2;

	/* rev 3+ */
	if ((dev->phy.n->ipa2g_on && band == IEEE80211_BAND_2GHZ) ||
	    (dev->phy.n->ipa5g_on && band == IEEE80211_BAND_5GHZ)) {
		return b43_nphy_get_ipa_gain_table(dev);
	} else if (b43_current_band(dev->wl) == IEEE80211_BAND_5GHZ) {
		if (dev->phy.rev == 3)
			return b43_ntab_tx_gain_rev3_5ghz;
		if (dev->phy.rev == 4)
			return sprom->fem.ghz5.extpa_gain == 3 ?
				b43_ntab_tx_gain_rev4_5ghz :
				b43_ntab_tx_gain_rev4_5ghz; /* FIXME */
		else
			return b43_ntab_tx_gain_rev5plus_5ghz;
	} else {
		if (dev->phy.rev >= 5 && sprom->fem.ghz5.extpa_gain == 3)
			return b43_ntab_tx_gain_rev3plus_2ghz; /* FIXME */
		else
			return b43_ntab_tx_gain_rev3plus_2ghz;
	}
}

struct nphy_gain_ctl_workaround_entry *b43_nphy_get_gain_ctl_workaround_ent(
	struct b43_wldev *dev, bool ghz5, bool ext_lna)
{
	struct nphy_gain_ctl_workaround_entry *e;
	u8 phy_idx;

	if (!ghz5 && dev->phy.rev >= 6 && dev->phy.radio_rev == 11)
		return &nphy_gain_ctl_wa_phy6_radio11_ghz2;

	B43_WARN_ON(dev->phy.rev < 3);
	if (dev->phy.rev >= 6)
		phy_idx = 3;
	else if (dev->phy.rev == 5)
		phy_idx = 2;
	else if (dev->phy.rev == 4)
		phy_idx = 1;
	else
		phy_idx = 0;
	e = &nphy_gain_ctl_workaround[ghz5][phy_idx];

	/* Some workarounds to the workarounds... */
	if (ghz5 && dev->phy.rev >= 6) {
		if (dev->phy.radio_rev == 11 &&
		    !b43_channel_type_is_40mhz(dev->phy.channel_type))
			e->cliplo_gain = 0x2d;
	} else if (!ghz5 && dev->phy.rev >= 5) {
		static const int gain_data[] = {0x0062, 0x0064, 0x006a, 0x106a,
						0x106c, 0x1074, 0x107c, 0x207c};
		u8 tr_iso = dev->dev->bus_sprom->fem.ghz2.tr_iso;

		if (ext_lna) {
			e->rfseq_init[0] &= ~0x4000;
			e->rfseq_init[1] &= ~0x4000;
			e->rfseq_init[2] &= ~0x4000;
			e->rfseq_init[3] &= ~0x4000;
			e->init_gain &= ~0x4000;
		}
		if (tr_iso > 7)
			tr_iso = 3;
		e->cliplo_gain = gain_data[tr_iso];

	} else if (ghz5 && dev->phy.rev == 4 && ext_lna) {
		e->rfseq_init[0] &= ~0x4000;
		e->rfseq_init[1] &= ~0x4000;
		e->rfseq_init[2] &= ~0x4000;
		e->rfseq_init[3] &= ~0x4000;
		e->init_gain &= ~0x4000;
		e->rfseq_init[0] |= 0x1000;
		e->rfseq_init[1] |= 0x1000;
		e->rfseq_init[2] |= 0x1000;
		e->rfseq_init[3] |= 0x1000;
		e->init_gain |= 0x1000;
	}

	return e;
}

const struct nphy_rf_control_override_rev7 *b43_nphy_get_rf_ctl_over_rev7(
	struct b43_wldev *dev, u16 field, u8 override)
{
	const struct nphy_rf_control_override_rev7 *e;
	u8 size, i;

	switch (override) {
	case 0:
		e = tbl_rf_control_override_rev7_over0;
		size = ARRAY_SIZE(tbl_rf_control_override_rev7_over0);
		break;
	case 1:
		e = tbl_rf_control_override_rev7_over1;
		size = ARRAY_SIZE(tbl_rf_control_override_rev7_over1);
		break;
	case 2:
		e = tbl_rf_control_override_rev7_over2;
		size = ARRAY_SIZE(tbl_rf_control_override_rev7_over2);
		break;
	default:
		b43err(dev->wl, "Invalid override value %d\n", override);
		return NULL;
	}

	for (i = 0; i < size; i++) {
		if (e[i].field == field)
			return &e[i];
	}

	return NULL;
}
