/* arch/arm/mach-msm/proc_comm.h
 *
 * Copyright (c) 2007 QUALCOMM Incorporated
 *
 * This software is licensed under the terms of the GNU General Public
 * License version 2, as published by the Free Software Foundation, and
 * may be copied, distributed, and modified under those terms.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#ifndef _ARCH_ARM_MACH_MSM_PROC_COMM_H_
#define _ARCH_ARM_MACH_MSM_PROC_COMM_H_

enum {
	PCOM_CMD_IDLE = 0x0,
	PCOM_CMD_DONE,
	PCOM_RESET_APPS,
	PCOM_RESET_CHIP,
	PCOM_CONFIG_NAND_MPU,
	PCOM_CONFIG_USB_CLKS,
	PCOM_GET_POWER_ON_STATUS,
	PCOM_GET_WAKE_UP_STATUS,
	PCOM_GET_BATT_LEVEL,
	PCOM_CHG_IS_CHARGING,
	PCOM_POWER_DOWN,
	PCOM_USB_PIN_CONFIG,
	PCOM_USB_PIN_SEL,
	PCOM_SET_RTC_ALARM,
	PCOM_NV_READ,
	PCOM_NV_WRITE,
	PCOM_GET_UUID_HIGH,
	PCOM_GET_UUID_LOW,
	PCOM_GET_HW_ENTROPY,
	PCOM_RPC_GPIO_TLMM_CONFIG_REMOTE,
	PCOM_CLKCTL_RPC_ENABLE,
	PCOM_CLKCTL_RPC_DISABLE,
	PCOM_CLKCTL_RPC_RESET,
	PCOM_CLKCTL_RPC_SET_FLAGS,
	PCOM_CLKCTL_RPC_SET_RATE,
	PCOM_CLKCTL_RPC_MIN_RATE,
	PCOM_CLKCTL_RPC_MAX_RATE,
	PCOM_CLKCTL_RPC_RATE,
	PCOM_CLKCTL_RPC_PLL_REQUEST,
	PCOM_CLKCTL_RPC_ENABLED,
	PCOM_VREG_SWITCH,
	PCOM_VREG_SET_LEVEL,
	PCOM_GPIO_TLMM_CONFIG_GROUP,
	PCOM_GPIO_TLMM_UNCONFIG_GROUP,
	PCOM_NV_WRITE_BYTES_4_7,
	PCOM_CONFIG_DISP,
	PCOM_GET_FTM_BOOT_COUNT,
	PCOM_RPC_GPIO_TLMM_CONFIG_EX,
	PCOM_PM_MPP_CONFIG,
	PCOM_GPIO_IN,
	PCOM_GPIO_OUT,
	PCOM_RESET_MODEM,
	PCOM_RESET_CHIP_IMM,
	PCOM_PM_VID_EN,
	PCOM_VREG_PULLDOWN,
	PCOM_NUM_CMDS,
};

enum {
	 PCOM_INVALID_STATUS = 0x0,
	 PCOM_READY,
	 PCOM_CMD_RUNNING,
	 PCOM_CMD_SUCCESS,
	 PCOM_CMD_FAIL,
};

/* List of VREGs that support the Pull Down Resistor setting. */
enum {
	PM_VREG_PDOWN_MSMA_ID,
	PM_VREG_PDOWN_MSMP_ID,
	PM_VREG_PDOWN_MSME1_ID,	/* Not supported in Panoramix */
	PM_VREG_PDOWN_MSMC1_ID,	/* Not supported in PM6620 */
	PM_VREG_PDOWN_MSMC2_ID,	/* Supported in PM7500 only */
	PM_VREG_PDOWN_GP3_ID,	/* Supported in PM7500 only */
	PM_VREG_PDOWN_MSME2_ID,	/* Supported in PM7500 and Panoramix only */
	PM_VREG_PDOWN_GP4_ID,	/* Supported in PM7500 only */
	PM_VREG_PDOWN_GP1_ID,	/* Supported in PM7500 only */
	PM_VREG_PDOWN_TCXO_ID,
	PM_VREG_PDOWN_PA_ID,
	PM_VREG_PDOWN_RFTX_ID,
	PM_VREG_PDOWN_RFRX1_ID,
	PM_VREG_PDOWN_RFRX2_ID,
	PM_VREG_PDOWN_SYNT_ID,
	PM_VREG_PDOWN_WLAN_ID,
	PM_VREG_PDOWN_USB_ID,
	PM_VREG_PDOWN_MMC_ID,
	PM_VREG_PDOWN_RUIM_ID,
	PM_VREG_PDOWN_MSMC0_ID,	/* Supported in PM6610 only */
	PM_VREG_PDOWN_GP2_ID,	/* Supported in PM7500 only */
	PM_VREG_PDOWN_GP5_ID,	/* Supported in PM7500 only */
	PM_VREG_PDOWN_GP6_ID,	/* Supported in PM7500 only */
	PM_VREG_PDOWN_RF_ID,
	PM_VREG_PDOWN_RF_VCO_ID,
	PM_VREG_PDOWN_MPLL_ID,
	PM_VREG_PDOWN_S2_ID,
	PM_VREG_PDOWN_S3_ID,
	PM_VREG_PDOWN_RFUBM_ID,

	/* new for HAN */
	PM_VREG_PDOWN_RF1_ID,
	PM_VREG_PDOWN_RF2_ID,
	PM_VREG_PDOWN_RFA_ID,
	PM_VREG_PDOWN_CDC2_ID,
	PM_VREG_PDOWN_RFTX2_ID,
	PM_VREG_PDOWN_USIM_ID,
	PM_VREG_PDOWN_USB2P6_ID,
	PM_VREG_PDOWN_USB3P3_ID,
	PM_VREG_PDOWN_INVALID_ID,

	/* backward compatible enums only */
	PM_VREG_PDOWN_CAM_ID = PM_VREG_PDOWN_GP1_ID,
	PM_VREG_PDOWN_MDDI_ID = PM_VREG_PDOWN_GP2_ID,
	PM_VREG_PDOWN_RUIM2_ID = PM_VREG_PDOWN_GP3_ID,
	PM_VREG_PDOWN_AUX_ID = PM_VREG_PDOWN_GP4_ID,
	PM_VREG_PDOWN_AUX2_ID = PM_VREG_PDOWN_GP5_ID,
	PM_VREG_PDOWN_BT_ID = PM_VREG_PDOWN_GP6_ID,

	PM_VREG_PDOWN_MSME_ID = PM_VREG_PDOWN_MSME1_ID,
	PM_VREG_PDOWN_MSMC_ID = PM_VREG_PDOWN_MSMC1_ID,
	PM_VREG_PDOWN_RFA1_ID = PM_VREG_PDOWN_RFRX2_ID,
	PM_VREG_PDOWN_RFA2_ID = PM_VREG_PDOWN_RFTX2_ID,
	PM_VREG_PDOWN_XO_ID = PM_VREG_PDOWN_TCXO_ID
};

/* gpio info for PCOM_RPC_GPIO_TLMM_CONFIG_EX */

#define GPIO_ENABLE	0
#define GPIO_DISABLE	1

#define GPIO_INPUT	0
#define GPIO_OUTPUT	1

#define GPIO_NO_PULL	0
#define GPIO_PULL_DOWN	1
#define GPIO_KEEPER	2
#define GPIO_PULL_UP	3

#define GPIO_2MA	0
#define GPIO_4MA	1
#define GPIO_6MA	2
#define GPIO_8MA	3
#define GPIO_10MA	4
#define GPIO_12MA	5
#define GPIO_14MA	6
#define GPIO_16MA	7

#define PCOM_GPIO_CFG(gpio, func, dir, pull, drvstr) \
		((((gpio) & 0x3FF) << 4)	| \
		((func) & 0xf)			| \
		(((dir) & 0x1) << 14)		| \
		(((pull) & 0x3) << 15)		| \
		(((drvstr) & 0xF) << 17))

int msm_proc_comm(unsigned cmd, unsigned *data1, unsigned *data2);

#endif
