// SPDX-License-Identifier: GPL-2.0-or-later
/* Copyright (C) 2019 IBM Corp. */
#include <linux/bitops.h>
#include <linux/init.h>
#include <linux/io.h>
#include <linux/kernel.h>
#include <linux/mfd/syscon.h>
#include <linux/mutex.h>
#include <linux/of.h>
#include <linux/platform_device.h>
#include <linux/pinctrl/pinctrl.h>
#include <linux/pinctrl/pinmux.h>
#include <linux/string.h>
#include <linux/types.h>

#include "../core.h"
#include "../pinctrl-utils.h"
#include "pinctrl-aspeed.h"

#define SCU400		0x400 /* Multi-function Pin Control #1  */
#define SCU404		0x404 /* Multi-function Pin Control #2  */
#define SCU410		0x410 /* Multi-function Pin Control #4  */
#define SCU414		0x414 /* Multi-function Pin Control #5  */
#define SCU418		0x418 /* Multi-function Pin Control #6  */
#define SCU41C		0x41C /* Multi-function Pin Control #7  */
#define SCU430		0x430 /* Multi-function Pin Control #8  */
#define SCU434		0x434 /* Multi-function Pin Control #9  */
#define SCU438		0x438 /* Multi-function Pin Control #10 */
#define SCU440		0x440 /* USB Multi-function Pin Control #12 */
#define SCU450		0x450 /* Multi-function Pin Control #14 */
#define SCU454		0x454 /* Multi-function Pin Control #15 */
#define SCU458		0x458 /* Multi-function Pin Control #16 */
#define SCU4B0		0x4B0 /* Multi-function Pin Control #17 */
#define SCU4B4		0x4B4 /* Multi-function Pin Control #18 */
#define SCU4B8		0x4B8 /* Multi-function Pin Control #19 */
#define SCU4BC		0x4BC /* Multi-function Pin Control #20 */
#define SCU4D4		0x4D4 /* Multi-function Pin Control #22 */
#define SCU4D8		0x4D8 /* Multi-function Pin Control #23 */
#define SCU500		0x500 /* Hardware Strap 1 */
#define SCU510		0x510 /* Hardware Strap 2 */
#define SCU610		0x610 /* Disable GPIO Internal Pull-Down #0 */
#define SCU614		0x614 /* Disable GPIO Internal Pull-Down #1 */
#define SCU618		0x618 /* Disable GPIO Internal Pull-Down #2 */
#define SCU61C		0x61c /* Disable GPIO Internal Pull-Down #3 */
#define SCU620		0x620 /* Disable GPIO Internal Pull-Down #4 */
#define SCU634		0x634 /* Disable GPIO Internal Pull-Down #5 */
#define SCU638		0x638 /* Disable GPIO Internal Pull-Down #6 */
#define SCU694		0x694 /* Multi-function Pin Control #25 */
#define SCUC20		0xC20 /* PCIE configuration Setting Control */

#define ASPEED_G6_NR_PINS 256

#define M24 0
SIG_EXPR_LIST_DECL_SESG(M24, MDC3, MDIO3, SIG_DESC_SET(SCU410, 0));
SIG_EXPR_LIST_DECL_SESG(M24, SCL11, I2C11, SIG_DESC_SET(SCU4B0, 0));
PIN_DECL_2(M24, GPIOA0, MDC3, SCL11);

#define M25 1
SIG_EXPR_LIST_DECL_SESG(M25, MDIO3, MDIO3, SIG_DESC_SET(SCU410, 1));
SIG_EXPR_LIST_DECL_SESG(M25, SDA11, I2C11, SIG_DESC_SET(SCU4B0, 1));
PIN_DECL_2(M25, GPIOA1, MDIO3, SDA11);

FUNC_GROUP_DECL(MDIO3, M24, M25);
FUNC_GROUP_DECL(I2C11, M24, M25);

#define L26 2
SIG_EXPR_LIST_DECL_SESG(L26, MDC4, MDIO4, SIG_DESC_SET(SCU410, 2));
SIG_EXPR_LIST_DECL_SESG(L26, SCL12, I2C12, SIG_DESC_SET(SCU4B0, 2));
PIN_DECL_2(L26, GPIOA2, MDC4, SCL12);

#define K24 3
SIG_EXPR_LIST_DECL_SESG(K24, MDIO4, MDIO4, SIG_DESC_SET(SCU410, 3));
SIG_EXPR_LIST_DECL_SESG(K24, SDA12, I2C12, SIG_DESC_SET(SCU4B0, 3));
PIN_DECL_2(K24, GPIOA3, MDIO4, SDA12);

FUNC_GROUP_DECL(MDIO4, L26, K24);
FUNC_GROUP_DECL(I2C12, L26, K24);

#define K26 4
SIG_EXPR_LIST_DECL_SESG(K26, MACLINK1, MACLINK1, SIG_DESC_SET(SCU410, 4));
SIG_EXPR_LIST_DECL_SESG(K26, SCL13, I2C13, SIG_DESC_SET(SCU4B0, 4));
PIN_DECL_2(K26, GPIOA4, MACLINK1, SCL13);
FUNC_GROUP_DECL(MACLINK1, K26);

#define L24 5
SIG_EXPR_LIST_DECL_SESG(L24, MACLINK2, MACLINK2, SIG_DESC_SET(SCU410, 5));
SIG_EXPR_LIST_DECL_SESG(L24, SDA13, I2C13, SIG_DESC_SET(SCU4B0, 5));
PIN_DECL_2(L24, GPIOA5, MACLINK2, SDA13);
FUNC_GROUP_DECL(MACLINK2, L24);

FUNC_GROUP_DECL(I2C13, K26, L24);

#define L23 6
SIG_EXPR_LIST_DECL_SESG(L23, MACLINK3, MACLINK3, SIG_DESC_SET(SCU410, 6));
SIG_EXPR_LIST_DECL_SESG(L23, SCL14, I2C14, SIG_DESC_SET(SCU4B0, 6));
PIN_DECL_2(L23, GPIOA6, MACLINK3, SCL14);
FUNC_GROUP_DECL(MACLINK3, L23);

#define K25 7
SIG_EXPR_LIST_DECL_SESG(K25, MACLINK4, MACLINK4, SIG_DESC_SET(SCU410, 7));
SIG_EXPR_LIST_DECL_SESG(K25, SDA14, I2C14, SIG_DESC_SET(SCU4B0, 7));
PIN_DECL_2(K25, GPIOA7, MACLINK4, SDA14);
FUNC_GROUP_DECL(MACLINK4, K25);

FUNC_GROUP_DECL(I2C14, L23, K25);

#define J26 8
SIG_EXPR_LIST_DECL_SESG(J26, SALT1, SALT1, SIG_DESC_SET(SCU410, 8));
SIG_EXPR_LIST_DECL_SESG(J26, LHAD0, LPCHC, SIG_DESC_SET(SCU4B0, 8));
PIN_DECL_2(J26, GPIOB0, SALT1, LHAD0);
FUNC_GROUP_DECL(SALT1, J26);

#define K23 9
SIG_EXPR_LIST_DECL_SESG(K23, SALT2, SALT2, SIG_DESC_SET(SCU410, 9));
SIG_EXPR_LIST_DECL_SESG(K23, LHAD1, LPCHC, SIG_DESC_SET(SCU4B0, 9));
PIN_DECL_2(K23, GPIOB1, SALT2, LHAD1);
FUNC_GROUP_DECL(SALT2, K23);

#define H26 10
SIG_EXPR_LIST_DECL_SESG(H26, SALT3, SALT3, SIG_DESC_SET(SCU410, 10));
SIG_EXPR_LIST_DECL_SESG(H26, LHAD2, LPCHC, SIG_DESC_SET(SCU4B0, 10));
PIN_DECL_2(H26, GPIOB2, SALT3, LHAD2);
FUNC_GROUP_DECL(SALT3, H26);

#define J25 11
SIG_EXPR_LIST_DECL_SESG(J25, SALT4, SALT4, SIG_DESC_SET(SCU410, 11));
SIG_EXPR_LIST_DECL_SESG(J25, LHAD3, LPCHC, SIG_DESC_SET(SCU4B0, 11));
PIN_DECL_2(J25, GPIOB3, SALT4, LHAD3);
FUNC_GROUP_DECL(SALT4, J25);

#define J23 12
SIG_EXPR_LIST_DECL_SESG(J23, MDC2, MDIO2, SIG_DESC_SET(SCU410, 12));
SIG_EXPR_LIST_DECL_SESG(J23, LHCLK, LPCHC, SIG_DESC_SET(SCU4B0, 12));
PIN_DECL_2(J23, GPIOB4, MDC2, LHCLK);

#define G26 13
SIG_EXPR_LIST_DECL_SESG(G26, MDIO2, MDIO2, SIG_DESC_SET(SCU410, 13));
SIG_EXPR_LIST_DECL_SESG(G26, LHFRAME, LPCHC, SIG_DESC_SET(SCU4B0, 13));
PIN_DECL_2(G26, GPIOB5, MDIO2, LHFRAME);

FUNC_GROUP_DECL(MDIO2, J23, G26);

#define H25 14
SIG_EXPR_LIST_DECL_SESG(H25, TXD4, TXD4, SIG_DESC_SET(SCU410, 14));
SIG_EXPR_LIST_DECL_SESG(H25, LHSIRQ, LHSIRQ, SIG_DESC_SET(SCU4B0, 14));
PIN_DECL_2(H25, GPIOB6, TXD4, LHSIRQ);
FUNC_GROUP_DECL(TXD4, H25);
FUNC_GROUP_DECL(LHSIRQ, H25);

#define J24 15
SIG_EXPR_LIST_DECL_SESG(J24, RXD4, RXD4, SIG_DESC_SET(SCU410, 15));
SIG_EXPR_LIST_DECL_SESG(J24, LHRST, LPCHC, SIG_DESC_SET(SCU4B0, 15));
PIN_DECL_2(J24, GPIOB7, RXD4, LHRST);
FUNC_GROUP_DECL(RXD4, J24);

FUNC_GROUP_DECL(LPCHC, J26, K23, H26, J25, J23, G26, H25, J24);

#define H24 16
SIG_EXPR_LIST_DECL_SESG(H24, RGMII3TXCK, RGMII3, SIG_DESC_SET(SCU410, 16),
			  SIG_DESC_SET(SCU510, 0));
SIG_EXPR_LIST_DECL_SESG(H24, RMII3RCLKO, RMII3, SIG_DESC_SET(SCU410, 16),
			  SIG_DESC_CLEAR(SCU510, 0));
PIN_DECL_2(H24, GPIOC0, RGMII3TXCK, RMII3RCLKO);

#define J22 17
SIG_EXPR_LIST_DECL_SESG(J22, RGMII3TXCTL, RGMII3, SIG_DESC_SET(SCU410, 17),
			  SIG_DESC_SET(SCU510, 0));
SIG_EXPR_LIST_DECL_SESG(J22, RMII3TXEN, RMII3, SIG_DESC_SET(SCU410, 17),
			  SIG_DESC_CLEAR(SCU510, 0));
PIN_DECL_2(J22, GPIOC1, RGMII3TXCTL, RMII3TXEN);

#define H22 18
SIG_EXPR_LIST_DECL_SESG(H22, RGMII3TXD0, RGMII3, SIG_DESC_SET(SCU410, 18),
			  SIG_DESC_SET(SCU510, 0));
SIG_EXPR_LIST_DECL_SESG(H22, RMII3TXD0, RMII3, SIG_DESC_SET(SCU410, 18),
			  SIG_DESC_CLEAR(SCU510, 0));
PIN_DECL_2(H22, GPIOC2, RGMII3TXD0, RMII3TXD0);

#define H23 19
SIG_EXPR_LIST_DECL_SESG(H23, RGMII3TXD1, RGMII3, SIG_DESC_SET(SCU410, 19),
			  SIG_DESC_SET(SCU510, 0));
SIG_EXPR_LIST_DECL_SESG(H23, RMII3TXD1, RMII3, SIG_DESC_SET(SCU410, 19),
			  SIG_DESC_CLEAR(SCU510, 0));
PIN_DECL_2(H23, GPIOC3, RGMII3TXD1, RMII3TXD1);

#define G22 20
SIG_EXPR_LIST_DECL_SESG(G22, RGMII3TXD2, RGMII3, SIG_DESC_SET(SCU410, 20),
			  SIG_DESC_SET(SCU510, 0));
PIN_DECL_1(G22, GPIOC4, RGMII3TXD2);

#define F22 21
SIG_EXPR_LIST_DECL_SESG(F22, RGMII3TXD3, RGMII3, SIG_DESC_SET(SCU410, 21),
			  SIG_DESC_SET(SCU510, 0));
PIN_DECL_1(F22, GPIOC5, RGMII3TXD3);

#define G23 22
SIG_EXPR_LIST_DECL_SESG(G23, RGMII3RXCK, RGMII3, SIG_DESC_SET(SCU410, 22),
			  SIG_DESC_SET(SCU510, 0));
SIG_EXPR_LIST_DECL_SESG(G23, RMII3RCLKI, RMII3, SIG_DESC_SET(SCU410, 22),
			  SIG_DESC_CLEAR(SCU510, 0));
PIN_DECL_2(G23, GPIOC6, RGMII3RXCK, RMII3RCLKI);

#define G24 23
SIG_EXPR_LIST_DECL_SESG(G24, RGMII3RXCTL, RGMII3, SIG_DESC_SET(SCU410, 23),
			  SIG_DESC_SET(SCU510, 0));
PIN_DECL_1(G24, GPIOC7, RGMII3RXCTL);

#define F23 24
SIG_EXPR_LIST_DECL_SESG(F23, RGMII3RXD0, RGMII3, SIG_DESC_SET(SCU410, 24),
			  SIG_DESC_SET(SCU510, 0));
SIG_EXPR_LIST_DECL_SESG(F23, RMII3RXD0, RMII3, SIG_DESC_SET(SCU410, 24),
			  SIG_DESC_CLEAR(SCU510, 0));
PIN_DECL_2(F23, GPIOD0, RGMII3RXD0, RMII3RXD0);

#define F26 25
SIG_EXPR_LIST_DECL_SESG(F26, RGMII3RXD1, RGMII3, SIG_DESC_SET(SCU410, 25),
			  SIG_DESC_SET(SCU510, 0));
SIG_EXPR_LIST_DECL_SESG(F26, RMII3RXD1, RMII3, SIG_DESC_SET(SCU410, 25),
			  SIG_DESC_CLEAR(SCU510, 0));
PIN_DECL_2(F26, GPIOD1, RGMII3RXD1, RMII3RXD1);

#define F25 26
SIG_EXPR_LIST_DECL_SESG(F25, RGMII3RXD2, RGMII3, SIG_DESC_SET(SCU410, 26),
			  SIG_DESC_SET(SCU510, 0));
SIG_EXPR_LIST_DECL_SESG(F25, RMII3CRSDV, RMII3, SIG_DESC_SET(SCU410, 26),
			  SIG_DESC_CLEAR(SCU510, 0));
PIN_DECL_2(F25, GPIOD2, RGMII3RXD2, RMII3CRSDV);

#define E26 27
SIG_EXPR_LIST_DECL_SESG(E26, RGMII3RXD3, RGMII3, SIG_DESC_SET(SCU410, 27),
			  SIG_DESC_SET(SCU510, 0));
SIG_EXPR_LIST_DECL_SESG(E26, RMII3RXER, RMII3, SIG_DESC_SET(SCU410, 27),
			  SIG_DESC_CLEAR(SCU510, 0));
PIN_DECL_2(E26, GPIOD3, RGMII3RXD3, RMII3RXER);

FUNC_GROUP_DECL(RGMII3, H24, J22, H22, H23, G22, F22, G23, G24, F23, F26, F25,
		E26);
FUNC_GROUP_DECL(RMII3, H24, J22, H22, H23, G23, F23, F26, F25, E26);

#define F24 28
SIG_EXPR_LIST_DECL_SESG(F24, NCTS3, NCTS3, SIG_DESC_SET(SCU410, 28));
SIG_EXPR_LIST_DECL_SESG(F24, RGMII4TXCK, RGMII4, SIG_DESC_SET(SCU4B0, 28),
			  SIG_DESC_SET(SCU510, 1));
SIG_EXPR_LIST_DECL_SESG(F24, RMII4RCLKO, RMII4, SIG_DESC_SET(SCU4B0, 28),
			  SIG_DESC_CLEAR(SCU510, 1));
PIN_DECL_3(F24, GPIOD4, NCTS3, RGMII4TXCK, RMII4RCLKO);
FUNC_GROUP_DECL(NCTS3, F24);

#define E23 29
SIG_EXPR_LIST_DECL_SESG(E23, NDCD3, NDCD3, SIG_DESC_SET(SCU410, 29));
SIG_EXPR_LIST_DECL_SESG(E23, RGMII4TXCTL, RGMII4, SIG_DESC_SET(SCU4B0, 29),
			  SIG_DESC_SET(SCU510, 1));
SIG_EXPR_LIST_DECL_SESG(E23, RMII4TXEN, RMII4, SIG_DESC_SET(SCU4B0, 29),
			  SIG_DESC_CLEAR(SCU510, 1));
PIN_DECL_3(E23, GPIOD5, NDCD3, RGMII4TXCTL, RMII4TXEN);
FUNC_GROUP_DECL(NDCD3, E23);

#define E24 30
SIG_EXPR_LIST_DECL_SESG(E24, NDSR3, NDSR3, SIG_DESC_SET(SCU410, 30));
SIG_EXPR_LIST_DECL_SESG(E24, RGMII4TXD0, RGMII4, SIG_DESC_SET(SCU4B0, 30),
			  SIG_DESC_SET(SCU510, 1));
SIG_EXPR_LIST_DECL_SESG(E24, RMII4TXD0, RMII4, SIG_DESC_SET(SCU4B0, 30),
			  SIG_DESC_CLEAR(SCU510, 1));
PIN_DECL_3(E24, GPIOD6, NDSR3, RGMII4TXD0, RMII4TXD0);
FUNC_GROUP_DECL(NDSR3, E24);

#define E25 31
SIG_EXPR_LIST_DECL_SESG(E25, NRI3, NRI3, SIG_DESC_SET(SCU410, 31));
SIG_EXPR_LIST_DECL_SESG(E25, RGMII4TXD1, RGMII4, SIG_DESC_SET(SCU4B0, 31),
			  SIG_DESC_SET(SCU510, 1));
SIG_EXPR_LIST_DECL_SESG(E25, RMII4TXD1, RMII4, SIG_DESC_SET(SCU4B0, 31),
			  SIG_DESC_CLEAR(SCU510, 1));
PIN_DECL_3(E25, GPIOD7, NRI3, RGMII4TXD1, RMII4TXD1);
FUNC_GROUP_DECL(NRI3, E25);

#define D26 32
SIG_EXPR_LIST_DECL_SESG(D26, NDTR3, NDTR3, SIG_DESC_SET(SCU414, 0));
SIG_EXPR_LIST_DECL_SESG(D26, RGMII4TXD2, RGMII4, SIG_DESC_SET(SCU4B4, 0),
			  SIG_DESC_SET(SCU510, 1));
PIN_DECL_2(D26, GPIOE0, NDTR3, RGMII4TXD2);
FUNC_GROUP_DECL(NDTR3, D26);

#define D24 33
SIG_EXPR_LIST_DECL_SESG(D24, NRTS3, NRTS3, SIG_DESC_SET(SCU414, 1));
SIG_EXPR_LIST_DECL_SESG(D24, RGMII4TXD3, RGMII4, SIG_DESC_SET(SCU4B4, 1),
			  SIG_DESC_SET(SCU510, 1));
PIN_DECL_2(D24, GPIOE1, NRTS3, RGMII4TXD3);
FUNC_GROUP_DECL(NRTS3, D24);

#define C25 34
SIG_EXPR_LIST_DECL_SESG(C25, NCTS4, NCTS4, SIG_DESC_SET(SCU414, 2));
SIG_EXPR_LIST_DECL_SESG(C25, RGMII4RXCK, RGMII4, SIG_DESC_SET(SCU4B4, 2),
			  SIG_DESC_SET(SCU510, 1));
SIG_EXPR_LIST_DECL_SESG(C25, RMII4RCLKI, RMII4, SIG_DESC_SET(SCU4B4, 2),
			  SIG_DESC_CLEAR(SCU510, 1));
PIN_DECL_3(C25, GPIOE2, NCTS4, RGMII4RXCK, RMII4RCLKI);
FUNC_GROUP_DECL(NCTS4, C25);

#define C26 35
SIG_EXPR_LIST_DECL_SESG(C26, NDCD4, NDCD4, SIG_DESC_SET(SCU414, 3));
SIG_EXPR_LIST_DECL_SESG(C26, RGMII4RXCTL, RGMII4, SIG_DESC_SET(SCU4B4, 3),
			  SIG_DESC_SET(SCU510, 1));
PIN_DECL_2(C26, GPIOE3, NDCD4, RGMII4RXCTL);
FUNC_GROUP_DECL(NDCD4, C26);

#define C24 36
SIG_EXPR_LIST_DECL_SESG(C24, NDSR4, NDSR4, SIG_DESC_SET(SCU414, 4));
SIG_EXPR_LIST_DECL_SESG(C24, RGMII4RXD0, RGMII4, SIG_DESC_SET(SCU4B4, 4),
			  SIG_DESC_SET(SCU510, 1));
SIG_EXPR_LIST_DECL_SESG(C24, RMII4RXD0, RMII4, SIG_DESC_SET(SCU4B4, 4),
			  SIG_DESC_CLEAR(SCU510, 1));
PIN_DECL_3(C24, GPIOE4, NDSR4, RGMII4RXD0, RMII4RXD0);
FUNC_GROUP_DECL(NDSR4, C24);

#define B26 37
SIG_EXPR_LIST_DECL_SESG(B26, NRI4, NRI4, SIG_DESC_SET(SCU414, 5));
SIG_EXPR_LIST_DECL_SESG(B26, RGMII4RXD1, RGMII4, SIG_DESC_SET(SCU4B4, 5),
			  SIG_DESC_SET(SCU510, 1));
SIG_EXPR_LIST_DECL_SESG(B26, RMII4RXD1, RMII4, SIG_DESC_SET(SCU4B4, 5),
			  SIG_DESC_CLEAR(SCU510, 1));
PIN_DECL_3(B26, GPIOE5, NRI4, RGMII4RXD1, RMII4RXD1);
FUNC_GROUP_DECL(NRI4, B26);

#define B25 38
SIG_EXPR_LIST_DECL_SESG(B25, NDTR4, NDTR4, SIG_DESC_SET(SCU414, 6));
SIG_EXPR_LIST_DECL_SESG(B25, RGMII4RXD2, RGMII4, SIG_DESC_SET(SCU4B4, 6),
			  SIG_DESC_SET(SCU510, 1));
SIG_EXPR_LIST_DECL_SESG(B25, RMII4CRSDV, RMII4, SIG_DESC_SET(SCU4B4, 6),
			  SIG_DESC_CLEAR(SCU510, 1));
PIN_DECL_3(B25, GPIOE6, NDTR4, RGMII4RXD2, RMII4CRSDV);
FUNC_GROUP_DECL(NDTR4, B25);

#define B24 39
SIG_EXPR_LIST_DECL_SESG(B24, NRTS4, NRTS4, SIG_DESC_SET(SCU414, 7));
SIG_EXPR_LIST_DECL_SESG(B24, RGMII4RXD3, RGMII4, SIG_DESC_SET(SCU4B4, 7),
			  SIG_DESC_SET(SCU510, 1));
SIG_EXPR_LIST_DECL_SESG(B24, RMII4RXER, RMII4, SIG_DESC_SET(SCU4B4, 7),
			  SIG_DESC_CLEAR(SCU510, 1));
PIN_DECL_3(B24, GPIOE7, NRTS4, RGMII4RXD3, RMII4RXER);
FUNC_GROUP_DECL(NRTS4, B24);

FUNC_GROUP_DECL(RGMII4, F24, E23, E24, E25, D26, D24, C25, C26, C24, B26, B25,
		B24);
FUNC_GROUP_DECL(RMII4, F24, E23, E24, E25, C25, C24, B26, B25, B24);

#define D22 40
SIG_EXPR_LIST_DECL_SESG(D22, SD1CLK, SD1, SIG_DESC_SET(SCU414, 8));
SIG_EXPR_LIST_DECL_SEMG(D22, PWM8, PWM8G0, PWM8, SIG_DESC_SET(SCU414, 8));
PIN_DECL_2(D22, GPIOF0, SD1CLK, PWM8);
GROUP_DECL(PWM8G0, D22);

#define E22 41
SIG_EXPR_LIST_DECL_SESG(E22, SD1CMD, SD1, SIG_DESC_SET(SCU414, 9));
SIG_EXPR_LIST_DECL_SEMG(E22, PWM9, PWM9G0, PWM9, SIG_DESC_SET(SCU4B4, 9));
PIN_DECL_2(E22, GPIOF1, SD1CMD, PWM9);
GROUP_DECL(PWM9G0, E22);

#define D23 42
SIG_EXPR_LIST_DECL_SESG(D23, SD1DAT0, SD1, SIG_DESC_SET(SCU414, 10));
SIG_EXPR_LIST_DECL_SEMG(D23, PWM10, PWM10G0, PWM10, SIG_DESC_SET(SCU4B4, 10));
PIN_DECL_2(D23, GPIOF2, SD1DAT0, PWM10);
GROUP_DECL(PWM10G0, D23);

#define C23 43
SIG_EXPR_LIST_DECL_SESG(C23, SD1DAT1, SD1, SIG_DESC_SET(SCU414, 11));
SIG_EXPR_LIST_DECL_SEMG(C23, PWM11, PWM11G0, PWM11, SIG_DESC_SET(SCU4B4, 11));
PIN_DECL_2(C23, GPIOF3, SD1DAT1, PWM11);
GROUP_DECL(PWM11G0, C23);

#define C22 44
SIG_EXPR_LIST_DECL_SESG(C22, SD1DAT2, SD1, SIG_DESC_SET(SCU414, 12));
SIG_EXPR_LIST_DECL_SEMG(C22, PWM12, PWM12G0, PWM12, SIG_DESC_SET(SCU4B4, 12));
PIN_DECL_2(C22, GPIOF4, SD1DAT2, PWM12);
GROUP_DECL(PWM12G0, C22);

#define A25 45
SIG_EXPR_LIST_DECL_SESG(A25, SD1DAT3, SD1, SIG_DESC_SET(SCU414, 13));
SIG_EXPR_LIST_DECL_SEMG(A25, PWM13, PWM13G0, PWM13, SIG_DESC_SET(SCU4B4, 13));
PIN_DECL_2(A25, GPIOF5, SD1DAT3, PWM13);
GROUP_DECL(PWM13G0, A25);

#define A24 46
SIG_EXPR_LIST_DECL_SESG(A24, SD1CD, SD1, SIG_DESC_SET(SCU414, 14));
SIG_EXPR_LIST_DECL_SEMG(A24, PWM14, PWM14G0, PWM14, SIG_DESC_SET(SCU4B4, 14));
PIN_DECL_2(A24, GPIOF6, SD1CD, PWM14);
GROUP_DECL(PWM14G0, A24);

#define A23 47
SIG_EXPR_LIST_DECL_SESG(A23, SD1WP, SD1, SIG_DESC_SET(SCU414, 15));
SIG_EXPR_LIST_DECL_SEMG(A23, PWM15, PWM15G0, PWM15, SIG_DESC_SET(SCU4B4, 15));
PIN_DECL_2(A23, GPIOF7, SD1WP, PWM15);
GROUP_DECL(PWM15G0, A23);

FUNC_GROUP_DECL(SD1, D22, E22, D23, C23, C22, A25, A24, A23);

#define E21 48
SIG_EXPR_LIST_DECL_SESG(E21, TXD6, UART6, SIG_DESC_SET(SCU414, 16));
SIG_EXPR_LIST_DECL_SESG(E21, SD2CLK, SD2, SIG_DESC_SET(SCU4B4, 16),
			  SIG_DESC_SET(SCU450, 1));
SIG_EXPR_LIST_DECL_SEMG(E21, SALT9, SALT9G0, SALT9, SIG_DESC_SET(SCU694, 16));
PIN_DECL_3(E21, GPIOG0, TXD6, SD2CLK, SALT9);
GROUP_DECL(SALT9G0, E21);

#define B22 49
SIG_EXPR_LIST_DECL_SESG(B22, RXD6, UART6, SIG_DESC_SET(SCU414, 17));
SIG_EXPR_LIST_DECL_SESG(B22, SD2CMD, SD2, SIG_DESC_SET(SCU4B4, 17),
			  SIG_DESC_SET(SCU450, 1));
SIG_EXPR_LIST_DECL_SEMG(B22, SALT10, SALT10G0, SALT10,
			SIG_DESC_SET(SCU694, 17));
PIN_DECL_3(B22, GPIOG1, RXD6, SD2CMD, SALT10);
GROUP_DECL(SALT10G0, B22);

FUNC_GROUP_DECL(UART6, E21, B22);

#define C21 50
SIG_EXPR_LIST_DECL_SESG(C21, TXD7, UART7, SIG_DESC_SET(SCU414, 18));
SIG_EXPR_LIST_DECL_SESG(C21, SD2DAT0, SD2, SIG_DESC_SET(SCU4B4, 18),
			  SIG_DESC_SET(SCU450, 1));
SIG_EXPR_LIST_DECL_SEMG(C21, SALT11, SALT11G0, SALT11,
			SIG_DESC_SET(SCU694, 18));
PIN_DECL_3(C21, GPIOG2, TXD7, SD2DAT0, SALT11);
GROUP_DECL(SALT11G0, C21);

#define A22 51
SIG_EXPR_LIST_DECL_SESG(A22, RXD7, UART7, SIG_DESC_SET(SCU414, 19));
SIG_EXPR_LIST_DECL_SESG(A22, SD2DAT1, SD2, SIG_DESC_SET(SCU4B4, 19),
			  SIG_DESC_SET(SCU450, 1));
SIG_EXPR_LIST_DECL_SEMG(A22, SALT12, SALT12G0, SALT12,
			SIG_DESC_SET(SCU694, 19));
PIN_DECL_3(A22, GPIOG3, RXD7, SD2DAT1, SALT12);
GROUP_DECL(SALT12G0, A22);

FUNC_GROUP_DECL(UART7, C21, A22);

#define A21 52
SIG_EXPR_LIST_DECL_SESG(A21, TXD8, UART8, SIG_DESC_SET(SCU414, 20));
SIG_EXPR_LIST_DECL_SESG(A21, SD2DAT2, SD2, SIG_DESC_SET(SCU4B4, 20),
			  SIG_DESC_SET(SCU450, 1));
SIG_EXPR_LIST_DECL_SEMG(A21, SALT13, SALT13G0, SALT13,
			SIG_DESC_SET(SCU694, 20));
PIN_DECL_3(A21, GPIOG4, TXD8, SD2DAT2, SALT13);
GROUP_DECL(SALT13G0, A21);

#define E20 53
SIG_EXPR_LIST_DECL_SESG(E20, RXD8, UART8, SIG_DESC_SET(SCU414, 21));
SIG_EXPR_LIST_DECL_SESG(E20, SD2DAT3, SD2, SIG_DESC_SET(SCU4B4, 21),
			  SIG_DESC_SET(SCU450, 1));
SIG_EXPR_LIST_DECL_SEMG(E20, SALT14, SALT14G0, SALT14,
			SIG_DESC_SET(SCU694, 21));
PIN_DECL_3(E20, GPIOG5, RXD8, SD2DAT3, SALT14);
GROUP_DECL(SALT14G0, E20);

FUNC_GROUP_DECL(UART8, A21, E20);

#define D21 54
SIG_EXPR_LIST_DECL_SESG(D21, TXD9, UART9, SIG_DESC_SET(SCU414, 22));
SIG_EXPR_LIST_DECL_SESG(D21, SD2CD, SD2, SIG_DESC_SET(SCU4B4, 22),
			  SIG_DESC_SET(SCU450, 1));
SIG_EXPR_LIST_DECL_SEMG(D21, SALT15, SALT15G0, SALT15,
			SIG_DESC_SET(SCU694, 22));
PIN_DECL_3(D21, GPIOG6, TXD9, SD2CD, SALT15);
GROUP_DECL(SALT15G0, D21);

#define B21 55
SIG_EXPR_LIST_DECL_SESG(B21, RXD9, UART9, SIG_DESC_SET(SCU414, 23));
SIG_EXPR_LIST_DECL_SESG(B21, SD2WP, SD2, SIG_DESC_SET(SCU4B4, 23),
			SIG_DESC_SET(SCU450, 1));
SIG_EXPR_LIST_DECL_SEMG(B21, SALT16, SALT16G0, SALT16,
			SIG_DESC_SET(SCU694, 23));
PIN_DECL_3(B21, GPIOG7, RXD9, SD2WP, SALT16);
GROUP_DECL(SALT16G0, B21);

FUNC_GROUP_DECL(UART9, D21, B21);

FUNC_GROUP_DECL(SD2, E21, B22, C21, A22, A21, E20, D21, B21);

#define A18 56
SIG_EXPR_LIST_DECL_SESG(A18, SGPM1CLK, SGPM1, SIG_DESC_SET(SCU414, 24));
PIN_DECL_1(A18, GPIOH0, SGPM1CLK);

#define B18 57
SIG_EXPR_LIST_DECL_SESG(B18, SGPM1LD, SGPM1, SIG_DESC_SET(SCU414, 25));
PIN_DECL_1(B18, GPIOH1, SGPM1LD);

#define C18 58
SIG_EXPR_LIST_DECL_SESG(C18, SGPM1O, SGPM1, SIG_DESC_SET(SCU414, 26));
PIN_DECL_1(C18, GPIOH2, SGPM1O);

#define A17 59
SIG_EXPR_LIST_DECL_SESG(A17, SGPM1I, SGPM1, SIG_DESC_SET(SCU414, 27));
PIN_DECL_1(A17, GPIOH3, SGPM1I);

FUNC_GROUP_DECL(SGPM1, A18, B18, C18, A17);

#define D18 60
SIG_EXPR_LIST_DECL_SESG(D18, SGPS1CK, SGPS1, SIG_DESC_SET(SCU414, 28));
SIG_EXPR_LIST_DECL_SESG(D18, SCL15, I2C15, SIG_DESC_SET(SCU4B4, 28));
PIN_DECL_2(D18, GPIOH4, SGPS1CK, SCL15);

#define B17 61
SIG_EXPR_LIST_DECL_SESG(B17, SGPS1LD, SGPS1, SIG_DESC_SET(SCU414, 29));
SIG_EXPR_LIST_DECL_SESG(B17, SDA15, I2C15, SIG_DESC_SET(SCU4B4, 29));
PIN_DECL_2(B17, GPIOH5, SGPS1LD, SDA15);

FUNC_GROUP_DECL(I2C15, D18, B17);

#define C17 62
SIG_EXPR_LIST_DECL_SESG(C17, SGPS1O, SGPS1, SIG_DESC_SET(SCU414, 30));
SIG_EXPR_LIST_DECL_SESG(C17, SCL16, I2C16, SIG_DESC_SET(SCU4B4, 30));
PIN_DECL_2(C17, GPIOH6, SGPS1O, SCL16);

#define E18 63
SIG_EXPR_LIST_DECL_SESG(E18, SGPS1I, SGPS1, SIG_DESC_SET(SCU414, 31));
SIG_EXPR_LIST_DECL_SESG(E18, SDA16, I2C16, SIG_DESC_SET(SCU4B4, 31));
PIN_DECL_2(E18, GPIOH7, SGPS1I, SDA16);

FUNC_GROUP_DECL(I2C16, C17, E18);
FUNC_GROUP_DECL(SGPS1, D18, B17, C17, E18);

#define D17 64
SIG_EXPR_LIST_DECL_SESG(D17, MTRSTN, JTAGM, SIG_DESC_SET(SCU418, 0));
SIG_EXPR_LIST_DECL_SEMG(D17, TXD12, UART12G0, UART12, SIG_DESC_SET(SCU4B8, 0));
PIN_DECL_2(D17, GPIOI0, MTRSTN, TXD12);

#define A16 65
SIG_EXPR_LIST_DECL_SESG(A16, MTDI, JTAGM, SIG_DESC_SET(SCU418, 1));
SIG_EXPR_LIST_DECL_SEMG(A16, RXD12, UART12G0, UART12, SIG_DESC_SET(SCU4B8, 1));
PIN_DECL_2(A16, GPIOI1, MTDI, RXD12);

GROUP_DECL(UART12G0, D17, A16);

#define E17 66
SIG_EXPR_LIST_DECL_SESG(E17, MTCK, JTAGM, SIG_DESC_SET(SCU418, 2));
SIG_EXPR_LIST_DECL_SEMG(E17, TXD13, UART13G0, UART13, SIG_DESC_SET(SCU4B8, 2));
PIN_DECL_2(E17, GPIOI2, MTCK, TXD13);

#define D16 67
SIG_EXPR_LIST_DECL_SESG(D16, MTMS, JTAGM, SIG_DESC_SET(SCU418, 3));
SIG_EXPR_LIST_DECL_SEMG(D16, RXD13, UART13G0, UART13, SIG_DESC_SET(SCU4B8, 3));
PIN_DECL_2(D16, GPIOI3, MTMS, RXD13);

GROUP_DECL(UART13G0, E17, D16);

#define C16 68
SIG_EXPR_LIST_DECL_SESG(C16, MTDO, JTAGM, SIG_DESC_SET(SCU418, 4));
PIN_DECL_1(C16, GPIOI4, MTDO);

FUNC_GROUP_DECL(JTAGM, D17, A16, E17, D16, C16);

#define E16 69
SIG_EXPR_LIST_DECL_SESG(E16, SIOPBO, SIOPBO, SIG_DESC_SET(SCU418, 5));
PIN_DECL_1(E16, GPIOI5, SIOPBO);
FUNC_GROUP_DECL(SIOPBO, E16);

#define B16 70
SIG_EXPR_LIST_DECL_SESG(B16, SIOPBI, SIOPBI, SIG_DESC_SET(SCU418, 6));
PIN_DECL_1(B16, GPIOI6, SIOPBI);
FUNC_GROUP_DECL(SIOPBI, B16);

#define A15 71
SIG_EXPR_LIST_DECL_SESG(A15, BMCINT, BMCINT, SIG_DESC_SET(SCU418, 7));
SIG_EXPR_LIST_DECL_SESG(A15, SIOSCI, SIOSCI, SIG_DESC_SET(SCU4B8, 7));
PIN_DECL_2(A15, GPIOI7, BMCINT, SIOSCI);
FUNC_GROUP_DECL(BMCINT, A15);
FUNC_GROUP_DECL(SIOSCI, A15);

#define B20 72
SIG_EXPR_LIST_DECL_SEMG(B20, I3C3SCL, HVI3C3, I3C3, SIG_DESC_SET(SCU418, 8));
SIG_EXPR_LIST_DECL_SESG(B20, SCL1, I2C1, SIG_DESC_SET(SCU4B8, 8));
PIN_DECL_2(B20, GPIOJ0, I3C3SCL, SCL1);

#define A20 73
SIG_EXPR_LIST_DECL_SEMG(A20, I3C3SDA, HVI3C3, I3C3, SIG_DESC_SET(SCU418, 9));
SIG_EXPR_LIST_DECL_SESG(A20, SDA1, I2C1, SIG_DESC_SET(SCU4B8, 9));
PIN_DECL_2(A20, GPIOJ1, I3C3SDA, SDA1);

GROUP_DECL(HVI3C3, B20, A20);
FUNC_GROUP_DECL(I2C1, B20, A20);

#define E19 74
SIG_EXPR_LIST_DECL_SEMG(E19, I3C4SCL, HVI3C4, I3C4, SIG_DESC_SET(SCU418, 10));
SIG_EXPR_LIST_DECL_SESG(E19, SCL2, I2C2, SIG_DESC_SET(SCU4B8, 10));
PIN_DECL_2(E19, GPIOJ2, I3C4SCL, SCL2);

#define D20 75
SIG_EXPR_LIST_DECL_SEMG(D20, I3C4SDA, HVI3C4, I3C4, SIG_DESC_SET(SCU418, 11));
SIG_EXPR_LIST_DECL_SESG(D20, SDA2, I2C2, SIG_DESC_SET(SCU4B8, 11));
PIN_DECL_2(D20, GPIOJ3, I3C4SDA, SDA2);

GROUP_DECL(HVI3C4, E19, D20);
FUNC_GROUP_DECL(I2C2, E19, D20);

#define C19 76
SIG_EXPR_LIST_DECL_SESG(C19, I3C5SCL, I3C5, SIG_DESC_SET(SCU418, 12));
SIG_EXPR_LIST_DECL_SESG(C19, SCL3, I2C3, SIG_DESC_SET(SCU4B8, 12));
PIN_DECL_2(C19, GPIOJ4, I3C5SCL, SCL3);

#define A19 77
SIG_EXPR_LIST_DECL_SESG(A19, I3C5SDA, I3C5, SIG_DESC_SET(SCU418, 13));
SIG_EXPR_LIST_DECL_SESG(A19, SDA3, I2C3, SIG_DESC_SET(SCU4B8, 13));
PIN_DECL_2(A19, GPIOJ5, I3C5SDA, SDA3);

FUNC_GROUP_DECL(I3C5, C19, A19);
FUNC_GROUP_DECL(I2C3, C19, A19);

#define C20 78
SIG_EXPR_LIST_DECL_SESG(C20, I3C6SCL, I3C6, SIG_DESC_SET(SCU418, 14));
SIG_EXPR_LIST_DECL_SESG(C20, SCL4, I2C4, SIG_DESC_SET(SCU4B8, 14));
PIN_DECL_2(C20, GPIOJ6, I3C6SCL, SCL4);

#define D19 79
SIG_EXPR_LIST_DECL_SESG(D19, I3C6SDA, I3C6, SIG_DESC_SET(SCU418, 15));
SIG_EXPR_LIST_DECL_SESG(D19, SDA4, I2C4, SIG_DESC_SET(SCU4B8, 15));
PIN_DECL_2(D19, GPIOJ7, I3C6SDA, SDA4);

FUNC_GROUP_DECL(I3C6, C20, D19);
FUNC_GROUP_DECL(I2C4, C20, D19);

#define A11 80
SIG_EXPR_LIST_DECL_SESG(A11, SCL5, I2C5, SIG_DESC_SET(SCU418, 16));
PIN_DECL_1(A11, GPIOK0, SCL5);

#define C11 81
SIG_EXPR_LIST_DECL_SESG(C11, SDA5, I2C5, SIG_DESC_SET(SCU418, 17));
PIN_DECL_1(C11, GPIOK1, SDA5);

FUNC_GROUP_DECL(I2C5, A11, C11);

#define D12 82
SIG_EXPR_LIST_DECL_SESG(D12, SCL6, I2C6, SIG_DESC_SET(SCU418, 18));
PIN_DECL_1(D12, GPIOK2, SCL6);

#define E13 83
SIG_EXPR_LIST_DECL_SESG(E13, SDA6, I2C6, SIG_DESC_SET(SCU418, 19));
PIN_DECL_1(E13, GPIOK3, SDA6);

FUNC_GROUP_DECL(I2C6, D12, E13);

#define D11 84
SIG_EXPR_LIST_DECL_SESG(D11, SCL7, I2C7, SIG_DESC_SET(SCU418, 20));
PIN_DECL_1(D11, GPIOK4, SCL7);

#define E11 85
SIG_EXPR_LIST_DECL_SESG(E11, SDA7, I2C7, SIG_DESC_SET(SCU418, 21));
PIN_DECL_1(E11, GPIOK5, SDA7);

FUNC_GROUP_DECL(I2C7, D11, E11);

#define F13 86
SIG_EXPR_LIST_DECL_SESG(F13, SCL8, I2C8, SIG_DESC_SET(SCU418, 22));
PIN_DECL_1(F13, GPIOK6, SCL8);

#define E12 87
SIG_EXPR_LIST_DECL_SESG(E12, SDA8, I2C8, SIG_DESC_SET(SCU418, 23));
PIN_DECL_1(E12, GPIOK7, SDA8);

FUNC_GROUP_DECL(I2C8, F13, E12);

#define D15 88
SIG_EXPR_LIST_DECL_SESG(D15, SCL9, I2C9, SIG_DESC_SET(SCU418, 24));
PIN_DECL_1(D15, GPIOL0, SCL9);

#define A14 89
SIG_EXPR_LIST_DECL_SESG(A14, SDA9, I2C9, SIG_DESC_SET(SCU418, 25));
PIN_DECL_1(A14, GPIOL1, SDA9);

FUNC_GROUP_DECL(I2C9, D15, A14);

#define E15 90
SIG_EXPR_LIST_DECL_SESG(E15, SCL10, I2C10, SIG_DESC_SET(SCU418, 26));
PIN_DECL_1(E15, GPIOL2, SCL10);

#define A13 91
SIG_EXPR_LIST_DECL_SESG(A13, SDA10, I2C10, SIG_DESC_SET(SCU418, 27));
PIN_DECL_1(A13, GPIOL3, SDA10);

FUNC_GROUP_DECL(I2C10, E15, A13);

#define C15 92
SSSF_PIN_DECL(C15, GPIOL4, TXD3, SIG_DESC_SET(SCU418, 28));

#define F15 93
SSSF_PIN_DECL(F15, GPIOL5, RXD3, SIG_DESC_SET(SCU418, 29));

#define B14 94
SSSF_PIN_DECL(B14, GPIOL6, VGAHS, SIG_DESC_SET(SCU418, 30));

#define C14 95
SSSF_PIN_DECL(C14, GPIOL7, VGAVS, SIG_DESC_SET(SCU418, 31));

#define D14 96
SSSF_PIN_DECL(D14, GPIOM0, NCTS1, SIG_DESC_SET(SCU41C, 0));

#define B13 97
SSSF_PIN_DECL(B13, GPIOM1, NDCD1, SIG_DESC_SET(SCU41C, 1));

#define A12 98
SSSF_PIN_DECL(A12, GPIOM2, NDSR1, SIG_DESC_SET(SCU41C, 2));

#define E14 99
SSSF_PIN_DECL(E14, GPIOM3, NRI1, SIG_DESC_SET(SCU41C, 3));

#define B12 100
SSSF_PIN_DECL(B12, GPIOM4, NDTR1, SIG_DESC_SET(SCU41C, 4));

#define C12 101
SSSF_PIN_DECL(C12, GPIOM5, NRTS1, SIG_DESC_SET(SCU41C, 5));

#define C13 102
SSSF_PIN_DECL(C13, GPIOM6, TXD1, SIG_DESC_SET(SCU41C, 6));

#define D13 103
SSSF_PIN_DECL(D13, GPIOM7, RXD1, SIG_DESC_SET(SCU41C, 7));

#define P25 104
SSSF_PIN_DECL(P25, GPION0, NCTS2, SIG_DESC_SET(SCU41C, 8));

#define N23 105
SSSF_PIN_DECL(N23, GPION1, NDCD2, SIG_DESC_SET(SCU41C, 9));

#define N25 106
SSSF_PIN_DECL(N25, GPION2, NDSR2, SIG_DESC_SET(SCU41C, 10));

#define N24 107
SSSF_PIN_DECL(N24, GPION3, NRI2, SIG_DESC_SET(SCU41C, 11));

#define P26 108
SSSF_PIN_DECL(P26, GPION4, NDTR2, SIG_DESC_SET(SCU41C, 12));

#define M23 109
SSSF_PIN_DECL(M23, GPION5, NRTS2, SIG_DESC_SET(SCU41C, 13));

#define N26 110
SSSF_PIN_DECL(N26, GPION6, TXD2, SIG_DESC_SET(SCU41C, 14));

#define M26 111
SSSF_PIN_DECL(M26, GPION7, RXD2, SIG_DESC_SET(SCU41C, 15));

#define AD26 112
SSSF_PIN_DECL(AD26, GPIOO0, PWM0, SIG_DESC_SET(SCU41C, 16));

#define AD22 113
SSSF_PIN_DECL(AD22, GPIOO1, PWM1, SIG_DESC_SET(SCU41C, 17));

#define AD23 114
SSSF_PIN_DECL(AD23, GPIOO2, PWM2, SIG_DESC_SET(SCU41C, 18));

#define AD24 115
SSSF_PIN_DECL(AD24, GPIOO3, PWM3, SIG_DESC_SET(SCU41C, 19));

#define AD25 116
SSSF_PIN_DECL(AD25, GPIOO4, PWM4, SIG_DESC_SET(SCU41C, 20));

#define AC22 117
SSSF_PIN_DECL(AC22, GPIOO5, PWM5, SIG_DESC_SET(SCU41C, 21));

#define AC24 118
SSSF_PIN_DECL(AC24, GPIOO6, PWM6, SIG_DESC_SET(SCU41C, 22));

#define AC23 119
SSSF_PIN_DECL(AC23, GPIOO7, PWM7, SIG_DESC_SET(SCU41C, 23));

#define AB22 120
SIG_EXPR_LIST_DECL_SEMG(AB22, PWM8, PWM8G1, PWM8, SIG_DESC_SET(SCU41C, 24));
SIG_EXPR_LIST_DECL_SESG(AB22, THRUIN0, THRU0, SIG_DESC_SET(SCU4BC, 24));
PIN_DECL_2(AB22, GPIOP0, PWM8, THRUIN0);
GROUP_DECL(PWM8G1, AB22);
FUNC_DECL_2(PWM8, PWM8G0, PWM8G1);

#define W24 121
SIG_EXPR_LIST_DECL_SEMG(W24, PWM9, PWM9G1, PWM9, SIG_DESC_SET(SCU41C, 25));
SIG_EXPR_LIST_DECL_SESG(W24, THRUOUT0, THRU0, SIG_DESC_SET(SCU4BC, 25));
PIN_DECL_2(W24, GPIOP1, PWM9, THRUOUT0);

FUNC_GROUP_DECL(THRU0, AB22, W24);

GROUP_DECL(PWM9G1, W24);
FUNC_DECL_2(PWM9, PWM9G0, PWM9G1);

#define AA23 122
SIG_EXPR_LIST_DECL_SEMG(AA23, PWM10, PWM10G1, PWM10, SIG_DESC_SET(SCU41C, 26));
SIG_EXPR_LIST_DECL_SESG(AA23, THRUIN1, THRU1, SIG_DESC_SET(SCU4BC, 26));
PIN_DECL_2(AA23, GPIOP2, PWM10, THRUIN1);
GROUP_DECL(PWM10G1, AA23);
FUNC_DECL_2(PWM10, PWM10G0, PWM10G1);

#define AA24 123
SIG_EXPR_LIST_DECL_SEMG(AA24, PWM11, PWM11G1, PWM11, SIG_DESC_SET(SCU41C, 27));
SIG_EXPR_LIST_DECL_SESG(AA24, THRUOUT1, THRU1, SIG_DESC_SET(SCU4BC, 27));
PIN_DECL_2(AA24, GPIOP3, PWM11, THRUOUT1);
GROUP_DECL(PWM11G1, AA24);
FUNC_DECL_2(PWM11, PWM11G0, PWM11G1);

FUNC_GROUP_DECL(THRU1, AA23, AA24);

#define W23 124
SIG_EXPR_LIST_DECL_SEMG(W23, PWM12, PWM12G1, PWM12, SIG_DESC_SET(SCU41C, 28));
SIG_EXPR_LIST_DECL_SESG(W23, THRUIN2, THRU2, SIG_DESC_SET(SCU4BC, 28));
PIN_DECL_2(W23, GPIOP4, PWM12, THRUIN2);
GROUP_DECL(PWM12G1, W23);
FUNC_DECL_2(PWM12, PWM12G0, PWM12G1);

#define AB23 125
SIG_EXPR_LIST_DECL_SEMG(AB23, PWM13, PWM13G1, PWM13, SIG_DESC_SET(SCU41C, 29));
SIG_EXPR_LIST_DECL_SESG(AB23, THRUOUT2, THRU2, SIG_DESC_SET(SCU4BC, 29));
PIN_DECL_2(AB23, GPIOP5, PWM13, THRUOUT2);
GROUP_DECL(PWM13G1, AB23);
FUNC_DECL_2(PWM13, PWM13G0, PWM13G1);

FUNC_GROUP_DECL(THRU2, W23, AB23);

#define AB24 126
SIG_EXPR_LIST_DECL_SEMG(AB24, PWM14, PWM14G1, PWM14, SIG_DESC_SET(SCU41C, 30));
SIG_EXPR_LIST_DECL_SESG(AB24, THRUIN3, THRU3, SIG_DESC_SET(SCU4BC, 30));
PIN_DECL_2(AB24, GPIOP6, PWM14, THRUIN3);
GROUP_DECL(PWM14G1, AB24);
FUNC_DECL_2(PWM14, PWM14G0, PWM14G1);

#define Y23 127
SIG_EXPR_LIST_DECL_SEMG(Y23, PWM15, PWM15G1, PWM15, SIG_DESC_SET(SCU41C, 31));
SIG_EXPR_LIST_DECL_SESG(Y23, THRUOUT3, THRU3, SIG_DESC_SET(SCU4BC, 31));
PIN_DECL_2(Y23, GPIOP7, PWM15, THRUOUT3);
GROUP_DECL(PWM15G1, Y23);
FUNC_DECL_2(PWM15, PWM15G0, PWM15G1);

FUNC_GROUP_DECL(THRU3, AB24, Y23);

#define AA25 128
SSSF_PIN_DECL(AA25, GPIOQ0, TACH0, SIG_DESC_SET(SCU430, 0));

#define AB25 129
SSSF_PIN_DECL(AB25, GPIOQ1, TACH1, SIG_DESC_SET(SCU430, 1));

#define Y24 130
SSSF_PIN_DECL(Y24, GPIOQ2, TACH2, SIG_DESC_SET(SCU430, 2));

#define AB26 131
SSSF_PIN_DECL(AB26, GPIOQ3, TACH3, SIG_DESC_SET(SCU430, 3));

#define Y26 132
SSSF_PIN_DECL(Y26, GPIOQ4, TACH4, SIG_DESC_SET(SCU430, 4));

#define AC26 133
SSSF_PIN_DECL(AC26, GPIOQ5, TACH5, SIG_DESC_SET(SCU430, 5));

#define Y25 134
SSSF_PIN_DECL(Y25, GPIOQ6, TACH6, SIG_DESC_SET(SCU430, 6));

#define AA26 135
SSSF_PIN_DECL(AA26, GPIOQ7, TACH7, SIG_DESC_SET(SCU430, 7));

#define V25 136
SSSF_PIN_DECL(V25, GPIOR0, TACH8, SIG_DESC_SET(SCU430, 8));

#define U24 137
SSSF_PIN_DECL(U24, GPIOR1, TACH9, SIG_DESC_SET(SCU430, 9));

#define V24 138
SSSF_PIN_DECL(V24, GPIOR2, TACH10, SIG_DESC_SET(SCU430, 10));

#define V26 139
SSSF_PIN_DECL(V26, GPIOR3, TACH11, SIG_DESC_SET(SCU430, 11));

#define U25 140
SSSF_PIN_DECL(U25, GPIOR4, TACH12, SIG_DESC_SET(SCU430, 12));

#define T23 141
SSSF_PIN_DECL(T23, GPIOR5, TACH13, SIG_DESC_SET(SCU430, 13));

#define W26 142
SSSF_PIN_DECL(W26, GPIOR6, TACH14, SIG_DESC_SET(SCU430, 14));

#define U26 143
SSSF_PIN_DECL(U26, GPIOR7, TACH15, SIG_DESC_SET(SCU430, 15));

#define R23 144
SIG_EXPR_LIST_DECL_SESG(R23, MDC1, MDIO1, SIG_DESC_SET(SCU430, 16));
PIN_DECL_1(R23, GPIOS0, MDC1);

#define T25 145
SIG_EXPR_LIST_DECL_SESG(T25, MDIO1, MDIO1, SIG_DESC_SET(SCU430, 17));
PIN_DECL_1(T25, GPIOS1, MDIO1);

FUNC_GROUP_DECL(MDIO1, R23, T25);

#define T26 146
SSSF_PIN_DECL(T26, GPIOS2, PEWAKE, SIG_DESC_SET(SCU430, 18));

#define R24 147
SSSF_PIN_DECL(R24, GPIOS3, OSCCLK, SIG_DESC_SET(SCU430, 19));

#define R26 148
SIG_EXPR_LIST_DECL_SESG(R26, TXD10, UART10, SIG_DESC_SET(SCU430, 20));
PIN_DECL_1(R26, GPIOS4, TXD10);

#define P24 149
SIG_EXPR_LIST_DECL_SESG(P24, RXD10, UART10, SIG_DESC_SET(SCU430, 21));
PIN_DECL_1(P24, GPIOS5, RXD10);

FUNC_GROUP_DECL(UART10, R26, P24);

#define P23 150
SIG_EXPR_LIST_DECL_SESG(P23, TXD11, UART11, SIG_DESC_SET(SCU430, 22));
PIN_DECL_1(P23, GPIOS6, TXD11);

#define T24 151
SIG_EXPR_LIST_DECL_SESG(T24, RXD11, UART11, SIG_DESC_SET(SCU430, 23));
PIN_DECL_1(T24, GPIOS7, RXD11);

FUNC_GROUP_DECL(UART11, P23, T24);

#define AD20 152
SIG_EXPR_LIST_DECL_SESG(AD20, GPIT0, GPIT0, SIG_DESC_SET(SCU430, 24));
SIG_EXPR_LIST_DECL_SESG(AD20, ADC0, ADC0);
PIN_DECL_(AD20, SIG_EXPR_LIST_PTR(AD20, GPIT0), SIG_EXPR_LIST_PTR(AD20, ADC0));
FUNC_GROUP_DECL(GPIT0, AD20);
FUNC_GROUP_DECL(ADC0, AD20);

#define AC18 153
SIG_EXPR_LIST_DECL_SESG(AC18, GPIT1, GPIT1, SIG_DESC_SET(SCU430, 25));
SIG_EXPR_LIST_DECL_SESG(AC18, ADC1, ADC1);
PIN_DECL_(AC18, SIG_EXPR_LIST_PTR(AC18, GPIT1), SIG_EXPR_LIST_PTR(AC18, ADC1));
FUNC_GROUP_DECL(GPIT1, AC18);
FUNC_GROUP_DECL(ADC1, AC18);

#define AE19 154
SIG_EXPR_LIST_DECL_SESG(AE19, GPIT2, GPIT2, SIG_DESC_SET(SCU430, 26));
SIG_EXPR_LIST_DECL_SESG(AE19, ADC2, ADC2);
PIN_DECL_(AE19, SIG_EXPR_LIST_PTR(AE19, GPIT2), SIG_EXPR_LIST_PTR(AE19, ADC2));
FUNC_GROUP_DECL(GPIT2, AE19);
FUNC_GROUP_DECL(ADC2, AE19);

#define AD19 155
SIG_EXPR_LIST_DECL_SESG(AD19, GPIT3, GPIT3, SIG_DESC_SET(SCU430, 27));
SIG_EXPR_LIST_DECL_SESG(AD19, ADC3, ADC3);
PIN_DECL_(AD19, SIG_EXPR_LIST_PTR(AD19, GPIT3), SIG_EXPR_LIST_PTR(AD19, ADC3));
FUNC_GROUP_DECL(GPIT3, AD19);
FUNC_GROUP_DECL(ADC3, AD19);

#define AC19 156
SIG_EXPR_LIST_DECL_SESG(AC19, GPIT4, GPIT4, SIG_DESC_SET(SCU430, 28));
SIG_EXPR_LIST_DECL_SESG(AC19, ADC4, ADC4);
PIN_DECL_(AC19, SIG_EXPR_LIST_PTR(AC19, GPIT4), SIG_EXPR_LIST_PTR(AC19, ADC4));
FUNC_GROUP_DECL(GPIT4, AC19);
FUNC_GROUP_DECL(ADC4, AC19);

#define AB19 157
SIG_EXPR_LIST_DECL_SESG(AB19, GPIT5, GPIT5, SIG_DESC_SET(SCU430, 29));
SIG_EXPR_LIST_DECL_SESG(AB19, ADC5, ADC5);
PIN_DECL_(AB19, SIG_EXPR_LIST_PTR(AB19, GPIT5), SIG_EXPR_LIST_PTR(AB19, ADC5));
FUNC_GROUP_DECL(GPIT5, AB19);
FUNC_GROUP_DECL(ADC5, AB19);

#define AB18 158
SIG_EXPR_LIST_DECL_SESG(AB18, GPIT6, GPIT6, SIG_DESC_SET(SCU430, 30));
SIG_EXPR_LIST_DECL_SESG(AB18, ADC6, ADC6);
PIN_DECL_(AB18, SIG_EXPR_LIST_PTR(AB18, GPIT6), SIG_EXPR_LIST_PTR(AB18, ADC6));
FUNC_GROUP_DECL(GPIT6, AB18);
FUNC_GROUP_DECL(ADC6, AB18);

#define AE18 159
SIG_EXPR_LIST_DECL_SESG(AE18, GPIT7, GPIT7, SIG_DESC_SET(SCU430, 31));
SIG_EXPR_LIST_DECL_SESG(AE18, ADC7, ADC7);
PIN_DECL_(AE18, SIG_EXPR_LIST_PTR(AE18, GPIT7), SIG_EXPR_LIST_PTR(AE18, ADC7));
FUNC_GROUP_DECL(GPIT7, AE18);
FUNC_GROUP_DECL(ADC7, AE18);

#define AB16 160
SIG_EXPR_LIST_DECL_SEMG(AB16, SALT9, SALT9G1, SALT9, SIG_DESC_SET(SCU434, 0),
			SIG_DESC_CLEAR(SCU694, 16));
SIG_EXPR_LIST_DECL_SESG(AB16, GPIU0, GPIU0, SIG_DESC_SET(SCU434, 0),
			SIG_DESC_SET(SCU694, 16));
SIG_EXPR_LIST_DECL_SESG(AB16, ADC8, ADC8);
PIN_DECL_(AB16, SIG_EXPR_LIST_PTR(AB16, SALT9), SIG_EXPR_LIST_PTR(AB16, GPIU0),
	  SIG_EXPR_LIST_PTR(AB16, ADC8));
GROUP_DECL(SALT9G1, AB16);
FUNC_DECL_2(SALT9, SALT9G0, SALT9G1);
FUNC_GROUP_DECL(GPIU0, AB16);
FUNC_GROUP_DECL(ADC8, AB16);

#define AA17 161
SIG_EXPR_LIST_DECL_SEMG(AA17, SALT10, SALT10G1, SALT10, SIG_DESC_SET(SCU434, 1),
			SIG_DESC_CLEAR(SCU694, 17));
SIG_EXPR_LIST_DECL_SESG(AA17, GPIU1, GPIU1, SIG_DESC_SET(SCU434, 1),
			SIG_DESC_SET(SCU694, 17));
SIG_EXPR_LIST_DECL_SESG(AA17, ADC9, ADC9);
PIN_DECL_(AA17, SIG_EXPR_LIST_PTR(AA17, SALT10), SIG_EXPR_LIST_PTR(AA17, GPIU1),
	  SIG_EXPR_LIST_PTR(AA17, ADC9));
GROUP_DECL(SALT10G1, AA17);
FUNC_DECL_2(SALT10, SALT10G0, SALT10G1);
FUNC_GROUP_DECL(GPIU1, AA17);
FUNC_GROUP_DECL(ADC9, AA17);

#define AB17 162
SIG_EXPR_LIST_DECL_SEMG(AB17, SALT11, SALT11G1, SALT11, SIG_DESC_SET(SCU434, 2),
			SIG_DESC_CLEAR(SCU694, 18));
SIG_EXPR_LIST_DECL_SESG(AB17, GPIU2, GPIU2, SIG_DESC_SET(SCU434, 2),
			SIG_DESC_SET(SCU694, 18));
SIG_EXPR_LIST_DECL_SESG(AB17, ADC10, ADC10);
PIN_DECL_(AB17, SIG_EXPR_LIST_PTR(AB17, SALT11), SIG_EXPR_LIST_PTR(AB17, GPIU2),
	  SIG_EXPR_LIST_PTR(AB17, ADC10));
GROUP_DECL(SALT11G1, AB17);
FUNC_DECL_2(SALT11, SALT11G0, SALT11G1);
FUNC_GROUP_DECL(GPIU2, AB17);
FUNC_GROUP_DECL(ADC10, AB17);

#define AE16 163
SIG_EXPR_LIST_DECL_SEMG(AE16, SALT12, SALT12G1, SALT12, SIG_DESC_SET(SCU434, 3),
			SIG_DESC_CLEAR(SCU694, 19));
SIG_EXPR_LIST_DECL_SESG(AE16, GPIU3, GPIU3, SIG_DESC_SET(SCU434, 3),
			SIG_DESC_SET(SCU694, 19));
SIG_EXPR_LIST_DECL_SESG(AE16, ADC11, ADC11);
PIN_DECL_(AE16, SIG_EXPR_LIST_PTR(AE16, SALT12), SIG_EXPR_LIST_PTR(AE16, GPIU3),
	  SIG_EXPR_LIST_PTR(AE16, ADC11));
GROUP_DECL(SALT12G1, AE16);
FUNC_DECL_2(SALT12, SALT12G0, SALT12G1);
FUNC_GROUP_DECL(GPIU3, AE16);
FUNC_GROUP_DECL(ADC11, AE16);

#define AC16 164
SIG_EXPR_LIST_DECL_SEMG(AC16, SALT13, SALT13G1, SALT13, SIG_DESC_SET(SCU434, 4),
			SIG_DESC_CLEAR(SCU694, 20));
SIG_EXPR_LIST_DECL_SESG(AC16, GPIU4, GPIU4, SIG_DESC_SET(SCU434, 4),
			SIG_DESC_SET(SCU694, 20));
SIG_EXPR_LIST_DECL_SESG(AC16, ADC12, ADC12);
PIN_DECL_(AC16, SIG_EXPR_LIST_PTR(AC16, SALT13), SIG_EXPR_LIST_PTR(AC16, GPIU4),
	  SIG_EXPR_LIST_PTR(AC16, ADC12));
GROUP_DECL(SALT13G1, AC16);
FUNC_DECL_2(SALT13, SALT13G0, SALT13G1);
FUNC_GROUP_DECL(GPIU4, AC16);
FUNC_GROUP_DECL(ADC12, AC16);

#define AA16 165
SIG_EXPR_LIST_DECL_SEMG(AA16, SALT14, SALT14G1, SALT14, SIG_DESC_SET(SCU434, 5),
			SIG_DESC_CLEAR(SCU694, 21));
SIG_EXPR_LIST_DECL_SESG(AA16, GPIU5, GPIU5, SIG_DESC_SET(SCU434, 5),
			SIG_DESC_SET(SCU694, 21));
SIG_EXPR_LIST_DECL_SESG(AA16, ADC13, ADC13);
PIN_DECL_(AA16, SIG_EXPR_LIST_PTR(AA16, SALT14), SIG_EXPR_LIST_PTR(AA16, GPIU5),
	  SIG_EXPR_LIST_PTR(AA16, ADC13));
GROUP_DECL(SALT14G1, AA16);
FUNC_DECL_2(SALT14, SALT14G0, SALT14G1);
FUNC_GROUP_DECL(GPIU5, AA16);
FUNC_GROUP_DECL(ADC13, AA16);

#define AD16 166
SIG_EXPR_LIST_DECL_SEMG(AD16, SALT15, SALT15G1, SALT15, SIG_DESC_SET(SCU434, 6),
			SIG_DESC_CLEAR(SCU694, 22));
SIG_EXPR_LIST_DECL_SESG(AD16, GPIU6, GPIU6, SIG_DESC_SET(SCU434, 6),
			SIG_DESC_SET(SCU694, 22));
SIG_EXPR_LIST_DECL_SESG(AD16, ADC14, ADC14);
PIN_DECL_(AD16, SIG_EXPR_LIST_PTR(AD16, SALT15), SIG_EXPR_LIST_PTR(AD16, GPIU6),
	  SIG_EXPR_LIST_PTR(AD16, ADC14));
GROUP_DECL(SALT15G1, AD16);
FUNC_DECL_2(SALT15, SALT15G0, SALT15G1);
FUNC_GROUP_DECL(GPIU6, AD16);
FUNC_GROUP_DECL(ADC14, AD16);

#define AC17 167
SIG_EXPR_LIST_DECL_SEMG(AC17, SALT16, SALT16G1, SALT16, SIG_DESC_SET(SCU434, 7),
			SIG_DESC_CLEAR(SCU694, 23));
SIG_EXPR_LIST_DECL_SESG(AC17, GPIU7, GPIU7, SIG_DESC_SET(SCU434, 7),
			SIG_DESC_SET(SCU694, 23));
SIG_EXPR_LIST_DECL_SESG(AC17, ADC15, ADC15);
PIN_DECL_(AC17, SIG_EXPR_LIST_PTR(AC17, SALT16), SIG_EXPR_LIST_PTR(AC17, GPIU7),
	  SIG_EXPR_LIST_PTR(AC17, ADC15));
GROUP_DECL(SALT16G1, AC17);
FUNC_DECL_2(SALT16, SALT16G0, SALT16G1);
FUNC_GROUP_DECL(GPIU7, AC17);
FUNC_GROUP_DECL(ADC15, AC17);

#define AB15 168
SSSF_PIN_DECL(AB15, GPIOV0, SIOS3, SIG_DESC_SET(SCU434, 8));

#define AF14 169
SSSF_PIN_DECL(AF14, GPIOV1, SIOS5, SIG_DESC_SET(SCU434, 9));

#define AD14 170
SSSF_PIN_DECL(AD14, GPIOV2, SIOPWREQ, SIG_DESC_SET(SCU434, 10));

#define AC15 171
SSSF_PIN_DECL(AC15, GPIOV3, SIOONCTRL, SIG_DESC_SET(SCU434, 11));

#define AE15 172
SSSF_PIN_DECL(AE15, GPIOV4, SIOPWRGD, SIG_DESC_SET(SCU434, 12));

#define AE14 173
SIG_EXPR_LIST_DECL_SESG(AE14, LPCPD, LPCPD, SIG_DESC_SET(SCU434, 13));
SIG_EXPR_LIST_DECL_SESG(AE14, LHPD, LHPD, SIG_DESC_SET(SCU4D4, 13));
PIN_DECL_2(AE14, GPIOV5, LPCPD, LHPD);
FUNC_GROUP_DECL(LPCPD, AE14);
FUNC_GROUP_DECL(LHPD, AE14);

#define AD15 174
SSSF_PIN_DECL(AD15, GPIOV6, LPCPME, SIG_DESC_SET(SCU434, 14));

#define AF15 175
SSSF_PIN_DECL(AF15, GPIOV7, LPCSMI, SIG_DESC_SET(SCU434, 15));

#define AB7 176
SIG_EXPR_LIST_DECL_SESG(AB7, LAD0, LPC, SIG_DESC_SET(SCU434, 16),
			  SIG_DESC_SET(SCU510, 6));
SIG_EXPR_LIST_DECL_SESG(AB7, ESPID0, ESPI, SIG_DESC_SET(SCU434, 16));
PIN_DECL_2(AB7, GPIOW0, LAD0, ESPID0);

#define AB8 177
SIG_EXPR_LIST_DECL_SESG(AB8, LAD1, LPC, SIG_DESC_SET(SCU434, 17),
			  SIG_DESC_SET(SCU510, 6));
SIG_EXPR_LIST_DECL_SESG(AB8, ESPID1, ESPI, SIG_DESC_SET(SCU434, 17));
PIN_DECL_2(AB8, GPIOW1, LAD1, ESPID1);

#define AC8 178
SIG_EXPR_LIST_DECL_SESG(AC8, LAD2, LPC, SIG_DESC_SET(SCU434, 18),
			  SIG_DESC_SET(SCU510, 6));
SIG_EXPR_LIST_DECL_SESG(AC8, ESPID2, ESPI, SIG_DESC_SET(SCU434, 18));
PIN_DECL_2(AC8, GPIOW2, LAD2, ESPID2);

#define AC7 179
SIG_EXPR_LIST_DECL_SESG(AC7, LAD3, LPC, SIG_DESC_SET(SCU434, 19),
			  SIG_DESC_SET(SCU510, 6));
SIG_EXPR_LIST_DECL_SESG(AC7, ESPID3, ESPI, SIG_DESC_SET(SCU434, 19));
PIN_DECL_2(AC7, GPIOW3, LAD3, ESPID3);

#define AE7 180
SIG_EXPR_LIST_DECL_SESG(AE7, LCLK, LPC, SIG_DESC_SET(SCU434, 20),
			  SIG_DESC_SET(SCU510, 6));
SIG_EXPR_LIST_DECL_SESG(AE7, ESPICK, ESPI, SIG_DESC_SET(SCU434, 20));
PIN_DECL_2(AE7, GPIOW4, LCLK, ESPICK);

#define AF7 181
SIG_EXPR_LIST_DECL_SESG(AF7, LFRAME, LPC, SIG_DESC_SET(SCU434, 21),
			  SIG_DESC_SET(SCU510, 6));
SIG_EXPR_LIST_DECL_SESG(AF7, ESPICS, ESPI, SIG_DESC_SET(SCU434, 21));
PIN_DECL_2(AF7, GPIOW5, LFRAME, ESPICS);

#define AD7 182
SIG_EXPR_LIST_DECL_SESG(AD7, LSIRQ, LSIRQ, SIG_DESC_SET(SCU434, 22),
			  SIG_DESC_SET(SCU510, 6));
SIG_EXPR_LIST_DECL_SESG(AD7, ESPIALT, ESPIALT, SIG_DESC_SET(SCU434, 22));
PIN_DECL_2(AD7, GPIOW6, LSIRQ, ESPIALT);
FUNC_GROUP_DECL(LSIRQ, AD7);
FUNC_GROUP_DECL(ESPIALT, AD7);

#define AD8 183
SIG_EXPR_LIST_DECL_SESG(AD8, LPCRST, LPC, SIG_DESC_SET(SCU434, 23),
			  SIG_DESC_SET(SCU510, 6));
SIG_EXPR_LIST_DECL_SESG(AD8, ESPIRST, ESPI, SIG_DESC_SET(SCU434, 23));
PIN_DECL_2(AD8, GPIOW7, LPCRST, ESPIRST);

FUNC_GROUP_DECL(LPC, AB7, AB8, AC8, AC7, AE7, AF7, AD8);
FUNC_GROUP_DECL(ESPI, AB7, AB8, AC8, AC7, AE7, AF7, AD8);

#define AE8 184
SIG_EXPR_LIST_DECL_SEMG(AE8, SPI2CS0, SPI2, SPI2, SIG_DESC_SET(SCU434, 24));
PIN_DECL_1(AE8, GPIOX0, SPI2CS0);

#define AA9 185
SSSF_PIN_DECL(AA9, GPIOX1, SPI2CS1, SIG_DESC_SET(SCU434, 25));

#define AC9 186
SSSF_PIN_DECL(AC9, GPIOX2, SPI2CS2, SIG_DESC_SET(SCU434, 26));

#define AF8 187
SIG_EXPR_LIST_DECL_SEMG(AF8, SPI2CK, SPI2, SPI2, SIG_DESC_SET(SCU434, 27));
PIN_DECL_1(AF8, GPIOX3, SPI2CK);

#define AB9 188
SIG_EXPR_LIST_DECL_SEMG(AB9, SPI2MOSI, SPI2, SPI2, SIG_DESC_SET(SCU434, 28));
PIN_DECL_1(AB9, GPIOX4, SPI2MOSI);

#define AD9 189
SIG_EXPR_LIST_DECL_SEMG(AD9, SPI2MISO, SPI2, SPI2, SIG_DESC_SET(SCU434, 29));
PIN_DECL_1(AD9, GPIOX5, SPI2MISO);

GROUP_DECL(SPI2, AE8, AF8, AB9, AD9);

#define AF9 190
SIG_EXPR_LIST_DECL_SEMG(AF9, SPI2DQ2, QSPI2, SPI2, SIG_DESC_SET(SCU434, 30));
SIG_EXPR_LIST_DECL_SEMG(AF9, TXD12, UART12G1, UART12, SIG_DESC_SET(SCU4D4, 30));
PIN_DECL_2(AF9, GPIOX6, SPI2DQ2, TXD12);

#define AB10 191
SIG_EXPR_LIST_DECL_SEMG(AB10, SPI2DQ3, QSPI2, SPI2, SIG_DESC_SET(SCU434, 31));
SIG_EXPR_LIST_DECL_SEMG(AB10, RXD12, UART12G1, UART12,
			SIG_DESC_SET(SCU4D4, 31));
PIN_DECL_2(AB10, GPIOX7, SPI2DQ3, RXD12);

GROUP_DECL(QSPI2, AE8, AF8, AB9, AD9, AF9, AB10);
FUNC_DECL_2(SPI2, SPI2, QSPI2);

GROUP_DECL(UART12G1, AF9, AB10);
FUNC_DECL_2(UART12, UART12G0, UART12G1);

#define AF11 192
SIG_EXPR_LIST_DECL_SESG(AF11, SALT5, SALT5, SIG_DESC_SET(SCU438, 0));
SIG_EXPR_LIST_DECL_SESG(AF11, WDTRST1, WDTRST1, SIG_DESC_SET(SCU4D8, 0));
PIN_DECL_2(AF11, GPIOY0, SALT5, WDTRST1);
FUNC_GROUP_DECL(SALT5, AF11);
FUNC_GROUP_DECL(WDTRST1, AF11);

#define AD12 193
SIG_EXPR_LIST_DECL_SESG(AD12, SALT6, SALT6, SIG_DESC_SET(SCU438, 1));
SIG_EXPR_LIST_DECL_SESG(AD12, WDTRST2, WDTRST2, SIG_DESC_SET(SCU4D8, 1));
PIN_DECL_2(AD12, GPIOY1, SALT6, WDTRST2);
FUNC_GROUP_DECL(SALT6, AD12);
FUNC_GROUP_DECL(WDTRST2, AD12);

#define AE11 194
SIG_EXPR_LIST_DECL_SESG(AE11, SALT7, SALT7, SIG_DESC_SET(SCU438, 2));
SIG_EXPR_LIST_DECL_SESG(AE11, WDTRST3, WDTRST3, SIG_DESC_SET(SCU4D8, 2));
PIN_DECL_2(AE11, GPIOY2, SALT7, WDTRST3);
FUNC_GROUP_DECL(SALT7, AE11);
FUNC_GROUP_DECL(WDTRST3, AE11);

#define AA12 195
SIG_EXPR_LIST_DECL_SESG(AA12, SALT8, SALT8, SIG_DESC_SET(SCU438, 3));
SIG_EXPR_LIST_DECL_SESG(AA12, WDTRST4, WDTRST4, SIG_DESC_SET(SCU4D8, 3));
PIN_DECL_2(AA12, GPIOY3, SALT8, WDTRST4);
FUNC_GROUP_DECL(SALT8, AA12);
FUNC_GROUP_DECL(WDTRST4, AA12);

#define AE12 196
SIG_EXPR_LIST_DECL_SEMG(AE12, FWSPIDQ2, FWQSPID, FWSPID,
			SIG_DESC_SET(SCU438, 4));
SIG_EXPR_LIST_DECL_SESG(AE12, GPIOY4, GPIOY4);
PIN_DECL_(AE12, SIG_EXPR_LIST_PTR(AE12, FWSPIDQ2),
	  SIG_EXPR_LIST_PTR(AE12, GPIOY4));

#define AF12 197
SIG_EXPR_LIST_DECL_SEMG(AF12, FWSPIDQ3, FWQSPID, FWSPID,
			SIG_DESC_SET(SCU438, 5));
SIG_EXPR_LIST_DECL_SESG(AF12, GPIOY5, GPIOY5);
PIN_DECL_(AF12, SIG_EXPR_LIST_PTR(AF12, FWSPIDQ3),
	  SIG_EXPR_LIST_PTR(AF12, GPIOY5));

#define AC12 198
SSSF_PIN_DECL(AC12, GPIOY6, FWSPIABR, SIG_DESC_SET(SCU438, 6));

#define AB12 199
SSSF_PIN_DECL(AB12, GPIOY7, FWSPIWP, SIG_DESC_SET(SCU438, 7));

#define AC10 200
SSSF_PIN_DECL(AC10, GPIOZ0, SPI1CS1, SIG_DESC_SET(SCU438, 8));

#define AD10 201
SSSF_PIN_DECL(AD10, GPIOZ1, SPI1ABR, SIG_DESC_SET(SCU438, 9));

#define AE10 202
SSSF_PIN_DECL(AE10, GPIOZ2, SPI1WP, SIG_DESC_SET(SCU438, 10));

#define AB11 203
SIG_EXPR_LIST_DECL_SEMG(AB11, SPI1CK, SPI1, SPI1, SIG_DESC_SET(SCU438, 11));
PIN_DECL_1(AB11, GPIOZ3, SPI1CK);

#define AC11 204
SIG_EXPR_LIST_DECL_SEMG(AC11, SPI1MOSI, SPI1, SPI1, SIG_DESC_SET(SCU438, 12));
PIN_DECL_1(AC11, GPIOZ4, SPI1MOSI);

#define AA11 205
SIG_EXPR_LIST_DECL_SEMG(AA11, SPI1MISO, SPI1, SPI1, SIG_DESC_SET(SCU438, 13));
PIN_DECL_1(AA11, GPIOZ5, SPI1MISO);

GROUP_DECL(SPI1, AB11, AC11, AA11);

#define AD11 206
SIG_EXPR_LIST_DECL_SEMG(AD11, SPI1DQ2, QSPI1, SPI1, SIG_DESC_SET(SCU438, 14));
SIG_EXPR_LIST_DECL_SEMG(AD11, TXD13, UART13G1, UART13,
			SIG_DESC_CLEAR(SCU4B8, 2), SIG_DESC_SET(SCU4D8, 14));
PIN_DECL_2(AD11, GPIOZ6, SPI1DQ2, TXD13);

#define AF10 207
SIG_EXPR_LIST_DECL_SEMG(AF10, SPI1DQ3, QSPI1, SPI1, SIG_DESC_SET(SCU438, 15));
SIG_EXPR_LIST_DECL_SEMG(AF10, RXD13, UART13G1, UART13,
			SIG_DESC_CLEAR(SCU4B8, 3), SIG_DESC_SET(SCU4D8, 15));
PIN_DECL_2(AF10, GPIOZ7, SPI1DQ3, RXD13);

GROUP_DECL(QSPI1, AB11, AC11, AA11, AD11, AF10);
FUNC_DECL_2(SPI1, SPI1, QSPI1);

GROUP_DECL(UART13G1, AD11, AF10);
FUNC_DECL_2(UART13, UART13G0, UART13G1);

#define C6 208
SIG_EXPR_LIST_DECL_SESG(C6, RGMII1TXCK, RGMII1, SIG_DESC_SET(SCU400, 0),
			  SIG_DESC_SET(SCU500, 6));
SIG_EXPR_LIST_DECL_SESG(C6, RMII1RCLKO, RMII1, SIG_DESC_SET(SCU400, 0),
			  SIG_DESC_CLEAR(SCU500, 6));
PIN_DECL_2(C6, GPIO18A0, RGMII1TXCK, RMII1RCLKO);

#define D6 209
SIG_EXPR_LIST_DECL_SESG(D6, RGMII1TXCTL, RGMII1, SIG_DESC_SET(SCU400, 1),
			  SIG_DESC_SET(SCU500, 6));
SIG_EXPR_LIST_DECL_SESG(D6, RMII1TXEN, RMII1, SIG_DESC_SET(SCU400, 1),
			  SIG_DESC_CLEAR(SCU500, 6));
PIN_DECL_2(D6, GPIO18A1, RGMII1TXCTL, RMII1TXEN);

#define D5 210
SIG_EXPR_LIST_DECL_SESG(D5, RGMII1TXD0, RGMII1, SIG_DESC_SET(SCU400, 2),
			  SIG_DESC_SET(SCU500, 6));
SIG_EXPR_LIST_DECL_SESG(D5, RMII1TXD0, RMII1, SIG_DESC_SET(SCU400, 2),
			  SIG_DESC_CLEAR(SCU500, 6));
PIN_DECL_2(D5, GPIO18A2, RGMII1TXD0, RMII1TXD0);

#define A3 211
SIG_EXPR_LIST_DECL_SESG(A3, RGMII1TXD1, RGMII1, SIG_DESC_SET(SCU400, 3),
			  SIG_DESC_SET(SCU500, 6));
SIG_EXPR_LIST_DECL_SESG(A3, RMII1TXD1, RMII1, SIG_DESC_SET(SCU400, 3),
			  SIG_DESC_CLEAR(SCU500, 6));
PIN_DECL_2(A3, GPIO18A3, RGMII1TXD1, RMII1TXD1);

#define C5 212
SIG_EXPR_LIST_DECL_SESG(C5, RGMII1TXD2, RGMII1, SIG_DESC_SET(SCU400, 4),
			  SIG_DESC_SET(SCU500, 6));
PIN_DECL_1(C5, GPIO18A4, RGMII1TXD2);

#define E6 213
SIG_EXPR_LIST_DECL_SESG(E6, RGMII1TXD3, RGMII1, SIG_DESC_SET(SCU400, 5),
			  SIG_DESC_SET(SCU500, 6));
PIN_DECL_1(E6, GPIO18A5, RGMII1TXD3);

#define B3 214
SIG_EXPR_LIST_DECL_SESG(B3, RGMII1RXCK, RGMII1, SIG_DESC_SET(SCU400, 6),
			  SIG_DESC_SET(SCU500, 6));
SIG_EXPR_LIST_DECL_SESG(B3, RMII1RCLKI, RMII1, SIG_DESC_SET(SCU400, 6),
			  SIG_DESC_CLEAR(SCU500, 6));
PIN_DECL_2(B3, GPIO18A6, RGMII1RXCK, RMII1RCLKI);

#define A2 215
SIG_EXPR_LIST_DECL_SESG(A2, RGMII1RXCTL, RGMII1, SIG_DESC_SET(SCU400, 7),
			  SIG_DESC_SET(SCU500, 6));
PIN_DECL_1(A2, GPIO18A7, RGMII1RXCTL);

#define B2 216
SIG_EXPR_LIST_DECL_SESG(B2, RGMII1RXD0, RGMII1, SIG_DESC_SET(SCU400, 8),
			  SIG_DESC_SET(SCU500, 6));
SIG_EXPR_LIST_DECL_SESG(B2, RMII1RXD0, RMII1, SIG_DESC_SET(SCU400, 8),
			  SIG_DESC_CLEAR(SCU500, 6));
PIN_DECL_2(B2, GPIO18B0, RGMII1RXD0, RMII1RXD0);

#define B1 217
SIG_EXPR_LIST_DECL_SESG(B1, RGMII1RXD1, RGMII1, SIG_DESC_SET(SCU400, 9),
			  SIG_DESC_SET(SCU500, 6));
SIG_EXPR_LIST_DECL_SESG(B1, RMII1RXD1, RMII1, SIG_DESC_SET(SCU400, 9),
			  SIG_DESC_CLEAR(SCU500, 6));
PIN_DECL_2(B1, GPIO18B1, RGMII1RXD1, RMII1RXD1);

#define C4 218
SIG_EXPR_LIST_DECL_SESG(C4, RGMII1RXD2, RGMII1, SIG_DESC_SET(SCU400, 10),
			  SIG_DESC_SET(SCU500, 6));
SIG_EXPR_LIST_DECL_SESG(C4, RMII1CRSDV, RMII1, SIG_DESC_SET(SCU400, 10),
			  SIG_DESC_CLEAR(SCU500, 6));
PIN_DECL_2(C4, GPIO18B2, RGMII1RXD2, RMII1CRSDV);

#define E5 219
SIG_EXPR_LIST_DECL_SESG(E5, RGMII1RXD3, RGMII1, SIG_DESC_SET(SCU400, 11),
			  SIG_DESC_SET(SCU500, 6));
SIG_EXPR_LIST_DECL_SESG(E5, RMII1RXER, RMII1, SIG_DESC_SET(SCU400, 11),
			  SIG_DESC_CLEAR(SCU500, 6));
PIN_DECL_2(E5, GPIO18B3, RGMII1RXD3, RMII1RXER);

FUNC_GROUP_DECL(RGMII1, C6, D6, D5, A3, C5, E6, B3, A2, B2, B1, C4, E5);
FUNC_GROUP_DECL(RMII1, C6, D6, D5, A3, B3, B2, B1, C4, E5);

#define D4 220
SIG_EXPR_LIST_DECL_SESG(D4, RGMII2TXCK, RGMII2, SIG_DESC_SET(SCU400, 12),
			  SIG_DESC_SET(SCU500, 7));
SIG_EXPR_LIST_DECL_SESG(D4, RMII2RCLKO, RMII2, SIG_DESC_SET(SCU400, 12),
			  SIG_DESC_CLEAR(SCU500, 7));
PIN_DECL_2(D4, GPIO18B4, RGMII2TXCK, RMII2RCLKO);

#define C2 221
SIG_EXPR_LIST_DECL_SESG(C2, RGMII2TXCTL, RGMII2, SIG_DESC_SET(SCU400, 13),
			  SIG_DESC_SET(SCU500, 7));
SIG_EXPR_LIST_DECL_SESG(C2, RMII2TXEN, RMII2, SIG_DESC_SET(SCU400, 13),
			  SIG_DESC_CLEAR(SCU500, 7));
PIN_DECL_2(C2, GPIO18B5, RGMII2TXCTL, RMII2TXEN);

#define C1 222
SIG_EXPR_LIST_DECL_SESG(C1, RGMII2TXD0, RGMII2, SIG_DESC_SET(SCU400, 14),
			  SIG_DESC_SET(SCU500, 7));
SIG_EXPR_LIST_DECL_SESG(C1, RMII2TXD0, RMII2, SIG_DESC_SET(SCU400, 14),
			  SIG_DESC_CLEAR(SCU500, 7));
PIN_DECL_2(C1, GPIO18B6, RGMII2TXD0, RMII2TXD0);

#define D3 223
SIG_EXPR_LIST_DECL_SESG(D3, RGMII2TXD1, RGMII2, SIG_DESC_SET(SCU400, 15),
			  SIG_DESC_SET(SCU500, 7));
SIG_EXPR_LIST_DECL_SESG(D3, RMII2TXD1, RMII2, SIG_DESC_SET(SCU400, 15),
			  SIG_DESC_CLEAR(SCU500, 7));
PIN_DECL_2(D3, GPIO18B7, RGMII2TXD1, RMII2TXD1);

#define E4 224
SIG_EXPR_LIST_DECL_SESG(E4, RGMII2TXD2, RGMII2, SIG_DESC_SET(SCU400, 16),
			  SIG_DESC_SET(SCU500, 7));
PIN_DECL_1(E4, GPIO18C0, RGMII2TXD2);

#define F5 225
SIG_EXPR_LIST_DECL_SESG(F5, RGMII2TXD3, RGMII2, SIG_DESC_SET(SCU400, 17),
			  SIG_DESC_SET(SCU500, 7));
PIN_DECL_1(F5, GPIO18C1, RGMII2TXD3);

#define D2 226
SIG_EXPR_LIST_DECL_SESG(D2, RGMII2RXCK, RGMII2, SIG_DESC_SET(SCU400, 18),
			  SIG_DESC_SET(SCU500, 7));
SIG_EXPR_LIST_DECL_SESG(D2, RMII2RCLKI, RMII2, SIG_DESC_SET(SCU400, 18),
			  SIG_DESC_CLEAR(SCU500, 7));
PIN_DECL_2(D2, GPIO18C2, RGMII2RXCK, RMII2RCLKI);

#define E3 227
SIG_EXPR_LIST_DECL_SESG(E3, RGMII2RXCTL, RGMII2, SIG_DESC_SET(SCU400, 19),
			  SIG_DESC_SET(SCU500, 7));
PIN_DECL_1(E3, GPIO18C3, RGMII2RXCTL);

#define D1 228
SIG_EXPR_LIST_DECL_SESG(D1, RGMII2RXD0, RGMII2, SIG_DESC_SET(SCU400, 20),
			  SIG_DESC_SET(SCU500, 7));
SIG_EXPR_LIST_DECL_SESG(D1, RMII2RXD0, RMII2, SIG_DESC_SET(SCU400, 20),
			  SIG_DESC_CLEAR(SCU500, 7));
PIN_DECL_2(D1, GPIO18C4, RGMII2RXD0, RMII2RXD0);

#define F4 229
SIG_EXPR_LIST_DECL_SESG(F4, RGMII2RXD1, RGMII2, SIG_DESC_SET(SCU400, 21),
			  SIG_DESC_SET(SCU500, 7));
SIG_EXPR_LIST_DECL_SESG(F4, RMII2RXD1, RMII2, SIG_DESC_SET(SCU400, 21),
			  SIG_DESC_CLEAR(SCU500, 7));
PIN_DECL_2(F4, GPIO18C5, RGMII2RXD1, RMII2RXD1);

#define E2 230
SIG_EXPR_LIST_DECL_SESG(E2, RGMII2RXD2, RGMII2, SIG_DESC_SET(SCU400, 22),
			  SIG_DESC_SET(SCU500, 7));
SIG_EXPR_LIST_DECL_SESG(E2, RMII2CRSDV, RMII2, SIG_DESC_SET(SCU400, 22),
			  SIG_DESC_CLEAR(SCU500, 7));
PIN_DECL_2(E2, GPIO18C6, RGMII2RXD2, RMII2CRSDV);

#define E1 231
SIG_EXPR_LIST_DECL_SESG(E1, RGMII2RXD3, RGMII2, SIG_DESC_SET(SCU400, 23),
			  SIG_DESC_SET(SCU500, 7));
SIG_EXPR_LIST_DECL_SESG(E1, RMII2RXER, RMII2, SIG_DESC_SET(SCU400, 23),
			  SIG_DESC_CLEAR(SCU500, 7));
PIN_DECL_2(E1, GPIO18C7, RGMII2RXD3, RMII2RXER);

FUNC_GROUP_DECL(RGMII2, D4, C2, C1, D3, E4, F5, D2, E3, D1, F4, E2, E1);
FUNC_GROUP_DECL(RMII2, D4, C2, C1, D3, D2, D1, F4, E2, E1);

#define AB4 232
SIG_EXPR_LIST_DECL_SEMG(AB4, EMMCCLK, EMMCG1, EMMC, SIG_DESC_SET(SCU400, 24));
PIN_DECL_1(AB4, GPIO18D0, EMMCCLK);

#define AA4 233
SIG_EXPR_LIST_DECL_SEMG(AA4, EMMCCMD, EMMCG1, EMMC, SIG_DESC_SET(SCU400, 25));
PIN_DECL_1(AA4, GPIO18D1, EMMCCMD);

#define AC4 234
SIG_EXPR_LIST_DECL_SEMG(AC4, EMMCDAT0, EMMCG1, EMMC, SIG_DESC_SET(SCU400, 26));
PIN_DECL_1(AC4, GPIO18D2, EMMCDAT0);

#define AA5 235
SIG_EXPR_LIST_DECL_SEMG(AA5, EMMCDAT1, EMMCG4, EMMC, SIG_DESC_SET(SCU400, 27));
PIN_DECL_1(AA5, GPIO18D3, EMMCDAT1);

#define Y5 236
SIG_EXPR_LIST_DECL_SEMG(Y5, EMMCDAT2, EMMCG4, EMMC, SIG_DESC_SET(SCU400, 28));
PIN_DECL_1(Y5, GPIO18D4, EMMCDAT2);

#define AB5 237
SIG_EXPR_LIST_DECL_SEMG(AB5, EMMCDAT3, EMMCG4, EMMC, SIG_DESC_SET(SCU400, 29));
PIN_DECL_1(AB5, GPIO18D5, EMMCDAT3);

#define AB6 238
SIG_EXPR_LIST_DECL_SEMG(AB6, EMMCCD, EMMCG1, EMMC, SIG_DESC_SET(SCU400, 30));
PIN_DECL_1(AB6, GPIO18D6, EMMCCD);

#define AC5 239
SIG_EXPR_LIST_DECL_SEMG(AC5, EMMCWP, EMMCG1, EMMC, SIG_DESC_SET(SCU400, 31));
PIN_DECL_1(AC5, GPIO18D7, EMMCWP);

GROUP_DECL(EMMCG1, AB4, AA4, AC4, AB6, AC5);
GROUP_DECL(EMMCG4, AB4, AA4, AC4, AA5, Y5, AB5, AB6, AC5);

#define Y1 240
SIG_EXPR_LIST_DECL_SEMG(Y1, FWSPIDCS, FWSPID, FWSPID, SIG_DESC_SET(SCU500, 3));
SIG_EXPR_LIST_DECL_SESG(Y1, VBCS, VB, SIG_DESC_SET(SCU500, 5));
SIG_EXPR_LIST_DECL_SEMG(Y1, EMMCDAT4, EMMCG8, EMMC, SIG_DESC_SET(SCU404, 0));
PIN_DECL_3(Y1, GPIO18E0, FWSPIDCS, VBCS, EMMCDAT4);

#define Y2 241
SIG_EXPR_LIST_DECL_SEMG(Y2, FWSPIDCK, FWSPID, FWSPID, SIG_DESC_SET(SCU500, 3));
SIG_EXPR_LIST_DECL_SESG(Y2, VBCK, VB, SIG_DESC_SET(SCU500, 5));
SIG_EXPR_LIST_DECL_SEMG(Y2, EMMCDAT5, EMMCG8, EMMC, SIG_DESC_SET(SCU404, 1));
PIN_DECL_3(Y2, GPIO18E1, FWSPIDCK, VBCK, EMMCDAT5);

#define Y3 242
SIG_EXPR_LIST_DECL_SEMG(Y3, FWSPIDMOSI, FWSPID, FWSPID,
			SIG_DESC_SET(SCU500, 3));
SIG_EXPR_LIST_DECL_SESG(Y3, VBMOSI, VB, SIG_DESC_SET(SCU500, 5));
SIG_EXPR_LIST_DECL_SEMG(Y3, EMMCDAT6, EMMCG8, EMMC, SIG_DESC_SET(SCU404, 2));
PIN_DECL_3(Y3, GPIO18E2, FWSPIDMOSI, VBMOSI, EMMCDAT6);

#define Y4 243
SIG_EXPR_LIST_DECL_SEMG(Y4, FWSPIDMISO, FWSPID, FWSPID,
			SIG_DESC_SET(SCU500, 3));
SIG_EXPR_LIST_DECL_SESG(Y4, VBMISO, VB, SIG_DESC_SET(SCU500, 5));
SIG_EXPR_LIST_DECL_SEMG(Y4, EMMCDAT7, EMMCG8, EMMC, SIG_DESC_SET(SCU404, 3));
PIN_DECL_3(Y4, GPIO18E3, FWSPIDMISO, VBMISO, EMMCDAT7);

GROUP_DECL(FWSPID, Y1, Y2, Y3, Y4);
GROUP_DECL(FWQSPID, Y1, Y2, Y3, Y4, AE12, AF12);
GROUP_DECL(EMMCG8, AB4, AA4, AC4, AA5, Y5, AB5, AB6, AC5, Y1, Y2, Y3, Y4);
FUNC_DECL_2(FWSPID, FWSPID, FWQSPID);
FUNC_GROUP_DECL(VB, Y1, Y2, Y3, Y4);
FUNC_DECL_3(EMMC, EMMCG1, EMMCG4, EMMCG8);
/*
 * FIXME: Confirm bits and priorities are the right way around for the
 * following 4 pins
 */
#define AF25 244
SIG_EXPR_LIST_DECL_SEMG(AF25, I3C3SCL, I3C3, I3C3, SIG_DESC_SET(SCU438, 20));
SIG_EXPR_LIST_DECL_SESG(AF25, FSI1CLK, FSI1, SIG_DESC_SET(SCU4D8, 20));
PIN_DECL_(AF25, SIG_EXPR_LIST_PTR(AF25, I3C3SCL),
	  SIG_EXPR_LIST_PTR(AF25, FSI1CLK));

#define AE26 245
SIG_EXPR_LIST_DECL_SEMG(AE26, I3C3SDA, I3C3, I3C3, SIG_DESC_SET(SCU438, 21));
SIG_EXPR_LIST_DECL_SESG(AE26, FSI1DATA, FSI1, SIG_DESC_SET(SCU4D8, 21));
PIN_DECL_(AE26, SIG_EXPR_LIST_PTR(AE26, I3C3SDA),
	  SIG_EXPR_LIST_PTR(AE26, FSI1DATA));

GROUP_DECL(I3C3, AF25, AE26);
FUNC_DECL_2(I3C3, HVI3C3, I3C3);
FUNC_GROUP_DECL(FSI1, AF25, AE26);

#define AE25 246
SIG_EXPR_LIST_DECL_SEMG(AE25, I3C4SCL, I3C4, I3C4, SIG_DESC_SET(SCU438, 22));
SIG_EXPR_LIST_DECL_SESG(AE25, FSI2CLK, FSI2, SIG_DESC_SET(SCU4D8, 22));
PIN_DECL_(AE25, SIG_EXPR_LIST_PTR(AE25, I3C4SCL),
	  SIG_EXPR_LIST_PTR(AE25, FSI2CLK));

#define AF24 247
SIG_EXPR_LIST_DECL_SEMG(AF24, I3C4SDA, I3C4, I3C4, SIG_DESC_SET(SCU438, 23));
SIG_EXPR_LIST_DECL_SESG(AF24, FSI2DATA, FSI2, SIG_DESC_SET(SCU4D8, 23));
PIN_DECL_(AF24, SIG_EXPR_LIST_PTR(AF24, I3C4SDA),
	  SIG_EXPR_LIST_PTR(AF24, FSI2DATA));

GROUP_DECL(I3C4, AE25, AF24);
FUNC_DECL_2(I3C4, HVI3C4, I3C4);
FUNC_GROUP_DECL(FSI2, AE25, AF24);

#define AF23 248
SIG_EXPR_LIST_DECL_SESG(AF23, I3C1SCL, I3C1, SIG_DESC_SET(SCU438, 16));
PIN_DECL_(AF23, SIG_EXPR_LIST_PTR(AF23, I3C1SCL));

#define AE24 249
SIG_EXPR_LIST_DECL_SESG(AE24, I3C1SDA, I3C1, SIG_DESC_SET(SCU438, 17));
PIN_DECL_(AE24, SIG_EXPR_LIST_PTR(AE24, I3C1SDA));

FUNC_GROUP_DECL(I3C1, AF23, AE24);

#define AF22 250
SIG_EXPR_LIST_DECL_SESG(AF22, I3C2SCL, I3C2, SIG_DESC_SET(SCU438, 18));
PIN_DECL_(AF22, SIG_EXPR_LIST_PTR(AF22, I3C2SCL));

#define AE22 251
SIG_EXPR_LIST_DECL_SESG(AE22, I3C2SDA, I3C2, SIG_DESC_SET(SCU438, 19));
PIN_DECL_(AE22, SIG_EXPR_LIST_PTR(AE22, I3C2SDA));

FUNC_GROUP_DECL(I3C2, AF22, AE22);

#define USB2ADP_DESC   { ASPEED_IP_SCU, SCU440, GENMASK(25, 24), 0, 0 }
#define USB2AD_DESC    { ASPEED_IP_SCU, SCU440, GENMASK(25, 24), 1, 0 }
#define USB2AH_DESC    { ASPEED_IP_SCU, SCU440, GENMASK(25, 24), 2, 0 }
#define USB2AHP_DESC   { ASPEED_IP_SCU, SCU440, GENMASK(25, 24), 3, 0 }
#define USB11BHID_DESC { ASPEED_IP_SCU, SCU440, GENMASK(29, 28), 0, 0 }
#define USB2BD_DESC    { ASPEED_IP_SCU, SCU440, GENMASK(29, 28), 1, 0 }
#define USB2BH_DESC    { ASPEED_IP_SCU, SCU440, GENMASK(29, 28), 2, 0 }

#define A4 252
SIG_EXPR_LIST_DECL_SEMG(A4, USB2ADPDP, USBA, USB2ADP, USB2ADP_DESC,
			SIG_DESC_SET(SCUC20, 16));
SIG_EXPR_LIST_DECL_SEMG(A4, USB2ADDP, USBA, USB2AD, USB2AD_DESC);
SIG_EXPR_LIST_DECL_SEMG(A4, USB2AHDP, USBA, USB2AH, USB2AH_DESC);
SIG_EXPR_LIST_DECL_SEMG(A4, USB2AHPDP, USBA, USB2AHP, USB2AHP_DESC);
PIN_DECL_(A4, SIG_EXPR_LIST_PTR(A4, USB2ADPDP), SIG_EXPR_LIST_PTR(A4, USB2ADDP),
	  SIG_EXPR_LIST_PTR(A4, USB2AHDP));

#define B4 253
SIG_EXPR_LIST_DECL_SEMG(B4, USB2ADPDN, USBA, USB2ADP, USB2ADP_DESC);
SIG_EXPR_LIST_DECL_SEMG(B4, USB2ADDN, USBA, USB2AD, USB2AD_DESC);
SIG_EXPR_LIST_DECL_SEMG(B4, USB2AHDN, USBA, USB2AH, USB2AH_DESC);
SIG_EXPR_LIST_DECL_SEMG(B4, USB2AHPDN, USBA, USB2AHP, USB2AHP_DESC);
PIN_DECL_(B4, SIG_EXPR_LIST_PTR(B4, USB2ADPDN), SIG_EXPR_LIST_PTR(B4, USB2ADDN),
	  SIG_EXPR_LIST_PTR(B4, USB2AHDN));

GROUP_DECL(USBA, A4, B4);

FUNC_DECL_1(USB2ADP, USBA);
FUNC_DECL_1(USB2AD, USBA);
FUNC_DECL_1(USB2AH, USBA);
FUNC_DECL_1(USB2AHP, USBA);

#define A6 254
SIG_EXPR_LIST_DECL_SEMG(A6, USB11BDP, USBB, USB11BHID, USB11BHID_DESC);
SIG_EXPR_LIST_DECL_SEMG(A6, USB2BDDP, USBB, USB2BD, USB2BD_DESC);
SIG_EXPR_LIST_DECL_SEMG(A6, USB2BHDP, USBB, USB2BH, USB2BH_DESC);
PIN_DECL_(A6, SIG_EXPR_LIST_PTR(A6, USB11BDP), SIG_EXPR_LIST_PTR(A6, USB2BDDP),
	  SIG_EXPR_LIST_PTR(A6, USB2BHDP));

#define B6 255
SIG_EXPR_LIST_DECL_SEMG(B6, USB11BDN, USBB, USB11BHID, USB11BHID_DESC);
SIG_EXPR_LIST_DECL_SEMG(B6, USB2BDDN, USBB, USB2BD, USB2BD_DESC);
SIG_EXPR_LIST_DECL_SEMG(B6, USB2BHDN, USBB, USB2BH, USB2BH_DESC);
PIN_DECL_(B6, SIG_EXPR_LIST_PTR(B6, USB11BDN), SIG_EXPR_LIST_PTR(B6, USB2BDDN),
	  SIG_EXPR_LIST_PTR(B6, USB2BHDN));

GROUP_DECL(USBB, A6, B6);

FUNC_DECL_1(USB11BHID, USBB);
FUNC_DECL_1(USB2BD, USBB);
FUNC_DECL_1(USB2BH, USBB);

/* Pins, groups and functions are sort(1):ed alphabetically for sanity */

static struct pinctrl_pin_desc aspeed_g6_pins[ASPEED_G6_NR_PINS] = {
	ASPEED_PINCTRL_PIN(A11),
	ASPEED_PINCTRL_PIN(A12),
	ASPEED_PINCTRL_PIN(A13),
	ASPEED_PINCTRL_PIN(A14),
	ASPEED_PINCTRL_PIN(A15),
	ASPEED_PINCTRL_PIN(A16),
	ASPEED_PINCTRL_PIN(A17),
	ASPEED_PINCTRL_PIN(A18),
	ASPEED_PINCTRL_PIN(A19),
	ASPEED_PINCTRL_PIN(A2),
	ASPEED_PINCTRL_PIN(A20),
	ASPEED_PINCTRL_PIN(A21),
	ASPEED_PINCTRL_PIN(A22),
	ASPEED_PINCTRL_PIN(A23),
	ASPEED_PINCTRL_PIN(A24),
	ASPEED_PINCTRL_PIN(A25),
	ASPEED_PINCTRL_PIN(A3),
	ASPEED_PINCTRL_PIN(A4),
	ASPEED_PINCTRL_PIN(A6),
	ASPEED_PINCTRL_PIN(AA11),
	ASPEED_PINCTRL_PIN(AA12),
	ASPEED_PINCTRL_PIN(AA16),
	ASPEED_PINCTRL_PIN(AA17),
	ASPEED_PINCTRL_PIN(AA23),
	ASPEED_PINCTRL_PIN(AA24),
	ASPEED_PINCTRL_PIN(AA25),
	ASPEED_PINCTRL_PIN(AA26),
	ASPEED_PINCTRL_PIN(AA4),
	ASPEED_PINCTRL_PIN(AA5),
	ASPEED_PINCTRL_PIN(AA9),
	ASPEED_PINCTRL_PIN(AB10),
	ASPEED_PINCTRL_PIN(AB11),
	ASPEED_PINCTRL_PIN(AB12),
	ASPEED_PINCTRL_PIN(AB15),
	ASPEED_PINCTRL_PIN(AB16),
	ASPEED_PINCTRL_PIN(AB17),
	ASPEED_PINCTRL_PIN(AB18),
	ASPEED_PINCTRL_PIN(AB19),
	ASPEED_PINCTRL_PIN(AB22),
	ASPEED_PINCTRL_PIN(AB23),
	ASPEED_PINCTRL_PIN(AB24),
	ASPEED_PINCTRL_PIN(AB25),
	ASPEED_PINCTRL_PIN(AB26),
	ASPEED_PINCTRL_PIN(AB4),
	ASPEED_PINCTRL_PIN(AB5),
	ASPEED_PINCTRL_PIN(AB6),
	ASPEED_PINCTRL_PIN(AB7),
	ASPEED_PINCTRL_PIN(AB8),
	ASPEED_PINCTRL_PIN(AB9),
	ASPEED_PINCTRL_PIN(AC10),
	ASPEED_PINCTRL_PIN(AC11),
	ASPEED_PINCTRL_PIN(AC12),
	ASPEED_PINCTRL_PIN(AC15),
	ASPEED_PINCTRL_PIN(AC16),
	ASPEED_PINCTRL_PIN(AC17),
	ASPEED_PINCTRL_PIN(AC18),
	ASPEED_PINCTRL_PIN(AC19),
	ASPEED_PINCTRL_PIN(AC22),
	ASPEED_PINCTRL_PIN(AC23),
	ASPEED_PINCTRL_PIN(AC24),
	ASPEED_PINCTRL_PIN(AC26),
	ASPEED_PINCTRL_PIN(AC4),
	ASPEED_PINCTRL_PIN(AC5),
	ASPEED_PINCTRL_PIN(AC7),
	ASPEED_PINCTRL_PIN(AC8),
	ASPEED_PINCTRL_PIN(AC9),
	ASPEED_PINCTRL_PIN(AD10),
	ASPEED_PINCTRL_PIN(AD11),
	ASPEED_PINCTRL_PIN(AD12),
	ASPEED_PINCTRL_PIN(AD14),
	ASPEED_PINCTRL_PIN(AD15),
	ASPEED_PINCTRL_PIN(AD16),
	ASPEED_PINCTRL_PIN(AD19),
	ASPEED_PINCTRL_PIN(AD20),
	ASPEED_PINCTRL_PIN(AD22),
	ASPEED_PINCTRL_PIN(AD23),
	ASPEED_PINCTRL_PIN(AD24),
	ASPEED_PINCTRL_PIN(AD25),
	ASPEED_PINCTRL_PIN(AD26),
	ASPEED_PINCTRL_PIN(AD7),
	ASPEED_PINCTRL_PIN(AD8),
	ASPEED_PINCTRL_PIN(AD9),
	ASPEED_PINCTRL_PIN(AE10),
	ASPEED_PINCTRL_PIN(AE11),
	ASPEED_PINCTRL_PIN(AE12),
	ASPEED_PINCTRL_PIN(AE14),
	ASPEED_PINCTRL_PIN(AE15),
	ASPEED_PINCTRL_PIN(AE16),
	ASPEED_PINCTRL_PIN(AE18),
	ASPEED_PINCTRL_PIN(AE19),
	ASPEED_PINCTRL_PIN(AE22),
	ASPEED_PINCTRL_PIN(AE24),
	ASPEED_PINCTRL_PIN(AE25),
	ASPEED_PINCTRL_PIN(AE26),
	ASPEED_PINCTRL_PIN(AE7),
	ASPEED_PINCTRL_PIN(AE8),
	ASPEED_PINCTRL_PIN(AF10),
	ASPEED_PINCTRL_PIN(AF11),
	ASPEED_PINCTRL_PIN(AF12),
	ASPEED_PINCTRL_PIN(AF14),
	ASPEED_PINCTRL_PIN(AF15),
	ASPEED_PINCTRL_PIN(AF22),
	ASPEED_PINCTRL_PIN(AF23),
	ASPEED_PINCTRL_PIN(AF24),
	ASPEED_PINCTRL_PIN(AF25),
	ASPEED_PINCTRL_PIN(AF7),
	ASPEED_PINCTRL_PIN(AF8),
	ASPEED_PINCTRL_PIN(AF9),
	ASPEED_PINCTRL_PIN(B1),
	ASPEED_PINCTRL_PIN(B12),
	ASPEED_PINCTRL_PIN(B13),
	ASPEED_PINCTRL_PIN(B14),
	ASPEED_PINCTRL_PIN(B16),
	ASPEED_PINCTRL_PIN(B17),
	ASPEED_PINCTRL_PIN(B18),
	ASPEED_PINCTRL_PIN(B2),
	ASPEED_PINCTRL_PIN(B20),
	ASPEED_PINCTRL_PIN(B21),
	ASPEED_PINCTRL_PIN(B22),
	ASPEED_PINCTRL_PIN(B24),
	ASPEED_PINCTRL_PIN(B25),
	ASPEED_PINCTRL_PIN(B26),
	ASPEED_PINCTRL_PIN(B3),
	ASPEED_PINCTRL_PIN(B4),
	ASPEED_PINCTRL_PIN(B6),
	ASPEED_PINCTRL_PIN(C1),
	ASPEED_PINCTRL_PIN(C11),
	ASPEED_PINCTRL_PIN(C12),
	ASPEED_PINCTRL_PIN(C13),
	ASPEED_PINCTRL_PIN(C14),
	ASPEED_PINCTRL_PIN(C15),
	ASPEED_PINCTRL_PIN(C16),
	ASPEED_PINCTRL_PIN(C17),
	ASPEED_PINCTRL_PIN(C18),
	ASPEED_PINCTRL_PIN(C19),
	ASPEED_PINCTRL_PIN(C2),
	ASPEED_PINCTRL_PIN(C20),
	ASPEED_PINCTRL_PIN(C21),
	ASPEED_PINCTRL_PIN(C22),
	ASPEED_PINCTRL_PIN(C23),
	ASPEED_PINCTRL_PIN(C24),
	ASPEED_PINCTRL_PIN(C25),
	ASPEED_PINCTRL_PIN(C26),
	ASPEED_PINCTRL_PIN(C4),
	ASPEED_PINCTRL_PIN(C5),
	ASPEED_PINCTRL_PIN(C6),
	ASPEED_PINCTRL_PIN(D1),
	ASPEED_PINCTRL_PIN(D11),
	ASPEED_PINCTRL_PIN(D12),
	ASPEED_PINCTRL_PIN(D13),
	ASPEED_PINCTRL_PIN(D14),
	ASPEED_PINCTRL_PIN(D15),
	ASPEED_PINCTRL_PIN(D16),
	ASPEED_PINCTRL_PIN(D17),
	ASPEED_PINCTRL_PIN(D18),
	ASPEED_PINCTRL_PIN(D19),
	ASPEED_PINCTRL_PIN(D2),
	ASPEED_PINCTRL_PIN(D20),
	ASPEED_PINCTRL_PIN(D21),
	ASPEED_PINCTRL_PIN(D22),
	ASPEED_PINCTRL_PIN(D23),
	ASPEED_PINCTRL_PIN(D24),
	ASPEED_PINCTRL_PIN(D26),
	ASPEED_PINCTRL_PIN(D3),
	ASPEED_PINCTRL_PIN(D4),
	ASPEED_PINCTRL_PIN(D5),
	ASPEED_PINCTRL_PIN(D6),
	ASPEED_PINCTRL_PIN(E1),
	ASPEED_PINCTRL_PIN(E11),
	ASPEED_PINCTRL_PIN(E12),
	ASPEED_PINCTRL_PIN(E13),
	ASPEED_PINCTRL_PIN(E14),
	ASPEED_PINCTRL_PIN(E15),
	ASPEED_PINCTRL_PIN(E16),
	ASPEED_PINCTRL_PIN(E17),
	ASPEED_PINCTRL_PIN(E18),
	ASPEED_PINCTRL_PIN(E19),
	ASPEED_PINCTRL_PIN(E2),
	ASPEED_PINCTRL_PIN(E20),
	ASPEED_PINCTRL_PIN(E21),
	ASPEED_PINCTRL_PIN(E22),
	ASPEED_PINCTRL_PIN(E23),
	ASPEED_PINCTRL_PIN(E24),
	ASPEED_PINCTRL_PIN(E25),
	ASPEED_PINCTRL_PIN(E26),
	ASPEED_PINCTRL_PIN(E3),
	ASPEED_PINCTRL_PIN(E4),
	ASPEED_PINCTRL_PIN(E5),
	ASPEED_PINCTRL_PIN(E6),
	ASPEED_PINCTRL_PIN(F13),
	ASPEED_PINCTRL_PIN(F15),
	ASPEED_PINCTRL_PIN(F22),
	ASPEED_PINCTRL_PIN(F23),
	ASPEED_PINCTRL_PIN(F24),
	ASPEED_PINCTRL_PIN(F25),
	ASPEED_PINCTRL_PIN(F26),
	ASPEED_PINCTRL_PIN(F4),
	ASPEED_PINCTRL_PIN(F5),
	ASPEED_PINCTRL_PIN(G22),
	ASPEED_PINCTRL_PIN(G23),
	ASPEED_PINCTRL_PIN(G24),
	ASPEED_PINCTRL_PIN(G26),
	ASPEED_PINCTRL_PIN(H22),
	ASPEED_PINCTRL_PIN(H23),
	ASPEED_PINCTRL_PIN(H24),
	ASPEED_PINCTRL_PIN(H25),
	ASPEED_PINCTRL_PIN(H26),
	ASPEED_PINCTRL_PIN(J22),
	ASPEED_PINCTRL_PIN(J23),
	ASPEED_PINCTRL_PIN(J24),
	ASPEED_PINCTRL_PIN(J25),
	ASPEED_PINCTRL_PIN(J26),
	ASPEED_PINCTRL_PIN(K23),
	ASPEED_PINCTRL_PIN(K24),
	ASPEED_PINCTRL_PIN(K25),
	ASPEED_PINCTRL_PIN(K26),
	ASPEED_PINCTRL_PIN(L23),
	ASPEED_PINCTRL_PIN(L24),
	ASPEED_PINCTRL_PIN(L26),
	ASPEED_PINCTRL_PIN(M23),
	ASPEED_PINCTRL_PIN(M24),
	ASPEED_PINCTRL_PIN(M25),
	ASPEED_PINCTRL_PIN(M26),
	ASPEED_PINCTRL_PIN(N23),
	ASPEED_PINCTRL_PIN(N24),
	ASPEED_PINCTRL_PIN(N25),
	ASPEED_PINCTRL_PIN(N26),
	ASPEED_PINCTRL_PIN(P23),
	ASPEED_PINCTRL_PIN(P24),
	ASPEED_PINCTRL_PIN(P25),
	ASPEED_PINCTRL_PIN(P26),
	ASPEED_PINCTRL_PIN(R23),
	ASPEED_PINCTRL_PIN(R24),
	ASPEED_PINCTRL_PIN(R26),
	ASPEED_PINCTRL_PIN(T23),
	ASPEED_PINCTRL_PIN(T24),
	ASPEED_PINCTRL_PIN(T25),
	ASPEED_PINCTRL_PIN(T26),
	ASPEED_PINCTRL_PIN(U24),
	ASPEED_PINCTRL_PIN(U25),
	ASPEED_PINCTRL_PIN(U26),
	ASPEED_PINCTRL_PIN(V24),
	ASPEED_PINCTRL_PIN(V25),
	ASPEED_PINCTRL_PIN(V26),
	ASPEED_PINCTRL_PIN(W23),
	ASPEED_PINCTRL_PIN(W24),
	ASPEED_PINCTRL_PIN(W26),
	ASPEED_PINCTRL_PIN(Y1),
	ASPEED_PINCTRL_PIN(Y2),
	ASPEED_PINCTRL_PIN(Y23),
	ASPEED_PINCTRL_PIN(Y24),
	ASPEED_PINCTRL_PIN(Y25),
	ASPEED_PINCTRL_PIN(Y26),
	ASPEED_PINCTRL_PIN(Y3),
	ASPEED_PINCTRL_PIN(Y4),
	ASPEED_PINCTRL_PIN(Y5),
};

static const struct aspeed_pin_group aspeed_g6_groups[] = {
	ASPEED_PINCTRL_GROUP(ADC0),
	ASPEED_PINCTRL_GROUP(ADC1),
	ASPEED_PINCTRL_GROUP(ADC10),
	ASPEED_PINCTRL_GROUP(ADC11),
	ASPEED_PINCTRL_GROUP(ADC12),
	ASPEED_PINCTRL_GROUP(ADC13),
	ASPEED_PINCTRL_GROUP(ADC14),
	ASPEED_PINCTRL_GROUP(ADC15),
	ASPEED_PINCTRL_GROUP(ADC2),
	ASPEED_PINCTRL_GROUP(ADC3),
	ASPEED_PINCTRL_GROUP(ADC4),
	ASPEED_PINCTRL_GROUP(ADC5),
	ASPEED_PINCTRL_GROUP(ADC6),
	ASPEED_PINCTRL_GROUP(ADC7),
	ASPEED_PINCTRL_GROUP(ADC8),
	ASPEED_PINCTRL_GROUP(ADC9),
	ASPEED_PINCTRL_GROUP(BMCINT),
	ASPEED_PINCTRL_GROUP(ESPI),
	ASPEED_PINCTRL_GROUP(ESPIALT),
	ASPEED_PINCTRL_GROUP(FSI1),
	ASPEED_PINCTRL_GROUP(FSI2),
	ASPEED_PINCTRL_GROUP(FWSPIABR),
	ASPEED_PINCTRL_GROUP(FWSPID),
	ASPEED_PINCTRL_GROUP(FWQSPID),
	ASPEED_PINCTRL_GROUP(FWSPIWP),
	ASPEED_PINCTRL_GROUP(GPIT0),
	ASPEED_PINCTRL_GROUP(GPIT1),
	ASPEED_PINCTRL_GROUP(GPIT2),
	ASPEED_PINCTRL_GROUP(GPIT3),
	ASPEED_PINCTRL_GROUP(GPIT4),
	ASPEED_PINCTRL_GROUP(GPIT5),
	ASPEED_PINCTRL_GROUP(GPIT6),
	ASPEED_PINCTRL_GROUP(GPIT7),
	ASPEED_PINCTRL_GROUP(GPIU0),
	ASPEED_PINCTRL_GROUP(GPIU1),
	ASPEED_PINCTRL_GROUP(GPIU2),
	ASPEED_PINCTRL_GROUP(GPIU3),
	ASPEED_PINCTRL_GROUP(GPIU4),
	ASPEED_PINCTRL_GROUP(GPIU5),
	ASPEED_PINCTRL_GROUP(GPIU6),
	ASPEED_PINCTRL_GROUP(GPIU7),
	ASPEED_PINCTRL_GROUP(HVI3C3),
	ASPEED_PINCTRL_GROUP(HVI3C4),
	ASPEED_PINCTRL_GROUP(I2C1),
	ASPEED_PINCTRL_GROUP(I2C10),
	ASPEED_PINCTRL_GROUP(I2C11),
	ASPEED_PINCTRL_GROUP(I2C12),
	ASPEED_PINCTRL_GROUP(I2C13),
	ASPEED_PINCTRL_GROUP(I2C14),
	ASPEED_PINCTRL_GROUP(I2C15),
	ASPEED_PINCTRL_GROUP(I2C16),
	ASPEED_PINCTRL_GROUP(I2C2),
	ASPEED_PINCTRL_GROUP(I2C3),
	ASPEED_PINCTRL_GROUP(I2C4),
	ASPEED_PINCTRL_GROUP(I2C5),
	ASPEED_PINCTRL_GROUP(I2C6),
	ASPEED_PINCTRL_GROUP(I2C7),
	ASPEED_PINCTRL_GROUP(I2C8),
	ASPEED_PINCTRL_GROUP(I2C9),
	ASPEED_PINCTRL_GROUP(I3C1),
	ASPEED_PINCTRL_GROUP(I3C2),
	ASPEED_PINCTRL_GROUP(I3C3),
	ASPEED_PINCTRL_GROUP(I3C4),
	ASPEED_PINCTRL_GROUP(I3C5),
	ASPEED_PINCTRL_GROUP(I3C6),
	ASPEED_PINCTRL_GROUP(JTAGM),
	ASPEED_PINCTRL_GROUP(LHPD),
	ASPEED_PINCTRL_GROUP(LHSIRQ),
	ASPEED_PINCTRL_GROUP(LPC),
	ASPEED_PINCTRL_GROUP(LPCHC),
	ASPEED_PINCTRL_GROUP(LPCPD),
	ASPEED_PINCTRL_GROUP(LPCPME),
	ASPEED_PINCTRL_GROUP(LPCSMI),
	ASPEED_PINCTRL_GROUP(LSIRQ),
	ASPEED_PINCTRL_GROUP(MACLINK1),
	ASPEED_PINCTRL_GROUP(MACLINK2),
	ASPEED_PINCTRL_GROUP(MACLINK3),
	ASPEED_PINCTRL_GROUP(MACLINK4),
	ASPEED_PINCTRL_GROUP(MDIO1),
	ASPEED_PINCTRL_GROUP(MDIO2),
	ASPEED_PINCTRL_GROUP(MDIO3),
	ASPEED_PINCTRL_GROUP(MDIO4),
	ASPEED_PINCTRL_GROUP(NCTS1),
	ASPEED_PINCTRL_GROUP(NCTS2),
	ASPEED_PINCTRL_GROUP(NCTS3),
	ASPEED_PINCTRL_GROUP(NCTS4),
	ASPEED_PINCTRL_GROUP(NDCD1),
	ASPEED_PINCTRL_GROUP(NDCD2),
	ASPEED_PINCTRL_GROUP(NDCD3),
	ASPEED_PINCTRL_GROUP(NDCD4),
	ASPEED_PINCTRL_GROUP(NDSR1),
	ASPEED_PINCTRL_GROUP(NDSR2),
	ASPEED_PINCTRL_GROUP(NDSR3),
	ASPEED_PINCTRL_GROUP(NDSR4),
	ASPEED_PINCTRL_GROUP(NDTR1),
	ASPEED_PINCTRL_GROUP(NDTR2),
	ASPEED_PINCTRL_GROUP(NDTR3),
	ASPEED_PINCTRL_GROUP(NDTR4),
	ASPEED_PINCTRL_GROUP(NRI1),
	ASPEED_PINCTRL_GROUP(NRI2),
	ASPEED_PINCTRL_GROUP(NRI3),
	ASPEED_PINCTRL_GROUP(NRI4),
	ASPEED_PINCTRL_GROUP(NRTS1),
	ASPEED_PINCTRL_GROUP(NRTS2),
	ASPEED_PINCTRL_GROUP(NRTS3),
	ASPEED_PINCTRL_GROUP(NRTS4),
	ASPEED_PINCTRL_GROUP(OSCCLK),
	ASPEED_PINCTRL_GROUP(PEWAKE),
	ASPEED_PINCTRL_GROUP(PWM0),
	ASPEED_PINCTRL_GROUP(PWM1),
	ASPEED_PINCTRL_GROUP(PWM10G0),
	ASPEED_PINCTRL_GROUP(PWM10G1),
	ASPEED_PINCTRL_GROUP(PWM11G0),
	ASPEED_PINCTRL_GROUP(PWM11G1),
	ASPEED_PINCTRL_GROUP(PWM12G0),
	ASPEED_PINCTRL_GROUP(PWM12G1),
	ASPEED_PINCTRL_GROUP(PWM13G0),
	ASPEED_PINCTRL_GROUP(PWM13G1),
	ASPEED_PINCTRL_GROUP(PWM14G0),
	ASPEED_PINCTRL_GROUP(PWM14G1),
	ASPEED_PINCTRL_GROUP(PWM15G0),
	ASPEED_PINCTRL_GROUP(PWM15G1),
	ASPEED_PINCTRL_GROUP(PWM2),
	ASPEED_PINCTRL_GROUP(PWM3),
	ASPEED_PINCTRL_GROUP(PWM4),
	ASPEED_PINCTRL_GROUP(PWM5),
	ASPEED_PINCTRL_GROUP(PWM6),
	ASPEED_PINCTRL_GROUP(PWM7),
	ASPEED_PINCTRL_GROUP(PWM8G0),
	ASPEED_PINCTRL_GROUP(PWM8G1),
	ASPEED_PINCTRL_GROUP(PWM9G0),
	ASPEED_PINCTRL_GROUP(PWM9G1),
	ASPEED_PINCTRL_GROUP(QSPI1),
	ASPEED_PINCTRL_GROUP(QSPI2),
	ASPEED_PINCTRL_GROUP(RGMII1),
	ASPEED_PINCTRL_GROUP(RGMII2),
	ASPEED_PINCTRL_GROUP(RGMII3),
	ASPEED_PINCTRL_GROUP(RGMII4),
	ASPEED_PINCTRL_GROUP(RMII1),
	ASPEED_PINCTRL_GROUP(RMII2),
	ASPEED_PINCTRL_GROUP(RMII3),
	ASPEED_PINCTRL_GROUP(RMII4),
	ASPEED_PINCTRL_GROUP(RXD1),
	ASPEED_PINCTRL_GROUP(RXD2),
	ASPEED_PINCTRL_GROUP(RXD3),
	ASPEED_PINCTRL_GROUP(RXD4),
	ASPEED_PINCTRL_GROUP(SALT1),
	ASPEED_PINCTRL_GROUP(SALT10G0),
	ASPEED_PINCTRL_GROUP(SALT10G1),
	ASPEED_PINCTRL_GROUP(SALT11G0),
	ASPEED_PINCTRL_GROUP(SALT11G1),
	ASPEED_PINCTRL_GROUP(SALT12G0),
	ASPEED_PINCTRL_GROUP(SALT12G1),
	ASPEED_PINCTRL_GROUP(SALT13G0),
	ASPEED_PINCTRL_GROUP(SALT13G1),
	ASPEED_PINCTRL_GROUP(SALT14G0),
	ASPEED_PINCTRL_GROUP(SALT14G1),
	ASPEED_PINCTRL_GROUP(SALT15G0),
	ASPEED_PINCTRL_GROUP(SALT15G1),
	ASPEED_PINCTRL_GROUP(SALT16G0),
	ASPEED_PINCTRL_GROUP(SALT16G1),
	ASPEED_PINCTRL_GROUP(SALT2),
	ASPEED_PINCTRL_GROUP(SALT3),
	ASPEED_PINCTRL_GROUP(SALT4),
	ASPEED_PINCTRL_GROUP(SALT5),
	ASPEED_PINCTRL_GROUP(SALT6),
	ASPEED_PINCTRL_GROUP(SALT7),
	ASPEED_PINCTRL_GROUP(SALT8),
	ASPEED_PINCTRL_GROUP(SALT9G0),
	ASPEED_PINCTRL_GROUP(SALT9G1),
	ASPEED_PINCTRL_GROUP(SD1),
	ASPEED_PINCTRL_GROUP(SD2),
	ASPEED_PINCTRL_GROUP(EMMCG1),
	ASPEED_PINCTRL_GROUP(EMMCG4),
	ASPEED_PINCTRL_GROUP(EMMCG8),
	ASPEED_PINCTRL_GROUP(SGPM1),
	ASPEED_PINCTRL_GROUP(SGPS1),
	ASPEED_PINCTRL_GROUP(SIOONCTRL),
	ASPEED_PINCTRL_GROUP(SIOPBI),
	ASPEED_PINCTRL_GROUP(SIOPBO),
	ASPEED_PINCTRL_GROUP(SIOPWREQ),
	ASPEED_PINCTRL_GROUP(SIOPWRGD),
	ASPEED_PINCTRL_GROUP(SIOS3),
	ASPEED_PINCTRL_GROUP(SIOS5),
	ASPEED_PINCTRL_GROUP(SIOSCI),
	ASPEED_PINCTRL_GROUP(SPI1),
	ASPEED_PINCTRL_GROUP(SPI1ABR),
	ASPEED_PINCTRL_GROUP(SPI1CS1),
	ASPEED_PINCTRL_GROUP(SPI1WP),
	ASPEED_PINCTRL_GROUP(SPI2),
	ASPEED_PINCTRL_GROUP(SPI2CS1),
	ASPEED_PINCTRL_GROUP(SPI2CS2),
	ASPEED_PINCTRL_GROUP(TACH0),
	ASPEED_PINCTRL_GROUP(TACH1),
	ASPEED_PINCTRL_GROUP(TACH10),
	ASPEED_PINCTRL_GROUP(TACH11),
	ASPEED_PINCTRL_GROUP(TACH12),
	ASPEED_PINCTRL_GROUP(TACH13),
	ASPEED_PINCTRL_GROUP(TACH14),
	ASPEED_PINCTRL_GROUP(TACH15),
	ASPEED_PINCTRL_GROUP(TACH2),
	ASPEED_PINCTRL_GROUP(TACH3),
	ASPEED_PINCTRL_GROUP(TACH4),
	ASPEED_PINCTRL_GROUP(TACH5),
	ASPEED_PINCTRL_GROUP(TACH6),
	ASPEED_PINCTRL_GROUP(TACH7),
	ASPEED_PINCTRL_GROUP(TACH8),
	ASPEED_PINCTRL_GROUP(TACH9),
	ASPEED_PINCTRL_GROUP(THRU0),
	ASPEED_PINCTRL_GROUP(THRU1),
	ASPEED_PINCTRL_GROUP(THRU2),
	ASPEED_PINCTRL_GROUP(THRU3),
	ASPEED_PINCTRL_GROUP(TXD1),
	ASPEED_PINCTRL_GROUP(TXD2),
	ASPEED_PINCTRL_GROUP(TXD3),
	ASPEED_PINCTRL_GROUP(TXD4),
	ASPEED_PINCTRL_GROUP(UART10),
	ASPEED_PINCTRL_GROUP(UART11),
	ASPEED_PINCTRL_GROUP(UART12G0),
	ASPEED_PINCTRL_GROUP(UART12G1),
	ASPEED_PINCTRL_GROUP(UART13G0),
	ASPEED_PINCTRL_GROUP(UART13G1),
	ASPEED_PINCTRL_GROUP(UART6),
	ASPEED_PINCTRL_GROUP(UART7),
	ASPEED_PINCTRL_GROUP(UART8),
	ASPEED_PINCTRL_GROUP(UART9),
	ASPEED_PINCTRL_GROUP(USBA),
	ASPEED_PINCTRL_GROUP(USBB),
	ASPEED_PINCTRL_GROUP(VB),
	ASPEED_PINCTRL_GROUP(VGAHS),
	ASPEED_PINCTRL_GROUP(VGAVS),
	ASPEED_PINCTRL_GROUP(WDTRST1),
	ASPEED_PINCTRL_GROUP(WDTRST2),
	ASPEED_PINCTRL_GROUP(WDTRST3),
	ASPEED_PINCTRL_GROUP(WDTRST4),
};

static const struct aspeed_pin_function aspeed_g6_functions[] = {
	ASPEED_PINCTRL_FUNC(ADC0),
	ASPEED_PINCTRL_FUNC(ADC1),
	ASPEED_PINCTRL_FUNC(ADC10),
	ASPEED_PINCTRL_FUNC(ADC11),
	ASPEED_PINCTRL_FUNC(ADC12),
	ASPEED_PINCTRL_FUNC(ADC13),
	ASPEED_PINCTRL_FUNC(ADC14),
	ASPEED_PINCTRL_FUNC(ADC15),
	ASPEED_PINCTRL_FUNC(ADC2),
	ASPEED_PINCTRL_FUNC(ADC3),
	ASPEED_PINCTRL_FUNC(ADC4),
	ASPEED_PINCTRL_FUNC(ADC5),
	ASPEED_PINCTRL_FUNC(ADC6),
	ASPEED_PINCTRL_FUNC(ADC7),
	ASPEED_PINCTRL_FUNC(ADC8),
	ASPEED_PINCTRL_FUNC(ADC9),
	ASPEED_PINCTRL_FUNC(BMCINT),
	ASPEED_PINCTRL_FUNC(EMMC),
	ASPEED_PINCTRL_FUNC(ESPI),
	ASPEED_PINCTRL_FUNC(ESPIALT),
	ASPEED_PINCTRL_FUNC(FSI1),
	ASPEED_PINCTRL_FUNC(FSI2),
	ASPEED_PINCTRL_FUNC(FWSPIABR),
	ASPEED_PINCTRL_FUNC(FWSPID),
	ASPEED_PINCTRL_FUNC(FWSPIWP),
	ASPEED_PINCTRL_FUNC(GPIT0),
	ASPEED_PINCTRL_FUNC(GPIT1),
	ASPEED_PINCTRL_FUNC(GPIT2),
	ASPEED_PINCTRL_FUNC(GPIT3),
	ASPEED_PINCTRL_FUNC(GPIT4),
	ASPEED_PINCTRL_FUNC(GPIT5),
	ASPEED_PINCTRL_FUNC(GPIT6),
	ASPEED_PINCTRL_FUNC(GPIT7),
	ASPEED_PINCTRL_FUNC(GPIU0),
	ASPEED_PINCTRL_FUNC(GPIU1),
	ASPEED_PINCTRL_FUNC(GPIU2),
	ASPEED_PINCTRL_FUNC(GPIU3),
	ASPEED_PINCTRL_FUNC(GPIU4),
	ASPEED_PINCTRL_FUNC(GPIU5),
	ASPEED_PINCTRL_FUNC(GPIU6),
	ASPEED_PINCTRL_FUNC(GPIU7),
	ASPEED_PINCTRL_FUNC(I2C1),
	ASPEED_PINCTRL_FUNC(I2C10),
	ASPEED_PINCTRL_FUNC(I2C11),
	ASPEED_PINCTRL_FUNC(I2C12),
	ASPEED_PINCTRL_FUNC(I2C13),
	ASPEED_PINCTRL_FUNC(I2C14),
	ASPEED_PINCTRL_FUNC(I2C15),
	ASPEED_PINCTRL_FUNC(I2C16),
	ASPEED_PINCTRL_FUNC(I2C2),
	ASPEED_PINCTRL_FUNC(I2C3),
	ASPEED_PINCTRL_FUNC(I2C4),
	ASPEED_PINCTRL_FUNC(I2C5),
	ASPEED_PINCTRL_FUNC(I2C6),
	ASPEED_PINCTRL_FUNC(I2C7),
	ASPEED_PINCTRL_FUNC(I2C8),
	ASPEED_PINCTRL_FUNC(I2C9),
	ASPEED_PINCTRL_FUNC(I3C1),
	ASPEED_PINCTRL_FUNC(I3C2),
	ASPEED_PINCTRL_FUNC(I3C3),
	ASPEED_PINCTRL_FUNC(I3C4),
	ASPEED_PINCTRL_FUNC(I3C5),
	ASPEED_PINCTRL_FUNC(I3C6),
	ASPEED_PINCTRL_FUNC(JTAGM),
	ASPEED_PINCTRL_FUNC(LHPD),
	ASPEED_PINCTRL_FUNC(LHSIRQ),
	ASPEED_PINCTRL_FUNC(LPC),
	ASPEED_PINCTRL_FUNC(LPCHC),
	ASPEED_PINCTRL_FUNC(LPCPD),
	ASPEED_PINCTRL_FUNC(LPCPME),
	ASPEED_PINCTRL_FUNC(LPCSMI),
	ASPEED_PINCTRL_FUNC(LSIRQ),
	ASPEED_PINCTRL_FUNC(MACLINK1),
	ASPEED_PINCTRL_FUNC(MACLINK2),
	ASPEED_PINCTRL_FUNC(MACLINK3),
	ASPEED_PINCTRL_FUNC(MACLINK4),
	ASPEED_PINCTRL_FUNC(MDIO1),
	ASPEED_PINCTRL_FUNC(MDIO2),
	ASPEED_PINCTRL_FUNC(MDIO3),
	ASPEED_PINCTRL_FUNC(MDIO4),
	ASPEED_PINCTRL_FUNC(NCTS1),
	ASPEED_PINCTRL_FUNC(NCTS2),
	ASPEED_PINCTRL_FUNC(NCTS3),
	ASPEED_PINCTRL_FUNC(NCTS4),
	ASPEED_PINCTRL_FUNC(NDCD1),
	ASPEED_PINCTRL_FUNC(NDCD2),
	ASPEED_PINCTRL_FUNC(NDCD3),
	ASPEED_PINCTRL_FUNC(NDCD4),
	ASPEED_PINCTRL_FUNC(NDSR1),
	ASPEED_PINCTRL_FUNC(NDSR2),
	ASPEED_PINCTRL_FUNC(NDSR3),
	ASPEED_PINCTRL_FUNC(NDSR4),
	ASPEED_PINCTRL_FUNC(NDTR1),
	ASPEED_PINCTRL_FUNC(NDTR2),
	ASPEED_PINCTRL_FUNC(NDTR3),
	ASPEED_PINCTRL_FUNC(NDTR4),
	ASPEED_PINCTRL_FUNC(NRI1),
	ASPEED_PINCTRL_FUNC(NRI2),
	ASPEED_PINCTRL_FUNC(NRI3),
	ASPEED_PINCTRL_FUNC(NRI4),
	ASPEED_PINCTRL_FUNC(NRTS1),
	ASPEED_PINCTRL_FUNC(NRTS2),
	ASPEED_PINCTRL_FUNC(NRTS3),
	ASPEED_PINCTRL_FUNC(NRTS4),
	ASPEED_PINCTRL_FUNC(OSCCLK),
	ASPEED_PINCTRL_FUNC(PEWAKE),
	ASPEED_PINCTRL_FUNC(PWM0),
	ASPEED_PINCTRL_FUNC(PWM1),
	ASPEED_PINCTRL_FUNC(PWM10),
	ASPEED_PINCTRL_FUNC(PWM11),
	ASPEED_PINCTRL_FUNC(PWM12),
	ASPEED_PINCTRL_FUNC(PWM13),
	ASPEED_PINCTRL_FUNC(PWM14),
	ASPEED_PINCTRL_FUNC(PWM15),
	ASPEED_PINCTRL_FUNC(PWM2),
	ASPEED_PINCTRL_FUNC(PWM3),
	ASPEED_PINCTRL_FUNC(PWM4),
	ASPEED_PINCTRL_FUNC(PWM5),
	ASPEED_PINCTRL_FUNC(PWM6),
	ASPEED_PINCTRL_FUNC(PWM7),
	ASPEED_PINCTRL_FUNC(PWM8),
	ASPEED_PINCTRL_FUNC(PWM9),
	ASPEED_PINCTRL_FUNC(RGMII1),
	ASPEED_PINCTRL_FUNC(RGMII2),
	ASPEED_PINCTRL_FUNC(RGMII3),
	ASPEED_PINCTRL_FUNC(RGMII4),
	ASPEED_PINCTRL_FUNC(RMII1),
	ASPEED_PINCTRL_FUNC(RMII2),
	ASPEED_PINCTRL_FUNC(RMII3),
	ASPEED_PINCTRL_FUNC(RMII4),
	ASPEED_PINCTRL_FUNC(RXD1),
	ASPEED_PINCTRL_FUNC(RXD2),
	ASPEED_PINCTRL_FUNC(RXD3),
	ASPEED_PINCTRL_FUNC(RXD4),
	ASPEED_PINCTRL_FUNC(SALT1),
	ASPEED_PINCTRL_FUNC(SALT10),
	ASPEED_PINCTRL_FUNC(SALT11),
	ASPEED_PINCTRL_FUNC(SALT12),
	ASPEED_PINCTRL_FUNC(SALT13),
	ASPEED_PINCTRL_FUNC(SALT14),
	ASPEED_PINCTRL_FUNC(SALT15),
	ASPEED_PINCTRL_FUNC(SALT16),
	ASPEED_PINCTRL_FUNC(SALT2),
	ASPEED_PINCTRL_FUNC(SALT3),
	ASPEED_PINCTRL_FUNC(SALT4),
	ASPEED_PINCTRL_FUNC(SALT5),
	ASPEED_PINCTRL_FUNC(SALT6),
	ASPEED_PINCTRL_FUNC(SALT7),
	ASPEED_PINCTRL_FUNC(SALT8),
	ASPEED_PINCTRL_FUNC(SALT9),
	ASPEED_PINCTRL_FUNC(SD1),
	ASPEED_PINCTRL_FUNC(SD2),
	ASPEED_PINCTRL_FUNC(SGPM1),
	ASPEED_PINCTRL_FUNC(SGPS1),
	ASPEED_PINCTRL_FUNC(SIOONCTRL),
	ASPEED_PINCTRL_FUNC(SIOPBI),
	ASPEED_PINCTRL_FUNC(SIOPBO),
	ASPEED_PINCTRL_FUNC(SIOPWREQ),
	ASPEED_PINCTRL_FUNC(SIOPWRGD),
	ASPEED_PINCTRL_FUNC(SIOS3),
	ASPEED_PINCTRL_FUNC(SIOS5),
	ASPEED_PINCTRL_FUNC(SIOSCI),
	ASPEED_PINCTRL_FUNC(SPI1),
	ASPEED_PINCTRL_FUNC(SPI1ABR),
	ASPEED_PINCTRL_FUNC(SPI1CS1),
	ASPEED_PINCTRL_FUNC(SPI1WP),
	ASPEED_PINCTRL_FUNC(SPI2),
	ASPEED_PINCTRL_FUNC(SPI2CS1),
	ASPEED_PINCTRL_FUNC(SPI2CS2),
	ASPEED_PINCTRL_FUNC(TACH0),
	ASPEED_PINCTRL_FUNC(TACH1),
	ASPEED_PINCTRL_FUNC(TACH10),
	ASPEED_PINCTRL_FUNC(TACH11),
	ASPEED_PINCTRL_FUNC(TACH12),
	ASPEED_PINCTRL_FUNC(TACH13),
	ASPEED_PINCTRL_FUNC(TACH14),
	ASPEED_PINCTRL_FUNC(TACH15),
	ASPEED_PINCTRL_FUNC(TACH2),
	ASPEED_PINCTRL_FUNC(TACH3),
	ASPEED_PINCTRL_FUNC(TACH4),
	ASPEED_PINCTRL_FUNC(TACH5),
	ASPEED_PINCTRL_FUNC(TACH6),
	ASPEED_PINCTRL_FUNC(TACH7),
	ASPEED_PINCTRL_FUNC(TACH8),
	ASPEED_PINCTRL_FUNC(TACH9),
	ASPEED_PINCTRL_FUNC(THRU0),
	ASPEED_PINCTRL_FUNC(THRU1),
	ASPEED_PINCTRL_FUNC(THRU2),
	ASPEED_PINCTRL_FUNC(THRU3),
	ASPEED_PINCTRL_FUNC(TXD1),
	ASPEED_PINCTRL_FUNC(TXD2),
	ASPEED_PINCTRL_FUNC(TXD3),
	ASPEED_PINCTRL_FUNC(TXD4),
	ASPEED_PINCTRL_FUNC(UART10),
	ASPEED_PINCTRL_FUNC(UART11),
	ASPEED_PINCTRL_FUNC(UART12),
	ASPEED_PINCTRL_FUNC(UART13),
	ASPEED_PINCTRL_FUNC(UART6),
	ASPEED_PINCTRL_FUNC(UART7),
	ASPEED_PINCTRL_FUNC(UART8),
	ASPEED_PINCTRL_FUNC(UART9),
	ASPEED_PINCTRL_FUNC(USB11BHID),
	ASPEED_PINCTRL_FUNC(USB2AD),
	ASPEED_PINCTRL_FUNC(USB2ADP),
	ASPEED_PINCTRL_FUNC(USB2AH),
	ASPEED_PINCTRL_FUNC(USB2AHP),
	ASPEED_PINCTRL_FUNC(USB2BD),
	ASPEED_PINCTRL_FUNC(USB2BH),
	ASPEED_PINCTRL_FUNC(VB),
	ASPEED_PINCTRL_FUNC(VGAHS),
	ASPEED_PINCTRL_FUNC(VGAVS),
	ASPEED_PINCTRL_FUNC(WDTRST1),
	ASPEED_PINCTRL_FUNC(WDTRST2),
	ASPEED_PINCTRL_FUNC(WDTRST3),
	ASPEED_PINCTRL_FUNC(WDTRST4),
};

static struct aspeed_pin_config aspeed_g6_configs[] = {
	/* GPIOB7 */
	ASPEED_PULL_DOWN_PINCONF(J24, SCU610, 15),
	/* GPIOB6 */
	ASPEED_PULL_DOWN_PINCONF(H25, SCU610, 14),
	/* GPIOB5 */
	ASPEED_PULL_DOWN_PINCONF(G26, SCU610, 13),
	/* GPIOB4 */
	ASPEED_PULL_DOWN_PINCONF(J23, SCU610, 12),
	/* GPIOB3 */
	ASPEED_PULL_DOWN_PINCONF(J25, SCU610, 11),
	/* GPIOB2 */
	ASPEED_PULL_DOWN_PINCONF(H26, SCU610, 10),
	/* GPIOB1 */
	ASPEED_PULL_DOWN_PINCONF(K23, SCU610, 9),
	/* GPIOB0 */
	ASPEED_PULL_DOWN_PINCONF(J26, SCU610, 8),

	/* GPIOH3 */
	ASPEED_PULL_DOWN_PINCONF(A17, SCU614, 27),
	/* GPIOH2 */
	ASPEED_PULL_DOWN_PINCONF(C18, SCU614, 26),
	/* GPIOH1 */
	ASPEED_PULL_DOWN_PINCONF(B18, SCU614, 25),
	/* GPIOH0 */
	ASPEED_PULL_DOWN_PINCONF(A18, SCU614, 24),

	/* GPIOL7 */
	ASPEED_PULL_DOWN_PINCONF(C14, SCU618, 31),
	/* GPIOL6 */
	ASPEED_PULL_DOWN_PINCONF(B14, SCU618, 30),
	/* GPIOL5 */
	ASPEED_PULL_DOWN_PINCONF(F15, SCU618, 29),
	/* GPIOL4 */
	ASPEED_PULL_DOWN_PINCONF(C15, SCU618, 28),

	/* GPIOJ7 */
	ASPEED_PULL_UP_PINCONF(D19, SCU618, 15),
	/* GPIOJ6 */
	ASPEED_PULL_UP_PINCONF(C20, SCU618, 14),
	/* GPIOJ5 */
	ASPEED_PULL_UP_PINCONF(A19, SCU618, 13),
	/* GPIOJ4 */
	ASPEED_PULL_UP_PINCONF(C19, SCU618, 12),
	/* GPIOJ3 */
	ASPEED_PULL_UP_PINCONF(D20, SCU618, 11),
	/* GPIOJ2 */
	ASPEED_PULL_UP_PINCONF(E19, SCU618, 10),
	/* GPIOJ1 */
	ASPEED_PULL_UP_PINCONF(A20, SCU618, 9),
	/* GPIOJ0 */
	ASPEED_PULL_UP_PINCONF(B20, SCU618, 8),

	/* GPIOI7 */
	ASPEED_PULL_DOWN_PINCONF(A15, SCU618, 7),
	/* GPIOI6 */
	ASPEED_PULL_DOWN_PINCONF(B16, SCU618, 6),
	/* GPIOI5 */
	ASPEED_PULL_DOWN_PINCONF(E16, SCU618, 5),
	/* GPIOI4 */
	ASPEED_PULL_DOWN_PINCONF(C16, SCU618, 4),
	/* GPIOI3 */
	ASPEED_PULL_DOWN_PINCONF(D16, SCU618, 3),
	/* GPIOI2 */
	ASPEED_PULL_DOWN_PINCONF(E17, SCU618, 2),
	/* GPIOI1 */
	ASPEED_PULL_DOWN_PINCONF(A16, SCU618, 1),
	/* GPIOI0 */
	ASPEED_PULL_DOWN_PINCONF(D17, SCU618, 0),

	/* GPIOP7 */
	ASPEED_PULL_DOWN_PINCONF(Y23, SCU61C, 31),
	/* GPIOP6 */
	ASPEED_PULL_DOWN_PINCONF(AB24, SCU61C, 30),
	/* GPIOP5 */
	ASPEED_PULL_DOWN_PINCONF(AB23, SCU61C, 29),
	/* GPIOP4 */
	ASPEED_PULL_DOWN_PINCONF(W23, SCU61C, 28),
	/* GPIOP3 */
	ASPEED_PULL_DOWN_PINCONF(AA24, SCU61C, 27),
	/* GPIOP2 */
	ASPEED_PULL_DOWN_PINCONF(AA23, SCU61C, 26),
	/* GPIOP1 */
	ASPEED_PULL_DOWN_PINCONF(W24, SCU61C, 25),
	/* GPIOP0 */
	ASPEED_PULL_DOWN_PINCONF(AB22, SCU61C, 24),

	/* GPIOO7 */
	ASPEED_PULL_DOWN_PINCONF(AC23, SCU61C, 23),
	/* GPIOO6 */
	ASPEED_PULL_DOWN_PINCONF(AC24, SCU61C, 22),
	/* GPIOO5 */
	ASPEED_PULL_DOWN_PINCONF(AC22, SCU61C, 21),
	/* GPIOO4 */
	ASPEED_PULL_DOWN_PINCONF(AD25, SCU61C, 20),
	/* GPIOO3 */
	ASPEED_PULL_DOWN_PINCONF(AD24, SCU61C, 19),
	/* GPIOO2 */
	ASPEED_PULL_DOWN_PINCONF(AD23, SCU61C, 18),
	/* GPIOO1 */
	ASPEED_PULL_DOWN_PINCONF(AD22, SCU61C, 17),
	/* GPIOO0 */
	ASPEED_PULL_DOWN_PINCONF(AD26, SCU61C, 16),

	/* GPION7 */
	ASPEED_PULL_DOWN_PINCONF(M26, SCU61C, 15),
	/* GPION6 */
	ASPEED_PULL_DOWN_PINCONF(N26, SCU61C, 14),
	/* GPION5 */
	ASPEED_PULL_DOWN_PINCONF(M23, SCU61C, 13),
	/* GPION4 */
	ASPEED_PULL_DOWN_PINCONF(P26, SCU61C, 12),
	/* GPION3 */
	ASPEED_PULL_DOWN_PINCONF(N24, SCU61C, 11),
	/* GPION2 */
	ASPEED_PULL_DOWN_PINCONF(N25, SCU61C, 10),
	/* GPION1 */
	ASPEED_PULL_DOWN_PINCONF(N23, SCU61C, 9),
	/* GPION0 */
	ASPEED_PULL_DOWN_PINCONF(P25, SCU61C, 8),

	/* GPIOM7 */
	ASPEED_PULL_DOWN_PINCONF(D13, SCU61C, 7),
	/* GPIOM6 */
	ASPEED_PULL_DOWN_PINCONF(C13, SCU61C, 6),
	/* GPIOM5 */
	ASPEED_PULL_DOWN_PINCONF(C12, SCU61C, 5),
	/* GPIOM4 */
	ASPEED_PULL_DOWN_PINCONF(B12, SCU61C, 4),
	/* GPIOM3 */
	ASPEED_PULL_DOWN_PINCONF(E14, SCU61C, 3),
	/* GPIOM2 */
	ASPEED_PULL_DOWN_PINCONF(A12, SCU61C, 2),
	/* GPIOM1 */
	ASPEED_PULL_DOWN_PINCONF(B13, SCU61C, 1),
	/* GPIOM0 */
	ASPEED_PULL_DOWN_PINCONF(D14, SCU61C, 0),

	/* GPIOS7 */
	ASPEED_PULL_DOWN_PINCONF(T24, SCU620, 23),
	/* GPIOS6 */
	ASPEED_PULL_DOWN_PINCONF(P23, SCU620, 22),
	/* GPIOS5 */
	ASPEED_PULL_DOWN_PINCONF(P24, SCU620, 21),
	/* GPIOS4 */
	ASPEED_PULL_DOWN_PINCONF(R26, SCU620, 20),
	/* GPIOS3*/
	ASPEED_PULL_DOWN_PINCONF(R24, SCU620, 19),
	/* GPIOS2 */
	ASPEED_PULL_DOWN_PINCONF(T26, SCU620, 18),
	/* GPIOS1 */
	ASPEED_PULL_DOWN_PINCONF(T25, SCU620, 17),
	/* GPIOS0 */
	ASPEED_PULL_DOWN_PINCONF(R23, SCU620, 16),

	/* GPIOR7 */
	ASPEED_PULL_DOWN_PINCONF(U26, SCU620, 15),
	/* GPIOR6 */
	ASPEED_PULL_DOWN_PINCONF(W26, SCU620, 14),
	/* GPIOR5 */
	ASPEED_PULL_DOWN_PINCONF(T23, SCU620, 13),
	/* GPIOR4 */
	ASPEED_PULL_DOWN_PINCONF(U25, SCU620, 12),
	/* GPIOR3*/
	ASPEED_PULL_DOWN_PINCONF(V26, SCU620, 11),
	/* GPIOR2 */
	ASPEED_PULL_DOWN_PINCONF(V24, SCU620, 10),
	/* GPIOR1 */
	ASPEED_PULL_DOWN_PINCONF(U24, SCU620, 9),
	/* GPIOR0 */
	ASPEED_PULL_DOWN_PINCONF(V25, SCU620, 8),

	/* GPIOX7 */
	ASPEED_PULL_DOWN_PINCONF(AB10, SCU634, 31),
	/* GPIOX6 */
	ASPEED_PULL_DOWN_PINCONF(AF9, SCU634, 30),
	/* GPIOX5 */
	ASPEED_PULL_DOWN_PINCONF(AD9, SCU634, 29),
	/* GPIOX4 */
	ASPEED_PULL_DOWN_PINCONF(AB9, SCU634, 28),
	/* GPIOX3*/
	ASPEED_PULL_DOWN_PINCONF(AF8, SCU634, 27),
	/* GPIOX2 */
	ASPEED_PULL_DOWN_PINCONF(AC9, SCU634, 26),
	/* GPIOX1 */
	ASPEED_PULL_DOWN_PINCONF(AA9, SCU634, 25),
	/* GPIOX0 */
	ASPEED_PULL_DOWN_PINCONF(AE8, SCU634, 24),

	/* GPIOV7 */
	ASPEED_PULL_DOWN_PINCONF(AF15, SCU634, 15),
	/* GPIOV6 */
	ASPEED_PULL_DOWN_PINCONF(AD15, SCU634, 14),
	/* GPIOV5 */
	ASPEED_PULL_DOWN_PINCONF(AE14, SCU634, 13),
	/* GPIOV4 */
	ASPEED_PULL_DOWN_PINCONF(AE15, SCU634, 12),
	/* GPIOV3*/
	ASPEED_PULL_DOWN_PINCONF(AC15, SCU634, 11),
	/* GPIOV2 */
	ASPEED_PULL_DOWN_PINCONF(AD14, SCU634, 10),
	/* GPIOV1 */
	ASPEED_PULL_DOWN_PINCONF(AF14, SCU634, 9),
	/* GPIOV0 */
	ASPEED_PULL_DOWN_PINCONF(AB15, SCU634, 8),

	/* GPIOZ7 */
	ASPEED_PULL_DOWN_PINCONF(AF10, SCU638, 15),
	/* GPIOZ6 */
	ASPEED_PULL_DOWN_PINCONF(AD11, SCU638, 14),
	/* GPIOZ5 */
	ASPEED_PULL_DOWN_PINCONF(AA11, SCU638, 13),
	/* GPIOZ4 */
	ASPEED_PULL_DOWN_PINCONF(AC11, SCU638, 12),
	/* GPIOZ3*/
	ASPEED_PULL_DOWN_PINCONF(AB11, SCU638, 11),

	/* GPIOZ1 */
	ASPEED_PULL_DOWN_PINCONF(AD10, SCU638, 9),
	/* GPIOZ0 */
	ASPEED_PULL_DOWN_PINCONF(AC10, SCU638, 8),

	/* GPIOY6 */
	ASPEED_PULL_DOWN_PINCONF(AC12, SCU638, 6),
	/* GPIOY5 */
	ASPEED_PULL_DOWN_PINCONF(AF12, SCU638, 5),
	/* GPIOY4 */
	ASPEED_PULL_DOWN_PINCONF(AE12, SCU638, 4),
	/* GPIOY3 */
	ASPEED_PULL_DOWN_PINCONF(AA12, SCU638, 3),
	/* GPIOY2 */
	ASPEED_PULL_DOWN_PINCONF(AE11, SCU638, 2),
	/* GPIOY1 */
	ASPEED_PULL_DOWN_PINCONF(AD12, SCU638, 1),
	/* GPIOY0 */
	ASPEED_PULL_DOWN_PINCONF(AF11, SCU638, 0),

	/* LAD3 */
	{ PIN_CONFIG_DRIVE_STRENGTH, { AC7, AC7 }, SCU454, GENMASK(31, 30)},
	/* LAD2 */
	{ PIN_CONFIG_DRIVE_STRENGTH, { AC8, AC8 }, SCU454, GENMASK(29, 28)},
	/* LAD1 */
	{ PIN_CONFIG_DRIVE_STRENGTH, { AB8, AB8 }, SCU454, GENMASK(27, 26)},
	/* LAD0 */
	{ PIN_CONFIG_DRIVE_STRENGTH, { AB7, AB7 }, SCU454, GENMASK(25, 24)},

	/* MAC3 */
	{ PIN_CONFIG_POWER_SOURCE,   { H24, E26 }, SCU458, BIT_MASK(4)},
	{ PIN_CONFIG_DRIVE_STRENGTH, { H24, E26 }, SCU458, GENMASK(1, 0)},
	/* MAC4 */
	{ PIN_CONFIG_POWER_SOURCE,   { F24, B24 }, SCU458, BIT_MASK(5)},
	{ PIN_CONFIG_DRIVE_STRENGTH, { F24, B24 }, SCU458, GENMASK(3, 2)},
};

/**
 * Configure a pin's signal by applying an expression's descriptor state for
 * all descriptors in the expression.
 *
 * @ctx: The pinmux context
 * @expr: The expression associated with the function whose signal is to be
 *        configured
 * @enable: true to enable an function's signal through a pin's signal
 *          expression, false to disable the function's signal
 *
 * Return: 0 if the expression is configured as requested and a negative error
 * code otherwise
 */
static int aspeed_g6_sig_expr_set(struct aspeed_pinmux_data *ctx,
				  const struct aspeed_sig_expr *expr,
				  bool enable)
{
	int ret;
	int i;

	for (i = 0; i < expr->ndescs; i++) {
		const struct aspeed_sig_desc *desc = &expr->descs[i];
		u32 pattern = enable ? desc->enable : desc->disable;
		u32 val = (pattern << __ffs(desc->mask));
		bool is_strap;

		if (!ctx->maps[desc->ip])
			return -ENODEV;

		WARN_ON(desc->ip != ASPEED_IP_SCU);
		is_strap = desc->reg == SCU500 || desc->reg == SCU510;

		if (is_strap) {
			/*
			 * The AST2600 has write protection mask registers for
			 * the hardware strapping in SCU508 and SCU518. Assume
			 * that if the platform doesn't want the strapping
			 * values changed that it has set the write mask.
			 *
			 * The strapping registers implement write-1-clear
			 * behaviour. SCU500 is paired with clear writes on
			 * SCU504, likewise SCU510 is paired with SCU514.
			 */
			u32 clear = ~val & desc->mask;
			u32 w1c = desc->reg + 4;

			if (clear)
				ret = regmap_update_bits(ctx->maps[desc->ip],
							 w1c, desc->mask,
							 clear);
		}

		ret = regmap_update_bits(ctx->maps[desc->ip], desc->reg,
					 desc->mask, val);
		if (ret)
			return ret;
	}

	ret = aspeed_sig_expr_eval(ctx, expr, enable);
	if (ret < 0)
		return ret;

	if (!ret)
		return -EPERM;
	return 0;
}

static const struct aspeed_pin_config_map aspeed_g6_pin_config_map[] = {
	{ PIN_CONFIG_BIAS_PULL_DOWN,  0,   1, BIT_MASK(0)},
	{ PIN_CONFIG_BIAS_PULL_DOWN, -1,   0, BIT_MASK(0)},
	{ PIN_CONFIG_BIAS_PULL_UP,    0,   1, BIT_MASK(0)},
	{ PIN_CONFIG_BIAS_PULL_UP,   -1,   0, BIT_MASK(0)},
	{ PIN_CONFIG_BIAS_DISABLE,   -1,   1, BIT_MASK(0)},
	{ PIN_CONFIG_DRIVE_STRENGTH,  4,   0, GENMASK(1, 0)},
	{ PIN_CONFIG_DRIVE_STRENGTH,  8,   1, GENMASK(1, 0)},
	{ PIN_CONFIG_DRIVE_STRENGTH, 12,   2, GENMASK(1, 0)},
	{ PIN_CONFIG_DRIVE_STRENGTH, 16,   3, GENMASK(1, 0)},
	{ PIN_CONFIG_POWER_SOURCE,   3300, 0, BIT_MASK(0)},
	{ PIN_CONFIG_POWER_SOURCE,   1800, 1, BIT_MASK(0)},
};

static const struct aspeed_pinmux_ops aspeed_g5_ops = {
	.set = aspeed_g6_sig_expr_set,
};

static struct aspeed_pinctrl_data aspeed_g6_pinctrl_data = {
	.pins = aspeed_g6_pins,
	.npins = ARRAY_SIZE(aspeed_g6_pins),
	.pinmux = {
		.ops = &aspeed_g5_ops,
		.groups = aspeed_g6_groups,
		.ngroups = ARRAY_SIZE(aspeed_g6_groups),
		.functions = aspeed_g6_functions,
		.nfunctions = ARRAY_SIZE(aspeed_g6_functions),
	},
	.configs = aspeed_g6_configs,
	.nconfigs = ARRAY_SIZE(aspeed_g6_configs),
	.confmaps = aspeed_g6_pin_config_map,
	.nconfmaps = ARRAY_SIZE(aspeed_g6_pin_config_map),
};

static const struct pinmux_ops aspeed_g6_pinmux_ops = {
	.get_functions_count = aspeed_pinmux_get_fn_count,
	.get_function_name = aspeed_pinmux_get_fn_name,
	.get_function_groups = aspeed_pinmux_get_fn_groups,
	.set_mux = aspeed_pinmux_set_mux,
	.gpio_request_enable = aspeed_gpio_request_enable,
	.strict = true,
};

static const struct pinctrl_ops aspeed_g6_pinctrl_ops = {
	.get_groups_count = aspeed_pinctrl_get_groups_count,
	.get_group_name = aspeed_pinctrl_get_group_name,
	.get_group_pins = aspeed_pinctrl_get_group_pins,
	.pin_dbg_show = aspeed_pinctrl_pin_dbg_show,
	.dt_node_to_map = pinconf_generic_dt_node_to_map_all,
	.dt_free_map = pinctrl_utils_free_map,
};

static const struct pinconf_ops aspeed_g6_conf_ops = {
	.is_generic = true,
	.pin_config_get = aspeed_pin_config_get,
	.pin_config_set = aspeed_pin_config_set,
	.pin_config_group_get = aspeed_pin_config_group_get,
	.pin_config_group_set = aspeed_pin_config_group_set,
};

static struct pinctrl_desc aspeed_g6_pinctrl_desc = {
	.name = "aspeed-g6-pinctrl",
	.pins = aspeed_g6_pins,
	.npins = ARRAY_SIZE(aspeed_g6_pins),
	.pctlops = &aspeed_g6_pinctrl_ops,
	.pmxops = &aspeed_g6_pinmux_ops,
	.confops = &aspeed_g6_conf_ops,
};

static int aspeed_g6_pinctrl_probe(struct platform_device *pdev)
{
	int i;

	for (i = 0; i < ARRAY_SIZE(aspeed_g6_pins); i++)
		aspeed_g6_pins[i].number = i;

	return aspeed_pinctrl_probe(pdev, &aspeed_g6_pinctrl_desc,
			&aspeed_g6_pinctrl_data);
}

static const struct of_device_id aspeed_g6_pinctrl_of_match[] = {
	{ .compatible = "aspeed,ast2600-pinctrl", },
	{ },
};

static struct platform_driver aspeed_g6_pinctrl_driver = {
	.probe = aspeed_g6_pinctrl_probe,
	.driver = {
		.name = "aspeed-g6-pinctrl",
		.of_match_table = aspeed_g6_pinctrl_of_match,
	},
};

static int aspeed_g6_pinctrl_init(void)
{
	return platform_driver_register(&aspeed_g6_pinctrl_driver);
}

arch_initcall(aspeed_g6_pinctrl_init);
