/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.common.junit4;

import org.apache.maven.surefire.common.junit4.JUnit4ProviderUtil;
import org.apache.maven.surefire.common.junit4.JUnit4Reflector;
import org.apache.maven.surefire.common.junit4.JUnit4StackTraceWriter;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.SimpleReportEntry;
import org.apache.maven.surefire.report.StackTraceWriter;
import org.apache.maven.surefire.testset.TestSetFailedException;
import org.apache.maven.surefire.util.internal.ClassMethod;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public class JUnit4RunListener
extends RunListener {
    protected final org.apache.maven.surefire.report.RunListener reporter;
    private final ThreadLocal<Boolean> failureFlag = new InheritableThreadLocal<Boolean>();

    public JUnit4RunListener(org.apache.maven.surefire.report.RunListener reporter) {
        this.reporter = reporter;
    }

    public void testIgnored(Description description) throws Exception {
        String reason = JUnit4Reflector.getAnnotatedIgnoreValue(description);
        ClassMethod classMethod = JUnit4ProviderUtil.toClassMethod(description);
        this.reporter.testSkipped((ReportEntry)SimpleReportEntry.ignored((String)classMethod.getClazz(), null, (String)classMethod.getMethod(), null, (String)reason));
    }

    public void testStarted(Description description) throws Exception {
        try {
            this.reporter.testStarting((ReportEntry)this.createReportEntry(description));
        }
        finally {
            this.failureFlag.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFailure(Failure failure) throws Exception {
        try {
            StackTraceWriter stackTrace = this.createStackTraceWriter(failure);
            ClassMethod classMethod = JUnit4ProviderUtil.toClassMethod(failure.getDescription());
            SimpleReportEntry report = SimpleReportEntry.withException((String)classMethod.getClazz(), null, (String)classMethod.getMethod(), null, (StackTraceWriter)stackTrace);
            if (failure.getException() instanceof AssertionError) {
                this.reporter.testFailed((ReportEntry)report);
            } else {
                this.reporter.testError((ReportEntry)report);
            }
        }
        finally {
            this.failureFlag.set(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAssumptionFailure(Failure failure) {
        try {
            Description desc = failure.getDescription();
            ClassMethod classMethod = JUnit4ProviderUtil.toClassMethod(desc);
            SimpleReportEntry report = SimpleReportEntry.assumption((String)classMethod.getClazz(), null, (String)classMethod.getMethod(), null, (String)failure.getMessage());
            this.reporter.testAssumptionFailure((ReportEntry)report);
        }
        finally {
            this.failureFlag.set(true);
        }
    }

    public void testFinished(Description description) throws Exception {
        Boolean failure = this.failureFlag.get();
        if (failure == null) {
            this.reporter.testSucceeded((ReportEntry)this.createReportEntry(description));
        }
    }

    public void testExecutionSkippedByUser() {
        this.reporter.testExecutionSkippedByUser();
    }

    protected StackTraceWriter createStackTraceWriter(Failure failure) {
        return new JUnit4StackTraceWriter(failure);
    }

    protected SimpleReportEntry createReportEntry(Description description) {
        ClassMethod classMethod = JUnit4ProviderUtil.toClassMethod(description);
        return new SimpleReportEntry(classMethod.getClazz(), null, classMethod.getMethod(), null);
    }

    public static void rethrowAnyTestMechanismFailures(Result run) throws TestSetFailedException {
        for (Failure failure : run.getFailures()) {
            if (!JUnit4ProviderUtil.isFailureInsideJUnitItself(failure.getDescription())) continue;
            throw new TestSetFailedException(failure.getTestHeader() + " :: " + failure.getMessage(), failure.getException());
        }
    }
}

