/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.internal.ProjectSegment;
import org.apache.maven.lifecycle.internal.TaskSegment;
import org.apache.maven.project.MavenProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectBuildList
implements Iterable<ProjectSegment> {
    private final List<ProjectSegment> items;

    public ProjectBuildList(List<ProjectSegment> items) {
        this.items = Collections.unmodifiableList(items);
    }

    public ProjectBuildList getByTaskSegment(TaskSegment taskSegment) {
        ArrayList<ProjectSegment> currentSegment = new ArrayList<ProjectSegment>();
        for (ProjectSegment projectBuild : this.items) {
            if (taskSegment != projectBuild.getTaskSegment()) continue;
            currentSegment.add(projectBuild);
        }
        return new ProjectBuildList(currentSegment);
    }

    public Map<MavenProject, ProjectSegment> selectSegment(TaskSegment taskSegment) {
        HashMap<MavenProject, ProjectSegment> result = new HashMap<MavenProject, ProjectSegment>();
        for (ProjectSegment projectBuild : this.items) {
            if (taskSegment != projectBuild.getTaskSegment()) continue;
            result.put(projectBuild.getProject(), projectBuild);
        }
        return result;
    }

    public ProjectSegment findByMavenProject(MavenProject mavenProject) {
        for (ProjectSegment projectBuild : this.items) {
            if (!mavenProject.equals(projectBuild.getProject())) continue;
            return projectBuild;
        }
        return null;
    }

    @Override
    public Iterator<ProjectSegment> iterator() {
        return this.items.iterator();
    }

    public void closeAll() {
        for (ProjectSegment item : this.items) {
            MavenSession sessionForThisModule = item.getSession();
            sessionForThisModule.setCurrentProject(null);
        }
    }

    public int size() {
        return this.items.size();
    }

    ProjectSegment get(int index) {
        return this.items.get(index);
    }

    public Set<String> getReactorProjectKeys() {
        HashSet<String> projectKeys = new HashSet<String>(this.items.size() * 2);
        for (ProjectSegment projectBuild : this.items) {
            MavenProject project = projectBuild.getProject();
            String key = ArtifactUtils.key((String)project.getGroupId(), (String)project.getArtifactId(), (String)project.getVersion());
            projectKeys.add(key);
        }
        return projectKeys;
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }
}

