/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.array.dyn;

import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.runtime.JSConfig;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.array.DynamicArray;
import com.oracle.truffle.js.runtime.array.ScriptArray;
import com.oracle.truffle.js.runtime.array.dyn.AbstractConstantArray;
import com.oracle.truffle.js.runtime.array.dyn.AbstractObjectArray;
import com.oracle.truffle.js.runtime.array.dyn.ZeroBasedObjectArray;
import com.oracle.truffle.js.runtime.builtins.JSAbstractArray;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.TRegexUtil;

public final class LazyRegexResultIndicesArray
extends AbstractConstantArray {
    public static final LazyRegexResultIndicesArray LAZY_REGEX_RESULT_INDICES_ARRAY = new LazyRegexResultIndicesArray(0, LazyRegexResultIndicesArray.createCache());

    public static LazyRegexResultIndicesArray createLazyRegexResultIndicesArray() {
        return LAZY_REGEX_RESULT_INDICES_ARRAY;
    }

    protected LazyRegexResultIndicesArray(int integrityLevel, DynamicArray.DynamicArrayCache cache) {
        super(integrityLevel, cache);
    }

    private static Object[] getArray(DynamicObject object, boolean condition) {
        return (Object[])JSAbstractArray.arrayGetArray(object, condition);
    }

    public static Object materializeGroup(JSContext context, TRegexUtil.TRegexResultAccessor resultAccessor, DynamicObject object, int index, boolean condition) {
        Object[] internalArray = LazyRegexResultIndicesArray.getArray(object, condition);
        if (internalArray[index] == null) {
            internalArray[index] = LazyRegexResultIndicesArray.getIntIndicesArray(context, resultAccessor, JSAbstractArray.arrayGetRegexResult(object, condition), index);
        }
        return internalArray[index];
    }

    public static Object getIntIndicesArray(JSContext context, TRegexUtil.TRegexResultAccessor resultAccessor, Object regexResult, int index) {
        int beginIndex = resultAccessor.captureGroupStart(regexResult, index);
        if (beginIndex == -1) {
            assert (index > 0);
            return Undefined.instance;
        }
        int[] intArray = new int[]{beginIndex, resultAccessor.captureGroupEnd(regexResult, index)};
        return JSArray.createConstantIntArray(context, intArray);
    }

    public ScriptArray createWritable(JSContext context, TRegexUtil.TRegexResultAccessor resultAccessor, DynamicObject object, long index, Object value, boolean condition) {
        boolean arrayTypeCondition = condition && JSAbstractArray.arrayGetArrayType(object, condition) instanceof LazyRegexResultIndicesArray;
        for (int i = 0; i < this.lengthInt(object); ++i) {
            LazyRegexResultIndicesArray.materializeGroup(context, resultAccessor, object, i, arrayTypeCondition);
        }
        Object[] internalArray = LazyRegexResultIndicesArray.getArray(object, condition);
        ZeroBasedObjectArray newArray = ZeroBasedObjectArray.makeZeroBasedObjectArray(object, internalArray.length, internalArray.length, internalArray, this.integrityLevel);
        if (JSConfig.TraceArrayTransitions) {
            LazyRegexResultIndicesArray.traceArrayTransition(this, newArray, index, value);
        }
        return newArray;
    }

    @Override
    public Object getElementInBounds(DynamicObject object, int index, boolean condition) {
        boolean arrayTypeCondition = condition && JSAbstractArray.arrayGetArrayType(object, condition) instanceof LazyRegexResultIndicesArray;
        return LazyRegexResultIndicesArray.materializeGroup(JavaScriptLanguage.getCurrentJSRealm().getContext(), TRegexUtil.TRegexResultAccessor.getUncached(), object, index, arrayTypeCondition);
    }

    @Override
    public boolean hasElement(DynamicObject object, long index, boolean condition) {
        return index >= 0L && index < (long)this.lengthInt(object, condition);
    }

    @Override
    public int lengthInt(DynamicObject object, boolean condition) {
        return (int)JSAbstractArray.arrayGetLength(object, condition);
    }

    @Override
    public AbstractObjectArray createWriteableObject(DynamicObject object, long index, Object value, boolean condition, ScriptArray.ProfileHolder profile) {
        Object[] array = LazyRegexResultIndicesArray.materializeFull(TRegexUtil.TRegexResultAccessor.getUncached(), object, this.lengthInt(object, condition));
        ZeroBasedObjectArray newArray = ZeroBasedObjectArray.makeZeroBasedObjectArray(object, array.length, array.length, array, this.integrityLevel);
        if (JSConfig.TraceArrayTransitions) {
            LazyRegexResultIndicesArray.traceArrayTransition(this, newArray, index, value);
        }
        return newArray;
    }

    @Override
    public AbstractObjectArray createWriteableInt(DynamicObject object, long index, int value, boolean condition, ScriptArray.ProfileHolder profile) {
        return this.createWriteableObject(object, index, value, condition, profile);
    }

    @Override
    public AbstractObjectArray createWriteableDouble(DynamicObject object, long index, double value, boolean condition, ScriptArray.ProfileHolder profile) {
        return this.createWriteableObject(object, index, value, condition, profile);
    }

    @Override
    public AbstractObjectArray createWriteableJSObject(DynamicObject object, long index, DynamicObject value, boolean condition, ScriptArray.ProfileHolder profile) {
        return this.createWriteableObject(object, index, value, condition, profile);
    }

    @Override
    public ScriptArray deleteElementImpl(DynamicObject object, long index, boolean strict, boolean condition) {
        return this.createWriteableObject(object, index, null, condition, ScriptArray.ProfileHolder.empty()).deleteElementImpl(object, index, strict, condition);
    }

    @Override
    public ScriptArray setLengthImpl(DynamicObject object, long length, boolean condition, ScriptArray.ProfileHolder profile) {
        return this.createWriteableObject(object, length - 1L, null, condition, ScriptArray.ProfileHolder.empty()).setLengthImpl(object, length, condition, profile);
    }

    @Override
    public ScriptArray addRangeImpl(DynamicObject object, long offset, int size) {
        return this.createWriteableObject(object, offset, null, JSArray.isJSArray(object), ScriptArray.ProfileHolder.empty()).addRangeImpl(object, offset, size);
    }

    @Override
    public ScriptArray removeRangeImpl(DynamicObject object, long start, long end) {
        return this.createWriteableObject(object, start, null, JSArray.isJSArray(object), ScriptArray.ProfileHolder.empty()).removeRangeImpl(object, start, end);
    }

    @Override
    public Object[] toArray(DynamicObject object) {
        return LazyRegexResultIndicesArray.materializeFull(TRegexUtil.TRegexResultAccessor.getUncached(), object, this.lengthInt(object));
    }

    @Override
    protected DynamicArray withIntegrityLevel(int newIntegrityLevel) {
        return new LazyRegexResultIndicesArray(newIntegrityLevel, this.cache);
    }

    protected static Object[] materializeFull(TRegexUtil.TRegexResultAccessor resultAccessor, DynamicObject object, int groupCount) {
        Object[] result = new Object[groupCount];
        boolean condition = JSAbstractArray.arrayGetArrayType(object) instanceof LazyRegexResultIndicesArray;
        for (int i = 0; i < groupCount; ++i) {
            result[i] = LazyRegexResultIndicesArray.materializeGroup(JavaScriptLanguage.getCurrentJSRealm().getContext(), resultAccessor, object, i, condition);
        }
        return result;
    }
}

