/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.treewalk.filter;

import java.io.IOException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.NotTreeFilter;

public abstract class TreeFilter {
    public static final TreeFilter ALL = new AllFilter();
    public static final TreeFilter ANY_DIFF = new AnyDiffFilter();

    public TreeFilter negate() {
        return NotTreeFilter.create(this);
    }

    public abstract boolean include(TreeWalk var1) throws MissingObjectException, IncorrectObjectTypeException, IOException;

    public abstract boolean shouldBeRecursive();

    public abstract TreeFilter clone();

    public String toString() {
        String n = this.getClass().getName();
        int lastDot = n.lastIndexOf(46);
        if (lastDot >= 0) {
            n = n.substring(lastDot + 1);
        }
        return n.replace('$', '.');
    }

    private static final class AllFilter
    extends TreeFilter {
        private AllFilter() {
        }

        @Override
        public boolean include(TreeWalk walker) {
            return true;
        }

        @Override
        public boolean shouldBeRecursive() {
            return false;
        }

        @Override
        public TreeFilter clone() {
            return this;
        }

        @Override
        public String toString() {
            return "ALL";
        }
    }

    private static final class AnyDiffFilter
    extends TreeFilter {
        private static final int baseTree = 0;

        private AnyDiffFilter() {
        }

        @Override
        public boolean include(TreeWalk walker) {
            int n = walker.getTreeCount();
            if (n == 1) {
                return true;
            }
            int m = walker.getRawMode(0);
            for (int i = 1; i < n; ++i) {
                if (walker.getRawMode(i) == m && walker.idEqual(i, 0)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean shouldBeRecursive() {
            return false;
        }

        @Override
        public TreeFilter clone() {
            return this;
        }

        @Override
        public String toString() {
            return "ANY_DIFF";
        }
    }
}

