/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.nodes.dfa;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.regex.tregex.nodes.dfa.DFAAbstractStateNode;
import com.oracle.truffle.regex.tregex.nodes.dfa.TRegexDFAExecutorLocals;
import com.oracle.truffle.regex.tregex.nodes.dfa.TRegexDFAExecutorNode;
import com.oracle.truffle.regex.tregex.util.json.Json;
import com.oracle.truffle.regex.tregex.util.json.JsonObject;
import com.oracle.truffle.regex.tregex.util.json.JsonValue;
import java.util.Arrays;

public class DFAInitialStateNode
extends DFAAbstractStateNode {
    private final boolean searching;
    private final boolean genericCG;

    public DFAInitialStateNode(short[] successors, boolean searching, boolean genericCG) {
        super((short)0, successors);
        this.searching = searching;
        this.genericCG = genericCG;
    }

    private DFAInitialStateNode(DFAInitialStateNode copy) {
        this(Arrays.copyOf(copy.successors, copy.successors.length), copy.searching, copy.genericCG);
    }

    public int getPrefixLength() {
        return this.successors.length / 2 - 1;
    }

    public boolean hasUnAnchoredEntry() {
        return this.successors[this.successors.length / 2] != -1;
    }

    @Override
    public DFAAbstractStateNode createNodeSplitCopy(short copyID) {
        return new DFAInitialStateNode(this);
    }

    @Override
    public void executeFindSuccessor(TRegexDFAExecutorLocals locals, TRegexDFAExecutorNode executor, boolean compactString) {
        if (this.searching) {
            locals.setSuccessorIndex(executor.rewindUpTo(locals, this.getPrefixLength()));
        } else {
            locals.setSuccessorIndex(Math.max(0, Math.min(this.getPrefixLength(), locals.getFromIndex() - locals.getIndex())));
        }
        if (!executor.atBegin(locals)) {
            locals.setSuccessorIndex(locals.getSuccessorIndex() + this.successors.length / 2);
        }
        if (this.genericCG) {
            locals.setLastTransition((short)0);
        }
        if (executor.recordExecution()) {
            executor.getDebugRecorder().setInitialIndex(locals.getIndex());
        }
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public JsonValue toJson() {
        return Json.obj(new JsonObject.JsonObjectProperty[0]);
    }
}

