/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.GlobalObjectNode;
import com.oracle.truffle.js.nodes.cast.JSPrepareThisNodeGen;
import com.oracle.truffle.js.nodes.unary.JSUnaryNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.JSBigInt;
import com.oracle.truffle.js.runtime.builtins.JSBoolean;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.builtins.JSNumber;
import com.oracle.truffle.js.runtime.builtins.JSString;
import com.oracle.truffle.js.runtime.builtins.JSSymbol;
import com.oracle.truffle.js.runtime.objects.JSLazyString;
import java.util.Set;

public abstract class JSPrepareThisNode
extends JSUnaryNode {
    final JSContext context;

    protected JSPrepareThisNode(JSContext context, JavaScriptNode child) {
        super(child);
        this.context = context;
    }

    public static JSPrepareThisNode createPrepareThisBinding(JSContext context, JavaScriptNode child) {
        return JSPrepareThisNodeGen.create(context, child);
    }

    @Specialization(guards={"isNullOrUndefined(object)"})
    protected DynamicObject doJSObject(Object object) {
        return GlobalObjectNode.getGlobalObject(this.context);
    }

    @Specialization(guards={"cachedClass != null", "cachedClass.isInstance(object)"}, limit="1")
    protected DynamicObject doJSObjectCached(DynamicObject object, @Cached(value="getJSClassIfObject(object)") JSClass cachedClass) {
        return object;
    }

    @Specialization(guards={"isJSObject(object)"}, replaces={"doJSObjectCached"})
    protected DynamicObject doJSObject(DynamicObject object) {
        return object;
    }

    @Specialization
    protected DynamicObject doBoolean(boolean value) {
        return JSBoolean.create(this.context, value);
    }

    @Specialization
    protected DynamicObject doJSLazyString(JSLazyString value) {
        return JSString.create(this.context, value);
    }

    @Specialization
    protected DynamicObject doString(String value) {
        return JSString.create(this.context, value);
    }

    @Specialization
    protected DynamicObject doInt(int value) {
        return JSNumber.create(this.context, value);
    }

    @Specialization
    protected DynamicObject doDouble(double value) {
        return JSNumber.create(this.context, value);
    }

    @Specialization
    protected DynamicObject doBigInt(BigInt value) {
        return JSBigInt.create(this.context, value);
    }

    @Specialization(guards={"isJavaNumber(value)"})
    protected DynamicObject doNumber(Object value) {
        return JSNumber.create(this.context, (Number)value);
    }

    @Specialization
    protected DynamicObject doSymbol(Symbol value) {
        return JSSymbol.create(this.context, value);
    }

    @Specialization(guards={"isForeignObject(object)"})
    protected Object doForeignObject(Object object) {
        return object;
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return JSPrepareThisNodeGen.create(this.context, JSPrepareThisNode.cloneUninitialized(this.getOperand(), materializedTags));
    }
}

