/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.common.junit4;

import org.apache.maven.surefire.common.junit4.JUnit4ProviderUtil;
import org.apache.maven.surefire.report.SafeThrowable;
import org.apache.maven.surefire.report.SmartStackTraceParser;
import org.apache.maven.surefire.report.StackTraceWriter;
import org.apache.maven.surefire.util.internal.ClassMethod;
import org.junit.runner.notification.Failure;

public class JUnit4StackTraceWriter
implements StackTraceWriter {
    private final Failure junitFailure;

    public JUnit4StackTraceWriter(Failure junitFailure) {
        this.junitFailure = junitFailure;
    }

    public String writeTraceToString() {
        Throwable t = this.junitFailure.getException();
        if (t != null) {
            String originalTrace = this.junitFailure.getTrace();
            if (JUnit4StackTraceWriter.isMultiLineExceptionMessage(t)) {
                StringBuilder builder = new StringBuilder(originalTrace);
                String exc = t.getClass().getName() + ": ";
                if (originalTrace.startsWith(exc)) {
                    builder.insert(exc.length(), '\n');
                }
                return builder.toString();
            }
            return originalTrace;
        }
        return "";
    }

    public String smartTrimmedStackTrace() {
        Throwable exception = this.junitFailure.getException();
        ClassMethod classMethod = JUnit4ProviderUtil.toClassMethod(this.junitFailure.getDescription());
        return exception == null ? this.junitFailure.getMessage() : new SmartStackTraceParser(classMethod.getClazz(), exception, classMethod.getMethod()).getString();
    }

    public String writeTrimmedTraceToString() {
        String testClass = JUnit4ProviderUtil.toClassMethod(this.junitFailure.getDescription()).getClazz();
        try {
            Throwable e = this.junitFailure.getException();
            return SmartStackTraceParser.stackTraceWithFocusOnClassAsString((Throwable)e, (String)testClass);
        }
        catch (Throwable t) {
            return SmartStackTraceParser.stackTraceWithFocusOnClassAsString((Throwable)t, (String)testClass);
        }
    }

    public SafeThrowable getThrowable() {
        return new SafeThrowable(this.junitFailure.getException());
    }

    private static boolean isMultiLineExceptionMessage(Throwable t) {
        String msg = t.getLocalizedMessage();
        if (msg != null) {
            int countNewLines = 0;
            int length = msg.length();
            for (int i = 0; i < length && (msg.charAt(i) != '\n' || ++countNewLines != 2); ++i) {
            }
            return countNewLines > 1 || countNewLines == 1 && !msg.trim().endsWith("\n");
        }
        return false;
    }
}

