/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.nodes.nfa;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.regex.RegexRootNode;
import com.oracle.truffle.regex.tregex.nfa.NFA;
import com.oracle.truffle.regex.tregex.nfa.NFAState;
import com.oracle.truffle.regex.tregex.nfa.NFAStateTransition;
import com.oracle.truffle.regex.tregex.nodes.TRegexExecutorLocals;
import com.oracle.truffle.regex.tregex.nodes.TRegexExecutorNode;
import com.oracle.truffle.regex.tregex.nodes.nfa.TRegexNFAExecutorLocals;

public class TRegexNFAExecutorNode
extends TRegexExecutorNode {
    private final NFA nfa;
    private final boolean searching;

    public TRegexNFAExecutorNode(NFA nfa) {
        this.nfa = nfa;
        nfa.setInitialLoopBack(false);
        this.searching = !nfa.getAst().getFlags().isSticky() && !nfa.getAst().getRoot().startsWithCaret();
        for (int i = 0; i < nfa.getNumberOfTransitions(); ++i) {
            if (nfa.getTransitions()[i] == null) continue;
            nfa.getTransitions()[i].getGroupBoundaries().materializeArrays();
        }
    }

    public NFA getNFA() {
        return this.nfa;
    }

    @Override
    public boolean writesCaptureGroups() {
        return true;
    }

    @Override
    public TRegexExecutorLocals createLocals(Object input, int fromIndex, int index, int maxIndex) {
        return new TRegexNFAExecutorLocals(input, fromIndex, index, maxIndex, this.getNumberOfCaptureGroups(), this.nfa.getNumberOfStates());
    }

    @Override
    public Object execute(TRegexExecutorLocals abstractLocals, boolean compactString) {
        TRegexNFAExecutorLocals locals = (TRegexNFAExecutorLocals)abstractLocals;
        CompilerDirectives.ensureVirtualized((Object)locals);
        int offset = Math.min(locals.getIndex(), this.nfa.getAnchoredEntry().length - 1);
        locals.setIndex(locals.getIndex() - offset);
        int anchoredInitialState = this.nfa.getAnchoredEntry()[offset].getTarget().getId();
        int unAnchoredInitialState = this.nfa.getUnAnchoredEntry()[offset].getTarget().getId();
        if (unAnchoredInitialState != anchoredInitialState && locals.getIndex() == 0) {
            locals.addInitialState(anchoredInitialState);
        }
        if (this.nfa.getState(unAnchoredInitialState) != null) {
            locals.addInitialState(unAnchoredInitialState);
        }
        if (locals.curStatesEmpty()) {
            return null;
        }
        while (true) {
            if (CompilerDirectives.inInterpreter()) {
                RegexRootNode.checkThreadInterrupted();
            }
            if (locals.getIndex() < this.getInputLength(locals)) {
                this.findNextStates(locals);
                if (locals.successorsEmpty() && (!this.searching || locals.hasResult())) {
                    return locals.getResult();
                }
            } else {
                this.findNextStatesAtEnd(locals);
                return locals.getResult();
            }
            locals.nextChar();
        }
    }

    private void findNextStates(TRegexNFAExecutorLocals locals) {
        char c = this.getChar(locals);
        while (locals.hasNext()) {
            this.expandState(locals, locals.next(), c, false);
            if (!locals.isResultPushed()) continue;
            return;
        }
        if (this.searching && !locals.hasResult() && locals.getIndex() >= locals.getFromIndex()) {
            this.expandState(locals, this.nfa.getInitialLoopBackTransition().getTarget().getId(), c, true);
        }
    }

    private void expandState(TRegexNFAExecutorLocals locals, int stateId, char c, boolean isLoopBack) {
        NFAState state = this.nfa.getState(stateId);
        for (int i = 0; i < TRegexNFAExecutorNode.maxTransitionIndex(state); ++i) {
            NFAStateTransition t = ((NFAStateTransition[])state.getSuccessors())[i];
            NFAState target = t.getTarget();
            int targetId = t.getTarget().getId();
            int markIndex = targetId >> 6;
            long markBit = 1L << targetId;
            if (t.getTarget().isAnchoredFinalState(true) || (locals.getMarks()[markIndex] & markBit) != 0L) continue;
            long[] lArray = locals.getMarks();
            int n = markIndex;
            lArray[n] = lArray[n] | markBit;
            if (t.getTarget().isUnAnchoredFinalState(true)) {
                locals.pushResult(t, !isLoopBack);
                continue;
            }
            if (!target.getCharSet().contains(c)) continue;
            locals.pushSuccessor(t, !isLoopBack);
        }
    }

    private static int maxTransitionIndex(NFAState state) {
        return state.hasTransitionToUnAnchoredFinalState(true) ? state.getTransitionToUnAnchoredFinalStateId(true) + 1 : ((NFAStateTransition[])state.getSuccessors()).length;
    }

    private void findNextStatesAtEnd(TRegexNFAExecutorLocals locals) {
        while (locals.hasNext()) {
            TRegexNFAExecutorNode.expandStateAtEnd(locals, this.nfa.getState(locals.next()), false);
            if (!locals.isResultPushed()) continue;
            return;
        }
        if (this.searching && !locals.hasResult()) {
            TRegexNFAExecutorNode.expandStateAtEnd(locals, this.nfa.getInitialLoopBackTransition().getTarget(), true);
        }
    }

    private static void expandStateAtEnd(TRegexNFAExecutorLocals locals, NFAState state, boolean isLoopBack) {
        if (state.hasTransitionToFinalState(true)) {
            locals.pushResult(state.getFirstTransitionToFinalState(true), !isLoopBack);
        }
    }
}

