/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.matchers;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.regex.charset.CP16BitMatchers;
import com.oracle.truffle.regex.tregex.matchers.InvertibleCharMatcher;
import com.oracle.truffle.regex.tregex.matchers.RangeListMatcherNodeGen;

public abstract class RangeListMatcher
extends InvertibleCharMatcher {
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final char[] ranges;

    RangeListMatcher(boolean invert, char[] ranges) {
        super(invert);
        this.ranges = ranges;
    }

    public static RangeListMatcher create(boolean invert, char[] ranges) {
        return RangeListMatcherNodeGen.create(invert, ranges);
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL)
    @Specialization
    public boolean match(char c, boolean compactString) {
        for (int i = 0; i < this.ranges.length; i += 2) {
            char lo = this.ranges[i];
            char hi = this.ranges[i + 1];
            if (compactString && lo > '\u00ff') {
                return this.result(false);
            }
            if (RangeListMatcher.isSingleChar(lo, hi)) {
                if (lo != c) continue;
                return this.result(true);
            }
            if (RangeListMatcher.isTwoChars(lo, hi)) {
                if (c != lo && c != hi) continue;
                return this.result(true);
            }
            if (lo <= c) {
                if (hi < c) continue;
                return this.result(true);
            }
            return this.result(false);
        }
        return this.result(false);
    }

    private static boolean isSingleChar(char lo, char hi) {
        CompilerAsserts.partialEvaluationConstant((int)lo);
        CompilerAsserts.partialEvaluationConstant((int)hi);
        return lo == hi;
    }

    private static boolean isTwoChars(char lo, char hi) {
        CompilerAsserts.partialEvaluationConstant((int)lo);
        CompilerAsserts.partialEvaluationConstant((int)hi);
        return lo + '\u0001' == hi;
    }

    @Override
    public int estimatedCost() {
        return this.ranges.length;
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        return "list " + this.modifiersToString() + "[" + CP16BitMatchers.rangesToString(this.ranges) + "]";
    }
}

